# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFsuCycleResult',
    'AwaitableGetFsuCycleResult',
    'get_fsu_cycle',
    'get_fsu_cycle_output',
]

@pulumi.output_type
class GetFsuCycleResult:
    """
    A collection of values returned by getFsuCycle.
    """
    def __init__(__self__, apply_action_schedules=None, batching_strategies=None, collection_type=None, compartment_id=None, defined_tags=None, diagnostics_collections=None, display_name=None, executing_fsu_action_id=None, freeform_tags=None, fsu_collection_id=None, fsu_cycle_id=None, goal_version_details=None, id=None, is_ignore_missing_patches=None, is_ignore_patches=None, is_keep_placement=None, last_completed_action=None, last_completed_action_id=None, lifecycle_details=None, max_drain_timeout_in_seconds=None, next_action_to_executes=None, rollback_cycle_state=None, stage_action_schedules=None, state=None, system_tags=None, time_created=None, time_finished=None, time_updated=None, type=None, upgrade_details=None):
        if apply_action_schedules and not isinstance(apply_action_schedules, list):
            raise TypeError("Expected argument 'apply_action_schedules' to be a list")
        pulumi.set(__self__, "apply_action_schedules", apply_action_schedules)
        if batching_strategies and not isinstance(batching_strategies, list):
            raise TypeError("Expected argument 'batching_strategies' to be a list")
        pulumi.set(__self__, "batching_strategies", batching_strategies)
        if collection_type and not isinstance(collection_type, str):
            raise TypeError("Expected argument 'collection_type' to be a str")
        pulumi.set(__self__, "collection_type", collection_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if diagnostics_collections and not isinstance(diagnostics_collections, list):
            raise TypeError("Expected argument 'diagnostics_collections' to be a list")
        pulumi.set(__self__, "diagnostics_collections", diagnostics_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if executing_fsu_action_id and not isinstance(executing_fsu_action_id, str):
            raise TypeError("Expected argument 'executing_fsu_action_id' to be a str")
        pulumi.set(__self__, "executing_fsu_action_id", executing_fsu_action_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if fsu_collection_id and not isinstance(fsu_collection_id, str):
            raise TypeError("Expected argument 'fsu_collection_id' to be a str")
        pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        if fsu_cycle_id and not isinstance(fsu_cycle_id, str):
            raise TypeError("Expected argument 'fsu_cycle_id' to be a str")
        pulumi.set(__self__, "fsu_cycle_id", fsu_cycle_id)
        if goal_version_details and not isinstance(goal_version_details, list):
            raise TypeError("Expected argument 'goal_version_details' to be a list")
        pulumi.set(__self__, "goal_version_details", goal_version_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_ignore_missing_patches and not isinstance(is_ignore_missing_patches, list):
            raise TypeError("Expected argument 'is_ignore_missing_patches' to be a list")
        pulumi.set(__self__, "is_ignore_missing_patches", is_ignore_missing_patches)
        if is_ignore_patches and not isinstance(is_ignore_patches, bool):
            raise TypeError("Expected argument 'is_ignore_patches' to be a bool")
        pulumi.set(__self__, "is_ignore_patches", is_ignore_patches)
        if is_keep_placement and not isinstance(is_keep_placement, bool):
            raise TypeError("Expected argument 'is_keep_placement' to be a bool")
        pulumi.set(__self__, "is_keep_placement", is_keep_placement)
        if last_completed_action and not isinstance(last_completed_action, str):
            raise TypeError("Expected argument 'last_completed_action' to be a str")
        pulumi.set(__self__, "last_completed_action", last_completed_action)
        if last_completed_action_id and not isinstance(last_completed_action_id, str):
            raise TypeError("Expected argument 'last_completed_action_id' to be a str")
        pulumi.set(__self__, "last_completed_action_id", last_completed_action_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_drain_timeout_in_seconds and not isinstance(max_drain_timeout_in_seconds, int):
            raise TypeError("Expected argument 'max_drain_timeout_in_seconds' to be a int")
        pulumi.set(__self__, "max_drain_timeout_in_seconds", max_drain_timeout_in_seconds)
        if next_action_to_executes and not isinstance(next_action_to_executes, list):
            raise TypeError("Expected argument 'next_action_to_executes' to be a list")
        pulumi.set(__self__, "next_action_to_executes", next_action_to_executes)
        if rollback_cycle_state and not isinstance(rollback_cycle_state, str):
            raise TypeError("Expected argument 'rollback_cycle_state' to be a str")
        pulumi.set(__self__, "rollback_cycle_state", rollback_cycle_state)
        if stage_action_schedules and not isinstance(stage_action_schedules, list):
            raise TypeError("Expected argument 'stage_action_schedules' to be a list")
        pulumi.set(__self__, "stage_action_schedules", stage_action_schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if upgrade_details and not isinstance(upgrade_details, list):
            raise TypeError("Expected argument 'upgrade_details' to be a list")
        pulumi.set(__self__, "upgrade_details", upgrade_details)

    @_builtins.property
    @pulumi.getter(name="applyActionSchedules")
    def apply_action_schedules(self) -> Sequence['outputs.GetFsuCycleApplyActionScheduleResult']:
        """
        Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "apply_action_schedules")

    @_builtins.property
    @pulumi.getter(name="batchingStrategies")
    def batching_strategies(self) -> Sequence['outputs.GetFsuCycleBatchingStrategyResult']:
        """
        Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        """
        return pulumi.get(self, "batching_strategies")

    @_builtins.property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> _builtins.str:
        """
        Type of Exadata Fleet Update collection being upgraded.
        """
        return pulumi.get(self, "collection_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="diagnosticsCollections")
    def diagnostics_collections(self) -> Sequence['outputs.GetFsuCycleDiagnosticsCollectionResult']:
        """
        Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        """
        return pulumi.get(self, "diagnostics_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executingFsuActionId")
    def executing_fsu_action_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Action that is currently in progress, if applicable.
        """
        return pulumi.get(self, "executing_fsu_action_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Collection being updated by this Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "fsu_collection_id")

    @_builtins.property
    @pulumi.getter(name="fsuCycleId")
    def fsu_cycle_id(self) -> _builtins.str:
        return pulumi.get(self, "fsu_cycle_id")

    @_builtins.property
    @pulumi.getter(name="goalVersionDetails")
    def goal_version_details(self) -> Sequence['outputs.GetFsuCycleGoalVersionDetailResult']:
        """
        Details of goal 'GUEST_OS' software version.
        """
        return pulumi.get(self, "goal_version_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isIgnoreMissingPatches")
    def is_ignore_missing_patches(self) -> Sequence[_builtins.str]:
        """
        List of identifiers of patches to ignore. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_missing_patches")

    @_builtins.property
    @pulumi.getter(name="isIgnorePatches")
    def is_ignore_patches(self) -> _builtins.bool:
        """
        Ignore patch conflicts or missing patches between the source and goal homes. This attribute will be ignored for Exadata Image (Guest OS) maintenance update.
        """
        return pulumi.get(self, "is_ignore_patches")

    @_builtins.property
    @pulumi.getter(name="isKeepPlacement")
    def is_keep_placement(self) -> _builtins.bool:
        """
        Ensure that database services are online on the same VMs before and after the maintenance update.
        """
        return pulumi.get(self, "is_keep_placement")

    @_builtins.property
    @pulumi.getter(name="lastCompletedAction")
    def last_completed_action(self) -> _builtins.str:
        """
        The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        """
        return pulumi.get(self, "last_completed_action")

    @_builtins.property
    @pulumi.getter(name="lastCompletedActionId")
    def last_completed_action_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "last_completed_action_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxDrainTimeoutInSeconds")
    def max_drain_timeout_in_seconds(self) -> _builtins.int:
        """
        Service drain timeout specified in seconds.
        """
        return pulumi.get(self, "max_drain_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="nextActionToExecutes")
    def next_action_to_executes(self) -> Sequence['outputs.GetFsuCycleNextActionToExecuteResult']:
        """
        All possible Exadata Fleet Update Actions will be listed. The first element is the suggested Exadata Fleet Update Action.
        """
        return pulumi.get(self, "next_action_to_executes")

    @_builtins.property
    @pulumi.getter(name="rollbackCycleState")
    def rollback_cycle_state(self) -> _builtins.str:
        """
        Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        """
        return pulumi.get(self, "rollback_cycle_state")

    @_builtins.property
    @pulumi.getter(name="stageActionSchedules")
    def stage_action_schedules(self) -> Sequence['outputs.GetFsuCycleStageActionScheduleResult']:
        """
        Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "stage_action_schedules")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Sequence['outputs.GetFsuCycleUpgradeDetailResult']:
        """
        Details of supported upgrade options for DB or GI collection.
        """
        return pulumi.get(self, "upgrade_details")


class AwaitableGetFsuCycleResult(GetFsuCycleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFsuCycleResult(
            apply_action_schedules=self.apply_action_schedules,
            batching_strategies=self.batching_strategies,
            collection_type=self.collection_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            diagnostics_collections=self.diagnostics_collections,
            display_name=self.display_name,
            executing_fsu_action_id=self.executing_fsu_action_id,
            freeform_tags=self.freeform_tags,
            fsu_collection_id=self.fsu_collection_id,
            fsu_cycle_id=self.fsu_cycle_id,
            goal_version_details=self.goal_version_details,
            id=self.id,
            is_ignore_missing_patches=self.is_ignore_missing_patches,
            is_ignore_patches=self.is_ignore_patches,
            is_keep_placement=self.is_keep_placement,
            last_completed_action=self.last_completed_action,
            last_completed_action_id=self.last_completed_action_id,
            lifecycle_details=self.lifecycle_details,
            max_drain_timeout_in_seconds=self.max_drain_timeout_in_seconds,
            next_action_to_executes=self.next_action_to_executes,
            rollback_cycle_state=self.rollback_cycle_state,
            stage_action_schedules=self.stage_action_schedules,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_updated=self.time_updated,
            type=self.type,
            upgrade_details=self.upgrade_details)


def get_fsu_cycle(fsu_cycle_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFsuCycleResult:
    """
    This data source provides details about a specific Fsu Cycle resource in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a Exadata Fleet Update Cycle by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_cycle = oci.FleetSoftwareUpdate.get_fsu_cycle(fsu_cycle_id=test_fsu_cycle_oci_fleet_software_update_fsu_cycle["id"])
    ```


    :param _builtins.str fsu_cycle_id: Unique Exadata Fleet Update Cycle identifier.
    """
    __args__ = dict()
    __args__['fsuCycleId'] = fsu_cycle_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetSoftwareUpdate/getFsuCycle:getFsuCycle', __args__, opts=opts, typ=GetFsuCycleResult).value

    return AwaitableGetFsuCycleResult(
        apply_action_schedules=pulumi.get(__ret__, 'apply_action_schedules'),
        batching_strategies=pulumi.get(__ret__, 'batching_strategies'),
        collection_type=pulumi.get(__ret__, 'collection_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        diagnostics_collections=pulumi.get(__ret__, 'diagnostics_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        executing_fsu_action_id=pulumi.get(__ret__, 'executing_fsu_action_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        fsu_collection_id=pulumi.get(__ret__, 'fsu_collection_id'),
        fsu_cycle_id=pulumi.get(__ret__, 'fsu_cycle_id'),
        goal_version_details=pulumi.get(__ret__, 'goal_version_details'),
        id=pulumi.get(__ret__, 'id'),
        is_ignore_missing_patches=pulumi.get(__ret__, 'is_ignore_missing_patches'),
        is_ignore_patches=pulumi.get(__ret__, 'is_ignore_patches'),
        is_keep_placement=pulumi.get(__ret__, 'is_keep_placement'),
        last_completed_action=pulumi.get(__ret__, 'last_completed_action'),
        last_completed_action_id=pulumi.get(__ret__, 'last_completed_action_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        max_drain_timeout_in_seconds=pulumi.get(__ret__, 'max_drain_timeout_in_seconds'),
        next_action_to_executes=pulumi.get(__ret__, 'next_action_to_executes'),
        rollback_cycle_state=pulumi.get(__ret__, 'rollback_cycle_state'),
        stage_action_schedules=pulumi.get(__ret__, 'stage_action_schedules'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        upgrade_details=pulumi.get(__ret__, 'upgrade_details'))
def get_fsu_cycle_output(fsu_cycle_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFsuCycleResult]:
    """
    This data source provides details about a specific Fsu Cycle resource in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a Exadata Fleet Update Cycle by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_cycle = oci.FleetSoftwareUpdate.get_fsu_cycle(fsu_cycle_id=test_fsu_cycle_oci_fleet_software_update_fsu_cycle["id"])
    ```


    :param _builtins.str fsu_cycle_id: Unique Exadata Fleet Update Cycle identifier.
    """
    __args__ = dict()
    __args__['fsuCycleId'] = fsu_cycle_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetSoftwareUpdate/getFsuCycle:getFsuCycle', __args__, opts=opts, typ=GetFsuCycleResult)
    return __ret__.apply(lambda __response__: GetFsuCycleResult(
        apply_action_schedules=pulumi.get(__response__, 'apply_action_schedules'),
        batching_strategies=pulumi.get(__response__, 'batching_strategies'),
        collection_type=pulumi.get(__response__, 'collection_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        diagnostics_collections=pulumi.get(__response__, 'diagnostics_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        executing_fsu_action_id=pulumi.get(__response__, 'executing_fsu_action_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        fsu_collection_id=pulumi.get(__response__, 'fsu_collection_id'),
        fsu_cycle_id=pulumi.get(__response__, 'fsu_cycle_id'),
        goal_version_details=pulumi.get(__response__, 'goal_version_details'),
        id=pulumi.get(__response__, 'id'),
        is_ignore_missing_patches=pulumi.get(__response__, 'is_ignore_missing_patches'),
        is_ignore_patches=pulumi.get(__response__, 'is_ignore_patches'),
        is_keep_placement=pulumi.get(__response__, 'is_keep_placement'),
        last_completed_action=pulumi.get(__response__, 'last_completed_action'),
        last_completed_action_id=pulumi.get(__response__, 'last_completed_action_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        max_drain_timeout_in_seconds=pulumi.get(__response__, 'max_drain_timeout_in_seconds'),
        next_action_to_executes=pulumi.get(__response__, 'next_action_to_executes'),
        rollback_cycle_state=pulumi.get(__response__, 'rollback_cycle_state'),
        stage_action_schedules=pulumi.get(__response__, 'stage_action_schedules'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        upgrade_details=pulumi.get(__response__, 'upgrade_details')))
