# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 memory_in_mbs: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detached_mode_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 failure_destination: Optional[pulumi.Input['FunctionFailureDestinationArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 image_digest: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']] = None,
                 source_details: Optional[pulumi.Input['FunctionSourceDetailsArgs']] = None,
                 success_destination: Optional[pulumi.Input['FunctionSuccessDestinationArgs']] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_config: Optional[pulumi.Input['FunctionTraceConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[_builtins.str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[_builtins.str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] detached_mode_timeout_in_seconds: (Updatable) Timeout for detached function invocations. Value in seconds.
        :param pulumi.Input['FunctionFailureDestinationArgs'] failure_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[_builtins.str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input['FunctionProvisionedConcurrencyConfigArgs'] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input['FunctionSourceDetailsArgs'] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input['FunctionSuccessDestinationArgs'] success_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input['FunctionTraceConfigArgs'] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detached_mode_timeout_in_seconds is not None:
            pulumi.set(__self__, "detached_mode_timeout_in_seconds", detached_mode_timeout_in_seconds)
        if failure_destination is not None:
            pulumi.set(__self__, "failure_destination", failure_destination)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if provisioned_concurrency_config is not None:
            pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if success_destination is not None:
            pulumi.set(__self__, "success_destination", success_destination)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if trace_config is not None:
            pulumi.set(__self__, "trace_config", trace_config)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "memory_in_mbs", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="detachedModeTimeoutInSeconds")
    def detached_mode_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for detached function invocations. Value in seconds.
        """
        return pulumi.get(self, "detached_mode_timeout_in_seconds")

    @detached_mode_timeout_in_seconds.setter
    def detached_mode_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "detached_mode_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="failureDestination")
    def failure_destination(self) -> Optional[pulumi.Input['FunctionFailureDestinationArgs']]:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        """
        return pulumi.get(self, "failure_destination")

    @failure_destination.setter
    def failure_destination(self, value: Optional[pulumi.Input['FunctionFailureDestinationArgs']]):
        pulumi.set(self, "failure_destination", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @image_digest.setter
    def image_digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_digest", value)

    @_builtins.property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @provisioned_concurrency_config.setter
    def provisioned_concurrency_config(self, value: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]):
        pulumi.set(self, "provisioned_concurrency_config", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['FunctionSourceDetailsArgs']]:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['FunctionSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter(name="successDestination")
    def success_destination(self) -> Optional[pulumi.Input['FunctionSuccessDestinationArgs']]:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        """
        return pulumi.get(self, "success_destination")

    @success_destination.setter
    def success_destination(self, value: Optional[pulumi.Input['FunctionSuccessDestinationArgs']]):
        pulumi.set(self, "success_destination", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> Optional[pulumi.Input['FunctionTraceConfigArgs']]:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

    @trace_config.setter
    def trace_config(self, value: Optional[pulumi.Input['FunctionTraceConfigArgs']]):
        pulumi.set(self, "trace_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detached_mode_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_destination: Optional[pulumi.Input['FunctionFailureDestinationArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 image_digest: Optional[pulumi.Input[_builtins.str]] = None,
                 invoke_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input['FunctionSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 success_destination: Optional[pulumi.Input['FunctionSuccessDestinationArgs']] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_config: Optional[pulumi.Input['FunctionTraceConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[_builtins.str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] detached_mode_timeout_in_seconds: (Updatable) Timeout for detached function invocations. Value in seconds.
        :param pulumi.Input[_builtins.str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input['FunctionFailureDestinationArgs'] failure_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[_builtins.str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[_builtins.str] invoke_endpoint: The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        :param pulumi.Input[_builtins.str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input['FunctionProvisionedConcurrencyConfigArgs'] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[_builtins.str] shape: The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        :param pulumi.Input['FunctionSourceDetailsArgs'] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[_builtins.str] state: The current state of the function.
        :param pulumi.Input['FunctionSuccessDestinationArgs'] success_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        :param pulumi.Input[_builtins.str] time_created: The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input['FunctionTraceConfigArgs'] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detached_mode_timeout_in_seconds is not None:
            pulumi.set(__self__, "detached_mode_timeout_in_seconds", detached_mode_timeout_in_seconds)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if failure_destination is not None:
            pulumi.set(__self__, "failure_destination", failure_destination)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if invoke_endpoint is not None:
            pulumi.set(__self__, "invoke_endpoint", invoke_endpoint)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if provisioned_concurrency_config is not None:
            pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if success_destination is not None:
            pulumi.set(__self__, "success_destination", success_destination)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if trace_config is not None:
            pulumi.set(__self__, "trace_config", trace_config)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment that contains the function.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="detachedModeTimeoutInSeconds")
    def detached_mode_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for detached function invocations. Value in seconds.
        """
        return pulumi.get(self, "detached_mode_timeout_in_seconds")

    @detached_mode_timeout_in_seconds.setter
    def detached_mode_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "detached_mode_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="failureDestination")
    def failure_destination(self) -> Optional[pulumi.Input['FunctionFailureDestinationArgs']]:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        """
        return pulumi.get(self, "failure_destination")

    @failure_destination.setter
    def failure_destination(self, value: Optional[pulumi.Input['FunctionFailureDestinationArgs']]):
        pulumi.set(self, "failure_destination", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @image_digest.setter
    def image_digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_digest", value)

    @_builtins.property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        """
        return pulumi.get(self, "invoke_endpoint")

    @invoke_endpoint.setter
    def invoke_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invoke_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_in_mbs", value)

    @_builtins.property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @provisioned_concurrency_config.setter
    def provisioned_concurrency_config(self, value: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]):
        pulumi.set(self, "provisioned_concurrency_config", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['FunctionSourceDetailsArgs']]:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['FunctionSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the function.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="successDestination")
    def success_destination(self) -> Optional[pulumi.Input['FunctionSuccessDestinationArgs']]:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        """
        return pulumi.get(self, "success_destination")

    @success_destination.setter
    def success_destination(self, value: Optional[pulumi.Input['FunctionSuccessDestinationArgs']]):
        pulumi.set(self, "success_destination", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> Optional[pulumi.Input['FunctionTraceConfigArgs']]:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

    @trace_config.setter
    def trace_config(self, value: Optional[pulumi.Input['FunctionTraceConfigArgs']]):
        pulumi.set(self, "trace_config", value)


@pulumi.type_token("oci:Functions/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detached_mode_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_destination: Optional[pulumi.Input[Union['FunctionFailureDestinationArgs', 'FunctionFailureDestinationArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 image_digest: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[Union['FunctionProvisionedConcurrencyConfigArgs', 'FunctionProvisionedConcurrencyConfigArgsDict']]] = None,
                 source_details: Optional[pulumi.Input[Union['FunctionSourceDetailsArgs', 'FunctionSourceDetailsArgsDict']]] = None,
                 success_destination: Optional[pulumi.Input[Union['FunctionSuccessDestinationArgs', 'FunctionSuccessDestinationArgsDict']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_config: Optional[pulumi.Input[Union['FunctionTraceConfigArgs', 'FunctionTraceConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_function = oci.functions.Function("test_function",
            application_id=test_application["id"],
            display_name=function_display_name,
            memory_in_mbs=function_memory_in_mbs,
            config=function_config,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            detached_mode_timeout_in_seconds=function_detached_mode_timeout_in_seconds,
            failure_destination={
                "kind": function_failure_destination_kind,
                "channel_id": test_channel["id"],
                "queue_id": test_queue["id"],
                "stream_id": test_stream["id"],
                "topic_id": test_notification_topic["id"],
            },
            freeform_tags={
                "Department": "Finance",
            },
            image=function_image,
            image_digest=function_image_digest,
            provisioned_concurrency_config={
                "strategy": function_provisioned_concurrency_config_strategy,
                "count": function_provisioned_concurrency_config_count,
            },
            source_details={
                "pbf_listing_id": test_pbf_listing["id"],
                "source_type": function_source_details_source_type,
            },
            success_destination={
                "kind": function_success_destination_kind,
                "channel_id": test_channel["id"],
                "queue_id": test_queue["id"],
                "stream_id": test_stream["id"],
                "topic_id": test_notification_topic["id"],
            },
            timeout_in_seconds=function_timeout_in_seconds,
            trace_config={
                "is_enabled": function_trace_config_is_enabled,
            })
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Functions/function:Function test_function "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] detached_mode_timeout_in_seconds: (Updatable) Timeout for detached function invocations. Value in seconds.
        :param pulumi.Input[_builtins.str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[Union['FunctionFailureDestinationArgs', 'FunctionFailureDestinationArgsDict']] failure_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[_builtins.str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[_builtins.str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[Union['FunctionProvisionedConcurrencyConfigArgs', 'FunctionProvisionedConcurrencyConfigArgsDict']] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[Union['FunctionSourceDetailsArgs', 'FunctionSourceDetailsArgsDict']] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[Union['FunctionSuccessDestinationArgs', 'FunctionSuccessDestinationArgsDict']] success_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input[Union['FunctionTraceConfigArgs', 'FunctionTraceConfigArgsDict']] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_function = oci.functions.Function("test_function",
            application_id=test_application["id"],
            display_name=function_display_name,
            memory_in_mbs=function_memory_in_mbs,
            config=function_config,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            detached_mode_timeout_in_seconds=function_detached_mode_timeout_in_seconds,
            failure_destination={
                "kind": function_failure_destination_kind,
                "channel_id": test_channel["id"],
                "queue_id": test_queue["id"],
                "stream_id": test_stream["id"],
                "topic_id": test_notification_topic["id"],
            },
            freeform_tags={
                "Department": "Finance",
            },
            image=function_image,
            image_digest=function_image_digest,
            provisioned_concurrency_config={
                "strategy": function_provisioned_concurrency_config_strategy,
                "count": function_provisioned_concurrency_config_count,
            },
            source_details={
                "pbf_listing_id": test_pbf_listing["id"],
                "source_type": function_source_details_source_type,
            },
            success_destination={
                "kind": function_success_destination_kind,
                "channel_id": test_channel["id"],
                "queue_id": test_queue["id"],
                "stream_id": test_stream["id"],
                "topic_id": test_notification_topic["id"],
            },
            timeout_in_seconds=function_timeout_in_seconds,
            trace_config={
                "is_enabled": function_trace_config_is_enabled,
            })
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Functions/function:Function test_function "id"
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detached_mode_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_destination: Optional[pulumi.Input[Union['FunctionFailureDestinationArgs', 'FunctionFailureDestinationArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 image_digest: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[Union['FunctionProvisionedConcurrencyConfigArgs', 'FunctionProvisionedConcurrencyConfigArgsDict']]] = None,
                 source_details: Optional[pulumi.Input[Union['FunctionSourceDetailsArgs', 'FunctionSourceDetailsArgsDict']]] = None,
                 success_destination: Optional[pulumi.Input[Union['FunctionSuccessDestinationArgs', 'FunctionSuccessDestinationArgsDict']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_config: Optional[pulumi.Input[Union['FunctionTraceConfigArgs', 'FunctionTraceConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["config"] = config
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["detached_mode_timeout_in_seconds"] = detached_mode_timeout_in_seconds
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["failure_destination"] = failure_destination
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image"] = image
            __props__.__dict__["image_digest"] = image_digest
            if memory_in_mbs is None and not opts.urn:
                raise TypeError("Missing required property 'memory_in_mbs'")
            __props__.__dict__["memory_in_mbs"] = memory_in_mbs
            __props__.__dict__["provisioned_concurrency_config"] = provisioned_concurrency_config
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["success_destination"] = success_destination
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["trace_config"] = trace_config
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["invoke_endpoint"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Function, __self__).__init__(
            'oci:Functions/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            detached_mode_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            failure_destination: Optional[pulumi.Input[Union['FunctionFailureDestinationArgs', 'FunctionFailureDestinationArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            image_digest: Optional[pulumi.Input[_builtins.str]] = None,
            invoke_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            memory_in_mbs: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_concurrency_config: Optional[pulumi.Input[Union['FunctionProvisionedConcurrencyConfigArgs', 'FunctionProvisionedConcurrencyConfigArgsDict']]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            source_details: Optional[pulumi.Input[Union['FunctionSourceDetailsArgs', 'FunctionSourceDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            success_destination: Optional[pulumi.Input[Union['FunctionSuccessDestinationArgs', 'FunctionSuccessDestinationArgsDict']]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            trace_config: Optional[pulumi.Input[Union['FunctionTraceConfigArgs', 'FunctionTraceConfigArgsDict']]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] detached_mode_timeout_in_seconds: (Updatable) Timeout for detached function invocations. Value in seconds.
        :param pulumi.Input[_builtins.str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[Union['FunctionFailureDestinationArgs', 'FunctionFailureDestinationArgsDict']] failure_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[_builtins.str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[_builtins.str] invoke_endpoint: The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        :param pulumi.Input[_builtins.str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[Union['FunctionProvisionedConcurrencyConfigArgs', 'FunctionProvisionedConcurrencyConfigArgsDict']] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[_builtins.str] shape: The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        :param pulumi.Input[Union['FunctionSourceDetailsArgs', 'FunctionSourceDetailsArgsDict']] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[_builtins.str] state: The current state of the function.
        :param pulumi.Input[Union['FunctionSuccessDestinationArgs', 'FunctionSuccessDestinationArgsDict']] success_destination: (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        :param pulumi.Input[_builtins.str] time_created: The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input[Union['FunctionTraceConfigArgs', 'FunctionTraceConfigArgsDict']] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config"] = config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["detached_mode_timeout_in_seconds"] = detached_mode_timeout_in_seconds
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["failure_destination"] = failure_destination
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image"] = image
        __props__.__dict__["image_digest"] = image_digest
        __props__.__dict__["invoke_endpoint"] = invoke_endpoint
        __props__.__dict__["memory_in_mbs"] = memory_in_mbs
        __props__.__dict__["provisioned_concurrency_config"] = provisioned_concurrency_config
        __props__.__dict__["shape"] = shape
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["success_destination"] = success_destination
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["trace_config"] = trace_config
        return Function(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment that contains the function.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="detachedModeTimeoutInSeconds")
    def detached_mode_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Timeout for detached function invocations. Value in seconds.
        """
        return pulumi.get(self, "detached_mode_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="failureDestination")
    def failure_destination(self) -> pulumi.Output['outputs.FunctionFailureDestination']:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the error of the failed detached function invocation. A notification is an example of a failure destination.  Example: `{"kind": "NOTIFICATION", "topicId": "topic_OCID"}`
        """
        return pulumi.get(self, "failure_destination")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @_builtins.property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        """
        return pulumi.get(self, "invoke_endpoint")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> pulumi.Output['outputs.FunctionProvisionedConcurrencyConfig']:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output['outputs.FunctionSourceDetails']:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the function.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="successDestination")
    def success_destination(self) -> pulumi.Output['outputs.FunctionSuccessDestination']:
        """
        (Updatable) An object that represents the destination to which Oracle Functions will send an invocation record with the details of the successful detached function invocation. A stream is an example of a success destination.  Example: `{"kind": "STREAM", "streamId": "stream_OCID"}`
        """
        return pulumi.get(self, "success_destination")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> pulumi.Output['outputs.FunctionTraceConfig']:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

