# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDedicatedAiClusterResult',
    'AwaitableGetDedicatedAiClusterResult',
    'get_dedicated_ai_cluster',
    'get_dedicated_ai_cluster_output',
]

@pulumi.output_type
class GetDedicatedAiClusterResult:
    """
    A collection of values returned by getDedicatedAiCluster.
    """
    def __init__(__self__, capacities=None, compartment_id=None, dedicated_ai_cluster_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None, unit_count=None, unit_shape=None):
        if capacities and not isinstance(capacities, list):
            raise TypeError("Expected argument 'capacities' to be a list")
        pulumi.set(__self__, "capacities", capacities)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dedicated_ai_cluster_id and not isinstance(dedicated_ai_cluster_id, str):
            raise TypeError("Expected argument 'dedicated_ai_cluster_id' to be a str")
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if unit_count and not isinstance(unit_count, int):
            raise TypeError("Expected argument 'unit_count' to be a int")
        pulumi.set(__self__, "unit_count", unit_count)
        if unit_shape and not isinstance(unit_shape, str):
            raise TypeError("Expected argument 'unit_shape' to be a str")
        pulumi.set(__self__, "unit_shape", unit_shape)

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetDedicatedAiClusterCapacityResult']:
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An optional description of the dedicated AI cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state with detail that can provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the dedicated AI cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the dedicated AI cluster was updated, in the format defined by RFC 3339
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="unitCount")
    def unit_count(self) -> _builtins.int:
        """
        The number of dedicated units in this AI cluster.
        """
        return pulumi.get(self, "unit_count")

    @_builtins.property
    @pulumi.getter(name="unitShape")
    def unit_shape(self) -> _builtins.str:
        """
        The shape of dedicated unit in this AI cluster. The underlying hardware configuration is hidden from customers.
        """
        return pulumi.get(self, "unit_shape")


class AwaitableGetDedicatedAiClusterResult(GetDedicatedAiClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedAiClusterResult(
            capacities=self.capacities,
            compartment_id=self.compartment_id,
            dedicated_ai_cluster_id=self.dedicated_ai_cluster_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            unit_count=self.unit_count,
            unit_shape=self.unit_shape)


def get_dedicated_ai_cluster(dedicated_ai_cluster_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedAiClusterResult:
    """
    This data source provides details about a specific Dedicated Ai Cluster resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about a dedicated AI cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_cluster = oci.GenerativeAi.get_dedicated_ai_cluster(dedicated_ai_cluster_id=test_dedicated_ai_cluster_oci_generative_ai_dedicated_ai_cluster["id"])
    ```


    :param _builtins.str dedicated_ai_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    """
    __args__ = dict()
    __args__['dedicatedAiClusterId'] = dedicated_ai_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getDedicatedAiCluster:getDedicatedAiCluster', __args__, opts=opts, typ=GetDedicatedAiClusterResult).value

    return AwaitableGetDedicatedAiClusterResult(
        capacities=pulumi.get(__ret__, 'capacities'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dedicated_ai_cluster_id=pulumi.get(__ret__, 'dedicated_ai_cluster_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        unit_count=pulumi.get(__ret__, 'unit_count'),
        unit_shape=pulumi.get(__ret__, 'unit_shape'))
def get_dedicated_ai_cluster_output(dedicated_ai_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDedicatedAiClusterResult]:
    """
    This data source provides details about a specific Dedicated Ai Cluster resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about a dedicated AI cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_ai_cluster = oci.GenerativeAi.get_dedicated_ai_cluster(dedicated_ai_cluster_id=test_dedicated_ai_cluster_oci_generative_ai_dedicated_ai_cluster["id"])
    ```


    :param _builtins.str dedicated_ai_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
    """
    __args__ = dict()
    __args__['dedicatedAiClusterId'] = dedicated_ai_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getDedicatedAiCluster:getDedicatedAiCluster', __args__, opts=opts, typ=GetDedicatedAiClusterResult)
    return __ret__.apply(lambda __response__: GetDedicatedAiClusterResult(
        capacities=pulumi.get(__response__, 'capacities'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dedicated_ai_cluster_id=pulumi.get(__response__, 'dedicated_ai_cluster_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        unit_count=pulumi.get(__response__, 'unit_count'),
        unit_shape=pulumi.get(__response__, 'unit_shape')))
