# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGenerativeAiPrivateEndpointResult',
    'AwaitableGetGenerativeAiPrivateEndpointResult',
    'get_generative_ai_private_endpoint',
    'get_generative_ai_private_endpoint_output',
]

@pulumi.output_type
class GetGenerativeAiPrivateEndpointResult:
    """
    A collection of values returned by getGenerativeAiPrivateEndpoint.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, dns_prefix=None, fqdn=None, freeform_tags=None, generative_ai_private_endpoint_id=None, id=None, lifecycle_details=None, nsg_ids=None, previous_state=None, private_endpoint_ip=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns_prefix and not isinstance(dns_prefix, str):
            raise TypeError("Expected argument 'dns_prefix' to be a str")
        pulumi.set(__self__, "dns_prefix", dns_prefix)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generative_ai_private_endpoint_id and not isinstance(generative_ai_private_endpoint_id, str):
            raise TypeError("Expected argument 'generative_ai_private_endpoint_id' to be a str")
        pulumi.set(__self__, "generative_ai_private_endpoint_id", generative_ai_private_endpoint_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if previous_state and not isinstance(previous_state, str):
            raise TypeError("Expected argument 'previous_state' to be a str")
        pulumi.set(__self__, "previous_state", previous_state)
        if private_endpoint_ip and not isinstance(private_endpoint_ip, str):
            raise TypeError("Expected argument 'private_endpoint_ip' to be a str")
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of this private endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> _builtins.str:
        return pulumi.get(self, "dns_prefix")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        Fully qualified domain name the customer will use for access (for eg: xyz.oraclecloud.com)
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="generativeAiPrivateEndpointId")
    def generative_ai_private_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "generative_ai_private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        A list of the OCIDs of the network security groups that the private endpoint's VNIC belongs to.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="previousState")
    def previous_state(self) -> _builtins.str:
        return pulumi.get(self, "previous_state")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        The private IP address (in the customer's VCN) that represents the access point for the associated endpoint service.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Generative AI Private Endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        return pulumi.get(self, "time_updated")


class AwaitableGetGenerativeAiPrivateEndpointResult(GetGenerativeAiPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGenerativeAiPrivateEndpointResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            dns_prefix=self.dns_prefix,
            fqdn=self.fqdn,
            freeform_tags=self.freeform_tags,
            generative_ai_private_endpoint_id=self.generative_ai_private_endpoint_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            nsg_ids=self.nsg_ids,
            previous_state=self.previous_state,
            private_endpoint_ip=self.private_endpoint_ip,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_generative_ai_private_endpoint(generative_ai_private_endpoint_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGenerativeAiPrivateEndpointResult:
    """
    This data source provides details about a specific Generative Ai Private Endpoint resource in Oracle Cloud Infrastructure Generative AI service.

    Retrieves an Generative AI private endpoint using a `privateEndpointId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generative_ai_private_endpoint = oci.GenerativeAi.get_generative_ai_private_endpoint(generative_ai_private_endpoint_id=test_generative_ai_private_endpoint_oci_generative_ai_generative_ai_private_endpoint["id"])
    ```


    :param _builtins.str generative_ai_private_endpoint_id: The unique id for a Generative AI private endpoint.
    """
    __args__ = dict()
    __args__['generativeAiPrivateEndpointId'] = generative_ai_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getGenerativeAiPrivateEndpoint:getGenerativeAiPrivateEndpoint', __args__, opts=opts, typ=GetGenerativeAiPrivateEndpointResult).value

    return AwaitableGetGenerativeAiPrivateEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns_prefix=pulumi.get(__ret__, 'dns_prefix'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        generative_ai_private_endpoint_id=pulumi.get(__ret__, 'generative_ai_private_endpoint_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        previous_state=pulumi.get(__ret__, 'previous_state'),
        private_endpoint_ip=pulumi.get(__ret__, 'private_endpoint_ip'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_generative_ai_private_endpoint_output(generative_ai_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGenerativeAiPrivateEndpointResult]:
    """
    This data source provides details about a specific Generative Ai Private Endpoint resource in Oracle Cloud Infrastructure Generative AI service.

    Retrieves an Generative AI private endpoint using a `privateEndpointId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generative_ai_private_endpoint = oci.GenerativeAi.get_generative_ai_private_endpoint(generative_ai_private_endpoint_id=test_generative_ai_private_endpoint_oci_generative_ai_generative_ai_private_endpoint["id"])
    ```


    :param _builtins.str generative_ai_private_endpoint_id: The unique id for a Generative AI private endpoint.
    """
    __args__ = dict()
    __args__['generativeAiPrivateEndpointId'] = generative_ai_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getGenerativeAiPrivateEndpoint:getGenerativeAiPrivateEndpoint', __args__, opts=opts, typ=GetGenerativeAiPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetGenerativeAiPrivateEndpointResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        dns_prefix=pulumi.get(__response__, 'dns_prefix'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        generative_ai_private_endpoint_id=pulumi.get(__response__, 'generative_ai_private_endpoint_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        previous_state=pulumi.get(__response__, 'previous_state'),
        private_endpoint_ip=pulumi.get(__response__, 'private_endpoint_ip'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
