# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGenerativeAiPrivateEndpointsResult',
    'AwaitableGetGenerativeAiPrivateEndpointsResult',
    'get_generative_ai_private_endpoints',
    'get_generative_ai_private_endpoints_output',
]

@pulumi.output_type
class GetGenerativeAiPrivateEndpointsResult:
    """
    A collection of values returned by getGenerativeAiPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, generative_ai_private_endpoint_collections=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if generative_ai_private_endpoint_collections and not isinstance(generative_ai_private_endpoint_collections, list):
            raise TypeError("Expected argument 'generative_ai_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "generative_ai_private_endpoint_collections", generative_ai_private_endpoint_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetGenerativeAiPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="generativeAiPrivateEndpointCollections")
    def generative_ai_private_endpoint_collections(self) -> Sequence['outputs.GetGenerativeAiPrivateEndpointsGenerativeAiPrivateEndpointCollectionResult']:
        """
        The list of generative_ai_private_endpoint_collection.
        """
        return pulumi.get(self, "generative_ai_private_endpoint_collections")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Generative AI Private Endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetGenerativeAiPrivateEndpointsResult(GetGenerativeAiPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGenerativeAiPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            generative_ai_private_endpoint_collections=self.generative_ai_private_endpoint_collections,
            id=self.id,
            state=self.state)


def get_generative_ai_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                                        display_name: Optional[_builtins.str] = None,
                                        filters: Optional[Sequence[Union['GetGenerativeAiPrivateEndpointsFilterArgs', 'GetGenerativeAiPrivateEndpointsFilterArgsDict']]] = None,
                                        id: Optional[_builtins.str] = None,
                                        state: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGenerativeAiPrivateEndpointsResult:
    """
    This data source provides the list of Generative Ai Private Endpoints in Oracle Cloud Infrastructure Generative AI service.

    Lists all Generative AI private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generative_ai_private_endpoints = oci.GenerativeAi.get_generative_ai_private_endpoints(compartment_id=compartment_id,
        display_name=generative_ai_private_endpoint_display_name,
        id=generative_ai_private_endpoint_id,
        state=generative_ai_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
    :param _builtins.str state: The lifecycle state of Generative AI private endpoints.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getGenerativeAiPrivateEndpoints:getGenerativeAiPrivateEndpoints', __args__, opts=opts, typ=GetGenerativeAiPrivateEndpointsResult).value

    return AwaitableGetGenerativeAiPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        generative_ai_private_endpoint_collections=pulumi.get(__ret__, 'generative_ai_private_endpoint_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_generative_ai_private_endpoints_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                               display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetGenerativeAiPrivateEndpointsFilterArgs', 'GetGenerativeAiPrivateEndpointsFilterArgsDict']]]]] = None,
                                               id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGenerativeAiPrivateEndpointsResult]:
    """
    This data source provides the list of Generative Ai Private Endpoints in Oracle Cloud Infrastructure Generative AI service.

    Lists all Generative AI private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generative_ai_private_endpoints = oci.GenerativeAi.get_generative_ai_private_endpoints(compartment_id=compartment_id,
        display_name=generative_ai_private_endpoint_display_name,
        id=generative_ai_private_endpoint_id,
        state=generative_ai_private_endpoint_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
    :param _builtins.str state: The lifecycle state of Generative AI private endpoints.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getGenerativeAiPrivateEndpoints:getGenerativeAiPrivateEndpoints', __args__, opts=opts, typ=GetGenerativeAiPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetGenerativeAiPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        generative_ai_private_endpoint_collections=pulumi.get(__response__, 'generative_ai_private_endpoint_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
