# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DomainReplicationToRegionArgs', 'DomainReplicationToRegion']

@pulumi.input_type
class DomainReplicationToRegionArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[_builtins.str],
                 replica_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainReplicationToRegion resource.
        :param pulumi.Input[_builtins.str] domain_id: The OCID of the domain
        :param pulumi.Input[_builtins.str] replica_region: A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "domain_id", domain_id)
        if replica_region is not None:
            pulumi.set(__self__, "replica_region", replica_region)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the domain
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "replica_region")

    @replica_region.setter
    def replica_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_region", value)


@pulumi.input_type
class _DomainReplicationToRegionState:
    def __init__(__self__, *,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainReplicationToRegion resources.
        :param pulumi.Input[_builtins.str] domain_id: The OCID of the domain
        :param pulumi.Input[_builtins.str] replica_region: A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if replica_region is not None:
            pulumi.set(__self__, "replica_region", replica_region)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the domain
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "replica_region")

    @replica_region.setter
    def replica_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_region", value)


@pulumi.type_token("oci:Identity/domainReplicationToRegion:DomainReplicationToRegion")
class DomainReplicationToRegion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_domain_replication_to_region = oci.identity.DomainReplicationToRegion("test_domain_replication_to_region",
            domain_id=test_domain["id"],
            replica_region=domain_replication_to_region_replica_region)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_id: The OCID of the domain
        :param pulumi.Input[_builtins.str] replica_region: A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainReplicationToRegionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_domain_replication_to_region = oci.identity.DomainReplicationToRegion("test_domain_replication_to_region",
            domain_id=test_domain["id"],
            replica_region=domain_replication_to_region_replica_region)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DomainReplicationToRegionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainReplicationToRegionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainReplicationToRegionArgs.__new__(DomainReplicationToRegionArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["replica_region"] = replica_region
        super(DomainReplicationToRegion, __self__).__init__(
            'oci:Identity/domainReplicationToRegion:DomainReplicationToRegion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            replica_region: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainReplicationToRegion':
        """
        Get an existing DomainReplicationToRegion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_id: The OCID of the domain
        :param pulumi.Input[_builtins.str] replica_region: A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainReplicationToRegionState.__new__(_DomainReplicationToRegionState)

        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["replica_region"] = replica_region
        return DomainReplicationToRegion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the domain
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> pulumi.Output[_builtins.str]:
        """
        A region for which domain replication is requested for. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "replica_region")

