# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, compartment_id=None, external_identifier=None, filters=None, id=None, identity_provider_id=None, name=None, state=None, users=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if external_identifier and not isinstance(external_identifier, str):
            raise TypeError("Expected argument 'external_identifier' to be a str")
        pulumi.set(__self__, "external_identifier", external_identifier)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_provider_id and not isinstance(identity_provider_id, str):
            raise TypeError("Expected argument 'identity_provider_id' to be a str")
        pulumi.set(__self__, "identity_provider_id", identity_provider_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy containing the user.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="externalIdentifier")
    def external_identifier(self) -> Optional[_builtins.str]:
        """
        Identifier of the user in the identity provider
        """
        return pulumi.get(self, "external_identifier")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUsersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityProviderId")
    def identity_provider_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the `IdentityProvider` this user belongs to.
        """
        return pulumi.get(self, "identity_provider_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The user's current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        The list of users.
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            compartment_id=self.compartment_id,
            external_identifier=self.external_identifier,
            filters=self.filters,
            id=self.id,
            identity_provider_id=self.identity_provider_id,
            name=self.name,
            state=self.state,
            users=self.users)


def get_users(compartment_id: Optional[_builtins.str] = None,
              external_identifier: Optional[_builtins.str] = None,
              filters: Optional[Sequence[Union['GetUsersFilterArgs', 'GetUsersFilterArgsDict']]] = None,
              identity_provider_id: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              state: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    This data source provides the list of Users in Oracle Cloud Infrastructure Identity service.

    Lists the users in your tenancy. You must specify your tenancy's OCID as the value for the
    compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_users = oci.Identity.get_users(compartment_id=tenancy_ocid,
        external_identifier=user_external_identifier,
        identity_provider_id=test_identity_provider["id"],
        name=user_name,
        state=user_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param _builtins.str external_identifier: The id of a user in the identity provider.
    :param _builtins.str identity_provider_id: The id of the identity provider.
    :param _builtins.str name: A filter to only return resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['externalIdentifier'] = external_identifier
    __args__['filters'] = filters
    __args__['identityProviderId'] = identity_provider_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        external_identifier=pulumi.get(__ret__, 'external_identifier'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identity_provider_id=pulumi.get(__ret__, 'identity_provider_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        users=pulumi.get(__ret__, 'users'))
def get_users_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                     external_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUsersFilterArgs', 'GetUsersFilterArgsDict']]]]] = None,
                     identity_provider_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsersResult]:
    """
    This data source provides the list of Users in Oracle Cloud Infrastructure Identity service.

    Lists the users in your tenancy. You must specify your tenancy's OCID as the value for the
    compartment ID (remember that the tenancy is simply the root compartment).
    See [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_users = oci.Identity.get_users(compartment_id=tenancy_ocid,
        external_identifier=user_external_identifier,
        identity_provider_id=test_identity_provider["id"],
        name=user_name,
        state=user_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param _builtins.str external_identifier: The id of a user in the identity provider.
    :param _builtins.str identity_provider_id: The id of the identity provider.
    :param _builtins.str name: A filter to only return resources that match the given name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['externalIdentifier'] = external_identifier
    __args__['filters'] = filters
    __args__['identityProviderId'] = identity_provider_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult)
    return __ret__.apply(lambda __response__: GetUsersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        external_identifier=pulumi.get(__response__, 'external_identifier'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        identity_provider_id=pulumi.get(__response__, 'identity_provider_id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        users=pulumi.get(__response__, 'users')))
