# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GeneratedScopedAccessTokenArgs', 'GeneratedScopedAccessToken']

@pulumi.input_type
class GeneratedScopedAccessTokenArgs:
    def __init__(__self__, *,
                 public_key: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GeneratedScopedAccessToken resource.
        :param pulumi.Input[_builtins.str] public_key: A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        :param pulumi.Input[_builtins.str] scope: Scope definition for the scoped access token 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[_builtins.str]:
        """
        A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        Scope definition for the scoped access token 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _GeneratedScopedAccessTokenState:
    def __init__(__self__, *,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GeneratedScopedAccessToken resources.
        :param pulumi.Input[_builtins.str] public_key: A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        :param pulumi.Input[_builtins.str] scope: Scope definition for the scoped access token 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] token: The security token, signed by auth service
        """
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope definition for the scoped access token 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security token, signed by auth service
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("oci:IdentityDataPlane/generatedScopedAccessToken:GeneratedScopedAccessToken")
class GeneratedScopedAccessToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generate_scoped_access_token = oci.identitydataplane.GeneratedScopedAccessToken("test_generate_scoped_access_token",
            public_key=generate_scoped_access_token_public_key,
            scope=generate_scoped_access_token_scope)
        ```

        ## Import

        GenerateScopedAccessToken can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:IdentityDataPlane/generatedScopedAccessToken:GeneratedScopedAccessToken test_generate_scoped_access_token "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] public_key: A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        :param pulumi.Input[_builtins.str] scope: Scope definition for the scoped access token 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GeneratedScopedAccessTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_generate_scoped_access_token = oci.identitydataplane.GeneratedScopedAccessToken("test_generate_scoped_access_token",
            public_key=generate_scoped_access_token_public_key,
            scope=generate_scoped_access_token_scope)
        ```

        ## Import

        GenerateScopedAccessToken can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:IdentityDataPlane/generatedScopedAccessToken:GeneratedScopedAccessToken test_generate_scoped_access_token "id"
        ```

        :param str resource_name: The name of the resource.
        :param GeneratedScopedAccessTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GeneratedScopedAccessTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GeneratedScopedAccessTokenArgs.__new__(GeneratedScopedAccessTokenArgs)

            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["token"] = None
        super(GeneratedScopedAccessToken, __self__).__init__(
            'oci:IdentityDataPlane/generatedScopedAccessToken:GeneratedScopedAccessToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None) -> 'GeneratedScopedAccessToken':
        """
        Get an existing GeneratedScopedAccessToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] public_key: A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        :param pulumi.Input[_builtins.str] scope: Scope definition for the scoped access token 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] token: The security token, signed by auth service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GeneratedScopedAccessTokenState.__new__(_GeneratedScopedAccessTokenState)

        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["scope"] = scope
        __props__.__dict__["token"] = token
        return GeneratedScopedAccessToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        A temporary public key, owned by the service. The service also owns the corresponding private key. This public key will by put inside the security token by the auth service after successful validation of the certificate.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Scope definition for the scoped access token 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        The security token, signed by auth service
        """
        return pulumi.get(self, "token")

