# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetAgentConfigurationArgs', 'FleetAgentConfiguration']

@pulumi.input_type
class FleetAgentConfigurationArgs:
    def __init__(__self__, *,
                 fleet_id: pulumi.Input[_builtins.str],
                 agent_polling_interval_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 is_capturing_ip_address_and_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_managed_instance_metrics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_usernames_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_libraries_scan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_usage_tracker_processing_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 jre_scan_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 linux_configuration: Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']] = None,
                 mac_os_configuration: Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']] = None,
                 windows_configuration: Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']] = None,
                 work_request_validity_period_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a FleetAgentConfiguration resource.
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.int] agent_polling_interval_in_minutes: (Updatable) Agent polling interval in minutes
        :param pulumi.Input[_builtins.bool] is_capturing_ip_address_and_fqdn_enabled: (Updatable) Collect network addresses of managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_managed_instance_metrics_enabled: (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_usernames_enabled: (Updatable) Collect username for application invocations for all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_libraries_scan_enabled: (Updatable) Enable libraries scan on all managed instances in the fleet.
        :param pulumi.Input[_builtins.int] java_usage_tracker_processing_frequency_in_minutes: (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        :param pulumi.Input[_builtins.int] jre_scan_frequency_in_minutes: (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        :param pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs'] linux_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs'] mac_os_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs'] windows_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.int] work_request_validity_period_in_days: (Updatable) The validity period in days for work requests. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "fleet_id", fleet_id)
        if agent_polling_interval_in_minutes is not None:
            pulumi.set(__self__, "agent_polling_interval_in_minutes", agent_polling_interval_in_minutes)
        if is_capturing_ip_address_and_fqdn_enabled is not None:
            pulumi.set(__self__, "is_capturing_ip_address_and_fqdn_enabled", is_capturing_ip_address_and_fqdn_enabled)
        if is_collecting_managed_instance_metrics_enabled is not None:
            pulumi.set(__self__, "is_collecting_managed_instance_metrics_enabled", is_collecting_managed_instance_metrics_enabled)
        if is_collecting_usernames_enabled is not None:
            pulumi.set(__self__, "is_collecting_usernames_enabled", is_collecting_usernames_enabled)
        if is_libraries_scan_enabled is not None:
            pulumi.set(__self__, "is_libraries_scan_enabled", is_libraries_scan_enabled)
        if java_usage_tracker_processing_frequency_in_minutes is not None:
            pulumi.set(__self__, "java_usage_tracker_processing_frequency_in_minutes", java_usage_tracker_processing_frequency_in_minutes)
        if jre_scan_frequency_in_minutes is not None:
            pulumi.set(__self__, "jre_scan_frequency_in_minutes", jre_scan_frequency_in_minutes)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if mac_os_configuration is not None:
            pulumi.set(__self__, "mac_os_configuration", mac_os_configuration)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)
        if work_request_validity_period_in_days is not None:
            pulumi.set(__self__, "work_request_validity_period_in_days", work_request_validity_period_in_days)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="agentPollingIntervalInMinutes")
    def agent_polling_interval_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Agent polling interval in minutes
        """
        return pulumi.get(self, "agent_polling_interval_in_minutes")

    @agent_polling_interval_in_minutes.setter
    def agent_polling_interval_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "agent_polling_interval_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="isCapturingIpAddressAndFqdnEnabled")
    def is_capturing_ip_address_and_fqdn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect network addresses of managed instances in the fleet.
        """
        return pulumi.get(self, "is_capturing_ip_address_and_fqdn_enabled")

    @is_capturing_ip_address_and_fqdn_enabled.setter
    def is_capturing_ip_address_and_fqdn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_capturing_ip_address_and_fqdn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCollectingManagedInstanceMetricsEnabled")
    def is_collecting_managed_instance_metrics_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_managed_instance_metrics_enabled")

    @is_collecting_managed_instance_metrics_enabled.setter
    def is_collecting_managed_instance_metrics_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_collecting_managed_instance_metrics_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCollectingUsernamesEnabled")
    def is_collecting_usernames_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect username for application invocations for all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_usernames_enabled")

    @is_collecting_usernames_enabled.setter
    def is_collecting_usernames_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_collecting_usernames_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isLibrariesScanEnabled")
    def is_libraries_scan_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Enable libraries scan on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_libraries_scan_enabled")

    @is_libraries_scan_enabled.setter
    def is_libraries_scan_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_libraries_scan_enabled", value)

    @_builtins.property
    @pulumi.getter(name="javaUsageTrackerProcessingFrequencyInMinutes")
    def java_usage_tracker_processing_frequency_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        """
        return pulumi.get(self, "java_usage_tracker_processing_frequency_in_minutes")

    @java_usage_tracker_processing_frequency_in_minutes.setter
    def java_usage_tracker_processing_frequency_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_usage_tracker_processing_frequency_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="jreScanFrequencyInMinutes")
    def jre_scan_frequency_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        """
        return pulumi.get(self, "jre_scan_frequency_in_minutes")

    @jre_scan_frequency_in_minutes.setter
    def jre_scan_frequency_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "jre_scan_frequency_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @_builtins.property
    @pulumi.getter(name="macOsConfiguration")
    def mac_os_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "mac_os_configuration")

    @mac_os_configuration.setter
    def mac_os_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']]):
        pulumi.set(self, "mac_os_configuration", value)

    @_builtins.property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)

    @_builtins.property
    @pulumi.getter(name="workRequestValidityPeriodInDays")
    def work_request_validity_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The validity period in days for work requests. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_validity_period_in_days")

    @work_request_validity_period_in_days.setter
    def work_request_validity_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "work_request_validity_period_in_days", value)


@pulumi.input_type
class _FleetAgentConfigurationState:
    def __init__(__self__, *,
                 agent_polling_interval_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_capturing_ip_address_and_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_managed_instance_metrics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_usernames_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_libraries_scan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_usage_tracker_processing_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 jre_scan_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 linux_configuration: Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']] = None,
                 mac_os_configuration: Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']] = None,
                 time_last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_configuration: Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']] = None,
                 work_request_validity_period_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering FleetAgentConfiguration resources.
        :param pulumi.Input[_builtins.int] agent_polling_interval_in_minutes: (Updatable) Agent polling interval in minutes
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.bool] is_capturing_ip_address_and_fqdn_enabled: (Updatable) Collect network addresses of managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_managed_instance_metrics_enabled: (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_usernames_enabled: (Updatable) Collect username for application invocations for all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_libraries_scan_enabled: (Updatable) Enable libraries scan on all managed instances in the fleet.
        :param pulumi.Input[_builtins.int] java_usage_tracker_processing_frequency_in_minutes: (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        :param pulumi.Input[_builtins.int] jre_scan_frequency_in_minutes: (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        :param pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs'] linux_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs'] mac_os_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.str] time_last_modified: The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs'] windows_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.int] work_request_validity_period_in_days: (Updatable) The validity period in days for work requests. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if agent_polling_interval_in_minutes is not None:
            pulumi.set(__self__, "agent_polling_interval_in_minutes", agent_polling_interval_in_minutes)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if is_capturing_ip_address_and_fqdn_enabled is not None:
            pulumi.set(__self__, "is_capturing_ip_address_and_fqdn_enabled", is_capturing_ip_address_and_fqdn_enabled)
        if is_collecting_managed_instance_metrics_enabled is not None:
            pulumi.set(__self__, "is_collecting_managed_instance_metrics_enabled", is_collecting_managed_instance_metrics_enabled)
        if is_collecting_usernames_enabled is not None:
            pulumi.set(__self__, "is_collecting_usernames_enabled", is_collecting_usernames_enabled)
        if is_libraries_scan_enabled is not None:
            pulumi.set(__self__, "is_libraries_scan_enabled", is_libraries_scan_enabled)
        if java_usage_tracker_processing_frequency_in_minutes is not None:
            pulumi.set(__self__, "java_usage_tracker_processing_frequency_in_minutes", java_usage_tracker_processing_frequency_in_minutes)
        if jre_scan_frequency_in_minutes is not None:
            pulumi.set(__self__, "jre_scan_frequency_in_minutes", jre_scan_frequency_in_minutes)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if mac_os_configuration is not None:
            pulumi.set(__self__, "mac_os_configuration", mac_os_configuration)
        if time_last_modified is not None:
            pulumi.set(__self__, "time_last_modified", time_last_modified)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)
        if work_request_validity_period_in_days is not None:
            pulumi.set(__self__, "work_request_validity_period_in_days", work_request_validity_period_in_days)

    @_builtins.property
    @pulumi.getter(name="agentPollingIntervalInMinutes")
    def agent_polling_interval_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Agent polling interval in minutes
        """
        return pulumi.get(self, "agent_polling_interval_in_minutes")

    @agent_polling_interval_in_minutes.setter
    def agent_polling_interval_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "agent_polling_interval_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="isCapturingIpAddressAndFqdnEnabled")
    def is_capturing_ip_address_and_fqdn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect network addresses of managed instances in the fleet.
        """
        return pulumi.get(self, "is_capturing_ip_address_and_fqdn_enabled")

    @is_capturing_ip_address_and_fqdn_enabled.setter
    def is_capturing_ip_address_and_fqdn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_capturing_ip_address_and_fqdn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCollectingManagedInstanceMetricsEnabled")
    def is_collecting_managed_instance_metrics_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_managed_instance_metrics_enabled")

    @is_collecting_managed_instance_metrics_enabled.setter
    def is_collecting_managed_instance_metrics_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_collecting_managed_instance_metrics_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isCollectingUsernamesEnabled")
    def is_collecting_usernames_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Collect username for application invocations for all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_usernames_enabled")

    @is_collecting_usernames_enabled.setter
    def is_collecting_usernames_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_collecting_usernames_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isLibrariesScanEnabled")
    def is_libraries_scan_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Enable libraries scan on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_libraries_scan_enabled")

    @is_libraries_scan_enabled.setter
    def is_libraries_scan_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_libraries_scan_enabled", value)

    @_builtins.property
    @pulumi.getter(name="javaUsageTrackerProcessingFrequencyInMinutes")
    def java_usage_tracker_processing_frequency_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        """
        return pulumi.get(self, "java_usage_tracker_processing_frequency_in_minutes")

    @java_usage_tracker_processing_frequency_in_minutes.setter
    def java_usage_tracker_processing_frequency_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_usage_tracker_processing_frequency_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="jreScanFrequencyInMinutes")
    def jre_scan_frequency_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        """
        return pulumi.get(self, "jre_scan_frequency_in_minutes")

    @jre_scan_frequency_in_minutes.setter
    def jre_scan_frequency_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "jre_scan_frequency_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationLinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @_builtins.property
    @pulumi.getter(name="macOsConfiguration")
    def mac_os_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "mac_os_configuration")

    @mac_os_configuration.setter
    def mac_os_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationMacOsConfigurationArgs']]):
        pulumi.set(self, "mac_os_configuration", value)

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")

    @time_last_modified.setter
    def time_last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_modified", value)

    @_builtins.property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']]:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['FleetAgentConfigurationWindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)

    @_builtins.property
    @pulumi.getter(name="workRequestValidityPeriodInDays")
    def work_request_validity_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The validity period in days for work requests. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_validity_period_in_days")

    @work_request_validity_period_in_days.setter
    def work_request_validity_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "work_request_validity_period_in_days", value)


@pulumi.type_token("oci:Jms/fleetAgentConfiguration:FleetAgentConfiguration")
class FleetAgentConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_polling_interval_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_capturing_ip_address_and_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_managed_instance_metrics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_usernames_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_libraries_scan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_usage_tracker_processing_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 jre_scan_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 linux_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationLinuxConfigurationArgs', 'FleetAgentConfigurationLinuxConfigurationArgsDict']]] = None,
                 mac_os_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationMacOsConfigurationArgs', 'FleetAgentConfigurationMacOsConfigurationArgsDict']]] = None,
                 windows_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationWindowsConfigurationArgs', 'FleetAgentConfigurationWindowsConfigurationArgsDict']]] = None,
                 work_request_validity_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Fleet Agent Configuration resource in Oracle Cloud Infrastructure Jms service.

        Update the Fleet Agent Configuration for the specified Fleet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_agent_configuration = oci.jms.FleetAgentConfiguration("test_fleet_agent_configuration",
            fleet_id=test_fleet["id"],
            agent_polling_interval_in_minutes=10,
            is_capturing_ip_address_and_fqdn_enabled=False,
            is_collecting_managed_instance_metrics_enabled=False,
            is_collecting_usernames_enabled=False,
            is_libraries_scan_enabled=False,
            java_usage_tracker_processing_frequency_in_minutes=10,
            jre_scan_frequency_in_minutes=180,
            linux_configuration={
                "exclude_paths": [
                    "/user/private1",
                    "/opt/private1",
                ],
                "include_paths": [
                    "/user",
                    "/opt",
                ],
            },
            mac_os_configuration={
                "exclude_paths": ["/home/private1"],
                "include_paths": ["/home"],
            },
            windows_configuration={
                "exclude_paths": [
                    "c:\\\\windows\\\\private1",
                    "d:\\\\data\\\\private1",
                ],
                "include_paths": [
                    "c:\\\\windows",
                    "d:\\\\data",
                ],
            },
            work_request_validity_period_in_days=10)
        ```

        ## Import

        FleetAgentConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleetAgentConfiguration:FleetAgentConfiguration test_fleet_agent_configuration "fleets/{fleetId}/agentConfiguration"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] agent_polling_interval_in_minutes: (Updatable) Agent polling interval in minutes
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.bool] is_capturing_ip_address_and_fqdn_enabled: (Updatable) Collect network addresses of managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_managed_instance_metrics_enabled: (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_usernames_enabled: (Updatable) Collect username for application invocations for all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_libraries_scan_enabled: (Updatable) Enable libraries scan on all managed instances in the fleet.
        :param pulumi.Input[_builtins.int] java_usage_tracker_processing_frequency_in_minutes: (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        :param pulumi.Input[_builtins.int] jre_scan_frequency_in_minutes: (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        :param pulumi.Input[Union['FleetAgentConfigurationLinuxConfigurationArgs', 'FleetAgentConfigurationLinuxConfigurationArgsDict']] linux_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[Union['FleetAgentConfigurationMacOsConfigurationArgs', 'FleetAgentConfigurationMacOsConfigurationArgsDict']] mac_os_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[Union['FleetAgentConfigurationWindowsConfigurationArgs', 'FleetAgentConfigurationWindowsConfigurationArgsDict']] windows_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.int] work_request_validity_period_in_days: (Updatable) The validity period in days for work requests. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetAgentConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fleet Agent Configuration resource in Oracle Cloud Infrastructure Jms service.

        Update the Fleet Agent Configuration for the specified Fleet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_agent_configuration = oci.jms.FleetAgentConfiguration("test_fleet_agent_configuration",
            fleet_id=test_fleet["id"],
            agent_polling_interval_in_minutes=10,
            is_capturing_ip_address_and_fqdn_enabled=False,
            is_collecting_managed_instance_metrics_enabled=False,
            is_collecting_usernames_enabled=False,
            is_libraries_scan_enabled=False,
            java_usage_tracker_processing_frequency_in_minutes=10,
            jre_scan_frequency_in_minutes=180,
            linux_configuration={
                "exclude_paths": [
                    "/user/private1",
                    "/opt/private1",
                ],
                "include_paths": [
                    "/user",
                    "/opt",
                ],
            },
            mac_os_configuration={
                "exclude_paths": ["/home/private1"],
                "include_paths": ["/home"],
            },
            windows_configuration={
                "exclude_paths": [
                    "c:\\\\windows\\\\private1",
                    "d:\\\\data\\\\private1",
                ],
                "include_paths": [
                    "c:\\\\windows",
                    "d:\\\\data",
                ],
            },
            work_request_validity_period_in_days=10)
        ```

        ## Import

        FleetAgentConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/fleetAgentConfiguration:FleetAgentConfiguration test_fleet_agent_configuration "fleets/{fleetId}/agentConfiguration"
        ```

        :param str resource_name: The name of the resource.
        :param FleetAgentConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetAgentConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_polling_interval_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_capturing_ip_address_and_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_managed_instance_metrics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_collecting_usernames_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_libraries_scan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_usage_tracker_processing_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 jre_scan_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 linux_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationLinuxConfigurationArgs', 'FleetAgentConfigurationLinuxConfigurationArgsDict']]] = None,
                 mac_os_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationMacOsConfigurationArgs', 'FleetAgentConfigurationMacOsConfigurationArgsDict']]] = None,
                 windows_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationWindowsConfigurationArgs', 'FleetAgentConfigurationWindowsConfigurationArgsDict']]] = None,
                 work_request_validity_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetAgentConfigurationArgs.__new__(FleetAgentConfigurationArgs)

            __props__.__dict__["agent_polling_interval_in_minutes"] = agent_polling_interval_in_minutes
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            __props__.__dict__["is_capturing_ip_address_and_fqdn_enabled"] = is_capturing_ip_address_and_fqdn_enabled
            __props__.__dict__["is_collecting_managed_instance_metrics_enabled"] = is_collecting_managed_instance_metrics_enabled
            __props__.__dict__["is_collecting_usernames_enabled"] = is_collecting_usernames_enabled
            __props__.__dict__["is_libraries_scan_enabled"] = is_libraries_scan_enabled
            __props__.__dict__["java_usage_tracker_processing_frequency_in_minutes"] = java_usage_tracker_processing_frequency_in_minutes
            __props__.__dict__["jre_scan_frequency_in_minutes"] = jre_scan_frequency_in_minutes
            __props__.__dict__["linux_configuration"] = linux_configuration
            __props__.__dict__["mac_os_configuration"] = mac_os_configuration
            __props__.__dict__["windows_configuration"] = windows_configuration
            __props__.__dict__["work_request_validity_period_in_days"] = work_request_validity_period_in_days
            __props__.__dict__["time_last_modified"] = None
        super(FleetAgentConfiguration, __self__).__init__(
            'oci:Jms/fleetAgentConfiguration:FleetAgentConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_polling_interval_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_capturing_ip_address_and_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_collecting_managed_instance_metrics_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_collecting_usernames_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_libraries_scan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            java_usage_tracker_processing_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            jre_scan_frequency_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            linux_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationLinuxConfigurationArgs', 'FleetAgentConfigurationLinuxConfigurationArgsDict']]] = None,
            mac_os_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationMacOsConfigurationArgs', 'FleetAgentConfigurationMacOsConfigurationArgsDict']]] = None,
            time_last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            windows_configuration: Optional[pulumi.Input[Union['FleetAgentConfigurationWindowsConfigurationArgs', 'FleetAgentConfigurationWindowsConfigurationArgsDict']]] = None,
            work_request_validity_period_in_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'FleetAgentConfiguration':
        """
        Get an existing FleetAgentConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] agent_polling_interval_in_minutes: (Updatable) Agent polling interval in minutes
        :param pulumi.Input[_builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.bool] is_capturing_ip_address_and_fqdn_enabled: (Updatable) Collect network addresses of managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_managed_instance_metrics_enabled: (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_collecting_usernames_enabled: (Updatable) Collect username for application invocations for all managed instances in the fleet.
        :param pulumi.Input[_builtins.bool] is_libraries_scan_enabled: (Updatable) Enable libraries scan on all managed instances in the fleet.
        :param pulumi.Input[_builtins.int] java_usage_tracker_processing_frequency_in_minutes: (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        :param pulumi.Input[_builtins.int] jre_scan_frequency_in_minutes: (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        :param pulumi.Input[Union['FleetAgentConfigurationLinuxConfigurationArgs', 'FleetAgentConfigurationLinuxConfigurationArgsDict']] linux_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[Union['FleetAgentConfigurationMacOsConfigurationArgs', 'FleetAgentConfigurationMacOsConfigurationArgsDict']] mac_os_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.str] time_last_modified: The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[Union['FleetAgentConfigurationWindowsConfigurationArgs', 'FleetAgentConfigurationWindowsConfigurationArgsDict']] windows_configuration: (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        :param pulumi.Input[_builtins.int] work_request_validity_period_in_days: (Updatable) The validity period in days for work requests. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetAgentConfigurationState.__new__(_FleetAgentConfigurationState)

        __props__.__dict__["agent_polling_interval_in_minutes"] = agent_polling_interval_in_minutes
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["is_capturing_ip_address_and_fqdn_enabled"] = is_capturing_ip_address_and_fqdn_enabled
        __props__.__dict__["is_collecting_managed_instance_metrics_enabled"] = is_collecting_managed_instance_metrics_enabled
        __props__.__dict__["is_collecting_usernames_enabled"] = is_collecting_usernames_enabled
        __props__.__dict__["is_libraries_scan_enabled"] = is_libraries_scan_enabled
        __props__.__dict__["java_usage_tracker_processing_frequency_in_minutes"] = java_usage_tracker_processing_frequency_in_minutes
        __props__.__dict__["jre_scan_frequency_in_minutes"] = jre_scan_frequency_in_minutes
        __props__.__dict__["linux_configuration"] = linux_configuration
        __props__.__dict__["mac_os_configuration"] = mac_os_configuration
        __props__.__dict__["time_last_modified"] = time_last_modified
        __props__.__dict__["windows_configuration"] = windows_configuration
        __props__.__dict__["work_request_validity_period_in_days"] = work_request_validity_period_in_days
        return FleetAgentConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentPollingIntervalInMinutes")
    def agent_polling_interval_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Agent polling interval in minutes
        """
        return pulumi.get(self, "agent_polling_interval_in_minutes")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="isCapturingIpAddressAndFqdnEnabled")
    def is_capturing_ip_address_and_fqdn_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Collect network addresses of managed instances in the fleet.
        """
        return pulumi.get(self, "is_capturing_ip_address_and_fqdn_enabled")

    @_builtins.property
    @pulumi.getter(name="isCollectingManagedInstanceMetricsEnabled")
    def is_collecting_managed_instance_metrics_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Collect JMS agent metrics on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_managed_instance_metrics_enabled")

    @_builtins.property
    @pulumi.getter(name="isCollectingUsernamesEnabled")
    def is_collecting_usernames_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Collect username for application invocations for all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_usernames_enabled")

    @_builtins.property
    @pulumi.getter(name="isLibrariesScanEnabled")
    def is_libraries_scan_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Enable libraries scan on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_libraries_scan_enabled")

    @_builtins.property
    @pulumi.getter(name="javaUsageTrackerProcessingFrequencyInMinutes")
    def java_usage_tracker_processing_frequency_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        """
        return pulumi.get(self, "java_usage_tracker_processing_frequency_in_minutes")

    @_builtins.property
    @pulumi.getter(name="jreScanFrequencyInMinutes")
    def jre_scan_frequency_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        """
        return pulumi.get(self, "jre_scan_frequency_in_minutes")

    @_builtins.property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> pulumi.Output['outputs.FleetAgentConfigurationLinuxConfiguration']:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "linux_configuration")

    @_builtins.property
    @pulumi.getter(name="macOsConfiguration")
    def mac_os_configuration(self) -> pulumi.Output['outputs.FleetAgentConfigurationMacOsConfiguration']:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "mac_os_configuration")

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")

    @_builtins.property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> pulumi.Output['outputs.FleetAgentConfigurationWindowsConfiguration']:
        """
        (Updatable) Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "windows_configuration")

    @_builtins.property
    @pulumi.getter(name="workRequestValidityPeriodInDays")
    def work_request_validity_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The validity period in days for work requests. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_validity_period_in_days")

