# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFleetAgentConfigurationResult',
    'AwaitableGetFleetAgentConfigurationResult',
    'get_fleet_agent_configuration',
    'get_fleet_agent_configuration_output',
]

@pulumi.output_type
class GetFleetAgentConfigurationResult:
    """
    A collection of values returned by getFleetAgentConfiguration.
    """
    def __init__(__self__, agent_polling_interval_in_minutes=None, fleet_id=None, id=None, is_capturing_ip_address_and_fqdn_enabled=None, is_collecting_managed_instance_metrics_enabled=None, is_collecting_usernames_enabled=None, is_libraries_scan_enabled=None, java_usage_tracker_processing_frequency_in_minutes=None, jre_scan_frequency_in_minutes=None, linux_configurations=None, mac_os_configurations=None, time_last_modified=None, windows_configurations=None, work_request_validity_period_in_days=None):
        if agent_polling_interval_in_minutes and not isinstance(agent_polling_interval_in_minutes, int):
            raise TypeError("Expected argument 'agent_polling_interval_in_minutes' to be a int")
        pulumi.set(__self__, "agent_polling_interval_in_minutes", agent_polling_interval_in_minutes)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_capturing_ip_address_and_fqdn_enabled and not isinstance(is_capturing_ip_address_and_fqdn_enabled, bool):
            raise TypeError("Expected argument 'is_capturing_ip_address_and_fqdn_enabled' to be a bool")
        pulumi.set(__self__, "is_capturing_ip_address_and_fqdn_enabled", is_capturing_ip_address_and_fqdn_enabled)
        if is_collecting_managed_instance_metrics_enabled and not isinstance(is_collecting_managed_instance_metrics_enabled, bool):
            raise TypeError("Expected argument 'is_collecting_managed_instance_metrics_enabled' to be a bool")
        pulumi.set(__self__, "is_collecting_managed_instance_metrics_enabled", is_collecting_managed_instance_metrics_enabled)
        if is_collecting_usernames_enabled and not isinstance(is_collecting_usernames_enabled, bool):
            raise TypeError("Expected argument 'is_collecting_usernames_enabled' to be a bool")
        pulumi.set(__self__, "is_collecting_usernames_enabled", is_collecting_usernames_enabled)
        if is_libraries_scan_enabled and not isinstance(is_libraries_scan_enabled, bool):
            raise TypeError("Expected argument 'is_libraries_scan_enabled' to be a bool")
        pulumi.set(__self__, "is_libraries_scan_enabled", is_libraries_scan_enabled)
        if java_usage_tracker_processing_frequency_in_minutes and not isinstance(java_usage_tracker_processing_frequency_in_minutes, int):
            raise TypeError("Expected argument 'java_usage_tracker_processing_frequency_in_minutes' to be a int")
        pulumi.set(__self__, "java_usage_tracker_processing_frequency_in_minutes", java_usage_tracker_processing_frequency_in_minutes)
        if jre_scan_frequency_in_minutes and not isinstance(jre_scan_frequency_in_minutes, int):
            raise TypeError("Expected argument 'jre_scan_frequency_in_minutes' to be a int")
        pulumi.set(__self__, "jre_scan_frequency_in_minutes", jre_scan_frequency_in_minutes)
        if linux_configurations and not isinstance(linux_configurations, list):
            raise TypeError("Expected argument 'linux_configurations' to be a list")
        pulumi.set(__self__, "linux_configurations", linux_configurations)
        if mac_os_configurations and not isinstance(mac_os_configurations, list):
            raise TypeError("Expected argument 'mac_os_configurations' to be a list")
        pulumi.set(__self__, "mac_os_configurations", mac_os_configurations)
        if time_last_modified and not isinstance(time_last_modified, str):
            raise TypeError("Expected argument 'time_last_modified' to be a str")
        pulumi.set(__self__, "time_last_modified", time_last_modified)
        if windows_configurations and not isinstance(windows_configurations, list):
            raise TypeError("Expected argument 'windows_configurations' to be a list")
        pulumi.set(__self__, "windows_configurations", windows_configurations)
        if work_request_validity_period_in_days and not isinstance(work_request_validity_period_in_days, int):
            raise TypeError("Expected argument 'work_request_validity_period_in_days' to be a int")
        pulumi.set(__self__, "work_request_validity_period_in_days", work_request_validity_period_in_days)

    @_builtins.property
    @pulumi.getter(name="agentPollingIntervalInMinutes")
    def agent_polling_interval_in_minutes(self) -> _builtins.int:
        """
        Agent polling interval in minutes
        """
        return pulumi.get(self, "agent_polling_interval_in_minutes")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCapturingIpAddressAndFqdnEnabled")
    def is_capturing_ip_address_and_fqdn_enabled(self) -> _builtins.bool:
        """
        Collect network addresses of managed instances in the fleet.
        """
        return pulumi.get(self, "is_capturing_ip_address_and_fqdn_enabled")

    @_builtins.property
    @pulumi.getter(name="isCollectingManagedInstanceMetricsEnabled")
    def is_collecting_managed_instance_metrics_enabled(self) -> _builtins.bool:
        """
        Collect JMS agent metrics on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_managed_instance_metrics_enabled")

    @_builtins.property
    @pulumi.getter(name="isCollectingUsernamesEnabled")
    def is_collecting_usernames_enabled(self) -> _builtins.bool:
        """
        Collect username for application invocations for all managed instances in the fleet.
        """
        return pulumi.get(self, "is_collecting_usernames_enabled")

    @_builtins.property
    @pulumi.getter(name="isLibrariesScanEnabled")
    def is_libraries_scan_enabled(self) -> _builtins.bool:
        """
        Enable libraries scan on all managed instances in the fleet.
        """
        return pulumi.get(self, "is_libraries_scan_enabled")

    @_builtins.property
    @pulumi.getter(name="javaUsageTrackerProcessingFrequencyInMinutes")
    def java_usage_tracker_processing_frequency_in_minutes(self) -> _builtins.int:
        """
        The frequency (in minutes) of Java Usage Tracker processing. (That is, how often should JMS process data from the Java Usage Tracker.)
        """
        return pulumi.get(self, "java_usage_tracker_processing_frequency_in_minutes")

    @_builtins.property
    @pulumi.getter(name="jreScanFrequencyInMinutes")
    def jre_scan_frequency_in_minutes(self) -> _builtins.int:
        """
        The frequency (in minutes) of JRE scanning. (That is, how often should JMS scan for JRE installations.)
        """
        return pulumi.get(self, "jre_scan_frequency_in_minutes")

    @_builtins.property
    @pulumi.getter(name="linuxConfigurations")
    def linux_configurations(self) -> Sequence['outputs.GetFleetAgentConfigurationLinuxConfigurationResult']:
        """
        Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "linux_configurations")

    @_builtins.property
    @pulumi.getter(name="macOsConfigurations")
    def mac_os_configurations(self) -> Sequence['outputs.GetFleetAgentConfigurationMacOsConfigurationResult']:
        """
        Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "mac_os_configurations")

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> _builtins.str:
        """
        The date and time of the last modification to the Fleet Agent Configuration (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")

    @_builtins.property
    @pulumi.getter(name="windowsConfigurations")
    def windows_configurations(self) -> Sequence['outputs.GetFleetAgentConfigurationWindowsConfigurationResult']:
        """
        Management Agent Configuration for list of include/exclude file system paths (specific to operating system).
        """
        return pulumi.get(self, "windows_configurations")

    @_builtins.property
    @pulumi.getter(name="workRequestValidityPeriodInDays")
    def work_request_validity_period_in_days(self) -> _builtins.int:
        """
        The validity period in days for work requests.
        """
        return pulumi.get(self, "work_request_validity_period_in_days")


class AwaitableGetFleetAgentConfigurationResult(GetFleetAgentConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetAgentConfigurationResult(
            agent_polling_interval_in_minutes=self.agent_polling_interval_in_minutes,
            fleet_id=self.fleet_id,
            id=self.id,
            is_capturing_ip_address_and_fqdn_enabled=self.is_capturing_ip_address_and_fqdn_enabled,
            is_collecting_managed_instance_metrics_enabled=self.is_collecting_managed_instance_metrics_enabled,
            is_collecting_usernames_enabled=self.is_collecting_usernames_enabled,
            is_libraries_scan_enabled=self.is_libraries_scan_enabled,
            java_usage_tracker_processing_frequency_in_minutes=self.java_usage_tracker_processing_frequency_in_minutes,
            jre_scan_frequency_in_minutes=self.jre_scan_frequency_in_minutes,
            linux_configurations=self.linux_configurations,
            mac_os_configurations=self.mac_os_configurations,
            time_last_modified=self.time_last_modified,
            windows_configurations=self.windows_configurations,
            work_request_validity_period_in_days=self.work_request_validity_period_in_days)


def get_fleet_agent_configuration(fleet_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetAgentConfigurationResult:
    """
    This data source provides details about a specific Fleet Agent Configuration resource in Oracle Cloud Infrastructure Jms service.

    Retrieve a Fleet Agent Configuration for the specified Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_agent_configuration = oci.Jms.get_fleet_agent_configuration(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetAgentConfiguration:getFleetAgentConfiguration', __args__, opts=opts, typ=GetFleetAgentConfigurationResult).value

    return AwaitableGetFleetAgentConfigurationResult(
        agent_polling_interval_in_minutes=pulumi.get(__ret__, 'agent_polling_interval_in_minutes'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        is_capturing_ip_address_and_fqdn_enabled=pulumi.get(__ret__, 'is_capturing_ip_address_and_fqdn_enabled'),
        is_collecting_managed_instance_metrics_enabled=pulumi.get(__ret__, 'is_collecting_managed_instance_metrics_enabled'),
        is_collecting_usernames_enabled=pulumi.get(__ret__, 'is_collecting_usernames_enabled'),
        is_libraries_scan_enabled=pulumi.get(__ret__, 'is_libraries_scan_enabled'),
        java_usage_tracker_processing_frequency_in_minutes=pulumi.get(__ret__, 'java_usage_tracker_processing_frequency_in_minutes'),
        jre_scan_frequency_in_minutes=pulumi.get(__ret__, 'jre_scan_frequency_in_minutes'),
        linux_configurations=pulumi.get(__ret__, 'linux_configurations'),
        mac_os_configurations=pulumi.get(__ret__, 'mac_os_configurations'),
        time_last_modified=pulumi.get(__ret__, 'time_last_modified'),
        windows_configurations=pulumi.get(__ret__, 'windows_configurations'),
        work_request_validity_period_in_days=pulumi.get(__ret__, 'work_request_validity_period_in_days'))
def get_fleet_agent_configuration_output(fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetAgentConfigurationResult]:
    """
    This data source provides details about a specific Fleet Agent Configuration resource in Oracle Cloud Infrastructure Jms service.

    Retrieve a Fleet Agent Configuration for the specified Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_agent_configuration = oci.Jms.get_fleet_agent_configuration(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetAgentConfiguration:getFleetAgentConfiguration', __args__, opts=opts, typ=GetFleetAgentConfigurationResult)
    return __ret__.apply(lambda __response__: GetFleetAgentConfigurationResult(
        agent_polling_interval_in_minutes=pulumi.get(__response__, 'agent_polling_interval_in_minutes'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        is_capturing_ip_address_and_fqdn_enabled=pulumi.get(__response__, 'is_capturing_ip_address_and_fqdn_enabled'),
        is_collecting_managed_instance_metrics_enabled=pulumi.get(__response__, 'is_collecting_managed_instance_metrics_enabled'),
        is_collecting_usernames_enabled=pulumi.get(__response__, 'is_collecting_usernames_enabled'),
        is_libraries_scan_enabled=pulumi.get(__response__, 'is_libraries_scan_enabled'),
        java_usage_tracker_processing_frequency_in_minutes=pulumi.get(__response__, 'java_usage_tracker_processing_frequency_in_minutes'),
        jre_scan_frequency_in_minutes=pulumi.get(__response__, 'jre_scan_frequency_in_minutes'),
        linux_configurations=pulumi.get(__response__, 'linux_configurations'),
        mac_os_configurations=pulumi.get(__response__, 'mac_os_configurations'),
        time_last_modified=pulumi.get(__response__, 'time_last_modified'),
        windows_configurations=pulumi.get(__response__, 'windows_configurations'),
        work_request_validity_period_in_days=pulumi.get(__response__, 'work_request_validity_period_in_days')))
