# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetLibraryManagedInstancesResult',
    'AwaitableGetFleetLibraryManagedInstancesResult',
    'get_fleet_library_managed_instances',
    'get_fleet_library_managed_instances_output',
]

@pulumi.output_type
class GetFleetLibraryManagedInstancesResult:
    """
    A collection of values returned by getFleetLibraryManagedInstances.
    """
    def __init__(__self__, application_id=None, filters=None, fleet_id=None, host_name=None, hostname_contains=None, id=None, library_key=None, library_managed_instance_usage_collections=None, managed_instance_id=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if hostname_contains and not isinstance(hostname_contains, str):
            raise TypeError("Expected argument 'hostname_contains' to be a str")
        pulumi.set(__self__, "hostname_contains", hostname_contains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if library_key and not isinstance(library_key, str):
            raise TypeError("Expected argument 'library_key' to be a str")
        pulumi.set(__self__, "library_key", library_key)
        if library_managed_instance_usage_collections and not isinstance(library_managed_instance_usage_collections, list):
            raise TypeError("Expected argument 'library_managed_instance_usage_collections' to be a list")
        pulumi.set(__self__, "library_managed_instance_usage_collections", library_managed_instance_usage_collections)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetLibraryManagedInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hostnameContains")
    def hostname_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "hostname_contains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="libraryKey")
    def library_key(self) -> _builtins.str:
        return pulumi.get(self, "library_key")

    @_builtins.property
    @pulumi.getter(name="libraryManagedInstanceUsageCollections")
    def library_managed_instance_usage_collections(self) -> Sequence['outputs.GetFleetLibraryManagedInstancesLibraryManagedInstanceUsageCollectionResult']:
        """
        The list of library_managed_instance_usage_collection.
        """
        return pulumi.get(self, "library_managed_instance_usage_collections")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_end")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetLibraryManagedInstancesResult(GetFleetLibraryManagedInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetLibraryManagedInstancesResult(
            application_id=self.application_id,
            filters=self.filters,
            fleet_id=self.fleet_id,
            host_name=self.host_name,
            hostname_contains=self.hostname_contains,
            id=self.id,
            library_key=self.library_key,
            library_managed_instance_usage_collections=self.library_managed_instance_usage_collections,
            managed_instance_id=self.managed_instance_id,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_library_managed_instances(application_id: Optional[_builtins.str] = None,
                                        filters: Optional[Sequence[Union['GetFleetLibraryManagedInstancesFilterArgs', 'GetFleetLibraryManagedInstancesFilterArgsDict']]] = None,
                                        fleet_id: Optional[_builtins.str] = None,
                                        host_name: Optional[_builtins.str] = None,
                                        hostname_contains: Optional[_builtins.str] = None,
                                        library_key: Optional[_builtins.str] = None,
                                        managed_instance_id: Optional[_builtins.str] = None,
                                        time_end: Optional[_builtins.str] = None,
                                        time_start: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetLibraryManagedInstancesResult:
    """
    This data source provides the list of Fleet Library Managed Instances in Oracle Cloud Infrastructure Jms service.

    List managed instances where a library has been detected, filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_library_managed_instances = oci.Jms.get_fleet_library_managed_instances(fleet_id=test_fleet["id"],
        library_key=fleet_library_managed_instance_library_key,
        application_id=test_application["id"],
        host_name=fleet_library_managed_instance_host_name,
        hostname_contains=fleet_library_managed_instance_hostname_contains,
        managed_instance_id=test_managed_instance["id"],
        time_end=fleet_library_managed_instance_time_end,
        time_start=fleet_library_managed_instance_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param _builtins.str hostname_contains: Filter the list with hostname contains the given value.
    :param _builtins.str library_key: The unique identifier of a Java library.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['hostnameContains'] = hostname_contains
    __args__['libraryKey'] = library_key
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetLibraryManagedInstances:getFleetLibraryManagedInstances', __args__, opts=opts, typ=GetFleetLibraryManagedInstancesResult).value

    return AwaitableGetFleetLibraryManagedInstancesResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        hostname_contains=pulumi.get(__ret__, 'hostname_contains'),
        id=pulumi.get(__ret__, 'id'),
        library_key=pulumi.get(__ret__, 'library_key'),
        library_managed_instance_usage_collections=pulumi.get(__ret__, 'library_managed_instance_usage_collections'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_fleet_library_managed_instances_output(application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetLibraryManagedInstancesFilterArgs', 'GetFleetLibraryManagedInstancesFilterArgsDict']]]]] = None,
                                               fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                               host_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               hostname_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               library_key: Optional[pulumi.Input[_builtins.str]] = None,
                                               managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               time_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               time_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetLibraryManagedInstancesResult]:
    """
    This data source provides the list of Fleet Library Managed Instances in Oracle Cloud Infrastructure Jms service.

    List managed instances where a library has been detected, filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_library_managed_instances = oci.Jms.get_fleet_library_managed_instances(fleet_id=test_fleet["id"],
        library_key=fleet_library_managed_instance_library_key,
        application_id=test_application["id"],
        host_name=fleet_library_managed_instance_host_name,
        hostname_contains=fleet_library_managed_instance_hostname_contains,
        managed_instance_id=test_managed_instance["id"],
        time_end=fleet_library_managed_instance_time_end,
        time_start=fleet_library_managed_instance_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param _builtins.str hostname_contains: Filter the list with hostname contains the given value.
    :param _builtins.str library_key: The unique identifier of a Java library.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['hostnameContains'] = hostname_contains
    __args__['libraryKey'] = library_key
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetLibraryManagedInstances:getFleetLibraryManagedInstances', __args__, opts=opts, typ=GetFleetLibraryManagedInstancesResult)
    return __ret__.apply(lambda __response__: GetFleetLibraryManagedInstancesResult(
        application_id=pulumi.get(__response__, 'application_id'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        host_name=pulumi.get(__response__, 'host_name'),
        hostname_contains=pulumi.get(__response__, 'hostname_contains'),
        id=pulumi.get(__response__, 'id'),
        library_key=pulumi.get(__response__, 'library_key'),
        library_managed_instance_usage_collections=pulumi.get(__response__, 'library_managed_instance_usage_collections'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
