# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetUncorrelatedPackagesResult',
    'AwaitableGetFleetUncorrelatedPackagesResult',
    'get_fleet_uncorrelated_packages',
    'get_fleet_uncorrelated_packages_output',
]

@pulumi.output_type
class GetFleetUncorrelatedPackagesResult:
    """
    A collection of values returned by getFleetUncorrelatedPackages.
    """
    def __init__(__self__, application_id=None, filters=None, fleet_id=None, id=None, managed_instance_id=None, package_name=None, time_end=None, time_start=None, uncorrelated_package_usage_collections=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)
        if uncorrelated_package_usage_collections and not isinstance(uncorrelated_package_usage_collections, list):
            raise TypeError("Expected argument 'uncorrelated_package_usage_collections' to be a list")
        pulumi.set(__self__, "uncorrelated_package_usage_collections", uncorrelated_package_usage_collections)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetUncorrelatedPackagesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[_builtins.str]:
        """
        The name of the package.
        """
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_end")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_start")

    @_builtins.property
    @pulumi.getter(name="uncorrelatedPackageUsageCollections")
    def uncorrelated_package_usage_collections(self) -> Sequence['outputs.GetFleetUncorrelatedPackagesUncorrelatedPackageUsageCollectionResult']:
        """
        The list of uncorrelated_package_usage_collection.
        """
        return pulumi.get(self, "uncorrelated_package_usage_collections")


class AwaitableGetFleetUncorrelatedPackagesResult(GetFleetUncorrelatedPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetUncorrelatedPackagesResult(
            application_id=self.application_id,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            package_name=self.package_name,
            time_end=self.time_end,
            time_start=self.time_start,
            uncorrelated_package_usage_collections=self.uncorrelated_package_usage_collections)


def get_fleet_uncorrelated_packages(application_id: Optional[_builtins.str] = None,
                                    filters: Optional[Sequence[Union['GetFleetUncorrelatedPackagesFilterArgs', 'GetFleetUncorrelatedPackagesFilterArgsDict']]] = None,
                                    fleet_id: Optional[_builtins.str] = None,
                                    managed_instance_id: Optional[_builtins.str] = None,
                                    package_name: Optional[_builtins.str] = None,
                                    time_end: Optional[_builtins.str] = None,
                                    time_start: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetUncorrelatedPackagesResult:
    """
    This data source provides the list of Fleet Uncorrelated Packages in Oracle Cloud Infrastructure Jms service.

    List uncorrelated package summaries in a fleet, filtered by query parameters. Uncorrelated packages are Java packages which can't be accurately correlated to a library during a library scan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_uncorrelated_packages = oci.Jms.get_fleet_uncorrelated_packages(fleet_id=test_fleet["id"],
        application_id=test_application["id"],
        managed_instance_id=test_managed_instance["id"],
        package_name=fleet_uncorrelated_package_package_name,
        time_end=fleet_uncorrelated_package_time_end,
        time_start=fleet_uncorrelated_package_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str package_name: The unique identifier of a Java package.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['packageName'] = package_name
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetUncorrelatedPackages:getFleetUncorrelatedPackages', __args__, opts=opts, typ=GetFleetUncorrelatedPackagesResult).value

    return AwaitableGetFleetUncorrelatedPackagesResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        package_name=pulumi.get(__ret__, 'package_name'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'),
        uncorrelated_package_usage_collections=pulumi.get(__ret__, 'uncorrelated_package_usage_collections'))
def get_fleet_uncorrelated_packages_output(application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetUncorrelatedPackagesFilterArgs', 'GetFleetUncorrelatedPackagesFilterArgsDict']]]]] = None,
                                           fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           package_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           time_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           time_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetUncorrelatedPackagesResult]:
    """
    This data source provides the list of Fleet Uncorrelated Packages in Oracle Cloud Infrastructure Jms service.

    List uncorrelated package summaries in a fleet, filtered by query parameters. Uncorrelated packages are Java packages which can't be accurately correlated to a library during a library scan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_uncorrelated_packages = oci.Jms.get_fleet_uncorrelated_packages(fleet_id=test_fleet["id"],
        application_id=test_application["id"],
        managed_instance_id=test_managed_instance["id"],
        package_name=fleet_uncorrelated_package_package_name,
        time_end=fleet_uncorrelated_package_time_end,
        time_start=fleet_uncorrelated_package_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str package_name: The unique identifier of a Java package.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['packageName'] = package_name
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetUncorrelatedPackages:getFleetUncorrelatedPackages', __args__, opts=opts, typ=GetFleetUncorrelatedPackagesResult)
    return __ret__.apply(lambda __response__: GetFleetUncorrelatedPackagesResult(
        application_id=pulumi.get(__response__, 'application_id'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        package_name=pulumi.get(__response__, 'package_name'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start'),
        uncorrelated_package_usage_collections=pulumi.get(__response__, 'uncorrelated_package_usage_collections')))
