# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JavaDownloadsJavaDownloadTokenArgs', 'JavaDownloadsJavaDownloadToken']

@pulumi.input_type
class JavaDownloadsJavaDownloadTokenArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 java_version: pulumi.Input[_builtins.str],
                 license_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 time_expires: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a JavaDownloadsJavaDownloadToken resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) User provided display name of the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] java_version: The Java version associated with the token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] license_types: (Updatable) The license type(s) associated with the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] time_expires: (Updatable) Expiry time of the token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) The token default attribute.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "java_version", java_version)
        pulumi.set(__self__, "license_types", license_types)
        pulumi.set(__self__, "time_expires", time_expires)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) User provided description of the JavaDownloadToken.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) User provided display name of the JavaDownloadToken.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> pulumi.Input[_builtins.str]:
        """
        The Java version associated with the token.
        """
        return pulumi.get(self, "java_version")

    @java_version.setter
    def java_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "java_version", value)

    @_builtins.property
    @pulumi.getter(name="licenseTypes")
    def license_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) The license type(s) associated with the JavaDownloadToken.
        """
        return pulumi.get(self, "license_types")

    @license_types.setter
    def license_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "license_types", value)

    @_builtins.property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Expiry time of the token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_expires")

    @time_expires.setter
    def time_expires(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_expires", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) The token default attribute.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)


@pulumi.input_type
class _JavaDownloadsJavaDownloadTokenState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenCreatedByArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_version: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_bies: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs']]]] = None,
                 license_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_expires: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_used: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering JavaDownloadsJavaDownloadToken resources.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        :param pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenCreatedByArgs']]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) User provided display name of the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) The token default attribute.
        :param pulumi.Input[_builtins.str] java_version: The Java version associated with the token.
        :param pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs']]] last_updated_bies: An authorized principal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] license_types: (Updatable) The license type(s) associated with the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] lifecycle_details: Possible lifecycle substates.
        :param pulumi.Input[_builtins.str] state: The current state of the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the JavaDownloadToken was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_expires: (Updatable) Expiry time of the token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_last_used: The time the JavaDownloadToken was last used for download, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the JavaDownloadToken was updated, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] value: Uniquely generated value for the JavaDownloadToken.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies is not None:
            pulumi.set(__self__, "created_bies", created_bies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if java_version is not None:
            pulumi.set(__self__, "java_version", java_version)
        if last_updated_bies is not None:
            pulumi.set(__self__, "last_updated_bies", last_updated_bies)
        if license_types is not None:
            pulumi.set(__self__, "license_types", license_types)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_expires is not None:
            pulumi.set(__self__, "time_expires", time_expires)
        if time_last_used is not None:
            pulumi.set(__self__, "time_last_used", time_last_used)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenCreatedByArgs']]]]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @created_bies.setter
    def created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenCreatedByArgs']]]]):
        pulumi.set(self, "created_bies", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User provided description of the JavaDownloadToken.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) User provided display name of the JavaDownloadToken.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) The token default attribute.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Java version associated with the token.
        """
        return pulumi.get(self, "java_version")

    @java_version.setter
    def java_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "java_version", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBies")
    def last_updated_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs']]]]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "last_updated_bies")

    @last_updated_bies.setter
    def last_updated_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs']]]]):
        pulumi.set(self, "last_updated_bies", value)

    @_builtins.property
    @pulumi.getter(name="licenseTypes")
    def license_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The license type(s) associated with the JavaDownloadToken.
        """
        return pulumi.get(self, "license_types")

    @license_types.setter
    def license_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "license_types", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible lifecycle substates.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the JavaDownloadToken.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the JavaDownloadToken was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Expiry time of the token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_expires")

    @time_expires.setter
    def time_expires(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_expires", value)

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the JavaDownloadToken was last used for download, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_last_used")

    @time_last_used.setter
    def time_last_used(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_used", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the JavaDownloadToken was updated, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Uniquely generated value for the JavaDownloadToken.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("oci:Jms/javaDownloadsJavaDownloadToken:JavaDownloadsJavaDownloadToken")
class JavaDownloadsJavaDownloadToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_version: Optional[pulumi.Input[_builtins.str]] = None,
                 license_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_expires: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_download_token = oci.jms.JavaDownloadsJavaDownloadToken("test_java_download_token",
            compartment_id=tenancy_ocid,
            description=java_download_token_description,
            display_name=java_download_token_display_name,
            java_version=java_download_token_java_version,
            license_types=java_download_token_license_type,
            time_expires=java_download_token_time_expires,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_default=java_download_token_is_default)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) User provided display name of the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) The token default attribute.
        :param pulumi.Input[_builtins.str] java_version: The Java version associated with the token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] license_types: (Updatable) The license type(s) associated with the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] time_expires: (Updatable) Expiry time of the token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JavaDownloadsJavaDownloadTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_download_token = oci.jms.JavaDownloadsJavaDownloadToken("test_java_download_token",
            compartment_id=tenancy_ocid,
            description=java_download_token_description,
            display_name=java_download_token_display_name,
            java_version=java_download_token_java_version,
            license_types=java_download_token_license_type,
            time_expires=java_download_token_time_expires,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_default=java_download_token_is_default)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param JavaDownloadsJavaDownloadTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JavaDownloadsJavaDownloadTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 java_version: Optional[pulumi.Input[_builtins.str]] = None,
                 license_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_expires: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JavaDownloadsJavaDownloadTokenArgs.__new__(JavaDownloadsJavaDownloadTokenArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_default"] = is_default
            if java_version is None and not opts.urn:
                raise TypeError("Missing required property 'java_version'")
            __props__.__dict__["java_version"] = java_version
            if license_types is None and not opts.urn:
                raise TypeError("Missing required property 'license_types'")
            __props__.__dict__["license_types"] = license_types
            if time_expires is None and not opts.urn:
                raise TypeError("Missing required property 'time_expires'")
            __props__.__dict__["time_expires"] = time_expires
            __props__.__dict__["created_bies"] = None
            __props__.__dict__["last_updated_bies"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_used"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["value"] = None
        super(JavaDownloadsJavaDownloadToken, __self__).__init__(
            'oci:Jms/javaDownloadsJavaDownloadToken:JavaDownloadsJavaDownloadToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadTokenCreatedByArgs', 'JavaDownloadsJavaDownloadTokenCreatedByArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            java_version: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs', 'JavaDownloadsJavaDownloadTokenLastUpdatedByArgsDict']]]]] = None,
            license_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_expires: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_used: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'JavaDownloadsJavaDownloadToken':
        """
        Get an existing JavaDownloadsJavaDownloadToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadTokenCreatedByArgs', 'JavaDownloadsJavaDownloadTokenCreatedByArgsDict']]]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[_builtins.str] description: (Updatable) User provided description of the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) User provided display name of the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[_builtins.bool] is_default: (Updatable) The token default attribute.
        :param pulumi.Input[_builtins.str] java_version: The Java version associated with the token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadTokenLastUpdatedByArgs', 'JavaDownloadsJavaDownloadTokenLastUpdatedByArgsDict']]]] last_updated_bies: An authorized principal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] license_types: (Updatable) The license type(s) associated with the JavaDownloadToken.
        :param pulumi.Input[_builtins.str] lifecycle_details: Possible lifecycle substates.
        :param pulumi.Input[_builtins.str] state: The current state of the JavaDownloadToken.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the JavaDownloadToken was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_expires: (Updatable) Expiry time of the token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_last_used: The time the JavaDownloadToken was last used for download, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time the JavaDownloadToken was updated, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] value: Uniquely generated value for the JavaDownloadToken.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JavaDownloadsJavaDownloadTokenState.__new__(_JavaDownloadsJavaDownloadTokenState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_bies"] = created_bies
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["java_version"] = java_version
        __props__.__dict__["last_updated_bies"] = last_updated_bies
        __props__.__dict__["license_types"] = license_types
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_expires"] = time_expires
        __props__.__dict__["time_last_used"] = time_last_used
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["value"] = value
        return JavaDownloadsJavaDownloadToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the JavaDownloadToken.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> pulumi.Output[Sequence['outputs.JavaDownloadsJavaDownloadTokenCreatedBy']]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) User provided description of the JavaDownloadToken.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) User provided display name of the JavaDownloadToken.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) The token default attribute.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> pulumi.Output[_builtins.str]:
        """
        The Java version associated with the token.
        """
        return pulumi.get(self, "java_version")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBies")
    def last_updated_bies(self) -> pulumi.Output[Sequence['outputs.JavaDownloadsJavaDownloadTokenLastUpdatedBy']]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "last_updated_bies")

    @_builtins.property
    @pulumi.getter(name="licenseTypes")
    def license_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The license type(s) associated with the JavaDownloadToken.
        """
        return pulumi.get(self, "license_types")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Possible lifecycle substates.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the JavaDownloadToken.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the JavaDownloadToken was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Expiry time of the token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_expires")

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> pulumi.Output[_builtins.str]:
        """
        The time the JavaDownloadToken was last used for download, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_last_used")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the JavaDownloadToken was updated, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Uniquely generated value for the JavaDownloadToken.
        """
        return pulumi.get(self, "value")

