# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UtilsAnalyzeApplicationsConfigurationArgs', 'UtilsAnalyzeApplicationsConfiguration']

@pulumi.input_type
class UtilsAnalyzeApplicationsConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UtilsAnalyzeApplicationsConfiguration resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] bucket: (Updatable) The name of the bucket used for analyzing applications.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The Object Storage namespace used for analyzing applications.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the bucket used for analyzing applications.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Object Storage namespace used for analyzing applications.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _UtilsAnalyzeApplicationsConfigurationState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UtilsAnalyzeApplicationsConfiguration resources.
        :param pulumi.Input[_builtins.str] bucket: (Updatable) The name of the bucket used for analyzing applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The Object Storage namespace used for analyzing applications.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the bucket used for analyzing applications.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Object Storage namespace used for analyzing applications.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.type_token("oci:Jms/utilsAnalyzeApplicationsConfiguration:UtilsAnalyzeApplicationsConfiguration")
class UtilsAnalyzeApplicationsConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Analyze Applications Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

        Updates the configuration for analyze application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analyze_applications_configuration = oci.jms.UtilsAnalyzeApplicationsConfiguration("test_analyze_applications_configuration",
            bucket=analyze_applications_configuration_bucket,
            compartment_id=compartment_id,
            namespace=analyze_applications_configuration_namespace)
        ```

        ## Import

        AnalyzeApplicationsConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/utilsAnalyzeApplicationsConfiguration:UtilsAnalyzeApplicationsConfiguration test_analyze_applications_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: (Updatable) The name of the bucket used for analyzing applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The Object Storage namespace used for analyzing applications.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UtilsAnalyzeApplicationsConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Analyze Applications Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

        Updates the configuration for analyze application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analyze_applications_configuration = oci.jms.UtilsAnalyzeApplicationsConfiguration("test_analyze_applications_configuration",
            bucket=analyze_applications_configuration_bucket,
            compartment_id=compartment_id,
            namespace=analyze_applications_configuration_namespace)
        ```

        ## Import

        AnalyzeApplicationsConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/utilsAnalyzeApplicationsConfiguration:UtilsAnalyzeApplicationsConfiguration test_analyze_applications_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param UtilsAnalyzeApplicationsConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UtilsAnalyzeApplicationsConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UtilsAnalyzeApplicationsConfigurationArgs.__new__(UtilsAnalyzeApplicationsConfigurationArgs)

            __props__.__dict__["bucket"] = bucket
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["namespace"] = namespace
        super(UtilsAnalyzeApplicationsConfiguration, __self__).__init__(
            'oci:Jms/utilsAnalyzeApplicationsConfiguration:UtilsAnalyzeApplicationsConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None) -> 'UtilsAnalyzeApplicationsConfiguration':
        """
        Get an existing UtilsAnalyzeApplicationsConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: (Updatable) The name of the bucket used for analyzing applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.str] namespace: (Updatable) The Object Storage namespace used for analyzing applications.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UtilsAnalyzeApplicationsConfigurationState.__new__(_UtilsAnalyzeApplicationsConfigurationState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["namespace"] = namespace
        return UtilsAnalyzeApplicationsConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the bucket used for analyzing applications.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The Object Storage namespace used for analyzing applications.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

