# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UtilsSubscriptionAcknowledgmentConfigurationArgs', 'UtilsSubscriptionAcknowledgmentConfiguration']

@pulumi.input_type
class UtilsSubscriptionAcknowledgmentConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 is_acknowledged: pulumi.Input[_builtins.bool]):
        """
        The set of arguments for constructing a UtilsSubscriptionAcknowledgmentConfiguration resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.bool] is_acknowledged: (Updatable) Flag to determine whether the subscription was acknowledged or not.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_acknowledged", is_acknowledged)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="isAcknowledged")
    def is_acknowledged(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Flag to determine whether the subscription was acknowledged or not.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_acknowledged")

    @is_acknowledged.setter
    def is_acknowledged(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_acknowledged", value)


@pulumi.input_type
class _UtilsSubscriptionAcknowledgmentConfigurationState:
    def __init__(__self__, *,
                 acknowledged_by: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_acknowledged: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UtilsSubscriptionAcknowledgmentConfiguration resources.
        :param pulumi.Input[_builtins.str] acknowledged_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal that ackwnoledged the subscription.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.bool] is_acknowledged: (Updatable) Flag to determine whether the subscription was acknowledged or not.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_acknowledged: The date and time the subscription was acknowledged (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        if acknowledged_by is not None:
            pulumi.set(__self__, "acknowledged_by", acknowledged_by)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_acknowledged is not None:
            pulumi.set(__self__, "is_acknowledged", is_acknowledged)
        if time_acknowledged is not None:
            pulumi.set(__self__, "time_acknowledged", time_acknowledged)

    @_builtins.property
    @pulumi.getter(name="acknowledgedBy")
    def acknowledged_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal that ackwnoledged the subscription.
        """
        return pulumi.get(self, "acknowledged_by")

    @acknowledged_by.setter
    def acknowledged_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acknowledged_by", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="isAcknowledged")
    def is_acknowledged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Flag to determine whether the subscription was acknowledged or not.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_acknowledged")

    @is_acknowledged.setter
    def is_acknowledged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_acknowledged", value)

    @_builtins.property
    @pulumi.getter(name="timeAcknowledged")
    def time_acknowledged(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the subscription was acknowledged (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_acknowledged")

    @time_acknowledged.setter
    def time_acknowledged(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_acknowledged", value)


@pulumi.type_token("oci:Jms/utilsSubscriptionAcknowledgmentConfiguration:UtilsSubscriptionAcknowledgmentConfiguration")
class UtilsSubscriptionAcknowledgmentConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Subscription Acknowledgment Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

        Updates the configuration for subscription acknowledgment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subscription_acknowledgment_configuration = oci.jms.UtilsSubscriptionAcknowledgmentConfiguration("test_subscription_acknowledgment_configuration",
            compartment_id=compartment_id,
            is_acknowledged=subscription_acknowledgment_configuration_is_acknowledged)
        ```

        ## Import

        SubscriptionAcknowledgmentConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/utilsSubscriptionAcknowledgmentConfiguration:UtilsSubscriptionAcknowledgmentConfiguration test_subscription_acknowledgment_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.bool] is_acknowledged: (Updatable) Flag to determine whether the subscription was acknowledged or not.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UtilsSubscriptionAcknowledgmentConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Subscription Acknowledgment Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

        Updates the configuration for subscription acknowledgment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subscription_acknowledgment_configuration = oci.jms.UtilsSubscriptionAcknowledgmentConfiguration("test_subscription_acknowledgment_configuration",
            compartment_id=compartment_id,
            is_acknowledged=subscription_acknowledgment_configuration_is_acknowledged)
        ```

        ## Import

        SubscriptionAcknowledgmentConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/utilsSubscriptionAcknowledgmentConfiguration:UtilsSubscriptionAcknowledgmentConfiguration test_subscription_acknowledgment_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param UtilsSubscriptionAcknowledgmentConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UtilsSubscriptionAcknowledgmentConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UtilsSubscriptionAcknowledgmentConfigurationArgs.__new__(UtilsSubscriptionAcknowledgmentConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if is_acknowledged is None and not opts.urn:
                raise TypeError("Missing required property 'is_acknowledged'")
            __props__.__dict__["is_acknowledged"] = is_acknowledged
            __props__.__dict__["acknowledged_by"] = None
            __props__.__dict__["time_acknowledged"] = None
        super(UtilsSubscriptionAcknowledgmentConfiguration, __self__).__init__(
            'oci:Jms/utilsSubscriptionAcknowledgmentConfiguration:UtilsSubscriptionAcknowledgmentConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledged_by: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_acknowledged: Optional[pulumi.Input[_builtins.bool]] = None,
            time_acknowledged: Optional[pulumi.Input[_builtins.str]] = None) -> 'UtilsSubscriptionAcknowledgmentConfiguration':
        """
        Get an existing UtilsSubscriptionAcknowledgmentConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acknowledged_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal that ackwnoledged the subscription.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param pulumi.Input[_builtins.bool] is_acknowledged: (Updatable) Flag to determine whether the subscription was acknowledged or not.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_acknowledged: The date and time the subscription was acknowledged (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UtilsSubscriptionAcknowledgmentConfigurationState.__new__(_UtilsSubscriptionAcknowledgmentConfigurationState)

        __props__.__dict__["acknowledged_by"] = acknowledged_by
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_acknowledged"] = is_acknowledged
        __props__.__dict__["time_acknowledged"] = time_acknowledged
        return UtilsSubscriptionAcknowledgmentConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acknowledgedBy")
    def acknowledged_by(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal that ackwnoledged the subscription.
        """
        return pulumi.get(self, "acknowledged_by")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="isAcknowledged")
    def is_acknowledged(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Flag to determine whether the subscription was acknowledged or not.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_acknowledged")

    @_builtins.property
    @pulumi.getter(name="timeAcknowledged")
    def time_acknowledged(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the subscription was acknowledged (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_acknowledged")

