# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyVersionArgs', 'KeyVersion']

@pulumi.input_type
class KeyVersionArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[_builtins.str],
                 management_endpoint: pulumi.Input[_builtins.str],
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeyVersion resource.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @external_key_version_id.setter
    def external_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_version_id", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)


@pulumi.input_type
class _KeyVersionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key_reference_details: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionExternalKeyReferenceDetailArgs']]]] = None,
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_rotated: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_details: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionReplicaDetailArgs']]]] = None,
                 restored_from_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restored_from_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyVersion resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains this key version.
        :param pulumi.Input[Sequence[pulumi.Input['KeyVersionExternalKeyReferenceDetailArgs']]] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        :param pulumi.Input[_builtins.bool] is_auto_rotated: An optional property indicating whether this keyversion is generated from auto rotatation.
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] public_key: The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        :param pulumi.Input[Sequence[pulumi.Input['KeyVersionReplicaDetailArgs']]] replica_details: KeyVersion replica details
        :param pulumi.Input[_builtins.str] restored_from_key_version_id: The OCID of the key version from which this key version was restored.
        :param pulumi.Input[_builtins.str] state: The key version's current lifecycle state.  Example: `ENABLED`
        :param pulumi.Input[_builtins.str] time_created: The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault that contains this key version.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if external_key_reference_details is not None:
            pulumi.set(__self__, "external_key_reference_details", external_key_reference_details)
        if external_key_version_id is not None:
            pulumi.set(__self__, "external_key_version_id", external_key_version_id)
        if is_auto_rotated is not None:
            pulumi.set(__self__, "is_auto_rotated", is_auto_rotated)
        if is_primary is not None:
            pulumi.set(__self__, "is_primary", is_primary)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_version_id is not None:
            pulumi.set(__self__, "key_version_id", key_version_id)
        if management_endpoint is not None:
            pulumi.set(__self__, "management_endpoint", management_endpoint)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if replica_details is not None:
            pulumi.set(__self__, "replica_details", replica_details)
        if restored_from_key_id is not None:
            pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        if restored_from_key_version_id is not None:
            pulumi.set(__self__, "restored_from_key_version_id", restored_from_key_version_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionExternalKeyReferenceDetailArgs']]]]:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @external_key_reference_details.setter
    def external_key_reference_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionExternalKeyReferenceDetailArgs']]]]):
        pulumi.set(self, "external_key_reference_details", value)

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @external_key_version_id.setter
    def external_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key_version_id", value)

    @_builtins.property
    @pulumi.getter(name="isAutoRotated")
    def is_auto_rotated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        An optional property indicating whether this keyversion is generated from auto rotatation.
        """
        return pulumi.get(self, "is_auto_rotated")

    @is_auto_rotated.setter
    def is_auto_rotated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_rotated", value)

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_primary", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_version_id")

    @key_version_id.setter
    def key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_version_id", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionReplicaDetailArgs']]]]:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @replica_details.setter
    def replica_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVersionReplicaDetailArgs']]]]):
        pulumi.set(self, "replica_details", value)

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "restored_from_key_id")

    @restored_from_key_id.setter
    def restored_from_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restored_from_key_id", value)

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @restored_from_key_version_id.setter
    def restored_from_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restored_from_key_version_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("oci:Kms/keyVersion:KeyVersion")
class KeyVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        KeyVersions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/keyVersion:KeyVersion test_key_version "managementEndpoint/{managementEndpoint}/keys/{keyId}/keyVersions/{keyVersionId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        KeyVersions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Kms/keyVersion:KeyVersion test_key_version "managementEndpoint/{managementEndpoint}/keys/{keyId}/keyVersions/{keyVersionId}"
        ```

        :param str resource_name: The name of the resource.
        :param KeyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyVersionArgs.__new__(KeyVersionArgs)

            __props__.__dict__["external_key_version_id"] = external_key_version_id
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if management_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'management_endpoint'")
            __props__.__dict__["management_endpoint"] = management_endpoint
            __props__.__dict__["time_of_deletion"] = time_of_deletion
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["external_key_reference_details"] = None
            __props__.__dict__["is_auto_rotated"] = None
            __props__.__dict__["is_primary"] = None
            __props__.__dict__["key_version_id"] = None
            __props__.__dict__["public_key"] = None
            __props__.__dict__["replica_details"] = None
            __props__.__dict__["restored_from_key_id"] = None
            __props__.__dict__["restored_from_key_version_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vault_id"] = None
        super(KeyVersion, __self__).__init__(
            'oci:Kms/keyVersion:KeyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_key_reference_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVersionExternalKeyReferenceDetailArgs', 'KeyVersionExternalKeyReferenceDetailArgsDict']]]]] = None,
            external_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_auto_rotated: Optional[pulumi.Input[_builtins.bool]] = None,
            is_primary: Optional[pulumi.Input[_builtins.bool]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            replica_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVersionReplicaDetailArgs', 'KeyVersionReplicaDetailArgsDict']]]]] = None,
            restored_from_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            restored_from_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyVersion':
        """
        Get an existing KeyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains this key version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyVersionExternalKeyReferenceDetailArgs', 'KeyVersionExternalKeyReferenceDetailArgsDict']]]] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param pulumi.Input[_builtins.str] external_key_version_id: Key version ID associated with the external key.
        :param pulumi.Input[_builtins.bool] is_auto_rotated: An optional property indicating whether this keyversion is generated from auto rotatation.
        :param pulumi.Input[_builtins.bool] is_primary: A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        :param pulumi.Input[_builtins.str] key_id: The OCID of the key.
        :param pulumi.Input[_builtins.str] management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param pulumi.Input[_builtins.str] public_key: The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyVersionReplicaDetailArgs', 'KeyVersionReplicaDetailArgsDict']]]] replica_details: KeyVersion replica details
        :param pulumi.Input[_builtins.str] restored_from_key_version_id: The OCID of the key version from which this key version was restored.
        :param pulumi.Input[_builtins.str] state: The key version's current lifecycle state.  Example: `ENABLED`
        :param pulumi.Input[_builtins.str] time_created: The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        :param pulumi.Input[_builtins.str] time_of_deletion: (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] vault_id: The OCID of the vault that contains this key version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyVersionState.__new__(_KeyVersionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["external_key_reference_details"] = external_key_reference_details
        __props__.__dict__["external_key_version_id"] = external_key_version_id
        __props__.__dict__["is_auto_rotated"] = is_auto_rotated
        __props__.__dict__["is_primary"] = is_primary
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_version_id"] = key_version_id
        __props__.__dict__["management_endpoint"] = management_endpoint
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["replica_details"] = replica_details
        __props__.__dict__["restored_from_key_id"] = restored_from_key_id
        __props__.__dict__["restored_from_key_version_id"] = restored_from_key_version_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["vault_id"] = vault_id
        return KeyVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> pulumi.Output[Sequence['outputs.KeyVersionExternalKeyReferenceDetail']]:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @_builtins.property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @_builtins.property
    @pulumi.getter(name="isAutoRotated")
    def is_auto_rotated(self) -> pulumi.Output[_builtins.bool]:
        """
        An optional property indicating whether this keyversion is generated from auto rotatation.
        """
        return pulumi.get(self, "is_auto_rotated")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Output[_builtins.bool]:
        """
        A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "key_version_id")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> pulumi.Output[Sequence['outputs.KeyVersionReplicaDetail']]:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "restored_from_key_id")

    @_builtins.property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional property for the deletion time of the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_of_deletion")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")

