# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'QuotaLock',
    'GetLimitDefinitionsFilterResult',
    'GetLimitDefinitionsLimitDefinitionResult',
    'GetLimitValuesFilterResult',
    'GetLimitValuesLimitValueResult',
    'GetQuotaLockResult',
    'GetQuotasFilterResult',
    'GetQuotasQuotaResult',
    'GetQuotasQuotaLockResult',
    'GetServicesFilterResult',
    'GetServicesServiceResult',
]

@pulumi.output_type
class QuotaLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 message: Optional[_builtins.str] = None,
                 related_resource_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Lock type.
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[_builtins.str]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetLimitDefinitionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional field, filter for a specific resource limit.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, filter for a specific resource limit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLimitDefinitionsLimitDefinitionResult(dict):
    def __init__(__self__, *,
                 are_quotas_supported: _builtins.bool,
                 description: _builtins.str,
                 external_location_supported_subscriptions: Sequence[_builtins.str],
                 is_deprecated: _builtins.bool,
                 is_dynamic: _builtins.bool,
                 is_eligible_for_limit_increase: _builtins.bool,
                 is_resource_availability_supported: _builtins.bool,
                 name: _builtins.str,
                 scope_type: _builtins.str,
                 service_name: _builtins.str,
                 supported_quota_families: Sequence[_builtins.str],
                 supported_subscriptions: Sequence[_builtins.str]):
        """
        :param _builtins.bool are_quotas_supported: If true, quota policies can be created on top of this resource limit.
        :param _builtins.str description: The limit description.
        :param Sequence[_builtins.str] external_location_supported_subscriptions: An array of subscription types that support ExternalLocations.
        :param _builtins.bool is_deprecated: Indicates if the limit has been deprecated.
        :param _builtins.bool is_dynamic: The limit for this resource has a dynamic value that is based on consumption across all Oracle Cloud Infrastructure services.
        :param _builtins.bool is_eligible_for_limit_increase: Indicates if the customer can request a limit increase for this resource.
        :param _builtins.bool is_resource_availability_supported: Reflects whether or not the GetResourceAvailability API is supported for this limit. If not, the API returns an empty JSON response.
        :param _builtins.str name: Optional field, filter for a specific resource limit.
        :param _builtins.str scope_type: Reflects the scope of the resource limit, whether Global (across all regions), regional, or availability domain-specific.
        :param _builtins.str service_name: The target service name.
        :param Sequence[_builtins.str] supported_quota_families: Supported quota family names for creation of quota policy.
        :param Sequence[_builtins.str] supported_subscriptions: An array of subscription types supported by the limit. For example, the type of subscription, such as SAAS, ERP, or CRM.
        """
        pulumi.set(__self__, "are_quotas_supported", are_quotas_supported)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "external_location_supported_subscriptions", external_location_supported_subscriptions)
        pulumi.set(__self__, "is_deprecated", is_deprecated)
        pulumi.set(__self__, "is_dynamic", is_dynamic)
        pulumi.set(__self__, "is_eligible_for_limit_increase", is_eligible_for_limit_increase)
        pulumi.set(__self__, "is_resource_availability_supported", is_resource_availability_supported)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scope_type", scope_type)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "supported_quota_families", supported_quota_families)
        pulumi.set(__self__, "supported_subscriptions", supported_subscriptions)

    @_builtins.property
    @pulumi.getter(name="areQuotasSupported")
    def are_quotas_supported(self) -> _builtins.bool:
        """
        If true, quota policies can be created on top of this resource limit.
        """
        return pulumi.get(self, "are_quotas_supported")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The limit description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalLocationSupportedSubscriptions")
    def external_location_supported_subscriptions(self) -> Sequence[_builtins.str]:
        """
        An array of subscription types that support ExternalLocations.
        """
        return pulumi.get(self, "external_location_supported_subscriptions")

    @_builtins.property
    @pulumi.getter(name="isDeprecated")
    def is_deprecated(self) -> _builtins.bool:
        """
        Indicates if the limit has been deprecated.
        """
        return pulumi.get(self, "is_deprecated")

    @_builtins.property
    @pulumi.getter(name="isDynamic")
    def is_dynamic(self) -> _builtins.bool:
        """
        The limit for this resource has a dynamic value that is based on consumption across all Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "is_dynamic")

    @_builtins.property
    @pulumi.getter(name="isEligibleForLimitIncrease")
    def is_eligible_for_limit_increase(self) -> _builtins.bool:
        """
        Indicates if the customer can request a limit increase for this resource.
        """
        return pulumi.get(self, "is_eligible_for_limit_increase")

    @_builtins.property
    @pulumi.getter(name="isResourceAvailabilitySupported")
    def is_resource_availability_supported(self) -> _builtins.bool:
        """
        Reflects whether or not the GetResourceAvailability API is supported for this limit. If not, the API returns an empty JSON response.
        """
        return pulumi.get(self, "is_resource_availability_supported")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, filter for a specific resource limit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> _builtins.str:
        """
        Reflects the scope of the resource limit, whether Global (across all regions), regional, or availability domain-specific.
        """
        return pulumi.get(self, "scope_type")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The target service name.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="supportedQuotaFamilies")
    def supported_quota_families(self) -> Sequence[_builtins.str]:
        """
        Supported quota family names for creation of quota policy.
        """
        return pulumi.get(self, "supported_quota_families")

    @_builtins.property
    @pulumi.getter(name="supportedSubscriptions")
    def supported_subscriptions(self) -> Sequence[_builtins.str]:
        """
        An array of subscription types supported by the limit. For example, the type of subscription, such as SAAS, ERP, or CRM.
        """
        return pulumi.get(self, "supported_subscriptions")


@pulumi.output_type
class GetLimitValuesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Optional field, can be used to see a specific resource limit value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, can be used to see a specific resource limit value.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLimitValuesLimitValueResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 name: _builtins.str,
                 scope_type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str availability_domain: Filter entries by availability domain. This implies that only AD-specific values are returned.
        :param _builtins.str name: Optional field, can be used to see a specific resource limit value.
        :param _builtins.str scope_type: Filter entries by scope type.
        :param _builtins.str value: The resource limit value.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scope_type", scope_type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        Filter entries by availability domain. This implies that only AD-specific values are returned.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional field, can be used to see a specific resource limit value.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> _builtins.str:
        """
        Filter entries by scope type.
        """
        return pulumi.get(self, "scope_type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The resource limit value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetQuotasFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetQuotasQuotaResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_lock_override: _builtins.bool,
                 locks: Sequence['outputs.GetQuotasQuotaLockResult'],
                 name: _builtins.str,
                 state: _builtins.str,
                 statements: Sequence[_builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description you assign to the quota.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the quota.
        :param Sequence['GetQuotasQuotaLockArgs'] locks: Locks associated with this resource.
        :param _builtins.str name: name
        :param _builtins.str state: Filters returned quotas based on the given state.
        :param Sequence[_builtins.str] statements: An array of one or more quota statements written in the declarative quota statement language.
        :param _builtins.str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "statements", statements)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description you assign to the quota.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the quota.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> _builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @_builtins.property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetQuotasQuotaLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filters returned quotas based on the given state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statements(self) -> Sequence[_builtins.str]:
        """
        An array of one or more quota statements written in the declarative quota statement language.
        """
        return pulumi.get(self, "statements")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetQuotasQuotaLockResult(dict):
    def __init__(__self__, *,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param _builtins.str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str type: Lock type.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServicesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The service name. Use this when calling other APIs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The service name. Use this when calling other APIs.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServicesServiceResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str,
                 supported_subscriptions: Sequence[_builtins.str]):
        """
        :param _builtins.str description: The friendly service name.
        :param _builtins.str name: The service name. Use this when calling other APIs.
        :param Sequence[_builtins.str] supported_subscriptions: An array of subscription types supported by the service. For example, the type of subscription, such as SAAS, ERP, or CRM.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "supported_subscriptions", supported_subscriptions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The friendly service name.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The service name. Use this when calling other APIs.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="supportedSubscriptions")
    def supported_subscriptions(self) -> Sequence[_builtins.str]:
        """
        An array of subscription types supported by the service. For example, the type of subscription, such as SAAS, ERP, or CRM.
        """
        return pulumi.get(self, "supported_subscriptions")


