# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackendSetBackend',
    'BackendSetHealthChecker',
    'BackendSetLbCookieSessionPersistenceConfiguration',
    'BackendSetSessionPersistenceConfiguration',
    'BackendSetSslConfiguration',
    'ListenerConnectionConfiguration',
    'ListenerSslConfiguration',
    'LoadBalancerIpAddressDetail',
    'LoadBalancerIpAddressDetailReservedIp',
    'LoadBalancerReservedIp',
    'LoadBalancerRoutingPolicyRule',
    'LoadBalancerRoutingPolicyRuleAction',
    'LoadBalancerShapeDetails',
    'PathRouteSetPathRoute',
    'PathRouteSetPathRoutePathMatchType',
    'RuleSetItem',
    'RuleSetItemCondition',
    'RuleSetItemIpMaxConnection',
    'RuleSetItemRedirectUri',
    'GetBackendHealthHealthCheckResultResult',
    'GetBackendSetsBackendsetResult',
    'GetBackendSetsBackendsetBackendResult',
    'GetBackendSetsBackendsetHealthCheckerResult',
    'GetBackendSetsBackendsetLbCookieSessionPersistenceConfigurationResult',
    'GetBackendSetsBackendsetSessionPersistenceConfigurationResult',
    'GetBackendSetsBackendsetSslConfigurationResult',
    'GetBackendSetsFilterResult',
    'GetBackendsBackendResult',
    'GetBackendsFilterResult',
    'GetCertificatesCertificateResult',
    'GetCertificatesFilterResult',
    'GetHostnamesFilterResult',
    'GetHostnamesHostnameResult',
    'GetListenerRulesFilterResult',
    'GetListenerRulesListenerRuleResult',
    'GetListenerRulesListenerRuleRuleResult',
    'GetListenerRulesListenerRuleRuleConditionResult',
    'GetListenerRulesListenerRuleRuleIpMaxConnectionResult',
    'GetListenerRulesListenerRuleRuleRedirectUriResult',
    'GetLoadBalancerRoutingPoliciesFilterResult',
    'GetLoadBalancerRoutingPoliciesRoutingPolicyResult',
    'GetLoadBalancerRoutingPoliciesRoutingPolicyRuleResult',
    'GetLoadBalancerRoutingPoliciesRoutingPolicyRuleActionResult',
    'GetLoadBalancerRoutingPolicyRuleResult',
    'GetLoadBalancerRoutingPolicyRuleActionResult',
    'GetLoadBalancersFilterResult',
    'GetLoadBalancersLoadBalancerResult',
    'GetLoadBalancersLoadBalancerIpAddressDetailResult',
    'GetLoadBalancersLoadBalancerIpAddressDetailReservedIpResult',
    'GetLoadBalancersLoadBalancerReservedIpResult',
    'GetLoadBalancersLoadBalancerShapeDetailResult',
    'GetPathRouteSetsFilterResult',
    'GetPathRouteSetsPathRouteSetResult',
    'GetPathRouteSetsPathRouteSetPathRouteResult',
    'GetPathRouteSetsPathRouteSetPathRoutePathMatchTypeResult',
    'GetPoliciesFilterResult',
    'GetPoliciesPolicyResult',
    'GetProtocolsFilterResult',
    'GetProtocolsProtocolResult',
    'GetRuleSetItemResult',
    'GetRuleSetItemConditionResult',
    'GetRuleSetItemIpMaxConnectionResult',
    'GetRuleSetItemRedirectUriResult',
    'GetRuleSetsFilterResult',
    'GetRuleSetsRuleSetResult',
    'GetRuleSetsRuleSetItemResult',
    'GetRuleSetsRuleSetItemConditionResult',
    'GetRuleSetsRuleSetItemIpMaxConnectionResult',
    'GetRuleSetsRuleSetItemRedirectUriResult',
    'GetShapesFilterResult',
    'GetShapesShapeResult',
    'GetSslCipherSuitesFilterResult',
    'GetSslCipherSuitesSslCipherSuiteResult',
]

@pulumi.output_type
class BackendSetBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "maxConnections":
            suggest = "max_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 port: _builtins.int,
                 backup: Optional[_builtins.bool] = None,
                 drain: Optional[_builtins.bool] = None,
                 max_connections: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 offline: Optional[_builtins.bool] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip_address: (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        :param _builtins.int port: (Updatable) The communication port for the backend server.  Example: `8080`
        :param _builtins.bool backup: (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
               
               **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.
               
               Example: `false`
        :param _builtins.bool drain: (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param _builtins.int max_connections: (Updatable) The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.
               
               If setting maxConnections to some value other than 0 then that value must be greater or equal to 256.
               
               Example: `300`
        :param _builtins.str name: A friendly name for the backend set. It must be unique and it cannot be changed.
               
               Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.
               
               Example: `example_backend_set`
        :param _builtins.bool offline: (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.int weight: (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if drain is not None:
            pulumi.set(__self__, "drain", drain)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offline is not None:
            pulumi.set(__self__, "offline", offline)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        (Updatable) The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        (Updatable) The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.

        **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.

        Example: `false`
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter
    def drain(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.

        If setting maxConnections to some value other than 0 then that value must be greater or equal to 256.

        Example: `300`
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.

        Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.

        Example: `example_backend_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def offline(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class BackendSetHealthChecker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalMs":
            suggest = "interval_ms"
        elif key == "isForcePlainText":
            suggest = "is_force_plain_text"
        elif key == "responseBodyRegex":
            suggest = "response_body_regex"
        elif key == "returnCode":
            suggest = "return_code"
        elif key == "timeoutInMillis":
            suggest = "timeout_in_millis"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetHealthChecker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetHealthChecker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetHealthChecker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 interval_ms: Optional[_builtins.int] = None,
                 is_force_plain_text: Optional[_builtins.bool] = None,
                 port: Optional[_builtins.int] = None,
                 response_body_regex: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 return_code: Optional[_builtins.int] = None,
                 timeout_in_millis: Optional[_builtins.int] = None,
                 url_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: (Updatable) The protocol the health check must use; either HTTP or TCP.  Example: `HTTP`
        :param _builtins.int interval_ms: (Updatable) The interval between health checks, in milliseconds.  Example: `10000`
        :param _builtins.bool is_force_plain_text: (Updatable) Specifies if health checks should always be done using plain text instead of depending on whether or not the associated backend set is using SSL.
               
               If "true", health checks will be done using plain text even if the associated backend set is configured to use SSL.
               
               If "false", health checks will be done using SSL encryption if the associated backend set is configured to use SSL. If the backend set is not so configured the health checks will be done using plain text.
               
               Example: `false`
        :param _builtins.int port: (Updatable) The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        :param _builtins.str response_body_regex: (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.int retries: (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state.  Example: `3`
        :param _builtins.int return_code: (Updatable) The status code a healthy backend server should return.  Example: `200`
        :param _builtins.int timeout_in_millis: (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period.  Example: `3000`
        :param _builtins.str url_path: (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "protocol", protocol)
        if interval_ms is not None:
            pulumi.set(__self__, "interval_ms", interval_ms)
        if is_force_plain_text is not None:
            pulumi.set(__self__, "is_force_plain_text", is_force_plain_text)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_body_regex is not None:
            pulumi.set(__self__, "response_body_regex", response_body_regex)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if return_code is not None:
            pulumi.set(__self__, "return_code", return_code)
        if timeout_in_millis is not None:
            pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (Updatable) The protocol the health check must use; either HTTP or TCP.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="intervalMs")
    def interval_ms(self) -> Optional[_builtins.int]:
        """
        (Updatable) The interval between health checks, in milliseconds.  Example: `10000`
        """
        return pulumi.get(self, "interval_ms")

    @_builtins.property
    @pulumi.getter(name="isForcePlainText")
    def is_force_plain_text(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Specifies if health checks should always be done using plain text instead of depending on whether or not the associated backend set is using SSL.

        If "true", health checks will be done using plain text even if the associated backend set is configured to use SSL.

        If "false", health checks will be done using SSL encryption if the associated backend set is configured to use SSL. If the backend set is not so configured the health checks will be done using plain text.

        Example: `false`
        """
        return pulumi.get(self, "is_force_plain_text")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> Optional[_builtins.str]:
        """
        (Updatable) A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        (Updatable) The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> Optional[_builtins.int]:
        """
        (Updatable) The status code a healthy backend server should return.  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period.  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class BackendSetLbCookieSessionPersistenceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "disableFallback":
            suggest = "disable_fallback"
        elif key == "isHttpOnly":
            suggest = "is_http_only"
        elif key == "isSecure":
            suggest = "is_secure"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetLbCookieSessionPersistenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetLbCookieSessionPersistenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetLbCookieSessionPersistenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_name: Optional[_builtins.str] = None,
                 disable_fallback: Optional[_builtins.bool] = None,
                 domain: Optional[_builtins.str] = None,
                 is_http_only: Optional[_builtins.bool] = None,
                 is_secure: Optional[_builtins.bool] = None,
                 max_age_in_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str cookie_name: (Updatable) The name of the cookie inserted by the load balancer. If this field is not configured, the cookie name defaults to "X-Oracle-BMC-LBS-Route".  Example: `example_cookie`
               
               **Notes:**
               *  Ensure that the cookie name used at the backend application servers is different from the cookie name used at the load balancer. To minimize the chance of name collision, Oracle recommends that you use a prefix such as "X-Oracle-OCI-" for this field.
               *  If a backend server and the load balancer both insert cookies with the same name, the client or browser behavior can vary depending on the domain and path values associated with the cookie. If the name, domain, and path values of the `Set-cookie` generated by a backend server and the `Set-cookie` generated by the load balancer are all the same, the client or browser treats them as one cookie and returns only one of the cookie values in subsequent requests. If both `Set-cookie` names are the same, but the domain and path names are different, the client or browser treats them as two different cookies.
        :param _builtins.bool disable_fallback: (Updatable) Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        :param _builtins.str domain: (Updatable) The domain in which the cookie is valid. The `Set-cookie` header inserted by the load balancer contains a domain attribute with the specified value.
               
               This attribute has no default value. If you do not specify a value, the load balancer does not insert the domain attribute into the `Set-cookie` header.
               
               **Notes:**
               *  [RFC 6265 - HTTP State Management Mechanism](https://www.ietf.org/rfc/rfc6265.txt) describes client and browser behavior when the domain attribute is present or not present in the `Set-cookie` header.
               
               If the value of the `Domain` attribute is `example.com` in the `Set-cookie` header, the client includes the same cookie in the `Cookie` header when making HTTP requests to `example.com`, `www.example.com`, and `www.abc.example.com`. If the `Domain` attribute is not present, the client returns the cookie only for the domain to which the original request was made.
               *  Ensure that this attribute specifies the correct domain value. If the `Domain` attribute in the `Set-cookie` header does not include the domain to which the original request was made, the client or browser might reject the cookie. As specified in RFC 6265, the client accepts a cookie with the `Domain` attribute value `example.com` or `www.example.com` sent from `www.example.com`. It does not accept a cookie with the `Domain` attribute `abc.example.com` or `www.abc.example.com` sent from `www.example.com`.
               
               Example: `example.com`
        :param _builtins.bool is_http_only: (Updatable) Whether the `Set-cookie` header should contain the `HttpOnly` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `HttpOnly` attribute, which limits the scope of the cookie to HTTP requests. This attribute directs the client or browser to omit the cookie when providing access to cookies through non-HTTP APIs. For example, it restricts the cookie from JavaScript channels.  Example: `true`
        :param _builtins.bool is_secure: (Updatable) Whether the `Set-cookie` header should contain the `Secure` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `Secure` attribute, which directs the client or browser to send the cookie only using a secure protocol.
               
               **Note:** If you set this field to `true`, you cannot associate the corresponding backend set with an HTTP listener.
               
               Example: `true`
        :param _builtins.int max_age_in_seconds: (Updatable) The amount of time the cookie remains valid. The `Set-cookie` header inserted by the load balancer contains a `Max-Age` attribute with the specified value.
               
               The specified value must be at least one second. There is no default value for this attribute. If you do not specify a value, the load balancer does not include the `Max-Age` attribute in the `Set-cookie` header. In most cases, the client or browser retains the cookie until the current session ends, as defined by the client.
               
               Example: `3600`
        :param _builtins.str path: (Updatable) The path in which the cookie is valid. The `Set-cookie header` inserted by the load balancer contains a `Path` attribute with the specified value.
               
               Clients include the cookie in an HTTP request only if the path portion of the request-uri matches, or is a subdirectory of, the cookie's `Path` attribute.
               
               The default value is `/`.
               
               Example: `/example`
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if disable_fallback is not None:
            pulumi.set(__self__, "disable_fallback", disable_fallback)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if is_http_only is not None:
            pulumi.set(__self__, "is_http_only", is_http_only)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the cookie inserted by the load balancer. If this field is not configured, the cookie name defaults to "X-Oracle-BMC-LBS-Route".  Example: `example_cookie`

        **Notes:**
        *  Ensure that the cookie name used at the backend application servers is different from the cookie name used at the load balancer. To minimize the chance of name collision, Oracle recommends that you use a prefix such as "X-Oracle-OCI-" for this field.
        *  If a backend server and the load balancer both insert cookies with the same name, the client or browser behavior can vary depending on the domain and path values associated with the cookie. If the name, domain, and path values of the `Set-cookie` generated by a backend server and the `Set-cookie` generated by the load balancer are all the same, the client or browser treats them as one cookie and returns only one of the cookie values in subsequent requests. If both `Set-cookie` names are the same, but the domain and path names are different, the client or browser treats them as two different cookies.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="disableFallback")
    def disable_fallback(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        return pulumi.get(self, "disable_fallback")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        (Updatable) The domain in which the cookie is valid. The `Set-cookie` header inserted by the load balancer contains a domain attribute with the specified value.

        This attribute has no default value. If you do not specify a value, the load balancer does not insert the domain attribute into the `Set-cookie` header.

        **Notes:**
        *  [RFC 6265 - HTTP State Management Mechanism](https://www.ietf.org/rfc/rfc6265.txt) describes client and browser behavior when the domain attribute is present or not present in the `Set-cookie` header.

        If the value of the `Domain` attribute is `example.com` in the `Set-cookie` header, the client includes the same cookie in the `Cookie` header when making HTTP requests to `example.com`, `www.example.com`, and `www.abc.example.com`. If the `Domain` attribute is not present, the client returns the cookie only for the domain to which the original request was made.
        *  Ensure that this attribute specifies the correct domain value. If the `Domain` attribute in the `Set-cookie` header does not include the domain to which the original request was made, the client or browser might reject the cookie. As specified in RFC 6265, the client accepts a cookie with the `Domain` attribute value `example.com` or `www.example.com` sent from `www.example.com`. It does not accept a cookie with the `Domain` attribute `abc.example.com` or `www.abc.example.com` sent from `www.example.com`.

        Example: `example.com`
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="isHttpOnly")
    def is_http_only(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the `Set-cookie` header should contain the `HttpOnly` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `HttpOnly` attribute, which limits the scope of the cookie to HTTP requests. This attribute directs the client or browser to omit the cookie when providing access to cookies through non-HTTP APIs. For example, it restricts the cookie from JavaScript channels.  Example: `true`
        """
        return pulumi.get(self, "is_http_only")

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the `Set-cookie` header should contain the `Secure` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `Secure` attribute, which directs the client or browser to send the cookie only using a secure protocol.

        **Note:** If you set this field to `true`, you cannot associate the corresponding backend set with an HTTP listener.

        Example: `true`
        """
        return pulumi.get(self, "is_secure")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        (Updatable) The amount of time the cookie remains valid. The `Set-cookie` header inserted by the load balancer contains a `Max-Age` attribute with the specified value.

        The specified value must be at least one second. There is no default value for this attribute. If you do not specify a value, the load balancer does not include the `Max-Age` attribute in the `Set-cookie` header. In most cases, the client or browser retains the cookie until the current session ends, as defined by the client.

        Example: `3600`
        """
        return pulumi.get(self, "max_age_in_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The path in which the cookie is valid. The `Set-cookie header` inserted by the load balancer contains a `Path` attribute with the specified value.

        Clients include the cookie in an HTTP request only if the path portion of the request-uri matches, or is a subdirectory of, the cookie's `Path` attribute.

        The default value is `/`.

        Example: `/example`
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class BackendSetSessionPersistenceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "disableFallback":
            suggest = "disable_fallback"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetSessionPersistenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetSessionPersistenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetSessionPersistenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_name: _builtins.str,
                 disable_fallback: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cookie_name: (Updatable) The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        :param _builtins.bool disable_fallback: (Updatable) Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        if disable_fallback is not None:
            pulumi.set(__self__, "disable_fallback", disable_fallback)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        """
        (Updatable) The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="disableFallback")
    def disable_fallback(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        return pulumi.get(self, "disable_fallback")


@pulumi.output_type
class BackendSetSslConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateIds":
            suggest = "certificate_ids"
        elif key == "certificateName":
            suggest = "certificate_name"
        elif key == "cipherSuiteName":
            suggest = "cipher_suite_name"
        elif key == "serverOrderPreference":
            suggest = "server_order_preference"
        elif key == "trustedCertificateAuthorityIds":
            suggest = "trusted_certificate_authority_ids"
        elif key == "verifyDepth":
            suggest = "verify_depth"
        elif key == "verifyPeerCertificate":
            suggest = "verify_peer_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendSetSslConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendSetSslConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendSetSslConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_ids: Optional[Sequence[_builtins.str]] = None,
                 certificate_name: Optional[_builtins.str] = None,
                 cipher_suite_name: Optional[_builtins.str] = None,
                 protocols: Optional[Sequence[_builtins.str]] = None,
                 server_order_preference: Optional[_builtins.str] = None,
                 trusted_certificate_authority_ids: Optional[Sequence[_builtins.str]] = None,
                 verify_depth: Optional[_builtins.int] = None,
                 verify_peer_certificate: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] certificate_ids: (Updatable) Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        :param _builtins.str certificate_name: (Updatable) A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        :param _builtins.str cipher_suite_name: (Updatable) The name of the cipher suite to use for HTTPS or SSL connections.
               
               If this field is not specified, the default is `oci-default-ssl-cipher-suite-v1`.
               
               **Notes:**
               *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite. Clients cannot perform an SSL handshake if there is an incompatible configuration.
               *  You must ensure compatibility between the ciphers configured in the cipher suite and the configured certificates. For example, RSA-based ciphers require RSA certificates and ECDSA-based ciphers require ECDSA certificates.
               *  If the cipher configuration is not modified after load balancer creation, the `GET` operation returns `oci-default-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing listeners that predate this feature.
               *  If the cipher configuration was modified using Oracle operations after load balancer creation, the `GET` operation returns `oci-customized-ssl-cipher-suite` as the value of this field in the SSL configuration for existing listeners that predate this feature.
               *  The `GET` operation returns `oci-wider-compatible-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing backend sets that predate this feature.
               *  If the `GET` operation on a listener returns `oci-customized-ssl-cipher-suite` as the value of this field, you must specify an appropriate predefined or custom cipher suite name when updating the resource.
               *  The `oci-customized-ssl-cipher-suite` Oracle reserved cipher suite name is not accepted as valid input for this field.
               
               example: `example_cipher_suite`
        :param Sequence[_builtins.str] protocols: (Updatable) A list of SSL protocols the load balancer must support for HTTPS or SSL connections.
               
               The load balancer uses SSL protocols to establish a secure connection between a client and a server. A secure connection ensures that all data passed between the client and the server is private.
               
               The Load Balancing service supports the following protocols:
               *  TLSv1
               *  TLSv1.1
               *  TLSv1.2
               *  TLSv1.3
               
               If this field is not specified, TLSv1.2 is the default.
               
               **Warning:** All SSL listeners created on a given port must use the same set of SSL protocols.
               
               **Notes:**
               *  The handshake to establish an SSL connection fails if the client supports none of the specified protocols.
               *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite.
               *  For all existing load balancer listeners and backend sets that predate this feature, the `GET` operation displays a list of SSL protocols currently used by those resources.
               
               example: `["TLSv1.1", "TLSv1.2"]`
        :param _builtins.str server_order_preference: (Updatable) When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.
               
               **Note:** This configuration is applicable only when the load balancer is acting as an SSL/HTTPS server. This field is ignored when the `SSLConfiguration` object is associated with a backend set.
        :param Sequence[_builtins.str] trusted_certificate_authority_ids: (Updatable) Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        :param _builtins.int verify_depth: (Updatable) The maximum depth for peer certificate chain verification.  Example: `3`
        :param _builtins.bool verify_peer_certificate: (Updatable) Whether the load balancer listener should verify peer certificates.  Example: `true` 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if cipher_suite_name is not None:
            pulumi.set(__self__, "cipher_suite_name", cipher_suite_name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if server_order_preference is not None:
            pulumi.set(__self__, "server_order_preference", server_order_preference)
        if trusted_certificate_authority_ids is not None:
            pulumi.set(__self__, "trusted_certificate_authority_ids", trusted_certificate_authority_ids)
        if verify_depth is not None:
            pulumi.set(__self__, "verify_depth", verify_depth)
        if verify_peer_certificate is not None:
            pulumi.set(__self__, "verify_peer_certificate", verify_peer_certificate)

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="cipherSuiteName")
    def cipher_suite_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the cipher suite to use for HTTPS or SSL connections.

        If this field is not specified, the default is `oci-default-ssl-cipher-suite-v1`.

        **Notes:**
        *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite. Clients cannot perform an SSL handshake if there is an incompatible configuration.
        *  You must ensure compatibility between the ciphers configured in the cipher suite and the configured certificates. For example, RSA-based ciphers require RSA certificates and ECDSA-based ciphers require ECDSA certificates.
        *  If the cipher configuration is not modified after load balancer creation, the `GET` operation returns `oci-default-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing listeners that predate this feature.
        *  If the cipher configuration was modified using Oracle operations after load balancer creation, the `GET` operation returns `oci-customized-ssl-cipher-suite` as the value of this field in the SSL configuration for existing listeners that predate this feature.
        *  The `GET` operation returns `oci-wider-compatible-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing backend sets that predate this feature.
        *  If the `GET` operation on a listener returns `oci-customized-ssl-cipher-suite` as the value of this field, you must specify an appropriate predefined or custom cipher suite name when updating the resource.
        *  The `oci-customized-ssl-cipher-suite` Oracle reserved cipher suite name is not accepted as valid input for this field.

        example: `example_cipher_suite`
        """
        return pulumi.get(self, "cipher_suite_name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) A list of SSL protocols the load balancer must support for HTTPS or SSL connections.

        The load balancer uses SSL protocols to establish a secure connection between a client and a server. A secure connection ensures that all data passed between the client and the server is private.

        The Load Balancing service supports the following protocols:
        *  TLSv1
        *  TLSv1.1
        *  TLSv1.2
        *  TLSv1.3

        If this field is not specified, TLSv1.2 is the default.

        **Warning:** All SSL listeners created on a given port must use the same set of SSL protocols.

        **Notes:**
        *  The handshake to establish an SSL connection fails if the client supports none of the specified protocols.
        *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite.
        *  For all existing load balancer listeners and backend sets that predate this feature, the `GET` operation displays a list of SSL protocols currently used by those resources.

        example: `["TLSv1.1", "TLSv1.2"]`
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="serverOrderPreference")
    def server_order_preference(self) -> Optional[_builtins.str]:
        """
        (Updatable) When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.

        **Note:** This configuration is applicable only when the load balancer is acting as an SSL/HTTPS server. This field is ignored when the `SSLConfiguration` object is associated with a backend set.
        """
        return pulumi.get(self, "server_order_preference")

    @_builtins.property
    @pulumi.getter(name="trustedCertificateAuthorityIds")
    def trusted_certificate_authority_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        """
        return pulumi.get(self, "trusted_certificate_authority_ids")

    @_builtins.property
    @pulumi.getter(name="verifyDepth")
    def verify_depth(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum depth for peer certificate chain verification.  Example: `3`
        """
        return pulumi.get(self, "verify_depth")

    @_builtins.property
    @pulumi.getter(name="verifyPeerCertificate")
    def verify_peer_certificate(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer listener should verify peer certificates.  Example: `true` 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "verify_peer_certificate")


@pulumi.output_type
class ListenerConnectionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutInSeconds":
            suggest = "idle_timeout_in_seconds"
        elif key == "backendTcpProxyProtocolOptions":
            suggest = "backend_tcp_proxy_protocol_options"
        elif key == "backendTcpProxyProtocolVersion":
            suggest = "backend_tcp_proxy_protocol_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerConnectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerConnectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerConnectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_in_seconds: _builtins.str,
                 backend_tcp_proxy_protocol_options: Optional[Sequence[_builtins.str]] = None,
                 backend_tcp_proxy_protocol_version: Optional[_builtins.int] = None):
        """
        :param _builtins.str idle_timeout_in_seconds: (Updatable) The maximum idle time, in seconds, allowed between two successive receive or two successive send operations between the client and backend servers. A send operation does not reset the timer for receive operations. A receive operation does not reset the timer for send operations.
               
               For more information, see [Connection Configuration](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/connectionreuse.htm#ConnectionConfiguration).
               
               Example: `1200`
        :param Sequence[_builtins.str] backend_tcp_proxy_protocol_options: (Updatable) An array that represents the PPV2 Options that can be enabled on TCP Listeners. Example: ["PP2_TYPE_AUTHORITY"]
        :param _builtins.int backend_tcp_proxy_protocol_version: (Updatable) The backend TCP Proxy Protocol version.  Example: `1`
        """
        pulumi.set(__self__, "idle_timeout_in_seconds", idle_timeout_in_seconds)
        if backend_tcp_proxy_protocol_options is not None:
            pulumi.set(__self__, "backend_tcp_proxy_protocol_options", backend_tcp_proxy_protocol_options)
        if backend_tcp_proxy_protocol_version is not None:
            pulumi.set(__self__, "backend_tcp_proxy_protocol_version", backend_tcp_proxy_protocol_version)

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInSeconds")
    def idle_timeout_in_seconds(self) -> _builtins.str:
        """
        (Updatable) The maximum idle time, in seconds, allowed between two successive receive or two successive send operations between the client and backend servers. A send operation does not reset the timer for receive operations. A receive operation does not reset the timer for send operations.

        For more information, see [Connection Configuration](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/connectionreuse.htm#ConnectionConfiguration).

        Example: `1200`
        """
        return pulumi.get(self, "idle_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="backendTcpProxyProtocolOptions")
    def backend_tcp_proxy_protocol_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array that represents the PPV2 Options that can be enabled on TCP Listeners. Example: ["PP2_TYPE_AUTHORITY"]
        """
        return pulumi.get(self, "backend_tcp_proxy_protocol_options")

    @_builtins.property
    @pulumi.getter(name="backendTcpProxyProtocolVersion")
    def backend_tcp_proxy_protocol_version(self) -> Optional[_builtins.int]:
        """
        (Updatable) The backend TCP Proxy Protocol version.  Example: `1`
        """
        return pulumi.get(self, "backend_tcp_proxy_protocol_version")


@pulumi.output_type
class ListenerSslConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateIds":
            suggest = "certificate_ids"
        elif key == "certificateName":
            suggest = "certificate_name"
        elif key == "cipherSuiteName":
            suggest = "cipher_suite_name"
        elif key == "hasSessionResumption":
            suggest = "has_session_resumption"
        elif key == "serverOrderPreference":
            suggest = "server_order_preference"
        elif key == "trustedCertificateAuthorityIds":
            suggest = "trusted_certificate_authority_ids"
        elif key == "verifyDepth":
            suggest = "verify_depth"
        elif key == "verifyPeerCertificate":
            suggest = "verify_peer_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerSslConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerSslConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerSslConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_ids: Optional[Sequence[_builtins.str]] = None,
                 certificate_name: Optional[_builtins.str] = None,
                 cipher_suite_name: Optional[_builtins.str] = None,
                 has_session_resumption: Optional[_builtins.bool] = None,
                 protocols: Optional[Sequence[_builtins.str]] = None,
                 server_order_preference: Optional[_builtins.str] = None,
                 trusted_certificate_authority_ids: Optional[Sequence[_builtins.str]] = None,
                 verify_depth: Optional[_builtins.int] = None,
                 verify_peer_certificate: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] certificate_ids: (Updatable) Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        :param _builtins.str certificate_name: (Updatable) A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        :param _builtins.str cipher_suite_name: (Updatable) The name of the cipher suite to use for HTTPS or SSL connections.
               
               If this field is not specified, the default is `oci-default-ssl-cipher-suite-v1`.
               
               **Notes:**
               *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite. Clients cannot perform an SSL handshake if there is an incompatible configuration.
               *  You must ensure compatibility between the ciphers configured in the cipher suite and the configured certificates. For example, RSA-based ciphers require RSA certificates and ECDSA-based ciphers require ECDSA certificates.
               *  If the cipher configuration is not modified after load balancer creation, the `GET` operation returns `oci-default-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing listeners that predate this feature.
               *  If the cipher configuration was modified using Oracle operations after load balancer creation, the `GET` operation returns `oci-customized-ssl-cipher-suite` as the value of this field in the SSL configuration for existing listeners that predate this feature.
               *  The `GET` operation returns `oci-wider-compatible-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing backend sets that predate this feature.
               *  If the `GET` operation on a listener returns `oci-customized-ssl-cipher-suite` as the value of this field, you must specify an appropriate predefined or custom cipher suite name when updating the resource.
               *  The `oci-customized-ssl-cipher-suite` Oracle reserved cipher suite name is not accepted as valid input for this field.
               
               example: `example_cipher_suite`
        :param _builtins.bool has_session_resumption: (Updatable) Whether the load balancer listener should resume an encrypted session by reusing the cryptographic parameters of a previous TLS session, without having to perform a full handshake again. If "true", the service resumes the previous TLS encrypted session. If "false", the service starts a new TLS encrypted session. Enabling session resumption improves performance but provides a lower level of security. Disabling session resumption improves security but reduces performance.  Example: `true`
        :param Sequence[_builtins.str] protocols: (Updatable) A list of SSL protocols the load balancer must support for HTTPS or SSL connections.
               
               The load balancer uses SSL protocols to establish a secure connection between a client and a server. A secure connection ensures that all data passed between the client and the server is private.
               
               The Load Balancing service supports the following protocols:
               *  TLSv1
               *  TLSv1.1
               *  TLSv1.2
               *  TLSv1.3
               
               If this field is not specified, TLSv1.2 is the default.
               
               **Warning:** All SSL listeners created on a given port must use the same set of SSL protocols.
               
               **Notes:**
               *  The handshake to establish an SSL connection fails if the client supports none of the specified protocols.
               *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite.
               *  For all existing load balancer listeners and backend sets that predate this feature, the `GET` operation displays a list of SSL protocols currently used by those resources.
               
               example: `["TLSv1.1", "TLSv1.2"]`
        :param _builtins.str server_order_preference: (Updatable) When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.
               
               **Note:** This configuration is applicable only when the load balancer is acting as an SSL/HTTPS server. This field is ignored when the `SSLConfiguration` object is associated with a backend set.
        :param Sequence[_builtins.str] trusted_certificate_authority_ids: (Updatable) Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        :param _builtins.int verify_depth: (Updatable) The maximum depth for peer certificate chain verification.  Example: `3`
        :param _builtins.bool verify_peer_certificate: (Updatable) Whether the load balancer listener should verify peer certificates.  Example: `true` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if cipher_suite_name is not None:
            pulumi.set(__self__, "cipher_suite_name", cipher_suite_name)
        if has_session_resumption is not None:
            pulumi.set(__self__, "has_session_resumption", has_session_resumption)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if server_order_preference is not None:
            pulumi.set(__self__, "server_order_preference", server_order_preference)
        if trusted_certificate_authority_ids is not None:
            pulumi.set(__self__, "trusted_certificate_authority_ids", trusted_certificate_authority_ids)
        if verify_depth is not None:
            pulumi.set(__self__, "verify_depth", verify_depth)
        if verify_peer_certificate is not None:
            pulumi.set(__self__, "verify_peer_certificate", verify_peer_certificate)

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="cipherSuiteName")
    def cipher_suite_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the cipher suite to use for HTTPS or SSL connections.

        If this field is not specified, the default is `oci-default-ssl-cipher-suite-v1`.

        **Notes:**
        *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite. Clients cannot perform an SSL handshake if there is an incompatible configuration.
        *  You must ensure compatibility between the ciphers configured in the cipher suite and the configured certificates. For example, RSA-based ciphers require RSA certificates and ECDSA-based ciphers require ECDSA certificates.
        *  If the cipher configuration is not modified after load balancer creation, the `GET` operation returns `oci-default-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing listeners that predate this feature.
        *  If the cipher configuration was modified using Oracle operations after load balancer creation, the `GET` operation returns `oci-customized-ssl-cipher-suite` as the value of this field in the SSL configuration for existing listeners that predate this feature.
        *  The `GET` operation returns `oci-wider-compatible-ssl-cipher-suite-v1` as the value of this field in the SSL configuration for existing backend sets that predate this feature.
        *  If the `GET` operation on a listener returns `oci-customized-ssl-cipher-suite` as the value of this field, you must specify an appropriate predefined or custom cipher suite name when updating the resource.
        *  The `oci-customized-ssl-cipher-suite` Oracle reserved cipher suite name is not accepted as valid input for this field.

        example: `example_cipher_suite`
        """
        return pulumi.get(self, "cipher_suite_name")

    @_builtins.property
    @pulumi.getter(name="hasSessionResumption")
    def has_session_resumption(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer listener should resume an encrypted session by reusing the cryptographic parameters of a previous TLS session, without having to perform a full handshake again. If "true", the service resumes the previous TLS encrypted session. If "false", the service starts a new TLS encrypted session. Enabling session resumption improves performance but provides a lower level of security. Disabling session resumption improves security but reduces performance.  Example: `true`
        """
        return pulumi.get(self, "has_session_resumption")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) A list of SSL protocols the load balancer must support for HTTPS or SSL connections.

        The load balancer uses SSL protocols to establish a secure connection between a client and a server. A secure connection ensures that all data passed between the client and the server is private.

        The Load Balancing service supports the following protocols:
        *  TLSv1
        *  TLSv1.1
        *  TLSv1.2
        *  TLSv1.3

        If this field is not specified, TLSv1.2 is the default.

        **Warning:** All SSL listeners created on a given port must use the same set of SSL protocols.

        **Notes:**
        *  The handshake to establish an SSL connection fails if the client supports none of the specified protocols.
        *  You must ensure compatibility between the specified SSL protocols and the ciphers configured in the cipher suite.
        *  For all existing load balancer listeners and backend sets that predate this feature, the `GET` operation displays a list of SSL protocols currently used by those resources.

        example: `["TLSv1.1", "TLSv1.2"]`
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="serverOrderPreference")
    def server_order_preference(self) -> Optional[_builtins.str]:
        """
        (Updatable) When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.

        **Note:** This configuration is applicable only when the load balancer is acting as an SSL/HTTPS server. This field is ignored when the `SSLConfiguration` object is associated with a backend set.
        """
        return pulumi.get(self, "server_order_preference")

    @_builtins.property
    @pulumi.getter(name="trustedCertificateAuthorityIds")
    def trusted_certificate_authority_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        """
        return pulumi.get(self, "trusted_certificate_authority_ids")

    @_builtins.property
    @pulumi.getter(name="verifyDepth")
    def verify_depth(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum depth for peer certificate chain verification.  Example: `3`
        """
        return pulumi.get(self, "verify_depth")

    @_builtins.property
    @pulumi.getter(name="verifyPeerCertificate")
    def verify_peer_certificate(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether the load balancer listener should verify peer certificates.  Example: `true` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "verify_peer_certificate")


@pulumi.output_type
class LoadBalancerIpAddressDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "isPublic":
            suggest = "is_public"
        elif key == "reservedIps":
            suggest = "reserved_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerIpAddressDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerIpAddressDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerIpAddressDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 is_public: Optional[_builtins.bool] = None,
                 reserved_ips: Optional[Sequence['outputs.LoadBalancerIpAddressDetailReservedIp']] = None):
        """
        :param _builtins.str ip_address: An IP address.  Example: `192.168.0.3`
        :param _builtins.bool is_public: Whether the IP address is public or private.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[_builtins.bool]:
        """
        Whether the IP address is public or private.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[Sequence['outputs.LoadBalancerIpAddressDetailReservedIp']]:
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class LoadBalancerIpAddressDetailReservedIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Ocid of the Reserved IP/Public Ip created with VCN.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Ocid of the Reserved IP/Public Ip created with VCN.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerReservedIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: (Updatable) Ocid of the Reserved IP/Public Ip created with VCN.
               
               Reserved IPs are IPs which already registered using VCN API.
               
               Create a reserved Public IP and then while creating the load balancer pass the ocid of the reserved IP in this field reservedIp to attach the Ip to Load balancer. Load balancer will be configured to listen to traffic on this IP.
               
               Reserved IPs will not be deleted when the Load balancer is deleted. They will be unattached from the Load balancer.
               
               Example: "ocid1.publicip.oc1.phx.unique_ID"
               
               IPV6 example: "ocid1.ipv6.oc1.phx.unique_ID" Ocid of the pre-created public IP that should be attached to this load balancer. The public IP will be attached to a private IP. **Note** If public IP resource is present in the config, the pulumi preview will throw `After applying this step and refreshing, the plan was not empty` error, and `private_ip_id` needs to be added as an input argument to the public IP resource block or ignore from its lifecycle as shown in examples to resolve this error.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Updatable) Ocid of the Reserved IP/Public Ip created with VCN.

        Reserved IPs are IPs which already registered using VCN API.

        Create a reserved Public IP and then while creating the load balancer pass the ocid of the reserved IP in this field reservedIp to attach the Ip to Load balancer. Load balancer will be configured to listen to traffic on this IP.

        Reserved IPs will not be deleted when the Load balancer is deleted. They will be unattached from the Load balancer.

        Example: "ocid1.publicip.oc1.phx.unique_ID"

        IPV6 example: "ocid1.ipv6.oc1.phx.unique_ID" Ocid of the pre-created public IP that should be attached to this load balancer. The public IP will be attached to a private IP. **Note** If public IP resource is present in the config, the pulumi preview will throw `After applying this step and refreshing, the plan was not empty` error, and `private_ip_id` needs to be added as an input argument to the public IP resource block or ignore from its lifecycle as shown in examples to resolve this error.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerRoutingPolicyRule(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.LoadBalancerRoutingPolicyRuleAction'],
                 condition: _builtins.str,
                 name: _builtins.str):
        """
        :param Sequence['LoadBalancerRoutingPolicyRuleActionArgs'] actions: (Updatable) A list of actions to be applied when conditions of the routing rule are met.
        :param _builtins.str condition: (Updatable) A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        :param _builtins.str name: (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.LoadBalancerRoutingPolicyRuleAction']:
        """
        (Updatable) A list of actions to be applied when conditions of the routing rule are met.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        (Updatable) A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancerRoutingPolicyRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendSetName":
            suggest = "backend_set_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerRoutingPolicyRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerRoutingPolicyRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerRoutingPolicyRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str backend_set_name: (Updatable) Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        :param _builtins.str name: (Updatable) The name can be one of these values: `FORWARD_TO_BACKENDSET`
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        (Updatable) Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Updatable) The name can be one of these values: `FORWARD_TO_BACKENDSET`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancerShapeDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBandwidthInMbps":
            suggest = "maximum_bandwidth_in_mbps"
        elif key == "minimumBandwidthInMbps":
            suggest = "minimum_bandwidth_in_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerShapeDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerShapeDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerShapeDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_bandwidth_in_mbps: _builtins.int,
                 minimum_bandwidth_in_mbps: _builtins.int):
        """
        :param _builtins.int maximum_bandwidth_in_mbps: (Updatable) Bandwidth in Mbps that determines the maximum bandwidth (ingress plus egress) that the load balancer can achieve. This bandwidth cannot be always guaranteed. For a guaranteed bandwidth use the minimumBandwidthInMbps parameter.
               
               The values must be between minimumBandwidthInMbps and 8000 (8Gbps).
               
               Example: `1500`
        :param _builtins.int minimum_bandwidth_in_mbps: (Updatable) Bandwidth in Mbps that determines the total pre-provisioned bandwidth (ingress plus egress). The values must be between 10 and the maximumBandwidthInMbps.  Example: `150`
        """
        pulumi.set(__self__, "maximum_bandwidth_in_mbps", maximum_bandwidth_in_mbps)
        pulumi.set(__self__, "minimum_bandwidth_in_mbps", minimum_bandwidth_in_mbps)

    @_builtins.property
    @pulumi.getter(name="maximumBandwidthInMbps")
    def maximum_bandwidth_in_mbps(self) -> _builtins.int:
        """
        (Updatable) Bandwidth in Mbps that determines the maximum bandwidth (ingress plus egress) that the load balancer can achieve. This bandwidth cannot be always guaranteed. For a guaranteed bandwidth use the minimumBandwidthInMbps parameter.

        The values must be between minimumBandwidthInMbps and 8000 (8Gbps).

        Example: `1500`
        """
        return pulumi.get(self, "maximum_bandwidth_in_mbps")

    @_builtins.property
    @pulumi.getter(name="minimumBandwidthInMbps")
    def minimum_bandwidth_in_mbps(self) -> _builtins.int:
        """
        (Updatable) Bandwidth in Mbps that determines the total pre-provisioned bandwidth (ingress plus egress). The values must be between 10 and the maximumBandwidthInMbps.  Example: `150`
        """
        return pulumi.get(self, "minimum_bandwidth_in_mbps")


@pulumi.output_type
class PathRouteSetPathRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendSetName":
            suggest = "backend_set_name"
        elif key == "pathMatchType":
            suggest = "path_match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathRouteSetPathRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathRouteSetPathRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathRouteSetPathRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 path: _builtins.str,
                 path_match_type: 'outputs.PathRouteSetPathRoutePathMatchType'):
        """
        :param _builtins.str backend_set_name: (Updatable) The name of the target backend set for requests where the incoming URI matches the specified path.  Example: `example_backend_set`
        :param _builtins.str path: (Updatable) The path string to match against the incoming URI path.
               *  Path strings are case-insensitive.
               *  Asterisk (*) wildcards are not supported.
               *  Regular expressions are not supported.
               
               Example: `/example/video/123`
        :param 'PathRouteSetPathRoutePathMatchTypeArgs' path_match_type: (Updatable) The type of matching to apply to incoming URIs.
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_match_type", path_match_type)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        (Updatable) The name of the target backend set for requests where the incoming URI matches the specified path.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        (Updatable) The path string to match against the incoming URI path.
        *  Path strings are case-insensitive.
        *  Asterisk (*) wildcards are not supported.
        *  Regular expressions are not supported.

        Example: `/example/video/123`
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathMatchType")
    def path_match_type(self) -> 'outputs.PathRouteSetPathRoutePathMatchType':
        """
        (Updatable) The type of matching to apply to incoming URIs.
        """
        return pulumi.get(self, "path_match_type")


@pulumi.output_type
class PathRouteSetPathRoutePathMatchType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathRouteSetPathRoutePathMatchType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathRouteSetPathRoutePathMatchType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathRouteSetPathRoutePathMatchType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: _builtins.str):
        """
        :param _builtins.str match_type: (Updatable) Specifies how the load balancing service compares a [PathRoute](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/requests/PathRoute) object's `path` string against the incoming URI.
               *  **EXACT_MATCH** - Looks for a `path` string that exactly matches the incoming URI path.
               *  **FORCE_LONGEST_PREFIX_MATCH** - Looks for the `path` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - Looks for a `path` string that matches the beginning portion of the incoming URI path.
               *  **SUFFIX_MATCH** - Looks for a `path` string that matches the ending portion of the incoming URI path.
               
               For a full description of how the system handles `matchType` in a path route set containing multiple rules, see [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> _builtins.str:
        """
        (Updatable) Specifies how the load balancing service compares a [PathRoute](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/requests/PathRoute) object's `path` string against the incoming URI.
        *  **EXACT_MATCH** - Looks for a `path` string that exactly matches the incoming URI path.
        *  **FORCE_LONGEST_PREFIX_MATCH** - Looks for the `path` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - Looks for a `path` string that matches the beginning portion of the incoming URI path.
        *  **SUFFIX_MATCH** - Looks for a `path` string that matches the ending portion of the incoming URI path.

        For a full description of how the system handles `matchType` in a path route set containing multiple rules, see [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "match_type")


@pulumi.output_type
class RuleSetItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "areInvalidCharactersAllowed":
            suggest = "are_invalid_characters_allowed"
        elif key == "defaultMaxConnections":
            suggest = "default_max_connections"
        elif key == "httpLargeHeaderSizeInKb":
            suggest = "http_large_header_size_in_kb"
        elif key == "ipMaxConnections":
            suggest = "ip_max_connections"
        elif key == "redirectUri":
            suggest = "redirect_uri"
        elif key == "responseCode":
            suggest = "response_code"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSetItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSetItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSetItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 allowed_methods: Optional[Sequence[_builtins.str]] = None,
                 are_invalid_characters_allowed: Optional[_builtins.bool] = None,
                 conditions: Optional[Sequence['outputs.RuleSetItemCondition']] = None,
                 default_max_connections: Optional[_builtins.int] = None,
                 description: Optional[_builtins.str] = None,
                 header: Optional[_builtins.str] = None,
                 http_large_header_size_in_kb: Optional[_builtins.int] = None,
                 ip_max_connections: Optional[Sequence['outputs.RuleSetItemIpMaxConnection']] = None,
                 prefix: Optional[_builtins.str] = None,
                 redirect_uri: Optional['outputs.RuleSetItemRedirectUri'] = None,
                 response_code: Optional[_builtins.int] = None,
                 status_code: Optional[_builtins.int] = None,
                 suffix: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: (Updatable) The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        :param Sequence[_builtins.str] allowed_methods: (Updatable) The list of HTTP methods allowed for this listener.
               
               By default, you can specify only the standard HTTP methods defined in the [HTTP Method Registry](http://www.iana.org/assignments/http-methods/http-methods.xhtml). You can also see a list of supported standard HTTP methods in the Load Balancing service documentation at [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm).
               
               Your backend application must be able to handle the methods specified in this list.
               
               The list of HTTP methods is extensible. If you need to configure custom HTTP methods, contact [My Oracle Support](http://support.oracle.com/) to remove the restriction for your tenancy.
               
               Example: ["GET", "PUT", "POST", "PROPFIND"]
        :param _builtins.bool are_invalid_characters_allowed: (Updatable) Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        :param Sequence['RuleSetItemConditionArgs'] conditions: (Updatable)
        :param _builtins.int default_max_connections: (Updatable) The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        :param _builtins.str description: (Updatable) A brief description of the access control rule. Avoid entering confidential information.
               
               example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        :param _builtins.str header: (Updatable) A header name that conforms to RFC 7230.  Example: `example_header_name`
        :param _builtins.int http_large_header_size_in_kb: (Updatable) The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        :param Sequence['RuleSetItemIpMaxConnectionArgs'] ip_max_connections: (Updatable) An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        :param _builtins.str prefix: (Updatable) A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
               
               Example: `example_prefix_value`
        :param 'RuleSetItemRedirectUriArgs' redirect_uri: (Updatable) An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
               
               **NOTE:** The Load Balancing service cannot automatically detect or avoid infinite redirects. Be sure to provide meaningful, complete, and correct field values. If any component field of this object has no value, the system retains the value from the incoming HTTP request URI.
               
               For example, if you specify only the protocol field `https`, and the incoming request URI is `http://example.com:8080`, the resulting runtime redirect URI is `https://example.com:8080`. The system retains the host and port from the incoming URI and does not automatically change the port setting from `8080` to `443`.
               
               Be sure to configure valid percent-encoding (URL encoding) when needed.
               
               In addition to static string values, you can use the following tokens to construct the redirect URI. These tokens extract values from the incoming HTTP request URI.
               *  {protocol} : The protocol from the incoming HTTP request URI.
               *  {host}     : The domain name from the incoming HTTP request URI.
               *  {port}     : The port from the incoming HTTP request URI.
               *  {path}     : The path from the incoming HTTP request URI.
               *  {query}    : The query string from the incoming HTTP request URI.
               
               The tokens are case sensitive. For example, `{host}` is a valid token, but `{HOST}` is not.
               
               You can retain the literal characters of a token when you specify values for the path and query properties of the redirect URI. Use a backslash (\\\\) as the escape character for the \\\\, {, and } characters. For example, if the incoming HTTP request URI is `/video`, the path property value:
               
               `/example{path}123\\{path\\}`
               
               appears in the constructed redirect URI as:
               
               `/example/video123{path}`
        :param _builtins.int response_code: (Updatable) The HTTP status code to return when the incoming request is redirected.
               
               The status line returned with the code is mapped from the standard HTTP specification. Valid response codes for redirection are:
               *  301
               *  302
               *  303
               *  307
               *  308
               
               The default value is `302` (Found).
               
               Example: `301`
        :param _builtins.int status_code: (Updatable) The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        :param _builtins.str suffix: (Updatable) A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
               
               Example: `example_suffix_value`
        :param _builtins.str value: (Updatable) A header value that conforms to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
               
               Example: `example_value`
        """
        pulumi.set(__self__, "action", action)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if are_invalid_characters_allowed is not None:
            pulumi.set(__self__, "are_invalid_characters_allowed", are_invalid_characters_allowed)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if default_max_connections is not None:
            pulumi.set(__self__, "default_max_connections", default_max_connections)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if http_large_header_size_in_kb is not None:
            pulumi.set(__self__, "http_large_header_size_in_kb", http_large_header_size_in_kb)
        if ip_max_connections is not None:
            pulumi.set(__self__, "ip_max_connections", ip_max_connections)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        (Updatable) The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) The list of HTTP methods allowed for this listener.

        By default, you can specify only the standard HTTP methods defined in the [HTTP Method Registry](http://www.iana.org/assignments/http-methods/http-methods.xhtml). You can also see a list of supported standard HTTP methods in the Load Balancing service documentation at [Managing Rule Sets](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrulesets.htm).

        Your backend application must be able to handle the methods specified in this list.

        The list of HTTP methods is extensible. If you need to configure custom HTTP methods, contact [My Oracle Support](http://support.oracle.com/) to remove the restriction for your tenancy.

        Example: ["GET", "PUT", "POST", "PROPFIND"]
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="areInvalidCharactersAllowed")
    def are_invalid_characters_allowed(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        """
        return pulumi.get(self, "are_invalid_characters_allowed")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.RuleSetItemCondition']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="defaultMaxConnections")
    def default_max_connections(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        """
        return pulumi.get(self, "default_max_connections")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) A brief description of the access control rule. Avoid entering confidential information.

        example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Optional[_builtins.str]:
        """
        (Updatable) A header name that conforms to RFC 7230.  Example: `example_header_name`
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter(name="httpLargeHeaderSizeInKb")
    def http_large_header_size_in_kb(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        """
        return pulumi.get(self, "http_large_header_size_in_kb")

    @_builtins.property
    @pulumi.getter(name="ipMaxConnections")
    def ip_max_connections(self) -> Optional[Sequence['outputs.RuleSetItemIpMaxConnection']]:
        """
        (Updatable) An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        """
        return pulumi.get(self, "ip_max_connections")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        (Updatable) A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.

        Example: `example_prefix_value`
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional['outputs.RuleSetItemRedirectUri']:
        """
        (Updatable) An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.

        **NOTE:** The Load Balancing service cannot automatically detect or avoid infinite redirects. Be sure to provide meaningful, complete, and correct field values. If any component field of this object has no value, the system retains the value from the incoming HTTP request URI.

        For example, if you specify only the protocol field `https`, and the incoming request URI is `http://example.com:8080`, the resulting runtime redirect URI is `https://example.com:8080`. The system retains the host and port from the incoming URI and does not automatically change the port setting from `8080` to `443`.

        Be sure to configure valid percent-encoding (URL encoding) when needed.

        In addition to static string values, you can use the following tokens to construct the redirect URI. These tokens extract values from the incoming HTTP request URI.
        *  {protocol} : The protocol from the incoming HTTP request URI.
        *  {host}     : The domain name from the incoming HTTP request URI.
        *  {port}     : The port from the incoming HTTP request URI.
        *  {path}     : The path from the incoming HTTP request URI.
        *  {query}    : The query string from the incoming HTTP request URI.

        The tokens are case sensitive. For example, `{host}` is a valid token, but `{HOST}` is not.

        You can retain the literal characters of a token when you specify values for the path and query properties of the redirect URI. Use a backslash (\\\\) as the escape character for the \\\\, {, and } characters. For example, if the incoming HTTP request URI is `/video`, the path property value:

        `/example{path}123\\{path\\}`

        appears in the constructed redirect URI as:

        `/example/video123{path}`
        """
        return pulumi.get(self, "redirect_uri")

    @_builtins.property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[_builtins.int]:
        """
        (Updatable) The HTTP status code to return when the incoming request is redirected.

        The status line returned with the code is mapped from the standard HTTP specification. Valid response codes for redirection are:
        *  301
        *  302
        *  303
        *  307
        *  308

        The default value is `302` (Found).

        Example: `301`
        """
        return pulumi.get(self, "response_code")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.int]:
        """
        (Updatable) The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> Optional[_builtins.str]:
        """
        (Updatable) A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.

        Example: `example_suffix_value`
        """
        return pulumi.get(self, "suffix")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        (Updatable) A header value that conforms to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.

        Example: `example_value`
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleSetItemCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeValue":
            suggest = "attribute_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSetItemCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSetItemCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSetItemCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: _builtins.str,
                 attribute_value: _builtins.str,
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str attribute_name: (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        :param _builtins.str attribute_value: (Updatable) Depends on `attribute_name`:
               - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        :param _builtins.str operator: (Updatable) A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
               *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
               *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
               *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> _builtins.str:
        """
        (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        """
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> _builtins.str:
        """
        (Updatable) Depends on `attribute_name`:
        - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        """
        return pulumi.get(self, "attribute_value")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        (Updatable) A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
        *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
        *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
        *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class RuleSetItemIpMaxConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "maxConnections":
            suggest = "max_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSetItemIpMaxConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSetItemIpMaxConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSetItemIpMaxConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 max_connections: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] ip_addresses: (Updatable) Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        :param _builtins.int max_connections: (Updatable) The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        (Updatable) The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        return pulumi.get(self, "max_connections")


@pulumi.output_type
class RuleSetItemRedirectUri(dict):
    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 query: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: (Updatable) The valid domain name (hostname) or IP address to use in the redirect URI.
               
               When this value is null, not set, or set to `{host}`, the service preserves the original domain name from the incoming HTTP request URI.
               
               All RedirectUri tokens are valid for this property. You can use any token more than once.
               
               Curly braces are valid in this property only to surround tokens, such as `{host}`
               
               Examples:
               *  **example.com** appears as `example.com` in the redirect URI.
               *  **in{host}** appears as `inexample.com` in the redirect URI if `example.com` is the hostname in the incoming HTTP request URI.
               *  **{port}{host}** appears as `8081example.com` in the redirect URI if `example.com` is the hostname and the port is `8081` in the incoming HTTP request URI.
        :param _builtins.str path: (Updatable) The HTTP URI path to use in the redirect URI.
               
               When this value is null, not set, or set to `{path}`, the service preserves the original path from the incoming HTTP request URI. To omit the path from the redirect URI, set this value to an empty string, "".
               
               All RedirectUri tokens are valid for this property. You can use any token more than once.
               
               The path string must begin with `/` if it does not begin with the `{path}` token.
               
               Examples:
               *  __/example/video/123__ appears as `/example/video/123` in the redirect URI.
               *  __/example{path}__ appears as `/example/video/123` in the redirect URI if `/video/123` is the path in the incoming HTTP request URI.
               *  __{path}/123__ appears as `/example/video/123` in the redirect URI if `/example/video` is the path in the incoming HTTP request URI.
               *  __{path}123__ appears as `/example/video123` in the redirect URI if `/example/video` is the path in the incoming HTTP request URI.
               *  __/{host}/123__ appears as `/example.com/123` in the redirect URI if `example.com` is the hostname in the incoming HTTP request URI.
               *  __/{host}/{port}__ appears as `/example.com/123` in the redirect URI if `example.com` is the hostname and `123` is the port in the incoming HTTP request URI.
               *  __/{query}__ appears as `/lang=en` in the redirect URI if the query is `lang=en` in the incoming HTTP request URI.
        :param _builtins.int port: (Updatable) The communication port to use in the redirect URI.
               
               Valid values include integers from 1 to 65535.
               
               When this value is null, the service preserves the original port from the incoming HTTP request URI.
               
               Example: `8081`
        :param _builtins.str protocol: (Updatable) The HTTP protocol to use in the redirect URI.
               
               When this value is null, not set, or set to `{protocol}`, the service preserves the original protocol from the incoming HTTP request URI. Allowed values are:
               *  HTTP
               *  HTTPS
               *  {protocol}
               
               `{protocol}` is the only valid token for this property. It can appear only once in the value string.
               
               Example: `HTTPS`
        :param _builtins.str query: (Updatable) The query string to use in the redirect URI.
               
               When this value is null, not set, or set to `{query}`, the service preserves the original query parameters from the incoming HTTP request URI.
               
               All `RedirectUri` tokens are valid for this property. You can use any token more than once.
               
               If the query string does not begin with the `{query}` token, it must begin with the question mark (?) character.
               
               You can specify multiple query parameters as a single string. Separate each query parameter with an ampersand (&) character. To omit all incoming query parameters from the redirect URI, set this value to an empty string, "".
               
               If the specified query string results in a redirect URI ending with `?` or `&`, the last character is truncated. For example, if the incoming URI is `http://host.com:8080/documents` and the query property value is `?lang=en&{query}`, the redirect URI is `http://host.com:8080/documents?lang=en`. The system truncates the final ampersand (&) because the incoming URI included no value to replace the {query} token.
               
               Examples:
               * **lang=en&time_zone=PST** appears as `lang=en&time_zone=PST` in the redirect URI.
               * **{query}** appears as `lang=en&time_zone=PST` in the redirect URI if `lang=en&time_zone=PST` is the query string in the incoming HTTP request. If the incoming HTTP request has no query parameters, the `{query}` token renders as an empty string.
               * **lang=en&{query}&time_zone=PST** appears as `lang=en&country=us&time_zone=PST` in the redirect URI if `country=us` is the query string in the incoming HTTP request. If the incoming HTTP request has no query parameters, this value renders as `lang=en&time_zone=PST`.
               *  **protocol={protocol}&hostname={host}** appears as `protocol=http&hostname=example.com` in the redirect URI if the protocol is `HTTP` and the hostname is `example.com` in the incoming HTTP request.
               *  **port={port}&hostname={host}** appears as `port=8080&hostname=example.com` in the redirect URI if the port is `8080` and the hostname is `example.com` in the incoming HTTP request URI.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        (Updatable) The valid domain name (hostname) or IP address to use in the redirect URI.

        When this value is null, not set, or set to `{host}`, the service preserves the original domain name from the incoming HTTP request URI.

        All RedirectUri tokens are valid for this property. You can use any token more than once.

        Curly braces are valid in this property only to surround tokens, such as `{host}`

        Examples:
        *  **example.com** appears as `example.com` in the redirect URI.
        *  **in{host}** appears as `inexample.com` in the redirect URI if `example.com` is the hostname in the incoming HTTP request URI.
        *  **{port}{host}** appears as `8081example.com` in the redirect URI if `example.com` is the hostname and the port is `8081` in the incoming HTTP request URI.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The HTTP URI path to use in the redirect URI.

        When this value is null, not set, or set to `{path}`, the service preserves the original path from the incoming HTTP request URI. To omit the path from the redirect URI, set this value to an empty string, "".

        All RedirectUri tokens are valid for this property. You can use any token more than once.

        The path string must begin with `/` if it does not begin with the `{path}` token.

        Examples:
        *  __/example/video/123__ appears as `/example/video/123` in the redirect URI.
        *  __/example{path}__ appears as `/example/video/123` in the redirect URI if `/video/123` is the path in the incoming HTTP request URI.
        *  __{path}/123__ appears as `/example/video/123` in the redirect URI if `/example/video` is the path in the incoming HTTP request URI.
        *  __{path}123__ appears as `/example/video123` in the redirect URI if `/example/video` is the path in the incoming HTTP request URI.
        *  __/{host}/123__ appears as `/example.com/123` in the redirect URI if `example.com` is the hostname in the incoming HTTP request URI.
        *  __/{host}/{port}__ appears as `/example.com/123` in the redirect URI if `example.com` is the hostname and `123` is the port in the incoming HTTP request URI.
        *  __/{query}__ appears as `/lang=en` in the redirect URI if the query is `lang=en` in the incoming HTTP request URI.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The communication port to use in the redirect URI.

        Valid values include integers from 1 to 65535.

        When this value is null, the service preserves the original port from the incoming HTTP request URI.

        Example: `8081`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        (Updatable) The HTTP protocol to use in the redirect URI.

        When this value is null, not set, or set to `{protocol}`, the service preserves the original protocol from the incoming HTTP request URI. Allowed values are:
        *  HTTP
        *  HTTPS
        *  {protocol}

        `{protocol}` is the only valid token for this property. It can appear only once in the value string.

        Example: `HTTPS`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[_builtins.str]:
        """
        (Updatable) The query string to use in the redirect URI.

        When this value is null, not set, or set to `{query}`, the service preserves the original query parameters from the incoming HTTP request URI.

        All `RedirectUri` tokens are valid for this property. You can use any token more than once.

        If the query string does not begin with the `{query}` token, it must begin with the question mark (?) character.

        You can specify multiple query parameters as a single string. Separate each query parameter with an ampersand (&) character. To omit all incoming query parameters from the redirect URI, set this value to an empty string, "".

        If the specified query string results in a redirect URI ending with `?` or `&`, the last character is truncated. For example, if the incoming URI is `http://host.com:8080/documents` and the query property value is `?lang=en&{query}`, the redirect URI is `http://host.com:8080/documents?lang=en`. The system truncates the final ampersand (&) because the incoming URI included no value to replace the {query} token.

        Examples:
        * **lang=en&time_zone=PST** appears as `lang=en&time_zone=PST` in the redirect URI.
        * **{query}** appears as `lang=en&time_zone=PST` in the redirect URI if `lang=en&time_zone=PST` is the query string in the incoming HTTP request. If the incoming HTTP request has no query parameters, the `{query}` token renders as an empty string.
        * **lang=en&{query}&time_zone=PST** appears as `lang=en&country=us&time_zone=PST` in the redirect URI if `country=us` is the query string in the incoming HTTP request. If the incoming HTTP request has no query parameters, this value renders as `lang=en&time_zone=PST`.
        *  **protocol={protocol}&hostname={host}** appears as `protocol=http&hostname=example.com` in the redirect URI if the protocol is `HTTP` and the hostname is `example.com` in the incoming HTTP request.
        *  **port={port}&hostname={host}** appears as `port=8080&hostname=example.com` in the redirect URI if the port is `8080` and the hostname is `example.com` in the incoming HTTP request URI.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GetBackendHealthHealthCheckResultResult(dict):
    def __init__(__self__, *,
                 health_check_status: _builtins.str,
                 source_ip_address: _builtins.str,
                 subnet_id: _builtins.str,
                 timestamp: _builtins.str):
        """
        :param _builtins.str health_check_status: The result of the most recent health check.
        :param _builtins.str source_ip_address: The IP address of the health check status report provider. This identifier helps you differentiate same-subnet load balancers that report health check status.  Example: `10.0.0.7`
        :param _builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet hosting the load balancer that reported this health check status.
        :param _builtins.str timestamp: The date and time the data was retrieved, in the format defined by RFC3339.  Example: `2017-06-02T18:28:11+00:00`
        """
        pulumi.set(__self__, "health_check_status", health_check_status)
        pulumi.set(__self__, "source_ip_address", source_ip_address)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "timestamp", timestamp)

    @_builtins.property
    @pulumi.getter(name="healthCheckStatus")
    def health_check_status(self) -> _builtins.str:
        """
        The result of the most recent health check.
        """
        return pulumi.get(self, "health_check_status")

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> _builtins.str:
        """
        The IP address of the health check status report provider. This identifier helps you differentiate same-subnet load balancers that report health check status.  Example: `10.0.0.7`
        """
        return pulumi.get(self, "source_ip_address")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet hosting the load balancer that reported this health check status.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> _builtins.str:
        """
        The date and time the data was retrieved, in the format defined by RFC3339.  Example: `2017-06-02T18:28:11+00:00`
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetBackendSetsBackendsetResult(dict):
    def __init__(__self__, *,
                 backend_max_connections: _builtins.int,
                 backends: Sequence['outputs.GetBackendSetsBackendsetBackendResult'],
                 health_checkers: Sequence['outputs.GetBackendSetsBackendsetHealthCheckerResult'],
                 id: _builtins.str,
                 lb_cookie_session_persistence_configurations: Sequence['outputs.GetBackendSetsBackendsetLbCookieSessionPersistenceConfigurationResult'],
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 policy: _builtins.str,
                 session_persistence_configurations: Sequence['outputs.GetBackendSetsBackendsetSessionPersistenceConfigurationResult'],
                 ssl_configurations: Sequence['outputs.GetBackendSetsBackendsetSslConfigurationResult'],
                 state: _builtins.str):
        """
        :param _builtins.int backend_max_connections: The maximum number of simultaneous connections the load balancer can make to any backend in the backend set unless the backend has its own maxConnections setting. If this is not set or set to 0 then the number of simultaneous connections the load balancer can make to any backend in the backend set unless the backend has its own maxConnections setting is unlimited.  Example: `300`
        :param Sequence['GetBackendSetsBackendsetHealthCheckerArgs'] health_checkers: The health check policy configuration. For more information, see [Editing Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/editinghealthcheck.htm).
        :param Sequence['GetBackendSetsBackendsetLbCookieSessionPersistenceConfigurationArgs'] lb_cookie_session_persistence_configurations: The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend sets to retrieve.
        :param _builtins.str name: A friendly name for the backend set. It must be unique and it cannot be changed.
        :param _builtins.str policy: The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        :param Sequence['GetBackendSetsBackendsetSessionPersistenceConfigurationArgs'] session_persistence_configurations: The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
        :param Sequence['GetBackendSetsBackendsetSslConfigurationArgs'] ssl_configurations: A listener's SSL handling configuration.
        """
        pulumi.set(__self__, "backend_max_connections", backend_max_connections)
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "health_checkers", health_checkers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lb_cookie_session_persistence_configurations", lb_cookie_session_persistence_configurations)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "session_persistence_configurations", session_persistence_configurations)
        pulumi.set(__self__, "ssl_configurations", ssl_configurations)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="backendMaxConnections")
    def backend_max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections the load balancer can make to any backend in the backend set unless the backend has its own maxConnections setting. If this is not set or set to 0 then the number of simultaneous connections the load balancer can make to any backend in the backend set unless the backend has its own maxConnections setting is unlimited.  Example: `300`
        """
        return pulumi.get(self, "backend_max_connections")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.GetBackendSetsBackendsetBackendResult']:
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="healthCheckers")
    def health_checkers(self) -> Sequence['outputs.GetBackendSetsBackendsetHealthCheckerResult']:
        """
        The health check policy configuration. For more information, see [Editing Health Check Policies](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/editinghealthcheck.htm).
        """
        return pulumi.get(self, "health_checkers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lbCookieSessionPersistenceConfigurations")
    def lb_cookie_session_persistence_configurations(self) -> Sequence['outputs.GetBackendSetsBackendsetLbCookieSessionPersistenceConfigurationResult']:
        """
        The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
        """
        return pulumi.get(self, "lb_cookie_session_persistence_configurations")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend sets to retrieve.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="sessionPersistenceConfigurations")
    def session_persistence_configurations(self) -> Sequence['outputs.GetBackendSetsBackendsetSessionPersistenceConfigurationResult']:
        """
        The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
        """
        return pulumi.get(self, "session_persistence_configurations")

    @_builtins.property
    @pulumi.getter(name="sslConfigurations")
    def ssl_configurations(self) -> Sequence['outputs.GetBackendSetsBackendsetSslConfigurationResult']:
        """
        A listener's SSL handling configuration.
        """
        return pulumi.get(self, "ssl_configurations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBackendSetsBackendsetBackendResult(dict):
    def __init__(__self__, *,
                 backup: _builtins.bool,
                 drain: _builtins.bool,
                 ip_address: _builtins.str,
                 max_connections: _builtins.int,
                 name: _builtins.str,
                 offline: _builtins.bool,
                 port: _builtins.int,
                 weight: _builtins.int):
        """
        :param _builtins.bool backup: Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
        :param _builtins.bool drain: Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param _builtins.str ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param _builtins.int max_connections: The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.  Example: `300`
        :param _builtins.str name: A friendly name for the backend set. It must be unique and it cannot be changed.
        :param _builtins.bool offline: Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        :param _builtins.int weight: The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "drain", drain)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "offline", offline)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> _builtins.bool:
        """
        Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter
    def drain(self) -> _builtins.bool:
        """
        Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.  Example: `300`
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def offline(self) -> _builtins.bool:
        """
        Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendSetsBackendsetHealthCheckerResult(dict):
    def __init__(__self__, *,
                 interval_ms: _builtins.int,
                 is_force_plain_text: _builtins.bool,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 response_body_regex: _builtins.str,
                 retries: _builtins.int,
                 return_code: _builtins.int,
                 timeout_in_millis: _builtins.int,
                 url_path: _builtins.str):
        """
        :param _builtins.int interval_ms: The interval between health checks, in milliseconds. The default is 10000 (10 seconds).  Example: `10000`
        :param _builtins.bool is_force_plain_text: Specifies if health checks should always be done using plain text instead of depending on whether or not the associated backend set is using SSL.
        :param _builtins.int port: The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        :param _builtins.str protocol: The protocol the health check must use; either HTTP or TCP.  Example: `HTTP`
        :param _builtins.str response_body_regex: A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        :param _builtins.int retries: The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. Defaults to 3.  Example: `3`
        :param _builtins.int return_code: The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, you can use common HTTP status codes such as "200".  Example: `200`
        :param _builtins.int timeout_in_millis: The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. Defaults to 3000 (3 seconds).  Example: `3000`
        :param _builtins.str url_path: The path against which to run the health check.  Example: `/healthcheck`
        """
        pulumi.set(__self__, "interval_ms", interval_ms)
        pulumi.set(__self__, "is_force_plain_text", is_force_plain_text)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "response_body_regex", response_body_regex)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "return_code", return_code)
        pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="intervalMs")
    def interval_ms(self) -> _builtins.int:
        """
        The interval between health checks, in milliseconds. The default is 10000 (10 seconds).  Example: `10000`
        """
        return pulumi.get(self, "interval_ms")

    @_builtins.property
    @pulumi.getter(name="isForcePlainText")
    def is_force_plain_text(self) -> _builtins.bool:
        """
        Specifies if health checks should always be done using plain text instead of depending on whether or not the associated backend set is using SSL.
        """
        return pulumi.get(self, "is_force_plain_text")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The backend server port against which to run the health check. If the port is not specified, the load balancer uses the port information from the `Backend` object.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol the health check must use; either HTTP or TCP.  Example: `HTTP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="responseBodyRegex")
    def response_body_regex(self) -> _builtins.str:
        """
        A regular expression for parsing the response body from the backend server.  Example: `^((?!false).|\\s)*$`
        """
        return pulumi.get(self, "response_body_regex")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        The number of retries to attempt before a backend server is considered "unhealthy". This number also applies when recovering a server to the "healthy" state. Defaults to 3.  Example: `3`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="returnCode")
    def return_code(self) -> _builtins.int:
        """
        The status code a healthy backend server should return. If you configure the health check policy to use the HTTP protocol, you can use common HTTP status codes such as "200".  Example: `200`
        """
        return pulumi.get(self, "return_code")

    @_builtins.property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> _builtins.int:
        """
        The maximum time, in milliseconds, to wait for a reply to a health check. A health check is successful only if a reply returns within this timeout period. Defaults to 3000 (3 seconds).  Example: `3000`
        """
        return pulumi.get(self, "timeout_in_millis")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> _builtins.str:
        """
        The path against which to run the health check.  Example: `/healthcheck`
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class GetBackendSetsBackendsetLbCookieSessionPersistenceConfigurationResult(dict):
    def __init__(__self__, *,
                 cookie_name: _builtins.str,
                 disable_fallback: _builtins.bool,
                 domain: _builtins.str,
                 is_http_only: _builtins.bool,
                 is_secure: _builtins.bool,
                 max_age_in_seconds: _builtins.int,
                 path: _builtins.str):
        """
        :param _builtins.str cookie_name: The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        :param _builtins.bool disable_fallback: Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        :param _builtins.str domain: The domain in which the cookie is valid. The `Set-cookie` header inserted by the load balancer contains a domain attribute with the specified value.
        :param _builtins.bool is_http_only: Whether the `Set-cookie` header should contain the `HttpOnly` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `HttpOnly` attribute, which limits the scope of the cookie to HTTP requests. This attribute directs the client or browser to omit the cookie when providing access to cookies through non-HTTP APIs. For example, it restricts the cookie from JavaScript channels.  Example: `true`
        :param _builtins.bool is_secure: Whether the `Set-cookie` header should contain the `Secure` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `Secure` attribute, which directs the client or browser to send the cookie only using a secure protocol.
        :param _builtins.int max_age_in_seconds: The amount of time the cookie remains valid. The `Set-cookie` header inserted by the load balancer contains a `Max-Age` attribute with the specified value.
        :param _builtins.str path: The path in which the cookie is valid. The `Set-cookie header` inserted by the load balancer contains a `Path` attribute with the specified value.
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "disable_fallback", disable_fallback)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "is_http_only", is_http_only)
        pulumi.set(__self__, "is_secure", is_secure)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        """
        The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="disableFallback")
    def disable_fallback(self) -> _builtins.bool:
        """
        Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        return pulumi.get(self, "disable_fallback")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain in which the cookie is valid. The `Set-cookie` header inserted by the load balancer contains a domain attribute with the specified value.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="isHttpOnly")
    def is_http_only(self) -> _builtins.bool:
        """
        Whether the `Set-cookie` header should contain the `HttpOnly` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `HttpOnly` attribute, which limits the scope of the cookie to HTTP requests. This attribute directs the client or browser to omit the cookie when providing access to cookies through non-HTTP APIs. For example, it restricts the cookie from JavaScript channels.  Example: `true`
        """
        return pulumi.get(self, "is_http_only")

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> _builtins.bool:
        """
        Whether the `Set-cookie` header should contain the `Secure` attribute. If `true`, the `Set-cookie` header inserted by the load balancer contains the `Secure` attribute, which directs the client or browser to send the cookie only using a secure protocol.
        """
        return pulumi.get(self, "is_secure")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The amount of time the cookie remains valid. The `Set-cookie` header inserted by the load balancer contains a `Max-Age` attribute with the specified value.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in which the cookie is valid. The `Set-cookie header` inserted by the load balancer contains a `Path` attribute with the specified value.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetBackendSetsBackendsetSessionPersistenceConfigurationResult(dict):
    def __init__(__self__, *,
                 cookie_name: _builtins.str,
                 disable_fallback: _builtins.bool):
        """
        :param _builtins.str cookie_name: The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        :param _builtins.bool disable_fallback: Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "disable_fallback", disable_fallback)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        """
        The name of the cookie used to detect a session initiated by the backend server. Use '*' to specify that any cookie set by the backend causes the session to persist.  Example: `example_cookie`
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="disableFallback")
    def disable_fallback(self) -> _builtins.bool:
        """
        Whether the load balancer is prevented from directing traffic from a persistent session client to a different backend server if the original server is unavailable. Defaults to false.  Example: `false`
        """
        return pulumi.get(self, "disable_fallback")


@pulumi.output_type
class GetBackendSetsBackendsetSslConfigurationResult(dict):
    def __init__(__self__, *,
                 certificate_ids: Sequence[_builtins.str],
                 certificate_name: _builtins.str,
                 cipher_suite_name: _builtins.str,
                 protocols: Sequence[_builtins.str],
                 server_order_preference: _builtins.str,
                 trusted_certificate_authority_ids: Sequence[_builtins.str],
                 verify_depth: _builtins.int,
                 verify_peer_certificate: _builtins.bool):
        """
        :param Sequence[_builtins.str] certificate_ids: Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        :param _builtins.str certificate_name: A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        :param _builtins.str cipher_suite_name: The name of the cipher suite to use for HTTPS or SSL connections.
        :param Sequence[_builtins.str] protocols: A list of SSL protocols the load balancer must support for HTTPS or SSL connections.
        :param _builtins.str server_order_preference: When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.
        :param Sequence[_builtins.str] trusted_certificate_authority_ids: Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        :param _builtins.int verify_depth: The maximum depth for peer certificate chain verification.  Example: `3`
        :param _builtins.bool verify_peer_certificate: Whether the load balancer listener should verify peer certificates.  Example: `true`
        """
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "cipher_suite_name", cipher_suite_name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "server_order_preference", server_order_preference)
        pulumi.set(__self__, "trusted_certificate_authority_ids", trusted_certificate_authority_ids)
        pulumi.set(__self__, "verify_depth", verify_depth)
        pulumi.set(__self__, "verify_peer_certificate", verify_peer_certificate)

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[_builtins.str]:
        """
        Ids for Oracle Cloud Infrastructure certificates service certificates. Currently only a single Id may be passed.  Example: `[ocid1.certificate.oc1.us-ashburn-1.amaaaaaaav3bgsaa5o2q7rh5nfmkkukfkogasqhk6af2opufhjlqg7m6jqzq]`
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> _builtins.str:
        """
        A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="cipherSuiteName")
    def cipher_suite_name(self) -> _builtins.str:
        """
        The name of the cipher suite to use for HTTPS or SSL connections.
        """
        return pulumi.get(self, "cipher_suite_name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.str]:
        """
        A list of SSL protocols the load balancer must support for HTTPS or SSL connections.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="serverOrderPreference")
    def server_order_preference(self) -> _builtins.str:
        """
        When this attribute is set to ENABLED, the system gives preference to the server ciphers over the client ciphers.
        """
        return pulumi.get(self, "server_order_preference")

    @_builtins.property
    @pulumi.getter(name="trustedCertificateAuthorityIds")
    def trusted_certificate_authority_ids(self) -> Sequence[_builtins.str]:
        """
        Ids for Oracle Cloud Infrastructure certificates service CA or CA bundles for the load balancer to trust.  Example: `[ocid1.cabundle.oc1.us-ashburn-1.amaaaaaaav3bgsaagl4zzyqdop5i2vuwoqewdvauuw34llqa74otq2jdsfyq]`
        """
        return pulumi.get(self, "trusted_certificate_authority_ids")

    @_builtins.property
    @pulumi.getter(name="verifyDepth")
    def verify_depth(self) -> _builtins.int:
        """
        The maximum depth for peer certificate chain verification.  Example: `3`
        """
        return pulumi.get(self, "verify_depth")

    @_builtins.property
    @pulumi.getter(name="verifyPeerCertificate")
    def verify_peer_certificate(self) -> _builtins.bool:
        """
        Whether the load balancer listener should verify peer certificates.  Example: `true`
        """
        return pulumi.get(self, "verify_peer_certificate")


@pulumi.output_type
class GetBackendSetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the backend set. It must be unique and it cannot be changed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBackendsBackendResult(dict):
    def __init__(__self__, *,
                 backendset_name: _builtins.str,
                 drain: _builtins.bool,
                 ip_address: _builtins.str,
                 load_balancer_id: _builtins.str,
                 max_connections: _builtins.int,
                 name: _builtins.str,
                 offline: _builtins.bool,
                 port: _builtins.int,
                 state: _builtins.str,
                 weight: _builtins.int,
                 backup: Optional[_builtins.bool] = None):
        """
        :param _builtins.str backendset_name: The name of the backend set associated with the backend servers.  Example: `example_backend_set`
        :param _builtins.bool drain: Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param _builtins.str ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        :param _builtins.int max_connections: The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.  Example: `300`
        :param _builtins.str name: A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        :param _builtins.bool offline: Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param _builtins.int port: The communication port for the backend server.  Example: `8080`
        :param _builtins.int weight: The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        :param _builtins.bool backup: Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
        """
        pulumi.set(__self__, "backendset_name", backendset_name)
        pulumi.set(__self__, "drain", drain)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "offline", offline)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "weight", weight)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)

    @_builtins.property
    @pulumi.getter(name="backendsetName")
    def backendset_name(self) -> _builtins.str:
        """
        The name of the backend set associated with the backend servers.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backendset_name")

    @_builtins.property
    @pulumi.getter
    def drain(self) -> _builtins.bool:
        """
        Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections the load balancer can make to the backend. If this is not set or set to 0 then the maximum number of simultaneous connections the load balancer can make to the backend is unlimited.  Example: `300`
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def offline(self) -> _builtins.bool:
        """
        Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3`
        """
        return pulumi.get(self, "weight")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[_builtins.bool]:
        """
        Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
        """
        return pulumi.get(self, "backup")


@pulumi.output_type
class GetBackendsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 ca_certificate: _builtins.str,
                 certificate_name: _builtins.str,
                 load_balancer_id: _builtins.str,
                 private_key: _builtins.str,
                 public_certificate: _builtins.str,
                 state: _builtins.str,
                 passphrase: Optional[_builtins.str] = None):
        """
        :param _builtins.str ca_certificate: The Certificate Authority certificate, or any interim certificate, that you received from your SSL certificate provider.
        :param _builtins.str certificate_name: A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the certificate bundles to be listed.
        :param _builtins.str public_certificate: The public certificate, in PEM format, that you received from your SSL certificate provider.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "public_certificate", public_certificate)
        pulumi.set(__self__, "state", state)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> _builtins.str:
        """
        The Certificate Authority certificate, or any interim certificate, that you received from your SSL certificate provider.
        """
        return pulumi.get(self, "ca_certificate")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> _builtins.str:
        """
        A friendly name for the certificate bundle. It must be unique and it cannot be changed. Valid certificate bundle names include only alphanumeric characters, dashes, and underscores. Certificate bundle names cannot contain spaces. Avoid entering confidential information.  Example: `example_certificate_bundle`
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the certificate bundles to be listed.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> _builtins.str:
        """
        The public certificate, in PEM format, that you received from your SSL certificate provider.
        """
        return pulumi.get(self, "public_certificate")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "passphrase")


@pulumi.output_type
class GetCertificatesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHostnamesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the hostname resource. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_hostname_001`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the hostname resource. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_hostname_001`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHostnamesHostnameResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str hostname: A virtual hostname. For more information about virtual hostname string construction, see [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm#routing).  Example: `app.example.com`
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the hostnames to retrieve.
        :param _builtins.str name: A friendly name for the hostname resource. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_hostname_001`
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        A virtual hostname. For more information about virtual hostname string construction, see [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm#routing).  Example: `app.example.com`
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the hostnames to retrieve.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the hostname resource. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_hostname_001`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetListenerRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the rule set that the rule belongs to.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule set that the rule belongs to.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListenerRulesListenerRuleResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 rules: Sequence['outputs.GetListenerRulesListenerRuleRuleResult'],
                 state: _builtins.str):
        """
        :param _builtins.str name: The name of the rule set that the rule belongs to.
        :param Sequence['GetListenerRulesListenerRuleRuleArgs'] rules: A rule object that applies to the listener.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule set that the rule belongs to.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetListenerRulesListenerRuleRuleResult']:
        """
        A rule object that applies to the listener.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetListenerRulesListenerRuleRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 allowed_methods: Sequence[_builtins.str],
                 are_invalid_characters_allowed: _builtins.bool,
                 conditions: Sequence['outputs.GetListenerRulesListenerRuleRuleConditionResult'],
                 default_max_connections: _builtins.int,
                 description: _builtins.str,
                 header: _builtins.str,
                 http_large_header_size_in_kb: _builtins.int,
                 ip_max_connections: Sequence['outputs.GetListenerRulesListenerRuleRuleIpMaxConnectionResult'],
                 prefix: _builtins.str,
                 redirect_uris: Sequence['outputs.GetListenerRulesListenerRuleRuleRedirectUriResult'],
                 response_code: _builtins.int,
                 status_code: _builtins.int,
                 suffix: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str action: The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        :param Sequence[_builtins.str] allowed_methods: The list of HTTP methods allowed for this listener.
        :param _builtins.bool are_invalid_characters_allowed: Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        :param _builtins.int default_max_connections: The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        :param _builtins.str description: A brief description of the access control rule. Avoid entering confidential information.
        :param _builtins.str header: A header name that conforms to RFC 7230.  Example: `example_header_name`
        :param _builtins.int http_large_header_size_in_kb: The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        :param Sequence['GetListenerRulesListenerRuleRuleIpMaxConnectionArgs'] ip_max_connections: An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        :param _builtins.str prefix: A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param Sequence['GetListenerRulesListenerRuleRuleRedirectUriArgs'] redirect_uris: An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        :param _builtins.int response_code: The HTTP status code to return when the incoming request is redirected.
        :param _builtins.int status_code: The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        :param _builtins.str suffix: A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param _builtins.str value: A header value that conforms to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "are_invalid_characters_allowed", are_invalid_characters_allowed)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "default_max_connections", default_max_connections)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "http_large_header_size_in_kb", http_large_header_size_in_kb)
        pulumi.set(__self__, "ip_max_connections", ip_max_connections)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "redirect_uris", redirect_uris)
        pulumi.set(__self__, "response_code", response_code)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "suffix", suffix)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP methods allowed for this listener.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="areInvalidCharactersAllowed")
    def are_invalid_characters_allowed(self) -> _builtins.bool:
        """
        Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        """
        return pulumi.get(self, "are_invalid_characters_allowed")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetListenerRulesListenerRuleRuleConditionResult']:
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="defaultMaxConnections")
    def default_max_connections(self) -> _builtins.int:
        """
        The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        """
        return pulumi.get(self, "default_max_connections")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A brief description of the access control rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def header(self) -> _builtins.str:
        """
        A header name that conforms to RFC 7230.  Example: `example_header_name`
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter(name="httpLargeHeaderSizeInKb")
    def http_large_header_size_in_kb(self) -> _builtins.int:
        """
        The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        """
        return pulumi.get(self, "http_large_header_size_in_kb")

    @_builtins.property
    @pulumi.getter(name="ipMaxConnections")
    def ip_max_connections(self) -> Sequence['outputs.GetListenerRulesListenerRuleRuleIpMaxConnectionResult']:
        """
        An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        """
        return pulumi.get(self, "ip_max_connections")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Sequence['outputs.GetListenerRulesListenerRuleRuleRedirectUriResult']:
        """
        An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        """
        return pulumi.get(self, "redirect_uris")

    @_builtins.property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the incoming request is redirected.
        """
        return pulumi.get(self, "response_code")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "suffix")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A header value that conforms to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetListenerRulesListenerRuleRuleConditionResult(dict):
    def __init__(__self__, *,
                 attribute_name: _builtins.str,
                 attribute_value: _builtins.str,
                 operator: _builtins.str):
        """
        :param _builtins.str attribute_name: The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        :param _builtins.str attribute_value: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the originating VCN that an incoming packet must match.
        :param _builtins.str operator: A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
               *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
               *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
               *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> _builtins.str:
        """
        The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        """
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the originating VCN that an incoming packet must match.
        """
        return pulumi.get(self, "attribute_value")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
        *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
        *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
        *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetListenerRulesListenerRuleRuleIpMaxConnectionResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[_builtins.str],
                 max_connections: _builtins.int):
        """
        :param Sequence[_builtins.str] ip_addresses: Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        :param _builtins.int max_connections: The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "max_connections", max_connections)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        return pulumi.get(self, "max_connections")


@pulumi.output_type
class GetListenerRulesListenerRuleRuleRedirectUriResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 query: _builtins.str):
        """
        :param _builtins.str host: The valid domain name (hostname) or IP address to use in the redirect URI.
        :param _builtins.str path: The HTTP URI path to use in the redirect URI.
        :param _builtins.int port: The communication port to use in the redirect URI.
        :param _builtins.str protocol: The HTTP protocol to use in the redirect URI.
        :param _builtins.str query: The query string to use in the redirect URI.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The valid domain name (hostname) or IP address to use in the redirect URI.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The HTTP URI path to use in the redirect URI.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port to use in the redirect URI.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The HTTP protocol to use in the redirect URI.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The query string to use in the redirect URI.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GetLoadBalancerRoutingPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLoadBalancerRoutingPoliciesRoutingPolicyResult(dict):
    def __init__(__self__, *,
                 condition_language_version: _builtins.str,
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 rules: Sequence['outputs.GetLoadBalancerRoutingPoliciesRoutingPolicyRuleResult'],
                 state: _builtins.str):
        """
        :param _builtins.str condition_language_version: The version of the language in which `condition` of `rules` are composed.
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the routing policies.
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        :param Sequence['GetLoadBalancerRoutingPoliciesRoutingPolicyRuleArgs'] rules: The ordered list of routing rules.
        """
        pulumi.set(__self__, "condition_language_version", condition_language_version)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="conditionLanguageVersion")
    def condition_language_version(self) -> _builtins.str:
        """
        The version of the language in which `condition` of `rules` are composed.
        """
        return pulumi.get(self, "condition_language_version")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the routing policies.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetLoadBalancerRoutingPoliciesRoutingPolicyRuleResult']:
        """
        The ordered list of routing rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetLoadBalancerRoutingPoliciesRoutingPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLoadBalancerRoutingPoliciesRoutingPolicyRuleActionResult'],
                 condition: _builtins.str,
                 name: _builtins.str):
        """
        :param Sequence['GetLoadBalancerRoutingPoliciesRoutingPolicyRuleActionArgs'] actions: A list of actions to be applied when conditions of the routing rule are met.
        :param _builtins.str condition: A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLoadBalancerRoutingPoliciesRoutingPolicyRuleActionResult']:
        """
        A list of actions to be applied when conditions of the routing rule are met.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancerRoutingPoliciesRoutingPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str backend_set_name: Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancerRoutingPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLoadBalancerRoutingPolicyRuleActionResult'],
                 condition: _builtins.str,
                 name: _builtins.str):
        """
        :param Sequence['GetLoadBalancerRoutingPolicyRuleActionArgs'] actions: A list of actions to be applied when conditions of the routing rule are met.
        :param _builtins.str condition: A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLoadBalancerRoutingPolicyRuleActionResult']:
        """
        A list of actions to be applied when conditions of the routing rule are met.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        A routing rule to evaluate defined conditions against the incoming HTTP request and perform an action.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancerRoutingPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str backend_set_name: Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        :param _builtins.str name: A unique name for the routing policy rule. Avoid entering confidential information.
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        Name of the backend set the listener will forward the traffic to.  Example: `backendSetForImages`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique name for the routing policy rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLoadBalancersLoadBalancerResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 ip_address_details: Sequence['outputs.GetLoadBalancersLoadBalancerIpAddressDetailResult'],
                 ip_addresses: Sequence[_builtins.str],
                 ip_mode: _builtins.str,
                 ipv6subnet_cidr: _builtins.str,
                 is_delete_protection_enabled: _builtins.bool,
                 is_private: _builtins.bool,
                 is_request_id_enabled: _builtins.bool,
                 network_security_group_ids: Sequence[_builtins.str],
                 request_id_header: _builtins.str,
                 reserved_ips: Sequence['outputs.GetLoadBalancersLoadBalancerReservedIpResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 shape: _builtins.str,
                 shape_details: Sequence['outputs.GetLoadBalancersLoadBalancerShapeDetailResult'],
                 state: _builtins.str,
                 subnet_ids: Sequence[_builtins.str],
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the load balancers to list.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_load_balancer`
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: Ocid of the Reserved IP/Public Ip created with VCN.
        :param Sequence['GetLoadBalancersLoadBalancerIpAddressDetailArgs'] ip_address_details: An array of IP addresses.
        :param Sequence[_builtins.str] ip_addresses: An array of IP addresses. Deprecated: use ip_address_details instead.
        :param _builtins.bool is_delete_protection_enabled: Whether or not the load balancer has delete protection enabled.
        :param _builtins.bool is_private: Whether the load balancer has a VCN-local (private) IP address.
        :param _builtins.bool is_request_id_enabled: Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
        :param Sequence[_builtins.str] network_security_group_ids: An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the load balancer.
        :param _builtins.str request_id_header: If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
        :param Mapping[str, _builtins.str] security_attributes: Extended Defined tags for ZPR for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value":"42","mode":"audit", "usagetype" : "zpr"}}}`
        :param _builtins.str shape: A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `100Mbps`
        :param Sequence['GetLoadBalancersLoadBalancerShapeDetailArgs'] shape_details: The configuration details to update load balancer to a different shape.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state.  Example: `SUCCEEDED`
        :param Sequence[_builtins.str] subnet_ids: An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address_details", ip_address_details)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "ip_mode", ip_mode)
        pulumi.set(__self__, "ipv6subnet_cidr", ipv6subnet_cidr)
        pulumi.set(__self__, "is_delete_protection_enabled", is_delete_protection_enabled)
        pulumi.set(__self__, "is_private", is_private)
        pulumi.set(__self__, "is_request_id_enabled", is_request_id_enabled)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "request_id_header", request_id_header)
        pulumi.set(__self__, "reserved_ips", reserved_ips)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_details", shape_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the load balancers to list.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.  Example: `example_load_balancer`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Ocid of the Reserved IP/Public Ip created with VCN.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddressDetails")
    def ip_address_details(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerIpAddressDetailResult']:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_address_details")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    @_utilities.deprecated("""The 'ip_addresses' field has been deprecated. Please use 'ip_address_details' instead.""")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        An array of IP addresses. Deprecated: use ip_address_details instead.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> _builtins.str:
        return pulumi.get(self, "ip_mode")

    @_builtins.property
    @pulumi.getter(name="ipv6subnetCidr")
    def ipv6subnet_cidr(self) -> _builtins.str:
        return pulumi.get(self, "ipv6subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtectionEnabled")
    def is_delete_protection_enabled(self) -> _builtins.bool:
        """
        Whether or not the load balancer has delete protection enabled.
        """
        return pulumi.get(self, "is_delete_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> _builtins.bool:
        """
        Whether the load balancer has a VCN-local (private) IP address.
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="isRequestIdEnabled")
    def is_request_id_enabled(self) -> _builtins.bool:
        """
        Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
        """
        return pulumi.get(self, "is_request_id_enabled")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the load balancer.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="requestIdHeader")
    def request_id_header(self) -> _builtins.str:
        """
        If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
        """
        return pulumi.get(self, "request_id_header")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerReservedIpResult']:
        return pulumi.get(self, "reserved_ips")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Extended Defined tags for ZPR for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value":"42","mode":"audit", "usagetype" : "zpr"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `100Mbps`
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeDetails")
    def shape_details(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerShapeDetailResult']:
        """
        The configuration details to update load balancer to a different shape.
        """
        return pulumi.get(self, "shape_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state.  Example: `SUCCEEDED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetLoadBalancersLoadBalancerIpAddressDetailResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 is_public: _builtins.bool,
                 reserved_ips: Sequence['outputs.GetLoadBalancersLoadBalancerIpAddressDetailReservedIpResult']):
        """
        :param _builtins.str ip_address: An IP address.  Example: `192.168.0.3`
        :param _builtins.bool is_public: Whether the IP address is public or private.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_public", is_public)
        pulumi.set(__self__, "reserved_ips", reserved_ips)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        An IP address.  Example: `192.168.0.3`
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        Whether the IP address is public or private.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerIpAddressDetailReservedIpResult']:
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class GetLoadBalancersLoadBalancerIpAddressDetailReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Ocid of the Reserved IP/Public Ip created with VCN.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Ocid of the Reserved IP/Public Ip created with VCN.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadBalancersLoadBalancerReservedIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Ocid of the Reserved IP/Public Ip created with VCN.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Ocid of the Reserved IP/Public Ip created with VCN.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadBalancersLoadBalancerShapeDetailResult(dict):
    def __init__(__self__, *,
                 maximum_bandwidth_in_mbps: _builtins.int,
                 minimum_bandwidth_in_mbps: _builtins.int):
        """
        :param _builtins.int maximum_bandwidth_in_mbps: Bandwidth in Mbps that determines the maximum bandwidth (ingress plus egress) that the load balancer can achieve. This bandwidth cannot be always guaranteed. For a guaranteed bandwidth use the minimumBandwidthInMbps parameter.
        :param _builtins.int minimum_bandwidth_in_mbps: Bandwidth in Mbps that determines the total pre-provisioned bandwidth (ingress plus egress). The values must be between 0 and the maximumBandwidthInMbps in multiples of 10. The current allowed maximum value is defined in [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).  Example: `150`
        """
        pulumi.set(__self__, "maximum_bandwidth_in_mbps", maximum_bandwidth_in_mbps)
        pulumi.set(__self__, "minimum_bandwidth_in_mbps", minimum_bandwidth_in_mbps)

    @_builtins.property
    @pulumi.getter(name="maximumBandwidthInMbps")
    def maximum_bandwidth_in_mbps(self) -> _builtins.int:
        """
        Bandwidth in Mbps that determines the maximum bandwidth (ingress plus egress) that the load balancer can achieve. This bandwidth cannot be always guaranteed. For a guaranteed bandwidth use the minimumBandwidthInMbps parameter.
        """
        return pulumi.get(self, "maximum_bandwidth_in_mbps")

    @_builtins.property
    @pulumi.getter(name="minimumBandwidthInMbps")
    def minimum_bandwidth_in_mbps(self) -> _builtins.int:
        """
        Bandwidth in Mbps that determines the total pre-provisioned bandwidth (ingress plus egress). The values must be between 0 and the maximumBandwidthInMbps in multiples of 10. The current allowed maximum value is defined in [Service Limits](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/servicelimits.htm).  Example: `150`
        """
        return pulumi.get(self, "minimum_bandwidth_in_mbps")


@pulumi.output_type
class GetPathRouteSetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The unique name for this set of path route rules. Avoid entering confidential information.  Example: `example_path_route_set`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name for this set of path route rules. Avoid entering confidential information.  Example: `example_path_route_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPathRouteSetsPathRouteSetResult(dict):
    def __init__(__self__, *,
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 path_routes: Sequence['outputs.GetPathRouteSetsPathRouteSetPathRouteResult'],
                 state: _builtins.str):
        """
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the path route sets to retrieve.
        :param _builtins.str name: The unique name for this set of path route rules. Avoid entering confidential information.  Example: `example_path_route_set`
        :param Sequence['GetPathRouteSetsPathRouteSetPathRouteArgs'] path_routes: The set of path route rules.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path_routes", path_routes)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the path route sets to retrieve.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name for this set of path route rules. Avoid entering confidential information.  Example: `example_path_route_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pathRoutes")
    def path_routes(self) -> Sequence['outputs.GetPathRouteSetsPathRouteSetPathRouteResult']:
        """
        The set of path route rules.
        """
        return pulumi.get(self, "path_routes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetPathRouteSetsPathRouteSetPathRouteResult(dict):
    def __init__(__self__, *,
                 backend_set_name: _builtins.str,
                 path: _builtins.str,
                 path_match_type: 'outputs.GetPathRouteSetsPathRouteSetPathRoutePathMatchTypeResult'):
        """
        :param _builtins.str backend_set_name: The name of the target backend set for requests where the incoming URI matches the specified path.  Example: `example_backend_set`
        :param _builtins.str path: The path string to match against the incoming URI path.
               *  Path strings are case-insensitive.
               *  Asterisk (*) wildcards are not supported.
               *  Regular expressions are not supported.
        :param 'GetPathRouteSetsPathRouteSetPathRoutePathMatchTypeArgs' path_match_type: The type of matching to apply to incoming URIs.
        """
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "path_match_type", path_match_type)

    @_builtins.property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> _builtins.str:
        """
        The name of the target backend set for requests where the incoming URI matches the specified path.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backend_set_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path string to match against the incoming URI path.
        *  Path strings are case-insensitive.
        *  Asterisk (*) wildcards are not supported.
        *  Regular expressions are not supported.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathMatchType")
    def path_match_type(self) -> 'outputs.GetPathRouteSetsPathRouteSetPathRoutePathMatchTypeResult':
        """
        The type of matching to apply to incoming URIs.
        """
        return pulumi.get(self, "path_match_type")


@pulumi.output_type
class GetPathRouteSetsPathRouteSetPathRoutePathMatchTypeResult(dict):
    def __init__(__self__, *,
                 match_type: _builtins.str):
        """
        :param _builtins.str match_type: Specifies how the load balancing service compares a [PathRoute](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/requests/PathRoute) object's `path` string against the incoming URI.
               *  **EXACT_MATCH** - Looks for a `path` string that exactly matches the incoming URI path.
               *  **FORCE_LONGEST_PREFIX_MATCH** - Looks for the `path` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - Looks for a `path` string that matches the beginning portion of the incoming URI path.
               *  **SUFFIX_MATCH** - Looks for a `path` string that matches the ending portion of the incoming URI path.
        """
        pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> _builtins.str:
        """
        Specifies how the load balancing service compares a [PathRoute](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/requests/PathRoute) object's `path` string against the incoming URI.
        *  **EXACT_MATCH** - Looks for a `path` string that exactly matches the incoming URI path.
        *  **FORCE_LONGEST_PREFIX_MATCH** - Looks for the `path` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - Looks for a `path` string that matches the beginning portion of the incoming URI path.
        *  **SUFFIX_MATCH** - Looks for a `path` string that matches the ending portion of the incoming URI path.
        """
        return pulumi.get(self, "match_type")


@pulumi.output_type
class GetPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of a load balancing policy.  Example: 'LEAST_CONNECTIONS'
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a load balancing policy.  Example: 'LEAST_CONNECTIONS'
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of a load balancing policy.  Example: 'LEAST_CONNECTIONS'
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a load balancing policy.  Example: 'LEAST_CONNECTIONS'
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProtocolsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of a protocol.  Example: 'HTTP'
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a protocol.  Example: 'HTTP'
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProtocolsProtocolResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of a protocol.  Example: 'HTTP'
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of a protocol.  Example: 'HTTP'
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRuleSetItemResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 allowed_methods: Sequence[_builtins.str],
                 are_invalid_characters_allowed: _builtins.bool,
                 conditions: Sequence['outputs.GetRuleSetItemConditionResult'],
                 default_max_connections: _builtins.int,
                 description: _builtins.str,
                 header: _builtins.str,
                 http_large_header_size_in_kb: _builtins.int,
                 ip_max_connections: Sequence['outputs.GetRuleSetItemIpMaxConnectionResult'],
                 prefix: _builtins.str,
                 redirect_uris: Sequence['outputs.GetRuleSetItemRedirectUriResult'],
                 response_code: _builtins.int,
                 status_code: _builtins.int,
                 suffix: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str action: The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        :param Sequence[_builtins.str] allowed_methods: The list of HTTP methods allowed for this listener.
        :param _builtins.bool are_invalid_characters_allowed: Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        :param _builtins.int default_max_connections: The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        :param _builtins.str description: A brief description of the access control rule. Avoid entering confidential information.
        :param _builtins.str header: A header name that conforms to RFC 7230.  Example: `example_header_name`
        :param _builtins.int http_large_header_size_in_kb: The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        :param Sequence['GetRuleSetItemIpMaxConnectionArgs'] ip_max_connections: An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        :param _builtins.str prefix: A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param Sequence['GetRuleSetItemRedirectUriArgs'] redirect_uris: An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        :param _builtins.int response_code: The HTTP status code to return when the incoming request is redirected.
        :param _builtins.int status_code: The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        :param _builtins.str suffix: A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param _builtins.str value: A header value that conforms to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "are_invalid_characters_allowed", are_invalid_characters_allowed)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "default_max_connections", default_max_connections)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "http_large_header_size_in_kb", http_large_header_size_in_kb)
        pulumi.set(__self__, "ip_max_connections", ip_max_connections)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "redirect_uris", redirect_uris)
        pulumi.set(__self__, "response_code", response_code)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "suffix", suffix)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP methods allowed for this listener.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="areInvalidCharactersAllowed")
    def are_invalid_characters_allowed(self) -> _builtins.bool:
        """
        Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        """
        return pulumi.get(self, "are_invalid_characters_allowed")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetRuleSetItemConditionResult']:
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="defaultMaxConnections")
    def default_max_connections(self) -> _builtins.int:
        """
        The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        """
        return pulumi.get(self, "default_max_connections")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A brief description of the access control rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def header(self) -> _builtins.str:
        """
        A header name that conforms to RFC 7230.  Example: `example_header_name`
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter(name="httpLargeHeaderSizeInKb")
    def http_large_header_size_in_kb(self) -> _builtins.int:
        """
        The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        """
        return pulumi.get(self, "http_large_header_size_in_kb")

    @_builtins.property
    @pulumi.getter(name="ipMaxConnections")
    def ip_max_connections(self) -> Sequence['outputs.GetRuleSetItemIpMaxConnectionResult']:
        """
        An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        """
        return pulumi.get(self, "ip_max_connections")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Sequence['outputs.GetRuleSetItemRedirectUriResult']:
        """
        An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        """
        return pulumi.get(self, "redirect_uris")

    @_builtins.property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the incoming request is redirected.
        """
        return pulumi.get(self, "response_code")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "suffix")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A header value that conforms to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRuleSetItemConditionResult(dict):
    def __init__(__self__, *,
                 attribute_name: _builtins.str,
                 attribute_value: _builtins.str,
                 operator: _builtins.str):
        """
        :param _builtins.str attribute_name: (Required) (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        :param _builtins.str attribute_value: (Required) (Updatable) Depends on `attribute_name`:
               - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        :param _builtins.str operator: A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
               *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
               *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
               *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> _builtins.str:
        """
        (Required) (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        """
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> _builtins.str:
        """
        (Required) (Updatable) Depends on `attribute_name`:
        - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        """
        return pulumi.get(self, "attribute_value")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
        *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
        *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
        *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetRuleSetItemIpMaxConnectionResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[_builtins.str],
                 max_connections: _builtins.int):
        """
        :param Sequence[_builtins.str] ip_addresses: Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        :param _builtins.int max_connections: The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "max_connections", max_connections)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        return pulumi.get(self, "max_connections")


@pulumi.output_type
class GetRuleSetItemRedirectUriResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 query: _builtins.str):
        """
        :param _builtins.str host: The valid domain name (hostname) or IP address to use in the redirect URI.
        :param _builtins.str path: The HTTP URI path to use in the redirect URI.
        :param _builtins.int port: The communication port to use in the redirect URI.
        :param _builtins.str protocol: The HTTP protocol to use in the redirect URI.
        :param _builtins.str query: The query string to use in the redirect URI.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The valid domain name (hostname) or IP address to use in the redirect URI.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The HTTP URI path to use in the redirect URI.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port to use in the redirect URI.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The HTTP protocol to use in the redirect URI.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The query string to use in the redirect URI.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GetRuleSetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRuleSetsRuleSetResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 items: Sequence['outputs.GetRuleSetsRuleSetItemResult'],
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str):
        """
        :param Sequence['GetRuleSetsRuleSetItemArgs'] items: An array of rules that compose the rule set.
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        :param _builtins.str name: The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRuleSetsRuleSetItemResult']:
        """
        An array of rules that compose the rule set.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the specified load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for this set of rules. It must be unique and it cannot be changed. Avoid entering confidential information.  Example: `example_rule_set`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


@pulumi.output_type
class GetRuleSetsRuleSetItemResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 allowed_methods: Sequence[_builtins.str],
                 are_invalid_characters_allowed: _builtins.bool,
                 conditions: Sequence['outputs.GetRuleSetsRuleSetItemConditionResult'],
                 default_max_connections: _builtins.int,
                 description: _builtins.str,
                 header: _builtins.str,
                 http_large_header_size_in_kb: _builtins.int,
                 ip_max_connections: Sequence['outputs.GetRuleSetsRuleSetItemIpMaxConnectionResult'],
                 prefix: _builtins.str,
                 redirect_uris: Sequence['outputs.GetRuleSetsRuleSetItemRedirectUriResult'],
                 response_code: _builtins.int,
                 status_code: _builtins.int,
                 suffix: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str action: The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        :param Sequence[_builtins.str] allowed_methods: The list of HTTP methods allowed for this listener.
        :param _builtins.bool are_invalid_characters_allowed: Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        :param _builtins.int default_max_connections: The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        :param _builtins.str description: A brief description of the access control rule. Avoid entering confidential information.
        :param _builtins.str header: A header name that conforms to RFC 7230.  Example: `example_header_name`
        :param _builtins.int http_large_header_size_in_kb: The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        :param Sequence['GetRuleSetsRuleSetItemIpMaxConnectionArgs'] ip_max_connections: An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        :param _builtins.str prefix: A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param Sequence['GetRuleSetsRuleSetItemRedirectUriArgs'] redirect_uris: An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        :param _builtins.int response_code: The HTTP status code to return when the incoming request is redirected.
        :param _builtins.int status_code: The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        :param _builtins.str suffix: A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        :param _builtins.str value: A header value that conforms to RFC 7230. With the following exceptions:
               *  value cannot contain `$`
               *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "are_invalid_characters_allowed", are_invalid_characters_allowed)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "default_max_connections", default_max_connections)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "http_large_header_size_in_kb", http_large_header_size_in_kb)
        pulumi.set(__self__, "ip_max_connections", ip_max_connections)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "redirect_uris", redirect_uris)
        pulumi.set(__self__, "response_code", response_code)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "suffix", suffix)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action can be one of these values: `ADD_HTTP_REQUEST_HEADER`, `ADD_HTTP_RESPONSE_HEADER`, `ALLOW`, `CONTROL_ACCESS_USING_HTTP_METHODS`, `EXTEND_HTTP_REQUEST_HEADER_VALUE`, `EXTEND_HTTP_RESPONSE_HEADER_VALUE`, `HTTP_HEADER`, `IP_BASED_MAX_CONNECTIONS`, `REDIRECT`, `REMOVE_HTTP_REQUEST_HEADER`, `REMOVE_HTTP_RESPONSE_HEADER`
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP methods allowed for this listener.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="areInvalidCharactersAllowed")
    def are_invalid_characters_allowed(self) -> _builtins.bool:
        """
        Indicates whether or not invalid characters in client header fields will be allowed. Valid names are composed of English letters, digits, hyphens and underscores. If "true", invalid characters are allowed in the HTTP header. If "false", invalid characters are not allowed in the HTTP header
        """
        return pulumi.get(self, "are_invalid_characters_allowed")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetRuleSetsRuleSetItemConditionResult']:
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="defaultMaxConnections")
    def default_max_connections(self) -> _builtins.int:
        """
        The maximum number of connections that the any IP can make to a listener unless the IP is mentioned in maxConnections. If no defaultMaxConnections is specified the default is unlimited.
        """
        return pulumi.get(self, "default_max_connections")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A brief description of the access control rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def header(self) -> _builtins.str:
        """
        A header name that conforms to RFC 7230.  Example: `example_header_name`
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter(name="httpLargeHeaderSizeInKb")
    def http_large_header_size_in_kb(self) -> _builtins.int:
        """
        The maximum size of each buffer used for reading http client request header. This value indicates the maximum size allowed for each buffer. The allowed values for buffer size are 8, 16, 32 and 64.
        """
        return pulumi.get(self, "http_large_header_size_in_kb")

    @_builtins.property
    @pulumi.getter(name="ipMaxConnections")
    def ip_max_connections(self) -> Sequence['outputs.GetRuleSetsRuleSetItemIpMaxConnectionResult']:
        """
        An array of IPs that have a maxConnection setting different than the default and what that maxConnection setting is
        """
        return pulumi.get(self, "ip_max_connections")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        A string to prepend to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Sequence['outputs.GetRuleSetsRuleSetItemRedirectUriResult']:
        """
        An object that defines the redirect URI applied to the original request. The object property values compose the redirect URI.
        """
        return pulumi.get(self, "redirect_uris")

    @_builtins.property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the incoming request is redirected.
        """
        return pulumi.get(self, "response_code")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.int:
        """
        The HTTP status code to return when the requested HTTP method is not in the list of allowed methods. The associated status line returned with the code is mapped from the standard HTTP specification. The default value is `405 (Method Not Allowed)`.  Example: 403
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        A string to append to the header value. The resulting header value must still conform to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "suffix")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A header value that conforms to RFC 7230. With the following exceptions:
        *  value cannot contain `$`
        *  value cannot contain patterns like `{variable_name}`. They are reserved for future extensions. Currently, such values are invalid.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRuleSetsRuleSetItemConditionResult(dict):
    def __init__(__self__, *,
                 attribute_name: _builtins.str,
                 attribute_value: _builtins.str,
                 operator: _builtins.str):
        """
        :param _builtins.str attribute_name: (Required) (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        :param _builtins.str attribute_value: (Required) (Updatable) Depends on `attribute_name`:
               - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
               - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        :param _builtins.str operator: A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
               *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
               *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
               *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
               *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)
        pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> _builtins.str:
        """
        (Required) (Updatable) The attribute_name can be one of these values: `PATH`, `SOURCE_IP_ADDRESS`, `SOURCE_VCN_ID`, `SOURCE_VCN_IP_ADDRESS`
        """
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> _builtins.str:
        """
        (Required) (Updatable) Depends on `attribute_name`:
        - when `attribute_name` = `SOURCE_IP_ADDRESS` | IPv4 or IPv6 address range to which the source IP address of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_IP_ADDRESS` | IPv4 address range to which the original client IP address (in customer VCN) of incoming packet would be matched against
        - when `attribute_name` = `SOURCE_VCN_ID` | OCID of the customer VCN to which the service gateway embedded VCN ID of incoming packet would be matched against
        """
        return pulumi.get(self, "attribute_value")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        A string that specifies how to compare the PathMatchCondition object's `attributeValue` string to the incoming URI.
        *  **EXACT_MATCH** - The incoming URI path must exactly and completely match the `attributeValue` string.
        *  **FORCE_LONGEST_PREFIX_MATCH** - The system looks for the `attributeValue` string with the best, longest match of the beginning portion of the incoming URI path.
        *  **PREFIX_MATCH** - The beginning portion of the incoming URI path must exactly match the `attributeValue` string.
        *  **SUFFIX_MATCH** - The ending portion of the incoming URI path must exactly match the `attributeValue` string.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetRuleSetsRuleSetItemIpMaxConnectionResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[_builtins.str],
                 max_connections: _builtins.int):
        """
        :param Sequence[_builtins.str] ip_addresses: Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        :param _builtins.int max_connections: The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "max_connections", max_connections)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Each element in the list should be valid IPv4 or IPv6 CIDR Block address. Example: '["129.213.176.0/24", "150.136.187.0/24", "2002::1234:abcd:ffff:c0a8:101/64"]'
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The maximum number of simultaneous connections that the specified IPs can make to the Listener. IPs without a maxConnections setting can make either defaultMaxConnections simultaneous connections to a listener or, if no defaultMaxConnections is specified, an unlimited number of simultaneous connections to a listener.
        """
        return pulumi.get(self, "max_connections")


@pulumi.output_type
class GetRuleSetsRuleSetItemRedirectUriResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 query: _builtins.str):
        """
        :param _builtins.str host: The valid domain name (hostname) or IP address to use in the redirect URI.
        :param _builtins.str path: The HTTP URI path to use in the redirect URI.
        :param _builtins.int port: The communication port to use in the redirect URI.
        :param _builtins.str protocol: The HTTP protocol to use in the redirect URI.
        :param _builtins.str query: The query string to use in the redirect URI.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The valid domain name (hostname) or IP address to use in the redirect URI.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The HTTP URI path to use in the redirect URI.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The communication port to use in the redirect URI.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The HTTP protocol to use in the redirect URI.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The query string to use in the redirect URI.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GetShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the shape.  Example: `100Mbps`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the shape.  Example: `100Mbps`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesShapeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the shape.  Example: `100Mbps`
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the shape.  Example: `100Mbps`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSslCipherSuitesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSslCipherSuitesSslCipherSuiteResult(dict):
    def __init__(__self__, *,
                 ciphers: Sequence[_builtins.str],
                 load_balancer_id: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str):
        """
        :param Sequence[_builtins.str] ciphers: A list of SSL ciphers the load balancer must support for HTTPS or SSL connections.
        :param _builtins.str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
        :param _builtins.str name: A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Sequence[_builtins.str]:
        """
        A list of SSL ciphers the load balancer must support for HTTPS or SSL connections.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A friendly name for the SSL cipher suite. It must be unique and it cannot be changed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")


