# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogAnalyticsEntityTypeArgs', 'LogAnalyticsEntityType']

@pulumi.input_type
class LogAnalyticsEntityTypeArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[_builtins.str],
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]] = None):
        """
        The set of arguments for constructing a LogAnalyticsEntityType resource.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[_builtins.str] category: Log analytics entity type category. Category will be used for grouping and filtering.
        :param pulumi.Input[_builtins.str] name: Log analytics entity type name.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]] properties: Log analytics entity type property definition.
        """
        pulumi.set(__self__, "namespace", namespace)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analytics entity type category. Category will be used for grouping and filtering.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]]:
        """
        Log analytics entity type property definition.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class _LogAnalyticsEntityTypeState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_name: Optional[pulumi.Input[_builtins.str]] = None,
                 management_agent_eligibility_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsEntityType resources.
        :param pulumi.Input[_builtins.str] category: Log analytics entity type category. Category will be used for grouping and filtering.
        :param pulumi.Input[_builtins.str] cloud_type: Log analytics entity type group. This can be CLOUD (OCI) or NON_CLOUD otherwise.
        :param pulumi.Input[_builtins.str] internal_name: Internal name for the log analytics entity type.
        :param pulumi.Input[_builtins.str] name: Log analytics entity type name.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]] properties: Log analytics entity type property definition.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the log analytics entity type.
        :param pulumi.Input[_builtins.str] time_created: Time the log analytics entity type was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: Time the log analytics entity type was updated. An RFC3339 formatted datetime string.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if internal_name is not None:
            pulumi.set(__self__, "internal_name", internal_name)
        if management_agent_eligibility_status is not None:
            pulumi.set(__self__, "management_agent_eligibility_status", management_agent_eligibility_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analytics entity type category. Category will be used for grouping and filtering.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analytics entity type group. This can be CLOUD (OCI) or NON_CLOUD otherwise.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_type", value)

    @_builtins.property
    @pulumi.getter(name="internalName")
    def internal_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "internal_name")

    @internal_name.setter
    def internal_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_name", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentEligibilityStatus")
    def management_agent_eligibility_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "management_agent_eligibility_status")

    @management_agent_eligibility_status.setter
    def management_agent_eligibility_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_eligibility_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]]:
        """
        Log analytics entity type property definition.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsEntityTypePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the log analytics entity type.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the log analytics entity type was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the log analytics entity type was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:LogAnalytics/logAnalyticsEntityType:LogAnalyticsEntityType")
class LogAnalyticsEntityType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsEntityTypePropertyArgs', 'LogAnalyticsEntityTypePropertyArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_entity_type = oci.loganalytics.LogAnalyticsEntityType("test_log_analytics_entity_type",
            name=log_analytics_entity_type_name,
            namespace=log_analytics_entity_type_namespace,
            category=log_analytics_entity_type_category,
            properties=[{
                "name": log_analytics_entity_type_properties_name,
                "description": log_analytics_entity_type_properties_description,
            }])
        ```

        ## Import

        LogAnalyticsEntityTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/logAnalyticsEntityType:LogAnalyticsEntityType test_log_analytics_entity_type "namespaces/{namespaceName}/logAnalyticsEntityTypes"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Log analytics entity type category. Category will be used for grouping and filtering.
        :param pulumi.Input[_builtins.str] name: Log analytics entity type name.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsEntityTypePropertyArgs', 'LogAnalyticsEntityTypePropertyArgsDict']]]] properties: Log analytics entity type property definition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsEntityTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_entity_type = oci.loganalytics.LogAnalyticsEntityType("test_log_analytics_entity_type",
            name=log_analytics_entity_type_name,
            namespace=log_analytics_entity_type_namespace,
            category=log_analytics_entity_type_category,
            properties=[{
                "name": log_analytics_entity_type_properties_name,
                "description": log_analytics_entity_type_properties_description,
            }])
        ```

        ## Import

        LogAnalyticsEntityTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/logAnalyticsEntityType:LogAnalyticsEntityType test_log_analytics_entity_type "namespaces/{namespaceName}/logAnalyticsEntityTypes"
        ```

        :param str resource_name: The name of the resource.
        :param LogAnalyticsEntityTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsEntityTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsEntityTypePropertyArgs', 'LogAnalyticsEntityTypePropertyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsEntityTypeArgs.__new__(LogAnalyticsEntityTypeArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["properties"] = properties
            __props__.__dict__["cloud_type"] = None
            __props__.__dict__["internal_name"] = None
            __props__.__dict__["management_agent_eligibility_status"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LogAnalyticsEntityType, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsEntityType:LogAnalyticsEntityType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
            internal_name: Optional[pulumi.Input[_builtins.str]] = None,
            management_agent_eligibility_status: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsEntityTypePropertyArgs', 'LogAnalyticsEntityTypePropertyArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogAnalyticsEntityType':
        """
        Get an existing LogAnalyticsEntityType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Log analytics entity type category. Category will be used for grouping and filtering.
        :param pulumi.Input[_builtins.str] cloud_type: Log analytics entity type group. This can be CLOUD (OCI) or NON_CLOUD otherwise.
        :param pulumi.Input[_builtins.str] internal_name: Internal name for the log analytics entity type.
        :param pulumi.Input[_builtins.str] name: Log analytics entity type name.
        :param pulumi.Input[_builtins.str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsEntityTypePropertyArgs', 'LogAnalyticsEntityTypePropertyArgsDict']]]] properties: Log analytics entity type property definition.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the log analytics entity type.
        :param pulumi.Input[_builtins.str] time_created: Time the log analytics entity type was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: Time the log analytics entity type was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsEntityTypeState.__new__(_LogAnalyticsEntityTypeState)

        __props__.__dict__["category"] = category
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["internal_name"] = internal_name
        __props__.__dict__["management_agent_eligibility_status"] = management_agent_eligibility_status
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["properties"] = properties
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return LogAnalyticsEntityType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Log analytics entity type category. Category will be used for grouping and filtering.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[_builtins.str]:
        """
        Log analytics entity type group. This can be CLOUD (OCI) or NON_CLOUD otherwise.
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter(name="internalName")
    def internal_name(self) -> pulumi.Output[_builtins.str]:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "internal_name")

    @_builtins.property
    @pulumi.getter(name="managementAgentEligibilityStatus")
    def management_agent_eligibility_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "management_agent_eligibility_status")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.LogAnalyticsEntityTypeProperty']]:
        """
        Log analytics entity type property definition.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the log analytics entity type.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Time the log analytics entity type was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time the log analytics entity type was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

