# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FileStorageObjectStorageLinkArgs', 'FileStorageObjectStorageLink']

@pulumi.input_type
class FileStorageObjectStorageLinkArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 file_system_path: pulumi.Input[_builtins.str],
                 is_overwrite: pulumi.Input[_builtins.bool],
                 lustre_file_system_id: pulumi.Input[_builtins.str],
                 object_storage_prefix: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 start_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 start_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a FileStorageObjectStorageLink resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        :param pulumi.Input[_builtins.str] file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param pulumi.Input[_builtins.bool] is_overwrite: (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param pulumi.Input[_builtins.str] lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        :param pulumi.Input[_builtins.str] object_storage_prefix: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] start_export_to_object_trigger: (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] start_import_from_object_trigger: (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_export_to_object_trigger: (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_import_from_object_trigger: (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "file_system_path", file_system_path)
        pulumi.set(__self__, "is_overwrite", is_overwrite)
        pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        pulumi.set(__self__, "object_storage_prefix", object_storage_prefix)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if start_export_to_object_trigger is not None:
            pulumi.set(__self__, "start_export_to_object_trigger", start_export_to_object_trigger)
        if start_import_from_object_trigger is not None:
            pulumi.set(__self__, "start_import_from_object_trigger", start_import_from_object_trigger)
        if stop_export_to_object_trigger is not None:
            pulumi.set(__self__, "stop_export_to_object_trigger", stop_export_to_object_trigger)
        if stop_import_from_object_trigger is not None:
            pulumi.set(__self__, "stop_import_from_object_trigger", stop_import_from_object_trigger)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Input[_builtins.str]:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "file_system_path")

    @file_system_path.setter
    def file_system_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_path", value)

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @is_overwrite.setter
    def is_overwrite(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @lustre_file_system_id.setter
    def lustre_file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lustre_file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="objectStoragePrefix")
    def object_storage_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_prefix")

    @object_storage_prefix.setter
    def object_storage_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_storage_prefix", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="startExportToObjectTrigger")
    def start_export_to_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_export_to_object_trigger")

    @start_export_to_object_trigger.setter
    def start_export_to_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_export_to_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="startImportFromObjectTrigger")
    def start_import_from_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_import_from_object_trigger")

    @start_import_from_object_trigger.setter
    def start_import_from_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_import_from_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="stopExportToObjectTrigger")
    def stop_export_to_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_export_to_object_trigger")

    @stop_export_to_object_trigger.setter
    def stop_export_to_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_export_to_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="stopImportFromObjectTrigger")
    def stop_import_from_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_import_from_object_trigger")

    @stop_import_from_object_trigger.setter
    def stop_import_from_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_import_from_object_trigger", value)


@pulumi.input_type
class _FileStorageObjectStorageLinkState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 current_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_path: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 lustre_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 start_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 start_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileStorageObjectStorageLink resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        :param pulumi.Input[_builtins.str] current_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        :param pulumi.Input[_builtins.str] file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_overwrite: (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param pulumi.Input[_builtins.str] last_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        :param pulumi.Input[_builtins.str] object_storage_prefix: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param pulumi.Input[_builtins.int] start_export_to_object_trigger: (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] start_import_from_object_trigger: (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] state: The current state of the Object Storage link.
        :param pulumi.Input[_builtins.int] stop_export_to_object_trigger: (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_import_from_object_trigger: (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if current_job_id is not None:
            pulumi.set(__self__, "current_job_id", current_job_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_system_path is not None:
            pulumi.set(__self__, "file_system_path", file_system_path)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_overwrite is not None:
            pulumi.set(__self__, "is_overwrite", is_overwrite)
        if last_job_id is not None:
            pulumi.set(__self__, "last_job_id", last_job_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lustre_file_system_id is not None:
            pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        if object_storage_prefix is not None:
            pulumi.set(__self__, "object_storage_prefix", object_storage_prefix)
        if start_export_to_object_trigger is not None:
            pulumi.set(__self__, "start_export_to_object_trigger", start_export_to_object_trigger)
        if start_import_from_object_trigger is not None:
            pulumi.set(__self__, "start_import_from_object_trigger", start_import_from_object_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stop_export_to_object_trigger is not None:
            pulumi.set(__self__, "stop_export_to_object_trigger", stop_export_to_object_trigger)
        if stop_import_from_object_trigger is not None:
            pulumi.set(__self__, "stop_import_from_object_trigger", stop_import_from_object_trigger)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="currentJobId")
    def current_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        """
        return pulumi.get(self, "current_job_id")

    @current_job_id.setter
    def current_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_job_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "file_system_path")

    @file_system_path.setter
    def file_system_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_path", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @is_overwrite.setter
    def is_overwrite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="lastJobId")
    def last_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        """
        return pulumi.get(self, "last_job_id")

    @last_job_id.setter
    def last_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_job_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @lustre_file_system_id.setter
    def lustre_file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lustre_file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="objectStoragePrefix")
    def object_storage_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_prefix")

    @object_storage_prefix.setter
    def object_storage_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_storage_prefix", value)

    @_builtins.property
    @pulumi.getter(name="startExportToObjectTrigger")
    def start_export_to_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_export_to_object_trigger")

    @start_export_to_object_trigger.setter
    def start_export_to_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_export_to_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="startImportFromObjectTrigger")
    def start_import_from_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_import_from_object_trigger")

    @start_import_from_object_trigger.setter
    def start_import_from_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_import_from_object_trigger", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Object Storage link.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stopExportToObjectTrigger")
    def stop_export_to_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_export_to_object_trigger")

    @stop_export_to_object_trigger.setter
    def stop_export_to_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_export_to_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="stopImportFromObjectTrigger")
    def stop_import_from_object_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_import_from_object_trigger")

    @stop_import_from_object_trigger.setter
    def stop_import_from_object_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_import_from_object_trigger", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Lustre/fileStorageObjectStorageLink:FileStorageObjectStorageLink")
class FileStorageObjectStorageLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_path: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 lustre_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 start_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 start_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Object Storage Link resource in Oracle Cloud Infrastructure Lustre File Storage service.

        Creates an Object Storage link.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_object_storage_link = oci.lustre.FileStorageObjectStorageLink("test_object_storage_link",
            availability_domain=object_storage_link_availability_domain,
            compartment_id=compartment_id,
            file_system_path=object_storage_link_file_system_path,
            is_overwrite=object_storage_link_is_overwrite,
            lustre_file_system_id=test_lustre_file_system["id"],
            object_storage_prefix=object_storage_link_object_storage_prefix,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=object_storage_link_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ObjectStorageLinks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Lustre/fileStorageObjectStorageLink:FileStorageObjectStorageLink test_object_storage_link "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        :param pulumi.Input[_builtins.str] file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_overwrite: (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param pulumi.Input[_builtins.str] lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        :param pulumi.Input[_builtins.str] object_storage_prefix: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param pulumi.Input[_builtins.int] start_export_to_object_trigger: (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] start_import_from_object_trigger: (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_export_to_object_trigger: (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_import_from_object_trigger: (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileStorageObjectStorageLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Object Storage Link resource in Oracle Cloud Infrastructure Lustre File Storage service.

        Creates an Object Storage link.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_object_storage_link = oci.lustre.FileStorageObjectStorageLink("test_object_storage_link",
            availability_domain=object_storage_link_availability_domain,
            compartment_id=compartment_id,
            file_system_path=object_storage_link_file_system_path,
            is_overwrite=object_storage_link_is_overwrite,
            lustre_file_system_id=test_lustre_file_system["id"],
            object_storage_prefix=object_storage_link_object_storage_prefix,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=object_storage_link_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ObjectStorageLinks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Lustre/fileStorageObjectStorageLink:FileStorageObjectStorageLink test_object_storage_link "id"
        ```

        :param str resource_name: The name of the resource.
        :param FileStorageObjectStorageLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileStorageObjectStorageLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_path: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 lustre_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_storage_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 start_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 start_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileStorageObjectStorageLinkArgs.__new__(FileStorageObjectStorageLinkArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if file_system_path is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_path'")
            __props__.__dict__["file_system_path"] = file_system_path
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_overwrite is None and not opts.urn:
                raise TypeError("Missing required property 'is_overwrite'")
            __props__.__dict__["is_overwrite"] = is_overwrite
            if lustre_file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'lustre_file_system_id'")
            __props__.__dict__["lustre_file_system_id"] = lustre_file_system_id
            if object_storage_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'object_storage_prefix'")
            __props__.__dict__["object_storage_prefix"] = object_storage_prefix
            __props__.__dict__["start_export_to_object_trigger"] = start_export_to_object_trigger
            __props__.__dict__["start_import_from_object_trigger"] = start_import_from_object_trigger
            __props__.__dict__["stop_export_to_object_trigger"] = stop_export_to_object_trigger
            __props__.__dict__["stop_import_from_object_trigger"] = stop_import_from_object_trigger
            __props__.__dict__["current_job_id"] = None
            __props__.__dict__["last_job_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(FileStorageObjectStorageLink, __self__).__init__(
            'oci:Lustre/fileStorageObjectStorageLink:FileStorageObjectStorageLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            current_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_path: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
            last_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            lustre_file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            object_storage_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            start_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            start_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            stop_export_to_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            stop_import_from_object_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileStorageObjectStorageLink':
        """
        Get an existing FileStorageObjectStorageLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        :param pulumi.Input[_builtins.str] current_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        :param pulumi.Input[_builtins.str] file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_overwrite: (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param pulumi.Input[_builtins.str] last_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        :param pulumi.Input[_builtins.str] object_storage_prefix: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param pulumi.Input[_builtins.int] start_export_to_object_trigger: (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] start_import_from_object_trigger: (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] state: The current state of the Object Storage link.
        :param pulumi.Input[_builtins.int] stop_export_to_object_trigger: (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        :param pulumi.Input[_builtins.int] stop_import_from_object_trigger: (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileStorageObjectStorageLinkState.__new__(_FileStorageObjectStorageLinkState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["current_job_id"] = current_job_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["file_system_path"] = file_system_path
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_overwrite"] = is_overwrite
        __props__.__dict__["last_job_id"] = last_job_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lustre_file_system_id"] = lustre_file_system_id
        __props__.__dict__["object_storage_prefix"] = object_storage_prefix
        __props__.__dict__["start_export_to_object_trigger"] = start_export_to_object_trigger
        __props__.__dict__["start_import_from_object_trigger"] = start_import_from_object_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["stop_export_to_object_trigger"] = stop_export_to_object_trigger
        __props__.__dict__["stop_import_from_object_trigger"] = stop_import_from_object_trigger
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return FileStorageObjectStorageLink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain that the Lustre file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Object Storage link.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentJobId")
    def current_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        """
        return pulumi.get(self, "current_job_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "file_system_path")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @_builtins.property
    @pulumi.getter(name="lastJobId")
    def last_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        """
        return pulumi.get(self, "last_job_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @_builtins.property
    @pulumi.getter(name="objectStoragePrefix")
    def object_storage_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_prefix")

    @_builtins.property
    @pulumi.getter(name="startExportToObjectTrigger")
    def start_export_to_object_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="startImportFromObjectTrigger")
    def start_import_from_object_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Import From Object. Could be set to any integer value.
        """
        return pulumi.get(self, "start_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Object Storage link.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopExportToObjectTrigger")
    def stop_export_to_object_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Export To Object. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="stopImportFromObjectTrigger")
    def stop_import_from_object_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Import From Object. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

