# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFileStorageObjectStorageLinkResult',
    'AwaitableGetFileStorageObjectStorageLinkResult',
    'get_file_storage_object_storage_link',
    'get_file_storage_object_storage_link_output',
]

@pulumi.output_type
class GetFileStorageObjectStorageLinkResult:
    """
    A collection of values returned by getFileStorageObjectStorageLink.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, current_job_id=None, defined_tags=None, display_name=None, file_system_path=None, freeform_tags=None, id=None, is_overwrite=None, last_job_id=None, lifecycle_details=None, lustre_file_system_id=None, object_storage_link_id=None, object_storage_prefix=None, start_export_to_object_trigger=None, start_import_from_object_trigger=None, state=None, stop_export_to_object_trigger=None, stop_import_from_object_trigger=None, system_tags=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if current_job_id and not isinstance(current_job_id, str):
            raise TypeError("Expected argument 'current_job_id' to be a str")
        pulumi.set(__self__, "current_job_id", current_job_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if file_system_path and not isinstance(file_system_path, str):
            raise TypeError("Expected argument 'file_system_path' to be a str")
        pulumi.set(__self__, "file_system_path", file_system_path)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_overwrite and not isinstance(is_overwrite, bool):
            raise TypeError("Expected argument 'is_overwrite' to be a bool")
        pulumi.set(__self__, "is_overwrite", is_overwrite)
        if last_job_id and not isinstance(last_job_id, str):
            raise TypeError("Expected argument 'last_job_id' to be a str")
        pulumi.set(__self__, "last_job_id", last_job_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lustre_file_system_id and not isinstance(lustre_file_system_id, str):
            raise TypeError("Expected argument 'lustre_file_system_id' to be a str")
        pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        if object_storage_link_id and not isinstance(object_storage_link_id, str):
            raise TypeError("Expected argument 'object_storage_link_id' to be a str")
        pulumi.set(__self__, "object_storage_link_id", object_storage_link_id)
        if object_storage_prefix and not isinstance(object_storage_prefix, str):
            raise TypeError("Expected argument 'object_storage_prefix' to be a str")
        pulumi.set(__self__, "object_storage_prefix", object_storage_prefix)
        if start_export_to_object_trigger and not isinstance(start_export_to_object_trigger, int):
            raise TypeError("Expected argument 'start_export_to_object_trigger' to be a int")
        pulumi.set(__self__, "start_export_to_object_trigger", start_export_to_object_trigger)
        if start_import_from_object_trigger and not isinstance(start_import_from_object_trigger, int):
            raise TypeError("Expected argument 'start_import_from_object_trigger' to be a int")
        pulumi.set(__self__, "start_import_from_object_trigger", start_import_from_object_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stop_export_to_object_trigger and not isinstance(stop_export_to_object_trigger, int):
            raise TypeError("Expected argument 'stop_export_to_object_trigger' to be a int")
        pulumi.set(__self__, "stop_export_to_object_trigger", stop_export_to_object_trigger)
        if stop_import_from_object_trigger and not isinstance(stop_import_from_object_trigger, int):
            raise TypeError("Expected argument 'stop_import_from_object_trigger' to be a int")
        pulumi.set(__self__, "stop_import_from_object_trigger", stop_import_from_object_trigger)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentJobId")
    def current_job_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        """
        return pulumi.get(self, "current_job_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> _builtins.str:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "file_system_path")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ObjectStorageLink.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> _builtins.bool:
        """
        The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @_builtins.property
    @pulumi.getter(name="lastJobId")
    def last_job_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        """
        return pulumi.get(self, "last_job_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @_builtins.property
    @pulumi.getter(name="objectStorageLinkId")
    def object_storage_link_id(self) -> _builtins.str:
        return pulumi.get(self, "object_storage_link_id")

    @_builtins.property
    @pulumi.getter(name="objectStoragePrefix")
    def object_storage_prefix(self) -> _builtins.str:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_prefix")

    @_builtins.property
    @pulumi.getter(name="startExportToObjectTrigger")
    def start_export_to_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "start_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="startImportFromObjectTrigger")
    def start_import_from_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "start_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Object Storage link.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopExportToObjectTrigger")
    def stop_export_to_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "stop_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="stopImportFromObjectTrigger")
    def stop_import_from_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "stop_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFileStorageObjectStorageLinkResult(GetFileStorageObjectStorageLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStorageObjectStorageLinkResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            current_job_id=self.current_job_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            file_system_path=self.file_system_path,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_overwrite=self.is_overwrite,
            last_job_id=self.last_job_id,
            lifecycle_details=self.lifecycle_details,
            lustre_file_system_id=self.lustre_file_system_id,
            object_storage_link_id=self.object_storage_link_id,
            object_storage_prefix=self.object_storage_prefix,
            start_export_to_object_trigger=self.start_export_to_object_trigger,
            start_import_from_object_trigger=self.start_import_from_object_trigger,
            state=self.state,
            stop_export_to_object_trigger=self.stop_export_to_object_trigger,
            stop_import_from_object_trigger=self.stop_import_from_object_trigger,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_file_storage_object_storage_link(object_storage_link_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStorageObjectStorageLinkResult:
    """
    This data source provides details about a specific Object Storage Link resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets information about an Object Storage link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_link = oci.Lustre.get_file_storage_object_storage_link(object_storage_link_id=test_object_storage_link_oci_lustre_file_storage_object_storage_link["id"])
    ```


    :param _builtins.str object_storage_link_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    """
    __args__ = dict()
    __args__['objectStorageLinkId'] = object_storage_link_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Lustre/getFileStorageObjectStorageLink:getFileStorageObjectStorageLink', __args__, opts=opts, typ=GetFileStorageObjectStorageLinkResult).value

    return AwaitableGetFileStorageObjectStorageLinkResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        current_job_id=pulumi.get(__ret__, 'current_job_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        file_system_path=pulumi.get(__ret__, 'file_system_path'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_overwrite=pulumi.get(__ret__, 'is_overwrite'),
        last_job_id=pulumi.get(__ret__, 'last_job_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lustre_file_system_id=pulumi.get(__ret__, 'lustre_file_system_id'),
        object_storage_link_id=pulumi.get(__ret__, 'object_storage_link_id'),
        object_storage_prefix=pulumi.get(__ret__, 'object_storage_prefix'),
        start_export_to_object_trigger=pulumi.get(__ret__, 'start_export_to_object_trigger'),
        start_import_from_object_trigger=pulumi.get(__ret__, 'start_import_from_object_trigger'),
        state=pulumi.get(__ret__, 'state'),
        stop_export_to_object_trigger=pulumi.get(__ret__, 'stop_export_to_object_trigger'),
        stop_import_from_object_trigger=pulumi.get(__ret__, 'stop_import_from_object_trigger'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_file_storage_object_storage_link_output(object_storage_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileStorageObjectStorageLinkResult]:
    """
    This data source provides details about a specific Object Storage Link resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets information about an Object Storage link.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_link = oci.Lustre.get_file_storage_object_storage_link(object_storage_link_id=test_object_storage_link_oci_lustre_file_storage_object_storage_link["id"])
    ```


    :param _builtins.str object_storage_link_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    """
    __args__ = dict()
    __args__['objectStorageLinkId'] = object_storage_link_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Lustre/getFileStorageObjectStorageLink:getFileStorageObjectStorageLink', __args__, opts=opts, typ=GetFileStorageObjectStorageLinkResult)
    return __ret__.apply(lambda __response__: GetFileStorageObjectStorageLinkResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        current_job_id=pulumi.get(__response__, 'current_job_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        file_system_path=pulumi.get(__response__, 'file_system_path'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_overwrite=pulumi.get(__response__, 'is_overwrite'),
        last_job_id=pulumi.get(__response__, 'last_job_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lustre_file_system_id=pulumi.get(__response__, 'lustre_file_system_id'),
        object_storage_link_id=pulumi.get(__response__, 'object_storage_link_id'),
        object_storage_prefix=pulumi.get(__response__, 'object_storage_prefix'),
        start_export_to_object_trigger=pulumi.get(__response__, 'start_export_to_object_trigger'),
        start_import_from_object_trigger=pulumi.get(__response__, 'start_import_from_object_trigger'),
        state=pulumi.get(__response__, 'state'),
        stop_export_to_object_trigger=pulumi.get(__response__, 'stop_export_to_object_trigger'),
        stop_import_from_object_trigger=pulumi.get(__response__, 'stop_import_from_object_trigger'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
