# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFileStorageObjectStorageLinkSyncJobResult',
    'AwaitableGetFileStorageObjectStorageLinkSyncJobResult',
    'get_file_storage_object_storage_link_sync_job',
    'get_file_storage_object_storage_link_sync_job_output',
]

@pulumi.output_type
class GetFileStorageObjectStorageLinkSyncJobResult:
    """
    A collection of values returned by getFileStorageObjectStorageLinkSyncJob.
    """
    def __init__(__self__, bytes_transferred=None, defined_tags=None, freeform_tags=None, id=None, is_overwrite=None, job_type=None, lifecycle_details=None, lustre_file_system_path=None, object_storage_link_id=None, object_storage_path=None, objects_transferred=None, parent_id=None, skipped_error_count=None, state=None, sync_job_id=None, system_tags=None, time_finished=None, time_started=None, total_objects_scanned=None):
        if bytes_transferred and not isinstance(bytes_transferred, str):
            raise TypeError("Expected argument 'bytes_transferred' to be a str")
        pulumi.set(__self__, "bytes_transferred", bytes_transferred)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_overwrite and not isinstance(is_overwrite, bool):
            raise TypeError("Expected argument 'is_overwrite' to be a bool")
        pulumi.set(__self__, "is_overwrite", is_overwrite)
        if job_type and not isinstance(job_type, str):
            raise TypeError("Expected argument 'job_type' to be a str")
        pulumi.set(__self__, "job_type", job_type)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lustre_file_system_path and not isinstance(lustre_file_system_path, str):
            raise TypeError("Expected argument 'lustre_file_system_path' to be a str")
        pulumi.set(__self__, "lustre_file_system_path", lustre_file_system_path)
        if object_storage_link_id and not isinstance(object_storage_link_id, str):
            raise TypeError("Expected argument 'object_storage_link_id' to be a str")
        pulumi.set(__self__, "object_storage_link_id", object_storage_link_id)
        if object_storage_path and not isinstance(object_storage_path, str):
            raise TypeError("Expected argument 'object_storage_path' to be a str")
        pulumi.set(__self__, "object_storage_path", object_storage_path)
        if objects_transferred and not isinstance(objects_transferred, str):
            raise TypeError("Expected argument 'objects_transferred' to be a str")
        pulumi.set(__self__, "objects_transferred", objects_transferred)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if skipped_error_count and not isinstance(skipped_error_count, str):
            raise TypeError("Expected argument 'skipped_error_count' to be a str")
        pulumi.set(__self__, "skipped_error_count", skipped_error_count)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if sync_job_id and not isinstance(sync_job_id, str):
            raise TypeError("Expected argument 'sync_job_id' to be a str")
        pulumi.set(__self__, "sync_job_id", sync_job_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if total_objects_scanned and not isinstance(total_objects_scanned, str):
            raise TypeError("Expected argument 'total_objects_scanned' to be a str")
        pulumi.set(__self__, "total_objects_scanned", total_objects_scanned)

    @_builtins.property
    @pulumi.getter(name="bytesTransferred")
    def bytes_transferred(self) -> _builtins.str:
        """
        Bytes transferred during the sync. This value changes while the sync is still in progress.
        """
        return pulumi.get(self, "bytes_transferred")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> _builtins.bool:
        """
        The flag is an identifier to tell whether this specific job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> _builtins.str:
        """
        The type of the sync job.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the sync job in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemPath")
    def lustre_file_system_path(self) -> _builtins.str:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "lustre_file_system_path")

    @_builtins.property
    @pulumi.getter(name="objectStorageLinkId")
    def object_storage_link_id(self) -> _builtins.str:
        return pulumi.get(self, "object_storage_link_id")

    @_builtins.property
    @pulumi.getter(name="objectStoragePath")
    def object_storage_path(self) -> _builtins.str:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_path")

    @_builtins.property
    @pulumi.getter(name="objectsTransferred")
    def objects_transferred(self) -> _builtins.str:
        """
        Count of total files that transferred successfully.
        """
        return pulumi.get(self, "objects_transferred")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="skippedErrorCount")
    def skipped_error_count(self) -> _builtins.str:
        """
        Count of files or objects that failed to export or import due to errors.
        """
        return pulumi.get(self, "skipped_error_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the sync job.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="syncJobId")
    def sync_job_id(self) -> _builtins.str:
        return pulumi.get(self, "sync_job_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time the job finished, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time the job was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="totalObjectsScanned")
    def total_objects_scanned(self) -> _builtins.str:
        """
        Total object count for scanned files for import or export as part of this sync job.
        """
        return pulumi.get(self, "total_objects_scanned")


class AwaitableGetFileStorageObjectStorageLinkSyncJobResult(GetFileStorageObjectStorageLinkSyncJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStorageObjectStorageLinkSyncJobResult(
            bytes_transferred=self.bytes_transferred,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_overwrite=self.is_overwrite,
            job_type=self.job_type,
            lifecycle_details=self.lifecycle_details,
            lustre_file_system_path=self.lustre_file_system_path,
            object_storage_link_id=self.object_storage_link_id,
            object_storage_path=self.object_storage_path,
            objects_transferred=self.objects_transferred,
            parent_id=self.parent_id,
            skipped_error_count=self.skipped_error_count,
            state=self.state,
            sync_job_id=self.sync_job_id,
            system_tags=self.system_tags,
            time_finished=self.time_finished,
            time_started=self.time_started,
            total_objects_scanned=self.total_objects_scanned)


def get_file_storage_object_storage_link_sync_job(object_storage_link_id: Optional[_builtins.str] = None,
                                                  sync_job_id: Optional[_builtins.str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStorageObjectStorageLinkSyncJobResult:
    """
    This data source provides details about a specific Object Storage Link Sync Job resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets details of a sync job associated with an Object Storage link when `objectStorageLink` and a unique ID are provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_link_sync_job = oci.Lustre.get_file_storage_object_storage_link_sync_job(object_storage_link_id=test_object_storage_link["id"],
        sync_job_id=test_job["id"])
    ```


    :param _builtins.str object_storage_link_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    :param _builtins.str sync_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the sync job.
    """
    __args__ = dict()
    __args__['objectStorageLinkId'] = object_storage_link_id
    __args__['syncJobId'] = sync_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Lustre/getFileStorageObjectStorageLinkSyncJob:getFileStorageObjectStorageLinkSyncJob', __args__, opts=opts, typ=GetFileStorageObjectStorageLinkSyncJobResult).value

    return AwaitableGetFileStorageObjectStorageLinkSyncJobResult(
        bytes_transferred=pulumi.get(__ret__, 'bytes_transferred'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_overwrite=pulumi.get(__ret__, 'is_overwrite'),
        job_type=pulumi.get(__ret__, 'job_type'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lustre_file_system_path=pulumi.get(__ret__, 'lustre_file_system_path'),
        object_storage_link_id=pulumi.get(__ret__, 'object_storage_link_id'),
        object_storage_path=pulumi.get(__ret__, 'object_storage_path'),
        objects_transferred=pulumi.get(__ret__, 'objects_transferred'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        skipped_error_count=pulumi.get(__ret__, 'skipped_error_count'),
        state=pulumi.get(__ret__, 'state'),
        sync_job_id=pulumi.get(__ret__, 'sync_job_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        total_objects_scanned=pulumi.get(__ret__, 'total_objects_scanned'))
def get_file_storage_object_storage_link_sync_job_output(object_storage_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                         sync_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileStorageObjectStorageLinkSyncJobResult]:
    """
    This data source provides details about a specific Object Storage Link Sync Job resource in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets details of a sync job associated with an Object Storage link when `objectStorageLink` and a unique ID are provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_link_sync_job = oci.Lustre.get_file_storage_object_storage_link_sync_job(object_storage_link_id=test_object_storage_link["id"],
        sync_job_id=test_job["id"])
    ```


    :param _builtins.str object_storage_link_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    :param _builtins.str sync_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the sync job.
    """
    __args__ = dict()
    __args__['objectStorageLinkId'] = object_storage_link_id
    __args__['syncJobId'] = sync_job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Lustre/getFileStorageObjectStorageLinkSyncJob:getFileStorageObjectStorageLinkSyncJob', __args__, opts=opts, typ=GetFileStorageObjectStorageLinkSyncJobResult)
    return __ret__.apply(lambda __response__: GetFileStorageObjectStorageLinkSyncJobResult(
        bytes_transferred=pulumi.get(__response__, 'bytes_transferred'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_overwrite=pulumi.get(__response__, 'is_overwrite'),
        job_type=pulumi.get(__response__, 'job_type'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lustre_file_system_path=pulumi.get(__response__, 'lustre_file_system_path'),
        object_storage_link_id=pulumi.get(__response__, 'object_storage_link_id'),
        object_storage_path=pulumi.get(__response__, 'object_storage_path'),
        objects_transferred=pulumi.get(__response__, 'objects_transferred'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        skipped_error_count=pulumi.get(__response__, 'skipped_error_count'),
        state=pulumi.get(__response__, 'state'),
        sync_job_id=pulumi.get(__response__, 'sync_job_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started'),
        total_objects_scanned=pulumi.get(__response__, 'total_objects_scanned')))
