# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFileStorageObjectStorageLinksResult',
    'AwaitableGetFileStorageObjectStorageLinksResult',
    'get_file_storage_object_storage_links',
    'get_file_storage_object_storage_links_output',
]

@pulumi.output_type
class GetFileStorageObjectStorageLinksResult:
    """
    A collection of values returned by getFileStorageObjectStorageLinks.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, display_name=None, filters=None, id=None, lustre_file_system_id=None, object_storage_link_collections=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lustre_file_system_id and not isinstance(lustre_file_system_id, str):
            raise TypeError("Expected argument 'lustre_file_system_id' to be a str")
        pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        if object_storage_link_collections and not isinstance(object_storage_link_collections, list):
            raise TypeError("Expected argument 'object_storage_link_collections' to be a list")
        pulumi.set(__self__, "object_storage_link_collections", object_storage_link_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        The availability domain the file system is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Lustre file system.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My Object Storage Link`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFileStorageObjectStorageLinksFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ObjectStorageLink.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @_builtins.property
    @pulumi.getter(name="objectStorageLinkCollections")
    def object_storage_link_collections(self) -> Sequence['outputs.GetFileStorageObjectStorageLinksObjectStorageLinkCollectionResult']:
        """
        The list of object_storage_link_collection.
        """
        return pulumi.get(self, "object_storage_link_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Object Storage link.
        """
        return pulumi.get(self, "state")


class AwaitableGetFileStorageObjectStorageLinksResult(GetFileStorageObjectStorageLinksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStorageObjectStorageLinksResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            lustre_file_system_id=self.lustre_file_system_id,
            object_storage_link_collections=self.object_storage_link_collections,
            state=self.state)


def get_file_storage_object_storage_links(availability_domain: Optional[_builtins.str] = None,
                                          compartment_id: Optional[_builtins.str] = None,
                                          display_name: Optional[_builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetFileStorageObjectStorageLinksFilterArgs', 'GetFileStorageObjectStorageLinksFilterArgsDict']]] = None,
                                          id: Optional[_builtins.str] = None,
                                          lustre_file_system_id: Optional[_builtins.str] = None,
                                          state: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStorageObjectStorageLinksResult:
    """
    This data source provides the list of Object Storage Links in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets a list of Object Storage links.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_links = oci.Lustre.get_file_storage_object_storage_links(availability_domain=object_storage_link_availability_domain,
        compartment_id=compartment_id,
        display_name=object_storage_link_display_name,
        id=object_storage_link_id,
        lustre_file_system_id=test_lustre_file_system["id"],
        state=object_storage_link_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    :param _builtins.str lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['lustreFileSystemId'] = lustre_file_system_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Lustre/getFileStorageObjectStorageLinks:getFileStorageObjectStorageLinks', __args__, opts=opts, typ=GetFileStorageObjectStorageLinksResult).value

    return AwaitableGetFileStorageObjectStorageLinksResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lustre_file_system_id=pulumi.get(__ret__, 'lustre_file_system_id'),
        object_storage_link_collections=pulumi.get(__ret__, 'object_storage_link_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_file_storage_object_storage_links_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFileStorageObjectStorageLinksFilterArgs', 'GetFileStorageObjectStorageLinksFilterArgsDict']]]]] = None,
                                                 id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 lustre_file_system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileStorageObjectStorageLinksResult]:
    """
    This data source provides the list of Object Storage Links in Oracle Cloud Infrastructure Lustre File Storage service.

    Gets a list of Object Storage links.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_object_storage_links = oci.Lustre.get_file_storage_object_storage_links(availability_domain=object_storage_link_availability_domain,
        compartment_id=compartment_id,
        display_name=object_storage_link_display_name,
        id=object_storage_link_id,
        lustre_file_system_id=test_lustre_file_system["id"],
        state=object_storage_link_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
    :param _builtins.str lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['lustreFileSystemId'] = lustre_file_system_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Lustre/getFileStorageObjectStorageLinks:getFileStorageObjectStorageLinks', __args__, opts=opts, typ=GetFileStorageObjectStorageLinksResult)
    return __ret__.apply(lambda __response__: GetFileStorageObjectStorageLinksResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lustre_file_system_id=pulumi.get(__response__, 'lustre_file_system_id'),
        object_storage_link_collections=pulumi.get(__response__, 'object_storage_link_collections'),
        state=pulumi.get(__response__, 'state')))
