# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FileStorageLustreFileSystemMaintenanceWindow',
    'FileStorageLustreFileSystemRootSquashConfiguration',
    'GetFileStorageLustreFileSystemMaintenanceWindowResult',
    'GetFileStorageLustreFileSystemRootSquashConfigurationResult',
    'GetFileStorageLustreFileSystemsFilterResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult',
    'GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult',
    'GetFileStorageObjectStorageLinkSyncJobsFilterResult',
    'GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionResult',
    'GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionItemResult',
    'GetFileStorageObjectStorageLinksFilterResult',
    'GetFileStorageObjectStorageLinksObjectStorageLinkCollectionResult',
    'GetFileStorageObjectStorageLinksObjectStorageLinkCollectionItemResult',
]

@pulumi.output_type
class FileStorageLustreFileSystemMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "timeStart":
            suggest = "time_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileStorageLustreFileSystemMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileStorageLustreFileSystemMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileStorageLustreFileSystemMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[_builtins.str] = None,
                 time_start: Optional[_builtins.str] = None):
        """
        :param _builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param _builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if time_start is not None:
            pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[_builtins.str]:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[_builtins.str]:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class FileStorageLustreFileSystemRootSquashConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientExceptions":
            suggest = "client_exceptions"
        elif key == "identitySquash":
            suggest = "identity_squash"
        elif key == "squashGid":
            suggest = "squash_gid"
        elif key == "squashUid":
            suggest = "squash_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileStorageLustreFileSystemRootSquashConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileStorageLustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileStorageLustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_exceptions: Optional[Sequence[_builtins.str]] = None,
                 identity_squash: Optional[_builtins.str] = None,
                 squash_gid: Optional[_builtins.str] = None,
                 squash_uid: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] client_exceptions: (Updatable) A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param _builtins.str identity_squash: (Updatable) Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param _builtins.str squash_gid: (Updatable) The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param _builtins.str squash_uid: (Updatable) The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        if client_exceptions is not None:
            pulumi.set(__self__, "client_exceptions", client_exceptions)
        if identity_squash is not None:
            pulumi.set(__self__, "identity_squash", identity_squash)
        if squash_gid is not None:
            pulumi.set(__self__, "squash_gid", squash_gid)
        if squash_uid is not None:
            pulumi.set(__self__, "squash_uid", squash_uid)

    @_builtins.property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @_builtins.property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> Optional[_builtins.str]:
        """
        (Updatable) Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @_builtins.property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> Optional[_builtins.str]:
        """
        (Updatable) The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @_builtins.property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> Optional[_builtins.str]:
        """
        (Updatable) The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


@pulumi.output_type
class GetFileStorageLustreFileSystemMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 time_start: _builtins.str):
        """
        :param _builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param _builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> _builtins.str:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class GetFileStorageLustreFileSystemRootSquashConfigurationResult(dict):
    def __init__(__self__, *,
                 client_exceptions: Sequence[_builtins.str],
                 identity_squash: _builtins.str,
                 squash_gid: _builtins.str,
                 squash_uid: _builtins.str):
        """
        :param Sequence[_builtins.str] client_exceptions: A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param _builtins.str identity_squash: Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param _builtins.str squash_gid: The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param _builtins.str squash_uid: The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        pulumi.set(__self__, "client_exceptions", client_exceptions)
        pulumi.set(__self__, "identity_squash", identity_squash)
        pulumi.set(__self__, "squash_gid", squash_gid)
        pulumi.set(__self__, "squash_uid", squash_uid)

    @_builtins.property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Sequence[_builtins.str]:
        """
        A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @_builtins.property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> _builtins.str:
        """
        Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @_builtins.property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> _builtins.str:
        """
        The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @_builtins.property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> _builtins.str:
        """
        The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


@pulumi.output_type
class GetFileStorageLustreFileSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 capacity_in_gbs: _builtins.int,
                 cluster_placement_group_id: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 file_system_description: _builtins.str,
                 file_system_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 kms_key_id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 lnet: _builtins.str,
                 maintenance_windows: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult'],
                 major_version: _builtins.str,
                 management_service_address: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 performance_tier: _builtins.str,
                 root_squash_configurations: Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult'],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_billing_cycle_end: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param _builtins.int capacity_in_gbs: Capacity of the Lustre file system in GB.
        :param _builtins.str cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param _builtins.str file_system_description: Short description of the Lustre file system. Avoid entering confidential information.
        :param _builtins.str file_system_name: The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        :param _builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param _builtins.str lifecycle_details: A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param _builtins.str lnet: Type of network used by clients to mount the file system.   Example: `tcp`
        :param Sequence['GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowArgs'] maintenance_windows: The preferred day and time to perform maintenance.
        :param _builtins.str major_version: Major version of Lustre running in the Lustre file system.  Example: `2.15`
        :param _builtins.str management_service_address: The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        :param Sequence[_builtins.str] nsg_ids: A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param _builtins.str performance_tier: The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        :param Sequence['GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationArgs'] root_squash_configurations: An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param _builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_billing_cycle_end: The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capacity_in_gbs", capacity_in_gbs)
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "file_system_description", file_system_description)
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lnet", lnet)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "major_version", major_version)
        pulumi.set(__self__, "management_service_address", management_service_address)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "performance_tier", performance_tier)
        pulumi.set(__self__, "root_squash_configurations", root_squash_configurations)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="capacityInGbs")
    def capacity_in_gbs(self) -> _builtins.int:
        """
        Capacity of the Lustre file system in GB.
        """
        return pulumi.get(self, "capacity_in_gbs")

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group in which the Lustre file system exists.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemDescription")
    def file_system_description(self) -> _builtins.str:
        """
        Short description of the Lustre file system. Avoid entering confidential information.
        """
        return pulumi.get(self, "file_system_description")

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> _builtins.str:
        """
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface. The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.
        """
        return pulumi.get(self, "file_system_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the Lustre file system in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def lnet(self) -> _builtins.str:
        """
        Type of network used by clients to mount the file system.   Example: `tcp`
        """
        return pulumi.get(self, "lnet")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult']:
        """
        The preferred day and time to perform maintenance.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> _builtins.str:
        """
        Major version of Lustre running in the Lustre file system.  Example: `2.15`
        """
        return pulumi.get(self, "major_version")

    @_builtins.property
    @pulumi.getter(name="managementServiceAddress")
    def management_service_address(self) -> _builtins.str:
        """
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system. For example '10.0.0.4'.
        """
        return pulumi.get(self, "management_service_address")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this lustre file system. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the lustre file system from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> _builtins.str:
        """
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.
        """
        return pulumi.get(self, "performance_tier")

    @_builtins.property
    @pulumi.getter(name="rootSquashConfigurations")
    def root_squash_configurations(self) -> Sequence['outputs.GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult']:
        """
        An administrative feature that allows you to restrict root level access from clients that try to access your Lustre file system as root.
        """
        return pulumi.get(self, "root_squash_configurations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the Lustre file system is in.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> _builtins.str:
        """
        The date and time that the current billing cycle for the file system will end, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. After the current cycle ends, this date is updated automatically to the next timestamp, which is 30 days later. File systems deleted earlier than this time will still incur charges until the billing cycle ends.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Lustre file system was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 time_start: _builtins.str):
        """
        :param _builtins.str day_of_week: Day of the week when the maintainence window starts.
        :param _builtins.str time_start: The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        Day of the week when the maintainence window starts.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> _builtins.str:
        """
        The time to start the maintenance window. The format is 'HH:MM', 'HH:MM' represents the time in UTC.   Example: `22:00`
        """
        return pulumi.get(self, "time_start")


@pulumi.output_type
class GetFileStorageLustreFileSystemsLustreFileSystemCollectionItemRootSquashConfigurationResult(dict):
    def __init__(__self__, *,
                 client_exceptions: Sequence[_builtins.str],
                 identity_squash: _builtins.str,
                 squash_gid: _builtins.str,
                 squash_uid: _builtins.str):
        """
        :param Sequence[_builtins.str] client_exceptions: A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        :param _builtins.str identity_squash: Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        :param _builtins.str squash_gid: The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        :param _builtins.str squash_uid: The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        pulumi.set(__self__, "client_exceptions", client_exceptions)
        pulumi.set(__self__, "identity_squash", identity_squash)
        pulumi.set(__self__, "squash_gid", squash_gid)
        pulumi.set(__self__, "squash_uid", squash_uid)

    @_builtins.property
    @pulumi.getter(name="clientExceptions")
    def client_exceptions(self) -> Sequence[_builtins.str]:
        """
        A list of NIDs allowed with this lustre file system not to be squashed. A maximum of 10 is allowed.
        """
        return pulumi.get(self, "client_exceptions")

    @_builtins.property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> _builtins.str:
        """
        Used when clients accessing the Lustre file system have their UID and GID remapped to `squashUid` and `squashGid`. If `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `NONE`.
        """
        return pulumi.get(self, "identity_squash")

    @_builtins.property
    @pulumi.getter(name="squashGid")
    def squash_gid(self) -> _builtins.str:
        """
        The GID value to remap to when squashing a client GID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_gid")

    @_builtins.property
    @pulumi.getter(name="squashUid")
    def squash_uid(self) -> _builtins.str:
        """
        The UID value to remap to when squashing a client UID. See `identitySquash` for more details. If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "squash_uid")


@pulumi.output_type
class GetFileStorageObjectStorageLinkSyncJobsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFileStorageObjectStorageLinkSyncJobsSyncJobCollectionItemResult(dict):
    def __init__(__self__, *,
                 bytes_transferred: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_overwrite: _builtins.bool,
                 job_type: _builtins.str,
                 lifecycle_details: _builtins.str,
                 lustre_file_system_path: _builtins.str,
                 object_storage_path: _builtins.str,
                 objects_transferred: _builtins.str,
                 parent_id: _builtins.str,
                 skipped_error_count: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_finished: _builtins.str,
                 time_started: _builtins.str,
                 total_objects_scanned: _builtins.str):
        """
        :param _builtins.str bytes_transferred: Bytes transferred during the sync. This value changes while the sync is still in progress.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the sync job.
        :param _builtins.bool is_overwrite: The flag is an identifier to tell whether this specific job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param _builtins.str job_type: The type of the sync job.
        :param _builtins.str lifecycle_details: A message that describes the current state of the sync job in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param _builtins.str lustre_file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param _builtins.str object_storage_path: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param _builtins.str objects_transferred: Count of total files that transferred successfully.
        :param _builtins.str parent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
        :param _builtins.str skipped_error_count: Count of files or objects that failed to export or import due to errors.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_finished: The date and time the job finished, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        :param _builtins.str time_started: The date and time the job was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        :param _builtins.str total_objects_scanned: Total object count for scanned files for import or export as part of this sync job.
        """
        pulumi.set(__self__, "bytes_transferred", bytes_transferred)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_overwrite", is_overwrite)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lustre_file_system_path", lustre_file_system_path)
        pulumi.set(__self__, "object_storage_path", object_storage_path)
        pulumi.set(__self__, "objects_transferred", objects_transferred)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "skipped_error_count", skipped_error_count)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "total_objects_scanned", total_objects_scanned)

    @_builtins.property
    @pulumi.getter(name="bytesTransferred")
    def bytes_transferred(self) -> _builtins.str:
        """
        Bytes transferred during the sync. This value changes while the sync is still in progress.
        """
        return pulumi.get(self, "bytes_transferred")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the sync job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> _builtins.bool:
        """
        The flag is an identifier to tell whether this specific job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> _builtins.str:
        """
        The type of the sync job.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the sync job in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemPath")
    def lustre_file_system_path(self) -> _builtins.str:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "lustre_file_system_path")

    @_builtins.property
    @pulumi.getter(name="objectStoragePath")
    def object_storage_path(self) -> _builtins.str:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_path")

    @_builtins.property
    @pulumi.getter(name="objectsTransferred")
    def objects_transferred(self) -> _builtins.str:
        """
        Count of total files that transferred successfully.
        """
        return pulumi.get(self, "objects_transferred")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="skippedErrorCount")
    def skipped_error_count(self) -> _builtins.str:
        """
        Count of files or objects that failed to export or import due to errors.
        """
        return pulumi.get(self, "skipped_error_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time the job finished, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time the job was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2020-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="totalObjectsScanned")
    def total_objects_scanned(self) -> _builtins.str:
        """
        Total object count for scanned files for import or export as part of this sync job.
        """
        return pulumi.get(self, "total_objects_scanned")


@pulumi.output_type
class GetFileStorageObjectStorageLinksFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileStorageObjectStorageLinksObjectStorageLinkCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFileStorageObjectStorageLinksObjectStorageLinkCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFileStorageObjectStorageLinksObjectStorageLinkCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFileStorageObjectStorageLinksObjectStorageLinkCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 compartment_id: _builtins.str,
                 current_job_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 file_system_path: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_overwrite: _builtins.bool,
                 last_job_id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 lustre_file_system_id: _builtins.str,
                 object_storage_prefix: _builtins.str,
                 start_export_to_object_trigger: _builtins.int,
                 start_import_from_object_trigger: _builtins.int,
                 state: _builtins.str,
                 stop_export_to_object_trigger: _builtins.int,
                 stop_import_from_object_trigger: _builtins.int,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param _builtins.str current_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param _builtins.str file_system_path: The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
        :param _builtins.bool is_overwrite: The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        :param _builtins.str last_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        :param _builtins.str lifecycle_details: A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param _builtins.str lustre_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        :param _builtins.str object_storage_prefix: The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "current_job_id", current_job_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "file_system_path", file_system_path)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_overwrite", is_overwrite)
        pulumi.set(__self__, "last_job_id", last_job_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lustre_file_system_id", lustre_file_system_id)
        pulumi.set(__self__, "object_storage_prefix", object_storage_prefix)
        pulumi.set(__self__, "start_export_to_object_trigger", start_export_to_object_trigger)
        pulumi.set(__self__, "start_import_from_object_trigger", start_import_from_object_trigger)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stop_export_to_object_trigger", stop_export_to_object_trigger)
        pulumi.set(__self__, "stop_import_from_object_trigger", stop_import_from_object_trigger)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentJobId")
    def current_job_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of currently running sync job. If no sync job is running, then this will be empty.
        """
        return pulumi.get(self, "current_job_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> _builtins.str:
        """
        The path in the Lustre file system used for this Object Storage link.  Example: `myFileSystem/mount/myDirectory`
        """
        return pulumi.get(self, "file_system_path")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Object Storage link.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOverwrite")
    def is_overwrite(self) -> _builtins.bool:
        """
        The flag is an identifier to tell whether the job run has overwrite enabled. If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists. If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.
        """
        return pulumi.get(self, "is_overwrite")

    @_builtins.property
    @pulumi.getter(name="lastJobId")
    def last_job_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last succeeded sync job. If no sync job has previously run, then this will be empty.
        """
        return pulumi.get(self, "last_job_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the Object Storage link in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lustreFileSystemId")
    def lustre_file_system_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Lustre file system.
        """
        return pulumi.get(self, "lustre_file_system_id")

    @_builtins.property
    @pulumi.getter(name="objectStoragePrefix")
    def object_storage_prefix(self) -> _builtins.str:
        """
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.  Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`
        """
        return pulumi.get(self, "object_storage_prefix")

    @_builtins.property
    @pulumi.getter(name="startExportToObjectTrigger")
    def start_export_to_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "start_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="startImportFromObjectTrigger")
    def start_import_from_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "start_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopExportToObjectTrigger")
    def stop_export_to_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "stop_export_to_object_trigger")

    @_builtins.property
    @pulumi.getter(name="stopImportFromObjectTrigger")
    def stop_import_from_object_trigger(self) -> _builtins.int:
        return pulumi.get(self, "stop_import_from_object_trigger")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Lustre file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Object Storage link was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2024-04-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


