# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagementAgentInstallKeyResult',
    'AwaitableGetManagementAgentInstallKeyResult',
    'get_management_agent_install_key',
    'get_management_agent_install_key_output',
]

@pulumi.output_type
class GetManagementAgentInstallKeyResult:
    """
    A collection of values returned by getManagementAgentInstallKey.
    """
    def __init__(__self__, allowed_key_install_count=None, compartment_id=None, created_by_principal_id=None, current_key_install_count=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_unlimited=None, key=None, lifecycle_details=None, management_agent_install_key_id=None, state=None, system_tags=None, time_created=None, time_expires=None, time_updated=None):
        if allowed_key_install_count and not isinstance(allowed_key_install_count, int):
            raise TypeError("Expected argument 'allowed_key_install_count' to be a int")
        pulumi.set(__self__, "allowed_key_install_count", allowed_key_install_count)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by_principal_id and not isinstance(created_by_principal_id, str):
            raise TypeError("Expected argument 'created_by_principal_id' to be a str")
        pulumi.set(__self__, "created_by_principal_id", created_by_principal_id)
        if current_key_install_count and not isinstance(current_key_install_count, int):
            raise TypeError("Expected argument 'current_key_install_count' to be a int")
        pulumi.set(__self__, "current_key_install_count", current_key_install_count)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_unlimited and not isinstance(is_unlimited, bool):
            raise TypeError("Expected argument 'is_unlimited' to be a bool")
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_agent_install_key_id and not isinstance(management_agent_install_key_id, str):
            raise TypeError("Expected argument 'management_agent_install_key_id' to be a str")
        pulumi.set(__self__, "management_agent_install_key_id", management_agent_install_key_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expires and not isinstance(time_expires, str):
            raise TypeError("Expected argument 'time_expires' to be a str")
        pulumi.set(__self__, "time_expires", time_expires)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="allowedKeyInstallCount")
    def allowed_key_install_count(self) -> _builtins.int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "allowed_key_install_count")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdByPrincipalId")
    def created_by_principal_id(self) -> _builtins.str:
        """
        Principal id of user who created the Agent Install key
        """
        return pulumi.get(self, "created_by_principal_id")

    @_builtins.property
    @pulumi.getter(name="currentKeyInstallCount")
    def current_key_install_count(self) -> _builtins.int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "current_key_install_count")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Management Agent Install Key Name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Agent install Key identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> _builtins.bool:
        """
        If set to true, the install key has no expiration date or usage limit. Properties allowedKeyInstallCount and timeExpires are ignored if set to true. Defaults to false.
        """
        return pulumi.get(self, "is_unlimited")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Management Agent Install Key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="managementAgentInstallKeyId")
    def management_agent_install_key_id(self) -> _builtins.str:
        return pulumi.get(self, "management_agent_install_key_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Status of Key
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when Management Agent install Key was created. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> _builtins.str:
        """
        date after which key would expire after creation
        """
        return pulumi.get(self, "time_expires")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when Management Agent install Key was updated. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetManagementAgentInstallKeyResult(GetManagementAgentInstallKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentInstallKeyResult(
            allowed_key_install_count=self.allowed_key_install_count,
            compartment_id=self.compartment_id,
            created_by_principal_id=self.created_by_principal_id,
            current_key_install_count=self.current_key_install_count,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_unlimited=self.is_unlimited,
            key=self.key,
            lifecycle_details=self.lifecycle_details,
            management_agent_install_key_id=self.management_agent_install_key_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_expires=self.time_expires,
            time_updated=self.time_updated)


def get_management_agent_install_key(management_agent_install_key_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentInstallKeyResult:
    """
    This data source provides details about a specific Management Agent Install Key resource in Oracle Cloud Infrastructure Management Agent service.

    Gets complete details of the Agent install Key for a given key id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_install_key = oci.ManagementAgent.get_management_agent_install_key(management_agent_install_key_id=test_management_agent_install_key_oci_management_agent_management_agent_install_key["id"])
    ```


    :param _builtins.str management_agent_install_key_id: Unique Management Agent Install Key identifier
    """
    __args__ = dict()
    __args__['managementAgentInstallKeyId'] = management_agent_install_key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentInstallKey:getManagementAgentInstallKey', __args__, opts=opts, typ=GetManagementAgentInstallKeyResult).value

    return AwaitableGetManagementAgentInstallKeyResult(
        allowed_key_install_count=pulumi.get(__ret__, 'allowed_key_install_count'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by_principal_id=pulumi.get(__ret__, 'created_by_principal_id'),
        current_key_install_count=pulumi.get(__ret__, 'current_key_install_count'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_unlimited=pulumi.get(__ret__, 'is_unlimited'),
        key=pulumi.get(__ret__, 'key'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        management_agent_install_key_id=pulumi.get(__ret__, 'management_agent_install_key_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expires=pulumi.get(__ret__, 'time_expires'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_management_agent_install_key_output(management_agent_install_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementAgentInstallKeyResult]:
    """
    This data source provides details about a specific Management Agent Install Key resource in Oracle Cloud Infrastructure Management Agent service.

    Gets complete details of the Agent install Key for a given key id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_install_key = oci.ManagementAgent.get_management_agent_install_key(management_agent_install_key_id=test_management_agent_install_key_oci_management_agent_management_agent_install_key["id"])
    ```


    :param _builtins.str management_agent_install_key_id: Unique Management Agent Install Key identifier
    """
    __args__ = dict()
    __args__['managementAgentInstallKeyId'] = management_agent_install_key_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getManagementAgentInstallKey:getManagementAgentInstallKey', __args__, opts=opts, typ=GetManagementAgentInstallKeyResult)
    return __ret__.apply(lambda __response__: GetManagementAgentInstallKeyResult(
        allowed_key_install_count=pulumi.get(__response__, 'allowed_key_install_count'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by_principal_id=pulumi.get(__response__, 'created_by_principal_id'),
        current_key_install_count=pulumi.get(__response__, 'current_key_install_count'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_unlimited=pulumi.get(__response__, 'is_unlimited'),
        key=pulumi.get(__response__, 'key'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        management_agent_install_key_id=pulumi.get(__response__, 'management_agent_install_key_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_expires=pulumi.get(__response__, 'time_expires'),
        time_updated=pulumi.get(__response__, 'time_updated')))
