# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PublicationIcon',
    'PublicationPackageDetails',
    'PublicationPackageDetailsEula',
    'PublicationPackageDetailsOperatingSystem',
    'PublicationSupportContact',
    'PublicationSupportedOperatingSystem',
    'GetAcceptedAgreementsAcceptedAgreementResult',
    'GetAcceptedAgreementsFilterResult',
    'GetCategoriesCategoryResult',
    'GetCategoriesFilterResult',
    'GetListingBannerResult',
    'GetListingDocumentationLinkResult',
    'GetListingIconResult',
    'GetListingLanguageResult',
    'GetListingLinkResult',
    'GetListingPackageAgreementsAgreementResult',
    'GetListingPackageAgreementsFilterResult',
    'GetListingPackageOperatingSystemResult',
    'GetListingPackagePricingResult',
    'GetListingPackagePricingInternationalMarketPriceResult',
    'GetListingPackageRegionResult',
    'GetListingPackageRegionCountryResult',
    'GetListingPackageVariableResult',
    'GetListingPackagesFilterResult',
    'GetListingPackagesListingPackageResult',
    'GetListingPackagesListingPackageOperatingSystemResult',
    'GetListingPackagesListingPackagePricingResult',
    'GetListingPackagesListingPackagePricingInternationalMarketPriceResult',
    'GetListingPackagesListingPackageRegionResult',
    'GetListingPackagesListingPackageRegionCountryResult',
    'GetListingPublisherResult',
    'GetListingPublisherLinkResult',
    'GetListingPublisherLogoResult',
    'GetListingRegionResult',
    'GetListingRegionCountryResult',
    'GetListingScreenshotResult',
    'GetListingSupportContactResult',
    'GetListingSupportLinkResult',
    'GetListingSupportedOperatingSystemResult',
    'GetListingTaxesFilterResult',
    'GetListingTaxesTaxResult',
    'GetListingVideoResult',
    'GetListingsFilterResult',
    'GetListingsListingResult',
    'GetListingsListingBannerResult',
    'GetListingsListingDocumentationLinkResult',
    'GetListingsListingIconResult',
    'GetListingsListingPublisherResult',
    'GetListingsListingRegionResult',
    'GetListingsListingRegionCountryResult',
    'GetListingsListingSupportedOperatingSystemResult',
    'GetMarketplaceMetadataPublicKeysFilterResult',
    'GetMarketplaceMetadataPublicKeysMarketplaceMetadataPublicKeyResult',
    'GetPublicationIconResult',
    'GetPublicationPackageDetailResult',
    'GetPublicationPackageDetailEulaResult',
    'GetPublicationPackageDetailOperatingSystemResult',
    'GetPublicationPackageOperatingSystemResult',
    'GetPublicationPackageVariableResult',
    'GetPublicationPackagesFilterResult',
    'GetPublicationPackagesPublicationPackageResult',
    'GetPublicationSupportContactResult',
    'GetPublicationSupportedOperatingSystemResult',
    'GetPublicationsFilterResult',
    'GetPublicationsPublicationResult',
    'GetPublicationsPublicationIconResult',
    'GetPublicationsPublicationPackageDetailResult',
    'GetPublicationsPublicationPackageDetailEulaResult',
    'GetPublicationsPublicationPackageDetailOperatingSystemResult',
    'GetPublicationsPublicationSupportContactResult',
    'GetPublicationsPublicationSupportedOperatingSystemResult',
    'GetPublishersFilterResult',
    'GetPublishersPublisherResult',
]

@pulumi.output_type
class PublicationIcon(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentUrl":
            suggest = "content_url"
        elif key == "fileExtension":
            suggest = "file_extension"
        elif key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicationIcon. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicationIcon.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicationIcon.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_url: Optional[_builtins.str] = None,
                 file_extension: Optional[_builtins.str] = None,
                 mime_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_url: The content URL of the upload data.
        :param _builtins.str file_extension: The file extension of the upload data.
        :param _builtins.str mime_type: The MIME type of the upload data.
        :param _builtins.str name: (Updatable) The name of the publication, which is also used in the listing.
        """
        if content_url is not None:
            pulumi.set(__self__, "content_url", content_url)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> Optional[_builtins.str]:
        """
        The content URL of the upload data.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[_builtins.str]:
        """
        The file extension of the upload data.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[_builtins.str]:
        """
        The MIME type of the upload data.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the publication, which is also used in the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PublicationPackageDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingSystem":
            suggest = "operating_system"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "packageVersion":
            suggest = "package_version"
        elif key == "imageId":
            suggest = "image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicationPackageDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicationPackageDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicationPackageDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eulas: Sequence['outputs.PublicationPackageDetailsEula'],
                 operating_system: 'outputs.PublicationPackageDetailsOperatingSystem',
                 package_type: _builtins.str,
                 package_version: _builtins.str,
                 image_id: Optional[_builtins.str] = None):
        """
        :param Sequence['PublicationPackageDetailsEulaArgs'] eulas: The end user license agreeement (EULA) that consumers of this listing must accept.
        :param 'PublicationPackageDetailsOperatingSystemArgs' operating_system: The operating system used by the listing.
        :param _builtins.str package_type: The package's type.
        :param _builtins.str package_version: The package version.
        :param _builtins.str image_id: The unique identifier for the base image of the publication.
        """
        pulumi.set(__self__, "eulas", eulas)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "package_version", package_version)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)

    @_builtins.property
    @pulumi.getter
    def eulas(self) -> Sequence['outputs.PublicationPackageDetailsEula']:
        """
        The end user license agreeement (EULA) that consumers of this listing must accept.
        """
        return pulumi.get(self, "eulas")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> 'outputs.PublicationPackageDetailsOperatingSystem':
        """
        The operating system used by the listing.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        The package's type.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        """
        The package version.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        """
        The unique identifier for the base image of the publication.
        """
        return pulumi.get(self, "image_id")


@pulumi.output_type
class PublicationPackageDetailsEula(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eulaType":
            suggest = "eula_type"
        elif key == "licenseText":
            suggest = "license_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicationPackageDetailsEula. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicationPackageDetailsEula.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicationPackageDetailsEula.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eula_type: _builtins.str,
                 license_text: Optional[_builtins.str] = None):
        """
        :param _builtins.str eula_type: The end user license agreement's type.
        :param _builtins.str license_text: The text of the end user license agreement.
        """
        pulumi.set(__self__, "eula_type", eula_type)
        if license_text is not None:
            pulumi.set(__self__, "license_text", license_text)

    @_builtins.property
    @pulumi.getter(name="eulaType")
    def eula_type(self) -> _builtins.str:
        """
        The end user license agreement's type.
        """
        return pulumi.get(self, "eula_type")

    @_builtins.property
    @pulumi.getter(name="licenseText")
    def license_text(self) -> Optional[_builtins.str]:
        """
        The text of the end user license agreement.
        """
        return pulumi.get(self, "license_text")


@pulumi.output_type
class PublicationPackageDetailsOperatingSystem(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the operating system.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PublicationSupportContact(dict):
    def __init__(__self__, *,
                 email: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 phone: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: (Updatable) The email of the contact.
        :param _builtins.str name: (Updatable) The name of the contact.
        :param _builtins.str phone: (Updatable) The phone number of the contact.
        :param _builtins.str subject: (Updatable) The email subject line to use when contacting support.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        (Updatable) The email of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the contact.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> Optional[_builtins.str]:
        """
        (Updatable) The phone number of the contact.
        """
        return pulumi.get(self, "phone")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        (Updatable) The email subject line to use when contacting support.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class PublicationSupportedOperatingSystem(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: (Updatable) The name of the publication, which is also used in the listing.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the publication, which is also used in the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAcceptedAgreementsAcceptedAgreementResult(dict):
    def __init__(__self__, *,
                 agreement_id: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 listing_id: _builtins.str,
                 package_version: _builtins.str,
                 signature: _builtins.str,
                 time_accepted: _builtins.str):
        """
        :param _builtins.str agreement_id: The unique identifier for the terms of use agreement itself.
        :param _builtins.str compartment_id: The unique identifier for the compartment.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: The display name of the resource.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The unique identifier for the acceptance of the agreement within a specific compartment.
        :param _builtins.str listing_id: The unique identifier for the listing.
        :param _builtins.str package_version: The version of the package. Package versions are unique within a listing.
        :param _builtins.str time_accepted: The time the agreement was accepted.
        """
        pulumi.set(__self__, "agreement_id", agreement_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "package_version", package_version)
        pulumi.set(__self__, "signature", signature)
        pulumi.set(__self__, "time_accepted", time_accepted)

    @_builtins.property
    @pulumi.getter(name="agreementId")
    def agreement_id(self) -> _builtins.str:
        """
        The unique identifier for the terms of use agreement itself.
        """
        return pulumi.get(self, "agreement_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The unique identifier for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the acceptance of the agreement within a specific compartment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> _builtins.str:
        """
        The unique identifier for the listing.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        """
        The version of the package. Package versions are unique within a listing.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> _builtins.str:
        return pulumi.get(self, "signature")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> _builtins.str:
        """
        The time the agreement was accepted.
        """
        return pulumi.get(self, "time_accepted")


@pulumi.output_type
class GetAcceptedAgreementsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCategoriesCategoryResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of the product category.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the product category.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCategoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the product category.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the product category.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListingBannerResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingDocumentationLinkResult(dict):
    def __init__(__self__, *,
                 document_category: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str document_category: The category that the document belongs to.
        :param _builtins.str name: Text that describes the resource.
        :param _builtins.str url: The URL of the resource.
        """
        pulumi.set(__self__, "document_category", document_category)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="documentCategory")
    def document_category(self) -> _builtins.str:
        """
        The category that the document belongs to.
        """
        return pulumi.get(self, "document_category")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetListingIconResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingLanguageResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingLinkResult(dict):
    def __init__(__self__, *,
                 href: _builtins.str,
                 rel: _builtins.str):
        """
        :param _builtins.str href: The anchor tag.
        :param _builtins.str rel: Reference links to the previous page, next page, and other pages.
        """
        pulumi.set(__self__, "href", href)
        pulumi.set(__self__, "rel", rel)

    @_builtins.property
    @pulumi.getter
    def href(self) -> _builtins.str:
        """
        The anchor tag.
        """
        return pulumi.get(self, "href")

    @_builtins.property
    @pulumi.getter
    def rel(self) -> _builtins.str:
        """
        Reference links to the previous page, next page, and other pages.
        """
        return pulumi.get(self, "rel")


@pulumi.output_type
class GetListingPackageAgreementsAgreementResult(dict):
    def __init__(__self__, *,
                 author: _builtins.str,
                 content_url: _builtins.str,
                 id: _builtins.str,
                 prompt: _builtins.str):
        """
        :param _builtins.str author: Who authored the agreement.
        :param _builtins.str content_url: The content URL of the agreement.
        :param _builtins.str id: The unique identifier for the agreement.
        :param _builtins.str prompt: Textual prompt to read and accept the agreement.
        """
        pulumi.set(__self__, "author", author)
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prompt", prompt)

    @_builtins.property
    @pulumi.getter
    def author(self) -> _builtins.str:
        """
        Who authored the agreement.
        """
        return pulumi.get(self, "author")

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the agreement.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the agreement.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prompt(self) -> _builtins.str:
        """
        Textual prompt to read and accept the agreement.
        """
        return pulumi.get(self, "prompt")


@pulumi.output_type
class GetListingPackageAgreementsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListingPackageOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackagePricingResult(dict):
    def __init__(__self__, *,
                 currency: _builtins.str,
                 international_market_prices: Sequence['outputs.GetListingPackagePricingInternationalMarketPriceResult'],
                 pay_go_strategy: _builtins.str,
                 rate: _builtins.float,
                 type: _builtins.str):
        """
        :param _builtins.str currency: The currency of the pricing model.
        :param Sequence['GetListingPackagePricingInternationalMarketPriceArgs'] international_market_prices: The model for international market pricing.
        :param _builtins.str pay_go_strategy: The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.
        :param _builtins.float rate: The pricing rate.
        :param _builtins.str type: The type of the pricing model.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "international_market_prices", international_market_prices)
        pulumi.set(__self__, "pay_go_strategy", pay_go_strategy)
        pulumi.set(__self__, "rate", rate)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        The currency of the pricing model.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="internationalMarketPrices")
    def international_market_prices(self) -> Sequence['outputs.GetListingPackagePricingInternationalMarketPriceResult']:
        """
        The model for international market pricing.
        """
        return pulumi.get(self, "international_market_prices")

    @_builtins.property
    @pulumi.getter(name="payGoStrategy")
    def pay_go_strategy(self) -> _builtins.str:
        """
        The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.
        """
        return pulumi.get(self, "pay_go_strategy")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> _builtins.float:
        """
        The pricing rate.
        """
        return pulumi.get(self, "rate")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the pricing model.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetListingPackagePricingInternationalMarketPriceResult(dict):
    def __init__(__self__, *,
                 currency_code: _builtins.str,
                 currency_symbol: _builtins.str,
                 rate: _builtins.float):
        """
        :param _builtins.str currency_code: The currency of the pricing model.
        :param _builtins.str currency_symbol: The symbol of the currency
        :param _builtins.float rate: The pricing rate.
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "rate", rate)

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> _builtins.str:
        """
        The currency of the pricing model.
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> _builtins.str:
        """
        The symbol of the currency
        """
        return pulumi.get(self, "currency_symbol")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> _builtins.float:
        """
        The pricing rate.
        """
        return pulumi.get(self, "rate")


@pulumi.output_type
class GetListingPackageRegionResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 countries: Sequence['outputs.GetListingPackageRegionCountryResult'],
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param Sequence['GetListingPackageRegionCountryArgs'] countries: Countries in the region.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetListingPackageRegionCountryResult']:
        """
        Countries in the region.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackageRegionCountryResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackageVariableResult(dict):
    def __init__(__self__, *,
                 data_type: _builtins.str,
                 default_value: _builtins.str,
                 description: _builtins.str,
                 hint_message: _builtins.str,
                 is_mandatory: _builtins.bool,
                 name: _builtins.str):
        """
        :param _builtins.str data_type: The data type of the variable.
        :param _builtins.str default_value: The variable's default value.
        :param _builtins.str description: A description of the variable.
        :param _builtins.str hint_message: A brief textual description that helps to explain the variable.
        :param _builtins.bool is_mandatory: Whether the variable is mandatory.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hint_message", hint_message)
        pulumi.set(__self__, "is_mandatory", is_mandatory)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> _builtins.str:
        """
        The data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The variable's default value.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hintMessage")
    def hint_message(self) -> _builtins.str:
        """
        A brief textual description that helps to explain the variable.
        """
        return pulumi.get(self, "hint_message")

    @_builtins.property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> _builtins.bool:
        """
        Whether the variable is mandatory.
        """
        return pulumi.get(self, "is_mandatory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackagesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListingPackagesListingPackageResult(dict):
    def __init__(__self__, *,
                 listing_id: _builtins.str,
                 operating_systems: Sequence['outputs.GetListingPackagesListingPackageOperatingSystemResult'],
                 package_type: _builtins.str,
                 package_version: _builtins.str,
                 pricings: Sequence['outputs.GetListingPackagesListingPackagePricingResult'],
                 regions: Sequence['outputs.GetListingPackagesListingPackageRegionResult'],
                 resource_id: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str listing_id: The unique identifier for the listing.
        :param Sequence['GetListingPackagesListingPackageOperatingSystemArgs'] operating_systems: The operating system used by the listing.
        :param _builtins.str package_type: A filter to return only packages that match the given package type exactly.
        :param _builtins.str package_version: The version of the package. Package versions are unique within a listing.
        :param Sequence['GetListingPackagesListingPackagePricingArgs'] pricings: The model for pricing.
        :param Sequence['GetListingPackagesListingPackageRegionArgs'] regions: The regions where you can deploy the listing package. (Some packages have restrictions that limit their deployment to United States regions only.)
        :param _builtins.str resource_id: The unique identifier for the package resource.
        :param _builtins.str time_created: The date and time this listing package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "operating_systems", operating_systems)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "package_version", package_version)
        pulumi.set(__self__, "pricings", pricings)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> _builtins.str:
        """
        The unique identifier for the listing.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Sequence['outputs.GetListingPackagesListingPackageOperatingSystemResult']:
        """
        The operating system used by the listing.
        """
        return pulumi.get(self, "operating_systems")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        A filter to return only packages that match the given package type exactly.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        """
        The version of the package. Package versions are unique within a listing.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter
    def pricings(self) -> Sequence['outputs.GetListingPackagesListingPackagePricingResult']:
        """
        The model for pricing.
        """
        return pulumi.get(self, "pricings")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetListingPackagesListingPackageRegionResult']:
        """
        The regions where you can deploy the listing package. (Some packages have restrictions that limit their deployment to United States regions only.)
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The unique identifier for the package resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time this listing package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetListingPackagesListingPackageOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackagesListingPackagePricingResult(dict):
    def __init__(__self__, *,
                 currency: _builtins.str,
                 international_market_prices: Sequence['outputs.GetListingPackagesListingPackagePricingInternationalMarketPriceResult'],
                 pay_go_strategy: _builtins.str,
                 rate: _builtins.float,
                 type: _builtins.str):
        """
        :param _builtins.str currency: The currency of the pricing model.
        :param Sequence['GetListingPackagesListingPackagePricingInternationalMarketPriceArgs'] international_market_prices: The model for international market pricing.
        :param _builtins.str pay_go_strategy: The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.
        :param _builtins.float rate: The pricing rate.
        :param _builtins.str type: The type of the pricing model.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "international_market_prices", international_market_prices)
        pulumi.set(__self__, "pay_go_strategy", pay_go_strategy)
        pulumi.set(__self__, "rate", rate)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        The currency of the pricing model.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="internationalMarketPrices")
    def international_market_prices(self) -> Sequence['outputs.GetListingPackagesListingPackagePricingInternationalMarketPriceResult']:
        """
        The model for international market pricing.
        """
        return pulumi.get(self, "international_market_prices")

    @_builtins.property
    @pulumi.getter(name="payGoStrategy")
    def pay_go_strategy(self) -> _builtins.str:
        """
        The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.
        """
        return pulumi.get(self, "pay_go_strategy")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> _builtins.float:
        """
        The pricing rate.
        """
        return pulumi.get(self, "rate")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the pricing model.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetListingPackagesListingPackagePricingInternationalMarketPriceResult(dict):
    def __init__(__self__, *,
                 currency_code: _builtins.str,
                 currency_symbol: _builtins.str,
                 rate: _builtins.float):
        """
        :param _builtins.str currency_code: The currency of the pricing model.
        :param _builtins.str currency_symbol: The symbol of the currency
        :param _builtins.float rate: The pricing rate.
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "rate", rate)

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> _builtins.str:
        """
        The currency of the pricing model.
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> _builtins.str:
        """
        The symbol of the currency
        """
        return pulumi.get(self, "currency_symbol")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> _builtins.float:
        """
        The pricing rate.
        """
        return pulumi.get(self, "rate")


@pulumi.output_type
class GetListingPackagesListingPackageRegionResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 countries: Sequence['outputs.GetListingPackagesListingPackageRegionCountryResult'],
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param Sequence['GetListingPackagesListingPackageRegionCountryArgs'] countries: Countries in the region.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetListingPackagesListingPackageRegionCountryResult']:
        """
        Countries in the region.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPackagesListingPackageRegionCountryResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingPublisherResult(dict):
    def __init__(__self__, *,
                 contact_email: _builtins.str,
                 contact_phone: _builtins.str,
                 description: _builtins.str,
                 hq_address: _builtins.str,
                 id: _builtins.str,
                 links: Sequence['outputs.GetListingPublisherLinkResult'],
                 logos: Sequence['outputs.GetListingPublisherLogoResult'],
                 name: _builtins.str,
                 website_url: _builtins.str,
                 year_founded: _builtins.str):
        """
        :param _builtins.str contact_email: The email address of the publisher.
        :param _builtins.str contact_phone: The phone number of the publisher.
        :param _builtins.str description: A description of the screenshot.
        :param _builtins.str hq_address: The address of the publisher's headquarters.
        :param _builtins.str id: The unique identifier for the publisher.
        :param Sequence['GetListingPublisherLinkArgs'] links: Reference links.
        :param Sequence['GetListingPublisherLogoArgs'] logos: The model for upload data for images and icons.
        :param _builtins.str name: Text that describes the resource.
        :param _builtins.str website_url: The publisher's website.
        :param _builtins.str year_founded: The year the publisher's company or organization was founded.
        """
        pulumi.set(__self__, "contact_email", contact_email)
        pulumi.set(__self__, "contact_phone", contact_phone)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hq_address", hq_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "logos", logos)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "website_url", website_url)
        pulumi.set(__self__, "year_founded", year_founded)

    @_builtins.property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> _builtins.str:
        """
        The email address of the publisher.
        """
        return pulumi.get(self, "contact_email")

    @_builtins.property
    @pulumi.getter(name="contactPhone")
    def contact_phone(self) -> _builtins.str:
        """
        The phone number of the publisher.
        """
        return pulumi.get(self, "contact_phone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the screenshot.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hqAddress")
    def hq_address(self) -> _builtins.str:
        """
        The address of the publisher's headquarters.
        """
        return pulumi.get(self, "hq_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the publisher.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetListingPublisherLinkResult']:
        """
        Reference links.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def logos(self) -> Sequence['outputs.GetListingPublisherLogoResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "logos")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> _builtins.str:
        """
        The publisher's website.
        """
        return pulumi.get(self, "website_url")

    @_builtins.property
    @pulumi.getter(name="yearFounded")
    def year_founded(self) -> _builtins.str:
        """
        The year the publisher's company or organization was founded.
        """
        return pulumi.get(self, "year_founded")


@pulumi.output_type
class GetListingPublisherLinkResult(dict):
    def __init__(__self__, *,
                 href: _builtins.str,
                 rel: _builtins.str):
        """
        :param _builtins.str href: The anchor tag.
        :param _builtins.str rel: Reference links to the previous page, next page, and other pages.
        """
        pulumi.set(__self__, "href", href)
        pulumi.set(__self__, "rel", rel)

    @_builtins.property
    @pulumi.getter
    def href(self) -> _builtins.str:
        """
        The anchor tag.
        """
        return pulumi.get(self, "href")

    @_builtins.property
    @pulumi.getter
    def rel(self) -> _builtins.str:
        """
        Reference links to the previous page, next page, and other pages.
        """
        return pulumi.get(self, "rel")


@pulumi.output_type
class GetListingPublisherLogoResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingRegionResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 countries: Sequence['outputs.GetListingRegionCountryResult'],
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param Sequence['GetListingRegionCountryArgs'] countries: Countries in the region.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetListingRegionCountryResult']:
        """
        Countries in the region.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingRegionCountryResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingScreenshotResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 description: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str description: A description of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the screenshot.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingSupportContactResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 name: _builtins.str,
                 phone: _builtins.str,
                 subject: _builtins.str):
        """
        :param _builtins.str email: The email of the contact.
        :param _builtins.str name: Text that describes the resource.
        :param _builtins.str phone: The phone number of the contact.
        :param _builtins.str subject: The email subject line to use when contacting support.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> _builtins.str:
        """
        The phone number of the contact.
        """
        return pulumi.get(self, "phone")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The email subject line to use when contacting support.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetListingSupportLinkResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str name: Text that describes the resource.
        :param _builtins.str url: The URL of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetListingSupportedOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Text that describes the resource.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingTaxesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the tax code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the tax code.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListingTaxesTaxResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 country: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str code: Unique code for the tax.
        :param _builtins.str country: Country, which imposes the tax.
        :param _builtins.str name: Name of the tax code.
        :param _builtins.str url: The URL with more details about this tax.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        Unique code for the tax.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country, which imposes the tax.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the tax code.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL with more details about this tax.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetListingVideoResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str name: Text that describes the resource.
        :param _builtins.str url: The URL of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetListingsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetListingsListingResult(dict):
    def __init__(__self__, *,
                 banners: Sequence['outputs.GetListingsListingBannerResult'],
                 categories: Sequence[_builtins.str],
                 compatible_architectures: Sequence[_builtins.str],
                 default_package_version: _builtins.str,
                 documentation_links: Sequence['outputs.GetListingsListingDocumentationLinkResult'],
                 icons: Sequence['outputs.GetListingsListingIconResult'],
                 id: _builtins.str,
                 is_featured: _builtins.bool,
                 listing_type: _builtins.str,
                 name: _builtins.str,
                 package_type: _builtins.str,
                 pricing_types: Sequence[_builtins.str],
                 publishers: Sequence['outputs.GetListingsListingPublisherResult'],
                 regions: Sequence['outputs.GetListingsListingRegionResult'],
                 short_description: _builtins.str,
                 supported_operating_systems: Sequence['outputs.GetListingsListingSupportedOperatingSystemResult']):
        """
        :param Sequence['GetListingsListingBannerArgs'] banners: The model for upload data for images and icons.
        :param Sequence[_builtins.str] categories: Product categories that the listing belongs to.
        :param Sequence[_builtins.str] compatible_architectures: The list of compatible architectures supported by the listing
        :param _builtins.str default_package_version: The default package version.
        :param Sequence['GetListingsListingDocumentationLinkArgs'] documentation_links: Links to additional documentation provided by the publisher specifically for the listing.
        :param Sequence['GetListingsListingIconArgs'] icons: The model for upload data for images and icons.
        :param _builtins.str id: The unique identifier for the publisher.
        :param _builtins.bool is_featured: Indicates whether to show only featured listings. If this is set to `false` or is omitted, then all listings will be returned.
        :param _builtins.str listing_type: The publisher category to which the listing belongs. The publisher category informs where the listing appears for use.
        :param _builtins.str name: The name of the listing.
        :param _builtins.str package_type: A filter to return only packages that match the given package type exactly.
        :param Sequence['GetListingsListingPublisherArgs'] publishers: Summary details about the publisher of the listing.
        :param Sequence['GetListingsListingRegionArgs'] regions: The regions where the listing is eligible to be deployed.
        :param _builtins.str short_description: A short description of the listing.
        :param Sequence['GetListingsListingSupportedOperatingSystemArgs'] supported_operating_systems: The list of operating systems supported by the listing.
        """
        pulumi.set(__self__, "banners", banners)
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        pulumi.set(__self__, "default_package_version", default_package_version)
        pulumi.set(__self__, "documentation_links", documentation_links)
        pulumi.set(__self__, "icons", icons)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_featured", is_featured)
        pulumi.set(__self__, "listing_type", listing_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "pricing_types", pricing_types)
        pulumi.set(__self__, "publishers", publishers)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "short_description", short_description)
        pulumi.set(__self__, "supported_operating_systems", supported_operating_systems)

    @_builtins.property
    @pulumi.getter
    def banners(self) -> Sequence['outputs.GetListingsListingBannerResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "banners")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        Product categories that the listing belongs to.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Sequence[_builtins.str]:
        """
        The list of compatible architectures supported by the listing
        """
        return pulumi.get(self, "compatible_architectures")

    @_builtins.property
    @pulumi.getter(name="defaultPackageVersion")
    def default_package_version(self) -> _builtins.str:
        """
        The default package version.
        """
        return pulumi.get(self, "default_package_version")

    @_builtins.property
    @pulumi.getter(name="documentationLinks")
    def documentation_links(self) -> Sequence['outputs.GetListingsListingDocumentationLinkResult']:
        """
        Links to additional documentation provided by the publisher specifically for the listing.
        """
        return pulumi.get(self, "documentation_links")

    @_builtins.property
    @pulumi.getter
    def icons(self) -> Sequence['outputs.GetListingsListingIconResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "icons")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the publisher.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFeatured")
    def is_featured(self) -> _builtins.bool:
        """
        Indicates whether to show only featured listings. If this is set to `false` or is omitted, then all listings will be returned.
        """
        return pulumi.get(self, "is_featured")

    @_builtins.property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> _builtins.str:
        """
        The publisher category to which the listing belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        A filter to return only packages that match the given package type exactly.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="pricingTypes")
    def pricing_types(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "pricing_types")

    @_builtins.property
    @pulumi.getter
    def publishers(self) -> Sequence['outputs.GetListingsListingPublisherResult']:
        """
        Summary details about the publisher of the listing.
        """
        return pulumi.get(self, "publishers")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetListingsListingRegionResult']:
        """
        The regions where the listing is eligible to be deployed.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> _builtins.str:
        """
        A short description of the listing.
        """
        return pulumi.get(self, "short_description")

    @_builtins.property
    @pulumi.getter(name="supportedOperatingSystems")
    def supported_operating_systems(self) -> Sequence['outputs.GetListingsListingSupportedOperatingSystemResult']:
        """
        The list of operating systems supported by the listing.
        """
        return pulumi.get(self, "supported_operating_systems")


@pulumi.output_type
class GetListingsListingBannerResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingsListingDocumentationLinkResult(dict):
    def __init__(__self__, *,
                 document_category: _builtins.str,
                 name: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str document_category: The category that the document belongs to.
        :param _builtins.str name: The name of the listing.
        :param _builtins.str url: The URL of the resource.
        """
        pulumi.set(__self__, "document_category", document_category)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="documentCategory")
    def document_category(self) -> _builtins.str:
        """
        The category that the document belongs to.
        """
        return pulumi.get(self, "document_category")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetListingsListingIconResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the screenshot.
        :param _builtins.str file_extension: The file extension of the screenshot.
        :param _builtins.str mime_type: The MIME type of the screenshot.
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the screenshot.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the screenshot.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the screenshot.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingsListingPublisherResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: A description of the screenshot.
        :param _builtins.str id: The unique identifier for the publisher.
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the screenshot.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the publisher.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingsListingRegionResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 countries: Sequence['outputs.GetListingsListingRegionCountryResult'],
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param Sequence['GetListingsListingRegionCountryArgs'] countries: Countries in the region.
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetListingsListingRegionCountryResult']:
        """
        Countries in the region.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingsListingRegionCountryResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str code: A code assigned to the item.
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        A code assigned to the item.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetListingsListingSupportedOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the listing.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetMarketplaceMetadataPublicKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMarketplaceMetadataPublicKeysMarketplaceMetadataPublicKeyResult(dict):
    def __init__(__self__, *,
                 certificate_chains: Sequence[_builtins.str],
                 certificate_thumbprint: _builtins.str,
                 exponent: _builtins.str,
                 key_algorithm: _builtins.str,
                 key_id: _builtins.str,
                 key_type: _builtins.str,
                 key_use: _builtins.str,
                 modulus: _builtins.str):
        """
        :param Sequence[_builtins.str] certificate_chains: chain of certificates used to sign JWT
        :param _builtins.str certificate_thumbprint: unique identifier of associated X509 certificate
        :param _builtins.str exponent: base64 encoded exponent for public key
        :param _builtins.str key_algorithm: algorithm for public key (i.e. RS256)
        :param _builtins.str key_id: unique id that maps to public certificate, directs user which certificate to use to verfiy
        :param _builtins.str key_type: key type (i.e. RSA)
        :param _builtins.str key_use: how key is to be used
        :param _builtins.str modulus: RSA public modulus
        """
        pulumi.set(__self__, "certificate_chains", certificate_chains)
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "key_use", key_use)
        pulumi.set(__self__, "modulus", modulus)

    @_builtins.property
    @pulumi.getter(name="certificateChains")
    def certificate_chains(self) -> Sequence[_builtins.str]:
        """
        chain of certificates used to sign JWT
        """
        return pulumi.get(self, "certificate_chains")

    @_builtins.property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> _builtins.str:
        """
        unique identifier of associated X509 certificate
        """
        return pulumi.get(self, "certificate_thumbprint")

    @_builtins.property
    @pulumi.getter
    def exponent(self) -> _builtins.str:
        """
        base64 encoded exponent for public key
        """
        return pulumi.get(self, "exponent")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> _builtins.str:
        """
        algorithm for public key (i.e. RS256)
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        unique id that maps to public certificate, directs user which certificate to use to verfiy
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        key type (i.e. RSA)
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="keyUse")
    def key_use(self) -> _builtins.str:
        """
        how key is to be used
        """
        return pulumi.get(self, "key_use")

    @_builtins.property
    @pulumi.getter
    def modulus(self) -> _builtins.str:
        """
        RSA public modulus
        """
        return pulumi.get(self, "modulus")


@pulumi.output_type
class GetPublicationIconResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the upload data.
        :param _builtins.str file_extension: The file extension of the upload data.
        :param _builtins.str mime_type: The MIME type of the upload data.
        :param _builtins.str name: The name of the operating system.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the upload data.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the upload data.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the upload data.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationPackageDetailResult(dict):
    def __init__(__self__, *,
                 eulas: Sequence['outputs.GetPublicationPackageDetailEulaResult'],
                 image_id: _builtins.str,
                 operating_systems: Sequence['outputs.GetPublicationPackageDetailOperatingSystemResult'],
                 package_type: _builtins.str,
                 package_version: _builtins.str):
        """
        :param _builtins.str package_type: The listing's package type.
        """
        pulumi.set(__self__, "eulas", eulas)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "operating_systems", operating_systems)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "package_version", package_version)

    @_builtins.property
    @pulumi.getter
    def eulas(self) -> Sequence['outputs.GetPublicationPackageDetailEulaResult']:
        return pulumi.get(self, "eulas")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Sequence['outputs.GetPublicationPackageDetailOperatingSystemResult']:
        return pulumi.get(self, "operating_systems")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        The listing's package type.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        return pulumi.get(self, "package_version")


@pulumi.output_type
class GetPublicationPackageDetailEulaResult(dict):
    def __init__(__self__, *,
                 eula_type: _builtins.str,
                 license_text: _builtins.str):
        pulumi.set(__self__, "eula_type", eula_type)
        pulumi.set(__self__, "license_text", license_text)

    @_builtins.property
    @pulumi.getter(name="eulaType")
    def eula_type(self) -> _builtins.str:
        return pulumi.get(self, "eula_type")

    @_builtins.property
    @pulumi.getter(name="licenseText")
    def license_text(self) -> _builtins.str:
        return pulumi.get(self, "license_text")


@pulumi.output_type
class GetPublicationPackageDetailOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the operating system.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationPackageOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationPackageVariableResult(dict):
    def __init__(__self__, *,
                 data_type: _builtins.str,
                 default_value: _builtins.str,
                 description: _builtins.str,
                 hint_message: _builtins.str,
                 is_mandatory: _builtins.bool,
                 name: _builtins.str):
        """
        :param _builtins.str data_type: The data type of the variable.
        :param _builtins.str default_value: The variable's default value.
        :param _builtins.str description: A description of the variable.
        :param _builtins.str hint_message: A brief textual description that helps to explain the variable.
        :param _builtins.bool is_mandatory: Whether the variable is mandatory.
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hint_message", hint_message)
        pulumi.set(__self__, "is_mandatory", is_mandatory)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> _builtins.str:
        """
        The data type of the variable.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The variable's default value.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hintMessage")
    def hint_message(self) -> _builtins.str:
        """
        A brief textual description that helps to explain the variable.
        """
        return pulumi.get(self, "hint_message")

    @_builtins.property
    @pulumi.getter(name="isMandatory")
    def is_mandatory(self) -> _builtins.bool:
        """
        Whether the variable is mandatory.
        """
        return pulumi.get(self, "is_mandatory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationPackagesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPublicationPackagesPublicationPackageResult(dict):
    def __init__(__self__, *,
                 listing_id: _builtins.str,
                 package_type: _builtins.str,
                 package_version: _builtins.str,
                 resource_id: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str listing_id: The ID of the listing that the specified package belongs to.
        :param _builtins.str package_type: A filter to return only packages that match the given package type exactly.
        :param _builtins.str package_version: The version of the package. Package versions are unique within a listing.
        :param _builtins.str resource_id: The unique identifier for the package resource.
        :param _builtins.str time_created: The date and time the publication package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "package_version", package_version)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> _builtins.str:
        """
        The ID of the listing that the specified package belongs to.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        A filter to return only packages that match the given package type exactly.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        """
        The version of the package. Package versions are unique within a listing.
        """
        return pulumi.get(self, "package_version")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The unique identifier for the package resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the publication package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetPublicationSupportContactResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 name: _builtins.str,
                 phone: _builtins.str,
                 subject: _builtins.str):
        """
        :param _builtins.str email: The email of the contact.
        :param _builtins.str name: The name of the operating system.
        :param _builtins.str phone: The phone number of the contact.
        :param _builtins.str subject: The email subject line to use when contacting support.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> _builtins.str:
        """
        The phone number of the contact.
        """
        return pulumi.get(self, "phone")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The email subject line to use when contacting support.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetPublicationSupportedOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the operating system.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the publication.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPublicationsPublicationResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 icons: Sequence['outputs.GetPublicationsPublicationIconResult'],
                 id: _builtins.str,
                 is_agreement_acknowledged: _builtins.bool,
                 listing_type: _builtins.str,
                 long_description: _builtins.str,
                 name: _builtins.str,
                 package_details: Sequence['outputs.GetPublicationsPublicationPackageDetailResult'],
                 package_type: _builtins.str,
                 short_description: _builtins.str,
                 state: _builtins.str,
                 support_contacts: Sequence['outputs.GetPublicationsPublicationSupportContactResult'],
                 supported_operating_systems: Sequence['outputs.GetPublicationsPublicationSupportedOperatingSystemResult'],
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str compartment_id: The unique identifier for the compartment.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param Sequence['GetPublicationsPublicationIconArgs'] icons: The model for upload data for images and icons.
        :param _builtins.str id: The unique identifier for the publication in Marketplace.
        :param _builtins.str listing_type: The type of the listing.
        :param _builtins.str long_description: A long description of the publication to use in the listing.
        :param _builtins.str name: The name of the publication.
        :param _builtins.str package_type: The listing's package type.
        :param _builtins.str short_description: A short description of the publication to use in the listing.
        :param _builtins.str state: The lifecycle state of the publication.
        :param Sequence['GetPublicationsPublicationSupportContactArgs'] support_contacts: Contact information for getting support from the publisher for the listing.
        :param Sequence['GetPublicationsPublicationSupportedOperatingSystemArgs'] supported_operating_systems: The list of operating systems supported by the listing.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "icons", icons)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_agreement_acknowledged", is_agreement_acknowledged)
        pulumi.set(__self__, "listing_type", listing_type)
        pulumi.set(__self__, "long_description", long_description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_details", package_details)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "short_description", short_description)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "support_contacts", support_contacts)
        pulumi.set(__self__, "supported_operating_systems", supported_operating_systems)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The unique identifier for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def icons(self) -> Sequence['outputs.GetPublicationsPublicationIconResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "icons")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the publication in Marketplace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAgreementAcknowledged")
    def is_agreement_acknowledged(self) -> _builtins.bool:
        return pulumi.get(self, "is_agreement_acknowledged")

    @_builtins.property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> _builtins.str:
        """
        The type of the listing.
        """
        return pulumi.get(self, "listing_type")

    @_builtins.property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> _builtins.str:
        """
        A long description of the publication to use in the listing.
        """
        return pulumi.get(self, "long_description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageDetails")
    def package_details(self) -> Sequence['outputs.GetPublicationsPublicationPackageDetailResult']:
        return pulumi.get(self, "package_details")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        The listing's package type.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> _builtins.str:
        """
        A short description of the publication to use in the listing.
        """
        return pulumi.get(self, "short_description")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The lifecycle state of the publication.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="supportContacts")
    def support_contacts(self) -> Sequence['outputs.GetPublicationsPublicationSupportContactResult']:
        """
        Contact information for getting support from the publisher for the listing.
        """
        return pulumi.get(self, "support_contacts")

    @_builtins.property
    @pulumi.getter(name="supportedOperatingSystems")
    def supported_operating_systems(self) -> Sequence['outputs.GetPublicationsPublicationSupportedOperatingSystemResult']:
        """
        The list of operating systems supported by the listing.
        """
        return pulumi.get(self, "supported_operating_systems")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetPublicationsPublicationIconResult(dict):
    def __init__(__self__, *,
                 content_url: _builtins.str,
                 file_extension: _builtins.str,
                 mime_type: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str content_url: The content URL of the upload data.
        :param _builtins.str file_extension: The file extension of the upload data.
        :param _builtins.str mime_type: The MIME type of the upload data.
        :param _builtins.str name: The name of the publication.
        """
        pulumi.set(__self__, "content_url", content_url)
        pulumi.set(__self__, "file_extension", file_extension)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> _builtins.str:
        """
        The content URL of the upload data.
        """
        return pulumi.get(self, "content_url")

    @_builtins.property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> _builtins.str:
        """
        The file extension of the upload data.
        """
        return pulumi.get(self, "file_extension")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The MIME type of the upload data.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationsPublicationPackageDetailResult(dict):
    def __init__(__self__, *,
                 eulas: Sequence['outputs.GetPublicationsPublicationPackageDetailEulaResult'],
                 image_id: _builtins.str,
                 operating_systems: Sequence['outputs.GetPublicationsPublicationPackageDetailOperatingSystemResult'],
                 package_type: _builtins.str,
                 package_version: _builtins.str):
        """
        :param _builtins.str package_type: The listing's package type.
        """
        pulumi.set(__self__, "eulas", eulas)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "operating_systems", operating_systems)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "package_version", package_version)

    @_builtins.property
    @pulumi.getter
    def eulas(self) -> Sequence['outputs.GetPublicationsPublicationPackageDetailEulaResult']:
        return pulumi.get(self, "eulas")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Sequence['outputs.GetPublicationsPublicationPackageDetailOperatingSystemResult']:
        return pulumi.get(self, "operating_systems")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        The listing's package type.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> _builtins.str:
        return pulumi.get(self, "package_version")


@pulumi.output_type
class GetPublicationsPublicationPackageDetailEulaResult(dict):
    def __init__(__self__, *,
                 eula_type: _builtins.str,
                 license_text: _builtins.str):
        pulumi.set(__self__, "eula_type", eula_type)
        pulumi.set(__self__, "license_text", license_text)

    @_builtins.property
    @pulumi.getter(name="eulaType")
    def eula_type(self) -> _builtins.str:
        return pulumi.get(self, "eula_type")

    @_builtins.property
    @pulumi.getter(name="licenseText")
    def license_text(self) -> _builtins.str:
        return pulumi.get(self, "license_text")


@pulumi.output_type
class GetPublicationsPublicationPackageDetailOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the publication.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublicationsPublicationSupportContactResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 name: _builtins.str,
                 phone: _builtins.str,
                 subject: _builtins.str):
        """
        :param _builtins.str email: The email of the contact.
        :param _builtins.str name: The name of the publication.
        :param _builtins.str phone: The phone number of the contact.
        :param _builtins.str subject: The email subject line to use when contacting support.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phone(self) -> _builtins.str:
        """
        The phone number of the contact.
        """
        return pulumi.get(self, "phone")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The email subject line to use when contacting support.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class GetPublicationsPublicationSupportedOperatingSystemResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the publication.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publication.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPublishersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the publisher.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publisher.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPublishersPublisherResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: A description of the publisher.
        :param _builtins.str id: The unique identifier for the publisher.
        :param _builtins.str name: The name of the publisher.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the publisher.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier for the publisher.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the publisher.
        """
        return pulumi.get(self, "name")


