# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlBackupArgs', 'MysqlBackup']

@pulumi.input_type
class MysqlBackupArgs:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_snapshot_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_data: Optional[pulumi.Input['MysqlBackupEncryptDataArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']] = None,
                 validate_backup_details: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]] = None,
                 validate_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MysqlBackup resource.
        :param pulumi.Input[_builtins.str] backup_type: The type of backup.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the Backup is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-supplied description for the backup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input['MysqlBackupEncryptDataArgs'] encrypt_data: Encrypt data details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] retention_in_days: (Updatable) Number of days to retain this backup.
        :param pulumi.Input[_builtins.str] soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param pulumi.Input['MysqlBackupSourceDetailsArgs'] source_details: Details of backup source in the cloud.
        :param pulumi.Input[_builtins.int] validate_trigger: (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
               * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_system_snapshot_summaries is not None:
            pulumi.set(__self__, "db_system_snapshot_summaries", db_system_snapshot_summaries)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypt_data is not None:
            pulumi.set(__self__, "encrypt_data", encrypt_data)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if validate_backup_details is not None:
            pulumi.set(__self__, "validate_backup_details", validate_backup_details)
        if validate_trigger is not None:
            pulumi.set(__self__, "validate_trigger", validate_trigger)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of backup.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DB System the Backup is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshotSummaries")
    def db_system_snapshot_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]]:
        return pulumi.get(self, "db_system_snapshot_summaries")

    @db_system_snapshot_summaries.setter
    def db_system_snapshot_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]]):
        pulumi.set(self, "db_system_snapshot_summaries", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> Optional[pulumi.Input['MysqlBackupEncryptDataArgs']]:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_data")

    @encrypt_data.setter
    def encrypt_data(self, value: Optional[pulumi.Input['MysqlBackupEncryptDataArgs']]):
        pulumi.set(self, "encrypt_data", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "soft_delete", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']]:
        """
        Details of backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter(name="validateBackupDetails")
    def validate_backup_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]]:
        return pulumi.get(self, "validate_backup_details")

    @validate_backup_details.setter
    def validate_backup_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]]):
        pulumi.set(self, "validate_backup_details", value)

    @_builtins.property
    @pulumi.getter(name="validateTrigger")
    def validate_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
        * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        return pulumi.get(self, "validate_trigger")

    @validate_trigger.setter
    def validate_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validate_trigger", value)


@pulumi.input_type
class _MysqlBackupState:
    def __init__(__self__, *,
                 backup_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_validation_details: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupBackupValidationDetailArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_snapshot_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]] = None,
                 db_system_snapshots: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_data: Optional[pulumi.Input['MysqlBackupEncryptDataArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 immediate_source_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.str]] = None,
                 original_source_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 shape_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_copy_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_backup_details: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]] = None,
                 validate_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MysqlBackup resources.
        :param pulumi.Input[_builtins.int] backup_size_in_gbs: The size of the backup in base-2 (IEC) gibibytes. (GiB).
        :param pulumi.Input[_builtins.str] backup_type: The type of backup.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupBackupValidationDetailArgs']]] backup_validation_details: Backup validation details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[_builtins.str] creation_type: Indicates how the backup was created: manually, automatic, or by an Operator.
        :param pulumi.Input[_builtins.int] data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the Backup is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotArgs']]] db_system_snapshots: Snapshot of the DbSystem details at the time of the backup
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-supplied description for the backup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input['MysqlBackupEncryptDataArgs'] encrypt_data: Encrypt data details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] immediate_source_backup_id: The OCID of the immediate source DB system backup from which this DB system backup was copied.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[_builtins.str] mysql_version: The MySQL server version of the DB System used for backup.
        :param pulumi.Input[_builtins.str] original_source_backup_id: The OCID of the original source DB system backup from which this DB system backup was copied.
        :param pulumi.Input[_builtins.int] retention_in_days: (Updatable) Number of days to retain this backup.
        :param pulumi.Input[_builtins.str] shape_name: The shape of the DB System instance used for backup.
        :param pulumi.Input[_builtins.str] soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param pulumi.Input['MysqlBackupSourceDetailsArgs'] source_details: Details of backup source in the cloud.
        :param pulumi.Input[_builtins.str] state: The state of the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_copy_created: The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_created: The time the backup record was created.
        :param pulumi.Input[_builtins.str] time_updated: The time at which the backup was updated.
        :param pulumi.Input[_builtins.int] validate_trigger: (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
               * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        if backup_size_in_gbs is not None:
            pulumi.set(__self__, "backup_size_in_gbs", backup_size_in_gbs)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if backup_validation_details is not None:
            pulumi.set(__self__, "backup_validation_details", backup_validation_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if creation_type is not None:
            pulumi.set(__self__, "creation_type", creation_type)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_system_snapshot_summaries is not None:
            pulumi.set(__self__, "db_system_snapshot_summaries", db_system_snapshot_summaries)
        if db_system_snapshots is not None:
            pulumi.set(__self__, "db_system_snapshots", db_system_snapshots)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypt_data is not None:
            pulumi.set(__self__, "encrypt_data", encrypt_data)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if immediate_source_backup_id is not None:
            pulumi.set(__self__, "immediate_source_backup_id", immediate_source_backup_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if original_source_backup_id is not None:
            pulumi.set(__self__, "original_source_backup_id", original_source_backup_id)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_copy_created is not None:
            pulumi.set(__self__, "time_copy_created", time_copy_created)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if validate_backup_details is not None:
            pulumi.set(__self__, "validate_backup_details", validate_backup_details)
        if validate_trigger is not None:
            pulumi.set(__self__, "validate_trigger", validate_trigger)

    @_builtins.property
    @pulumi.getter(name="backupSizeInGbs")
    def backup_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the backup in base-2 (IEC) gibibytes. (GiB).
        """
        return pulumi.get(self, "backup_size_in_gbs")

    @backup_size_in_gbs.setter
    def backup_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of backup.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="backupValidationDetails")
    def backup_validation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupBackupValidationDetailArgs']]]]:
        """
        Backup validation details.
        """
        return pulumi.get(self, "backup_validation_details")

    @backup_validation_details.setter
    def backup_validation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupBackupValidationDetailArgs']]]]):
        pulumi.set(self, "backup_validation_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates how the backup was created: manually, automatic, or by an Operator.
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_type", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DB System the Backup is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshotSummaries")
    def db_system_snapshot_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]]:
        return pulumi.get(self, "db_system_snapshot_summaries")

    @db_system_snapshot_summaries.setter
    def db_system_snapshot_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotSummaryArgs']]]]):
        pulumi.set(self, "db_system_snapshot_summaries", value)

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshots")
    def db_system_snapshots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotArgs']]]]:
        """
        Snapshot of the DbSystem details at the time of the backup
        """
        return pulumi.get(self, "db_system_snapshots")

    @db_system_snapshots.setter
    def db_system_snapshots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupDbSystemSnapshotArgs']]]]):
        pulumi.set(self, "db_system_snapshots", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> Optional[pulumi.Input['MysqlBackupEncryptDataArgs']]:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_data")

    @encrypt_data.setter
    def encrypt_data(self, value: Optional[pulumi.Input['MysqlBackupEncryptDataArgs']]):
        pulumi.set(self, "encrypt_data", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="immediateSourceBackupId")
    def immediate_source_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the immediate source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "immediate_source_backup_id")

    @immediate_source_backup_id.setter
    def immediate_source_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immediate_source_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mysql_version", value)

    @_builtins.property
    @pulumi.getter(name="originalSourceBackupId")
    def original_source_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the original source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "original_source_backup_id")

    @original_source_backup_id.setter
    def original_source_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "original_source_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @soft_delete.setter
    def soft_delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "soft_delete", value)

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']]:
        """
        Details of backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['MysqlBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCopyCreated")
    def time_copy_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_copy_created")

    @time_copy_created.setter
    def time_copy_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_copy_created", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the backup record was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the backup was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="validateBackupDetails")
    def validate_backup_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]]:
        return pulumi.get(self, "validate_backup_details")

    @validate_backup_details.setter
    def validate_backup_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlBackupValidateBackupDetailArgs']]]]):
        pulumi.set(self, "validate_backup_details", value)

    @_builtins.property
    @pulumi.getter(name="validateTrigger")
    def validate_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
        * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        return pulumi.get(self, "validate_trigger")

    @validate_trigger.setter
    def validate_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "validate_trigger", value)


@pulumi.type_token("oci:Mysql/mysqlBackup:MysqlBackup")
class MysqlBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_snapshot_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupDbSystemSnapshotSummaryArgs', 'MysqlBackupDbSystemSnapshotSummaryArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_data: Optional[pulumi.Input[Union['MysqlBackupEncryptDataArgs', 'MysqlBackupEncryptDataArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input[Union['MysqlBackupSourceDetailsArgs', 'MysqlBackupSourceDetailsArgsDict']]] = None,
                 validate_backup_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupValidateBackupDetailArgs', 'MysqlBackupValidateBackupDetailArgsDict']]]]] = None,
                 validate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_backup = oci.mysql.MysqlBackup("test_mysql_backup",
            db_system_id=test_db_system["id"],
            backup_type=mysql_backup_backup_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=mysql_backup_description,
            display_name=mysql_backup_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            retention_in_days=mysql_backup_retention_in_days,
            soft_delete=mysql_backup_soft_delete)
        ```

        ## Import

        MysqlBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/mysqlBackup:MysqlBackup test_mysql_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: The type of backup.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the Backup is associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-supplied description for the backup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input[Union['MysqlBackupEncryptDataArgs', 'MysqlBackupEncryptDataArgsDict']] encrypt_data: Encrypt data details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] retention_in_days: (Updatable) Number of days to retain this backup.
        :param pulumi.Input[_builtins.str] soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param pulumi.Input[Union['MysqlBackupSourceDetailsArgs', 'MysqlBackupSourceDetailsArgsDict']] source_details: Details of backup source in the cloud.
        :param pulumi.Input[_builtins.int] validate_trigger: (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
               * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MysqlBackupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_backup = oci.mysql.MysqlBackup("test_mysql_backup",
            db_system_id=test_db_system["id"],
            backup_type=mysql_backup_backup_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=mysql_backup_description,
            display_name=mysql_backup_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            retention_in_days=mysql_backup_retention_in_days,
            soft_delete=mysql_backup_soft_delete)
        ```

        ## Import

        MysqlBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/mysqlBackup:MysqlBackup test_mysql_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param MysqlBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_system_snapshot_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupDbSystemSnapshotSummaryArgs', 'MysqlBackupDbSystemSnapshotSummaryArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_data: Optional[pulumi.Input[Union['MysqlBackupEncryptDataArgs', 'MysqlBackupEncryptDataArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
                 source_details: Optional[pulumi.Input[Union['MysqlBackupSourceDetailsArgs', 'MysqlBackupSourceDetailsArgsDict']]] = None,
                 validate_backup_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupValidateBackupDetailArgs', 'MysqlBackupValidateBackupDetailArgsDict']]]]] = None,
                 validate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlBackupArgs.__new__(MysqlBackupArgs)

            __props__.__dict__["backup_type"] = backup_type
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["db_system_snapshot_summaries"] = db_system_snapshot_summaries
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encrypt_data"] = encrypt_data
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["retention_in_days"] = retention_in_days
            __props__.__dict__["soft_delete"] = soft_delete
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["validate_backup_details"] = validate_backup_details
            __props__.__dict__["validate_trigger"] = validate_trigger
            __props__.__dict__["backup_size_in_gbs"] = None
            __props__.__dict__["backup_validation_details"] = None
            __props__.__dict__["creation_type"] = None
            __props__.__dict__["data_storage_size_in_gb"] = None
            __props__.__dict__["db_system_snapshots"] = None
            __props__.__dict__["immediate_source_backup_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["mysql_version"] = None
            __props__.__dict__["original_source_backup_id"] = None
            __props__.__dict__["shape_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_copy_created"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MysqlBackup, __self__).__init__(
            'oci:Mysql/mysqlBackup:MysqlBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            backup_validation_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupBackupValidationDetailArgs', 'MysqlBackupBackupValidationDetailArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            creation_type: Optional[pulumi.Input[_builtins.str]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_system_snapshot_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupDbSystemSnapshotSummaryArgs', 'MysqlBackupDbSystemSnapshotSummaryArgsDict']]]]] = None,
            db_system_snapshots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupDbSystemSnapshotArgs', 'MysqlBackupDbSystemSnapshotArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_data: Optional[pulumi.Input[Union['MysqlBackupEncryptDataArgs', 'MysqlBackupEncryptDataArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            immediate_source_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            mysql_version: Optional[pulumi.Input[_builtins.str]] = None,
            original_source_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            shape_name: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete: Optional[pulumi.Input[_builtins.str]] = None,
            source_details: Optional[pulumi.Input[Union['MysqlBackupSourceDetailsArgs', 'MysqlBackupSourceDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_copy_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            validate_backup_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupValidateBackupDetailArgs', 'MysqlBackupValidateBackupDetailArgsDict']]]]] = None,
            validate_trigger: Optional[pulumi.Input[_builtins.int]] = None) -> 'MysqlBackup':
        """
        Get an existing MysqlBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] backup_size_in_gbs: The size of the backup in base-2 (IEC) gibibytes. (GiB).
        :param pulumi.Input[_builtins.str] backup_type: The type of backup.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupBackupValidationDetailArgs', 'MysqlBackupBackupValidationDetailArgsDict']]]] backup_validation_details: Backup validation details.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param pulumi.Input[_builtins.str] creation_type: Indicates how the backup was created: manually, automatic, or by an Operator.
        :param pulumi.Input[_builtins.int] data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param pulumi.Input[_builtins.str] db_system_id: The OCID of the DB System the Backup is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlBackupDbSystemSnapshotArgs', 'MysqlBackupDbSystemSnapshotArgsDict']]]] db_system_snapshots: Snapshot of the DbSystem details at the time of the backup
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-supplied description for the backup.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-supplied display name for the backup.
        :param pulumi.Input[Union['MysqlBackupEncryptDataArgs', 'MysqlBackupEncryptDataArgsDict']] encrypt_data: Encrypt data details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] immediate_source_backup_id: The OCID of the immediate source DB system backup from which this DB system backup was copied.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[_builtins.str] mysql_version: The MySQL server version of the DB System used for backup.
        :param pulumi.Input[_builtins.str] original_source_backup_id: The OCID of the original source DB system backup from which this DB system backup was copied.
        :param pulumi.Input[_builtins.int] retention_in_days: (Updatable) Number of days to retain this backup.
        :param pulumi.Input[_builtins.str] shape_name: The shape of the DB System instance used for backup.
        :param pulumi.Input[_builtins.str] soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param pulumi.Input[Union['MysqlBackupSourceDetailsArgs', 'MysqlBackupSourceDetailsArgsDict']] source_details: Details of backup source in the cloud.
        :param pulumi.Input[_builtins.str] state: The state of the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_copy_created: The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[_builtins.str] time_created: The time the backup record was created.
        :param pulumi.Input[_builtins.str] time_updated: The time at which the backup was updated.
        :param pulumi.Input[_builtins.int] validate_trigger: (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
               * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlBackupState.__new__(_MysqlBackupState)

        __props__.__dict__["backup_size_in_gbs"] = backup_size_in_gbs
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["backup_validation_details"] = backup_validation_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["creation_type"] = creation_type
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["db_system_snapshot_summaries"] = db_system_snapshot_summaries
        __props__.__dict__["db_system_snapshots"] = db_system_snapshots
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encrypt_data"] = encrypt_data
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["immediate_source_backup_id"] = immediate_source_backup_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["mysql_version"] = mysql_version
        __props__.__dict__["original_source_backup_id"] = original_source_backup_id
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["soft_delete"] = soft_delete
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_copy_created"] = time_copy_created
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["validate_backup_details"] = validate_backup_details
        __props__.__dict__["validate_trigger"] = validate_trigger
        return MysqlBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupSizeInGbs")
    def backup_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the backup in base-2 (IEC) gibibytes. (GiB).
        """
        return pulumi.get(self, "backup_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of backup.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="backupValidationDetails")
    def backup_validation_details(self) -> pulumi.Output[Sequence['outputs.MysqlBackupBackupValidationDetail']]:
        """
        Backup validation details.
        """
        return pulumi.get(self, "backup_validation_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates how the backup was created: manually, automatic, or by an Operator.
        """
        return pulumi.get(self, "creation_type")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DB System the Backup is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshotSummaries")
    def db_system_snapshot_summaries(self) -> pulumi.Output[Sequence['outputs.MysqlBackupDbSystemSnapshotSummary']]:
        return pulumi.get(self, "db_system_snapshot_summaries")

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshots")
    def db_system_snapshots(self) -> pulumi.Output[Sequence['outputs.MysqlBackupDbSystemSnapshot']]:
        """
        Snapshot of the DbSystem details at the time of the backup
        """
        return pulumi.get(self, "db_system_snapshots")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptData")
    def encrypt_data(self) -> pulumi.Output['outputs.MysqlBackupEncryptData']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_data")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="immediateSourceBackupId")
    def immediate_source_backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the immediate source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "immediate_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> pulumi.Output[_builtins.str]:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="originalSourceBackupId")
    def original_source_backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the original source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "original_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[_builtins.str]:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output[Optional['outputs.MysqlBackupSourceDetails']]:
        """
        Details of backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the backup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCopyCreated")
    def time_copy_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_copy_created")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the backup record was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the backup was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="validateBackupDetails")
    def validate_backup_details(self) -> pulumi.Output[Optional[Sequence['outputs.MysqlBackupValidateBackupDetail']]]:
        return pulumi.get(self, "validate_backup_details")

    @_builtins.property
    @pulumi.getter(name="validateTrigger")
    def validate_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional integer property when incremented will trigger a validation of the backup. Set the integer to 1 initially and increment it by 1 to re-trigger validation.
        * `validate-backup-details` - Details required to validate backup. **Note:** Validate action can only be called from update resource operation.
        """
        return pulumi.get(self, "validate_trigger")

