# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ChannelSource',
    'ChannelSourceAnonymousTransactionsHandling',
    'ChannelSourceSslCaCertificate',
    'ChannelTarget',
    'ChannelTargetFilter',
    'HeatWaveClusterClusterNode',
    'MysqlBackupBackupValidationDetail',
    'MysqlBackupBackupValidationDetailPreparedBackupDetail',
    'MysqlBackupDbSystemSnapshot',
    'MysqlBackupDbSystemSnapshotBackupPolicy',
    'MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy',
    'MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy',
    'MysqlBackupDbSystemSnapshotDataStorage',
    'MysqlBackupDbSystemSnapshotDeletionPolicy',
    'MysqlBackupDbSystemSnapshotEncryptData',
    'MysqlBackupDbSystemSnapshotEndpoint',
    'MysqlBackupDbSystemSnapshotMaintenance',
    'MysqlBackupDbSystemSnapshotReadEndpoint',
    'MysqlBackupDbSystemSnapshotRest',
    'MysqlBackupDbSystemSnapshotSecureConnection',
    'MysqlBackupDbSystemSnapshotSummary',
    'MysqlBackupEncryptData',
    'MysqlBackupSourceDetails',
    'MysqlBackupValidateBackupDetail',
    'MysqlConfigurationInitVariables',
    'MysqlConfigurationVariables',
    'MysqlDbSystemBackupPolicy',
    'MysqlDbSystemBackupPolicyCopyPolicy',
    'MysqlDbSystemBackupPolicyPitrPolicy',
    'MysqlDbSystemChannel',
    'MysqlDbSystemChannelSource',
    'MysqlDbSystemChannelSourceAnonymousTransactionsHandling',
    'MysqlDbSystemChannelSourceSslCaCertificate',
    'MysqlDbSystemChannelTarget',
    'MysqlDbSystemChannelTargetFilter',
    'MysqlDbSystemCurrentPlacement',
    'MysqlDbSystemCustomerContact',
    'MysqlDbSystemDataStorage',
    'MysqlDbSystemDeletionPolicy',
    'MysqlDbSystemEncryptData',
    'MysqlDbSystemEndpoint',
    'MysqlDbSystemHeatWaveCluster',
    'MysqlDbSystemMaintenance',
    'MysqlDbSystemPointInTimeRecoveryDetail',
    'MysqlDbSystemReadEndpoint',
    'MysqlDbSystemRest',
    'MysqlDbSystemSecureConnections',
    'MysqlDbSystemSource',
    'ReplicaEncryptData',
    'ReplicaReplicaOverrides',
    'ReplicaSecureConnection',
    'GetChannelSourceResult',
    'GetChannelSourceAnonymousTransactionsHandlingResult',
    'GetChannelSourceSslCaCertificateResult',
    'GetChannelTargetResult',
    'GetChannelTargetFilterResult',
    'GetChannelsChannelResult',
    'GetChannelsChannelSourceResult',
    'GetChannelsChannelSourceAnonymousTransactionsHandlingResult',
    'GetChannelsChannelSourceSslCaCertificateResult',
    'GetChannelsChannelTargetResult',
    'GetChannelsChannelTargetFilterResult',
    'GetChannelsFilterResult',
    'GetHeatWaveClusterClusterNodeResult',
    'GetMysqlBackupBackupValidationDetailResult',
    'GetMysqlBackupBackupValidationDetailPreparedBackupDetailResult',
    'GetMysqlBackupDbSystemSnapshotResult',
    'GetMysqlBackupDbSystemSnapshotBackupPolicyResult',
    'GetMysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyResult',
    'GetMysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyResult',
    'GetMysqlBackupDbSystemSnapshotDataStorageResult',
    'GetMysqlBackupDbSystemSnapshotDeletionPolicyResult',
    'GetMysqlBackupDbSystemSnapshotEncryptDataResult',
    'GetMysqlBackupDbSystemSnapshotEndpointResult',
    'GetMysqlBackupDbSystemSnapshotMaintenanceResult',
    'GetMysqlBackupDbSystemSnapshotReadEndpointResult',
    'GetMysqlBackupDbSystemSnapshotRestResult',
    'GetMysqlBackupDbSystemSnapshotSecureConnectionResult',
    'GetMysqlBackupDbSystemSnapshotSummaryResult',
    'GetMysqlBackupEncryptDataResult',
    'GetMysqlBackupSourceDetailResult',
    'GetMysqlBackupValidateBackupDetailResult',
    'GetMysqlBackupsBackupResult',
    'GetMysqlBackupsBackupDbSystemSnapshotSummaryResult',
    'GetMysqlBackupsBackupEncryptDataResult',
    'GetMysqlBackupsFilterResult',
    'GetMysqlConfigurationInitVariableResult',
    'GetMysqlConfigurationVariableResult',
    'GetMysqlConfigurationsConfigurationResult',
    'GetMysqlConfigurationsConfigurationInitVariableResult',
    'GetMysqlConfigurationsConfigurationVariableResult',
    'GetMysqlConfigurationsFilterResult',
    'GetMysqlDbSystemBackupPolicyResult',
    'GetMysqlDbSystemBackupPolicyCopyPolicyResult',
    'GetMysqlDbSystemBackupPolicyPitrPolicyResult',
    'GetMysqlDbSystemChannelResult',
    'GetMysqlDbSystemChannelSourceResult',
    'GetMysqlDbSystemChannelSourceAnonymousTransactionsHandlingResult',
    'GetMysqlDbSystemChannelSourceSslCaCertificateResult',
    'GetMysqlDbSystemChannelTargetResult',
    'GetMysqlDbSystemChannelTargetFilterResult',
    'GetMysqlDbSystemCurrentPlacementResult',
    'GetMysqlDbSystemCustomerContactResult',
    'GetMysqlDbSystemDataStorageResult',
    'GetMysqlDbSystemDeletionPolicyResult',
    'GetMysqlDbSystemEncryptDataResult',
    'GetMysqlDbSystemEndpointResult',
    'GetMysqlDbSystemHeatWaveClusterResult',
    'GetMysqlDbSystemMaintenanceResult',
    'GetMysqlDbSystemPointInTimeRecoveryDetailResult',
    'GetMysqlDbSystemReadEndpointResult',
    'GetMysqlDbSystemRestResult',
    'GetMysqlDbSystemSecureConnectionResult',
    'GetMysqlDbSystemSourceResult',
    'GetMysqlDbSystemsDbSystemResult',
    'GetMysqlDbSystemsDbSystemBackupPolicyResult',
    'GetMysqlDbSystemsDbSystemBackupPolicyCopyPolicyResult',
    'GetMysqlDbSystemsDbSystemBackupPolicyPitrPolicyResult',
    'GetMysqlDbSystemsDbSystemChannelResult',
    'GetMysqlDbSystemsDbSystemChannelSourceResult',
    'GetMysqlDbSystemsDbSystemChannelSourceAnonymousTransactionsHandlingResult',
    'GetMysqlDbSystemsDbSystemChannelSourceSslCaCertificateResult',
    'GetMysqlDbSystemsDbSystemChannelTargetResult',
    'GetMysqlDbSystemsDbSystemChannelTargetFilterResult',
    'GetMysqlDbSystemsDbSystemCurrentPlacementResult',
    'GetMysqlDbSystemsDbSystemCustomerContactResult',
    'GetMysqlDbSystemsDbSystemDataStorageResult',
    'GetMysqlDbSystemsDbSystemDeletionPolicyResult',
    'GetMysqlDbSystemsDbSystemEncryptDataResult',
    'GetMysqlDbSystemsDbSystemEndpointResult',
    'GetMysqlDbSystemsDbSystemHeatWaveClusterResult',
    'GetMysqlDbSystemsDbSystemMaintenanceResult',
    'GetMysqlDbSystemsDbSystemPointInTimeRecoveryDetailResult',
    'GetMysqlDbSystemsDbSystemReadEndpointResult',
    'GetMysqlDbSystemsDbSystemRestResult',
    'GetMysqlDbSystemsDbSystemSecureConnectionResult',
    'GetMysqlDbSystemsDbSystemSourceResult',
    'GetMysqlDbSystemsFilterResult',
    'GetMysqlVersionFilterResult',
    'GetMysqlVersionVersionResult',
    'GetMysqlVersionVersionVersionResult',
    'GetReplicaEncryptDataResult',
    'GetReplicaReplicaOverrideResult',
    'GetReplicaSecureConnectionResult',
    'GetReplicasFilterResult',
    'GetReplicasReplicaResult',
    'GetReplicasReplicaEncryptDataResult',
    'GetReplicasReplicaReplicaOverrideResult',
    'GetReplicasReplicaSecureConnectionResult',
    'GetShapesFilterResult',
    'GetShapesShapeResult',
]

@pulumi.output_type
class ChannelSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "anonymousTransactionsHandling":
            suggest = "anonymous_transactions_handling"
        elif key == "sslCaCertificate":
            suggest = "ssl_ca_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: _builtins.str,
                 password: _builtins.str,
                 source_type: _builtins.str,
                 ssl_mode: _builtins.str,
                 username: _builtins.str,
                 anonymous_transactions_handling: Optional['outputs.ChannelSourceAnonymousTransactionsHandling'] = None,
                 port: Optional[_builtins.int] = None,
                 ssl_ca_certificate: Optional['outputs.ChannelSourceSslCaCertificate'] = None):
        """
        :param _builtins.str hostname: (Updatable) The network address of the MySQL instance.
        :param _builtins.str password: (Updatable) The password for the replication user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param _builtins.str source_type: (Updatable) The specific source identifier.
        :param _builtins.str ssl_mode: (Updatable) The SSL mode of the Channel.
        :param _builtins.str username: (Updatable) The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        :param 'ChannelSourceAnonymousTransactionsHandlingArgs' anonymous_transactions_handling: (Updatable) Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.int port: (Updatable) The port the source MySQL instance listens on.
        :param 'ChannelSourceSslCaCertificateArgs' ssl_ca_certificate: (Updatable) The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)
        if anonymous_transactions_handling is not None:
            pulumi.set(__self__, "anonymous_transactions_handling", anonymous_transactions_handling)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_ca_certificate is not None:
            pulumi.set(__self__, "ssl_ca_certificate", ssl_ca_certificate)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        (Updatable) The network address of the MySQL instance.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        (Updatable) The password for the replication user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        (Updatable) The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        (Updatable) The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        (Updatable) The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandling")
    def anonymous_transactions_handling(self) -> Optional['outputs.ChannelSourceAnonymousTransactionsHandling']:
        """
        (Updatable) Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handling")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The port the source MySQL instance listens on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificate")
    def ssl_ca_certificate(self) -> Optional['outputs.ChannelSourceSslCaCertificate']:
        """
        (Updatable) The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificate")


@pulumi.output_type
class ChannelSourceAnonymousTransactionsHandling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastConfiguredLogFilename":
            suggest = "last_configured_log_filename"
        elif key == "lastConfiguredLogOffset":
            suggest = "last_configured_log_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelSourceAnonymousTransactionsHandling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelSourceAnonymousTransactionsHandling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelSourceAnonymousTransactionsHandling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy: _builtins.str,
                 last_configured_log_filename: Optional[_builtins.str] = None,
                 last_configured_log_offset: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str policy: (Updatable) Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str last_configured_log_filename: (Updatable) Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: (Updatable) Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str uuid: (Updatable) The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "policy", policy)
        if last_configured_log_filename is not None:
            pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        if last_configured_log_offset is not None:
            pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        (Updatable) Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> Optional[_builtins.str]:
        """
        (Updatable) Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> Optional[_builtins.str]:
        """
        (Updatable) Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        (Updatable) The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ChannelSourceSslCaCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelSourceSslCaCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelSourceSslCaCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelSourceSslCaCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: _builtins.str,
                 contents: _builtins.str):
        """
        :param _builtins.str certificate_type: (Updatable) The type of CA certificate.
        :param _builtins.str contents: (Updatable) The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> _builtins.str:
        """
        (Updatable) The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        (Updatable) The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class ChannelTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbSystemId":
            suggest = "db_system_id"
        elif key == "targetType":
            suggest = "target_type"
        elif key == "applierUsername":
            suggest = "applier_username"
        elif key == "channelName":
            suggest = "channel_name"
        elif key == "delayInSeconds":
            suggest = "delay_in_seconds"
        elif key == "tablesWithoutPrimaryKeyHandling":
            suggest = "tables_without_primary_key_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_system_id: _builtins.str,
                 target_type: _builtins.str,
                 applier_username: Optional[_builtins.str] = None,
                 channel_name: Optional[_builtins.str] = None,
                 delay_in_seconds: Optional[_builtins.int] = None,
                 filters: Optional[Sequence['outputs.ChannelTargetFilter']] = None,
                 tables_without_primary_key_handling: Optional[_builtins.str] = None):
        """
        :param _builtins.str db_system_id: The OCID of the target DB System.
        :param _builtins.str target_type: (Updatable) The specific target identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param _builtins.str applier_username: (Updatable) The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: (Updatable) The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.int delay_in_seconds: (Updatable) Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['ChannelTargetFilterArgs'] filters: (Updatable) Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: (Updatable) Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key. The default value is set to ALLOW.
        """
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "target_type", target_type)
        if applier_username is not None:
            pulumi.set(__self__, "applier_username", applier_username)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if delay_in_seconds is not None:
            pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if tables_without_primary_key_handling is not None:
            pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the target DB System.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        (Updatable) The specific target identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> Optional[_builtins.str]:
        """
        (Updatable) The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> Optional[_builtins.int]:
        """
        (Updatable) Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.ChannelTargetFilter']]:
        """
        (Updatable) Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> Optional[_builtins.str]:
        """
        (Updatable) Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key. The default value is set to ALLOW.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")


@pulumi.output_type
class ChannelTargetFilter(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: (Updatable) The type of the filter rule.
               
               For details on each type, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html)
        :param _builtins.str value: (Updatable) The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (Updatable) The type of the filter rule.

        For details on each type, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        (Updatable) The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HeatWaveClusterClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeatWaveClusterClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeatWaveClusterClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeatWaveClusterClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_id: The ID of the node within MySQL HeatWave cluster.
        :param _builtins.str state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param _builtins.str time_created: The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_updated: The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the node within MySQL HeatWave cluster.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[_builtins.str]:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class MysqlBackupBackupValidationDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPreparationStatus":
            suggest = "backup_preparation_status"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "estimatedRestoreDuration":
            suggest = "estimated_restore_duration"
        elif key == "preparedBackupDetails":
            suggest = "prepared_backup_details"
        elif key == "timeLastValidated":
            suggest = "time_last_validated"
        elif key == "validationStatus":
            suggest = "validation_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupBackupValidationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupBackupValidationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupBackupValidationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_preparation_status: Optional[_builtins.str] = None,
                 error_message: Optional[_builtins.str] = None,
                 estimated_restore_duration: Optional[_builtins.str] = None,
                 prepared_backup_details: Optional[Sequence['outputs.MysqlBackupBackupValidationDetailPreparedBackupDetail']] = None,
                 time_last_validated: Optional[_builtins.str] = None,
                 validation_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str backup_preparation_status: Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        :param _builtins.str error_message: Error message if the backup validation has failed.
        :param _builtins.str estimated_restore_duration: The estimated restore duration of the backup.
        :param Sequence['MysqlBackupBackupValidationDetailPreparedBackupDetailArgs'] prepared_backup_details: Prepared backup details.
        :param _builtins.str time_last_validated: The date and time of the most recent validation performed on the backup.
        :param _builtins.str validation_status: The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        if backup_preparation_status is not None:
            pulumi.set(__self__, "backup_preparation_status", backup_preparation_status)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if estimated_restore_duration is not None:
            pulumi.set(__self__, "estimated_restore_duration", estimated_restore_duration)
        if prepared_backup_details is not None:
            pulumi.set(__self__, "prepared_backup_details", prepared_backup_details)
        if time_last_validated is not None:
            pulumi.set(__self__, "time_last_validated", time_last_validated)
        if validation_status is not None:
            pulumi.set(__self__, "validation_status", validation_status)

    @_builtins.property
    @pulumi.getter(name="backupPreparationStatus")
    def backup_preparation_status(self) -> Optional[_builtins.str]:
        """
        Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        """
        return pulumi.get(self, "backup_preparation_status")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[_builtins.str]:
        """
        Error message if the backup validation has failed.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="estimatedRestoreDuration")
    def estimated_restore_duration(self) -> Optional[_builtins.str]:
        """
        The estimated restore duration of the backup.
        """
        return pulumi.get(self, "estimated_restore_duration")

    @_builtins.property
    @pulumi.getter(name="preparedBackupDetails")
    def prepared_backup_details(self) -> Optional[Sequence['outputs.MysqlBackupBackupValidationDetailPreparedBackupDetail']]:
        """
        Prepared backup details.
        """
        return pulumi.get(self, "prepared_backup_details")

    @_builtins.property
    @pulumi.getter(name="timeLastValidated")
    def time_last_validated(self) -> Optional[_builtins.str]:
        """
        The date and time of the most recent validation performed on the backup.
        """
        return pulumi.get(self, "time_last_validated")

    @_builtins.property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> Optional[_builtins.str]:
        """
        The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        return pulumi.get(self, "validation_status")


@pulumi.output_type
class MysqlBackupBackupValidationDetailPreparedBackupDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preparedBackupRestoreReductionInMinutes":
            suggest = "prepared_backup_restore_reduction_in_minutes"
        elif key == "timePrepared":
            suggest = "time_prepared"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupBackupValidationDetailPreparedBackupDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupBackupValidationDetailPreparedBackupDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupBackupValidationDetailPreparedBackupDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prepared_backup_restore_reduction_in_minutes: Optional[_builtins.int] = None,
                 time_prepared: Optional[_builtins.str] = None):
        """
        :param _builtins.int prepared_backup_restore_reduction_in_minutes: The estimated time saving when this prepared backup is restored.
        :param _builtins.str time_prepared: The date and time the backup was prepared.
        """
        if prepared_backup_restore_reduction_in_minutes is not None:
            pulumi.set(__self__, "prepared_backup_restore_reduction_in_minutes", prepared_backup_restore_reduction_in_minutes)
        if time_prepared is not None:
            pulumi.set(__self__, "time_prepared", time_prepared)

    @_builtins.property
    @pulumi.getter(name="preparedBackupRestoreReductionInMinutes")
    def prepared_backup_restore_reduction_in_minutes(self) -> Optional[_builtins.int]:
        """
        The estimated time saving when this prepared backup is restored.
        """
        return pulumi.get(self, "prepared_backup_restore_reduction_in_minutes")

    @_builtins.property
    @pulumi.getter(name="timePrepared")
    def time_prepared(self) -> Optional[_builtins.str]:
        """
        The date and time the backup was prepared.
        """
        return pulumi.get(self, "time_prepared")


@pulumi.output_type
class MysqlBackupDbSystemSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "backupPolicies":
            suggest = "backup_policies"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "configurationId":
            suggest = "configuration_id"
        elif key == "crashRecovery":
            suggest = "crash_recovery"
        elif key == "dataStorageSizeInGb":
            suggest = "data_storage_size_in_gb"
        elif key == "dataStorages":
            suggest = "data_storages"
        elif key == "databaseManagement":
            suggest = "database_management"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "deletionPolicies":
            suggest = "deletion_policies"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "encryptDatas":
            suggest = "encrypt_datas"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "hostnameLabel":
            suggest = "hostname_label"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "isHighlyAvailable":
            suggest = "is_highly_available"
        elif key == "mysqlVersion":
            suggest = "mysql_version"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "portX":
            suggest = "port_x"
        elif key == "readEndpoints":
            suggest = "read_endpoints"
        elif key == "secureConnections":
            suggest = "secure_connections"
        elif key == "securityAttributes":
            suggest = "security_attributes"
        elif key == "shapeName":
            suggest = "shape_name"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: Optional[_builtins.str] = None,
                 availability_domain: Optional[_builtins.str] = None,
                 backup_policies: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicy']] = None,
                 compartment_id: Optional[_builtins.str] = None,
                 configuration_id: Optional[_builtins.str] = None,
                 crash_recovery: Optional[_builtins.str] = None,
                 data_storage_size_in_gb: Optional[_builtins.int] = None,
                 data_storages: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotDataStorage']] = None,
                 database_management: Optional[_builtins.str] = None,
                 defined_tags: Optional[Mapping[str, _builtins.str]] = None,
                 deletion_policies: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotDeletionPolicy']] = None,
                 description: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 encrypt_datas: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotEncryptData']] = None,
                 endpoints: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotEndpoint']] = None,
                 fault_domain: Optional[_builtins.str] = None,
                 freeform_tags: Optional[Mapping[str, _builtins.str]] = None,
                 hostname_label: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 is_highly_available: Optional[_builtins.bool] = None,
                 maintenances: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotMaintenance']] = None,
                 mysql_version: Optional[_builtins.str] = None,
                 nsg_ids: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None,
                 port_x: Optional[_builtins.int] = None,
                 read_endpoints: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotReadEndpoint']] = None,
                 region: Optional[_builtins.str] = None,
                 rests: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotRest']] = None,
                 secure_connections: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotSecureConnection']] = None,
                 security_attributes: Optional[Mapping[str, _builtins.str]] = None,
                 shape_name: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str admin_username: The username for the administrative user.
        :param _builtins.str availability_domain: The Availability Domain where the primary DB System should be located.
        :param Sequence['MysqlBackupDbSystemSnapshotBackupPolicyArgs'] backup_policies: The Backup policy for the DB System.
        :param _builtins.str compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param _builtins.str configuration_id: The OCID of the Configuration to be used for Instances in this DB System.
        :param _builtins.str crash_recovery: Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param _builtins.int data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param Sequence['MysqlBackupDbSystemSnapshotDataStorageArgs'] data_storages: Data Storage information.
        :param _builtins.str database_management: Whether to enable monitoring via the Database Management service.
        :param Mapping[str, _builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['MysqlBackupDbSystemSnapshotDeletionPolicyArgs'] deletion_policies: The Deletion policy for the DB System.
        :param _builtins.str description: (Updatable) A user-supplied description for the backup.
        :param _builtins.str display_name: (Updatable) A user-supplied display name for the backup.
        :param Sequence['MysqlBackupDbSystemSnapshotEncryptDataArgs'] encrypt_datas: Encrypt data details.
        :param Sequence['MysqlBackupDbSystemSnapshotEndpointArgs'] endpoints: The network endpoints available for this DB System.
        :param _builtins.str fault_domain: The name of the Fault Domain the DB System is located in.
        :param Mapping[str, _builtins.str] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param _builtins.bool is_highly_available: Specifies if the DB System is highly available.
        :param Sequence['MysqlBackupDbSystemSnapshotMaintenanceArgs'] maintenances: The Maintenance Policy for the DB System or Read Replica that this model is included in.
        :param _builtins.str mysql_version: The MySQL server version of the DB System used for backup.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param Sequence['MysqlBackupDbSystemSnapshotReadEndpointArgs'] read_endpoints: The read endpoint of a DB System.
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        :param Sequence['MysqlBackupDbSystemSnapshotRestArgs'] rests: REST configuration details.
        :param Sequence['MysqlBackupDbSystemSnapshotSecureConnectionArgs'] secure_connections: Secure connection configuration details.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape of the DB System instance used for backup.
        :param _builtins.str subnet_id: The OCID of the subnet the DB System is associated with.
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if crash_recovery is not None:
            pulumi.set(__self__, "crash_recovery", crash_recovery)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storages is not None:
            pulumi.set(__self__, "data_storages", data_storages)
        if database_management is not None:
            pulumi.set(__self__, "database_management", database_management)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_policies is not None:
            pulumi.set(__self__, "deletion_policies", deletion_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encrypt_datas is not None:
            pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_highly_available is not None:
            pulumi.set(__self__, "is_highly_available", is_highly_available)
        if maintenances is not None:
            pulumi.set(__self__, "maintenances", maintenances)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if read_endpoints is not None:
            pulumi.set(__self__, "read_endpoints", read_endpoints)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rests is not None:
            pulumi.set(__self__, "rests", rests)
        if secure_connections is not None:
            pulumi.set(__self__, "secure_connections", secure_connections)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[_builtins.str]:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        The Availability Domain where the primary DB System should be located.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicy']]:
        """
        The Backup policy for the DB System.
        """
        return pulumi.get(self, "backup_policies")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> Optional[_builtins.str]:
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[_builtins.int]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorages")
    def data_storages(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotDataStorage']]:
        """
        Data Storage information.
        """
        return pulumi.get(self, "data_storages")

    @_builtins.property
    @pulumi.getter(name="databaseManagement")
    def database_management(self) -> Optional[_builtins.str]:
        """
        Whether to enable monitoring via the Database Management service.
        """
        return pulumi.get(self, "database_management")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotDeletionPolicy']]:
        """
        The Deletion policy for the DB System.
        """
        return pulumi.get(self, "deletion_policies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotEncryptData']]:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotEndpoint']]:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[_builtins.str]:
        """
        The name of the Fault Domain the DB System is located in.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[_builtins.str]:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> Optional[_builtins.bool]:
        """
        Specifies if the DB System is highly available.
        """
        return pulumi.get(self, "is_highly_available")

    @_builtins.property
    @pulumi.getter
    def maintenances(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotMaintenance']]:
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        return pulumi.get(self, "maintenances")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[_builtins.str]:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[_builtins.int]:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotReadEndpoint']]:
        """
        The read endpoint of a DB System.
        """
        return pulumi.get(self, "read_endpoints")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rests(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotRest']]:
        """
        REST configuration details.
        """
        return pulumi.get(self, "rests")

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotSecureConnection']]:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[_builtins.str]:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyPolicies":
            suggest = "copy_policies"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "pitrPolicies":
            suggest = "pitr_policies"
        elif key == "retentionInDays":
            suggest = "retention_in_days"
        elif key == "softDelete":
            suggest = "soft_delete"
        elif key == "windowStartTime":
            suggest = "window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_policies: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy']] = None,
                 defined_tags: Optional[Mapping[str, _builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, _builtins.str]] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 pitr_policies: Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy']] = None,
                 retention_in_days: Optional[_builtins.int] = None,
                 soft_delete: Optional[_builtins.str] = None,
                 window_start_time: Optional[_builtins.str] = None):
        """
        :param Sequence['MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs'] copy_policies: List of policies of a DB system to schedule cross-region DB system backup copy.
        :param Mapping[str, _builtins.str] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, _builtins.str] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param Sequence['MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs'] pitr_policies: The PITR policy for the DB System.
        :param _builtins.int retention_in_days: (Updatable) Number of days to retain this backup.
        :param _builtins.str soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        if copy_policies is not None:
            pulumi.set(__self__, "copy_policies", copy_policies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if pitr_policies is not None:
            pulumi.set(__self__, "pitr_policies", pitr_policies)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy']]:
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        return pulumi.get(self, "copy_policies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="pitrPolicies")
    def pitr_policies(self) -> Optional[Sequence['outputs.MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy']]:
        """
        The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policies")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[_builtins.str]:
        """
        (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[_builtins.str]:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupCopyRetentionInDays":
            suggest = "backup_copy_retention_in_days"
        elif key == "copyToRegion":
            suggest = "copy_to_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicyCopyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_copy_retention_in_days: Optional[_builtins.int] = None,
                 copy_to_region: Optional[_builtins.str] = None):
        """
        :param _builtins.int backup_copy_retention_in_days: Number of days to retain the copied DB system backup.
        :param _builtins.str copy_to_region: The destination region name to which the DB system backup will be copied.
        """
        if backup_copy_retention_in_days is not None:
            pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)
        if copy_to_region is not None:
            pulumi.set(__self__, "copy_to_region", copy_to_region)

    @_builtins.property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> Optional[_builtins.int]:
        """
        Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> Optional[_builtins.str]:
        """
        The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotBackupPolicyPitrPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotDataStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedStorageSizeInGbs":
            suggest = "allocated_storage_size_in_gbs"
        elif key == "dataStorageSizeInGb":
            suggest = "data_storage_size_in_gb"
        elif key == "dataStorageSizeLimitInGbs":
            suggest = "data_storage_size_limit_in_gbs"
        elif key == "isAutoExpandStorageEnabled":
            suggest = "is_auto_expand_storage_enabled"
        elif key == "maxStorageSizeInGbs":
            suggest = "max_storage_size_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotDataStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotDataStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotDataStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: Optional[_builtins.int] = None,
                 data_storage_size_in_gb: Optional[_builtins.int] = None,
                 data_storage_size_limit_in_gbs: Optional[_builtins.int] = None,
                 is_auto_expand_storage_enabled: Optional[_builtins.bool] = None,
                 max_storage_size_in_gbs: Optional[_builtins.int] = None):
        """
        :param _builtins.int allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param _builtins.int data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param _builtins.int data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param _builtins.bool is_auto_expand_storage_enabled: Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param _builtins.int max_storage_size_in_gbs: Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        if allocated_storage_size_in_gbs is not None:
            pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_limit_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        if is_auto_expand_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        if max_storage_size_in_gbs is not None:
            pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> Optional[_builtins.int]:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[_builtins.int]:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> Optional[_builtins.int]:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> Optional[_builtins.int]:
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotDeletionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticBackupRetention":
            suggest = "automatic_backup_retention"
        elif key == "finalBackup":
            suggest = "final_backup"
        elif key == "isDeleteProtected":
            suggest = "is_delete_protected"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotDeletionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotDeletionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotDeletionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_backup_retention: Optional[_builtins.str] = None,
                 final_backup: Optional[_builtins.str] = None,
                 is_delete_protected: Optional[_builtins.bool] = None):
        """
        :param _builtins.str automatic_backup_retention: Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param _builtins.str final_backup: Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param _builtins.bool is_delete_protected: Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        if automatic_backup_retention is not None:
            pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        if final_backup is not None:
            pulumi.set(__self__, "final_backup", final_backup)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @_builtins.property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> Optional[_builtins.str]:
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @_builtins.property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> Optional[_builtins.str]:
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotEncryptData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyGenerationType":
            suggest = "key_generation_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotEncryptData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotEncryptData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotEncryptData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_generation_type: Optional[_builtins.str] = None,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        if key_generation_type is not None:
            pulumi.set(__self__, "key_generation_type", key_generation_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> Optional[_builtins.str]:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "portX":
            suggest = "port_x"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "statusDetails":
            suggest = "status_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 modes: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None,
                 port_x: Optional[_builtins.int] = None,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 status_details: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param Sequence[_builtins.str] modes: The access modes from the client that this endpoint supports.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param _builtins.str resource_id: The OCID of the resource that this endpoint is attached to.
        :param _builtins.str resource_type: The type of endpoint that clients and connectors can connect to.
        :param _builtins.str status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param _builtins.str status_details: Additional information about the current endpoint status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[_builtins.int]:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[_builtins.str]:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotMaintenance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceScheduleType":
            suggest = "maintenance_schedule_type"
        elif key == "targetVersion":
            suggest = "target_version"
        elif key == "timeScheduled":
            suggest = "time_scheduled"
        elif key == "versionPreference":
            suggest = "version_preference"
        elif key == "versionTrackPreference":
            suggest = "version_track_preference"
        elif key == "windowStartTime":
            suggest = "window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotMaintenance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotMaintenance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotMaintenance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintenance_schedule_type: Optional[_builtins.str] = None,
                 target_version: Optional[_builtins.str] = None,
                 time_scheduled: Optional[_builtins.str] = None,
                 version_preference: Optional[_builtins.str] = None,
                 version_track_preference: Optional[_builtins.str] = None,
                 window_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str maintenance_schedule_type: The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        :param _builtins.str target_version: The version that is expected to be targeted during the next scheduled maintenance run.
        :param _builtins.str time_scheduled: The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str version_preference: The preferred version to target when performing an automatic MySQL upgrade.
        :param _builtins.str version_track_preference: The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        if maintenance_schedule_type is not None:
            pulumi.set(__self__, "maintenance_schedule_type", maintenance_schedule_type)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if time_scheduled is not None:
            pulumi.set(__self__, "time_scheduled", time_scheduled)
        if version_preference is not None:
            pulumi.set(__self__, "version_preference", version_preference)
        if version_track_preference is not None:
            pulumi.set(__self__, "version_track_preference", version_track_preference)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="maintenanceScheduleType")
    def maintenance_schedule_type(self) -> Optional[_builtins.str]:
        """
        The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        """
        return pulumi.get(self, "maintenance_schedule_type")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[_builtins.str]:
        """
        The version that is expected to be targeted during the next scheduled maintenance run.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> Optional[_builtins.str]:
        """
        The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> Optional[_builtins.str]:
        """
        The preferred version to target when performing an automatic MySQL upgrade.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="versionTrackPreference")
    def version_track_preference(self) -> Optional[_builtins.str]:
        """
        The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        return pulumi.get(self, "version_track_preference")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[_builtins.str]:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotReadEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeIps":
            suggest = "exclude_ips"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "readEndpointHostnameLabel":
            suggest = "read_endpoint_hostname_label"
        elif key == "readEndpointIpAddress":
            suggest = "read_endpoint_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotReadEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotReadEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotReadEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_ips: Optional[Sequence[_builtins.str]] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 read_endpoint_hostname_label: Optional[_builtins.str] = None,
                 read_endpoint_ip_address: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclude_ips: A list of IP addresses of read replicas that are excluded from serving read requests.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str read_endpoint_hostname_label: The hostname for the read endpoint of the DB System. Used for DNS.
        :param _builtins.str read_endpoint_ip_address: The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        if exclude_ips is not None:
            pulumi.set(__self__, "exclude_ips", exclude_ips)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if read_endpoint_hostname_label is not None:
            pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        if read_endpoint_ip_address is not None:
            pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @_builtins.property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> Optional[_builtins.str]:
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @_builtins.property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotRest(dict):
    def __init__(__self__, *,
                 configuration: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str configuration: Select how REST is configured across the DB System instances.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[_builtins.str]:
        """
        Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotSecureConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateGenerationType":
            suggest = "certificate_generation_type"
        elif key == "certificateId":
            suggest = "certificate_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotSecureConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotSecureConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotSecureConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_generation_type: Optional[_builtins.str] = None,
                 certificate_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        if certificate_generation_type is not None:
            pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> Optional[_builtins.str]:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class MysqlBackupDbSystemSnapshotSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupDbSystemSnapshotSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupDbSystemSnapshotSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupDbSystemSnapshotSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: (Updatable) A user-supplied display name for the backup.
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class MysqlBackupEncryptData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyGenerationType":
            suggest = "key_generation_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupEncryptData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupEncryptData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupEncryptData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class MysqlBackupSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupId":
            suggest = "backup_id"
        elif key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_id: _builtins.str,
                 compartment_id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str backup_id: The OCID of the source backup.
        :param _builtins.str compartment_id: (Updatable) The OCID of the compartment the backup exists in.
        :param _builtins.str region: The region of the backup source.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        The OCID of the source backup.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        (Updatable) The OCID of the compartment the backup exists in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the backup source.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class MysqlBackupValidateBackupDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPreparedBackupRequired":
            suggest = "is_prepared_backup_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlBackupValidateBackupDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlBackupValidateBackupDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlBackupValidateBackupDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_prepared_backup_required: _builtins.bool):
        """
        :param _builtins.bool is_prepared_backup_required: Specifies whether the backup needs to be prepared for fast restore or not. Set to true to prepare the backup **Note:** Prepare backup is a one time operation, therefore this field can be set to true only once.
        """
        pulumi.set(__self__, "is_prepared_backup_required", is_prepared_backup_required)

    @_builtins.property
    @pulumi.getter(name="isPreparedBackupRequired")
    def is_prepared_backup_required(self) -> _builtins.bool:
        """
        Specifies whether the backup needs to be prepared for fast restore or not. Set to true to prepare the backup **Note:** Prepare backup is a one time operation, therefore this field can be set to true only once.
        """
        return pulumi.get(self, "is_prepared_backup_required")


@pulumi.output_type
class MysqlConfigurationInitVariables(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lowerCaseTableNames":
            suggest = "lower_case_table_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlConfigurationInitVariables. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlConfigurationInitVariables.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlConfigurationInitVariables.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lower_case_table_names: Optional[_builtins.str] = None):
        """
        :param _builtins.str lower_case_table_names: Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
               
               lowerCaseTableNames controls case-sensitivity of tables and schema names and how they are stored in the DB System.
               
               Valid values are:
               * CASE_SENSITIVE - (default) Table and schema name comparisons are case-sensitive and stored as specified. (lower_case_table_names=0)
               * CASE_INSENSITIVE_LOWERCASE - Table and schema name comparisons are not case-sensitive and stored in lowercase. (lower_case_table_names=1)
        """
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[_builtins.str]:
        """
        Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).

        lowerCaseTableNames controls case-sensitivity of tables and schema names and how they are stored in the DB System.

        Valid values are:
        * CASE_SENSITIVE - (default) Table and schema name comparisons are case-sensitive and stored as specified. (lower_case_table_names=0)
        * CASE_INSENSITIVE_LOWERCASE - Table and schema name comparisons are not case-sensitive and stored in lowercase. (lower_case_table_names=1)
        """
        return pulumi.get(self, "lower_case_table_names")


@pulumi.output_type
class MysqlConfigurationVariables(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoIncrementIncrement":
            suggest = "auto_increment_increment"
        elif key == "autoIncrementOffset":
            suggest = "auto_increment_offset"
        elif key == "bigTables":
            suggest = "big_tables"
        elif key == "binlogExpireLogsSeconds":
            suggest = "binlog_expire_logs_seconds"
        elif key == "binlogGroupCommitSyncDelay":
            suggest = "binlog_group_commit_sync_delay"
        elif key == "binlogGroupCommitSyncNoDelayCount":
            suggest = "binlog_group_commit_sync_no_delay_count"
        elif key == "binlogRowMetadata":
            suggest = "binlog_row_metadata"
        elif key == "binlogRowValueOptions":
            suggest = "binlog_row_value_options"
        elif key == "binlogTransactionCompression":
            suggest = "binlog_transaction_compression"
        elif key == "blockEncryptionMode":
            suggest = "block_encryption_mode"
        elif key == "characterSetServer":
            suggest = "character_set_server"
        elif key == "collationServer":
            suggest = "collation_server"
        elif key == "completionType":
            suggest = "completion_type"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "connectionMemoryChunkSize":
            suggest = "connection_memory_chunk_size"
        elif key == "connectionMemoryLimit":
            suggest = "connection_memory_limit"
        elif key == "cteMaxRecursionDepth":
            suggest = "cte_max_recursion_depth"
        elif key == "defaultAuthenticationPlugin":
            suggest = "default_authentication_plugin"
        elif key == "explainFormat":
            suggest = "explain_format"
        elif key == "explicitDefaultsForTimestamp":
            suggest = "explicit_defaults_for_timestamp"
        elif key == "foreignKeyChecks":
            suggest = "foreign_key_checks"
        elif key == "generatedRandomPasswordLength":
            suggest = "generated_random_password_length"
        elif key == "globalConnectionMemoryLimit":
            suggest = "global_connection_memory_limit"
        elif key == "globalConnectionMemoryTracking":
            suggest = "global_connection_memory_tracking"
        elif key == "groupConcatMaxLen":
            suggest = "group_concat_max_len"
        elif key == "groupReplicationConsistency":
            suggest = "group_replication_consistency"
        elif key == "informationSchemaStatsExpiry":
            suggest = "information_schema_stats_expiry"
        elif key == "innodbAdaptiveHashIndex":
            suggest = "innodb_adaptive_hash_index"
        elif key == "innodbAutoincLockMode":
            suggest = "innodb_autoinc_lock_mode"
        elif key == "innodbBufferPoolDumpPct":
            suggest = "innodb_buffer_pool_dump_pct"
        elif key == "innodbBufferPoolInstances":
            suggest = "innodb_buffer_pool_instances"
        elif key == "innodbBufferPoolSize":
            suggest = "innodb_buffer_pool_size"
        elif key == "innodbChangeBuffering":
            suggest = "innodb_change_buffering"
        elif key == "innodbDdlBufferSize":
            suggest = "innodb_ddl_buffer_size"
        elif key == "innodbDdlThreads":
            suggest = "innodb_ddl_threads"
        elif key == "innodbFtEnableStopword":
            suggest = "innodb_ft_enable_stopword"
        elif key == "innodbFtMaxTokenSize":
            suggest = "innodb_ft_max_token_size"
        elif key == "innodbFtMinTokenSize":
            suggest = "innodb_ft_min_token_size"
        elif key == "innodbFtNumWordOptimize":
            suggest = "innodb_ft_num_word_optimize"
        elif key == "innodbFtResultCacheLimit":
            suggest = "innodb_ft_result_cache_limit"
        elif key == "innodbFtServerStopwordTable":
            suggest = "innodb_ft_server_stopword_table"
        elif key == "innodbLockWaitTimeout":
            suggest = "innodb_lock_wait_timeout"
        elif key == "innodbLogWriterThreads":
            suggest = "innodb_log_writer_threads"
        elif key == "innodbMaxPurgeLag":
            suggest = "innodb_max_purge_lag"
        elif key == "innodbMaxPurgeLagDelay":
            suggest = "innodb_max_purge_lag_delay"
        elif key == "innodbNumaInterleave":
            suggest = "innodb_numa_interleave"
        elif key == "innodbOnlineAlterLogMaxSize":
            suggest = "innodb_online_alter_log_max_size"
        elif key == "innodbRedoLogCapacity":
            suggest = "innodb_redo_log_capacity"
        elif key == "innodbRollbackOnTimeout":
            suggest = "innodb_rollback_on_timeout"
        elif key == "innodbSortBufferSize":
            suggest = "innodb_sort_buffer_size"
        elif key == "innodbStatsPersistentSamplePages":
            suggest = "innodb_stats_persistent_sample_pages"
        elif key == "innodbStatsTransientSamplePages":
            suggest = "innodb_stats_transient_sample_pages"
        elif key == "innodbStrictMode":
            suggest = "innodb_strict_mode"
        elif key == "innodbUndoLogTruncate":
            suggest = "innodb_undo_log_truncate"
        elif key == "interactiveTimeout":
            suggest = "interactive_timeout"
        elif key == "joinBufferSize":
            suggest = "join_buffer_size"
        elif key == "localInfile":
            suggest = "local_infile"
        elif key == "longQueryTime":
            suggest = "long_query_time"
        elif key == "mandatoryRoles":
            suggest = "mandatory_roles"
        elif key == "maxAllowedPacket":
            suggest = "max_allowed_packet"
        elif key == "maxBinlogCacheSize":
            suggest = "max_binlog_cache_size"
        elif key == "maxConnectErrors":
            suggest = "max_connect_errors"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxExecutionTime":
            suggest = "max_execution_time"
        elif key == "maxHeapTableSize":
            suggest = "max_heap_table_size"
        elif key == "maxPreparedStmtCount":
            suggest = "max_prepared_stmt_count"
        elif key == "maxSeeksForKey":
            suggest = "max_seeks_for_key"
        elif key == "maxUserConnections":
            suggest = "max_user_connections"
        elif key == "mysqlFirewallMode":
            suggest = "mysql_firewall_mode"
        elif key == "mysqlZstdDefaultCompressionLevel":
            suggest = "mysql_zstd_default_compression_level"
        elif key == "mysqlxConnectTimeout":
            suggest = "mysqlx_connect_timeout"
        elif key == "mysqlxDeflateDefaultCompressionLevel":
            suggest = "mysqlx_deflate_default_compression_level"
        elif key == "mysqlxDeflateMaxClientCompressionLevel":
            suggest = "mysqlx_deflate_max_client_compression_level"
        elif key == "mysqlxDocumentIdUniquePrefix":
            suggest = "mysqlx_document_id_unique_prefix"
        elif key == "mysqlxEnableHelloNotice":
            suggest = "mysqlx_enable_hello_notice"
        elif key == "mysqlxIdleWorkerThreadTimeout":
            suggest = "mysqlx_idle_worker_thread_timeout"
        elif key == "mysqlxInteractiveTimeout":
            suggest = "mysqlx_interactive_timeout"
        elif key == "mysqlxLz4defaultCompressionLevel":
            suggest = "mysqlx_lz4default_compression_level"
        elif key == "mysqlxLz4maxClientCompressionLevel":
            suggest = "mysqlx_lz4max_client_compression_level"
        elif key == "mysqlxMaxAllowedPacket":
            suggest = "mysqlx_max_allowed_packet"
        elif key == "mysqlxMinWorkerThreads":
            suggest = "mysqlx_min_worker_threads"
        elif key == "mysqlxReadTimeout":
            suggest = "mysqlx_read_timeout"
        elif key == "mysqlxWaitTimeout":
            suggest = "mysqlx_wait_timeout"
        elif key == "mysqlxWriteTimeout":
            suggest = "mysqlx_write_timeout"
        elif key == "mysqlxZstdDefaultCompressionLevel":
            suggest = "mysqlx_zstd_default_compression_level"
        elif key == "mysqlxZstdMaxClientCompressionLevel":
            suggest = "mysqlx_zstd_max_client_compression_level"
        elif key == "netReadTimeout":
            suggest = "net_read_timeout"
        elif key == "netWriteTimeout":
            suggest = "net_write_timeout"
        elif key == "optimizerSwitch":
            suggest = "optimizer_switch"
        elif key == "parserMaxMemSize":
            suggest = "parser_max_mem_size"
        elif key == "queryAllocBlockSize":
            suggest = "query_alloc_block_size"
        elif key == "queryPreallocSize":
            suggest = "query_prealloc_size"
        elif key == "rangeOptimizerMaxMemSize":
            suggest = "range_optimizer_max_mem_size"
        elif key == "regexpTimeLimit":
            suggest = "regexp_time_limit"
        elif key == "relayLogSpaceLimit":
            suggest = "relay_log_space_limit"
        elif key == "replicaNetTimeout":
            suggest = "replica_net_timeout"
        elif key == "replicaParallelWorkers":
            suggest = "replica_parallel_workers"
        elif key == "replicaTypeConversions":
            suggest = "replica_type_conversions"
        elif key == "requireSecureTransport":
            suggest = "require_secure_transport"
        elif key == "skipNameResolve":
            suggest = "skip_name_resolve"
        elif key == "sortBufferSize":
            suggest = "sort_buffer_size"
        elif key == "sqlGenerateInvisiblePrimaryKey":
            suggest = "sql_generate_invisible_primary_key"
        elif key == "sqlMode":
            suggest = "sql_mode"
        elif key == "sqlRequirePrimaryKey":
            suggest = "sql_require_primary_key"
        elif key == "sqlWarnings":
            suggest = "sql_warnings"
        elif key == "tableDefinitionCache":
            suggest = "table_definition_cache"
        elif key == "tableOpenCache":
            suggest = "table_open_cache"
        elif key == "temptableMaxRam":
            suggest = "temptable_max_ram"
        elif key == "threadPoolDedicatedListeners":
            suggest = "thread_pool_dedicated_listeners"
        elif key == "threadPoolMaxTransactionsLimit":
            suggest = "thread_pool_max_transactions_limit"
        elif key == "threadPoolQueryThreadsPerGroup":
            suggest = "thread_pool_query_threads_per_group"
        elif key == "threadPoolSize":
            suggest = "thread_pool_size"
        elif key == "threadPoolTransactionDelay":
            suggest = "thread_pool_transaction_delay"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "tmpTableSize":
            suggest = "tmp_table_size"
        elif key == "transactionIsolation":
            suggest = "transaction_isolation"
        elif key == "waitTimeout":
            suggest = "wait_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlConfigurationVariables. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlConfigurationVariables.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlConfigurationVariables.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_increment_increment: Optional[_builtins.int] = None,
                 auto_increment_offset: Optional[_builtins.int] = None,
                 autocommit: Optional[_builtins.bool] = None,
                 big_tables: Optional[_builtins.bool] = None,
                 binlog_expire_logs_seconds: Optional[_builtins.int] = None,
                 binlog_group_commit_sync_delay: Optional[_builtins.int] = None,
                 binlog_group_commit_sync_no_delay_count: Optional[_builtins.int] = None,
                 binlog_row_metadata: Optional[_builtins.str] = None,
                 binlog_row_value_options: Optional[_builtins.str] = None,
                 binlog_transaction_compression: Optional[_builtins.bool] = None,
                 block_encryption_mode: Optional[_builtins.str] = None,
                 character_set_server: Optional[_builtins.str] = None,
                 collation_server: Optional[_builtins.str] = None,
                 completion_type: Optional[_builtins.str] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 connection_memory_chunk_size: Optional[_builtins.int] = None,
                 connection_memory_limit: Optional[_builtins.str] = None,
                 cte_max_recursion_depth: Optional[_builtins.str] = None,
                 default_authentication_plugin: Optional[_builtins.str] = None,
                 explain_format: Optional[_builtins.str] = None,
                 explicit_defaults_for_timestamp: Optional[_builtins.bool] = None,
                 foreign_key_checks: Optional[_builtins.bool] = None,
                 generated_random_password_length: Optional[_builtins.int] = None,
                 global_connection_memory_limit: Optional[_builtins.str] = None,
                 global_connection_memory_tracking: Optional[_builtins.bool] = None,
                 group_concat_max_len: Optional[_builtins.str] = None,
                 group_replication_consistency: Optional[_builtins.str] = None,
                 information_schema_stats_expiry: Optional[_builtins.int] = None,
                 innodb_adaptive_hash_index: Optional[_builtins.bool] = None,
                 innodb_autoinc_lock_mode: Optional[_builtins.int] = None,
                 innodb_buffer_pool_dump_pct: Optional[_builtins.int] = None,
                 innodb_buffer_pool_instances: Optional[_builtins.int] = None,
                 innodb_buffer_pool_size: Optional[_builtins.str] = None,
                 innodb_change_buffering: Optional[_builtins.str] = None,
                 innodb_ddl_buffer_size: Optional[_builtins.str] = None,
                 innodb_ddl_threads: Optional[_builtins.int] = None,
                 innodb_ft_enable_stopword: Optional[_builtins.bool] = None,
                 innodb_ft_max_token_size: Optional[_builtins.int] = None,
                 innodb_ft_min_token_size: Optional[_builtins.int] = None,
                 innodb_ft_num_word_optimize: Optional[_builtins.int] = None,
                 innodb_ft_result_cache_limit: Optional[_builtins.str] = None,
                 innodb_ft_server_stopword_table: Optional[_builtins.str] = None,
                 innodb_lock_wait_timeout: Optional[_builtins.int] = None,
                 innodb_log_writer_threads: Optional[_builtins.bool] = None,
                 innodb_max_purge_lag: Optional[_builtins.str] = None,
                 innodb_max_purge_lag_delay: Optional[_builtins.int] = None,
                 innodb_numa_interleave: Optional[_builtins.bool] = None,
                 innodb_online_alter_log_max_size: Optional[_builtins.str] = None,
                 innodb_redo_log_capacity: Optional[_builtins.str] = None,
                 innodb_rollback_on_timeout: Optional[_builtins.bool] = None,
                 innodb_sort_buffer_size: Optional[_builtins.int] = None,
                 innodb_stats_persistent_sample_pages: Optional[_builtins.str] = None,
                 innodb_stats_transient_sample_pages: Optional[_builtins.str] = None,
                 innodb_strict_mode: Optional[_builtins.bool] = None,
                 innodb_undo_log_truncate: Optional[_builtins.bool] = None,
                 interactive_timeout: Optional[_builtins.int] = None,
                 join_buffer_size: Optional[_builtins.str] = None,
                 local_infile: Optional[_builtins.bool] = None,
                 long_query_time: Optional[_builtins.int] = None,
                 mandatory_roles: Optional[_builtins.str] = None,
                 max_allowed_packet: Optional[_builtins.int] = None,
                 max_binlog_cache_size: Optional[_builtins.str] = None,
                 max_connect_errors: Optional[_builtins.str] = None,
                 max_connections: Optional[_builtins.int] = None,
                 max_execution_time: Optional[_builtins.str] = None,
                 max_heap_table_size: Optional[_builtins.str] = None,
                 max_prepared_stmt_count: Optional[_builtins.int] = None,
                 max_seeks_for_key: Optional[_builtins.str] = None,
                 max_user_connections: Optional[_builtins.str] = None,
                 mysql_firewall_mode: Optional[_builtins.bool] = None,
                 mysql_zstd_default_compression_level: Optional[_builtins.int] = None,
                 mysqlx_connect_timeout: Optional[_builtins.int] = None,
                 mysqlx_deflate_default_compression_level: Optional[_builtins.int] = None,
                 mysqlx_deflate_max_client_compression_level: Optional[_builtins.int] = None,
                 mysqlx_document_id_unique_prefix: Optional[_builtins.int] = None,
                 mysqlx_enable_hello_notice: Optional[_builtins.bool] = None,
                 mysqlx_idle_worker_thread_timeout: Optional[_builtins.int] = None,
                 mysqlx_interactive_timeout: Optional[_builtins.int] = None,
                 mysqlx_lz4default_compression_level: Optional[_builtins.int] = None,
                 mysqlx_lz4max_client_compression_level: Optional[_builtins.int] = None,
                 mysqlx_max_allowed_packet: Optional[_builtins.int] = None,
                 mysqlx_min_worker_threads: Optional[_builtins.int] = None,
                 mysqlx_read_timeout: Optional[_builtins.int] = None,
                 mysqlx_wait_timeout: Optional[_builtins.int] = None,
                 mysqlx_write_timeout: Optional[_builtins.int] = None,
                 mysqlx_zstd_default_compression_level: Optional[_builtins.int] = None,
                 mysqlx_zstd_max_client_compression_level: Optional[_builtins.int] = None,
                 net_read_timeout: Optional[_builtins.int] = None,
                 net_write_timeout: Optional[_builtins.int] = None,
                 optimizer_switch: Optional[_builtins.str] = None,
                 parser_max_mem_size: Optional[_builtins.str] = None,
                 query_alloc_block_size: Optional[_builtins.str] = None,
                 query_prealloc_size: Optional[_builtins.str] = None,
                 range_optimizer_max_mem_size: Optional[_builtins.str] = None,
                 regexp_time_limit: Optional[_builtins.int] = None,
                 relay_log_space_limit: Optional[_builtins.str] = None,
                 replica_net_timeout: Optional[_builtins.int] = None,
                 replica_parallel_workers: Optional[_builtins.int] = None,
                 replica_type_conversions: Optional[_builtins.str] = None,
                 require_secure_transport: Optional[_builtins.bool] = None,
                 skip_name_resolve: Optional[_builtins.bool] = None,
                 sort_buffer_size: Optional[_builtins.str] = None,
                 sql_generate_invisible_primary_key: Optional[_builtins.bool] = None,
                 sql_mode: Optional[_builtins.str] = None,
                 sql_require_primary_key: Optional[_builtins.bool] = None,
                 sql_warnings: Optional[_builtins.bool] = None,
                 table_definition_cache: Optional[_builtins.int] = None,
                 table_open_cache: Optional[_builtins.int] = None,
                 temptable_max_ram: Optional[_builtins.str] = None,
                 thread_pool_dedicated_listeners: Optional[_builtins.bool] = None,
                 thread_pool_max_transactions_limit: Optional[_builtins.int] = None,
                 thread_pool_query_threads_per_group: Optional[_builtins.int] = None,
                 thread_pool_size: Optional[_builtins.int] = None,
                 thread_pool_transaction_delay: Optional[_builtins.int] = None,
                 time_zone: Optional[_builtins.str] = None,
                 tmp_table_size: Optional[_builtins.str] = None,
                 transaction_isolation: Optional[_builtins.str] = None,
                 wait_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int auto_increment_increment: auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
               
               autoIncrementIncrement corresponds to the MySQL Replication Source Options variable [auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).
        :param _builtins.int auto_increment_offset: This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
               
               autoIncrementOffset corresponds to the MySQL Replication Source Options variable [auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).
        :param _builtins.bool autocommit: ("autocommit")
        :param _builtins.bool big_tables: If enabled, the server stores all temporary tables on disk rather than in memory.
               
               bigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).
        :param _builtins.int binlog_expire_logs_seconds: Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        :param _builtins.int binlog_group_commit_sync_delay: Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
               
               binlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable [binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)
        :param _builtins.int binlog_group_commit_sync_no_delay_count: The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
               
               binlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable [binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)
        :param _builtins.str binlog_row_metadata: Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        :param _builtins.str binlog_row_value_options: When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        :param _builtins.bool binlog_transaction_compression: Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        :param _builtins.str block_encryption_mode: This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
               
               block_encryption_mode corresponds to the MySQL Server Administration system variable [block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)
        :param _builtins.str character_set_server: The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
               
               characterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).
        :param _builtins.str collation_server: The server's default collation.
               
               collationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).
        :param _builtins.str completion_type: ("completion_type")
        :param _builtins.int connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
               
               connectTimeout corresponds to the MySQL system variable [connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)
               
               Increasing the connect_timeout value might help if clients frequently encounter errors of the form "Lost connection to MySQL server at 'XXX', system error: errno".
        :param _builtins.int connection_memory_chunk_size: Set the chunking size for updates to the global memory usage counter Global_connection_memory.
               
               connectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).
        :param _builtins.str connection_memory_limit: Set the maximum amount of memory that can be used by a single user connection.
               
               connectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).
        :param _builtins.str cte_max_recursion_depth: ("cte_max_recursion_depth")
        :param _builtins.str default_authentication_plugin: The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
               
               As of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used, but in conjunction with and at a lower precedence than the authentication_policy system variable. For details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27 and subject to removal in a future MySQL version.
               
               defaultAuthenticationPlugin corresponds to the MySQL system variable [default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).
        :param _builtins.str explain_format: This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
               
               explainFormat corresponds to the MySQL system variable [explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).
        :param _builtins.bool explicit_defaults_for_timestamp: This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
               
               explicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable [explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)
        :param _builtins.bool foreign_key_checks: ("foreign_key_checks")
        :param _builtins.int generated_random_password_length: ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str global_connection_memory_limit: Set the total amount of memory that can be used by all user connections.
               
               globalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).
        :param _builtins.bool global_connection_memory_tracking: Determines whether the MySQL server calculates Global_connection_memory.
               
               globalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).
        :param _builtins.str group_concat_max_len: Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
               
               This is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)
        :param _builtins.str group_replication_consistency: * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
               * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
               * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        :param _builtins.int information_schema_stats_expiry: ("information_schema_stats_expiry")
        :param _builtins.bool innodb_adaptive_hash_index: Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
               
               innodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).
        :param _builtins.int innodb_autoinc_lock_mode: The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
               
               innodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).
        :param _builtins.int innodb_buffer_pool_dump_pct: Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
               
               innodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable [innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).
               
               The range is 1 to 100. The default value is 25.
               
               For example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25, the 25 most recently used pages from each buffer pool are dumped.
        :param _builtins.int innodb_buffer_pool_instances: ("innodb_buffer_pool_instances")
        :param _builtins.str innodb_buffer_pool_size: The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
               
               innodbBufferPoolSize corresponds to the MySQL server system variable [innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).
               
               The default and maximum values depend on the amount of RAM provisioned by the shape. See [Default User Variables](https://www.terraform.io/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).
        :param _builtins.str innodb_change_buffering: Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
               
               innodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
        :param _builtins.str innodb_ddl_buffer_size: innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        :param _builtins.int innodb_ddl_threads: innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        :param _builtins.bool innodb_ft_enable_stopword: ("innodb_ft_enable_stopword")
        :param _builtins.int innodb_ft_max_token_size: ("innodb_ft_max_token_size")
        :param _builtins.int innodb_ft_min_token_size: ("innodb_ft_min_token_size")
        :param _builtins.int innodb_ft_num_word_optimize: ("innodb_ft_num_word_optimize")
        :param _builtins.str innodb_ft_result_cache_limit: ("innodb_ft_result_cache_limit")
        :param _builtins.str innodb_ft_server_stopword_table: ("innodb_ft_server_stopword_table")
        :param _builtins.int innodb_lock_wait_timeout: ("innodb_lock_wait_timeout")
        :param _builtins.bool innodb_log_writer_threads: Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
               
               This is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)
        :param _builtins.str innodb_max_purge_lag: The desired maximum purge lag in terms of transactions.
               
               InnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.
               
               If this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.
               
               The default value is 0, which means there is no maximum purge lag and no delay.
               
               innodbMaxPurgeLag corresponds to the MySQL server system variable [innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).
        :param _builtins.int innodb_max_purge_lag_delay: The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
               
               The specified innodb_max_purge_lag_delay value is an upper limit on the delay period.
               
               innodbMaxPurgeLagDelay corresponds to the MySQL server system variable [innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).
        :param _builtins.bool innodb_numa_interleave: Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
               
               innodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).
        :param _builtins.str innodb_online_alter_log_max_size: Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
               
               innodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).
        :param _builtins.str innodb_redo_log_capacity: Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
               
               innodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables [innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)
        :param _builtins.bool innodb_rollback_on_timeout: InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
               
               innodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).
        :param _builtins.int innodb_sort_buffer_size: This variable defines:
               * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
               * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
               
               innodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).
        :param _builtins.str innodb_stats_persistent_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
               
               innodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)
               
               innodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table; when innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.
        :param _builtins.str innodb_stats_transient_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
               
               innodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)
               
               innodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table; when innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.
               
               innodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the STATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and [ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.
        :param _builtins.bool innodb_strict_mode: When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
               
               innodbStrictMode corresponds to the MySQL InnoDB system variable [innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)
        :param _builtins.bool innodb_undo_log_truncate: When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
               
               innodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).
        :param _builtins.int interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
               
               interactiveTimeout corresponds to the MySQL system variable. [interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)
        :param _builtins.str join_buffer_size: The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
               
               joinBufferSize corresponds to the MySQL Server System variable [join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).
        :param _builtins.bool local_infile: This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side. 
               
               local_infile corresponds to the MySQL Server system variable [local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)
        :param _builtins.int long_query_time: If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
               
               longQueryTime corresponds to the MySQL Server System variable [long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).
        :param _builtins.str mandatory_roles: ("mandatory_roles")
        :param _builtins.int max_allowed_packet: The maximum size of one packet or any generated/intermediate string.
               
               This is the mysql variable "max_allowed_packet".
        :param _builtins.str max_binlog_cache_size: Sets the size of the transaction cache.
               
               maxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).
        :param _builtins.str max_connect_errors: ("max_connect_errors")
        :param _builtins.int max_connections: ("max_connections")
        :param _builtins.str max_execution_time: ("max_execution_time")
        :param _builtins.str max_heap_table_size: This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
               
               maxHeapTableSize corresponds to the MySQL system variable [max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)
        :param _builtins.int max_prepared_stmt_count: ("max_prepared_stmt_count")
        :param _builtins.str max_seeks_for_key: Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
               
               maxSeeksForKey corresponds to the MySQL Server System variable [max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).
        :param _builtins.str max_user_connections: The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
               
               maxUserConnections corresponds to the MySQL Server System variable [max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).
        :param _builtins.bool mysql_firewall_mode: ("mysql_firewall_mode")
        :param _builtins.int mysql_zstd_default_compression_level: DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        :param _builtins.int mysqlx_connect_timeout: The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
               
               mysqlxConnectTimeout corresponds to the MySQL X Plugin system variable [mysqlx_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_connect_timeout)
        :param _builtins.int mysqlx_deflate_default_compression_level: Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        :param _builtins.int mysqlx_deflate_max_client_compression_level: Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        :param _builtins.int mysqlx_document_id_unique_prefix: ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.bool mysqlx_enable_hello_notice: ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_idle_worker_thread_timeout: ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_interactive_timeout: The number of seconds to wait for interactive clients to timeout.
               
               mysqlxInteractiveTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_interactive_timeout)
        :param _builtins.int mysqlx_lz4default_compression_level: Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        :param _builtins.int mysqlx_lz4max_client_compression_level: Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        :param _builtins.int mysqlx_max_allowed_packet: The maximum size of network packets that can be received by X Plugin.
               
               This is the mysql variable "mysqlx_max_allowed_packet".
        :param _builtins.int mysqlx_min_worker_threads: ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_read_timeout: The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
               
               mysqlxReadTimeout corresponds to the MySQL X Plugin system variable [mysqlx_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_read_timeout)
        :param _builtins.int mysqlx_wait_timeout: The number of seconds that X Plugin waits for activity on a connection.
               
               mysqlxWaitTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_wait_timeout)
        :param _builtins.int mysqlx_write_timeout: The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
               
               mysqlxReadmysqlxWriteTimeoutTimeout corresponds to the MySQL X Plugin system variable [mysqlx_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_write_timeout)
        :param _builtins.int mysqlx_zstd_default_compression_level: Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        :param _builtins.int mysqlx_zstd_max_client_compression_level: Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        :param _builtins.int net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
               
               netReadTimeout corresponds to the MySQL system variable [net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)
        :param _builtins.int net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
               
               netWriteTimeout corresponds to the MySQL system variable [net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)
        :param _builtins.str optimizer_switch: The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
               
               Setting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.
               
               optimizerSwitch corresponds to the MySQL Server System variable [optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).
        :param _builtins.str parser_max_mem_size: ("parser_max_mem_size")
        :param _builtins.str query_alloc_block_size: ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str query_prealloc_size: ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str range_optimizer_max_mem_size: The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans. 
               
               rangeOptimizerMaxMemSize corresponds to the MySQL Server System variable [range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).
        :param _builtins.int regexp_time_limit: regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        :param _builtins.str relay_log_space_limit: The maximum amount of space to use for all relay logs.
               
               relayLogSpaceLimit corresponds to the MySQL Replica Server Options variable [relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).
        :param _builtins.int replica_net_timeout: Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
               
               replicaNetTimeout corresponds to the MySQL Replica server system variable [replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)
        :param _builtins.int replica_parallel_workers: Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
               
               replicaParallelWorkers corresponds to the MySQL Replica Server Options variable [replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).
        :param _builtins.str replica_type_conversions: From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
               
               replica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication. Its value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED. Set this variable to an empty string to disallow type conversions between the source and the replica. Setting this variable takes effect for all replication channels immediately, including running channels.
               
               replica_type_conversions corresponds to the MySQL Replica Server Options variable [replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).
        :param _builtins.bool require_secure_transport: Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
               
               require_secure_transport corresponds to the MySQL Server Administration system variable [require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)
        :param _builtins.bool skip_name_resolve: Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
               
               skipNameResolve corresponds to the MySQL Server System variable [skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).
        :param _builtins.str sort_buffer_size: Each session that must perform a sort allocates a buffer of this size.
               
               sortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)
        :param _builtins.bool sql_generate_invisible_primary_key: Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
               
               sqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable [sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).
        :param _builtins.str sql_mode: ("sql_mode")
        :param _builtins.bool sql_require_primary_key: ("sql_require_primary_key")
        :param _builtins.bool sql_warnings: ("sql_warnings")
        :param _builtins.int table_definition_cache: The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
               
               table_definition_cache corresponds to the MySQL Server Administration system variable [table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)
        :param _builtins.int table_open_cache: The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
               
               table_open_cache corresponds to the MySQL Server Administration system variable [table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)
        :param _builtins.str temptable_max_ram: Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
               
               temptableMaxRam corresponds to the MySQL system variable [temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).
        :param _builtins.bool thread_pool_dedicated_listeners: Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        :param _builtins.int thread_pool_max_transactions_limit: Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        :param _builtins.int thread_pool_query_threads_per_group: The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions. 
               
               threadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable [thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)
        :param _builtins.int thread_pool_size: The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
               
               threadPoolSize corresponds to the MySQL Server System variable [thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).
        :param _builtins.int thread_pool_transaction_delay: The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running. 
               
               threadPoolTransactionDelay corresponds to the MySQL Server system variable [thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)
        :param _builtins.str time_zone: Initializes the time zone for each client that connects.
               
               This corresponds to the MySQL System Variable "time_zone".
               
               The values can be given in one of the following formats, none of which are case-sensitive:
               * As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as '+10:00', '-6:00', or '+05:30'. The permitted range is '-13:59' to '+14:00', inclusive.
               * As a named time zone, as defined by the "IANA Time Zone database", such as 'Europe/Helsinki', 'US/Eastern', 'MET', or 'UTC'.
        :param _builtins.str tmp_table_size: The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
               
               tmp_table_size corresponds to the MySQL system variable [tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)
        :param _builtins.str transaction_isolation: ("transaction_isolation")
        :param _builtins.int wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
               
               waitTimeout corresponds to the MySQL system variable. [wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if auto_increment_increment is not None:
            pulumi.set(__self__, "auto_increment_increment", auto_increment_increment)
        if auto_increment_offset is not None:
            pulumi.set(__self__, "auto_increment_offset", auto_increment_offset)
        if autocommit is not None:
            pulumi.set(__self__, "autocommit", autocommit)
        if big_tables is not None:
            pulumi.set(__self__, "big_tables", big_tables)
        if binlog_expire_logs_seconds is not None:
            pulumi.set(__self__, "binlog_expire_logs_seconds", binlog_expire_logs_seconds)
        if binlog_group_commit_sync_delay is not None:
            pulumi.set(__self__, "binlog_group_commit_sync_delay", binlog_group_commit_sync_delay)
        if binlog_group_commit_sync_no_delay_count is not None:
            pulumi.set(__self__, "binlog_group_commit_sync_no_delay_count", binlog_group_commit_sync_no_delay_count)
        if binlog_row_metadata is not None:
            pulumi.set(__self__, "binlog_row_metadata", binlog_row_metadata)
        if binlog_row_value_options is not None:
            pulumi.set(__self__, "binlog_row_value_options", binlog_row_value_options)
        if binlog_transaction_compression is not None:
            pulumi.set(__self__, "binlog_transaction_compression", binlog_transaction_compression)
        if block_encryption_mode is not None:
            pulumi.set(__self__, "block_encryption_mode", block_encryption_mode)
        if character_set_server is not None:
            pulumi.set(__self__, "character_set_server", character_set_server)
        if collation_server is not None:
            pulumi.set(__self__, "collation_server", collation_server)
        if completion_type is not None:
            pulumi.set(__self__, "completion_type", completion_type)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if connection_memory_chunk_size is not None:
            pulumi.set(__self__, "connection_memory_chunk_size", connection_memory_chunk_size)
        if connection_memory_limit is not None:
            pulumi.set(__self__, "connection_memory_limit", connection_memory_limit)
        if cte_max_recursion_depth is not None:
            pulumi.set(__self__, "cte_max_recursion_depth", cte_max_recursion_depth)
        if default_authentication_plugin is not None:
            pulumi.set(__self__, "default_authentication_plugin", default_authentication_plugin)
        if explain_format is not None:
            pulumi.set(__self__, "explain_format", explain_format)
        if explicit_defaults_for_timestamp is not None:
            pulumi.set(__self__, "explicit_defaults_for_timestamp", explicit_defaults_for_timestamp)
        if foreign_key_checks is not None:
            pulumi.set(__self__, "foreign_key_checks", foreign_key_checks)
        if generated_random_password_length is not None:
            pulumi.set(__self__, "generated_random_password_length", generated_random_password_length)
        if global_connection_memory_limit is not None:
            pulumi.set(__self__, "global_connection_memory_limit", global_connection_memory_limit)
        if global_connection_memory_tracking is not None:
            pulumi.set(__self__, "global_connection_memory_tracking", global_connection_memory_tracking)
        if group_concat_max_len is not None:
            pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        if group_replication_consistency is not None:
            pulumi.set(__self__, "group_replication_consistency", group_replication_consistency)
        if information_schema_stats_expiry is not None:
            pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        if innodb_adaptive_hash_index is not None:
            pulumi.set(__self__, "innodb_adaptive_hash_index", innodb_adaptive_hash_index)
        if innodb_autoinc_lock_mode is not None:
            pulumi.set(__self__, "innodb_autoinc_lock_mode", innodb_autoinc_lock_mode)
        if innodb_buffer_pool_dump_pct is not None:
            pulumi.set(__self__, "innodb_buffer_pool_dump_pct", innodb_buffer_pool_dump_pct)
        if innodb_buffer_pool_instances is not None:
            pulumi.set(__self__, "innodb_buffer_pool_instances", innodb_buffer_pool_instances)
        if innodb_buffer_pool_size is not None:
            pulumi.set(__self__, "innodb_buffer_pool_size", innodb_buffer_pool_size)
        if innodb_change_buffering is not None:
            pulumi.set(__self__, "innodb_change_buffering", innodb_change_buffering)
        if innodb_ddl_buffer_size is not None:
            pulumi.set(__self__, "innodb_ddl_buffer_size", innodb_ddl_buffer_size)
        if innodb_ddl_threads is not None:
            pulumi.set(__self__, "innodb_ddl_threads", innodb_ddl_threads)
        if innodb_ft_enable_stopword is not None:
            pulumi.set(__self__, "innodb_ft_enable_stopword", innodb_ft_enable_stopword)
        if innodb_ft_max_token_size is not None:
            pulumi.set(__self__, "innodb_ft_max_token_size", innodb_ft_max_token_size)
        if innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        if innodb_ft_num_word_optimize is not None:
            pulumi.set(__self__, "innodb_ft_num_word_optimize", innodb_ft_num_word_optimize)
        if innodb_ft_result_cache_limit is not None:
            pulumi.set(__self__, "innodb_ft_result_cache_limit", innodb_ft_result_cache_limit)
        if innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        if innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        if innodb_log_writer_threads is not None:
            pulumi.set(__self__, "innodb_log_writer_threads", innodb_log_writer_threads)
        if innodb_max_purge_lag is not None:
            pulumi.set(__self__, "innodb_max_purge_lag", innodb_max_purge_lag)
        if innodb_max_purge_lag_delay is not None:
            pulumi.set(__self__, "innodb_max_purge_lag_delay", innodb_max_purge_lag_delay)
        if innodb_numa_interleave is not None:
            pulumi.set(__self__, "innodb_numa_interleave", innodb_numa_interleave)
        if innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        if innodb_redo_log_capacity is not None:
            pulumi.set(__self__, "innodb_redo_log_capacity", innodb_redo_log_capacity)
        if innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        if innodb_sort_buffer_size is not None:
            pulumi.set(__self__, "innodb_sort_buffer_size", innodb_sort_buffer_size)
        if innodb_stats_persistent_sample_pages is not None:
            pulumi.set(__self__, "innodb_stats_persistent_sample_pages", innodb_stats_persistent_sample_pages)
        if innodb_stats_transient_sample_pages is not None:
            pulumi.set(__self__, "innodb_stats_transient_sample_pages", innodb_stats_transient_sample_pages)
        if innodb_strict_mode is not None:
            pulumi.set(__self__, "innodb_strict_mode", innodb_strict_mode)
        if innodb_undo_log_truncate is not None:
            pulumi.set(__self__, "innodb_undo_log_truncate", innodb_undo_log_truncate)
        if interactive_timeout is not None:
            pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        if join_buffer_size is not None:
            pulumi.set(__self__, "join_buffer_size", join_buffer_size)
        if local_infile is not None:
            pulumi.set(__self__, "local_infile", local_infile)
        if long_query_time is not None:
            pulumi.set(__self__, "long_query_time", long_query_time)
        if mandatory_roles is not None:
            pulumi.set(__self__, "mandatory_roles", mandatory_roles)
        if max_allowed_packet is not None:
            pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        if max_binlog_cache_size is not None:
            pulumi.set(__self__, "max_binlog_cache_size", max_binlog_cache_size)
        if max_connect_errors is not None:
            pulumi.set(__self__, "max_connect_errors", max_connect_errors)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_execution_time is not None:
            pulumi.set(__self__, "max_execution_time", max_execution_time)
        if max_heap_table_size is not None:
            pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        if max_prepared_stmt_count is not None:
            pulumi.set(__self__, "max_prepared_stmt_count", max_prepared_stmt_count)
        if max_seeks_for_key is not None:
            pulumi.set(__self__, "max_seeks_for_key", max_seeks_for_key)
        if max_user_connections is not None:
            pulumi.set(__self__, "max_user_connections", max_user_connections)
        if mysql_firewall_mode is not None:
            pulumi.set(__self__, "mysql_firewall_mode", mysql_firewall_mode)
        if mysql_zstd_default_compression_level is not None:
            pulumi.set(__self__, "mysql_zstd_default_compression_level", mysql_zstd_default_compression_level)
        if mysqlx_connect_timeout is not None:
            pulumi.set(__self__, "mysqlx_connect_timeout", mysqlx_connect_timeout)
        if mysqlx_deflate_default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_deflate_default_compression_level", mysqlx_deflate_default_compression_level)
        if mysqlx_deflate_max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_deflate_max_client_compression_level", mysqlx_deflate_max_client_compression_level)
        if mysqlx_document_id_unique_prefix is not None:
            pulumi.set(__self__, "mysqlx_document_id_unique_prefix", mysqlx_document_id_unique_prefix)
        if mysqlx_enable_hello_notice is not None:
            pulumi.set(__self__, "mysqlx_enable_hello_notice", mysqlx_enable_hello_notice)
        if mysqlx_idle_worker_thread_timeout is not None:
            pulumi.set(__self__, "mysqlx_idle_worker_thread_timeout", mysqlx_idle_worker_thread_timeout)
        if mysqlx_interactive_timeout is not None:
            pulumi.set(__self__, "mysqlx_interactive_timeout", mysqlx_interactive_timeout)
        if mysqlx_lz4default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_lz4default_compression_level", mysqlx_lz4default_compression_level)
        if mysqlx_lz4max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_lz4max_client_compression_level", mysqlx_lz4max_client_compression_level)
        if mysqlx_max_allowed_packet is not None:
            pulumi.set(__self__, "mysqlx_max_allowed_packet", mysqlx_max_allowed_packet)
        if mysqlx_min_worker_threads is not None:
            pulumi.set(__self__, "mysqlx_min_worker_threads", mysqlx_min_worker_threads)
        if mysqlx_read_timeout is not None:
            pulumi.set(__self__, "mysqlx_read_timeout", mysqlx_read_timeout)
        if mysqlx_wait_timeout is not None:
            pulumi.set(__self__, "mysqlx_wait_timeout", mysqlx_wait_timeout)
        if mysqlx_write_timeout is not None:
            pulumi.set(__self__, "mysqlx_write_timeout", mysqlx_write_timeout)
        if mysqlx_zstd_default_compression_level is not None:
            pulumi.set(__self__, "mysqlx_zstd_default_compression_level", mysqlx_zstd_default_compression_level)
        if mysqlx_zstd_max_client_compression_level is not None:
            pulumi.set(__self__, "mysqlx_zstd_max_client_compression_level", mysqlx_zstd_max_client_compression_level)
        if net_read_timeout is not None:
            pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        if net_write_timeout is not None:
            pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        if optimizer_switch is not None:
            pulumi.set(__self__, "optimizer_switch", optimizer_switch)
        if parser_max_mem_size is not None:
            pulumi.set(__self__, "parser_max_mem_size", parser_max_mem_size)
        if query_alloc_block_size is not None:
            pulumi.set(__self__, "query_alloc_block_size", query_alloc_block_size)
        if query_prealloc_size is not None:
            pulumi.set(__self__, "query_prealloc_size", query_prealloc_size)
        if range_optimizer_max_mem_size is not None:
            pulumi.set(__self__, "range_optimizer_max_mem_size", range_optimizer_max_mem_size)
        if regexp_time_limit is not None:
            pulumi.set(__self__, "regexp_time_limit", regexp_time_limit)
        if relay_log_space_limit is not None:
            pulumi.set(__self__, "relay_log_space_limit", relay_log_space_limit)
        if replica_net_timeout is not None:
            pulumi.set(__self__, "replica_net_timeout", replica_net_timeout)
        if replica_parallel_workers is not None:
            pulumi.set(__self__, "replica_parallel_workers", replica_parallel_workers)
        if replica_type_conversions is not None:
            pulumi.set(__self__, "replica_type_conversions", replica_type_conversions)
        if require_secure_transport is not None:
            pulumi.set(__self__, "require_secure_transport", require_secure_transport)
        if skip_name_resolve is not None:
            pulumi.set(__self__, "skip_name_resolve", skip_name_resolve)
        if sort_buffer_size is not None:
            pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        if sql_generate_invisible_primary_key is not None:
            pulumi.set(__self__, "sql_generate_invisible_primary_key", sql_generate_invisible_primary_key)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if sql_require_primary_key is not None:
            pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        if sql_warnings is not None:
            pulumi.set(__self__, "sql_warnings", sql_warnings)
        if table_definition_cache is not None:
            pulumi.set(__self__, "table_definition_cache", table_definition_cache)
        if table_open_cache is not None:
            pulumi.set(__self__, "table_open_cache", table_open_cache)
        if temptable_max_ram is not None:
            pulumi.set(__self__, "temptable_max_ram", temptable_max_ram)
        if thread_pool_dedicated_listeners is not None:
            pulumi.set(__self__, "thread_pool_dedicated_listeners", thread_pool_dedicated_listeners)
        if thread_pool_max_transactions_limit is not None:
            pulumi.set(__self__, "thread_pool_max_transactions_limit", thread_pool_max_transactions_limit)
        if thread_pool_query_threads_per_group is not None:
            pulumi.set(__self__, "thread_pool_query_threads_per_group", thread_pool_query_threads_per_group)
        if thread_pool_size is not None:
            pulumi.set(__self__, "thread_pool_size", thread_pool_size)
        if thread_pool_transaction_delay is not None:
            pulumi.set(__self__, "thread_pool_transaction_delay", thread_pool_transaction_delay)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tmp_table_size is not None:
            pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        if transaction_isolation is not None:
            pulumi.set(__self__, "transaction_isolation", transaction_isolation)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="autoIncrementIncrement")
    def auto_increment_increment(self) -> Optional[_builtins.int]:
        """
        auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.

        autoIncrementIncrement corresponds to the MySQL Replication Source Options variable [auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).
        """
        return pulumi.get(self, "auto_increment_increment")

    @_builtins.property
    @pulumi.getter(name="autoIncrementOffset")
    def auto_increment_offset(self) -> Optional[_builtins.int]:
        """
        This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.

        autoIncrementOffset corresponds to the MySQL Replication Source Options variable [auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).
        """
        return pulumi.get(self, "auto_increment_offset")

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> Optional[_builtins.bool]:
        """
        ("autocommit")
        """
        return pulumi.get(self, "autocommit")

    @_builtins.property
    @pulumi.getter(name="bigTables")
    def big_tables(self) -> Optional[_builtins.bool]:
        """
        If enabled, the server stores all temporary tables on disk rather than in memory.

        bigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).
        """
        return pulumi.get(self, "big_tables")

    @_builtins.property
    @pulumi.getter(name="binlogExpireLogsSeconds")
    def binlog_expire_logs_seconds(self) -> Optional[_builtins.int]:
        """
        Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        """
        return pulumi.get(self, "binlog_expire_logs_seconds")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncDelay")
    def binlog_group_commit_sync_delay(self) -> Optional[_builtins.int]:
        """
        Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.

        binlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable [binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)
        """
        return pulumi.get(self, "binlog_group_commit_sync_delay")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncNoDelayCount")
    def binlog_group_commit_sync_no_delay_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.

        binlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable [binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)
        """
        return pulumi.get(self, "binlog_group_commit_sync_no_delay_count")

    @_builtins.property
    @pulumi.getter(name="binlogRowMetadata")
    def binlog_row_metadata(self) -> Optional[_builtins.str]:
        """
        Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        """
        return pulumi.get(self, "binlog_row_metadata")

    @_builtins.property
    @pulumi.getter(name="binlogRowValueOptions")
    def binlog_row_value_options(self) -> Optional[_builtins.str]:
        """
        When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        """
        return pulumi.get(self, "binlog_row_value_options")

    @_builtins.property
    @pulumi.getter(name="binlogTransactionCompression")
    def binlog_transaction_compression(self) -> Optional[_builtins.bool]:
        """
        Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        """
        return pulumi.get(self, "binlog_transaction_compression")

    @_builtins.property
    @pulumi.getter(name="blockEncryptionMode")
    def block_encryption_mode(self) -> Optional[_builtins.str]:
        """
        This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.

        block_encryption_mode corresponds to the MySQL Server Administration system variable [block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)
        """
        return pulumi.get(self, "block_encryption_mode")

    @_builtins.property
    @pulumi.getter(name="characterSetServer")
    def character_set_server(self) -> Optional[_builtins.str]:
        """
        The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.

        characterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).
        """
        return pulumi.get(self, "character_set_server")

    @_builtins.property
    @pulumi.getter(name="collationServer")
    def collation_server(self) -> Optional[_builtins.str]:
        """
        The server's default collation.

        collationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).
        """
        return pulumi.get(self, "collation_server")

    @_builtins.property
    @pulumi.getter(name="completionType")
    def completion_type(self) -> Optional[_builtins.str]:
        """
        ("completion_type")
        """
        return pulumi.get(self, "completion_type")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.

        connectTimeout corresponds to the MySQL system variable [connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)

        Increasing the connect_timeout value might help if clients frequently encounter errors of the form "Lost connection to MySQL server at 'XXX', system error: errno".
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryChunkSize")
    def connection_memory_chunk_size(self) -> Optional[_builtins.int]:
        """
        Set the chunking size for updates to the global memory usage counter Global_connection_memory.

        connectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).
        """
        return pulumi.get(self, "connection_memory_chunk_size")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryLimit")
    def connection_memory_limit(self) -> Optional[_builtins.str]:
        """
        Set the maximum amount of memory that can be used by a single user connection.

        connectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).
        """
        return pulumi.get(self, "connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="cteMaxRecursionDepth")
    def cte_max_recursion_depth(self) -> Optional[_builtins.str]:
        """
        ("cte_max_recursion_depth")
        """
        return pulumi.get(self, "cte_max_recursion_depth")

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationPlugin")
    def default_authentication_plugin(self) -> Optional[_builtins.str]:
        """
        The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.

        As of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used, but in conjunction with and at a lower precedence than the authentication_policy system variable. For details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27 and subject to removal in a future MySQL version.

        defaultAuthenticationPlugin corresponds to the MySQL system variable [default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).
        """
        return pulumi.get(self, "default_authentication_plugin")

    @_builtins.property
    @pulumi.getter(name="explainFormat")
    def explain_format(self) -> Optional[_builtins.str]:
        """
        This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.

        explainFormat corresponds to the MySQL system variable [explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).
        """
        return pulumi.get(self, "explain_format")

    @_builtins.property
    @pulumi.getter(name="explicitDefaultsForTimestamp")
    def explicit_defaults_for_timestamp(self) -> Optional[_builtins.bool]:
        """
        This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.

        explicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable [explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)
        """
        return pulumi.get(self, "explicit_defaults_for_timestamp")

    @_builtins.property
    @pulumi.getter(name="foreignKeyChecks")
    def foreign_key_checks(self) -> Optional[_builtins.bool]:
        """
        ("foreign_key_checks")
        """
        return pulumi.get(self, "foreign_key_checks")

    @_builtins.property
    @pulumi.getter(name="generatedRandomPasswordLength")
    @_utilities.deprecated("""The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def generated_random_password_length(self) -> Optional[_builtins.int]:
        """
        ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "generated_random_password_length")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryLimit")
    def global_connection_memory_limit(self) -> Optional[_builtins.str]:
        """
        Set the total amount of memory that can be used by all user connections.

        globalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).
        """
        return pulumi.get(self, "global_connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryTracking")
    def global_connection_memory_tracking(self) -> Optional[_builtins.bool]:
        """
        Determines whether the MySQL server calculates Global_connection_memory.

        globalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).
        """
        return pulumi.get(self, "global_connection_memory_tracking")

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> Optional[_builtins.str]:
        """
        Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.

        This is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)
        """
        return pulumi.get(self, "group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="groupReplicationConsistency")
    def group_replication_consistency(self) -> Optional[_builtins.str]:
        """
        * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
        * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
        * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        """
        return pulumi.get(self, "group_replication_consistency")

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> Optional[_builtins.int]:
        """
        ("information_schema_stats_expiry")
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="innodbAdaptiveHashIndex")
    def innodb_adaptive_hash_index(self) -> Optional[_builtins.bool]:
        """
        Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.

        innodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).
        """
        return pulumi.get(self, "innodb_adaptive_hash_index")

    @_builtins.property
    @pulumi.getter(name="innodbAutoincLockMode")
    def innodb_autoinc_lock_mode(self) -> Optional[_builtins.int]:
        """
        The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.

        innodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).
        """
        return pulumi.get(self, "innodb_autoinc_lock_mode")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolDumpPct")
    def innodb_buffer_pool_dump_pct(self) -> Optional[_builtins.int]:
        """
        Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.

        innodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable [innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).

        The range is 1 to 100. The default value is 25.

        For example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25, the 25 most recently used pages from each buffer pool are dumped.
        """
        return pulumi.get(self, "innodb_buffer_pool_dump_pct")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolInstances")
    def innodb_buffer_pool_instances(self) -> Optional[_builtins.int]:
        """
        ("innodb_buffer_pool_instances")
        """
        return pulumi.get(self, "innodb_buffer_pool_instances")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolSize")
    def innodb_buffer_pool_size(self) -> Optional[_builtins.str]:
        """
        The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.

        innodbBufferPoolSize corresponds to the MySQL server system variable [innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).

        The default and maximum values depend on the amount of RAM provisioned by the shape. See [Default User Variables](https://www.terraform.io/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).
        """
        return pulumi.get(self, "innodb_buffer_pool_size")

    @_builtins.property
    @pulumi.getter(name="innodbChangeBuffering")
    def innodb_change_buffering(self) -> Optional[_builtins.str]:
        """
        Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.

        innodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
        """
        return pulumi.get(self, "innodb_change_buffering")

    @_builtins.property
    @pulumi.getter(name="innodbDdlBufferSize")
    def innodb_ddl_buffer_size(self) -> Optional[_builtins.str]:
        """
        innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        """
        return pulumi.get(self, "innodb_ddl_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbDdlThreads")
    def innodb_ddl_threads(self) -> Optional[_builtins.int]:
        """
        innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        """
        return pulumi.get(self, "innodb_ddl_threads")

    @_builtins.property
    @pulumi.getter(name="innodbFtEnableStopword")
    def innodb_ft_enable_stopword(self) -> Optional[_builtins.bool]:
        """
        ("innodb_ft_enable_stopword")
        """
        return pulumi.get(self, "innodb_ft_enable_stopword")

    @_builtins.property
    @pulumi.getter(name="innodbFtMaxTokenSize")
    def innodb_ft_max_token_size(self) -> Optional[_builtins.int]:
        """
        ("innodb_ft_max_token_size")
        """
        return pulumi.get(self, "innodb_ft_max_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> Optional[_builtins.int]:
        """
        ("innodb_ft_min_token_size")
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtNumWordOptimize")
    def innodb_ft_num_word_optimize(self) -> Optional[_builtins.int]:
        """
        ("innodb_ft_num_word_optimize")
        """
        return pulumi.get(self, "innodb_ft_num_word_optimize")

    @_builtins.property
    @pulumi.getter(name="innodbFtResultCacheLimit")
    def innodb_ft_result_cache_limit(self) -> Optional[_builtins.str]:
        """
        ("innodb_ft_result_cache_limit")
        """
        return pulumi.get(self, "innodb_ft_result_cache_limit")

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> Optional[_builtins.str]:
        """
        ("innodb_ft_server_stopword_table")
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> Optional[_builtins.int]:
        """
        ("innodb_lock_wait_timeout")
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbLogWriterThreads")
    def innodb_log_writer_threads(self) -> Optional[_builtins.bool]:
        """
        Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.

        This is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)
        """
        return pulumi.get(self, "innodb_log_writer_threads")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLag")
    def innodb_max_purge_lag(self) -> Optional[_builtins.str]:
        """
        The desired maximum purge lag in terms of transactions.

        InnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.

        If this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.

        The default value is 0, which means there is no maximum purge lag and no delay.

        innodbMaxPurgeLag corresponds to the MySQL server system variable [innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).
        """
        return pulumi.get(self, "innodb_max_purge_lag")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLagDelay")
    def innodb_max_purge_lag_delay(self) -> Optional[_builtins.int]:
        """
        The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.

        The specified innodb_max_purge_lag_delay value is an upper limit on the delay period.

        innodbMaxPurgeLagDelay corresponds to the MySQL server system variable [innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).
        """
        return pulumi.get(self, "innodb_max_purge_lag_delay")

    @_builtins.property
    @pulumi.getter(name="innodbNumaInterleave")
    def innodb_numa_interleave(self) -> Optional[_builtins.bool]:
        """
        Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.

        innodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).
        """
        return pulumi.get(self, "innodb_numa_interleave")

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> Optional[_builtins.str]:
        """
        Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.

        innodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbRedoLogCapacity")
    def innodb_redo_log_capacity(self) -> Optional[_builtins.str]:
        """
        Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.

        innodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables [innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)
        """
        return pulumi.get(self, "innodb_redo_log_capacity")

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> Optional[_builtins.bool]:
        """
        InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.

        innodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbSortBufferSize")
    def innodb_sort_buffer_size(self) -> Optional[_builtins.int]:
        """
        This variable defines:
        * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
        * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.

        innodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).
        """
        return pulumi.get(self, "innodb_sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbStatsPersistentSamplePages")
    def innodb_stats_persistent_sample_pages(self) -> Optional[_builtins.str]:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.

        innodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)

        innodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table; when innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.
        """
        return pulumi.get(self, "innodb_stats_persistent_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStatsTransientSamplePages")
    def innodb_stats_transient_sample_pages(self) -> Optional[_builtins.str]:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).

        innodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable [innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)

        innodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table; when innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.

        innodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the STATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and [ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.
        """
        return pulumi.get(self, "innodb_stats_transient_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStrictMode")
    def innodb_strict_mode(self) -> Optional[_builtins.bool]:
        """
        When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.

        innodbStrictMode corresponds to the MySQL InnoDB system variable [innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)
        """
        return pulumi.get(self, "innodb_strict_mode")

    @_builtins.property
    @pulumi.getter(name="innodbUndoLogTruncate")
    def innodb_undo_log_truncate(self) -> Optional[_builtins.bool]:
        """
        When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.

        innodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables [innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).
        """
        return pulumi.get(self, "innodb_undo_log_truncate")

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.

        interactiveTimeout corresponds to the MySQL system variable. [interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)
        """
        return pulumi.get(self, "interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="joinBufferSize")
    def join_buffer_size(self) -> Optional[_builtins.str]:
        """
        The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.

        joinBufferSize corresponds to the MySQL Server System variable [join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).
        """
        return pulumi.get(self, "join_buffer_size")

    @_builtins.property
    @pulumi.getter(name="localInfile")
    def local_infile(self) -> Optional[_builtins.bool]:
        """
        This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side. 

        local_infile corresponds to the MySQL Server system variable [local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)
        """
        return pulumi.get(self, "local_infile")

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> Optional[_builtins.int]:
        """
        If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.

        longQueryTime corresponds to the MySQL Server System variable [long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).
        """
        return pulumi.get(self, "long_query_time")

    @_builtins.property
    @pulumi.getter(name="mandatoryRoles")
    def mandatory_roles(self) -> Optional[_builtins.str]:
        """
        ("mandatory_roles")
        """
        return pulumi.get(self, "mandatory_roles")

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> Optional[_builtins.int]:
        """
        The maximum size of one packet or any generated/intermediate string.

        This is the mysql variable "max_allowed_packet".
        """
        return pulumi.get(self, "max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="maxBinlogCacheSize")
    def max_binlog_cache_size(self) -> Optional[_builtins.str]:
        """
        Sets the size of the transaction cache.

        maxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).
        """
        return pulumi.get(self, "max_binlog_cache_size")

    @_builtins.property
    @pulumi.getter(name="maxConnectErrors")
    def max_connect_errors(self) -> Optional[_builtins.str]:
        """
        ("max_connect_errors")
        """
        return pulumi.get(self, "max_connect_errors")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        ("max_connections")
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxExecutionTime")
    def max_execution_time(self) -> Optional[_builtins.str]:
        """
        ("max_execution_time")
        """
        return pulumi.get(self, "max_execution_time")

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> Optional[_builtins.str]:
        """
        This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.

        maxHeapTableSize corresponds to the MySQL system variable [max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)
        """
        return pulumi.get(self, "max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="maxPreparedStmtCount")
    def max_prepared_stmt_count(self) -> Optional[_builtins.int]:
        """
        ("max_prepared_stmt_count")
        """
        return pulumi.get(self, "max_prepared_stmt_count")

    @_builtins.property
    @pulumi.getter(name="maxSeeksForKey")
    def max_seeks_for_key(self) -> Optional[_builtins.str]:
        """
        Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.

        maxSeeksForKey corresponds to the MySQL Server System variable [max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).
        """
        return pulumi.get(self, "max_seeks_for_key")

    @_builtins.property
    @pulumi.getter(name="maxUserConnections")
    def max_user_connections(self) -> Optional[_builtins.str]:
        """
        The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.

        maxUserConnections corresponds to the MySQL Server System variable [max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).
        """
        return pulumi.get(self, "max_user_connections")

    @_builtins.property
    @pulumi.getter(name="mysqlFirewallMode")
    def mysql_firewall_mode(self) -> Optional[_builtins.bool]:
        """
        ("mysql_firewall_mode")
        """
        return pulumi.get(self, "mysql_firewall_mode")

    @_builtins.property
    @pulumi.getter(name="mysqlZstdDefaultCompressionLevel")
    @_utilities.deprecated("""The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysql_zstd_default_compression_level(self) -> Optional[_builtins.int]:
        """
        DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        """
        return pulumi.get(self, "mysql_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxConnectTimeout")
    def mysqlx_connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds X Plugin waits for the first packet to be received from newly connected clients.

        mysqlxConnectTimeout corresponds to the MySQL X Plugin system variable [mysqlx_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_connect_timeout)
        """
        return pulumi.get(self, "mysqlx_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateDefaultCompressionLevel")
    def mysqlx_deflate_default_compression_level(self) -> Optional[_builtins.int]:
        """
        Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateMaxClientCompressionLevel")
    def mysqlx_deflate_max_client_compression_level(self) -> Optional[_builtins.int]:
        """
        Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDocumentIdUniquePrefix")
    @_utilities.deprecated("""The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_document_id_unique_prefix(self) -> Optional[_builtins.int]:
        """
        ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_document_id_unique_prefix")

    @_builtins.property
    @pulumi.getter(name="mysqlxEnableHelloNotice")
    def mysqlx_enable_hello_notice(self) -> Optional[_builtins.bool]:
        """
        ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_enable_hello_notice")

    @_builtins.property
    @pulumi.getter(name="mysqlxIdleWorkerThreadTimeout")
    @_utilities.deprecated("""The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_idle_worker_thread_timeout(self) -> Optional[_builtins.int]:
        """
        ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_idle_worker_thread_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxInteractiveTimeout")
    def mysqlx_interactive_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to wait for interactive clients to timeout.

        mysqlxInteractiveTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_interactive_timeout)
        """
        return pulumi.get(self, "mysqlx_interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4defaultCompressionLevel")
    def mysqlx_lz4default_compression_level(self) -> Optional[_builtins.int]:
        """
        Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4maxClientCompressionLevel")
    def mysqlx_lz4max_client_compression_level(self) -> Optional[_builtins.int]:
        """
        Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxMaxAllowedPacket")
    def mysqlx_max_allowed_packet(self) -> Optional[_builtins.int]:
        """
        The maximum size of network packets that can be received by X Plugin.

        This is the mysql variable "mysqlx_max_allowed_packet".
        """
        return pulumi.get(self, "mysqlx_max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="mysqlxMinWorkerThreads")
    @_utilities.deprecated("""The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_min_worker_threads(self) -> Optional[_builtins.int]:
        """
        ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_min_worker_threads")

    @_builtins.property
    @pulumi.getter(name="mysqlxReadTimeout")
    def mysqlx_read_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.

        mysqlxReadTimeout corresponds to the MySQL X Plugin system variable [mysqlx_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_read_timeout)
        """
        return pulumi.get(self, "mysqlx_read_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWaitTimeout")
    def mysqlx_wait_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds that X Plugin waits for activity on a connection.

        mysqlxWaitTimeout corresponds to the MySQL X Plugin system variable. [mysqlx_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_wait_timeout)
        """
        return pulumi.get(self, "mysqlx_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWriteTimeout")
    def mysqlx_write_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.

        mysqlxReadmysqlxWriteTimeoutTimeout corresponds to the MySQL X Plugin system variable [mysqlx_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html#sysvar_mysqlx_write_timeout)
        """
        return pulumi.get(self, "mysqlx_write_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdDefaultCompressionLevel")
    def mysqlx_zstd_default_compression_level(self) -> Optional[_builtins.int]:
        """
        Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdMaxClientCompressionLevel")
    def mysqlx_zstd_max_client_compression_level(self) -> Optional[_builtins.int]:
        """
        Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.

        netReadTimeout corresponds to the MySQL system variable [net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)
        """
        return pulumi.get(self, "net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.

        netWriteTimeout corresponds to the MySQL system variable [net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)
        """
        return pulumi.get(self, "net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="optimizerSwitch")
    def optimizer_switch(self) -> Optional[_builtins.str]:
        """
        The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.

        Setting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.

        optimizerSwitch corresponds to the MySQL Server System variable [optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).
        """
        return pulumi.get(self, "optimizer_switch")

    @_builtins.property
    @pulumi.getter(name="parserMaxMemSize")
    def parser_max_mem_size(self) -> Optional[_builtins.str]:
        """
        ("parser_max_mem_size")
        """
        return pulumi.get(self, "parser_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="queryAllocBlockSize")
    @_utilities.deprecated("""The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def query_alloc_block_size(self) -> Optional[_builtins.str]:
        """
        ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_alloc_block_size")

    @_builtins.property
    @pulumi.getter(name="queryPreallocSize")
    def query_prealloc_size(self) -> Optional[_builtins.str]:
        """
        ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_prealloc_size")

    @_builtins.property
    @pulumi.getter(name="rangeOptimizerMaxMemSize")
    @_utilities.deprecated("""The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def range_optimizer_max_mem_size(self) -> Optional[_builtins.str]:
        """
        The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans. 

        rangeOptimizerMaxMemSize corresponds to the MySQL Server System variable [range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).
        """
        return pulumi.get(self, "range_optimizer_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="regexpTimeLimit")
    def regexp_time_limit(self) -> Optional[_builtins.int]:
        """
        regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        """
        return pulumi.get(self, "regexp_time_limit")

    @_builtins.property
    @pulumi.getter(name="relayLogSpaceLimit")
    def relay_log_space_limit(self) -> Optional[_builtins.str]:
        """
        The maximum amount of space to use for all relay logs.

        relayLogSpaceLimit corresponds to the MySQL Replica Server Options variable [relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).
        """
        return pulumi.get(self, "relay_log_space_limit")

    @_builtins.property
    @pulumi.getter(name="replicaNetTimeout")
    def replica_net_timeout(self) -> Optional[_builtins.int]:
        """
        Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.

        replicaNetTimeout corresponds to the MySQL Replica server system variable [replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)
        """
        return pulumi.get(self, "replica_net_timeout")

    @_builtins.property
    @pulumi.getter(name="replicaParallelWorkers")
    def replica_parallel_workers(self) -> Optional[_builtins.int]:
        """
        Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)

        replicaParallelWorkers corresponds to the MySQL Replica Server Options variable [replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).
        """
        return pulumi.get(self, "replica_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="replicaTypeConversions")
    def replica_type_conversions(self) -> Optional[_builtins.str]:
        """
        From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.

        replica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication. Its value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED. Set this variable to an empty string to disallow type conversions between the source and the replica. Setting this variable takes effect for all replication channels immediately, including running channels.

        replica_type_conversions corresponds to the MySQL Replica Server Options variable [replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).
        """
        return pulumi.get(self, "replica_type_conversions")

    @_builtins.property
    @pulumi.getter(name="requireSecureTransport")
    def require_secure_transport(self) -> Optional[_builtins.bool]:
        """
        Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.

        require_secure_transport corresponds to the MySQL Server Administration system variable [require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)
        """
        return pulumi.get(self, "require_secure_transport")

    @_builtins.property
    @pulumi.getter(name="skipNameResolve")
    def skip_name_resolve(self) -> Optional[_builtins.bool]:
        """
        Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.

        skipNameResolve corresponds to the MySQL Server System variable [skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).
        """
        return pulumi.get(self, "skip_name_resolve")

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> Optional[_builtins.str]:
        """
        Each session that must perform a sort allocates a buffer of this size.

        sortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)
        """
        return pulumi.get(self, "sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="sqlGenerateInvisiblePrimaryKey")
    def sql_generate_invisible_primary_key(self) -> Optional[_builtins.bool]:
        """
        Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.

        sqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable [sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).
        """
        return pulumi.get(self, "sql_generate_invisible_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[_builtins.str]:
        """
        ("sql_mode")
        """
        return pulumi.get(self, "sql_mode")

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> Optional[_builtins.bool]:
        """
        ("sql_require_primary_key")
        """
        return pulumi.get(self, "sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlWarnings")
    def sql_warnings(self) -> Optional[_builtins.bool]:
        """
        ("sql_warnings")
        """
        return pulumi.get(self, "sql_warnings")

    @_builtins.property
    @pulumi.getter(name="tableDefinitionCache")
    def table_definition_cache(self) -> Optional[_builtins.int]:
        """
        The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.

        table_definition_cache corresponds to the MySQL Server Administration system variable [table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)
        """
        return pulumi.get(self, "table_definition_cache")

    @_builtins.property
    @pulumi.getter(name="tableOpenCache")
    def table_open_cache(self) -> Optional[_builtins.int]:
        """
        The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.

        table_open_cache corresponds to the MySQL Server Administration system variable [table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)
        """
        return pulumi.get(self, "table_open_cache")

    @_builtins.property
    @pulumi.getter(name="temptableMaxRam")
    def temptable_max_ram(self) -> Optional[_builtins.str]:
        """
        Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.

        temptableMaxRam corresponds to the MySQL system variable [temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).
        """
        return pulumi.get(self, "temptable_max_ram")

    @_builtins.property
    @pulumi.getter(name="threadPoolDedicatedListeners")
    def thread_pool_dedicated_listeners(self) -> Optional[_builtins.bool]:
        """
        Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        """
        return pulumi.get(self, "thread_pool_dedicated_listeners")

    @_builtins.property
    @pulumi.getter(name="threadPoolMaxTransactionsLimit")
    def thread_pool_max_transactions_limit(self) -> Optional[_builtins.int]:
        """
        Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        """
        return pulumi.get(self, "thread_pool_max_transactions_limit")

    @_builtins.property
    @pulumi.getter(name="threadPoolQueryThreadsPerGroup")
    def thread_pool_query_threads_per_group(self) -> Optional[_builtins.int]:
        """
        The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions. 

        threadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable [thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)
        """
        return pulumi.get(self, "thread_pool_query_threads_per_group")

    @_builtins.property
    @pulumi.getter(name="threadPoolSize")
    def thread_pool_size(self) -> Optional[_builtins.int]:
        """
        The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.

        threadPoolSize corresponds to the MySQL Server System variable [thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).
        """
        return pulumi.get(self, "thread_pool_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolTransactionDelay")
    def thread_pool_transaction_delay(self) -> Optional[_builtins.int]:
        """
        The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running. 

        threadPoolTransactionDelay corresponds to the MySQL Server system variable [thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)
        """
        return pulumi.get(self, "thread_pool_transaction_delay")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        Initializes the time zone for each client that connects.

        This corresponds to the MySQL System Variable "time_zone".

        The values can be given in one of the following formats, none of which are case-sensitive:
        * As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as '+10:00', '-6:00', or '+05:30'. The permitted range is '-13:59' to '+14:00', inclusive.
        * As a named time zone, as defined by the "IANA Time Zone database", such as 'Europe/Helsinki', 'US/Eastern', 'MET', or 'UTC'.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> Optional[_builtins.str]:
        """
        The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.

        tmp_table_size corresponds to the MySQL system variable [tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)
        """
        return pulumi.get(self, "tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="transactionIsolation")
    def transaction_isolation(self) -> Optional[_builtins.str]:
        """
        ("transaction_isolation")
        """
        return pulumi.get(self, "transaction_isolation")

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.

        waitTimeout corresponds to the MySQL system variable. [wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wait_timeout")


@pulumi.output_type
class MysqlDbSystemBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyPolicies":
            suggest = "copy_policies"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "pitrPolicy":
            suggest = "pitr_policy"
        elif key == "retentionInDays":
            suggest = "retention_in_days"
        elif key == "softDelete":
            suggest = "soft_delete"
        elif key == "windowStartTime":
            suggest = "window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_policies: Optional[Sequence['outputs.MysqlDbSystemBackupPolicyCopyPolicy']] = None,
                 defined_tags: Optional[Mapping[str, _builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, _builtins.str]] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 pitr_policy: Optional['outputs.MysqlDbSystemBackupPolicyPitrPolicy'] = None,
                 retention_in_days: Optional[_builtins.int] = None,
                 soft_delete: Optional[_builtins.str] = None,
                 window_start_time: Optional[_builtins.str] = None):
        """
        :param Sequence['MysqlDbSystemBackupPolicyCopyPolicyArgs'] copy_policies: (Updatable) List of policies of a DB system to schedule cross-region DB system backup copy.
               
               The policy includes the name of the destination region to which the DB system backup will be copied, and an optional parameter which specifies the retention period of the copied DB system backup in days.
               
               **Note:** Currently, only one policy can be specified in the list.
        :param Mapping[str, _builtins.str] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces.
               
               Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.
               
               Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, _builtins.str] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
               
               Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.
               
               Example: `{"bar-key": "value"}`
        :param _builtins.bool is_enabled: (Updatable) Specifies if automatic backups are enabled.
        :param 'MysqlDbSystemBackupPolicyPitrPolicyArgs' pitr_policy: (Updatable) The PITR policy for the DB System.
        :param _builtins.int retention_in_days: (Updatable) Number of days to retain an automatic backup.
        :param _builtins.str soft_delete: (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param _builtins.str window_start_time: (Updatable) The start of a 30-minute window of time in which daily, automated backups occur.
               
               This should be in the format of the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
               
               At some point in the window, the system may incur a brief service disruption as the backup is performed.
        """
        if copy_policies is not None:
            pulumi.set(__self__, "copy_policies", copy_policies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if pitr_policy is not None:
            pulumi.set(__self__, "pitr_policy", pitr_policy)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if soft_delete is not None:
            pulumi.set(__self__, "soft_delete", soft_delete)
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Optional[Sequence['outputs.MysqlDbSystemBackupPolicyCopyPolicy']]:
        """
        (Updatable) List of policies of a DB system to schedule cross-region DB system backup copy.

        The policy includes the name of the destination region to which the DB system backup will be copied, and an optional parameter which specifies the retention period of the copied DB system backup in days.

        **Note:** Currently, only one policy can be specified in the list.
        """
        return pulumi.get(self, "copy_policies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Specifies if automatic backups are enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="pitrPolicy")
    def pitr_policy(self) -> Optional['outputs.MysqlDbSystemBackupPolicyPitrPolicy']:
        """
        (Updatable) The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policy")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of days to retain an automatic backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[_builtins.str]:
        """
        (Updatable) Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[_builtins.str]:
        """
        (Updatable) The start of a 30-minute window of time in which daily, automated backups occur.

        This should be in the format of the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        At some point in the window, the system may incur a brief service disruption as the backup is performed.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class MysqlDbSystemBackupPolicyCopyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyToRegion":
            suggest = "copy_to_region"
        elif key == "backupCopyRetentionInDays":
            suggest = "backup_copy_retention_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemBackupPolicyCopyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemBackupPolicyCopyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemBackupPolicyCopyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_to_region: _builtins.str,
                 backup_copy_retention_in_days: Optional[_builtins.int] = None):
        """
        :param _builtins.str copy_to_region: (Updatable) The destination region name to which the DB system backup will be copied.
        :param _builtins.int backup_copy_retention_in_days: (Updatable) Number of days to retain the copied DB system backup.
        """
        pulumi.set(__self__, "copy_to_region", copy_to_region)
        if backup_copy_retention_in_days is not None:
            pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)

    @_builtins.property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> _builtins.str:
        """
        (Updatable) The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")

    @_builtins.property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")


@pulumi.output_type
class MysqlDbSystemBackupPolicyPitrPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemBackupPolicyPitrPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemBackupPolicyPitrPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemBackupPolicyPitrPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_enabled: (Updatable) Specifies if PITR is enabled or disabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Specifies if PITR is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class MysqlDbSystemChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "systemTags":
            suggest = "system_tags"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[_builtins.str] = None,
                 defined_tags: Optional[Mapping[str, _builtins.str]] = None,
                 display_name: Optional[_builtins.str] = None,
                 freeform_tags: Optional[Mapping[str, _builtins.str]] = None,
                 id: Optional[_builtins.str] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 lifecycle_details: Optional[_builtins.str] = None,
                 sources: Optional[Sequence['outputs.MysqlDbSystemChannelSource']] = None,
                 state: Optional[_builtins.str] = None,
                 system_tags: Optional[Mapping[str, _builtins.str]] = None,
                 targets: Optional[Sequence['outputs.MysqlDbSystemChannelTarget']] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param Mapping[str, _builtins.str] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the DB System.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str lifecycle_details: Additional information about the current lifecycleState.
        :param Sequence['MysqlDbSystemChannelSourceArgs'] sources: Parameters detailing how to provision the initial data of the system.
        :param _builtins.str state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['MysqlDbSystemChannelTargetArgs'] targets: Details about the Channel target.
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[_builtins.str]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.MysqlDbSystemChannelSource']]:
        """
        Parameters detailing how to provision the initial data of the system.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.MysqlDbSystemChannelTarget']]:
        """
        Details about the Channel target.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[_builtins.str]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class MysqlDbSystemChannelSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anonymousTransactionsHandlings":
            suggest = "anonymous_transactions_handlings"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "sslCaCertificates":
            suggest = "ssl_ca_certificates"
        elif key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemChannelSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemChannelSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemChannelSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anonymous_transactions_handlings: Optional[Sequence['outputs.MysqlDbSystemChannelSourceAnonymousTransactionsHandling']] = None,
                 hostname: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 source_type: Optional[_builtins.str] = None,
                 ssl_ca_certificates: Optional[Sequence['outputs.MysqlDbSystemChannelSourceSslCaCertificate']] = None,
                 ssl_mode: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param Sequence['MysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.int port: The port for primary endpoint of the DB System to listen on.
        :param _builtins.str source_type: The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        :param Sequence['MysqlDbSystemChannelSourceSslCaCertificateArgs'] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param _builtins.str ssl_mode: The SSL mode of the Channel.
        :param _builtins.str username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        if anonymous_transactions_handlings is not None:
            pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if ssl_ca_certificates is not None:
            pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Optional[Sequence['outputs.MysqlDbSystemChannelSourceAnonymousTransactionsHandling']]:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[_builtins.str]:
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Optional[Sequence['outputs.MysqlDbSystemChannelSourceSslCaCertificate']]:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[_builtins.str]:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MysqlDbSystemChannelSourceAnonymousTransactionsHandling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastConfiguredLogFilename":
            suggest = "last_configured_log_filename"
        elif key == "lastConfiguredLogOffset":
            suggest = "last_configured_log_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemChannelSourceAnonymousTransactionsHandling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemChannelSourceAnonymousTransactionsHandling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemChannelSourceAnonymousTransactionsHandling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_configured_log_filename: Optional[_builtins.str] = None,
                 last_configured_log_offset: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str policy: Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        if last_configured_log_filename is not None:
            pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        if last_configured_log_offset is not None:
            pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> Optional[_builtins.str]:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> Optional[_builtins.str]:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class MysqlDbSystemChannelSourceSslCaCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemChannelSourceSslCaCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemChannelSourceSslCaCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemChannelSourceSslCaCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: Optional[_builtins.str] = None,
                 contents: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_type: The type of CA certificate.
        :param _builtins.str contents: The string containing the CA certificate in PEM format.
        """
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if contents is not None:
            pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[_builtins.str]:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> Optional[_builtins.str]:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class MysqlDbSystemChannelTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applierUsername":
            suggest = "applier_username"
        elif key == "channelName":
            suggest = "channel_name"
        elif key == "dbSystemId":
            suggest = "db_system_id"
        elif key == "delayInSeconds":
            suggest = "delay_in_seconds"
        elif key == "tablesWithoutPrimaryKeyHandling":
            suggest = "tables_without_primary_key_handling"
        elif key == "targetType":
            suggest = "target_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemChannelTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemChannelTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemChannelTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applier_username: Optional[_builtins.str] = None,
                 channel_name: Optional[_builtins.str] = None,
                 db_system_id: Optional[_builtins.str] = None,
                 delay_in_seconds: Optional[_builtins.int] = None,
                 filters: Optional[Sequence['outputs.MysqlDbSystemChannelTargetFilter']] = None,
                 tables_without_primary_key_handling: Optional[_builtins.str] = None,
                 target_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str applier_username: The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.str db_system_id: The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        :param _builtins.int delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['MysqlDbSystemChannelTargetFilterArgs'] filters: Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param _builtins.str target_type: The specific target identifier.
        """
        if applier_username is not None:
            pulumi.set(__self__, "applier_username", applier_username)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if delay_in_seconds is not None:
            pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if tables_without_primary_key_handling is not None:
            pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> Optional[_builtins.str]:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[_builtins.str]:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.MysqlDbSystemChannelTargetFilter']]:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> Optional[_builtins.str]:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class MysqlDbSystemChannelTargetFilter(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the filter rule.
        :param _builtins.str value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MysqlDbSystemCurrentPlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "faultDomain":
            suggest = "fault_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemCurrentPlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemCurrentPlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemCurrentPlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: Optional[_builtins.str] = None,
                 fault_domain: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param _builtins.str fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[_builtins.str]:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        return pulumi.get(self, "fault_domain")


@pulumi.output_type
class MysqlDbSystemCustomerContact(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        """
        :param _builtins.str email: (Updatable) The email address used by Oracle to send notifications regarding the DB System.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        (Updatable) The email address used by Oracle to send notifications regarding the DB System.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class MysqlDbSystemDataStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedStorageSizeInGbs":
            suggest = "allocated_storage_size_in_gbs"
        elif key == "dataStorageSizeInGb":
            suggest = "data_storage_size_in_gb"
        elif key == "dataStorageSizeLimitInGbs":
            suggest = "data_storage_size_limit_in_gbs"
        elif key == "isAutoExpandStorageEnabled":
            suggest = "is_auto_expand_storage_enabled"
        elif key == "maxStorageSizeInGbs":
            suggest = "max_storage_size_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemDataStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemDataStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemDataStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: Optional[_builtins.int] = None,
                 data_storage_size_in_gb: Optional[_builtins.int] = None,
                 data_storage_size_limit_in_gbs: Optional[_builtins.int] = None,
                 is_auto_expand_storage_enabled: Optional[_builtins.bool] = None,
                 max_storage_size_in_gbs: Optional[_builtins.int] = None):
        """
        :param _builtins.int allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param _builtins.int data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param _builtins.int data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param _builtins.bool is_auto_expand_storage_enabled: (Updatable) Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param _builtins.int max_storage_size_in_gbs: (Updatable) Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
               
               DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB. DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB. DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB. DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.
               
               It is not possible to decrease data storage size. You cannot set the maximum data storage size to less than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.
        """
        if allocated_storage_size_in_gbs is not None:
            pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_limit_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        if is_auto_expand_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        if max_storage_size_in_gbs is not None:
            pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> Optional[_builtins.int]:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[_builtins.int]:
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> Optional[_builtins.int]:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> Optional[_builtins.int]:
        """
        (Updatable) Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB. DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB. DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB. DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size. You cannot set the maximum data storage size to less than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")


@pulumi.output_type
class MysqlDbSystemDeletionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticBackupRetention":
            suggest = "automatic_backup_retention"
        elif key == "finalBackup":
            suggest = "final_backup"
        elif key == "isDeleteProtected":
            suggest = "is_delete_protected"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemDeletionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemDeletionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemDeletionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_backup_retention: Optional[_builtins.str] = None,
                 final_backup: Optional[_builtins.str] = None,
                 is_delete_protected: Optional[_builtins.bool] = None):
        """
        :param _builtins.str automatic_backup_retention: (Updatable) Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param _builtins.str final_backup: (Updatable) Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param _builtins.bool is_delete_protected: (Updatable) Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        if automatic_backup_retention is not None:
            pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        if final_backup is not None:
            pulumi.set(__self__, "final_backup", final_backup)
        if is_delete_protected is not None:
            pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @_builtins.property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> Optional[_builtins.str]:
        """
        (Updatable) Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @_builtins.property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> Optional[_builtins.str]:
        """
        (Updatable) Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")


@pulumi.output_type
class MysqlDbSystemEncryptData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyGenerationType":
            suggest = "key_generation_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemEncryptData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemEncryptData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemEncryptData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_generation_type: (Updatable) Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: (Updatable) The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        (Updatable) Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class MysqlDbSystemEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "portX":
            suggest = "port_x"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "statusDetails":
            suggest = "status_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 modes: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None,
                 port_x: Optional[_builtins.int] = None,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 status_details: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param Sequence[_builtins.str] modes: The access modes from the client that this endpoint supports.
        :param _builtins.int port: The port for primary endpoint of the DB System to listen on.
        :param _builtins.int port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param _builtins.str resource_id: The OCID of the resource that this endpoint is attached to.
        :param _builtins.str resource_type: The type of endpoint that clients and connectors can connect to.
        :param _builtins.str status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param _builtins.str status_details: Additional information about the current endpoint status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[_builtins.int]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[_builtins.str]:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")


@pulumi.output_type
class MysqlDbSystemHeatWaveCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterSize":
            suggest = "cluster_size"
        elif key == "isLakehouseEnabled":
            suggest = "is_lakehouse_enabled"
        elif key == "shapeName":
            suggest = "shape_name"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemHeatWaveCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemHeatWaveCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemHeatWaveCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_size: Optional[_builtins.int] = None,
                 is_lakehouse_enabled: Optional[_builtins.bool] = None,
                 shape_name: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_updated: Optional[_builtins.str] = None):
        """
        :param _builtins.int cluster_size: The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        :param _builtins.bool is_lakehouse_enabled: Lakehouse enabled status for the HeatWave cluster.
        :param _builtins.str shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param _builtins.str state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if is_lakehouse_enabled is not None:
            pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[_builtins.int]:
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> Optional[_builtins.bool]:
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[_builtins.str]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class MysqlDbSystemMaintenance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowStartTime":
            suggest = "window_start_time"
        elif key == "maintenanceScheduleType":
            suggest = "maintenance_schedule_type"
        elif key == "targetVersion":
            suggest = "target_version"
        elif key == "timeScheduled":
            suggest = "time_scheduled"
        elif key == "versionPreference":
            suggest = "version_preference"
        elif key == "versionTrackPreference":
            suggest = "version_track_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemMaintenance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemMaintenance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemMaintenance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 window_start_time: _builtins.str,
                 maintenance_schedule_type: Optional[_builtins.str] = None,
                 target_version: Optional[_builtins.str] = None,
                 time_scheduled: Optional[_builtins.str] = None,
                 version_preference: Optional[_builtins.str] = None,
                 version_track_preference: Optional[_builtins.str] = None):
        """
        :param _builtins.str window_start_time: (Updatable) The start of the 2 hour maintenance window.
               
               This string is of the format: "{day-of-week} {time-of-day}".
               
               "{day-of-week}" is a case-insensitive string like "mon", "tue", &c.
               
               "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.
               
               If you set the read replica maintenance window to "" or if not specified, the read replica is set same as the DB system maintenance window.
        :param _builtins.str maintenance_schedule_type: (Updatable) The maintenance schedule type of the DB system. Defaults to REGULAR. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        :param _builtins.str target_version: The version that is expected to be targeted during the next scheduled maintenance run.
        :param _builtins.str time_scheduled: The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str version_preference: (Updatable) The preferred version to target when performing an automatic MySQL upgrade. Defaults to OLDEST.
               
               OLDEST: Choose the oldest available MySQL version based on the current version of the DB System. SECOND_NEWEST: Choose the MySQL version before the newest for auto-upgrade. NEWEST: Choose the latest and greatest MySQL version available for auto-upgrade.
        :param _builtins.str version_track_preference: (Updatable) The preferred version track to target when performing an automatic MySQL upgrade. Defaults to FOLLOW. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        pulumi.set(__self__, "window_start_time", window_start_time)
        if maintenance_schedule_type is not None:
            pulumi.set(__self__, "maintenance_schedule_type", maintenance_schedule_type)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if time_scheduled is not None:
            pulumi.set(__self__, "time_scheduled", time_scheduled)
        if version_preference is not None:
            pulumi.set(__self__, "version_preference", version_preference)
        if version_track_preference is not None:
            pulumi.set(__self__, "version_track_preference", version_track_preference)

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        (Updatable) The start of the 2 hour maintenance window.

        This string is of the format: "{day-of-week} {time-of-day}".

        "{day-of-week}" is a case-insensitive string like "mon", "tue", &c.

        "{time-of-day}" is the "Time" portion of an RFC3339-formatted timestamp. Any second or sub-second time data will be truncated to zero.

        If you set the read replica maintenance window to "" or if not specified, the read replica is set same as the DB system maintenance window.
        """
        return pulumi.get(self, "window_start_time")

    @_builtins.property
    @pulumi.getter(name="maintenanceScheduleType")
    def maintenance_schedule_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The maintenance schedule type of the DB system. Defaults to REGULAR. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        """
        return pulumi.get(self, "maintenance_schedule_type")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[_builtins.str]:
        """
        The version that is expected to be targeted during the next scheduled maintenance run.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> Optional[_builtins.str]:
        """
        The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> Optional[_builtins.str]:
        """
        (Updatable) The preferred version to target when performing an automatic MySQL upgrade. Defaults to OLDEST.

        OLDEST: Choose the oldest available MySQL version based on the current version of the DB System. SECOND_NEWEST: Choose the MySQL version before the newest for auto-upgrade. NEWEST: Choose the latest and greatest MySQL version available for auto-upgrade.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="versionTrackPreference")
    def version_track_preference(self) -> Optional[_builtins.str]:
        """
        (Updatable) The preferred version track to target when performing an automatic MySQL upgrade. Defaults to FOLLOW. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        return pulumi.get(self, "version_track_preference")


@pulumi.output_type
class MysqlDbSystemPointInTimeRecoveryDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeEarliestRecoveryPoint":
            suggest = "time_earliest_recovery_point"
        elif key == "timeLatestRecoveryPoint":
            suggest = "time_latest_recovery_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemPointInTimeRecoveryDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemPointInTimeRecoveryDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemPointInTimeRecoveryDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_earliest_recovery_point: Optional[_builtins.str] = None,
                 time_latest_recovery_point: Optional[_builtins.str] = None):
        """
        :param _builtins.str time_earliest_recovery_point: Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_latest_recovery_point: Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if time_earliest_recovery_point is not None:
            pulumi.set(__self__, "time_earliest_recovery_point", time_earliest_recovery_point)
        if time_latest_recovery_point is not None:
            pulumi.set(__self__, "time_latest_recovery_point", time_latest_recovery_point)

    @_builtins.property
    @pulumi.getter(name="timeEarliestRecoveryPoint")
    def time_earliest_recovery_point(self) -> Optional[_builtins.str]:
        """
        Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_earliest_recovery_point")

    @_builtins.property
    @pulumi.getter(name="timeLatestRecoveryPoint")
    def time_latest_recovery_point(self) -> Optional[_builtins.str]:
        """
        Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_latest_recovery_point")


@pulumi.output_type
class MysqlDbSystemReadEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeIps":
            suggest = "exclude_ips"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "readEndpointHostnameLabel":
            suggest = "read_endpoint_hostname_label"
        elif key == "readEndpointIpAddress":
            suggest = "read_endpoint_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemReadEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemReadEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemReadEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_ips: Optional[Sequence[_builtins.str]] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 read_endpoint_hostname_label: Optional[_builtins.str] = None,
                 read_endpoint_ip_address: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclude_ips: (Updatable) A list of IP addresses of read replicas that are excluded from serving read requests.
        :param _builtins.bool is_enabled: (Updatable) Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str read_endpoint_hostname_label: (Updatable) The hostname for the read endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)  (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param _builtins.str read_endpoint_ip_address: (Updatable) The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        if exclude_ips is not None:
            pulumi.set(__self__, "exclude_ips", exclude_ips)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if read_endpoint_hostname_label is not None:
            pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        if read_endpoint_ip_address is not None:
            pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @_builtins.property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> Optional[_builtins.str]:
        """
        (Updatable) The hostname for the read endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)  (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @_builtins.property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> Optional[_builtins.str]:
        """
        (Updatable) The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")


@pulumi.output_type
class MysqlDbSystemRest(dict):
    def __init__(__self__, *,
                 configuration: _builtins.str,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str configuration: (Updatable) Select how REST is configured across the DB System instances.
        :param _builtins.int port: (Updatable) The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        pulumi.set(__self__, "configuration", configuration)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> _builtins.str:
        """
        (Updatable) Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        (Updatable) The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class MysqlDbSystemSecureConnections(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateGenerationType":
            suggest = "certificate_generation_type"
        elif key == "certificateId":
            suggest = "certificate_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemSecureConnections. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemSecureConnections.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemSecureConnections.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_generation_type: (Updatable) Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: (Updatable) The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        (Updatable) Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class MysqlDbSystemSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "backupId":
            suggest = "backup_id"
        elif key == "dbSystemId":
            suggest = "db_system_id"
        elif key == "recoveryPoint":
            suggest = "recovery_point"
        elif key == "sourceUrl":
            suggest = "source_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDbSystemSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDbSystemSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDbSystemSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: _builtins.str,
                 backup_id: Optional[_builtins.str] = None,
                 db_system_id: Optional[_builtins.str] = None,
                 recovery_point: Optional[_builtins.str] = None,
                 source_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_type: The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        :param _builtins.str backup_id: The OCID of the backup to be used as the source for the new DB System.
        :param _builtins.str db_system_id: The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        :param _builtins.str recovery_point: The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        :param _builtins.str source_url: The Pre-Authenticated Request (PAR) of a bucket/prefix or PAR of a @.manifest.json object from the Object Storage. Check [Using Pre-Authenticated Requests](https://docs.oracle.com/en-us/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm) for information related to PAR creation. Please create PAR with "Permit object reads" access type and "Enable Object Listing" permission when using a bucket/prefix PAR. Please create PAR with "Permit object reads" access type when using a @.manifest.json object PAR.
        """
        pulumi.set(__self__, "source_type", source_type)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if recovery_point is not None:
            pulumi.set(__self__, "recovery_point", recovery_point)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier. Use `BACKUP` for creating a new database by restoring from a backup. Use `IMPORTURL` for creating a new database from a URL Object Storage PAR.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the backup to be used as the source for the new DB System.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPoint")
    def recovery_point(self) -> Optional[_builtins.str]:
        """
        The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        """
        return pulumi.get(self, "recovery_point")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[_builtins.str]:
        """
        The Pre-Authenticated Request (PAR) of a bucket/prefix or PAR of a @.manifest.json object from the Object Storage. Check [Using Pre-Authenticated Requests](https://docs.oracle.com/en-us/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm) for information related to PAR creation. Please create PAR with "Permit object reads" access type and "Enable Object Listing" permission when using a bucket/prefix PAR. Please create PAR with "Permit object reads" access type when using a @.manifest.json object PAR.
        """
        return pulumi.get(self, "source_url")


@pulumi.output_type
class ReplicaEncryptData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyGenerationType":
            suggest = "key_generation_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaEncryptData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaEncryptData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaEncryptData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_generation_type: Optional[_builtins.str] = None,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        if key_generation_type is not None:
            pulumi.set(__self__, "key_generation_type", key_generation_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> Optional[_builtins.str]:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class ReplicaReplicaOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationId":
            suggest = "configuration_id"
        elif key == "mysqlVersion":
            suggest = "mysql_version"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "securityAttributes":
            suggest = "security_attributes"
        elif key == "shapeName":
            suggest = "shape_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaReplicaOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaReplicaOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaReplicaOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_id: Optional[_builtins.str] = None,
                 mysql_version: Optional[_builtins.str] = None,
                 nsg_ids: Optional[Sequence[_builtins.str]] = None,
                 security_attributes: Optional[Mapping[str, _builtins.str]] = None,
                 shape_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str configuration_id: (Updatable) The OCID of the Configuration to be used by the read replica.
        :param _builtins.str mysql_version: (Updatable) The MySQL version to be used by the read replica.
        :param Sequence[_builtins.str] nsg_ids: (Updatable) Network Security Group OCIDs used for the VNIC attachment.
        :param Mapping[str, _builtins.str] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: (Updatable) The shape to be used by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[_builtins.str]:
        """
        (Updatable) The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The shape to be used by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shape_name")


@pulumi.output_type
class ReplicaSecureConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateGenerationType":
            suggest = "certificate_generation_type"
        elif key == "certificateId":
            suggest = "certificate_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSecureConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSecureConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSecureConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_generation_type: Optional[_builtins.str] = None,
                 certificate_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        if certificate_generation_type is not None:
            pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> Optional[_builtins.str]:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetChannelSourceResult(dict):
    def __init__(__self__, *,
                 anonymous_transactions_handlings: Sequence['outputs.GetChannelSourceAnonymousTransactionsHandlingResult'],
                 hostname: _builtins.str,
                 password: _builtins.str,
                 port: _builtins.int,
                 source_type: _builtins.str,
                 ssl_ca_certificates: Sequence['outputs.GetChannelSourceSslCaCertificateResult'],
                 ssl_mode: _builtins.str,
                 username: _builtins.str):
        """
        :param Sequence['GetChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.str hostname: The network address of the MySQL instance.
        :param _builtins.int port: The port the source MySQL instance listens on.
        :param _builtins.str source_type: The specific source identifier.
        :param Sequence['GetChannelSourceSslCaCertificateArgs'] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param _builtins.str ssl_mode: The SSL mode of the Channel.
        :param _builtins.str username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Sequence['outputs.GetChannelSourceAnonymousTransactionsHandlingResult']:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the MySQL instance.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port the source MySQL instance listens on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Sequence['outputs.GetChannelSourceSslCaCertificateResult']:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetChannelSourceAnonymousTransactionsHandlingResult(dict):
    def __init__(__self__, *,
                 last_configured_log_filename: _builtins.str,
                 last_configured_log_offset: _builtins.str,
                 policy: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str policy: Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> _builtins.str:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> _builtins.str:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetChannelSourceSslCaCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_type: _builtins.str,
                 contents: _builtins.str):
        """
        :param _builtins.str certificate_type: The type of CA certificate.
        :param _builtins.str contents: The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> _builtins.str:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class GetChannelTargetResult(dict):
    def __init__(__self__, *,
                 applier_username: _builtins.str,
                 channel_name: _builtins.str,
                 db_system_id: _builtins.str,
                 delay_in_seconds: _builtins.int,
                 filters: Sequence['outputs.GetChannelTargetFilterResult'],
                 tables_without_primary_key_handling: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str applier_username: The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.str db_system_id: The OCID of the source DB System.
        :param _builtins.int delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['GetChannelTargetFilterArgs'] filters: Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param _builtins.str target_type: The specific target identifier.
        """
        pulumi.set(__self__, "applier_username", applier_username)
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> _builtins.str:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> _builtins.str:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the source DB System.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> _builtins.int:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetChannelTargetFilterResult']:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> _builtins.str:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetChannelTargetFilterResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the filter rule.
        :param _builtins.str value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetChannelsChannelResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 sources: Sequence['outputs.GetChannelsChannelSourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 targets: Sequence['outputs.GetChannelsChannelTargetResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: User provided description of the Channel.
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the Channel.
        :param _builtins.bool is_enabled: If true, returns only Channels that are enabled. If false, returns only Channels that are disabled.
        :param _builtins.str lifecycle_details: A message describing the state of the Channel.
        :param Sequence['GetChannelsChannelSourceArgs'] sources: Parameters detailing how to provision the source for the given Channel.
        :param _builtins.str state: The LifecycleState of the Channel.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetChannelsChannelTargetArgs'] targets: Details about the Channel target.
        :param _builtins.str time_created: The date and time the Channel was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_updated: The time the Channel was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        User provided description of the Channel.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the Channel.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        If true, returns only Channels that are enabled. If false, returns only Channels that are disabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the state of the Channel.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetChannelsChannelSourceResult']:
        """
        Parameters detailing how to provision the source for the given Channel.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the Channel.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetChannelsChannelTargetResult']:
        """
        Details about the Channel target.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Channel was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Channel was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetChannelsChannelSourceResult(dict):
    def __init__(__self__, *,
                 anonymous_transactions_handlings: Sequence['outputs.GetChannelsChannelSourceAnonymousTransactionsHandlingResult'],
                 hostname: _builtins.str,
                 password: _builtins.str,
                 port: _builtins.int,
                 source_type: _builtins.str,
                 ssl_ca_certificates: Sequence['outputs.GetChannelsChannelSourceSslCaCertificateResult'],
                 ssl_mode: _builtins.str,
                 username: _builtins.str):
        """
        :param Sequence['GetChannelsChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.str hostname: The network address of the MySQL instance.
        :param _builtins.int port: The port the source MySQL instance listens on.
        :param _builtins.str source_type: The specific source identifier.
        :param Sequence['GetChannelsChannelSourceSslCaCertificateArgs'] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param _builtins.str ssl_mode: The SSL mode of the Channel.
        :param _builtins.str username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Sequence['outputs.GetChannelsChannelSourceAnonymousTransactionsHandlingResult']:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the MySQL instance.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port the source MySQL instance listens on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Sequence['outputs.GetChannelsChannelSourceSslCaCertificateResult']:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetChannelsChannelSourceAnonymousTransactionsHandlingResult(dict):
    def __init__(__self__, *,
                 last_configured_log_filename: _builtins.str,
                 last_configured_log_offset: _builtins.str,
                 policy: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str policy: Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> _builtins.str:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> _builtins.str:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetChannelsChannelSourceSslCaCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_type: _builtins.str,
                 contents: _builtins.str):
        """
        :param _builtins.str certificate_type: The type of CA certificate.
        :param _builtins.str contents: The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> _builtins.str:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class GetChannelsChannelTargetResult(dict):
    def __init__(__self__, *,
                 applier_username: _builtins.str,
                 channel_name: _builtins.str,
                 db_system_id: _builtins.str,
                 delay_in_seconds: _builtins.int,
                 filters: Sequence['outputs.GetChannelsChannelTargetFilterResult'],
                 tables_without_primary_key_handling: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str applier_username: The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.int delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['GetChannelsChannelTargetFilterArgs'] filters: Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param _builtins.str target_type: The specific target identifier.
        """
        pulumi.set(__self__, "applier_username", applier_username)
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> _builtins.str:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> _builtins.str:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> _builtins.int:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetChannelsChannelTargetFilterResult']:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> _builtins.str:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetChannelsChannelTargetFilterResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the filter rule.
        :param _builtins.str value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetChannelsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHeatWaveClusterClusterNodeResult(dict):
    def __init__(__self__, *,
                 node_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str node_id: The ID of the node within MySQL HeatWave cluster.
        :param _builtins.str state: The current state of the HeatWave cluster.
        :param _builtins.str time_created: The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_updated: The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the node within MySQL HeatWave cluster.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the HeatWave cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlBackupBackupValidationDetailResult(dict):
    def __init__(__self__, *,
                 backup_preparation_status: _builtins.str,
                 error_message: _builtins.str,
                 estimated_restore_duration: _builtins.str,
                 prepared_backup_details: Sequence['outputs.GetMysqlBackupBackupValidationDetailPreparedBackupDetailResult'],
                 time_last_validated: _builtins.str,
                 validation_status: _builtins.str):
        """
        :param _builtins.str backup_preparation_status: Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        :param _builtins.str error_message: Error message if the backup validation has failed.
        :param _builtins.str estimated_restore_duration: The estimated restore duration of the backup.
        :param Sequence['GetMysqlBackupBackupValidationDetailPreparedBackupDetailArgs'] prepared_backup_details: Prepared backup details.
        :param _builtins.str time_last_validated: The date and time of the most recent validation performed on the backup.
        :param _builtins.str validation_status: The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        pulumi.set(__self__, "backup_preparation_status", backup_preparation_status)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "estimated_restore_duration", estimated_restore_duration)
        pulumi.set(__self__, "prepared_backup_details", prepared_backup_details)
        pulumi.set(__self__, "time_last_validated", time_last_validated)
        pulumi.set(__self__, "validation_status", validation_status)

    @_builtins.property
    @pulumi.getter(name="backupPreparationStatus")
    def backup_preparation_status(self) -> _builtins.str:
        """
        Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        """
        return pulumi.get(self, "backup_preparation_status")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        Error message if the backup validation has failed.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="estimatedRestoreDuration")
    def estimated_restore_duration(self) -> _builtins.str:
        """
        The estimated restore duration of the backup.
        """
        return pulumi.get(self, "estimated_restore_duration")

    @_builtins.property
    @pulumi.getter(name="preparedBackupDetails")
    def prepared_backup_details(self) -> Sequence['outputs.GetMysqlBackupBackupValidationDetailPreparedBackupDetailResult']:
        """
        Prepared backup details.
        """
        return pulumi.get(self, "prepared_backup_details")

    @_builtins.property
    @pulumi.getter(name="timeLastValidated")
    def time_last_validated(self) -> _builtins.str:
        """
        The date and time of the most recent validation performed on the backup.
        """
        return pulumi.get(self, "time_last_validated")

    @_builtins.property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> _builtins.str:
        """
        The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        return pulumi.get(self, "validation_status")


@pulumi.output_type
class GetMysqlBackupBackupValidationDetailPreparedBackupDetailResult(dict):
    def __init__(__self__, *,
                 prepared_backup_restore_reduction_in_minutes: _builtins.int,
                 time_prepared: _builtins.str):
        """
        :param _builtins.int prepared_backup_restore_reduction_in_minutes: The estimated time saving when this prepared backup is restored.
        :param _builtins.str time_prepared: The date and time the backup was prepared.
        """
        pulumi.set(__self__, "prepared_backup_restore_reduction_in_minutes", prepared_backup_restore_reduction_in_minutes)
        pulumi.set(__self__, "time_prepared", time_prepared)

    @_builtins.property
    @pulumi.getter(name="preparedBackupRestoreReductionInMinutes")
    def prepared_backup_restore_reduction_in_minutes(self) -> _builtins.int:
        """
        The estimated time saving when this prepared backup is restored.
        """
        return pulumi.get(self, "prepared_backup_restore_reduction_in_minutes")

    @_builtins.property
    @pulumi.getter(name="timePrepared")
    def time_prepared(self) -> _builtins.str:
        """
        The date and time the backup was prepared.
        """
        return pulumi.get(self, "time_prepared")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotResult(dict):
    def __init__(__self__, *,
                 admin_username: _builtins.str,
                 availability_domain: _builtins.str,
                 backup_policies: Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyResult'],
                 compartment_id: _builtins.str,
                 configuration_id: _builtins.str,
                 crash_recovery: _builtins.str,
                 data_storage_size_in_gb: _builtins.int,
                 data_storages: Sequence['outputs.GetMysqlBackupDbSystemSnapshotDataStorageResult'],
                 database_management: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 deletion_policies: Sequence['outputs.GetMysqlBackupDbSystemSnapshotDeletionPolicyResult'],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 encrypt_datas: Sequence['outputs.GetMysqlBackupDbSystemSnapshotEncryptDataResult'],
                 endpoints: Sequence['outputs.GetMysqlBackupDbSystemSnapshotEndpointResult'],
                 fault_domain: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 hostname_label: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 is_highly_available: _builtins.bool,
                 maintenances: Sequence['outputs.GetMysqlBackupDbSystemSnapshotMaintenanceResult'],
                 mysql_version: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 read_endpoints: Sequence['outputs.GetMysqlBackupDbSystemSnapshotReadEndpointResult'],
                 region: _builtins.str,
                 rests: Sequence['outputs.GetMysqlBackupDbSystemSnapshotRestResult'],
                 secure_connections: Sequence['outputs.GetMysqlBackupDbSystemSnapshotSecureConnectionResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 shape_name: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str admin_username: The username for the administrative user.
        :param _builtins.str availability_domain: The Availability Domain where the primary DB System should be located.
        :param Sequence['GetMysqlBackupDbSystemSnapshotBackupPolicyArgs'] backup_policies: The Backup policy for the DB System.
        :param _builtins.str compartment_id: The OCID of the compartment the DB System belongs in.
        :param _builtins.str configuration_id: The OCID of the Configuration to be used for Instances in this DB System.
        :param _builtins.str crash_recovery: Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param _builtins.int data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param Sequence['GetMysqlBackupDbSystemSnapshotDataStorageArgs'] data_storages: Data Storage information.
        :param _builtins.str database_management: Whether to enable monitoring via the Database Management service.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetMysqlBackupDbSystemSnapshotDeletionPolicyArgs'] deletion_policies: The Deletion policy for the DB System.
        :param _builtins.str description: A user-supplied description for the backup.
        :param _builtins.str display_name: A user-supplied display name for the backup.
        :param Sequence['GetMysqlBackupDbSystemSnapshotEncryptDataArgs'] encrypt_datas: Encrypt data details.
        :param Sequence['GetMysqlBackupDbSystemSnapshotEndpointArgs'] endpoints: The network endpoints available for this DB System.
        :param _builtins.str fault_domain: The name of the Fault Domain the DB System is located in.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param _builtins.bool is_highly_available: Specifies if the DB System is highly available.
        :param Sequence['GetMysqlBackupDbSystemSnapshotMaintenanceArgs'] maintenances: The Maintenance Policy for the DB System or Read Replica that this model is included in.
        :param _builtins.str mysql_version: The MySQL server version of the DB System used for backup.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param Sequence['GetMysqlBackupDbSystemSnapshotReadEndpointArgs'] read_endpoints: The read endpoint of a DB System.
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        :param Sequence['GetMysqlBackupDbSystemSnapshotRestArgs'] rests: REST configuration details.
        :param Sequence['GetMysqlBackupDbSystemSnapshotSecureConnectionArgs'] secure_connections: Secure connection configuration details.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape of the DB System instance used for backup.
        :param _builtins.str subnet_id: The OCID of the subnet the DB System is associated with.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "crash_recovery", crash_recovery)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "data_storages", data_storages)
        pulumi.set(__self__, "database_management", database_management)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "deletion_policies", deletion_policies)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "hostname_label", hostname_label)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_highly_available", is_highly_available)
        pulumi.set(__self__, "maintenances", maintenances)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "read_endpoints", read_endpoints)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "rests", rests)
        pulumi.set(__self__, "secure_connections", secure_connections)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The Availability Domain where the primary DB System should be located.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyResult']:
        """
        The Backup policy for the DB System.
        """
        return pulumi.get(self, "backup_policies")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> _builtins.str:
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> _builtins.str:
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorages")
    def data_storages(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotDataStorageResult']:
        """
        Data Storage information.
        """
        return pulumi.get(self, "data_storages")

    @_builtins.property
    @pulumi.getter(name="databaseManagement")
    def database_management(self) -> _builtins.str:
        """
        Whether to enable monitoring via the Database Management service.
        """
        return pulumi.get(self, "database_management")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotDeletionPolicyResult']:
        """
        The Deletion policy for the DB System.
        """
        return pulumi.get(self, "deletion_policies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotEncryptDataResult']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotEndpointResult']:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The name of the Fault Domain the DB System is located in.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> _builtins.str:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> _builtins.bool:
        """
        Specifies if the DB System is highly available.
        """
        return pulumi.get(self, "is_highly_available")

    @_builtins.property
    @pulumi.getter
    def maintenances(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotMaintenanceResult']:
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        return pulumi.get(self, "maintenances")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotReadEndpointResult']:
        """
        The read endpoint of a DB System.
        """
        return pulumi.get(self, "read_endpoints")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rests(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotRestResult']:
        """
        REST configuration details.
        """
        return pulumi.get(self, "rests")

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotSecureConnectionResult']:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotBackupPolicyResult(dict):
    def __init__(__self__, *,
                 copy_policies: Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 is_enabled: _builtins.bool,
                 pitr_policies: Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyResult'],
                 retention_in_days: _builtins.int,
                 soft_delete: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param Sequence['GetMysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyArgs'] copy_policies: List of policies of a DB system to schedule cross-region DB system backup copy.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param Sequence['GetMysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyArgs'] pitr_policies: The PITR policy for the DB System.
        :param _builtins.int retention_in_days: Number of days to retain this backup.
        :param _builtins.str soft_delete: Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "copy_policies", copy_policies)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "pitr_policies", pitr_policies)
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        pulumi.set(__self__, "soft_delete", soft_delete)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyResult']:
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        return pulumi.get(self, "copy_policies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="pitrPolicies")
    def pitr_policies(self) -> Sequence['outputs.GetMysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyResult']:
        """
        The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policies")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> _builtins.str:
        """
        Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotBackupPolicyCopyPolicyResult(dict):
    def __init__(__self__, *,
                 backup_copy_retention_in_days: _builtins.int,
                 copy_to_region: _builtins.str):
        """
        :param _builtins.int backup_copy_retention_in_days: Number of days to retain the copied DB system backup.
        :param _builtins.str copy_to_region: The destination region name to which the DB system backup will be copied.
        """
        pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)
        pulumi.set(__self__, "copy_to_region", copy_to_region)

    @_builtins.property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> _builtins.str:
        """
        The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotBackupPolicyPitrPolicyResult(dict):
    def __init__(__self__, *,
                 is_enabled: _builtins.bool):
        """
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotDataStorageResult(dict):
    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: _builtins.int,
                 data_storage_size_in_gb: _builtins.int,
                 data_storage_size_limit_in_gbs: _builtins.int,
                 is_auto_expand_storage_enabled: _builtins.bool,
                 max_storage_size_in_gbs: _builtins.int):
        """
        :param _builtins.int allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param _builtins.int data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param _builtins.int data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param _builtins.bool is_auto_expand_storage_enabled: Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param _builtins.int max_storage_size_in_gbs: Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> _builtins.int:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> _builtins.int:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> _builtins.bool:
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> _builtins.int:
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotDeletionPolicyResult(dict):
    def __init__(__self__, *,
                 automatic_backup_retention: _builtins.str,
                 final_backup: _builtins.str,
                 is_delete_protected: _builtins.bool):
        """
        :param _builtins.str automatic_backup_retention: Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param _builtins.str final_backup: Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param _builtins.bool is_delete_protected: Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        pulumi.set(__self__, "final_backup", final_backup)
        pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @_builtins.property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> _builtins.str:
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @_builtins.property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> _builtins.str:
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> _builtins.bool:
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotEndpointResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 ip_address: _builtins.str,
                 modes: Sequence[_builtins.str],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 status_details: _builtins.str):
        """
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param Sequence[_builtins.str] modes: The access modes from the client that this endpoint supports.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param _builtins.str resource_id: The OCID of the resource that this endpoint is attached to.
        :param _builtins.str resource_type: The type of endpoint that clients and connectors can connect to.
        :param _builtins.str status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param _builtins.str status_details: Additional information about the current endpoint status.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Sequence[_builtins.str]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> _builtins.str:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotMaintenanceResult(dict):
    def __init__(__self__, *,
                 maintenance_schedule_type: _builtins.str,
                 target_version: _builtins.str,
                 time_scheduled: _builtins.str,
                 version_preference: _builtins.str,
                 version_track_preference: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param _builtins.str maintenance_schedule_type: The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        :param _builtins.str target_version: The version that is expected to be targeted during the next scheduled maintenance run.
        :param _builtins.str time_scheduled: The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str version_preference: The preferred version to target when performing an automatic MySQL upgrade.
        :param _builtins.str version_track_preference: The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "maintenance_schedule_type", maintenance_schedule_type)
        pulumi.set(__self__, "target_version", target_version)
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        pulumi.set(__self__, "version_preference", version_preference)
        pulumi.set(__self__, "version_track_preference", version_track_preference)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="maintenanceScheduleType")
    def maintenance_schedule_type(self) -> _builtins.str:
        """
        The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        """
        return pulumi.get(self, "maintenance_schedule_type")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> _builtins.str:
        """
        The version that is expected to be targeted during the next scheduled maintenance run.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> _builtins.str:
        """
        The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> _builtins.str:
        """
        The preferred version to target when performing an automatic MySQL upgrade.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="versionTrackPreference")
    def version_track_preference(self) -> _builtins.str:
        """
        The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        return pulumi.get(self, "version_track_preference")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotReadEndpointResult(dict):
    def __init__(__self__, *,
                 exclude_ips: Sequence[_builtins.str],
                 is_enabled: _builtins.bool,
                 read_endpoint_hostname_label: _builtins.str,
                 read_endpoint_ip_address: _builtins.str):
        """
        :param Sequence[_builtins.str] exclude_ips: A list of IP addresses of read replicas that are excluded from serving read requests.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str read_endpoint_hostname_label: The hostname for the read endpoint of the DB System. Used for DNS.
        :param _builtins.str read_endpoint_ip_address: The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        pulumi.set(__self__, "exclude_ips", exclude_ips)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @_builtins.property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Sequence[_builtins.str]:
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> _builtins.str:
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @_builtins.property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> _builtins.str:
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotRestResult(dict):
    def __init__(__self__, *,
                 configuration: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str configuration: Select how REST is configured across the DB System instances.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> _builtins.str:
        """
        Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotSecureConnectionResult(dict):
    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: _builtins.str):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetMysqlBackupDbSystemSnapshotSummaryResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str display_name: A user-supplied display name for the backup.
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetMysqlBackupEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetMysqlBackupSourceDetailResult(dict):
    def __init__(__self__, *,
                 backup_id: _builtins.str,
                 compartment_id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str backup_id: The OCID of the Backup
        :param _builtins.str compartment_id: The OCID of the compartment the DB System belongs in.
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        The OCID of the Backup
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetMysqlBackupValidateBackupDetailResult(dict):
    def __init__(__self__, *,
                 is_prepared_backup_required: _builtins.bool):
        pulumi.set(__self__, "is_prepared_backup_required", is_prepared_backup_required)

    @_builtins.property
    @pulumi.getter(name="isPreparedBackupRequired")
    def is_prepared_backup_required(self) -> _builtins.bool:
        return pulumi.get(self, "is_prepared_backup_required")


@pulumi.output_type
class GetMysqlBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_preparation_status: _builtins.str,
                 backup_size_in_gbs: _builtins.int,
                 backup_type: _builtins.str,
                 compartment_id: _builtins.str,
                 creation_type: _builtins.str,
                 data_storage_size_in_gb: _builtins.int,
                 db_system_id: _builtins.str,
                 db_system_snapshot_summaries: Sequence['outputs.GetMysqlBackupsBackupDbSystemSnapshotSummaryResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 encrypt_datas: Sequence['outputs.GetMysqlBackupsBackupEncryptDataResult'],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 immediate_source_backup_id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 mysql_version: _builtins.str,
                 original_source_backup_id: _builtins.str,
                 retention_in_days: _builtins.int,
                 shape_name: _builtins.str,
                 soft_delete: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_copy_created: _builtins.str,
                 time_created: _builtins.str,
                 validation_status: _builtins.str):
        """
        :param _builtins.str backup_preparation_status: Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        :param _builtins.int backup_size_in_gbs: The size of the backup in base-2 (IEC) gibibytes. (GiB).
        :param _builtins.str backup_type: The type of backup.
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str creation_type: Backup creationType
        :param _builtins.int data_storage_size_in_gb: DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: A user-supplied description for the backup.
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Sequence['GetMysqlBackupsBackupEncryptDataArgs'] encrypt_datas: Encrypt data details.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str immediate_source_backup_id: The OCID of the immediate source DB system backup from which this DB system backup was copied.
        :param _builtins.str lifecycle_details: Additional information about the current lifecycleState.
        :param _builtins.str mysql_version: The MySQL server version of the DB System used for backup.
        :param _builtins.str original_source_backup_id: The OCID of the original source DB system backup from which this DB system backup was copied.
        :param _builtins.int retention_in_days: Number of days to retain this backup.
        :param _builtins.str shape_name: The shape of the DB System instance used for backup.
        :param _builtins.str soft_delete: Backup Soft Delete
        :param _builtins.str state: Backup Lifecycle State
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_copy_created: The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_created: The time the backup record was created.
        :param _builtins.str validation_status: The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        pulumi.set(__self__, "backup_preparation_status", backup_preparation_status)
        pulumi.set(__self__, "backup_size_in_gbs", backup_size_in_gbs)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "creation_type", creation_type)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "db_system_snapshot_summaries", db_system_snapshot_summaries)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "immediate_source_backup_id", immediate_source_backup_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "original_source_backup_id", original_source_backup_id)
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "soft_delete", soft_delete)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_copy_created", time_copy_created)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "validation_status", validation_status)

    @_builtins.property
    @pulumi.getter(name="backupPreparationStatus")
    def backup_preparation_status(self) -> _builtins.str:
        """
        Indicates whether the backup has been prepared successfully.  PREPARED: The backup is prepared one. NOT_PREPARED: The backup is not prepared.
        """
        return pulumi.get(self, "backup_preparation_status")

    @_builtins.property
    @pulumi.getter(name="backupSizeInGbs")
    def backup_size_in_gbs(self) -> _builtins.int:
        """
        The size of the backup in base-2 (IEC) gibibytes. (GiB).
        """
        return pulumi.get(self, "backup_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The type of backup.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> _builtins.str:
        """
        Backup creationType
        """
        return pulumi.get(self, "creation_type")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs. Replaced by dataStorage.dataStorageSizeInGBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemSnapshotSummaries")
    def db_system_snapshot_summaries(self) -> Sequence['outputs.GetMysqlBackupsBackupDbSystemSnapshotSummaryResult']:
        return pulumi.get(self, "db_system_snapshot_summaries")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-supplied description for the backup.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Sequence['outputs.GetMysqlBackupsBackupEncryptDataResult']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="immediateSourceBackupId")
    def immediate_source_backup_id(self) -> _builtins.str:
        """
        The OCID of the immediate source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "immediate_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL server version of the DB System used for backup.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="originalSourceBackupId")
    def original_source_backup_id(self) -> _builtins.str:
        """
        The OCID of the original source DB system backup from which this DB system backup was copied.
        """
        return pulumi.get(self, "original_source_backup_id")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain this backup.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the DB System instance used for backup.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> _builtins.str:
        """
        Backup Soft Delete
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Backup Lifecycle State
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCopyCreated")
    def time_copy_created(self) -> _builtins.str:
        """
        The date and time the DB system backup copy was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_copy_created")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the backup record was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> _builtins.str:
        """
        The status of backup validation:  NOT_VALIDATED (Default): The backup has not been validated.  VALIDATED: The backup has been validated successfully.  NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.  FAILED: The backup cannot be restored.
        """
        return pulumi.get(self, "validation_status")


@pulumi.output_type
class GetMysqlBackupsBackupDbSystemSnapshotSummaryResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param _builtins.str id: OCID of the backup itself
        :param _builtins.str region: The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the backup itself
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region identifier of the region where the DB system exists. For more information, please see [Regions and Availability Domains](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm).
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetMysqlBackupsBackupEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetMysqlBackupsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMysqlConfigurationInitVariableResult(dict):
    def __init__(__self__, *,
                 lower_case_table_names: _builtins.str):
        """
        :param _builtins.str lower_case_table_names: Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
        """
        pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> _builtins.str:
        """
        Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
        """
        return pulumi.get(self, "lower_case_table_names")


@pulumi.output_type
class GetMysqlConfigurationVariableResult(dict):
    def __init__(__self__, *,
                 auto_increment_increment: _builtins.int,
                 auto_increment_offset: _builtins.int,
                 autocommit: _builtins.bool,
                 big_tables: _builtins.bool,
                 binlog_expire_logs_seconds: _builtins.int,
                 binlog_group_commit_sync_delay: _builtins.int,
                 binlog_group_commit_sync_no_delay_count: _builtins.int,
                 binlog_row_metadata: _builtins.str,
                 binlog_row_value_options: _builtins.str,
                 binlog_transaction_compression: _builtins.bool,
                 block_encryption_mode: _builtins.str,
                 character_set_server: _builtins.str,
                 collation_server: _builtins.str,
                 completion_type: _builtins.str,
                 connect_timeout: _builtins.int,
                 connection_memory_chunk_size: _builtins.int,
                 connection_memory_limit: _builtins.str,
                 cte_max_recursion_depth: _builtins.str,
                 default_authentication_plugin: _builtins.str,
                 explain_format: _builtins.str,
                 explicit_defaults_for_timestamp: _builtins.bool,
                 foreign_key_checks: _builtins.bool,
                 generated_random_password_length: _builtins.int,
                 global_connection_memory_limit: _builtins.str,
                 global_connection_memory_tracking: _builtins.bool,
                 group_concat_max_len: _builtins.str,
                 group_replication_consistency: _builtins.str,
                 information_schema_stats_expiry: _builtins.int,
                 innodb_adaptive_hash_index: _builtins.bool,
                 innodb_autoinc_lock_mode: _builtins.int,
                 innodb_buffer_pool_dump_pct: _builtins.int,
                 innodb_buffer_pool_instances: _builtins.int,
                 innodb_buffer_pool_size: _builtins.str,
                 innodb_change_buffering: _builtins.str,
                 innodb_ddl_buffer_size: _builtins.str,
                 innodb_ddl_threads: _builtins.int,
                 innodb_ft_enable_stopword: _builtins.bool,
                 innodb_ft_max_token_size: _builtins.int,
                 innodb_ft_min_token_size: _builtins.int,
                 innodb_ft_num_word_optimize: _builtins.int,
                 innodb_ft_result_cache_limit: _builtins.str,
                 innodb_ft_server_stopword_table: _builtins.str,
                 innodb_lock_wait_timeout: _builtins.int,
                 innodb_log_writer_threads: _builtins.bool,
                 innodb_max_purge_lag: _builtins.str,
                 innodb_max_purge_lag_delay: _builtins.int,
                 innodb_numa_interleave: _builtins.bool,
                 innodb_online_alter_log_max_size: _builtins.str,
                 innodb_redo_log_capacity: _builtins.str,
                 innodb_rollback_on_timeout: _builtins.bool,
                 innodb_sort_buffer_size: _builtins.int,
                 innodb_stats_persistent_sample_pages: _builtins.str,
                 innodb_stats_transient_sample_pages: _builtins.str,
                 innodb_strict_mode: _builtins.bool,
                 innodb_undo_log_truncate: _builtins.bool,
                 interactive_timeout: _builtins.int,
                 join_buffer_size: _builtins.str,
                 local_infile: _builtins.bool,
                 long_query_time: _builtins.int,
                 mandatory_roles: _builtins.str,
                 max_allowed_packet: _builtins.int,
                 max_binlog_cache_size: _builtins.str,
                 max_connect_errors: _builtins.str,
                 max_connections: _builtins.int,
                 max_execution_time: _builtins.str,
                 max_heap_table_size: _builtins.str,
                 max_prepared_stmt_count: _builtins.int,
                 max_seeks_for_key: _builtins.str,
                 max_user_connections: _builtins.str,
                 mysql_firewall_mode: _builtins.bool,
                 mysql_zstd_default_compression_level: _builtins.int,
                 mysqlx_connect_timeout: _builtins.int,
                 mysqlx_deflate_default_compression_level: _builtins.int,
                 mysqlx_deflate_max_client_compression_level: _builtins.int,
                 mysqlx_document_id_unique_prefix: _builtins.int,
                 mysqlx_enable_hello_notice: _builtins.bool,
                 mysqlx_idle_worker_thread_timeout: _builtins.int,
                 mysqlx_interactive_timeout: _builtins.int,
                 mysqlx_lz4default_compression_level: _builtins.int,
                 mysqlx_lz4max_client_compression_level: _builtins.int,
                 mysqlx_max_allowed_packet: _builtins.int,
                 mysqlx_min_worker_threads: _builtins.int,
                 mysqlx_read_timeout: _builtins.int,
                 mysqlx_wait_timeout: _builtins.int,
                 mysqlx_write_timeout: _builtins.int,
                 mysqlx_zstd_default_compression_level: _builtins.int,
                 mysqlx_zstd_max_client_compression_level: _builtins.int,
                 net_read_timeout: _builtins.int,
                 net_write_timeout: _builtins.int,
                 optimizer_switch: _builtins.str,
                 parser_max_mem_size: _builtins.str,
                 query_alloc_block_size: _builtins.str,
                 query_prealloc_size: _builtins.str,
                 range_optimizer_max_mem_size: _builtins.str,
                 regexp_time_limit: _builtins.int,
                 relay_log_space_limit: _builtins.str,
                 replica_net_timeout: _builtins.int,
                 replica_parallel_workers: _builtins.int,
                 replica_type_conversions: _builtins.str,
                 require_secure_transport: _builtins.bool,
                 skip_name_resolve: _builtins.bool,
                 sort_buffer_size: _builtins.str,
                 sql_generate_invisible_primary_key: _builtins.bool,
                 sql_mode: _builtins.str,
                 sql_require_primary_key: _builtins.bool,
                 sql_warnings: _builtins.bool,
                 table_definition_cache: _builtins.int,
                 table_open_cache: _builtins.int,
                 temptable_max_ram: _builtins.str,
                 thread_pool_dedicated_listeners: _builtins.bool,
                 thread_pool_max_transactions_limit: _builtins.int,
                 thread_pool_query_threads_per_group: _builtins.int,
                 thread_pool_size: _builtins.int,
                 thread_pool_transaction_delay: _builtins.int,
                 time_zone: _builtins.str,
                 tmp_table_size: _builtins.str,
                 transaction_isolation: _builtins.str,
                 wait_timeout: _builtins.int):
        """
        :param _builtins.int auto_increment_increment: auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
        :param _builtins.int auto_increment_offset: This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
        :param _builtins.bool autocommit: ("autocommit")
        :param _builtins.bool big_tables: If enabled, the server stores all temporary tables on disk rather than in memory.
        :param _builtins.int binlog_expire_logs_seconds: Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        :param _builtins.int binlog_group_commit_sync_delay: Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
        :param _builtins.int binlog_group_commit_sync_no_delay_count: The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
        :param _builtins.str binlog_row_metadata: Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        :param _builtins.str binlog_row_value_options: When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        :param _builtins.bool binlog_transaction_compression: Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        :param _builtins.str block_encryption_mode: This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
        :param _builtins.str character_set_server: The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
        :param _builtins.str collation_server: The server's default collation.
        :param _builtins.str completion_type: ("completion_type")
        :param _builtins.int connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        :param _builtins.int connection_memory_chunk_size: Set the chunking size for updates to the global memory usage counter Global_connection_memory.
        :param _builtins.str connection_memory_limit: Set the maximum amount of memory that can be used by a single user connection.
        :param _builtins.str cte_max_recursion_depth: ("cte_max_recursion_depth")
        :param _builtins.str default_authentication_plugin: The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
        :param _builtins.str explain_format: This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
        :param _builtins.bool explicit_defaults_for_timestamp: This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
        :param _builtins.bool foreign_key_checks: ("foreign_key_checks")
        :param _builtins.int generated_random_password_length: ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str global_connection_memory_limit: Set the total amount of memory that can be used by all user connections.
        :param _builtins.bool global_connection_memory_tracking: Determines whether the MySQL server calculates Global_connection_memory.
        :param _builtins.str group_concat_max_len: Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
        :param _builtins.str group_replication_consistency: * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
               * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
               * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        :param _builtins.int information_schema_stats_expiry: ("information_schema_stats_expiry")
        :param _builtins.bool innodb_adaptive_hash_index: Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
        :param _builtins.int innodb_autoinc_lock_mode: The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
        :param _builtins.int innodb_buffer_pool_dump_pct: Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
        :param _builtins.int innodb_buffer_pool_instances: ("innodb_buffer_pool_instances")
        :param _builtins.str innodb_buffer_pool_size: The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
        :param _builtins.str innodb_change_buffering: Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
        :param _builtins.str innodb_ddl_buffer_size: innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        :param _builtins.int innodb_ddl_threads: innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        :param _builtins.bool innodb_ft_enable_stopword: ("innodb_ft_enable_stopword")
        :param _builtins.int innodb_ft_max_token_size: ("innodb_ft_max_token_size")
        :param _builtins.int innodb_ft_min_token_size: ("innodb_ft_min_token_size")
        :param _builtins.int innodb_ft_num_word_optimize: ("innodb_ft_num_word_optimize")
        :param _builtins.str innodb_ft_result_cache_limit: ("innodb_ft_result_cache_limit")
        :param _builtins.str innodb_ft_server_stopword_table: ("innodb_ft_server_stopword_table")
        :param _builtins.int innodb_lock_wait_timeout: ("innodb_lock_wait_timeout")
        :param _builtins.bool innodb_log_writer_threads: Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
        :param _builtins.str innodb_max_purge_lag: The desired maximum purge lag in terms of transactions.
        :param _builtins.int innodb_max_purge_lag_delay: The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
        :param _builtins.bool innodb_numa_interleave: Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
        :param _builtins.str innodb_online_alter_log_max_size: Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
        :param _builtins.str innodb_redo_log_capacity: Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
        :param _builtins.bool innodb_rollback_on_timeout: InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
        :param _builtins.int innodb_sort_buffer_size: This variable defines:
               * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
               * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
        :param _builtins.str innodb_stats_persistent_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
        :param _builtins.str innodb_stats_transient_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
        :param _builtins.bool innodb_strict_mode: When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
        :param _builtins.bool innodb_undo_log_truncate: When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
        :param _builtins.int interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param _builtins.str join_buffer_size: The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
        :param _builtins.bool local_infile: This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side.
        :param _builtins.int long_query_time: If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
        :param _builtins.str mandatory_roles: ("mandatory_roles")
        :param _builtins.int max_allowed_packet: The maximum size of one packet or any generated/intermediate string.
        :param _builtins.str max_binlog_cache_size: Sets the size of the transaction cache.
        :param _builtins.str max_connect_errors: ("max_connect_errors")
        :param _builtins.int max_connections: ("max_connections")
        :param _builtins.str max_execution_time: ("max_execution_time")
        :param _builtins.str max_heap_table_size: This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
        :param _builtins.int max_prepared_stmt_count: ("max_prepared_stmt_count")
        :param _builtins.str max_seeks_for_key: Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
        :param _builtins.str max_user_connections: The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
        :param _builtins.bool mysql_firewall_mode: ("mysql_firewall_mode")
        :param _builtins.int mysql_zstd_default_compression_level: DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        :param _builtins.int mysqlx_connect_timeout: The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
        :param _builtins.int mysqlx_deflate_default_compression_level: Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        :param _builtins.int mysqlx_deflate_max_client_compression_level: Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        :param _builtins.int mysqlx_document_id_unique_prefix: ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.bool mysqlx_enable_hello_notice: ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_idle_worker_thread_timeout: ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_interactive_timeout: The number of seconds to wait for interactive clients to timeout.
        :param _builtins.int mysqlx_lz4default_compression_level: Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        :param _builtins.int mysqlx_lz4max_client_compression_level: Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        :param _builtins.int mysqlx_max_allowed_packet: The maximum size of network packets that can be received by X Plugin.
        :param _builtins.int mysqlx_min_worker_threads: ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_read_timeout: The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
        :param _builtins.int mysqlx_wait_timeout: The number of seconds that X Plugin waits for activity on a connection.
        :param _builtins.int mysqlx_write_timeout: The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
        :param _builtins.int mysqlx_zstd_default_compression_level: Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        :param _builtins.int mysqlx_zstd_max_client_compression_level: Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        :param _builtins.int net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param _builtins.int net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param _builtins.str optimizer_switch: The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
        :param _builtins.str parser_max_mem_size: ("parser_max_mem_size")
        :param _builtins.str query_alloc_block_size: ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str query_prealloc_size: ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str range_optimizer_max_mem_size: The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans.
        :param _builtins.int regexp_time_limit: regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        :param _builtins.str relay_log_space_limit: The maximum amount of space to use for all relay logs.
        :param _builtins.int replica_net_timeout: Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
        :param _builtins.int replica_parallel_workers: Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
        :param _builtins.str replica_type_conversions: From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
        :param _builtins.bool require_secure_transport: Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
        :param _builtins.bool skip_name_resolve: Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
        :param _builtins.str sort_buffer_size: Each session that must perform a sort allocates a buffer of this size.
        :param _builtins.bool sql_generate_invisible_primary_key: Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
        :param _builtins.str sql_mode: ("sql_mode")
        :param _builtins.bool sql_require_primary_key: ("sql_require_primary_key")
        :param _builtins.bool sql_warnings: ("sql_warnings")
        :param _builtins.int table_definition_cache: The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
        :param _builtins.int table_open_cache: The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
        :param _builtins.str temptable_max_ram: Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
        :param _builtins.bool thread_pool_dedicated_listeners: Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        :param _builtins.int thread_pool_max_transactions_limit: Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        :param _builtins.int thread_pool_query_threads_per_group: The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions.
        :param _builtins.int thread_pool_size: The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
        :param _builtins.int thread_pool_transaction_delay: The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running.
        :param _builtins.str time_zone: Initializes the time zone for each client that connects.
        :param _builtins.str tmp_table_size: The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
        :param _builtins.str transaction_isolation: ("transaction_isolation")
        :param _builtins.int wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        pulumi.set(__self__, "auto_increment_increment", auto_increment_increment)
        pulumi.set(__self__, "auto_increment_offset", auto_increment_offset)
        pulumi.set(__self__, "autocommit", autocommit)
        pulumi.set(__self__, "big_tables", big_tables)
        pulumi.set(__self__, "binlog_expire_logs_seconds", binlog_expire_logs_seconds)
        pulumi.set(__self__, "binlog_group_commit_sync_delay", binlog_group_commit_sync_delay)
        pulumi.set(__self__, "binlog_group_commit_sync_no_delay_count", binlog_group_commit_sync_no_delay_count)
        pulumi.set(__self__, "binlog_row_metadata", binlog_row_metadata)
        pulumi.set(__self__, "binlog_row_value_options", binlog_row_value_options)
        pulumi.set(__self__, "binlog_transaction_compression", binlog_transaction_compression)
        pulumi.set(__self__, "block_encryption_mode", block_encryption_mode)
        pulumi.set(__self__, "character_set_server", character_set_server)
        pulumi.set(__self__, "collation_server", collation_server)
        pulumi.set(__self__, "completion_type", completion_type)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "connection_memory_chunk_size", connection_memory_chunk_size)
        pulumi.set(__self__, "connection_memory_limit", connection_memory_limit)
        pulumi.set(__self__, "cte_max_recursion_depth", cte_max_recursion_depth)
        pulumi.set(__self__, "default_authentication_plugin", default_authentication_plugin)
        pulumi.set(__self__, "explain_format", explain_format)
        pulumi.set(__self__, "explicit_defaults_for_timestamp", explicit_defaults_for_timestamp)
        pulumi.set(__self__, "foreign_key_checks", foreign_key_checks)
        pulumi.set(__self__, "generated_random_password_length", generated_random_password_length)
        pulumi.set(__self__, "global_connection_memory_limit", global_connection_memory_limit)
        pulumi.set(__self__, "global_connection_memory_tracking", global_connection_memory_tracking)
        pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        pulumi.set(__self__, "group_replication_consistency", group_replication_consistency)
        pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        pulumi.set(__self__, "innodb_adaptive_hash_index", innodb_adaptive_hash_index)
        pulumi.set(__self__, "innodb_autoinc_lock_mode", innodb_autoinc_lock_mode)
        pulumi.set(__self__, "innodb_buffer_pool_dump_pct", innodb_buffer_pool_dump_pct)
        pulumi.set(__self__, "innodb_buffer_pool_instances", innodb_buffer_pool_instances)
        pulumi.set(__self__, "innodb_buffer_pool_size", innodb_buffer_pool_size)
        pulumi.set(__self__, "innodb_change_buffering", innodb_change_buffering)
        pulumi.set(__self__, "innodb_ddl_buffer_size", innodb_ddl_buffer_size)
        pulumi.set(__self__, "innodb_ddl_threads", innodb_ddl_threads)
        pulumi.set(__self__, "innodb_ft_enable_stopword", innodb_ft_enable_stopword)
        pulumi.set(__self__, "innodb_ft_max_token_size", innodb_ft_max_token_size)
        pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        pulumi.set(__self__, "innodb_ft_num_word_optimize", innodb_ft_num_word_optimize)
        pulumi.set(__self__, "innodb_ft_result_cache_limit", innodb_ft_result_cache_limit)
        pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        pulumi.set(__self__, "innodb_log_writer_threads", innodb_log_writer_threads)
        pulumi.set(__self__, "innodb_max_purge_lag", innodb_max_purge_lag)
        pulumi.set(__self__, "innodb_max_purge_lag_delay", innodb_max_purge_lag_delay)
        pulumi.set(__self__, "innodb_numa_interleave", innodb_numa_interleave)
        pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        pulumi.set(__self__, "innodb_redo_log_capacity", innodb_redo_log_capacity)
        pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        pulumi.set(__self__, "innodb_sort_buffer_size", innodb_sort_buffer_size)
        pulumi.set(__self__, "innodb_stats_persistent_sample_pages", innodb_stats_persistent_sample_pages)
        pulumi.set(__self__, "innodb_stats_transient_sample_pages", innodb_stats_transient_sample_pages)
        pulumi.set(__self__, "innodb_strict_mode", innodb_strict_mode)
        pulumi.set(__self__, "innodb_undo_log_truncate", innodb_undo_log_truncate)
        pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        pulumi.set(__self__, "join_buffer_size", join_buffer_size)
        pulumi.set(__self__, "local_infile", local_infile)
        pulumi.set(__self__, "long_query_time", long_query_time)
        pulumi.set(__self__, "mandatory_roles", mandatory_roles)
        pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        pulumi.set(__self__, "max_binlog_cache_size", max_binlog_cache_size)
        pulumi.set(__self__, "max_connect_errors", max_connect_errors)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_execution_time", max_execution_time)
        pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        pulumi.set(__self__, "max_prepared_stmt_count", max_prepared_stmt_count)
        pulumi.set(__self__, "max_seeks_for_key", max_seeks_for_key)
        pulumi.set(__self__, "max_user_connections", max_user_connections)
        pulumi.set(__self__, "mysql_firewall_mode", mysql_firewall_mode)
        pulumi.set(__self__, "mysql_zstd_default_compression_level", mysql_zstd_default_compression_level)
        pulumi.set(__self__, "mysqlx_connect_timeout", mysqlx_connect_timeout)
        pulumi.set(__self__, "mysqlx_deflate_default_compression_level", mysqlx_deflate_default_compression_level)
        pulumi.set(__self__, "mysqlx_deflate_max_client_compression_level", mysqlx_deflate_max_client_compression_level)
        pulumi.set(__self__, "mysqlx_document_id_unique_prefix", mysqlx_document_id_unique_prefix)
        pulumi.set(__self__, "mysqlx_enable_hello_notice", mysqlx_enable_hello_notice)
        pulumi.set(__self__, "mysqlx_idle_worker_thread_timeout", mysqlx_idle_worker_thread_timeout)
        pulumi.set(__self__, "mysqlx_interactive_timeout", mysqlx_interactive_timeout)
        pulumi.set(__self__, "mysqlx_lz4default_compression_level", mysqlx_lz4default_compression_level)
        pulumi.set(__self__, "mysqlx_lz4max_client_compression_level", mysqlx_lz4max_client_compression_level)
        pulumi.set(__self__, "mysqlx_max_allowed_packet", mysqlx_max_allowed_packet)
        pulumi.set(__self__, "mysqlx_min_worker_threads", mysqlx_min_worker_threads)
        pulumi.set(__self__, "mysqlx_read_timeout", mysqlx_read_timeout)
        pulumi.set(__self__, "mysqlx_wait_timeout", mysqlx_wait_timeout)
        pulumi.set(__self__, "mysqlx_write_timeout", mysqlx_write_timeout)
        pulumi.set(__self__, "mysqlx_zstd_default_compression_level", mysqlx_zstd_default_compression_level)
        pulumi.set(__self__, "mysqlx_zstd_max_client_compression_level", mysqlx_zstd_max_client_compression_level)
        pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        pulumi.set(__self__, "optimizer_switch", optimizer_switch)
        pulumi.set(__self__, "parser_max_mem_size", parser_max_mem_size)
        pulumi.set(__self__, "query_alloc_block_size", query_alloc_block_size)
        pulumi.set(__self__, "query_prealloc_size", query_prealloc_size)
        pulumi.set(__self__, "range_optimizer_max_mem_size", range_optimizer_max_mem_size)
        pulumi.set(__self__, "regexp_time_limit", regexp_time_limit)
        pulumi.set(__self__, "relay_log_space_limit", relay_log_space_limit)
        pulumi.set(__self__, "replica_net_timeout", replica_net_timeout)
        pulumi.set(__self__, "replica_parallel_workers", replica_parallel_workers)
        pulumi.set(__self__, "replica_type_conversions", replica_type_conversions)
        pulumi.set(__self__, "require_secure_transport", require_secure_transport)
        pulumi.set(__self__, "skip_name_resolve", skip_name_resolve)
        pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        pulumi.set(__self__, "sql_generate_invisible_primary_key", sql_generate_invisible_primary_key)
        pulumi.set(__self__, "sql_mode", sql_mode)
        pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        pulumi.set(__self__, "sql_warnings", sql_warnings)
        pulumi.set(__self__, "table_definition_cache", table_definition_cache)
        pulumi.set(__self__, "table_open_cache", table_open_cache)
        pulumi.set(__self__, "temptable_max_ram", temptable_max_ram)
        pulumi.set(__self__, "thread_pool_dedicated_listeners", thread_pool_dedicated_listeners)
        pulumi.set(__self__, "thread_pool_max_transactions_limit", thread_pool_max_transactions_limit)
        pulumi.set(__self__, "thread_pool_query_threads_per_group", thread_pool_query_threads_per_group)
        pulumi.set(__self__, "thread_pool_size", thread_pool_size)
        pulumi.set(__self__, "thread_pool_transaction_delay", thread_pool_transaction_delay)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        pulumi.set(__self__, "transaction_isolation", transaction_isolation)
        pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="autoIncrementIncrement")
    def auto_increment_increment(self) -> _builtins.int:
        """
        auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
        """
        return pulumi.get(self, "auto_increment_increment")

    @_builtins.property
    @pulumi.getter(name="autoIncrementOffset")
    def auto_increment_offset(self) -> _builtins.int:
        """
        This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
        """
        return pulumi.get(self, "auto_increment_offset")

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> _builtins.bool:
        """
        ("autocommit")
        """
        return pulumi.get(self, "autocommit")

    @_builtins.property
    @pulumi.getter(name="bigTables")
    def big_tables(self) -> _builtins.bool:
        """
        If enabled, the server stores all temporary tables on disk rather than in memory.
        """
        return pulumi.get(self, "big_tables")

    @_builtins.property
    @pulumi.getter(name="binlogExpireLogsSeconds")
    def binlog_expire_logs_seconds(self) -> _builtins.int:
        """
        Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        """
        return pulumi.get(self, "binlog_expire_logs_seconds")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncDelay")
    def binlog_group_commit_sync_delay(self) -> _builtins.int:
        """
        Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
        """
        return pulumi.get(self, "binlog_group_commit_sync_delay")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncNoDelayCount")
    def binlog_group_commit_sync_no_delay_count(self) -> _builtins.int:
        """
        The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
        """
        return pulumi.get(self, "binlog_group_commit_sync_no_delay_count")

    @_builtins.property
    @pulumi.getter(name="binlogRowMetadata")
    def binlog_row_metadata(self) -> _builtins.str:
        """
        Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        """
        return pulumi.get(self, "binlog_row_metadata")

    @_builtins.property
    @pulumi.getter(name="binlogRowValueOptions")
    def binlog_row_value_options(self) -> _builtins.str:
        """
        When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        """
        return pulumi.get(self, "binlog_row_value_options")

    @_builtins.property
    @pulumi.getter(name="binlogTransactionCompression")
    def binlog_transaction_compression(self) -> _builtins.bool:
        """
        Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        """
        return pulumi.get(self, "binlog_transaction_compression")

    @_builtins.property
    @pulumi.getter(name="blockEncryptionMode")
    def block_encryption_mode(self) -> _builtins.str:
        """
        This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
        """
        return pulumi.get(self, "block_encryption_mode")

    @_builtins.property
    @pulumi.getter(name="characterSetServer")
    def character_set_server(self) -> _builtins.str:
        """
        The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
        """
        return pulumi.get(self, "character_set_server")

    @_builtins.property
    @pulumi.getter(name="collationServer")
    def collation_server(self) -> _builtins.str:
        """
        The server's default collation.
        """
        return pulumi.get(self, "collation_server")

    @_builtins.property
    @pulumi.getter(name="completionType")
    def completion_type(self) -> _builtins.str:
        """
        ("completion_type")
        """
        return pulumi.get(self, "completion_type")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> _builtins.int:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryChunkSize")
    def connection_memory_chunk_size(self) -> _builtins.int:
        """
        Set the chunking size for updates to the global memory usage counter Global_connection_memory.
        """
        return pulumi.get(self, "connection_memory_chunk_size")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryLimit")
    def connection_memory_limit(self) -> _builtins.str:
        """
        Set the maximum amount of memory that can be used by a single user connection.
        """
        return pulumi.get(self, "connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="cteMaxRecursionDepth")
    def cte_max_recursion_depth(self) -> _builtins.str:
        """
        ("cte_max_recursion_depth")
        """
        return pulumi.get(self, "cte_max_recursion_depth")

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationPlugin")
    def default_authentication_plugin(self) -> _builtins.str:
        """
        The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
        """
        return pulumi.get(self, "default_authentication_plugin")

    @_builtins.property
    @pulumi.getter(name="explainFormat")
    def explain_format(self) -> _builtins.str:
        """
        This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
        """
        return pulumi.get(self, "explain_format")

    @_builtins.property
    @pulumi.getter(name="explicitDefaultsForTimestamp")
    def explicit_defaults_for_timestamp(self) -> _builtins.bool:
        """
        This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
        """
        return pulumi.get(self, "explicit_defaults_for_timestamp")

    @_builtins.property
    @pulumi.getter(name="foreignKeyChecks")
    def foreign_key_checks(self) -> _builtins.bool:
        """
        ("foreign_key_checks")
        """
        return pulumi.get(self, "foreign_key_checks")

    @_builtins.property
    @pulumi.getter(name="generatedRandomPasswordLength")
    @_utilities.deprecated("""The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def generated_random_password_length(self) -> _builtins.int:
        """
        ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "generated_random_password_length")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryLimit")
    def global_connection_memory_limit(self) -> _builtins.str:
        """
        Set the total amount of memory that can be used by all user connections.
        """
        return pulumi.get(self, "global_connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryTracking")
    def global_connection_memory_tracking(self) -> _builtins.bool:
        """
        Determines whether the MySQL server calculates Global_connection_memory.
        """
        return pulumi.get(self, "global_connection_memory_tracking")

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> _builtins.str:
        """
        Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="groupReplicationConsistency")
    def group_replication_consistency(self) -> _builtins.str:
        """
        * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
        * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
        * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        """
        return pulumi.get(self, "group_replication_consistency")

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> _builtins.int:
        """
        ("information_schema_stats_expiry")
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="innodbAdaptiveHashIndex")
    def innodb_adaptive_hash_index(self) -> _builtins.bool:
        """
        Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
        """
        return pulumi.get(self, "innodb_adaptive_hash_index")

    @_builtins.property
    @pulumi.getter(name="innodbAutoincLockMode")
    def innodb_autoinc_lock_mode(self) -> _builtins.int:
        """
        The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
        """
        return pulumi.get(self, "innodb_autoinc_lock_mode")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolDumpPct")
    def innodb_buffer_pool_dump_pct(self) -> _builtins.int:
        """
        Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
        """
        return pulumi.get(self, "innodb_buffer_pool_dump_pct")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolInstances")
    def innodb_buffer_pool_instances(self) -> _builtins.int:
        """
        ("innodb_buffer_pool_instances")
        """
        return pulumi.get(self, "innodb_buffer_pool_instances")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolSize")
    def innodb_buffer_pool_size(self) -> _builtins.str:
        """
        The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
        """
        return pulumi.get(self, "innodb_buffer_pool_size")

    @_builtins.property
    @pulumi.getter(name="innodbChangeBuffering")
    def innodb_change_buffering(self) -> _builtins.str:
        """
        Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
        """
        return pulumi.get(self, "innodb_change_buffering")

    @_builtins.property
    @pulumi.getter(name="innodbDdlBufferSize")
    def innodb_ddl_buffer_size(self) -> _builtins.str:
        """
        innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        """
        return pulumi.get(self, "innodb_ddl_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbDdlThreads")
    def innodb_ddl_threads(self) -> _builtins.int:
        """
        innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        """
        return pulumi.get(self, "innodb_ddl_threads")

    @_builtins.property
    @pulumi.getter(name="innodbFtEnableStopword")
    def innodb_ft_enable_stopword(self) -> _builtins.bool:
        """
        ("innodb_ft_enable_stopword")
        """
        return pulumi.get(self, "innodb_ft_enable_stopword")

    @_builtins.property
    @pulumi.getter(name="innodbFtMaxTokenSize")
    def innodb_ft_max_token_size(self) -> _builtins.int:
        """
        ("innodb_ft_max_token_size")
        """
        return pulumi.get(self, "innodb_ft_max_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> _builtins.int:
        """
        ("innodb_ft_min_token_size")
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtNumWordOptimize")
    def innodb_ft_num_word_optimize(self) -> _builtins.int:
        """
        ("innodb_ft_num_word_optimize")
        """
        return pulumi.get(self, "innodb_ft_num_word_optimize")

    @_builtins.property
    @pulumi.getter(name="innodbFtResultCacheLimit")
    def innodb_ft_result_cache_limit(self) -> _builtins.str:
        """
        ("innodb_ft_result_cache_limit")
        """
        return pulumi.get(self, "innodb_ft_result_cache_limit")

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> _builtins.str:
        """
        ("innodb_ft_server_stopword_table")
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> _builtins.int:
        """
        ("innodb_lock_wait_timeout")
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbLogWriterThreads")
    def innodb_log_writer_threads(self) -> _builtins.bool:
        """
        Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
        """
        return pulumi.get(self, "innodb_log_writer_threads")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLag")
    def innodb_max_purge_lag(self) -> _builtins.str:
        """
        The desired maximum purge lag in terms of transactions.
        """
        return pulumi.get(self, "innodb_max_purge_lag")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLagDelay")
    def innodb_max_purge_lag_delay(self) -> _builtins.int:
        """
        The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
        """
        return pulumi.get(self, "innodb_max_purge_lag_delay")

    @_builtins.property
    @pulumi.getter(name="innodbNumaInterleave")
    def innodb_numa_interleave(self) -> _builtins.bool:
        """
        Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
        """
        return pulumi.get(self, "innodb_numa_interleave")

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> _builtins.str:
        """
        Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbRedoLogCapacity")
    def innodb_redo_log_capacity(self) -> _builtins.str:
        """
        Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
        """
        return pulumi.get(self, "innodb_redo_log_capacity")

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> _builtins.bool:
        """
        InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbSortBufferSize")
    def innodb_sort_buffer_size(self) -> _builtins.int:
        """
        This variable defines:
        * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
        * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
        """
        return pulumi.get(self, "innodb_sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbStatsPersistentSamplePages")
    def innodb_stats_persistent_sample_pages(self) -> _builtins.str:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
        """
        return pulumi.get(self, "innodb_stats_persistent_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStatsTransientSamplePages")
    def innodb_stats_transient_sample_pages(self) -> _builtins.str:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
        """
        return pulumi.get(self, "innodb_stats_transient_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStrictMode")
    def innodb_strict_mode(self) -> _builtins.bool:
        """
        When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
        """
        return pulumi.get(self, "innodb_strict_mode")

    @_builtins.property
    @pulumi.getter(name="innodbUndoLogTruncate")
    def innodb_undo_log_truncate(self) -> _builtins.bool:
        """
        When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
        """
        return pulumi.get(self, "innodb_undo_log_truncate")

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="joinBufferSize")
    def join_buffer_size(self) -> _builtins.str:
        """
        The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
        """
        return pulumi.get(self, "join_buffer_size")

    @_builtins.property
    @pulumi.getter(name="localInfile")
    def local_infile(self) -> _builtins.bool:
        """
        This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side.
        """
        return pulumi.get(self, "local_infile")

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> _builtins.int:
        """
        If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
        """
        return pulumi.get(self, "long_query_time")

    @_builtins.property
    @pulumi.getter(name="mandatoryRoles")
    def mandatory_roles(self) -> _builtins.str:
        """
        ("mandatory_roles")
        """
        return pulumi.get(self, "mandatory_roles")

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> _builtins.int:
        """
        The maximum size of one packet or any generated/intermediate string.
        """
        return pulumi.get(self, "max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="maxBinlogCacheSize")
    def max_binlog_cache_size(self) -> _builtins.str:
        """
        Sets the size of the transaction cache.
        """
        return pulumi.get(self, "max_binlog_cache_size")

    @_builtins.property
    @pulumi.getter(name="maxConnectErrors")
    def max_connect_errors(self) -> _builtins.str:
        """
        ("max_connect_errors")
        """
        return pulumi.get(self, "max_connect_errors")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        ("max_connections")
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxExecutionTime")
    def max_execution_time(self) -> _builtins.str:
        """
        ("max_execution_time")
        """
        return pulumi.get(self, "max_execution_time")

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> _builtins.str:
        """
        This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
        """
        return pulumi.get(self, "max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="maxPreparedStmtCount")
    def max_prepared_stmt_count(self) -> _builtins.int:
        """
        ("max_prepared_stmt_count")
        """
        return pulumi.get(self, "max_prepared_stmt_count")

    @_builtins.property
    @pulumi.getter(name="maxSeeksForKey")
    def max_seeks_for_key(self) -> _builtins.str:
        """
        Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
        """
        return pulumi.get(self, "max_seeks_for_key")

    @_builtins.property
    @pulumi.getter(name="maxUserConnections")
    def max_user_connections(self) -> _builtins.str:
        """
        The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
        """
        return pulumi.get(self, "max_user_connections")

    @_builtins.property
    @pulumi.getter(name="mysqlFirewallMode")
    def mysql_firewall_mode(self) -> _builtins.bool:
        """
        ("mysql_firewall_mode")
        """
        return pulumi.get(self, "mysql_firewall_mode")

    @_builtins.property
    @pulumi.getter(name="mysqlZstdDefaultCompressionLevel")
    @_utilities.deprecated("""The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysql_zstd_default_compression_level(self) -> _builtins.int:
        """
        DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        """
        return pulumi.get(self, "mysql_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxConnectTimeout")
    def mysqlx_connect_timeout(self) -> _builtins.int:
        """
        The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
        """
        return pulumi.get(self, "mysqlx_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateDefaultCompressionLevel")
    def mysqlx_deflate_default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateMaxClientCompressionLevel")
    def mysqlx_deflate_max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDocumentIdUniquePrefix")
    @_utilities.deprecated("""The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_document_id_unique_prefix(self) -> _builtins.int:
        """
        ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_document_id_unique_prefix")

    @_builtins.property
    @pulumi.getter(name="mysqlxEnableHelloNotice")
    def mysqlx_enable_hello_notice(self) -> _builtins.bool:
        """
        ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_enable_hello_notice")

    @_builtins.property
    @pulumi.getter(name="mysqlxIdleWorkerThreadTimeout")
    @_utilities.deprecated("""The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_idle_worker_thread_timeout(self) -> _builtins.int:
        """
        ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_idle_worker_thread_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxInteractiveTimeout")
    def mysqlx_interactive_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for interactive clients to timeout.
        """
        return pulumi.get(self, "mysqlx_interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4defaultCompressionLevel")
    def mysqlx_lz4default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4maxClientCompressionLevel")
    def mysqlx_lz4max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxMaxAllowedPacket")
    def mysqlx_max_allowed_packet(self) -> _builtins.int:
        """
        The maximum size of network packets that can be received by X Plugin.
        """
        return pulumi.get(self, "mysqlx_max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="mysqlxMinWorkerThreads")
    @_utilities.deprecated("""The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_min_worker_threads(self) -> _builtins.int:
        """
        ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_min_worker_threads")

    @_builtins.property
    @pulumi.getter(name="mysqlxReadTimeout")
    def mysqlx_read_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
        """
        return pulumi.get(self, "mysqlx_read_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWaitTimeout")
    def mysqlx_wait_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for activity on a connection.
        """
        return pulumi.get(self, "mysqlx_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWriteTimeout")
    def mysqlx_write_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
        """
        return pulumi.get(self, "mysqlx_write_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdDefaultCompressionLevel")
    def mysqlx_zstd_default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdMaxClientCompressionLevel")
    def mysqlx_zstd_max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="optimizerSwitch")
    def optimizer_switch(self) -> _builtins.str:
        """
        The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
        """
        return pulumi.get(self, "optimizer_switch")

    @_builtins.property
    @pulumi.getter(name="parserMaxMemSize")
    def parser_max_mem_size(self) -> _builtins.str:
        """
        ("parser_max_mem_size")
        """
        return pulumi.get(self, "parser_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="queryAllocBlockSize")
    @_utilities.deprecated("""The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def query_alloc_block_size(self) -> _builtins.str:
        """
        ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_alloc_block_size")

    @_builtins.property
    @pulumi.getter(name="queryPreallocSize")
    def query_prealloc_size(self) -> _builtins.str:
        """
        ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_prealloc_size")

    @_builtins.property
    @pulumi.getter(name="rangeOptimizerMaxMemSize")
    @_utilities.deprecated("""The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def range_optimizer_max_mem_size(self) -> _builtins.str:
        """
        The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans.
        """
        return pulumi.get(self, "range_optimizer_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="regexpTimeLimit")
    def regexp_time_limit(self) -> _builtins.int:
        """
        regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        """
        return pulumi.get(self, "regexp_time_limit")

    @_builtins.property
    @pulumi.getter(name="relayLogSpaceLimit")
    def relay_log_space_limit(self) -> _builtins.str:
        """
        The maximum amount of space to use for all relay logs.
        """
        return pulumi.get(self, "relay_log_space_limit")

    @_builtins.property
    @pulumi.getter(name="replicaNetTimeout")
    def replica_net_timeout(self) -> _builtins.int:
        """
        Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
        """
        return pulumi.get(self, "replica_net_timeout")

    @_builtins.property
    @pulumi.getter(name="replicaParallelWorkers")
    def replica_parallel_workers(self) -> _builtins.int:
        """
        Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
        """
        return pulumi.get(self, "replica_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="replicaTypeConversions")
    def replica_type_conversions(self) -> _builtins.str:
        """
        From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
        """
        return pulumi.get(self, "replica_type_conversions")

    @_builtins.property
    @pulumi.getter(name="requireSecureTransport")
    def require_secure_transport(self) -> _builtins.bool:
        """
        Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
        """
        return pulumi.get(self, "require_secure_transport")

    @_builtins.property
    @pulumi.getter(name="skipNameResolve")
    def skip_name_resolve(self) -> _builtins.bool:
        """
        Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
        """
        return pulumi.get(self, "skip_name_resolve")

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> _builtins.str:
        """
        Each session that must perform a sort allocates a buffer of this size.
        """
        return pulumi.get(self, "sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="sqlGenerateInvisiblePrimaryKey")
    def sql_generate_invisible_primary_key(self) -> _builtins.bool:
        """
        Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
        """
        return pulumi.get(self, "sql_generate_invisible_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> _builtins.str:
        """
        ("sql_mode")
        """
        return pulumi.get(self, "sql_mode")

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> _builtins.bool:
        """
        ("sql_require_primary_key")
        """
        return pulumi.get(self, "sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlWarnings")
    def sql_warnings(self) -> _builtins.bool:
        """
        ("sql_warnings")
        """
        return pulumi.get(self, "sql_warnings")

    @_builtins.property
    @pulumi.getter(name="tableDefinitionCache")
    def table_definition_cache(self) -> _builtins.int:
        """
        The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
        """
        return pulumi.get(self, "table_definition_cache")

    @_builtins.property
    @pulumi.getter(name="tableOpenCache")
    def table_open_cache(self) -> _builtins.int:
        """
        The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
        """
        return pulumi.get(self, "table_open_cache")

    @_builtins.property
    @pulumi.getter(name="temptableMaxRam")
    def temptable_max_ram(self) -> _builtins.str:
        """
        Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
        """
        return pulumi.get(self, "temptable_max_ram")

    @_builtins.property
    @pulumi.getter(name="threadPoolDedicatedListeners")
    def thread_pool_dedicated_listeners(self) -> _builtins.bool:
        """
        Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        """
        return pulumi.get(self, "thread_pool_dedicated_listeners")

    @_builtins.property
    @pulumi.getter(name="threadPoolMaxTransactionsLimit")
    def thread_pool_max_transactions_limit(self) -> _builtins.int:
        """
        Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        """
        return pulumi.get(self, "thread_pool_max_transactions_limit")

    @_builtins.property
    @pulumi.getter(name="threadPoolQueryThreadsPerGroup")
    def thread_pool_query_threads_per_group(self) -> _builtins.int:
        """
        The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions.
        """
        return pulumi.get(self, "thread_pool_query_threads_per_group")

    @_builtins.property
    @pulumi.getter(name="threadPoolSize")
    def thread_pool_size(self) -> _builtins.int:
        """
        The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
        """
        return pulumi.get(self, "thread_pool_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolTransactionDelay")
    def thread_pool_transaction_delay(self) -> _builtins.int:
        """
        The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running.
        """
        return pulumi.get(self, "thread_pool_transaction_delay")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Initializes the time zone for each client that connects.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> _builtins.str:
        """
        The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
        """
        return pulumi.get(self, "tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="transactionIsolation")
    def transaction_isolation(self) -> _builtins.str:
        """
        ("transaction_isolation")
        """
        return pulumi.get(self, "transaction_isolation")

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")


@pulumi.output_type
class GetMysqlConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 init_variables: Sequence['outputs.GetMysqlConfigurationsConfigurationInitVariableResult'],
                 parent_configuration_id: _builtins.str,
                 shape_name: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str,
                 variables: Sequence['outputs.GetMysqlConfigurationsConfigurationVariableResult']):
        """
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: User-provided data about the Configuration.
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the Configuration.
        :param Sequence['GetMysqlConfigurationsConfigurationInitVariableArgs'] init_variables: User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        :param _builtins.str parent_configuration_id: The OCID of the Configuration from which this Configuration is "derived". This is entirely a metadata relationship. There is no relation between the values in this Configuration and its parent.
        :param _builtins.str shape_name: The requested Shape name.
        :param _builtins.str state: Configuration Lifecycle State
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_updated: The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str type: The requested Configuration types.
        :param Sequence['GetMysqlConfigurationsConfigurationVariableArgs'] variables: User-defined service variables.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "init_variables", init_variables)
        pulumi.set(__self__, "parent_configuration_id", parent_configuration_id)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        User-provided data about the Configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the Configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initVariables")
    def init_variables(self) -> Sequence['outputs.GetMysqlConfigurationsConfigurationInitVariableResult']:
        """
        User-defined service variables set only at DB system initialization. These variables cannot be changed later at runtime.
        """
        return pulumi.get(self, "init_variables")

    @_builtins.property
    @pulumi.getter(name="parentConfigurationId")
    def parent_configuration_id(self) -> _builtins.str:
        """
        The OCID of the Configuration from which this Configuration is "derived". This is entirely a metadata relationship. There is no relation between the values in this Configuration and its parent.
        """
        return pulumi.get(self, "parent_configuration_id")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The requested Shape name.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Configuration Lifecycle State
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Configuration was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Configuration was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The requested Configuration types.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetMysqlConfigurationsConfigurationVariableResult']:
        """
        User-defined service variables.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetMysqlConfigurationsConfigurationInitVariableResult(dict):
    def __init__(__self__, *,
                 lower_case_table_names: _builtins.str):
        """
        :param _builtins.str lower_case_table_names: Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
        """
        pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> _builtins.str:
        """
        Represents the MySQL server system variable lower_case_table_names (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names).
        """
        return pulumi.get(self, "lower_case_table_names")


@pulumi.output_type
class GetMysqlConfigurationsConfigurationVariableResult(dict):
    def __init__(__self__, *,
                 auto_increment_increment: _builtins.int,
                 auto_increment_offset: _builtins.int,
                 autocommit: _builtins.bool,
                 big_tables: _builtins.bool,
                 binlog_expire_logs_seconds: _builtins.int,
                 binlog_group_commit_sync_delay: _builtins.int,
                 binlog_group_commit_sync_no_delay_count: _builtins.int,
                 binlog_row_metadata: _builtins.str,
                 binlog_row_value_options: _builtins.str,
                 binlog_transaction_compression: _builtins.bool,
                 block_encryption_mode: _builtins.str,
                 character_set_server: _builtins.str,
                 collation_server: _builtins.str,
                 completion_type: _builtins.str,
                 connect_timeout: _builtins.int,
                 connection_memory_chunk_size: _builtins.int,
                 connection_memory_limit: _builtins.str,
                 cte_max_recursion_depth: _builtins.str,
                 default_authentication_plugin: _builtins.str,
                 explain_format: _builtins.str,
                 explicit_defaults_for_timestamp: _builtins.bool,
                 foreign_key_checks: _builtins.bool,
                 generated_random_password_length: _builtins.int,
                 global_connection_memory_limit: _builtins.str,
                 global_connection_memory_tracking: _builtins.bool,
                 group_concat_max_len: _builtins.str,
                 group_replication_consistency: _builtins.str,
                 information_schema_stats_expiry: _builtins.int,
                 innodb_adaptive_hash_index: _builtins.bool,
                 innodb_autoinc_lock_mode: _builtins.int,
                 innodb_buffer_pool_dump_pct: _builtins.int,
                 innodb_buffer_pool_instances: _builtins.int,
                 innodb_buffer_pool_size: _builtins.str,
                 innodb_change_buffering: _builtins.str,
                 innodb_ddl_buffer_size: _builtins.str,
                 innodb_ddl_threads: _builtins.int,
                 innodb_ft_enable_stopword: _builtins.bool,
                 innodb_ft_max_token_size: _builtins.int,
                 innodb_ft_min_token_size: _builtins.int,
                 innodb_ft_num_word_optimize: _builtins.int,
                 innodb_ft_result_cache_limit: _builtins.str,
                 innodb_ft_server_stopword_table: _builtins.str,
                 innodb_lock_wait_timeout: _builtins.int,
                 innodb_log_writer_threads: _builtins.bool,
                 innodb_max_purge_lag: _builtins.str,
                 innodb_max_purge_lag_delay: _builtins.int,
                 innodb_numa_interleave: _builtins.bool,
                 innodb_online_alter_log_max_size: _builtins.str,
                 innodb_redo_log_capacity: _builtins.str,
                 innodb_rollback_on_timeout: _builtins.bool,
                 innodb_sort_buffer_size: _builtins.int,
                 innodb_stats_persistent_sample_pages: _builtins.str,
                 innodb_stats_transient_sample_pages: _builtins.str,
                 innodb_strict_mode: _builtins.bool,
                 innodb_undo_log_truncate: _builtins.bool,
                 interactive_timeout: _builtins.int,
                 join_buffer_size: _builtins.str,
                 local_infile: _builtins.bool,
                 long_query_time: _builtins.int,
                 mandatory_roles: _builtins.str,
                 max_allowed_packet: _builtins.int,
                 max_binlog_cache_size: _builtins.str,
                 max_connect_errors: _builtins.str,
                 max_connections: _builtins.int,
                 max_execution_time: _builtins.str,
                 max_heap_table_size: _builtins.str,
                 max_prepared_stmt_count: _builtins.int,
                 max_seeks_for_key: _builtins.str,
                 max_user_connections: _builtins.str,
                 mysql_firewall_mode: _builtins.bool,
                 mysql_zstd_default_compression_level: _builtins.int,
                 mysqlx_connect_timeout: _builtins.int,
                 mysqlx_deflate_default_compression_level: _builtins.int,
                 mysqlx_deflate_max_client_compression_level: _builtins.int,
                 mysqlx_document_id_unique_prefix: _builtins.int,
                 mysqlx_enable_hello_notice: _builtins.bool,
                 mysqlx_idle_worker_thread_timeout: _builtins.int,
                 mysqlx_interactive_timeout: _builtins.int,
                 mysqlx_lz4default_compression_level: _builtins.int,
                 mysqlx_lz4max_client_compression_level: _builtins.int,
                 mysqlx_max_allowed_packet: _builtins.int,
                 mysqlx_min_worker_threads: _builtins.int,
                 mysqlx_read_timeout: _builtins.int,
                 mysqlx_wait_timeout: _builtins.int,
                 mysqlx_write_timeout: _builtins.int,
                 mysqlx_zstd_default_compression_level: _builtins.int,
                 mysqlx_zstd_max_client_compression_level: _builtins.int,
                 net_read_timeout: _builtins.int,
                 net_write_timeout: _builtins.int,
                 optimizer_switch: _builtins.str,
                 parser_max_mem_size: _builtins.str,
                 query_alloc_block_size: _builtins.str,
                 query_prealloc_size: _builtins.str,
                 range_optimizer_max_mem_size: _builtins.str,
                 regexp_time_limit: _builtins.int,
                 relay_log_space_limit: _builtins.str,
                 replica_net_timeout: _builtins.int,
                 replica_parallel_workers: _builtins.int,
                 replica_type_conversions: _builtins.str,
                 require_secure_transport: _builtins.bool,
                 skip_name_resolve: _builtins.bool,
                 sort_buffer_size: _builtins.str,
                 sql_generate_invisible_primary_key: _builtins.bool,
                 sql_mode: _builtins.str,
                 sql_require_primary_key: _builtins.bool,
                 sql_warnings: _builtins.bool,
                 table_definition_cache: _builtins.int,
                 table_open_cache: _builtins.int,
                 temptable_max_ram: _builtins.str,
                 thread_pool_dedicated_listeners: _builtins.bool,
                 thread_pool_max_transactions_limit: _builtins.int,
                 thread_pool_query_threads_per_group: _builtins.int,
                 thread_pool_size: _builtins.int,
                 thread_pool_transaction_delay: _builtins.int,
                 time_zone: _builtins.str,
                 tmp_table_size: _builtins.str,
                 transaction_isolation: _builtins.str,
                 wait_timeout: _builtins.int):
        """
        :param _builtins.int auto_increment_increment: auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
        :param _builtins.int auto_increment_offset: This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
        :param _builtins.bool autocommit: ("autocommit")
        :param _builtins.bool big_tables: If enabled, the server stores all temporary tables on disk rather than in memory.
        :param _builtins.int binlog_expire_logs_seconds: Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        :param _builtins.int binlog_group_commit_sync_delay: Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
        :param _builtins.int binlog_group_commit_sync_no_delay_count: The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
        :param _builtins.str binlog_row_metadata: Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        :param _builtins.str binlog_row_value_options: When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        :param _builtins.bool binlog_transaction_compression: Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        :param _builtins.str block_encryption_mode: This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
        :param _builtins.str character_set_server: The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
        :param _builtins.str collation_server: The server's default collation.
        :param _builtins.str completion_type: ("completion_type")
        :param _builtins.int connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        :param _builtins.int connection_memory_chunk_size: Set the chunking size for updates to the global memory usage counter Global_connection_memory.
        :param _builtins.str connection_memory_limit: Set the maximum amount of memory that can be used by a single user connection.
        :param _builtins.str cte_max_recursion_depth: ("cte_max_recursion_depth")
        :param _builtins.str default_authentication_plugin: The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
        :param _builtins.str explain_format: This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
        :param _builtins.bool explicit_defaults_for_timestamp: This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
        :param _builtins.bool foreign_key_checks: ("foreign_key_checks")
        :param _builtins.int generated_random_password_length: ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str global_connection_memory_limit: Set the total amount of memory that can be used by all user connections.
        :param _builtins.bool global_connection_memory_tracking: Determines whether the MySQL server calculates Global_connection_memory.
        :param _builtins.str group_concat_max_len: Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
        :param _builtins.str group_replication_consistency: * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
               * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
               * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
               * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        :param _builtins.int information_schema_stats_expiry: ("information_schema_stats_expiry")
        :param _builtins.bool innodb_adaptive_hash_index: Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
        :param _builtins.int innodb_autoinc_lock_mode: The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
        :param _builtins.int innodb_buffer_pool_dump_pct: Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
        :param _builtins.int innodb_buffer_pool_instances: ("innodb_buffer_pool_instances")
        :param _builtins.str innodb_buffer_pool_size: The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
        :param _builtins.str innodb_change_buffering: Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
        :param _builtins.str innodb_ddl_buffer_size: innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        :param _builtins.int innodb_ddl_threads: innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        :param _builtins.bool innodb_ft_enable_stopword: ("innodb_ft_enable_stopword")
        :param _builtins.int innodb_ft_max_token_size: ("innodb_ft_max_token_size")
        :param _builtins.int innodb_ft_min_token_size: ("innodb_ft_min_token_size")
        :param _builtins.int innodb_ft_num_word_optimize: ("innodb_ft_num_word_optimize")
        :param _builtins.str innodb_ft_result_cache_limit: ("innodb_ft_result_cache_limit")
        :param _builtins.str innodb_ft_server_stopword_table: ("innodb_ft_server_stopword_table")
        :param _builtins.int innodb_lock_wait_timeout: ("innodb_lock_wait_timeout")
        :param _builtins.bool innodb_log_writer_threads: Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
        :param _builtins.str innodb_max_purge_lag: The desired maximum purge lag in terms of transactions.
        :param _builtins.int innodb_max_purge_lag_delay: The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
        :param _builtins.bool innodb_numa_interleave: Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
        :param _builtins.str innodb_online_alter_log_max_size: Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
        :param _builtins.str innodb_redo_log_capacity: Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
        :param _builtins.bool innodb_rollback_on_timeout: InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
        :param _builtins.int innodb_sort_buffer_size: This variable defines:
               * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
               * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
        :param _builtins.str innodb_stats_persistent_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
        :param _builtins.str innodb_stats_transient_sample_pages: The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
        :param _builtins.bool innodb_strict_mode: When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
        :param _builtins.bool innodb_undo_log_truncate: When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
        :param _builtins.int interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param _builtins.str join_buffer_size: The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
        :param _builtins.bool local_infile: This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side.
        :param _builtins.int long_query_time: If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
        :param _builtins.str mandatory_roles: ("mandatory_roles")
        :param _builtins.int max_allowed_packet: The maximum size of one packet or any generated/intermediate string.
        :param _builtins.str max_binlog_cache_size: Sets the size of the transaction cache.
        :param _builtins.str max_connect_errors: ("max_connect_errors")
        :param _builtins.int max_connections: ("max_connections")
        :param _builtins.str max_execution_time: ("max_execution_time")
        :param _builtins.str max_heap_table_size: This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
        :param _builtins.int max_prepared_stmt_count: ("max_prepared_stmt_count")
        :param _builtins.str max_seeks_for_key: Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
        :param _builtins.str max_user_connections: The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
        :param _builtins.bool mysql_firewall_mode: ("mysql_firewall_mode")
        :param _builtins.int mysql_zstd_default_compression_level: DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        :param _builtins.int mysqlx_connect_timeout: The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
        :param _builtins.int mysqlx_deflate_default_compression_level: Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        :param _builtins.int mysqlx_deflate_max_client_compression_level: Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        :param _builtins.int mysqlx_document_id_unique_prefix: ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.bool mysqlx_enable_hello_notice: ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_idle_worker_thread_timeout: ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_interactive_timeout: The number of seconds to wait for interactive clients to timeout.
        :param _builtins.int mysqlx_lz4default_compression_level: Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        :param _builtins.int mysqlx_lz4max_client_compression_level: Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        :param _builtins.int mysqlx_max_allowed_packet: The maximum size of network packets that can be received by X Plugin.
        :param _builtins.int mysqlx_min_worker_threads: ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.int mysqlx_read_timeout: The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
        :param _builtins.int mysqlx_wait_timeout: The number of seconds that X Plugin waits for activity on a connection.
        :param _builtins.int mysqlx_write_timeout: The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
        :param _builtins.int mysqlx_zstd_default_compression_level: Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        :param _builtins.int mysqlx_zstd_max_client_compression_level: Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        :param _builtins.int net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param _builtins.int net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param _builtins.str optimizer_switch: The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
        :param _builtins.str parser_max_mem_size: ("parser_max_mem_size")
        :param _builtins.str query_alloc_block_size: ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str query_prealloc_size: ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        :param _builtins.str range_optimizer_max_mem_size: The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans.
        :param _builtins.int regexp_time_limit: regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        :param _builtins.str relay_log_space_limit: The maximum amount of space to use for all relay logs.
        :param _builtins.int replica_net_timeout: Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
        :param _builtins.int replica_parallel_workers: Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
        :param _builtins.str replica_type_conversions: From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
        :param _builtins.bool require_secure_transport: Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
        :param _builtins.bool skip_name_resolve: Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
        :param _builtins.str sort_buffer_size: Each session that must perform a sort allocates a buffer of this size.
        :param _builtins.bool sql_generate_invisible_primary_key: Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
        :param _builtins.str sql_mode: ("sql_mode")
        :param _builtins.bool sql_require_primary_key: ("sql_require_primary_key")
        :param _builtins.bool sql_warnings: ("sql_warnings")
        :param _builtins.int table_definition_cache: The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
        :param _builtins.int table_open_cache: The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
        :param _builtins.str temptable_max_ram: Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
        :param _builtins.bool thread_pool_dedicated_listeners: Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        :param _builtins.int thread_pool_max_transactions_limit: Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        :param _builtins.int thread_pool_query_threads_per_group: The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions.
        :param _builtins.int thread_pool_size: The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
        :param _builtins.int thread_pool_transaction_delay: The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running.
        :param _builtins.str time_zone: Initializes the time zone for each client that connects.
        :param _builtins.str tmp_table_size: The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
        :param _builtins.str transaction_isolation: ("transaction_isolation")
        :param _builtins.int wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        pulumi.set(__self__, "auto_increment_increment", auto_increment_increment)
        pulumi.set(__self__, "auto_increment_offset", auto_increment_offset)
        pulumi.set(__self__, "autocommit", autocommit)
        pulumi.set(__self__, "big_tables", big_tables)
        pulumi.set(__self__, "binlog_expire_logs_seconds", binlog_expire_logs_seconds)
        pulumi.set(__self__, "binlog_group_commit_sync_delay", binlog_group_commit_sync_delay)
        pulumi.set(__self__, "binlog_group_commit_sync_no_delay_count", binlog_group_commit_sync_no_delay_count)
        pulumi.set(__self__, "binlog_row_metadata", binlog_row_metadata)
        pulumi.set(__self__, "binlog_row_value_options", binlog_row_value_options)
        pulumi.set(__self__, "binlog_transaction_compression", binlog_transaction_compression)
        pulumi.set(__self__, "block_encryption_mode", block_encryption_mode)
        pulumi.set(__self__, "character_set_server", character_set_server)
        pulumi.set(__self__, "collation_server", collation_server)
        pulumi.set(__self__, "completion_type", completion_type)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "connection_memory_chunk_size", connection_memory_chunk_size)
        pulumi.set(__self__, "connection_memory_limit", connection_memory_limit)
        pulumi.set(__self__, "cte_max_recursion_depth", cte_max_recursion_depth)
        pulumi.set(__self__, "default_authentication_plugin", default_authentication_plugin)
        pulumi.set(__self__, "explain_format", explain_format)
        pulumi.set(__self__, "explicit_defaults_for_timestamp", explicit_defaults_for_timestamp)
        pulumi.set(__self__, "foreign_key_checks", foreign_key_checks)
        pulumi.set(__self__, "generated_random_password_length", generated_random_password_length)
        pulumi.set(__self__, "global_connection_memory_limit", global_connection_memory_limit)
        pulumi.set(__self__, "global_connection_memory_tracking", global_connection_memory_tracking)
        pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        pulumi.set(__self__, "group_replication_consistency", group_replication_consistency)
        pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        pulumi.set(__self__, "innodb_adaptive_hash_index", innodb_adaptive_hash_index)
        pulumi.set(__self__, "innodb_autoinc_lock_mode", innodb_autoinc_lock_mode)
        pulumi.set(__self__, "innodb_buffer_pool_dump_pct", innodb_buffer_pool_dump_pct)
        pulumi.set(__self__, "innodb_buffer_pool_instances", innodb_buffer_pool_instances)
        pulumi.set(__self__, "innodb_buffer_pool_size", innodb_buffer_pool_size)
        pulumi.set(__self__, "innodb_change_buffering", innodb_change_buffering)
        pulumi.set(__self__, "innodb_ddl_buffer_size", innodb_ddl_buffer_size)
        pulumi.set(__self__, "innodb_ddl_threads", innodb_ddl_threads)
        pulumi.set(__self__, "innodb_ft_enable_stopword", innodb_ft_enable_stopword)
        pulumi.set(__self__, "innodb_ft_max_token_size", innodb_ft_max_token_size)
        pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        pulumi.set(__self__, "innodb_ft_num_word_optimize", innodb_ft_num_word_optimize)
        pulumi.set(__self__, "innodb_ft_result_cache_limit", innodb_ft_result_cache_limit)
        pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        pulumi.set(__self__, "innodb_log_writer_threads", innodb_log_writer_threads)
        pulumi.set(__self__, "innodb_max_purge_lag", innodb_max_purge_lag)
        pulumi.set(__self__, "innodb_max_purge_lag_delay", innodb_max_purge_lag_delay)
        pulumi.set(__self__, "innodb_numa_interleave", innodb_numa_interleave)
        pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        pulumi.set(__self__, "innodb_redo_log_capacity", innodb_redo_log_capacity)
        pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        pulumi.set(__self__, "innodb_sort_buffer_size", innodb_sort_buffer_size)
        pulumi.set(__self__, "innodb_stats_persistent_sample_pages", innodb_stats_persistent_sample_pages)
        pulumi.set(__self__, "innodb_stats_transient_sample_pages", innodb_stats_transient_sample_pages)
        pulumi.set(__self__, "innodb_strict_mode", innodb_strict_mode)
        pulumi.set(__self__, "innodb_undo_log_truncate", innodb_undo_log_truncate)
        pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        pulumi.set(__self__, "join_buffer_size", join_buffer_size)
        pulumi.set(__self__, "local_infile", local_infile)
        pulumi.set(__self__, "long_query_time", long_query_time)
        pulumi.set(__self__, "mandatory_roles", mandatory_roles)
        pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        pulumi.set(__self__, "max_binlog_cache_size", max_binlog_cache_size)
        pulumi.set(__self__, "max_connect_errors", max_connect_errors)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_execution_time", max_execution_time)
        pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        pulumi.set(__self__, "max_prepared_stmt_count", max_prepared_stmt_count)
        pulumi.set(__self__, "max_seeks_for_key", max_seeks_for_key)
        pulumi.set(__self__, "max_user_connections", max_user_connections)
        pulumi.set(__self__, "mysql_firewall_mode", mysql_firewall_mode)
        pulumi.set(__self__, "mysql_zstd_default_compression_level", mysql_zstd_default_compression_level)
        pulumi.set(__self__, "mysqlx_connect_timeout", mysqlx_connect_timeout)
        pulumi.set(__self__, "mysqlx_deflate_default_compression_level", mysqlx_deflate_default_compression_level)
        pulumi.set(__self__, "mysqlx_deflate_max_client_compression_level", mysqlx_deflate_max_client_compression_level)
        pulumi.set(__self__, "mysqlx_document_id_unique_prefix", mysqlx_document_id_unique_prefix)
        pulumi.set(__self__, "mysqlx_enable_hello_notice", mysqlx_enable_hello_notice)
        pulumi.set(__self__, "mysqlx_idle_worker_thread_timeout", mysqlx_idle_worker_thread_timeout)
        pulumi.set(__self__, "mysqlx_interactive_timeout", mysqlx_interactive_timeout)
        pulumi.set(__self__, "mysqlx_lz4default_compression_level", mysqlx_lz4default_compression_level)
        pulumi.set(__self__, "mysqlx_lz4max_client_compression_level", mysqlx_lz4max_client_compression_level)
        pulumi.set(__self__, "mysqlx_max_allowed_packet", mysqlx_max_allowed_packet)
        pulumi.set(__self__, "mysqlx_min_worker_threads", mysqlx_min_worker_threads)
        pulumi.set(__self__, "mysqlx_read_timeout", mysqlx_read_timeout)
        pulumi.set(__self__, "mysqlx_wait_timeout", mysqlx_wait_timeout)
        pulumi.set(__self__, "mysqlx_write_timeout", mysqlx_write_timeout)
        pulumi.set(__self__, "mysqlx_zstd_default_compression_level", mysqlx_zstd_default_compression_level)
        pulumi.set(__self__, "mysqlx_zstd_max_client_compression_level", mysqlx_zstd_max_client_compression_level)
        pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        pulumi.set(__self__, "optimizer_switch", optimizer_switch)
        pulumi.set(__self__, "parser_max_mem_size", parser_max_mem_size)
        pulumi.set(__self__, "query_alloc_block_size", query_alloc_block_size)
        pulumi.set(__self__, "query_prealloc_size", query_prealloc_size)
        pulumi.set(__self__, "range_optimizer_max_mem_size", range_optimizer_max_mem_size)
        pulumi.set(__self__, "regexp_time_limit", regexp_time_limit)
        pulumi.set(__self__, "relay_log_space_limit", relay_log_space_limit)
        pulumi.set(__self__, "replica_net_timeout", replica_net_timeout)
        pulumi.set(__self__, "replica_parallel_workers", replica_parallel_workers)
        pulumi.set(__self__, "replica_type_conversions", replica_type_conversions)
        pulumi.set(__self__, "require_secure_transport", require_secure_transport)
        pulumi.set(__self__, "skip_name_resolve", skip_name_resolve)
        pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        pulumi.set(__self__, "sql_generate_invisible_primary_key", sql_generate_invisible_primary_key)
        pulumi.set(__self__, "sql_mode", sql_mode)
        pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        pulumi.set(__self__, "sql_warnings", sql_warnings)
        pulumi.set(__self__, "table_definition_cache", table_definition_cache)
        pulumi.set(__self__, "table_open_cache", table_open_cache)
        pulumi.set(__self__, "temptable_max_ram", temptable_max_ram)
        pulumi.set(__self__, "thread_pool_dedicated_listeners", thread_pool_dedicated_listeners)
        pulumi.set(__self__, "thread_pool_max_transactions_limit", thread_pool_max_transactions_limit)
        pulumi.set(__self__, "thread_pool_query_threads_per_group", thread_pool_query_threads_per_group)
        pulumi.set(__self__, "thread_pool_size", thread_pool_size)
        pulumi.set(__self__, "thread_pool_transaction_delay", thread_pool_transaction_delay)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        pulumi.set(__self__, "transaction_isolation", transaction_isolation)
        pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="autoIncrementIncrement")
    def auto_increment_increment(self) -> _builtins.int:
        """
        auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication, and can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values, and each can assume an integer value between 1 and 65,535 inclusive.
        """
        return pulumi.get(self, "auto_increment_increment")

    @_builtins.property
    @pulumi.getter(name="autoIncrementOffset")
    def auto_increment_offset(self) -> _builtins.int:
        """
        This variable has a default value of 1. If it is left with its default value, and Group Replication is started on the server in multi-primary mode, it is changed to the server ID.
        """
        return pulumi.get(self, "auto_increment_offset")

    @_builtins.property
    @pulumi.getter
    def autocommit(self) -> _builtins.bool:
        """
        ("autocommit")
        """
        return pulumi.get(self, "autocommit")

    @_builtins.property
    @pulumi.getter(name="bigTables")
    def big_tables(self) -> _builtins.bool:
        """
        If enabled, the server stores all temporary tables on disk rather than in memory.
        """
        return pulumi.get(self, "big_tables")

    @_builtins.property
    @pulumi.getter(name="binlogExpireLogsSeconds")
    def binlog_expire_logs_seconds(self) -> _builtins.int:
        """
        Sets the binary log expiration period in seconds. binlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).
        """
        return pulumi.get(self, "binlog_expire_logs_seconds")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncDelay")
    def binlog_group_commit_sync_delay(self) -> _builtins.int:
        """
        Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk. There is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized together to disk at once, reducing the overall time to commit a group of transactions because the larger groups required fewer time units per group.
        """
        return pulumi.get(self, "binlog_group_commit_sync_delay")

    @_builtins.property
    @pulumi.getter(name="binlogGroupCommitSyncNoDelayCount")
    def binlog_group_commit_sync_no_delay_count(self) -> _builtins.int:
        """
        The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay. If binlog_group_commit_sync_delay is set to 0, then this option has no effect.
        """
        return pulumi.get(self, "binlog_group_commit_sync_no_delay_count")

    @_builtins.property
    @pulumi.getter(name="binlogRowMetadata")
    def binlog_row_metadata(self) -> _builtins.str:
        """
        Configures the amount of table metadata added to the binary log when using row-based logging. binlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).
        """
        return pulumi.get(self, "binlog_row_metadata")

    @_builtins.property
    @pulumi.getter(name="binlogRowValueOptions")
    def binlog_row_value_options(self) -> _builtins.str:
        """
        When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document. binlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).
        """
        return pulumi.get(self, "binlog_row_value_options")

    @_builtins.property
    @pulumi.getter(name="binlogTransactionCompression")
    def binlog_transaction_compression(self) -> _builtins.bool:
        """
        Enables compression for transactions that are written to binary log files on this server. binlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).
        """
        return pulumi.get(self, "binlog_transaction_compression")

    @_builtins.property
    @pulumi.getter(name="blockEncryptionMode")
    def block_encryption_mode(self) -> _builtins.str:
        """
        This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT(). block_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive. Permitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.
        """
        return pulumi.get(self, "block_encryption_mode")

    @_builtins.property
    @pulumi.getter(name="characterSetServer")
    def character_set_server(self) -> _builtins.str:
        """
        The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.
        """
        return pulumi.get(self, "character_set_server")

    @_builtins.property
    @pulumi.getter(name="collationServer")
    def collation_server(self) -> _builtins.str:
        """
        The server's default collation.
        """
        return pulumi.get(self, "collation_server")

    @_builtins.property
    @pulumi.getter(name="completionType")
    def completion_type(self) -> _builtins.str:
        """
        ("completion_type")
        """
        return pulumi.get(self, "completion_type")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> _builtins.int:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryChunkSize")
    def connection_memory_chunk_size(self) -> _builtins.int:
        """
        Set the chunking size for updates to the global memory usage counter Global_connection_memory.
        """
        return pulumi.get(self, "connection_memory_chunk_size")

    @_builtins.property
    @pulumi.getter(name="connectionMemoryLimit")
    def connection_memory_limit(self) -> _builtins.str:
        """
        Set the maximum amount of memory that can be used by a single user connection.
        """
        return pulumi.get(self, "connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="cteMaxRecursionDepth")
    def cte_max_recursion_depth(self) -> _builtins.str:
        """
        ("cte_max_recursion_depth")
        """
        return pulumi.get(self, "cte_max_recursion_depth")

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationPlugin")
    def default_authentication_plugin(self) -> _builtins.str:
        """
        The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted: mysql_native_password, sha256_password, caching_sha2_password.
        """
        return pulumi.get(self, "default_authentication_plugin")

    @_builtins.property
    @pulumi.getter(name="explainFormat")
    def explain_format(self) -> _builtins.str:
        """
        This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.
        """
        return pulumi.get(self, "explain_format")

    @_builtins.property
    @pulumi.getter(name="explicitDefaultsForTimestamp")
    def explicit_defaults_for_timestamp(self) -> _builtins.bool:
        """
        This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns. By default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.
        """
        return pulumi.get(self, "explicit_defaults_for_timestamp")

    @_builtins.property
    @pulumi.getter(name="foreignKeyChecks")
    def foreign_key_checks(self) -> _builtins.bool:
        """
        ("foreign_key_checks")
        """
        return pulumi.get(self, "foreign_key_checks")

    @_builtins.property
    @pulumi.getter(name="generatedRandomPasswordLength")
    @_utilities.deprecated("""The 'generated_random_password_length' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def generated_random_password_length(self) -> _builtins.int:
        """
        ("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "generated_random_password_length")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryLimit")
    def global_connection_memory_limit(self) -> _builtins.str:
        """
        Set the total amount of memory that can be used by all user connections.
        """
        return pulumi.get(self, "global_connection_memory_limit")

    @_builtins.property
    @pulumi.getter(name="globalConnectionMemoryTracking")
    def global_connection_memory_tracking(self) -> _builtins.bool:
        """
        Determines whether the MySQL server calculates Global_connection_memory.
        """
        return pulumi.get(self, "global_connection_memory_tracking")

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> _builtins.str:
        """
        Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="groupReplicationConsistency")
    def group_replication_consistency(self) -> _builtins.str:
        """
        * EVENTUAL: Both RO and RW transactions do not wait for preceding transactions to be applied before executing. A RW transaction does not wait for other members to apply a transaction. This means that a transaction could be externalized on one member before the others. This also means that in the event of a primary failover, the new primary can accept new RO and RW transactions before the previous primary transactions are all applied. RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.
        * BEFORE_ON_PRIMARY_FAILOVER: New RO or RW transactions with a newly elected primary that is applying backlog from the old primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens, intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal, but does depend on the size of the backlog.
        * BEFORE: A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * AFTER: A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions. This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction, by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        * BEFORE_AND_AFTER: A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.
        """
        return pulumi.get(self, "group_replication_consistency")

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> _builtins.int:
        """
        ("information_schema_stats_expiry")
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="innodbAdaptiveHashIndex")
    def innodb_adaptive_hash_index(self) -> _builtins.bool:
        """
        Whether the InnoDB adaptive hash index is enabled or disabled. It may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance. Because the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.
        """
        return pulumi.get(self, "innodb_adaptive_hash_index")

    @_builtins.property
    @pulumi.getter(name="innodbAutoincLockMode")
    def innodb_autoinc_lock_mode(self) -> _builtins.int:
        """
        The lock mode to use for generating auto-increment values. Permissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.
        """
        return pulumi.get(self, "innodb_autoinc_lock_mode")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolDumpPct")
    def innodb_buffer_pool_dump_pct(self) -> _builtins.int:
        """
        Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.
        """
        return pulumi.get(self, "innodb_buffer_pool_dump_pct")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolInstances")
    def innodb_buffer_pool_instances(self) -> _builtins.int:
        """
        ("innodb_buffer_pool_instances")
        """
        return pulumi.get(self, "innodb_buffer_pool_instances")

    @_builtins.property
    @pulumi.getter(name="innodbBufferPoolSize")
    def innodb_buffer_pool_size(self) -> _builtins.str:
        """
        The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.
        """
        return pulumi.get(self, "innodb_buffer_pool_size")

    @_builtins.property
    @pulumi.getter(name="innodbChangeBuffering")
    def innodb_change_buffering(self) -> _builtins.str:
        """
        Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially. Permitted values are described in the following table. Values may also be specified numerically.
        """
        return pulumi.get(self, "innodb_change_buffering")

    @_builtins.property
    @pulumi.getter(name="innodbDdlBufferSize")
    def innodb_ddl_buffer_size(self) -> _builtins.str:
        """
        innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)
        """
        return pulumi.get(self, "innodb_ddl_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbDdlThreads")
    def innodb_ddl_threads(self) -> _builtins.int:
        """
        innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)
        """
        return pulumi.get(self, "innodb_ddl_threads")

    @_builtins.property
    @pulumi.getter(name="innodbFtEnableStopword")
    def innodb_ft_enable_stopword(self) -> _builtins.bool:
        """
        ("innodb_ft_enable_stopword")
        """
        return pulumi.get(self, "innodb_ft_enable_stopword")

    @_builtins.property
    @pulumi.getter(name="innodbFtMaxTokenSize")
    def innodb_ft_max_token_size(self) -> _builtins.int:
        """
        ("innodb_ft_max_token_size")
        """
        return pulumi.get(self, "innodb_ft_max_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> _builtins.int:
        """
        ("innodb_ft_min_token_size")
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtNumWordOptimize")
    def innodb_ft_num_word_optimize(self) -> _builtins.int:
        """
        ("innodb_ft_num_word_optimize")
        """
        return pulumi.get(self, "innodb_ft_num_word_optimize")

    @_builtins.property
    @pulumi.getter(name="innodbFtResultCacheLimit")
    def innodb_ft_result_cache_limit(self) -> _builtins.str:
        """
        ("innodb_ft_result_cache_limit")
        """
        return pulumi.get(self, "innodb_ft_result_cache_limit")

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> _builtins.str:
        """
        ("innodb_ft_server_stopword_table")
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> _builtins.int:
        """
        ("innodb_lock_wait_timeout")
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbLogWriterThreads")
    def innodb_log_writer_threads(self) -> _builtins.bool:
        """
        Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.
        """
        return pulumi.get(self, "innodb_log_writer_threads")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLag")
    def innodb_max_purge_lag(self) -> _builtins.str:
        """
        The desired maximum purge lag in terms of transactions.
        """
        return pulumi.get(self, "innodb_max_purge_lag")

    @_builtins.property
    @pulumi.getter(name="innodbMaxPurgeLagDelay")
    def innodb_max_purge_lag_delay(self) -> _builtins.int:
        """
        The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.
        """
        return pulumi.get(self, "innodb_max_purge_lag_delay")

    @_builtins.property
    @pulumi.getter(name="innodbNumaInterleave")
    def innodb_numa_interleave(self) -> _builtins.bool:
        """
        Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool. When innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process. After the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT. For the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.
        """
        return pulumi.get(self, "innodb_numa_interleave")

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> _builtins.str:
        """
        Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables. There is one such log file for each index being created or table being altered. This log file stores data inserted, updated, or deleted in the table during the DDL operation.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbRedoLogCapacity")
    def innodb_redo_log_capacity(self) -> _builtins.str:
        """
        Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables, which are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined, then the default innodb_redo_log_capacity value is used.
        """
        return pulumi.get(self, "innodb_redo_log_capacity")

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> _builtins.bool:
        """
        InnoDB rolls back only the last statement on a transaction timeout by default. If --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbSortBufferSize")
    def innodb_sort_buffer_size(self) -> _builtins.int:
        """
        This variable defines:
        * The sort buffer size for online DDL operations that create or rebuild secondary indexes. However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.
        * The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation, and the size of the temporary log file read buffer and write buffer.
        """
        return pulumi.get(self, "innodb_sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbStatsPersistentSamplePages")
    def innodb_stats_persistent_sample_pages(self) -> _builtins.str:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by ANALYZE TABLE.
        """
        return pulumi.get(self, "innodb_stats_persistent_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStatsTransientSamplePages")
    def innodb_stats_transient_sample_pages(self) -> _builtins.str:
        """
        The number of index pages to sample when estimating cardinality and other statistics for an indexed column, such as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).
        """
        return pulumi.get(self, "innodb_stats_transient_sample_pages")

    @_builtins.property
    @pulumi.getter(name="innodbStrictMode")
    def innodb_strict_mode(self) -> _builtins.bool:
        """
        When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.
        """
        return pulumi.get(self, "innodb_strict_mode")

    @_builtins.property
    @pulumi.getter(name="innodbUndoLogTruncate")
    def innodb_undo_log_truncate(self) -> _builtins.bool:
        """
        When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation. Only undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported. For truncation to occur, there must be at least two undo tablespaces.
        """
        return pulumi.get(self, "innodb_undo_log_truncate")

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="joinBufferSize")
    def join_buffer_size(self) -> _builtins.str:
        """
        The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans. In MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes. Increase the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables. For a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.
        """
        return pulumi.get(self, "join_buffer_size")

    @_builtins.property
    @pulumi.getter(name="localInfile")
    def local_infile(self) -> _builtins.bool:
        """
        This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side.
        """
        return pulumi.get(self, "local_infile")

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> _builtins.int:
        """
        If a query takes longer than this many seconds, the server increments the Slow_queries status variable. If the slow query log is enabled, the query is logged to the slow query log file. This value is measured in real time, not CPU time, so a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.
        """
        return pulumi.get(self, "long_query_time")

    @_builtins.property
    @pulumi.getter(name="mandatoryRoles")
    def mandatory_roles(self) -> _builtins.str:
        """
        ("mandatory_roles")
        """
        return pulumi.get(self, "mandatory_roles")

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> _builtins.int:
        """
        The maximum size of one packet or any generated/intermediate string.
        """
        return pulumi.get(self, "max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="maxBinlogCacheSize")
    def max_binlog_cache_size(self) -> _builtins.str:
        """
        Sets the size of the transaction cache.
        """
        return pulumi.get(self, "max_binlog_cache_size")

    @_builtins.property
    @pulumi.getter(name="maxConnectErrors")
    def max_connect_errors(self) -> _builtins.str:
        """
        ("max_connect_errors")
        """
        return pulumi.get(self, "max_connect_errors")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        ("max_connections")
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxExecutionTime")
    def max_execution_time(self) -> _builtins.str:
        """
        ("max_execution_time")
        """
        return pulumi.get(self, "max_execution_time")

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> _builtins.str:
        """
        This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.
        """
        return pulumi.get(self, "max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="maxPreparedStmtCount")
    def max_prepared_stmt_count(self) -> _builtins.int:
        """
        ("max_prepared_stmt_count")
        """
        return pulumi.get(self, "max_prepared_stmt_count")

    @_builtins.property
    @pulumi.getter(name="maxSeeksForKey")
    def max_seeks_for_key(self) -> _builtins.str:
        """
        Limit the assumed maximum number of seeks when looking up rows based on a key. The MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index, regardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”). By setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.
        """
        return pulumi.get(self, "max_seeks_for_key")

    @_builtins.property
    @pulumi.getter(name="maxUserConnections")
    def max_user_connections(self) -> _builtins.str:
        """
        The maximum number of simultaneous connections permitted to any given MySQL user account. A value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime. It also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.
        """
        return pulumi.get(self, "max_user_connections")

    @_builtins.property
    @pulumi.getter(name="mysqlFirewallMode")
    def mysql_firewall_mode(self) -> _builtins.bool:
        """
        ("mysql_firewall_mode")
        """
        return pulumi.get(self, "mysql_firewall_mode")

    @_builtins.property
    @pulumi.getter(name="mysqlZstdDefaultCompressionLevel")
    @_utilities.deprecated("""The 'mysql_zstd_default_compression_level' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysql_zstd_default_compression_level(self) -> _builtins.int:
        """
        DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.
        """
        return pulumi.get(self, "mysql_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxConnectTimeout")
    def mysqlx_connect_timeout(self) -> _builtins.int:
        """
        The number of seconds X Plugin waits for the first packet to be received from newly connected clients.
        """
        return pulumi.get(self, "mysqlx_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateDefaultCompressionLevel")
    def mysqlx_deflate_default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDeflateMaxClientCompressionLevel")
    def mysqlx_deflate_max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_deflate_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxDocumentIdUniquePrefix")
    @_utilities.deprecated("""The 'mysqlx_document_id_unique_prefix' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_document_id_unique_prefix(self) -> _builtins.int:
        """
        ("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_document_id_unique_prefix")

    @_builtins.property
    @pulumi.getter(name="mysqlxEnableHelloNotice")
    def mysqlx_enable_hello_notice(self) -> _builtins.bool:
        """
        ("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_enable_hello_notice")

    @_builtins.property
    @pulumi.getter(name="mysqlxIdleWorkerThreadTimeout")
    @_utilities.deprecated("""The 'mysqlx_idle_worker_thread_timeout' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_idle_worker_thread_timeout(self) -> _builtins.int:
        """
        ("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_idle_worker_thread_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxInteractiveTimeout")
    def mysqlx_interactive_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for interactive clients to timeout.
        """
        return pulumi.get(self, "mysqlx_interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4defaultCompressionLevel")
    def mysqlx_lz4default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxLz4maxClientCompressionLevel")
    def mysqlx_lz4max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_lz4max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxMaxAllowedPacket")
    def mysqlx_max_allowed_packet(self) -> _builtins.int:
        """
        The maximum size of network packets that can be received by X Plugin.
        """
        return pulumi.get(self, "mysqlx_max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="mysqlxMinWorkerThreads")
    @_utilities.deprecated("""The 'mysqlx_min_worker_threads' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def mysqlx_min_worker_threads(self) -> _builtins.int:
        """
        ("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "mysqlx_min_worker_threads")

    @_builtins.property
    @pulumi.getter(name="mysqlxReadTimeout")
    def mysqlx_read_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for blocking read operations to complete. After this time, if the read operation is not successful, X Plugin closes the connection and returns a warning notice with the error code ER_IO_READ_ERROR to the client application.
        """
        return pulumi.get(self, "mysqlx_read_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWaitTimeout")
    def mysqlx_wait_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for activity on a connection.
        """
        return pulumi.get(self, "mysqlx_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxWriteTimeout")
    def mysqlx_write_timeout(self) -> _builtins.int:
        """
        The number of seconds that X Plugin waits for blocking write operations to complete. After this time, if the write operation is not successful, X Plugin closes the connection.
        """
        return pulumi.get(self, "mysqlx_write_timeout")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdDefaultCompressionLevel")
    def mysqlx_zstd_default_compression_level(self) -> _builtins.int:
        """
        Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_default_compression_level")

    @_builtins.property
    @pulumi.getter(name="mysqlxZstdMaxClientCompressionLevel")
    def mysqlx_zstd_max_client_compression_level(self) -> _builtins.int:
        """
        Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")
        """
        return pulumi.get(self, "mysqlx_zstd_max_client_compression_level")

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="optimizerSwitch")
    def optimizer_switch(self) -> _builtins.str:
        """
        The optimizer_switch system variable enables control over optimizer behavior. The value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled. This variable has global and session values and can be changed at runtime. The global default can be set at server startup.
        """
        return pulumi.get(self, "optimizer_switch")

    @_builtins.property
    @pulumi.getter(name="parserMaxMemSize")
    def parser_max_mem_size(self) -> _builtins.str:
        """
        ("parser_max_mem_size")
        """
        return pulumi.get(self, "parser_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="queryAllocBlockSize")
    @_utilities.deprecated("""The 'query_alloc_block_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def query_alloc_block_size(self) -> _builtins.str:
        """
        ("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_alloc_block_size")

    @_builtins.property
    @pulumi.getter(name="queryPreallocSize")
    def query_prealloc_size(self) -> _builtins.str:
        """
        ("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored
        """
        return pulumi.get(self, "query_prealloc_size")

    @_builtins.property
    @pulumi.getter(name="rangeOptimizerMaxMemSize")
    @_utilities.deprecated("""The 'query_prealloc_size' field has been deprecated and may be removed in a future version. Do not use this field.""")
    def range_optimizer_max_mem_size(self) -> _builtins.str:
        """
        The limit on memory consumption for the range optimizer. A value of 0 means “no limit.” If an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit, it abandons the plan and considers other plans.
        """
        return pulumi.get(self, "range_optimizer_max_mem_size")

    @_builtins.property
    @pulumi.getter(name="regexpTimeLimit")
    def regexp_time_limit(self) -> _builtins.int:
        """
        regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)
        """
        return pulumi.get(self, "regexp_time_limit")

    @_builtins.property
    @pulumi.getter(name="relayLogSpaceLimit")
    def relay_log_space_limit(self) -> _builtins.str:
        """
        The maximum amount of space to use for all relay logs.
        """
        return pulumi.get(self, "relay_log_space_limit")

    @_builtins.property
    @pulumi.getter(name="replicaNetTimeout")
    def replica_net_timeout(self) -> _builtins.int:
        """
        Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken, aborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.
        """
        return pulumi.get(self, "replica_net_timeout")

    @_builtins.property
    @pulumi.getter(name="replicaParallelWorkers")
    def replica_parallel_workers(self) -> _builtins.int:
        """
        Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead. (Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)
        """
        return pulumi.get(self, "replica_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="replicaTypeConversions")
    def replica_type_conversions(self) -> _builtins.str:
        """
        From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release. In releases before MySQL 8.0.26, use slave_type_conversions.
        """
        return pulumi.get(self, "replica_type_conversions")

    @_builtins.property
    @pulumi.getter(name="requireSecureTransport")
    def require_secure_transport(self) -> _builtins.bool:
        """
        Whether client connections to the server are required to use some form of secure transport. When this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory. The server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.
        """
        return pulumi.get(self, "require_secure_transport")

    @_builtins.property
    @pulumi.getter(name="skipNameResolve")
    def skip_name_resolve(self) -> _builtins.bool:
        """
        Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections. If it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses. See Section 7.1.12.3, “DNS Lookups and the Host Cache”.
        """
        return pulumi.get(self, "skip_name_resolve")

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> _builtins.str:
        """
        Each session that must perform a sort allocates a buffer of this size.
        """
        return pulumi.get(self, "sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="sqlGenerateInvisiblePrimaryKey")
    def sql_generate_invisible_primary_key(self) -> _builtins.bool:
        """
        Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.
        """
        return pulumi.get(self, "sql_generate_invisible_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> _builtins.str:
        """
        ("sql_mode")
        """
        return pulumi.get(self, "sql_mode")

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> _builtins.bool:
        """
        ("sql_require_primary_key")
        """
        return pulumi.get(self, "sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="sqlWarnings")
    def sql_warnings(self) -> _builtins.bool:
        """
        ("sql_warnings")
        """
        return pulumi.get(self, "sql_warnings")

    @_builtins.property
    @pulumi.getter(name="tableDefinitionCache")
    def table_definition_cache(self) -> _builtins.int:
        """
        The number of table definitions that can be stored in the table definition cache. If you use a large number of tables, you can create a large table definition cache to speed up opening of tables. The table definition cache takes less space and does not use file descriptors, unlike the normal table cache.
        """
        return pulumi.get(self, "table_definition_cache")

    @_builtins.property
    @pulumi.getter(name="tableOpenCache")
    def table_open_cache(self) -> _builtins.int:
        """
        The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.
        """
        return pulumi.get(self, "table_open_cache")

    @_builtins.property
    @pulumi.getter(name="temptableMaxRam")
    def temptable_max_ram(self) -> _builtins.str:
        """
        Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk. The default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.
        """
        return pulumi.get(self, "temptable_max_ram")

    @_builtins.property
    @pulumi.getter(name="threadPoolDedicatedListeners")
    def thread_pool_dedicated_listeners(self) -> _builtins.bool:
        """
        Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening for network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit. threadPoolDedicatedListeners corresponds to the MySQL Database Service-specific system variable thread_pool_dedicated_listeners.
        """
        return pulumi.get(self, "thread_pool_dedicated_listeners")

    @_builtins.property
    @pulumi.getter(name="threadPoolMaxTransactionsLimit")
    def thread_pool_max_transactions_limit(self) -> _builtins.int:
        """
        Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit. threadPoolMaxTransactionsLimit corresponds to the MySQL Database Service-specific system variable thread_pool_max_transactions_limit.
        """
        return pulumi.get(self, "thread_pool_max_transactions_limit")

    @_builtins.property
    @pulumi.getter(name="threadPoolQueryThreadsPerGroup")
    def thread_pool_query_threads_per_group(self) -> _builtins.int:
        """
        The maximum number of query threads permitted in a thread group. The maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value. The default value of 1 means there is one active query thread in each thread group, which works well for many loads. When you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1), consider increasing the value if you experience slower response times due to long-running transactions.
        """
        return pulumi.get(self, "thread_pool_query_threads_per_group")

    @_builtins.property
    @pulumi.getter(name="threadPoolSize")
    def thread_pool_size(self) -> _builtins.int:
        """
        The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance. It affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified, the thread pool plugin does not load and the server writes a message to the error log.
        """
        return pulumi.get(self, "thread_pool_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolTransactionDelay")
    def thread_pool_transaction_delay(self) -> _builtins.int:
        """
        The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes). A transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention. For example, if parallel transactions affect index creation or an online buffer pool resizing operation, you can configure a transaction delay to reduce resource contention while those operations are running.
        """
        return pulumi.get(self, "thread_pool_transaction_delay")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Initializes the time zone for each client that connects.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> _builtins.str:
        """
        The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.
        """
        return pulumi.get(self, "tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="transactionIsolation")
    def transaction_isolation(self) -> _builtins.str:
        """
        ("transaction_isolation")
        """
        return pulumi.get(self, "transaction_isolation")

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")


@pulumi.output_type
class GetMysqlConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMysqlDbSystemBackupPolicyResult(dict):
    def __init__(__self__, *,
                 copy_policies: Sequence['outputs.GetMysqlDbSystemBackupPolicyCopyPolicyResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 is_enabled: _builtins.bool,
                 pitr_policies: Sequence['outputs.GetMysqlDbSystemBackupPolicyPitrPolicyResult'],
                 retention_in_days: _builtins.int,
                 soft_delete: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param Sequence['GetMysqlDbSystemBackupPolicyCopyPolicyArgs'] copy_policies: List of policies of a DB system to schedule cross-region DB system backup copy.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param Sequence['GetMysqlDbSystemBackupPolicyPitrPolicyArgs'] pitr_policies: The PITR policy for the DB System.
        :param _builtins.int retention_in_days: The number of days automated backups are retained.
        :param _builtins.str soft_delete: Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "copy_policies", copy_policies)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "pitr_policies", pitr_policies)
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        pulumi.set(__self__, "soft_delete", soft_delete)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Sequence['outputs.GetMysqlDbSystemBackupPolicyCopyPolicyResult']:
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        return pulumi.get(self, "copy_policies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="pitrPolicies")
    def pitr_policies(self) -> Sequence['outputs.GetMysqlDbSystemBackupPolicyPitrPolicyResult']:
        """
        The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policies")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        The number of days automated backups are retained.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> _builtins.str:
        """
        Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlDbSystemBackupPolicyCopyPolicyResult(dict):
    def __init__(__self__, *,
                 backup_copy_retention_in_days: _builtins.int,
                 copy_to_region: _builtins.str):
        """
        :param _builtins.int backup_copy_retention_in_days: Number of days to retain the copied DB system backup.
        :param _builtins.str copy_to_region: The destination region name to which the DB system backup will be copied.
        """
        pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)
        pulumi.set(__self__, "copy_to_region", copy_to_region)

    @_builtins.property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> _builtins.str:
        """
        The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")


@pulumi.output_type
class GetMysqlDbSystemBackupPolicyPitrPolicyResult(dict):
    def __init__(__self__, *,
                 is_enabled: _builtins.bool):
        """
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetMysqlDbSystemChannelResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 sources: Sequence['outputs.GetMysqlDbSystemChannelSourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 targets: Sequence['outputs.GetMysqlDbSystemChannelTargetResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment the DB System belongs in.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: The user-friendly name for the DB System. It does not have to be unique.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the DB System.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str lifecycle_details: Additional information about the current lifecycleState.
        :param Sequence['GetMysqlDbSystemChannelSourceArgs'] sources: Parameters detailing how to provision the initial data of the DB System.
        :param _builtins.str state: The current state of the DB System.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetMysqlDbSystemChannelTargetArgs'] targets: Details about the Channel target.
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMysqlDbSystemChannelSourceResult']:
        """
        Parameters detailing how to provision the initial data of the DB System.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the DB System.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetMysqlDbSystemChannelTargetResult']:
        """
        Details about the Channel target.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlDbSystemChannelSourceResult(dict):
    def __init__(__self__, *,
                 anonymous_transactions_handlings: Sequence['outputs.GetMysqlDbSystemChannelSourceAnonymousTransactionsHandlingResult'],
                 hostname: _builtins.str,
                 port: _builtins.int,
                 source_type: _builtins.str,
                 ssl_ca_certificates: Sequence['outputs.GetMysqlDbSystemChannelSourceSslCaCertificateResult'],
                 ssl_mode: _builtins.str,
                 username: _builtins.str):
        """
        :param Sequence['GetMysqlDbSystemChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.str source_type: The specific source identifier.
        :param Sequence['GetMysqlDbSystemChannelSourceSslCaCertificateArgs'] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param _builtins.str ssl_mode: The SSL mode of the Channel.
        :param _builtins.str username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Sequence['outputs.GetMysqlDbSystemChannelSourceAnonymousTransactionsHandlingResult']:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Sequence['outputs.GetMysqlDbSystemChannelSourceSslCaCertificateResult']:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMysqlDbSystemChannelSourceAnonymousTransactionsHandlingResult(dict):
    def __init__(__self__, *,
                 last_configured_log_filename: _builtins.str,
                 last_configured_log_offset: _builtins.str,
                 policy: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str policy: Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> _builtins.str:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> _builtins.str:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetMysqlDbSystemChannelSourceSslCaCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_type: _builtins.str,
                 contents: _builtins.str):
        """
        :param _builtins.str certificate_type: The type of CA certificate.
        :param _builtins.str contents: The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> _builtins.str:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class GetMysqlDbSystemChannelTargetResult(dict):
    def __init__(__self__, *,
                 applier_username: _builtins.str,
                 channel_name: _builtins.str,
                 db_system_id: _builtins.str,
                 delay_in_seconds: _builtins.int,
                 filters: Sequence['outputs.GetMysqlDbSystemChannelTargetFilterResult'],
                 tables_without_primary_key_handling: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str applier_username: The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.int delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['GetMysqlDbSystemChannelTargetFilterArgs'] filters: Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param _builtins.str target_type: The specific target identifier.
        """
        pulumi.set(__self__, "applier_username", applier_username)
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> _builtins.str:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> _builtins.str:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> _builtins.int:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetMysqlDbSystemChannelTargetFilterResult']:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> _builtins.str:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetMysqlDbSystemChannelTargetFilterResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the filter rule.
        :param _builtins.str value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMysqlDbSystemCurrentPlacementResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 fault_domain: _builtins.str):
        """
        :param _builtins.str availability_domain: The availability domain in which the DB System is placed.
        :param _builtins.str fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domain", fault_domain)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        return pulumi.get(self, "fault_domain")


@pulumi.output_type
class GetMysqlDbSystemCustomerContactResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        """
        :param _builtins.str email: The email address used by Oracle to send notifications regarding the DB System.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email address used by Oracle to send notifications regarding the DB System.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetMysqlDbSystemDataStorageResult(dict):
    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: _builtins.int,
                 data_storage_size_in_gb: _builtins.int,
                 data_storage_size_limit_in_gbs: _builtins.int,
                 is_auto_expand_storage_enabled: _builtins.bool,
                 max_storage_size_in_gbs: _builtins.int):
        """
        :param _builtins.int allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param _builtins.int data_storage_size_in_gb: Initial size of the data volume in GiBs that will be created and attached.
        :param _builtins.int data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param _builtins.bool is_auto_expand_storage_enabled: Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param _builtins.int max_storage_size_in_gbs: Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> _builtins.int:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        Initial size of the data volume in GiBs that will be created and attached.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> _builtins.int:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> _builtins.bool:
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> _builtins.int:
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")


@pulumi.output_type
class GetMysqlDbSystemDeletionPolicyResult(dict):
    def __init__(__self__, *,
                 automatic_backup_retention: _builtins.str,
                 final_backup: _builtins.str,
                 is_delete_protected: _builtins.bool):
        """
        :param _builtins.str automatic_backup_retention: Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param _builtins.str final_backup: Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param _builtins.bool is_delete_protected: Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        pulumi.set(__self__, "final_backup", final_backup)
        pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @_builtins.property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> _builtins.str:
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @_builtins.property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> _builtins.str:
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> _builtins.bool:
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")


@pulumi.output_type
class GetMysqlDbSystemEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetMysqlDbSystemEndpointResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 ip_address: _builtins.str,
                 modes: Sequence[_builtins.str],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 status_details: _builtins.str):
        """
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param Sequence[_builtins.str] modes: The access modes from the client that this endpoint supports.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param _builtins.str resource_id: The OCID of the resource that this endpoint is attached to.
        :param _builtins.str resource_type: The type of endpoint that clients and connectors can connect to.
        :param _builtins.str status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param _builtins.str status_details: Additional information about the current endpoint status.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Sequence[_builtins.str]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> _builtins.str:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")


@pulumi.output_type
class GetMysqlDbSystemHeatWaveClusterResult(dict):
    def __init__(__self__, *,
                 cluster_size: _builtins.int,
                 is_lakehouse_enabled: _builtins.bool,
                 shape_name: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.int cluster_size: The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        :param _builtins.bool is_lakehouse_enabled: Lakehouse enabled status for the HeatWave cluster.
        :param _builtins.str shape_name: The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        :param _builtins.str state: The current state of the DB System.
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> _builtins.int:
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> _builtins.bool:
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the DB System.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlDbSystemMaintenanceResult(dict):
    def __init__(__self__, *,
                 maintenance_schedule_type: _builtins.str,
                 target_version: _builtins.str,
                 time_scheduled: _builtins.str,
                 version_preference: _builtins.str,
                 version_track_preference: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param _builtins.str maintenance_schedule_type: The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        :param _builtins.str target_version: The version that is expected to be targeted during the next scheduled maintenance run.
        :param _builtins.str time_scheduled: The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str version_preference: The preferred version to target when performing an automatic MySQL upgrade.
        :param _builtins.str version_track_preference: The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "maintenance_schedule_type", maintenance_schedule_type)
        pulumi.set(__self__, "target_version", target_version)
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        pulumi.set(__self__, "version_preference", version_preference)
        pulumi.set(__self__, "version_track_preference", version_track_preference)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="maintenanceScheduleType")
    def maintenance_schedule_type(self) -> _builtins.str:
        """
        The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        """
        return pulumi.get(self, "maintenance_schedule_type")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> _builtins.str:
        """
        The version that is expected to be targeted during the next scheduled maintenance run.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> _builtins.str:
        """
        The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> _builtins.str:
        """
        The preferred version to target when performing an automatic MySQL upgrade.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="versionTrackPreference")
    def version_track_preference(self) -> _builtins.str:
        """
        The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        return pulumi.get(self, "version_track_preference")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlDbSystemPointInTimeRecoveryDetailResult(dict):
    def __init__(__self__, *,
                 time_earliest_recovery_point: _builtins.str,
                 time_latest_recovery_point: _builtins.str):
        """
        :param _builtins.str time_earliest_recovery_point: Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_latest_recovery_point: Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        pulumi.set(__self__, "time_earliest_recovery_point", time_earliest_recovery_point)
        pulumi.set(__self__, "time_latest_recovery_point", time_latest_recovery_point)

    @_builtins.property
    @pulumi.getter(name="timeEarliestRecoveryPoint")
    def time_earliest_recovery_point(self) -> _builtins.str:
        """
        Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_earliest_recovery_point")

    @_builtins.property
    @pulumi.getter(name="timeLatestRecoveryPoint")
    def time_latest_recovery_point(self) -> _builtins.str:
        """
        Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_latest_recovery_point")


@pulumi.output_type
class GetMysqlDbSystemReadEndpointResult(dict):
    def __init__(__self__, *,
                 exclude_ips: Sequence[_builtins.str],
                 is_enabled: _builtins.bool,
                 read_endpoint_hostname_label: _builtins.str,
                 read_endpoint_ip_address: _builtins.str):
        """
        :param Sequence[_builtins.str] exclude_ips: A list of IP addresses of read replicas that are excluded from serving read requests.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str read_endpoint_hostname_label: The hostname for the read endpoint of the DB System. Used for DNS.
        :param _builtins.str read_endpoint_ip_address: The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        pulumi.set(__self__, "exclude_ips", exclude_ips)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @_builtins.property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Sequence[_builtins.str]:
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> _builtins.str:
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @_builtins.property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> _builtins.str:
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")


@pulumi.output_type
class GetMysqlDbSystemRestResult(dict):
    def __init__(__self__, *,
                 configuration: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str configuration: Select how REST is configured across the DB System instances.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> _builtins.str:
        """
        Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetMysqlDbSystemSecureConnectionResult(dict):
    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: _builtins.str):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetMysqlDbSystemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: _builtins.str,
                 db_system_id: _builtins.str,
                 recovery_point: _builtins.str,
                 source_type: _builtins.str,
                 source_url: _builtins.str):
        """
        :param _builtins.str backup_id: The OCID of the backup to be used as the source for the new DB System.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str recovery_point: The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        :param _builtins.str source_type: The specific source identifier.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "recovery_point", recovery_point)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "source_url", source_url)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        The OCID of the backup to be used as the source for the new DB System.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPoint")
    def recovery_point(self) -> _builtins.str:
        """
        The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        """
        return pulumi.get(self, "recovery_point")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        return pulumi.get(self, "source_url")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemResult(dict):
    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 admin_password: _builtins.str,
                 admin_username: _builtins.str,
                 availability_domain: _builtins.str,
                 backup_policies: Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyResult'],
                 channels: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelResult'],
                 compartment_id: _builtins.str,
                 configuration_id: _builtins.str,
                 crash_recovery: _builtins.str,
                 current_placements: Sequence['outputs.GetMysqlDbSystemsDbSystemCurrentPlacementResult'],
                 customer_contacts: Sequence['outputs.GetMysqlDbSystemsDbSystemCustomerContactResult'],
                 data_storage_size_in_gb: _builtins.int,
                 data_storages: Sequence['outputs.GetMysqlDbSystemsDbSystemDataStorageResult'],
                 database_management: _builtins.str,
                 database_mode: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 deletion_policies: Sequence['outputs.GetMysqlDbSystemsDbSystemDeletionPolicyResult'],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 encrypt_datas: Sequence['outputs.GetMysqlDbSystemsDbSystemEncryptDataResult'],
                 endpoints: Sequence['outputs.GetMysqlDbSystemsDbSystemEndpointResult'],
                 fault_domain: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 heat_wave_clusters: Sequence['outputs.GetMysqlDbSystemsDbSystemHeatWaveClusterResult'],
                 hostname_label: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 is_heat_wave_cluster_attached: _builtins.bool,
                 is_highly_available: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 maintenances: Sequence['outputs.GetMysqlDbSystemsDbSystemMaintenanceResult'],
                 mysql_version: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 point_in_time_recovery_details: Sequence['outputs.GetMysqlDbSystemsDbSystemPointInTimeRecoveryDetailResult'],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 read_endpoints: Sequence['outputs.GetMysqlDbSystemsDbSystemReadEndpointResult'],
                 rests: Sequence['outputs.GetMysqlDbSystemsDbSystemRestResult'],
                 secure_connections: Sequence['outputs.GetMysqlDbSystemsDbSystemSecureConnectionResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 shape_name: _builtins.str,
                 shutdown_type: _builtins.str,
                 sources: Sequence['outputs.GetMysqlDbSystemsDbSystemSourceResult'],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str access_mode: The access mode indicating if the database access is unrestricted (to all MySQL user accounts),  or restricted (to only certain users with specific privileges):
               * UNRESTRICTED: the access to the database is not restricted;
               * RESTRICTED: the access is allowed only to users with specific privileges;  RESTRICTED will correspond to setting the MySQL system variable  [offline_mode](https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode) to ON.
        :param _builtins.str availability_domain: The availability domain in which the DB System is placed.
        :param Sequence['GetMysqlDbSystemsDbSystemBackupPolicyArgs'] backup_policies: The Backup policy for the DB System.
        :param Sequence['GetMysqlDbSystemsDbSystemChannelArgs'] channels: A list with a summary of all the Channels attached to the DB System.
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str configuration_id: The requested Configuration instance.
        :param _builtins.str crash_recovery: Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param Sequence['GetMysqlDbSystemsDbSystemCurrentPlacementArgs'] current_placements: The availability domain and fault domain a DB System is placed in.
        :param Sequence['GetMysqlDbSystemsDbSystemCustomerContactArgs'] customer_contacts: The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure DB System resource.  Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.  Up to 10 email addresses can be added to the customer contacts for a DB System.
        :param _builtins.int data_storage_size_in_gb: Initial size of the data volume in GiBs that will be created and attached.
        :param Sequence['GetMysqlDbSystemsDbSystemDataStorageArgs'] data_storages: Data Storage information.
        :param _builtins.str database_management: Filter DB Systems by their Database Management configuration.
        :param _builtins.str database_mode: The database mode indicating the types of statements that are allowed to run in the the DB system. This mode applies only to statements run by user connections. Replicated write statements continue  to be allowed regardless of the DatabaseMode.
               * READ_WRITE: allow running read and write statements on the DB system;
               * READ_ONLY: only allow running read statements on the DB system.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetMysqlDbSystemsDbSystemDeletionPolicyArgs'] deletion_policies: The Deletion policy for the DB System.
        :param _builtins.str description: User-provided data about the DB System.
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Sequence['GetMysqlDbSystemsDbSystemEncryptDataArgs'] encrypt_datas: Encrypt data details.
        :param Sequence['GetMysqlDbSystemsDbSystemEndpointArgs'] endpoints: The network endpoints available for this DB System.
        :param _builtins.str fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['GetMysqlDbSystemsDbSystemHeatWaveClusterArgs'] heat_wave_clusters: A summary of a HeatWave cluster.
        :param _builtins.str hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param _builtins.str id: The OCID of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param _builtins.bool is_heat_wave_cluster_attached: If true, return only DB Systems with a HeatWave cluster attached, if false return only DB Systems with no HeatWave cluster attached. If not present, return all DB Systems.
        :param _builtins.bool is_highly_available: Specifies if the DB System is highly available.
        :param _builtins.str lifecycle_details: Additional information about the current lifecycleState.
        :param Sequence['GetMysqlDbSystemsDbSystemMaintenanceArgs'] maintenances: The Maintenance Policy for the DB System or Read Replica that this model is included in.
        :param _builtins.str mysql_version: Name of the MySQL Version in use for the DB System.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param Sequence['GetMysqlDbSystemsDbSystemPointInTimeRecoveryDetailArgs'] point_in_time_recovery_details: Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param Sequence['GetMysqlDbSystemsDbSystemReadEndpointArgs'] read_endpoints: The read endpoint of a DB System.
        :param Sequence['GetMysqlDbSystemsDbSystemRestArgs'] rests: REST configuration details.
        :param Sequence['GetMysqlDbSystemsDbSystemSecureConnectionArgs'] secure_connections: Secure connection configuration details.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        :param Sequence['GetMysqlDbSystemsDbSystemSourceArgs'] sources: Parameters detailing how to provision the initial data of the DB System.
        :param _builtins.str state: DbSystem Lifecycle State
        :param _builtins.str subnet_id: The OCID of the subnet the DB System is associated with.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "backup_policies", backup_policies)
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "crash_recovery", crash_recovery)
        pulumi.set(__self__, "current_placements", current_placements)
        pulumi.set(__self__, "customer_contacts", customer_contacts)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "data_storages", data_storages)
        pulumi.set(__self__, "database_management", database_management)
        pulumi.set(__self__, "database_mode", database_mode)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "deletion_policies", deletion_policies)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "heat_wave_clusters", heat_wave_clusters)
        pulumi.set(__self__, "hostname_label", hostname_label)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_heat_wave_cluster_attached", is_heat_wave_cluster_attached)
        pulumi.set(__self__, "is_highly_available", is_highly_available)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "maintenances", maintenances)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "point_in_time_recovery_details", point_in_time_recovery_details)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "read_endpoints", read_endpoints)
        pulumi.set(__self__, "rests", rests)
        pulumi.set(__self__, "secure_connections", secure_connections)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "shutdown_type", shutdown_type)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        The access mode indicating if the database access is unrestricted (to all MySQL user accounts),  or restricted (to only certain users with specific privileges):
        * UNRESTRICTED: the access to the database is not restricted;
        * RESTRICTED: the access is allowed only to users with specific privileges;  RESTRICTED will correspond to setting the MySQL system variable  [offline_mode](https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode) to ON.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> _builtins.str:
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyResult']:
        """
        The Backup policy for the DB System.
        """
        return pulumi.get(self, "backup_policies")

    @_builtins.property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelResult']:
        """
        A list with a summary of all the Channels attached to the DB System.
        """
        return pulumi.get(self, "channels")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> _builtins.str:
        """
        The requested Configuration instance.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> _builtins.str:
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @_builtins.property
    @pulumi.getter(name="currentPlacements")
    def current_placements(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemCurrentPlacementResult']:
        """
        The availability domain and fault domain a DB System is placed in.
        """
        return pulumi.get(self, "current_placements")

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemCustomerContactResult']:
        """
        The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure DB System resource.  Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.  Up to 10 email addresses can be added to the customer contacts for a DB System.
        """
        return pulumi.get(self, "customer_contacts")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        Initial size of the data volume in GiBs that will be created and attached.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorages")
    def data_storages(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemDataStorageResult']:
        """
        Data Storage information.
        """
        return pulumi.get(self, "data_storages")

    @_builtins.property
    @pulumi.getter(name="databaseManagement")
    def database_management(self) -> _builtins.str:
        """
        Filter DB Systems by their Database Management configuration.
        """
        return pulumi.get(self, "database_management")

    @_builtins.property
    @pulumi.getter(name="databaseMode")
    def database_mode(self) -> _builtins.str:
        """
        The database mode indicating the types of statements that are allowed to run in the the DB system. This mode applies only to statements run by user connections. Replicated write statements continue  to be allowed regardless of the DatabaseMode.
        * READ_WRITE: allow running read and write statements on the DB system;
        * READ_ONLY: only allow running read statements on the DB system.
        """
        return pulumi.get(self, "database_mode")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemDeletionPolicyResult']:
        """
        The Deletion policy for the DB System.
        """
        return pulumi.get(self, "deletion_policies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        User-provided data about the DB System.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemEncryptDataResult']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemEndpointResult']:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="heatWaveClusters")
    def heat_wave_clusters(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemHeatWaveClusterResult']:
        """
        A summary of a HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_clusters")

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> _builtins.str:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isHeatWaveClusterAttached")
    def is_heat_wave_cluster_attached(self) -> _builtins.bool:
        """
        If true, return only DB Systems with a HeatWave cluster attached, if false return only DB Systems with no HeatWave cluster attached. If not present, return all DB Systems.
        """
        return pulumi.get(self, "is_heat_wave_cluster_attached")

    @_builtins.property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> _builtins.bool:
        """
        Specifies if the DB System is highly available.
        """
        return pulumi.get(self, "is_highly_available")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def maintenances(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemMaintenanceResult']:
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        return pulumi.get(self, "maintenances")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        Name of the MySQL Version in use for the DB System.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecoveryDetails")
    def point_in_time_recovery_details(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemPointInTimeRecoveryDetailResult']:
        """
        Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        """
        return pulumi.get(self, "point_in_time_recovery_details")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemReadEndpointResult']:
        """
        The read endpoint of a DB System.
        """
        return pulumi.get(self, "read_endpoints")

    @_builtins.property
    @pulumi.getter
    def rests(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemRestResult']:
        """
        REST configuration details.
        """
        return pulumi.get(self, "rests")

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemSecureConnectionResult']:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter(name="shutdownType")
    def shutdown_type(self) -> _builtins.str:
        return pulumi.get(self, "shutdown_type")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemSourceResult']:
        """
        Parameters detailing how to provision the initial data of the DB System.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        DbSystem Lifecycle State
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemBackupPolicyResult(dict):
    def __init__(__self__, *,
                 copy_policies: Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyCopyPolicyResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 is_enabled: _builtins.bool,
                 pitr_policies: Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyPitrPolicyResult'],
                 retention_in_days: _builtins.int,
                 soft_delete: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param Sequence['GetMysqlDbSystemsDbSystemBackupPolicyCopyPolicyArgs'] copy_policies: List of policies of a DB system to schedule cross-region DB system backup copy.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param Sequence['GetMysqlDbSystemsDbSystemBackupPolicyPitrPolicyArgs'] pitr_policies: The PITR policy for the DB System.
        :param _builtins.int retention_in_days: The number of days automated backups are retained.
        :param _builtins.str soft_delete: Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "copy_policies", copy_policies)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "pitr_policies", pitr_policies)
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        pulumi.set(__self__, "soft_delete", soft_delete)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="copyPolicies")
    def copy_policies(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyCopyPolicyResult']:
        """
        List of policies of a DB system to schedule cross-region DB system backup copy.
        """
        return pulumi.get(self, "copy_policies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="pitrPolicies")
    def pitr_policies(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemBackupPolicyPitrPolicyResult']:
        """
        The PITR policy for the DB System.
        """
        return pulumi.get(self, "pitr_policies")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        The number of days automated backups are retained.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> _builtins.str:
        """
        Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemBackupPolicyCopyPolicyResult(dict):
    def __init__(__self__, *,
                 backup_copy_retention_in_days: _builtins.int,
                 copy_to_region: _builtins.str):
        """
        :param _builtins.int backup_copy_retention_in_days: Number of days to retain the copied DB system backup.
        :param _builtins.str copy_to_region: The destination region name to which the DB system backup will be copied.
        """
        pulumi.set(__self__, "backup_copy_retention_in_days", backup_copy_retention_in_days)
        pulumi.set(__self__, "copy_to_region", copy_to_region)

    @_builtins.property
    @pulumi.getter(name="backupCopyRetentionInDays")
    def backup_copy_retention_in_days(self) -> _builtins.int:
        """
        Number of days to retain the copied DB system backup.
        """
        return pulumi.get(self, "backup_copy_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="copyToRegion")
    def copy_to_region(self) -> _builtins.str:
        """
        The destination region name to which the DB system backup will be copied.
        """
        return pulumi.get(self, "copy_to_region")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemBackupPolicyPitrPolicyResult(dict):
    def __init__(__self__, *,
                 is_enabled: _builtins.bool):
        """
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 sources: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 targets: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelTargetResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the DB System.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str lifecycle_details: Additional information about the current lifecycleState.
        :param Sequence['GetMysqlDbSystemsDbSystemChannelSourceArgs'] sources: Parameters detailing how to provision the initial data of the DB System.
        :param _builtins.str state: DbSystem Lifecycle State
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetMysqlDbSystemsDbSystemChannelTargetArgs'] targets: Details about the Channel target.
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceResult']:
        """
        Parameters detailing how to provision the initial data of the DB System.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        DbSystem Lifecycle State
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelTargetResult']:
        """
        Details about the Channel target.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelSourceResult(dict):
    def __init__(__self__, *,
                 anonymous_transactions_handlings: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceAnonymousTransactionsHandlingResult'],
                 hostname: _builtins.str,
                 port: _builtins.int,
                 source_type: _builtins.str,
                 ssl_ca_certificates: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceSslCaCertificateResult'],
                 ssl_mode: _builtins.str,
                 username: _builtins.str):
        """
        :param Sequence['GetMysqlDbSystemsDbSystemChannelSourceAnonymousTransactionsHandlingArgs'] anonymous_transactions_handlings: Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.str source_type: The specific source identifier.
        :param Sequence['GetMysqlDbSystemsDbSystemChannelSourceSslCaCertificateArgs'] ssl_ca_certificates: The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        :param _builtins.str ssl_mode: The SSL mode of the Channel.
        :param _builtins.str username: The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        pulumi.set(__self__, "anonymous_transactions_handlings", anonymous_transactions_handlings)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "ssl_ca_certificates", ssl_ca_certificates)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="anonymousTransactionsHandlings")
    def anonymous_transactions_handlings(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceAnonymousTransactionsHandlingResult']:
        """
        Specifies how the replication channel handles replicated transactions without an identifier, enabling replication from a source that does not use transaction-id-based replication to a replica that does.
        """
        return pulumi.get(self, "anonymous_transactions_handlings")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sslCaCertificates")
    def ssl_ca_certificates(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelSourceSslCaCertificateResult']:
        """
        The CA certificate of the server used for VERIFY_IDENTITY and VERIFY_CA ssl modes.
        """
        return pulumi.get(self, "ssl_ca_certificates")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        The SSL mode of the Channel.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the replication user on the source MySQL instance. The username has a maximum length of 96 characters. For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/change-master-to.html)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelSourceAnonymousTransactionsHandlingResult(dict):
    def __init__(__self__, *,
                 last_configured_log_filename: _builtins.str,
                 last_configured_log_offset: _builtins.str,
                 policy: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str last_configured_log_filename: Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str last_configured_log_offset: Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        :param _builtins.str policy: Specifies how the replication channel handles anonymous transactions.
        :param _builtins.str uuid: The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        pulumi.set(__self__, "last_configured_log_filename", last_configured_log_filename)
        pulumi.set(__self__, "last_configured_log_offset", last_configured_log_offset)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogFilename")
    def last_configured_log_filename(self) -> _builtins.str:
        """
        Specifies one of the coordinates (file) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_filename")

    @_builtins.property
    @pulumi.getter(name="lastConfiguredLogOffset")
    def last_configured_log_offset(self) -> _builtins.str:
        """
        Specifies one of the coordinates (offset) at which the replica should begin reading the source's log. As this value specifies the point where replication starts from, it is only used once, when it starts. It is never used again, unless a new UpdateChannel operation modifies it.
        """
        return pulumi.get(self, "last_configured_log_offset")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Specifies how the replication channel handles anonymous transactions.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID that is used as a prefix when generating transaction identifiers for anonymous transactions coming from the source. You can change the UUID later.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelSourceSslCaCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_type: _builtins.str,
                 contents: _builtins.str):
        """
        :param _builtins.str certificate_type: The type of CA certificate.
        :param _builtins.str contents: The string containing the CA certificate in PEM format.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "contents", contents)

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> _builtins.str:
        """
        The type of CA certificate.
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter
    def contents(self) -> _builtins.str:
        """
        The string containing the CA certificate in PEM format.
        """
        return pulumi.get(self, "contents")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelTargetResult(dict):
    def __init__(__self__, *,
                 applier_username: _builtins.str,
                 channel_name: _builtins.str,
                 db_system_id: _builtins.str,
                 delay_in_seconds: _builtins.int,
                 filters: Sequence['outputs.GetMysqlDbSystemsDbSystemChannelTargetFilterResult'],
                 tables_without_primary_key_handling: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str applier_username: The username for the replication applier of the target MySQL DB System.
        :param _builtins.str channel_name: The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.int delay_in_seconds: Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        :param Sequence['GetMysqlDbSystemsDbSystemChannelTargetFilterArgs'] filters: Replication filter rules to be applied at the DB System Channel target.
        :param _builtins.str tables_without_primary_key_handling: Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        :param _builtins.str target_type: The specific target identifier.
        """
        pulumi.set(__self__, "applier_username", applier_username)
        pulumi.set(__self__, "channel_name", channel_name)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "tables_without_primary_key_handling", tables_without_primary_key_handling)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="applierUsername")
    def applier_username(self) -> _builtins.str:
        """
        The username for the replication applier of the target MySQL DB System.
        """
        return pulumi.get(self, "applier_username")

    @_builtins.property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> _builtins.str:
        """
        The case-insensitive name that identifies the replication channel. Channel names must follow the rules defined for [MySQL identifiers](https://dev.mysql.com/doc/refman/8.0/en/identifiers.html). The names of non-Deleted Channels must be unique for each DB System.
        """
        return pulumi.get(self, "channel_name")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> _builtins.int:
        """
        Specifies the amount of time, in seconds, that the channel waits before  applying a transaction received from the source.
        """
        return pulumi.get(self, "delay_in_seconds")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetMysqlDbSystemsDbSystemChannelTargetFilterResult']:
        """
        Replication filter rules to be applied at the DB System Channel target.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="tablesWithoutPrimaryKeyHandling")
    def tables_without_primary_key_handling(self) -> _builtins.str:
        """
        Specifies how a replication channel handles the creation and alteration of tables  that do not have a primary key.
        """
        return pulumi.get(self, "tables_without_primary_key_handling")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The specific target identifier.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemChannelTargetFilterResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the filter rule.
        :param _builtins.str value: The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the filter rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The body of the filter rule. This can represent a database, a table, or a database pair (represented as "db1->db2"). For more information, see [Replication Filtering Rules](https://dev.mysql.com/doc/refman/8.0/en/replication-rules.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemCurrentPlacementResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 fault_domain: _builtins.str):
        """
        :param _builtins.str availability_domain: The availability domain in which the DB System is placed.
        :param _builtins.str fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domain", fault_domain)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        return pulumi.get(self, "fault_domain")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemCustomerContactResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        """
        :param _builtins.str email: The email address used by Oracle to send notifications regarding the DB System.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email address used by Oracle to send notifications regarding the DB System.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemDataStorageResult(dict):
    def __init__(__self__, *,
                 allocated_storage_size_in_gbs: _builtins.int,
                 data_storage_size_in_gb: _builtins.int,
                 data_storage_size_limit_in_gbs: _builtins.int,
                 is_auto_expand_storage_enabled: _builtins.bool,
                 max_storage_size_in_gbs: _builtins.int):
        """
        :param _builtins.int allocated_storage_size_in_gbs: The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        :param _builtins.int data_storage_size_in_gb: Initial size of the data volume in GiBs that will be created and attached.
        :param _builtins.int data_storage_size_limit_in_gbs: The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        :param _builtins.bool is_auto_expand_storage_enabled: Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        :param _builtins.int max_storage_size_in_gbs: Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        pulumi.set(__self__, "allocated_storage_size_in_gbs", allocated_storage_size_in_gbs)
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        pulumi.set(__self__, "data_storage_size_limit_in_gbs", data_storage_size_limit_in_gbs)
        pulumi.set(__self__, "is_auto_expand_storage_enabled", is_auto_expand_storage_enabled)
        pulumi.set(__self__, "max_storage_size_in_gbs", max_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="allocatedStorageSizeInGbs")
    def allocated_storage_size_in_gbs(self) -> _builtins.int:
        """
        The actual allocated storage size for the DB System. This may be higher than dataStorageSizeInGBs if an automatic storage expansion has occurred.
        """
        return pulumi.get(self, "allocated_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> _builtins.int:
        """
        Initial size of the data volume in GiBs that will be created and attached.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeLimitInGbs")
    def data_storage_size_limit_in_gbs(self) -> _builtins.int:
        """
        The absolute limit the DB System's storage size may ever expand to, either manually or automatically. This limit is based based on the initial dataStorageSizeInGBs when the DB System was first created. Both dataStorageSizeInGBs and maxDataStorageSizeInGBs can not exceed this value.
        """
        return pulumi.get(self, "data_storage_size_limit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isAutoExpandStorageEnabled")
    def is_auto_expand_storage_enabled(self) -> _builtins.bool:
        """
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically add storage incrementally up to the value specified in maxStorageSizeInGBs.
        """
        return pulumi.get(self, "is_auto_expand_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="maxStorageSizeInGbs")
    def max_storage_size_in_gbs(self) -> _builtins.int:
        """
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled is set to true, the DB System will add storage incrementally up to this value.
        """
        return pulumi.get(self, "max_storage_size_in_gbs")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemDeletionPolicyResult(dict):
    def __init__(__self__, *,
                 automatic_backup_retention: _builtins.str,
                 final_backup: _builtins.str,
                 is_delete_protected: _builtins.bool):
        """
        :param _builtins.str automatic_backup_retention: Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        :param _builtins.str final_backup: Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        :param _builtins.bool is_delete_protected: Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        pulumi.set(__self__, "automatic_backup_retention", automatic_backup_retention)
        pulumi.set(__self__, "final_backup", final_backup)
        pulumi.set(__self__, "is_delete_protected", is_delete_protected)

    @_builtins.property
    @pulumi.getter(name="automaticBackupRetention")
    def automatic_backup_retention(self) -> _builtins.str:
        """
        Specifies if any automatic backups created for a DB System should be retained or deleted when the DB System is deleted.
        """
        return pulumi.get(self, "automatic_backup_retention")

    @_builtins.property
    @pulumi.getter(name="finalBackup")
    def final_backup(self) -> _builtins.str:
        """
        Specifies whether or not a backup is taken when the DB System is deleted. REQUIRE_FINAL_BACKUP: a backup is taken if the DB System is deleted. SKIP_FINAL_BACKUP: a backup is not taken if the DB System is deleted.
        """
        return pulumi.get(self, "final_backup")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> _builtins.bool:
        """
        Specifies whether the DB System can be deleted. Set to true to prevent deletion, false (default) to allow.
        """
        return pulumi.get(self, "is_delete_protected")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemEndpointResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 ip_address: _builtins.str,
                 modes: Sequence[_builtins.str],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 status_details: _builtins.str):
        """
        :param _builtins.str hostname: The network address of the DB System.
        :param _builtins.str ip_address: The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        :param Sequence[_builtins.str] modes: The access modes from the client that this endpoint supports.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        :param _builtins.int port_x: The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        :param _builtins.str resource_id: The OCID of the resource that this endpoint is attached to.
        :param _builtins.str resource_type: The type of endpoint that clients and connectors can connect to.
        :param _builtins.str status: The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        :param _builtins.str status_details: Additional information about the current endpoint status.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The network address of the DB System.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def modes(self) -> Sequence[_builtins.str]:
        """
        The access modes from the client that this endpoint supports.
        """
        return pulumi.get(self, "modes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The OCID of the resource that this endpoint is attached to.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of endpoint that clients and connectors can connect to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the endpoints, as far as it can seen from the DB System. There may be some inconsistency with the actual state of the MySQL service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> _builtins.str:
        """
        Additional information about the current endpoint status.
        """
        return pulumi.get(self, "status_details")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemHeatWaveClusterResult(dict):
    def __init__(__self__, *,
                 cluster_size: _builtins.int,
                 is_lakehouse_enabled: _builtins.bool,
                 shape_name: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.int cluster_size: The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        :param _builtins.bool is_lakehouse_enabled: Lakehouse enabled status for the HeatWave cluster.
        :param _builtins.str shape_name: The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        :param _builtins.str state: DbSystem Lifecycle State
        :param _builtins.str time_created: The date and time the DB System was created.
        :param _builtins.str time_updated: The time the DB System was last updated.
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> _builtins.int:
        """
        The number of analytics-processing compute instances, of the specified shape, in the HeatWave cluster.
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> _builtins.bool:
        """
        Lakehouse enabled status for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        DbSystem Lifecycle State
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemMaintenanceResult(dict):
    def __init__(__self__, *,
                 maintenance_schedule_type: _builtins.str,
                 target_version: _builtins.str,
                 time_scheduled: _builtins.str,
                 version_preference: _builtins.str,
                 version_track_preference: _builtins.str,
                 window_start_time: _builtins.str):
        """
        :param _builtins.str maintenance_schedule_type: The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        :param _builtins.str target_version: The version that is expected to be targeted during the next scheduled maintenance run.
        :param _builtins.str time_scheduled: The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str version_preference: The preferred version to target when performing an automatic MySQL upgrade.
        :param _builtins.str version_track_preference: The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        :param _builtins.str window_start_time: The start time of the maintenance window.
        """
        pulumi.set(__self__, "maintenance_schedule_type", maintenance_schedule_type)
        pulumi.set(__self__, "target_version", target_version)
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        pulumi.set(__self__, "version_preference", version_preference)
        pulumi.set(__self__, "version_track_preference", version_track_preference)
        pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="maintenanceScheduleType")
    def maintenance_schedule_type(self) -> _builtins.str:
        """
        The maintenance schedule type of the DB system. EARLY:   Maintenance schedule follows a cycle where upgrades are performed when versions become deprecated. REGULAR: Maintenance schedule follows the normal cycle where upgrades are performed when versions become unavailable.
        """
        return pulumi.get(self, "maintenance_schedule_type")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> _builtins.str:
        """
        The version that is expected to be targeted during the next scheduled maintenance run.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> _builtins.str:
        """
        The time the scheduled maintenance is expected to start, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_scheduled")

    @_builtins.property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> _builtins.str:
        """
        The preferred version to target when performing an automatic MySQL upgrade.
        """
        return pulumi.get(self, "version_preference")

    @_builtins.property
    @pulumi.getter(name="versionTrackPreference")
    def version_track_preference(self) -> _builtins.str:
        """
        The preferred version track to target when performing an automatic MySQL upgrade. LONG_TERM_SUPPORT: No MySQL database behavior changes. INNOVATION:        Provides access to the latest features and all bug fixes. FOLLOW:            Follows the track of the current MySQL version.
        """
        return pulumi.get(self, "version_track_preference")

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window.
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemPointInTimeRecoveryDetailResult(dict):
    def __init__(__self__, *,
                 time_earliest_recovery_point: _builtins.str,
                 time_latest_recovery_point: _builtins.str):
        """
        :param _builtins.str time_earliest_recovery_point: Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_latest_recovery_point: Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        pulumi.set(__self__, "time_earliest_recovery_point", time_earliest_recovery_point)
        pulumi.set(__self__, "time_latest_recovery_point", time_latest_recovery_point)

    @_builtins.property
    @pulumi.getter(name="timeEarliestRecoveryPoint")
    def time_earliest_recovery_point(self) -> _builtins.str:
        """
        Earliest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_earliest_recovery_point")

    @_builtins.property
    @pulumi.getter(name="timeLatestRecoveryPoint")
    def time_latest_recovery_point(self) -> _builtins.str:
        """
        Latest recovery time point for the DB System, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_latest_recovery_point")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemReadEndpointResult(dict):
    def __init__(__self__, *,
                 exclude_ips: Sequence[_builtins.str],
                 is_enabled: _builtins.bool,
                 read_endpoint_hostname_label: _builtins.str,
                 read_endpoint_ip_address: _builtins.str):
        """
        :param Sequence[_builtins.str] exclude_ips: A list of IP addresses of read replicas that are excluded from serving read requests.
        :param _builtins.bool is_enabled: Specifies if the DB System read endpoint is enabled or not.
        :param _builtins.str read_endpoint_hostname_label: The hostname for the read endpoint of the DB System. Used for DNS.
        :param _builtins.str read_endpoint_ip_address: The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        pulumi.set(__self__, "exclude_ips", exclude_ips)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "read_endpoint_hostname_label", read_endpoint_hostname_label)
        pulumi.set(__self__, "read_endpoint_ip_address", read_endpoint_ip_address)

    @_builtins.property
    @pulumi.getter(name="excludeIps")
    def exclude_ips(self) -> Sequence[_builtins.str]:
        """
        A list of IP addresses of read replicas that are excluded from serving read requests.
        """
        return pulumi.get(self, "exclude_ips")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Specifies if the DB System read endpoint is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="readEndpointHostnameLabel")
    def read_endpoint_hostname_label(self) -> _builtins.str:
        """
        The hostname for the read endpoint of the DB System. Used for DNS.
        """
        return pulumi.get(self, "read_endpoint_hostname_label")

    @_builtins.property
    @pulumi.getter(name="readEndpointIpAddress")
    def read_endpoint_ip_address(self) -> _builtins.str:
        """
        The IP address the DB System read endpoint is configured to listen on. A private IP address of your choice to assign to the read endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "read_endpoint_ip_address")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemRestResult(dict):
    def __init__(__self__, *,
                 configuration: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str configuration: Select how REST is configured across the DB System instances.
        :param _builtins.int port: The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> _builtins.str:
        """
        Select how REST is configured across the DB System instances.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port for REST to listen on. Supported port numbers are 443 and from 1024 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemSecureConnectionResult(dict):
    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: _builtins.str):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetMysqlDbSystemsDbSystemSourceResult(dict):
    def __init__(__self__, *,
                 backup_id: _builtins.str,
                 db_system_id: _builtins.str,
                 recovery_point: _builtins.str,
                 source_type: _builtins.str,
                 source_url: _builtins.str):
        """
        :param _builtins.str backup_id: The OCID of the backup to be used as the source for the new DB System.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str recovery_point: The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        :param _builtins.str source_type: The specific source identifier.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "recovery_point", recovery_point)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "source_url", source_url)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        The OCID of the backup to be used as the source for the new DB System.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPoint")
    def recovery_point(self) -> _builtins.str:
        """
        The date and time, as per RFC 3339, of the change up to which the new DB System shall be restored to, using a backup and logs from the original DB System. In case no point in time is specified, then this new DB System shall be restored up to the latest change recorded for the original DB System.
        """
        return pulumi.get(self, "recovery_point")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The specific source identifier.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        return pulumi.get(self, "source_url")


@pulumi.output_type
class GetMysqlDbSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMysqlVersionFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMysqlVersionVersionResult(dict):
    def __init__(__self__, *,
                 version_family: _builtins.str,
                 versions: Sequence['outputs.GetMysqlVersionVersionVersionResult']):
        """
        :param _builtins.str version_family: A descriptive summary of a group of versions.
        :param Sequence['GetMysqlVersionVersionVersionArgs'] versions: The list of supported MySQL Versions.
        """
        pulumi.set(__self__, "version_family", version_family)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="versionFamily")
    def version_family(self) -> _builtins.str:
        """
        A descriptive summary of a group of versions.
        """
        return pulumi.get(self, "version_family")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetMysqlVersionVersionVersionResult']:
        """
        The list of supported MySQL Versions.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetMysqlVersionVersionVersionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str description: A link to a page describing the version.
        :param _builtins.str version: The specific version identifier
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A link to a page describing the version.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The specific version identifier
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetReplicaEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetReplicaReplicaOverrideResult(dict):
    def __init__(__self__, *,
                 configuration_id: _builtins.str,
                 mysql_version: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 security_attributes: Mapping[str, _builtins.str],
                 shape_name: _builtins.str):
        """
        :param _builtins.str configuration_id: The OCID of the Configuration to be used by the read replica.
        :param _builtins.str mysql_version: The MySQL version to be used by the read replica.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape_name", shape_name)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> _builtins.str:
        """
        The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")


@pulumi.output_type
class GetReplicaSecureConnectionResult(dict):
    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: _builtins.str):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetReplicasFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicasReplicaResult(dict):
    def __init__(__self__, *,
                 availability_domain: _builtins.str,
                 compartment_id: _builtins.str,
                 configuration_id: _builtins.str,
                 db_system_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 encrypt_datas: Sequence['outputs.GetReplicasReplicaEncryptDataResult'],
                 fault_domain: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 is_delete_protected: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 mysql_version: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 port: _builtins.int,
                 port_x: _builtins.int,
                 replica_overrides: Sequence['outputs.GetReplicasReplicaReplicaOverrideResult'],
                 secure_connections: Sequence['outputs.GetReplicasReplicaSecureConnectionResult'],
                 security_attributes: Mapping[str, _builtins.str],
                 shape_name: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str availability_domain: The name of the Availability Domain the read replica is located in.
        :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param _builtins.str configuration_id: The requested Configuration instance.
        :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: User provided description of the read replica.
        :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
        :param Sequence['GetReplicasReplicaEncryptDataArgs'] encrypt_datas: Encrypt data details.
        :param _builtins.str fault_domain: The name of the Fault Domain the read replica is located in.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The OCID of the read replica.
        :param _builtins.str ip_address: The IP address the read replica is configured to listen on.
        :param _builtins.bool is_delete_protected: Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        :param _builtins.str lifecycle_details: A message describing the state of the read replica.
        :param _builtins.str mysql_version: The MySQL version to be used by the read replica.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param _builtins.int port: The port the read replica is configured to listen on.
        :param _builtins.int port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param Sequence['GetReplicasReplicaReplicaOverrideArgs'] replica_overrides: By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        :param Sequence['GetReplicasReplicaSecureConnectionArgs'] secure_connections: Secure connection configuration details.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param _builtins.str state: The LifecycleState of the read replica.
        :param _builtins.str time_created: The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param _builtins.str time_updated: The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "encrypt_datas", encrypt_datas)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_delete_protected", is_delete_protected)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_x", port_x)
        pulumi.set(__self__, "replica_overrides", replica_overrides)
        pulumi.set(__self__, "secure_connections", secure_connections)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The name of the Availability Domain the read replica is located in.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> _builtins.str:
        """
        The requested Configuration instance.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        User provided description of the read replica.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only the resource matching the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="encryptDatas")
    def encrypt_datas(self) -> Sequence['outputs.GetReplicasReplicaEncryptDataResult']:
        """
        Encrypt data details.
        """
        return pulumi.get(self, "encrypt_datas")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The name of the Fault Domain the read replica is located in.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the read replica.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address the read replica is configured to listen on.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> _builtins.bool:
        """
        Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        """
        return pulumi.get(self, "is_delete_protected")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the state of the read replica.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port the read replica is configured to listen on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portX")
    def port_x(self) -> _builtins.int:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @_builtins.property
    @pulumi.getter(name="replicaOverrides")
    def replica_overrides(self) -> Sequence['outputs.GetReplicasReplicaReplicaOverrideResult']:
        """
        By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        return pulumi.get(self, "replica_overrides")

    @_builtins.property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Sequence['outputs.GetReplicasReplicaSecureConnectionResult']:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the read replica.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetReplicasReplicaEncryptDataResult(dict):
    def __init__(__self__, *,
                 key_generation_type: _builtins.str,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_generation_type: Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        :param _builtins.str key_id: The OCID of the key to use.
        """
        pulumi.set(__self__, "key_generation_type", key_generation_type)
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyGenerationType")
    def key_generation_type(self) -> _builtins.str:
        """
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).
        """
        return pulumi.get(self, "key_generation_type")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The OCID of the key to use.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetReplicasReplicaReplicaOverrideResult(dict):
    def __init__(__self__, *,
                 configuration_id: _builtins.str,
                 mysql_version: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 security_attributes: Mapping[str, _builtins.str],
                 shape_name: _builtins.str):
        """
        :param _builtins.str configuration_id: The requested Configuration instance.
        :param _builtins.str mysql_version: The MySQL version to be used by the read replica.
        :param Sequence[_builtins.str] nsg_ids: Network Security Group OCIDs used for the VNIC attachment.
        :param Mapping[str, _builtins.str] security_attributes: Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param _builtins.str shape_name: The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "mysql_version", mysql_version)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "security_attributes", security_attributes)
        pulumi.set(__self__, "shape_name", shape_name)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> _builtins.str:
        """
        The requested Configuration instance.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> _builtins.str:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs used for the VNIC attachment.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, _builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [ZPR Artifacts](https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")


@pulumi.output_type
class GetReplicasReplicaSecureConnectionResult(dict):
    def __init__(__self__, *,
                 certificate_generation_type: _builtins.str,
                 certificate_id: _builtins.str):
        """
        :param _builtins.str certificate_generation_type: Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        :param _builtins.str certificate_id: The OCID of the certificate to use.
        """
        pulumi.set(__self__, "certificate_generation_type", certificate_generation_type)
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateGenerationType")
    def certificate_generation_type(self) -> _builtins.str:
        """
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).
        """
        return pulumi.get(self, "certificate_generation_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate to use.
        """
        return pulumi.get(self, "certificate_id")


@pulumi.output_type
class GetShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShapesShapeResult(dict):
    def __init__(__self__, *,
                 cpu_core_count: _builtins.int,
                 is_supported_fors: Sequence[_builtins.str],
                 memory_size_in_gbs: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.int cpu_core_count: The number of CPU Cores the Instance provides. These are "OCPU"s.
        :param Sequence[_builtins.str] is_supported_fors: Return shapes that are supported by the service feature.
        :param _builtins.int memory_size_in_gbs: The amount of RAM the Instance provides. This is an IEC base-2 number.
        :param _builtins.str name: Name
        """
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "is_supported_fors", is_supported_fors)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU Cores the Instance provides. These are "OCPU"s.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="isSupportedFors")
    def is_supported_fors(self) -> Sequence[_builtins.str]:
        """
        Return shapes that are supported by the service feature.
        """
        return pulumi.get(self, "is_supported_fors")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The amount of RAM the Instance provides. This is an IEC base-2 number.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")


