# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkFirewallPolicyDecryptionProfileArgs', 'NetworkFirewallPolicyDecryptionProfile']

@pulumi.input_type
class NetworkFirewallPolicyDecryptionProfileArgs:
    def __init__(__self__, *,
                 network_firewall_policy_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 are_certificate_extensions_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_include_alt_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_expired_certificate_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_out_of_capacity_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_revocation_status_timeout_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unknown_revocation_status_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_cipher_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_version_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_untrusted_issuer_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyDecryptionProfile resource.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] type: Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        :param pulumi.Input[_builtins.bool] are_certificate_extensions_restricted: (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param pulumi.Input[_builtins.bool] is_auto_include_alt_name: (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param pulumi.Input[_builtins.bool] is_expired_certificate_blocked: (Updatable) Whether to block sessions if server's certificate is expired.
        :param pulumi.Input[_builtins.bool] is_out_of_capacity_blocked: (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param pulumi.Input[_builtins.bool] is_revocation_status_timeout_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param pulumi.Input[_builtins.bool] is_unknown_revocation_status_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param pulumi.Input[_builtins.bool] is_unsupported_cipher_blocked: (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        :param pulumi.Input[_builtins.bool] is_unsupported_version_blocked: (Updatable) Whether to block sessions if SSL version is not supported.
        :param pulumi.Input[_builtins.bool] is_untrusted_issuer_blocked: (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param pulumi.Input[_builtins.str] name: Name of the decryption profile.
        """
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "type", type)
        if are_certificate_extensions_restricted is not None:
            pulumi.set(__self__, "are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        if is_auto_include_alt_name is not None:
            pulumi.set(__self__, "is_auto_include_alt_name", is_auto_include_alt_name)
        if is_expired_certificate_blocked is not None:
            pulumi.set(__self__, "is_expired_certificate_blocked", is_expired_certificate_blocked)
        if is_out_of_capacity_blocked is not None:
            pulumi.set(__self__, "is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        if is_revocation_status_timeout_blocked is not None:
            pulumi.set(__self__, "is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        if is_unknown_revocation_status_blocked is not None:
            pulumi.set(__self__, "is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        if is_unsupported_cipher_blocked is not None:
            pulumi.set(__self__, "is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        if is_unsupported_version_blocked is not None:
            pulumi.set(__self__, "is_unsupported_version_blocked", is_unsupported_version_blocked)
        if is_untrusted_issuer_blocked is not None:
            pulumi.set(__self__, "is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @are_certificate_extensions_restricted.setter
    def are_certificate_extensions_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_certificate_extensions_restricted", value)

    @_builtins.property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @is_auto_include_alt_name.setter
    def is_auto_include_alt_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_include_alt_name", value)

    @_builtins.property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @is_expired_certificate_blocked.setter
    def is_expired_certificate_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_expired_certificate_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @is_out_of_capacity_blocked.setter
    def is_out_of_capacity_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_out_of_capacity_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @is_revocation_status_timeout_blocked.setter
    def is_revocation_status_timeout_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_revocation_status_timeout_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @is_unknown_revocation_status_blocked.setter
    def is_unknown_revocation_status_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unknown_revocation_status_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @is_unsupported_cipher_blocked.setter
    def is_unsupported_cipher_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unsupported_cipher_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @is_unsupported_version_blocked.setter
    def is_unsupported_version_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unsupported_version_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @is_untrusted_issuer_blocked.setter
    def is_untrusted_issuer_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_untrusted_issuer_blocked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyDecryptionProfileState:
    def __init__(__self__, *,
                 are_certificate_extensions_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_include_alt_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_expired_certificate_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_out_of_capacity_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_revocation_status_timeout_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unknown_revocation_status_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_cipher_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_version_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_untrusted_issuer_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyDecryptionProfile resources.
        :param pulumi.Input[_builtins.bool] are_certificate_extensions_restricted: (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param pulumi.Input[_builtins.bool] is_auto_include_alt_name: (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param pulumi.Input[_builtins.bool] is_expired_certificate_blocked: (Updatable) Whether to block sessions if server's certificate is expired.
        :param pulumi.Input[_builtins.bool] is_out_of_capacity_blocked: (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param pulumi.Input[_builtins.bool] is_revocation_status_timeout_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param pulumi.Input[_builtins.bool] is_unknown_revocation_status_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param pulumi.Input[_builtins.bool] is_unsupported_cipher_blocked: (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        :param pulumi.Input[_builtins.bool] is_unsupported_version_blocked: (Updatable) Whether to block sessions if SSL version is not supported.
        :param pulumi.Input[_builtins.bool] is_untrusted_issuer_blocked: (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param pulumi.Input[_builtins.str] name: Name of the decryption profile.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption profile belongs to.
        :param pulumi.Input[_builtins.str] type: Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        if are_certificate_extensions_restricted is not None:
            pulumi.set(__self__, "are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        if is_auto_include_alt_name is not None:
            pulumi.set(__self__, "is_auto_include_alt_name", is_auto_include_alt_name)
        if is_expired_certificate_blocked is not None:
            pulumi.set(__self__, "is_expired_certificate_blocked", is_expired_certificate_blocked)
        if is_out_of_capacity_blocked is not None:
            pulumi.set(__self__, "is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        if is_revocation_status_timeout_blocked is not None:
            pulumi.set(__self__, "is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        if is_unknown_revocation_status_blocked is not None:
            pulumi.set(__self__, "is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        if is_unsupported_cipher_blocked is not None:
            pulumi.set(__self__, "is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        if is_unsupported_version_blocked is not None:
            pulumi.set(__self__, "is_unsupported_version_blocked", is_unsupported_version_blocked)
        if is_untrusted_issuer_blocked is not None:
            pulumi.set(__self__, "is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @are_certificate_extensions_restricted.setter
    def are_certificate_extensions_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_certificate_extensions_restricted", value)

    @_builtins.property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @is_auto_include_alt_name.setter
    def is_auto_include_alt_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_include_alt_name", value)

    @_builtins.property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @is_expired_certificate_blocked.setter
    def is_expired_certificate_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_expired_certificate_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @is_out_of_capacity_blocked.setter
    def is_out_of_capacity_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_out_of_capacity_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @is_revocation_status_timeout_blocked.setter
    def is_revocation_status_timeout_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_revocation_status_timeout_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @is_unknown_revocation_status_blocked.setter
    def is_unknown_revocation_status_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unknown_revocation_status_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @is_unsupported_cipher_blocked.setter
    def is_unsupported_cipher_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unsupported_cipher_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @is_unsupported_version_blocked.setter
    def is_unsupported_version_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_unsupported_version_blocked", value)

    @_builtins.property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @is_untrusted_issuer_blocked.setter
    def is_untrusted_issuer_blocked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_untrusted_issuer_blocked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:NetworkFirewall/networkFirewallPolicyDecryptionProfile:NetworkFirewallPolicyDecryptionProfile")
class NetworkFirewallPolicyDecryptionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_certificate_extensions_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_include_alt_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_expired_certificate_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_out_of_capacity_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_revocation_status_timeout_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unknown_revocation_status_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_cipher_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_version_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_untrusted_issuer_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_decryption_profile = oci.networkfirewall.NetworkFirewallPolicyDecryptionProfile("test_network_firewall_policy_decryption_profile",
            name=network_firewall_policy_decryption_profile_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_decryption_profile_type,
            are_certificate_extensions_restricted=network_firewall_policy_decryption_profile_are_certificate_extensions_restricted,
            is_auto_include_alt_name=network_firewall_policy_decryption_profile_is_auto_include_alt_name,
            is_expired_certificate_blocked=network_firewall_policy_decryption_profile_is_expired_certificate_blocked,
            is_out_of_capacity_blocked=network_firewall_policy_decryption_profile_is_out_of_capacity_blocked,
            is_revocation_status_timeout_blocked=network_firewall_policy_decryption_profile_is_revocation_status_timeout_blocked,
            is_unknown_revocation_status_blocked=network_firewall_policy_decryption_profile_is_unknown_revocation_status_blocked,
            is_unsupported_cipher_blocked=network_firewall_policy_decryption_profile_is_unsupported_cipher_blocked,
            is_unsupported_version_blocked=network_firewall_policy_decryption_profile_is_unsupported_version_blocked,
            is_untrusted_issuer_blocked=network_firewall_policy_decryption_profile_is_untrusted_issuer_blocked)
        ```

        ## Import

        NetworkFirewallPolicyDecryptionProfiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyDecryptionProfile:NetworkFirewallPolicyDecryptionProfile test_network_firewall_policy_decryption_profile "networkFirewallPolicies/{networkFirewallPolicyId}/decryptionProfiles/{decryptionProfileName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_certificate_extensions_restricted: (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param pulumi.Input[_builtins.bool] is_auto_include_alt_name: (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param pulumi.Input[_builtins.bool] is_expired_certificate_blocked: (Updatable) Whether to block sessions if server's certificate is expired.
        :param pulumi.Input[_builtins.bool] is_out_of_capacity_blocked: (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param pulumi.Input[_builtins.bool] is_revocation_status_timeout_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param pulumi.Input[_builtins.bool] is_unknown_revocation_status_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param pulumi.Input[_builtins.bool] is_unsupported_cipher_blocked: (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        :param pulumi.Input[_builtins.bool] is_unsupported_version_blocked: (Updatable) Whether to block sessions if SSL version is not supported.
        :param pulumi.Input[_builtins.bool] is_untrusted_issuer_blocked: (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param pulumi.Input[_builtins.str] name: Name of the decryption profile.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] type: Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyDecryptionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_decryption_profile = oci.networkfirewall.NetworkFirewallPolicyDecryptionProfile("test_network_firewall_policy_decryption_profile",
            name=network_firewall_policy_decryption_profile_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_decryption_profile_type,
            are_certificate_extensions_restricted=network_firewall_policy_decryption_profile_are_certificate_extensions_restricted,
            is_auto_include_alt_name=network_firewall_policy_decryption_profile_is_auto_include_alt_name,
            is_expired_certificate_blocked=network_firewall_policy_decryption_profile_is_expired_certificate_blocked,
            is_out_of_capacity_blocked=network_firewall_policy_decryption_profile_is_out_of_capacity_blocked,
            is_revocation_status_timeout_blocked=network_firewall_policy_decryption_profile_is_revocation_status_timeout_blocked,
            is_unknown_revocation_status_blocked=network_firewall_policy_decryption_profile_is_unknown_revocation_status_blocked,
            is_unsupported_cipher_blocked=network_firewall_policy_decryption_profile_is_unsupported_cipher_blocked,
            is_unsupported_version_blocked=network_firewall_policy_decryption_profile_is_unsupported_version_blocked,
            is_untrusted_issuer_blocked=network_firewall_policy_decryption_profile_is_untrusted_issuer_blocked)
        ```

        ## Import

        NetworkFirewallPolicyDecryptionProfiles can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyDecryptionProfile:NetworkFirewallPolicyDecryptionProfile test_network_firewall_policy_decryption_profile "networkFirewallPolicies/{networkFirewallPolicyId}/decryptionProfiles/{decryptionProfileName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyDecryptionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyDecryptionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_certificate_extensions_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_include_alt_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_expired_certificate_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_out_of_capacity_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_revocation_status_timeout_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unknown_revocation_status_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_cipher_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_unsupported_version_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_untrusted_issuer_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyDecryptionProfileArgs.__new__(NetworkFirewallPolicyDecryptionProfileArgs)

            __props__.__dict__["are_certificate_extensions_restricted"] = are_certificate_extensions_restricted
            __props__.__dict__["is_auto_include_alt_name"] = is_auto_include_alt_name
            __props__.__dict__["is_expired_certificate_blocked"] = is_expired_certificate_blocked
            __props__.__dict__["is_out_of_capacity_blocked"] = is_out_of_capacity_blocked
            __props__.__dict__["is_revocation_status_timeout_blocked"] = is_revocation_status_timeout_blocked
            __props__.__dict__["is_unknown_revocation_status_blocked"] = is_unknown_revocation_status_blocked
            __props__.__dict__["is_unsupported_cipher_blocked"] = is_unsupported_cipher_blocked
            __props__.__dict__["is_unsupported_version_blocked"] = is_unsupported_version_blocked
            __props__.__dict__["is_untrusted_issuer_blocked"] = is_untrusted_issuer_blocked
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["parent_resource_id"] = None
        super(NetworkFirewallPolicyDecryptionProfile, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyDecryptionProfile:NetworkFirewallPolicyDecryptionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_certificate_extensions_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            is_auto_include_alt_name: Optional[pulumi.Input[_builtins.bool]] = None,
            is_expired_certificate_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_out_of_capacity_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_revocation_status_timeout_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_unknown_revocation_status_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_unsupported_cipher_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_unsupported_version_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            is_untrusted_issuer_blocked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkFirewallPolicyDecryptionProfile':
        """
        Get an existing NetworkFirewallPolicyDecryptionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] are_certificate_extensions_restricted: (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param pulumi.Input[_builtins.bool] is_auto_include_alt_name: (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param pulumi.Input[_builtins.bool] is_expired_certificate_blocked: (Updatable) Whether to block sessions if server's certificate is expired.
        :param pulumi.Input[_builtins.bool] is_out_of_capacity_blocked: (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param pulumi.Input[_builtins.bool] is_revocation_status_timeout_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param pulumi.Input[_builtins.bool] is_unknown_revocation_status_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param pulumi.Input[_builtins.bool] is_unsupported_cipher_blocked: (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        :param pulumi.Input[_builtins.bool] is_unsupported_version_blocked: (Updatable) Whether to block sessions if SSL version is not supported.
        :param pulumi.Input[_builtins.bool] is_untrusted_issuer_blocked: (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param pulumi.Input[_builtins.str] name: Name of the decryption profile.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption profile belongs to.
        :param pulumi.Input[_builtins.str] type: Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyDecryptionProfileState.__new__(_NetworkFirewallPolicyDecryptionProfileState)

        __props__.__dict__["are_certificate_extensions_restricted"] = are_certificate_extensions_restricted
        __props__.__dict__["is_auto_include_alt_name"] = is_auto_include_alt_name
        __props__.__dict__["is_expired_certificate_blocked"] = is_expired_certificate_blocked
        __props__.__dict__["is_out_of_capacity_blocked"] = is_out_of_capacity_blocked
        __props__.__dict__["is_revocation_status_timeout_blocked"] = is_revocation_status_timeout_blocked
        __props__.__dict__["is_unknown_revocation_status_blocked"] = is_unknown_revocation_status_blocked
        __props__.__dict__["is_unsupported_cipher_blocked"] = is_unsupported_cipher_blocked
        __props__.__dict__["is_unsupported_version_blocked"] = is_unsupported_version_blocked
        __props__.__dict__["is_untrusted_issuer_blocked"] = is_untrusted_issuer_blocked
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["type"] = type
        return NetworkFirewallPolicyDecryptionProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @_builtins.property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @_builtins.property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @_builtins.property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @_builtins.property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @_builtins.property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @_builtins.property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @_builtins.property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @_builtins.property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the decryption profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Network Firewall Policy identifier


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the type of decryption profile. The accepted values are - * SSL_FORWARD_PROXY * SSL_INBOUND_INSPECTION
        """
        return pulumi.get(self, "type")

