# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 default_backend_set_name: pulumi.Input[_builtins.str],
                 network_load_balancer_id: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ppv2enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 l3ip_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[_builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[_builtins.str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param pulumi.Input[_builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[_builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        :param pulumi.Input[_builtins.str] ip_version: (Updatable) IP version associated with the listener.
        :param pulumi.Input[_builtins.bool] is_ppv2enabled: (Updatable) Property to enable/disable PPv2 feature for this listener.
        :param pulumi.Input[_builtins.int] l3ip_idle_timeout: (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        :param pulumi.Input[_builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        :param pulumi.Input[_builtins.int] tcp_idle_timeout: (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        :param pulumi.Input[_builtins.int] udp_idle_timeout: (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "default_backend_set_name", default_backend_set_name)
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_ppv2enabled is not None:
            pulumi.set(__self__, "is_ppv2enabled", is_ppv2enabled)
        if l3ip_idle_timeout is not None:
            pulumi.set(__self__, "l3ip_idle_timeout", l3ip_idle_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcp_idle_timeout is not None:
            pulumi.set(__self__, "tcp_idle_timeout", tcp_idle_timeout)
        if udp_idle_timeout is not None:
            pulumi.set(__self__, "udp_idle_timeout", udp_idle_timeout)

    @_builtins.property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @default_backend_set_name.setter
    def default_backend_set_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_backend_set_name", value)

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="isPpv2enabled")
    def is_ppv2enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Property to enable/disable PPv2 feature for this listener.
        """
        return pulumi.get(self, "is_ppv2enabled")

    @is_ppv2enabled.setter
    def is_ppv2enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ppv2enabled", value)

    @_builtins.property
    @pulumi.getter(name="l3ipIdleTimeout")
    def l3ip_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        """
        return pulumi.get(self, "l3ip_idle_timeout")

    @l3ip_idle_timeout.setter
    def l3ip_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "l3ip_idle_timeout", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tcpIdleTimeout")
    def tcp_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        """
        return pulumi.get(self, "tcp_idle_timeout")

    @tcp_idle_timeout.setter
    def tcp_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeout")
    def udp_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "udp_idle_timeout")

    @udp_idle_timeout.setter
    def udp_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_idle_timeout", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 default_backend_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ppv2enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 l3ip_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[_builtins.str] ip_version: (Updatable) IP version associated with the listener.
        :param pulumi.Input[_builtins.bool] is_ppv2enabled: (Updatable) Property to enable/disable PPv2 feature for this listener.
        :param pulumi.Input[_builtins.int] l3ip_idle_timeout: (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        :param pulumi.Input[_builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        :param pulumi.Input[_builtins.str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param pulumi.Input[_builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[_builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        :param pulumi.Input[_builtins.int] tcp_idle_timeout: (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        :param pulumi.Input[_builtins.int] udp_idle_timeout: (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if default_backend_set_name is not None:
            pulumi.set(__self__, "default_backend_set_name", default_backend_set_name)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if is_ppv2enabled is not None:
            pulumi.set(__self__, "is_ppv2enabled", is_ppv2enabled)
        if l3ip_idle_timeout is not None:
            pulumi.set(__self__, "l3ip_idle_timeout", l3ip_idle_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tcp_idle_timeout is not None:
            pulumi.set(__self__, "tcp_idle_timeout", tcp_idle_timeout)
        if udp_idle_timeout is not None:
            pulumi.set(__self__, "udp_idle_timeout", udp_idle_timeout)

    @_builtins.property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @default_backend_set_name.setter
    def default_backend_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_backend_set_name", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="isPpv2enabled")
    def is_ppv2enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Property to enable/disable PPv2 feature for this listener.
        """
        return pulumi.get(self, "is_ppv2enabled")

    @is_ppv2enabled.setter
    def is_ppv2enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ppv2enabled", value)

    @_builtins.property
    @pulumi.getter(name="l3ipIdleTimeout")
    def l3ip_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        """
        return pulumi.get(self, "l3ip_idle_timeout")

    @l3ip_idle_timeout.setter
    def l3ip_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "l3ip_idle_timeout", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="tcpIdleTimeout")
    def tcp_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        """
        return pulumi.get(self, "tcp_idle_timeout")

    @tcp_idle_timeout.setter
    def tcp_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeout")
    def udp_idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "udp_idle_timeout")

    @udp_idle_timeout.setter
    def udp_idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_idle_timeout", value)


@pulumi.type_token("oci:NetworkLoadBalancer/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_backend_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ppv2enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 l3ip_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_listener = oci.networkloadbalancer.Listener("test_listener",
            default_backend_set_name=test_backend_set["name"],
            name=listener_name,
            network_load_balancer_id=test_network_load_balancer["id"],
            port=listener_port,
            protocol=listener_protocol,
            ip_version=listener_ip_version,
            is_ppv2enabled=listener_is_ppv2enabled,
            l3ip_idle_timeout=listener_l3ip_idle_timeout,
            tcp_idle_timeout=listener_tcp_idle_timeout,
            udp_idle_timeout=listener_udp_idle_timeout)
        ```

        ## Import

        Listeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkLoadBalancer/listener:Listener test_listener "networkLoadBalancers/{networkLoadBalancerId}/listeners/{listenerName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[_builtins.str] ip_version: (Updatable) IP version associated with the listener.
        :param pulumi.Input[_builtins.bool] is_ppv2enabled: (Updatable) Property to enable/disable PPv2 feature for this listener.
        :param pulumi.Input[_builtins.int] l3ip_idle_timeout: (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        :param pulumi.Input[_builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        :param pulumi.Input[_builtins.str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param pulumi.Input[_builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[_builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        :param pulumi.Input[_builtins.int] tcp_idle_timeout: (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        :param pulumi.Input[_builtins.int] udp_idle_timeout: (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_listener = oci.networkloadbalancer.Listener("test_listener",
            default_backend_set_name=test_backend_set["name"],
            name=listener_name,
            network_load_balancer_id=test_network_load_balancer["id"],
            port=listener_port,
            protocol=listener_protocol,
            ip_version=listener_ip_version,
            is_ppv2enabled=listener_is_ppv2enabled,
            l3ip_idle_timeout=listener_l3ip_idle_timeout,
            tcp_idle_timeout=listener_tcp_idle_timeout,
            udp_idle_timeout=listener_udp_idle_timeout)
        ```

        ## Import

        Listeners can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkLoadBalancer/listener:Listener test_listener "networkLoadBalancers/{networkLoadBalancerId}/listeners/{listenerName}"
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_backend_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ppv2enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 l3ip_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            if default_backend_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'default_backend_set_name'")
            __props__.__dict__["default_backend_set_name"] = default_backend_set_name
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["is_ppv2enabled"] = is_ppv2enabled
            __props__.__dict__["l3ip_idle_timeout"] = l3ip_idle_timeout
            __props__.__dict__["name"] = name
            if network_load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_load_balancer_id'")
            __props__.__dict__["network_load_balancer_id"] = network_load_balancer_id
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["tcp_idle_timeout"] = tcp_idle_timeout
            __props__.__dict__["udp_idle_timeout"] = udp_idle_timeout
        super(Listener, __self__).__init__(
            'oci:NetworkLoadBalancer/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_backend_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            is_ppv2enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            l3ip_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            tcp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            udp_idle_timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_backend_set_name: (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        :param pulumi.Input[_builtins.str] ip_version: (Updatable) IP version associated with the listener.
        :param pulumi.Input[_builtins.bool] is_ppv2enabled: (Updatable) Property to enable/disable PPv2 feature for this listener.
        :param pulumi.Input[_builtins.int] l3ip_idle_timeout: (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        :param pulumi.Input[_builtins.str] name: A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        :param pulumi.Input[_builtins.str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        :param pulumi.Input[_builtins.int] port: (Updatable) The communication port for the listener.  Example: `80`
        :param pulumi.Input[_builtins.str] protocol: (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        :param pulumi.Input[_builtins.int] tcp_idle_timeout: (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        :param pulumi.Input[_builtins.int] udp_idle_timeout: (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["default_backend_set_name"] = default_backend_set_name
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["is_ppv2enabled"] = is_ppv2enabled
        __props__.__dict__["l3ip_idle_timeout"] = l3ip_idle_timeout
        __props__.__dict__["name"] = name
        __props__.__dict__["network_load_balancer_id"] = network_load_balancer_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["tcp_idle_timeout"] = tcp_idle_timeout
        __props__.__dict__["udp_idle_timeout"] = udp_idle_timeout
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultBackendSetName")
    def default_backend_set_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the associated backend set.  Example: `example_backend_set`
        """
        return pulumi.get(self, "default_backend_set_name")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) IP version associated with the listener.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="isPpv2enabled")
    def is_ppv2enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Property to enable/disable PPv2 feature for this listener.
        """
        return pulumi.get(self, "is_ppv2enabled")

    @_builtins.property
    @pulumi.getter(name="l3ipIdleTimeout")
    def l3ip_idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The duration for L3IP idle timeout in seconds. Example: `200`
        """
        return pulumi.get(self, "l3ip_idle_timeout")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A friendly name for the listener. It must be unique and it cannot be changed.  Example: `example_listener`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer to update.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The communication port for the listener.  Example: `80`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The protocol on which the listener accepts connection requests. For public network load balancers, ANY protocol refers to TCP/UDP with the wildcard port. For private network load balancers, ANY protocol refers to TCP/UDP/ICMP (note that ICMP requires isPreserveSourceDestination to be set to true). "ListNetworkLoadBalancersProtocols" API is deprecated and it will not return the updated values. Use the allowed values for the protocol instead.  Example: `TCP`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="tcpIdleTimeout")
    def tcp_idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The duration for TCP idle timeout in seconds. Example: `300`
        """
        return pulumi.get(self, "tcp_idle_timeout")

    @_builtins.property
    @pulumi.getter(name="udpIdleTimeout")
    def udp_idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The duration for UDP idle timeout in seconds. Example: `120` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "udp_idle_timeout")

