# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkLoadBalancerArgs', 'NetworkLoadBalancer']

@pulumi.input_type
class NetworkLoadBalancerArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 assigned_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 assigned_private_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_preserve_source_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_symmetric_hash_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nlb_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_ipv6cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkLoadBalancer resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Network load balancer identifier, which can be renamed.
        :param pulumi.Input[_builtins.str] subnet_id: The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] assigned_ipv6: IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        :param pulumi.Input[_builtins.str] assigned_private_ipv4: Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_preserve_source_destination: (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        :param pulumi.Input[_builtins.bool] is_private: Whether the network load balancer has a virtual cloud network-local (private) IP address.
               
               If "true", then the service assigns a private IP address to the network load balancer.
               
               If "false", then the service assigns a public IP address to the network load balancer.
               
               A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] is_symmetric_hash_enabled: (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 
               
               Example: `true`
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_security_group_ids: (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
               
               During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.
               
               The benefits of associating the network load balancer with network security groups include:
               *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
               *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.
               
               Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        :param pulumi.Input[_builtins.str] nlb_ip_version: (Updatable) IP version associated with the NLB.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]] reserved_ips: An array of reserved Ips.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[_builtins.str] subnet_ipv6cidr: IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if assigned_ipv6 is not None:
            pulumi.set(__self__, "assigned_ipv6", assigned_ipv6)
        if assigned_private_ipv4 is not None:
            pulumi.set(__self__, "assigned_private_ipv4", assigned_private_ipv4)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_preserve_source_destination is not None:
            pulumi.set(__self__, "is_preserve_source_destination", is_preserve_source_destination)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if is_symmetric_hash_enabled is not None:
            pulumi.set(__self__, "is_symmetric_hash_enabled", is_symmetric_hash_enabled)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if nlb_ip_version is not None:
            pulumi.set(__self__, "nlb_ip_version", nlb_ip_version)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if subnet_ipv6cidr is not None:
            pulumi.set(__self__, "subnet_ipv6cidr", subnet_ipv6cidr)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Network load balancer identifier, which can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="assignedIpv6")
    def assigned_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        """
        return pulumi.get(self, "assigned_ipv6")

    @assigned_ipv6.setter
    def assigned_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="assignedPrivateIpv4")
    def assigned_private_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        """
        return pulumi.get(self, "assigned_private_ipv4")

    @assigned_private_ipv4.setter
    def assigned_private_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_private_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isPreserveSourceDestination")
    def is_preserve_source_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        """
        return pulumi.get(self, "is_preserve_source_destination")

    @is_preserve_source_destination.setter
    def is_preserve_source_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_preserve_source_destination", value)

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the network load balancer has a virtual cloud network-local (private) IP address.

        If "true", then the service assigns a private IP address to the network load balancer.

        If "false", then the service assigns a public IP address to the network load balancer.

        A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_private", value)

    @_builtins.property
    @pulumi.getter(name="isSymmetricHashEnabled")
    def is_symmetric_hash_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 

        Example: `true`
        Example: `true`
        """
        return pulumi.get(self, "is_symmetric_hash_enabled")

    @is_symmetric_hash_enabled.setter
    def is_symmetric_hash_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_symmetric_hash_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.

        During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.

        The benefits of associating the network load balancer with network security groups include:
        *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
        *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.

        Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="nlbIpVersion")
    def nlb_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) IP version associated with the NLB.
        """
        return pulumi.get(self, "nlb_ip_version")

    @nlb_ip_version.setter
    def nlb_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nlb_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]]:
        """
        An array of reserved Ips.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]]):
        pulumi.set(self, "reserved_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @_builtins.property
    @pulumi.getter(name="subnetIpv6cidr")
    def subnet_ipv6cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ipv6cidr")

    @subnet_ipv6cidr.setter
    def subnet_ipv6cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_ipv6cidr", value)


@pulumi.input_type
class _NetworkLoadBalancerState:
    def __init__(__self__, *,
                 assigned_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 assigned_private_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressArgs']]]] = None,
                 is_preserve_source_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_symmetric_hash_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nlb_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ipv6cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkLoadBalancer resources.
        :param pulumi.Input[_builtins.str] assigned_ipv6: IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        :param pulumi.Input[_builtins.str] assigned_private_ipv4: Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Network load balancer identifier, which can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressArgs']]] ip_addresses: An array of IP addresses.
        :param pulumi.Input[_builtins.bool] is_preserve_source_destination: (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        :param pulumi.Input[_builtins.bool] is_private: Whether the network load balancer has a virtual cloud network-local (private) IP address.
               
               If "true", then the service assigns a private IP address to the network load balancer.
               
               If "false", then the service assigns a public IP address to the network load balancer.
               
               A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] is_symmetric_hash_enabled: (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 
               
               Example: `true`
               Example: `true`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_security_group_ids: (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
               
               During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.
               
               The benefits of associating the network load balancer with network security groups include:
               *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
               *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.
               
               Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        :param pulumi.Input[_builtins.str] nlb_ip_version: (Updatable) IP version associated with the NLB.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]] reserved_ips: An array of reserved Ips.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[_builtins.str] state: The current state of the network load balancer.
        :param pulumi.Input[_builtins.str] subnet_id: The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] subnet_ipv6cidr: IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        if assigned_ipv6 is not None:
            pulumi.set(__self__, "assigned_ipv6", assigned_ipv6)
        if assigned_private_ipv4 is not None:
            pulumi.set(__self__, "assigned_private_ipv4", assigned_private_ipv4)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if is_preserve_source_destination is not None:
            pulumi.set(__self__, "is_preserve_source_destination", is_preserve_source_destination)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if is_symmetric_hash_enabled is not None:
            pulumi.set(__self__, "is_symmetric_hash_enabled", is_symmetric_hash_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if nlb_ip_version is not None:
            pulumi.set(__self__, "nlb_ip_version", nlb_ip_version)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_ipv6cidr is not None:
            pulumi.set(__self__, "subnet_ipv6cidr", subnet_ipv6cidr)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="assignedIpv6")
    def assigned_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        """
        return pulumi.get(self, "assigned_ipv6")

    @assigned_ipv6.setter
    def assigned_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="assignedPrivateIpv4")
    def assigned_private_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        """
        return pulumi.get(self, "assigned_private_ipv4")

    @assigned_private_ipv4.setter
    def assigned_private_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assigned_private_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Network load balancer identifier, which can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressArgs']]]]:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerIpAddressArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="isPreserveSourceDestination")
    def is_preserve_source_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        """
        return pulumi.get(self, "is_preserve_source_destination")

    @is_preserve_source_destination.setter
    def is_preserve_source_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_preserve_source_destination", value)

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the network load balancer has a virtual cloud network-local (private) IP address.

        If "true", then the service assigns a private IP address to the network load balancer.

        If "false", then the service assigns a public IP address to the network load balancer.

        A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_private", value)

    @_builtins.property
    @pulumi.getter(name="isSymmetricHashEnabled")
    def is_symmetric_hash_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 

        Example: `true`
        Example: `true`
        """
        return pulumi.get(self, "is_symmetric_hash_enabled")

    @is_symmetric_hash_enabled.setter
    def is_symmetric_hash_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_symmetric_hash_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.

        During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.

        The benefits of associating the network load balancer with network security groups include:
        *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
        *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.

        Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="nlbIpVersion")
    def nlb_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) IP version associated with the NLB.
        """
        return pulumi.get(self, "nlb_ip_version")

    @nlb_ip_version.setter
    def nlb_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nlb_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]]:
        """
        An array of reserved Ips.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkLoadBalancerReservedIpArgs']]]]):
        pulumi.set(self, "reserved_ips", value)

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the network load balancer.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetIpv6cidr")
    def subnet_ipv6cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ipv6cidr")

    @subnet_ipv6cidr.setter
    def subnet_ipv6cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_ipv6cidr", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:NetworkLoadBalancer/networkLoadBalancer:NetworkLoadBalancer")
class NetworkLoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 assigned_private_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_preserve_source_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_symmetric_hash_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nlb_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerReservedIpArgs', 'NetworkLoadBalancerReservedIpArgsDict']]]]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ipv6cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        NetworkLoadBalancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkLoadBalancer/networkLoadBalancer:NetworkLoadBalancer test_network_load_balancer "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assigned_ipv6: IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        :param pulumi.Input[_builtins.str] assigned_private_ipv4: Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Network load balancer identifier, which can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_preserve_source_destination: (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        :param pulumi.Input[_builtins.bool] is_private: Whether the network load balancer has a virtual cloud network-local (private) IP address.
               
               If "true", then the service assigns a private IP address to the network load balancer.
               
               If "false", then the service assigns a public IP address to the network load balancer.
               
               A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] is_symmetric_hash_enabled: (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 
               
               Example: `true`
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_security_group_ids: (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
               
               During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.
               
               The benefits of associating the network load balancer with network security groups include:
               *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
               *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.
               
               Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        :param pulumi.Input[_builtins.str] nlb_ip_version: (Updatable) IP version associated with the NLB.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerReservedIpArgs', 'NetworkLoadBalancerReservedIpArgsDict']]]] reserved_ips: An array of reserved Ips.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[_builtins.str] subnet_id: The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] subnet_ipv6cidr: IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkLoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        NetworkLoadBalancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:NetworkLoadBalancer/networkLoadBalancer:NetworkLoadBalancer test_network_load_balancer "id"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assigned_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 assigned_private_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_preserve_source_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_private: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_symmetric_hash_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nlb_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerReservedIpArgs', 'NetworkLoadBalancerReservedIpArgsDict']]]]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ipv6cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkLoadBalancerArgs.__new__(NetworkLoadBalancerArgs)

            __props__.__dict__["assigned_ipv6"] = assigned_ipv6
            __props__.__dict__["assigned_private_ipv4"] = assigned_private_ipv4
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_preserve_source_destination"] = is_preserve_source_destination
            __props__.__dict__["is_private"] = is_private
            __props__.__dict__["is_symmetric_hash_enabled"] = is_symmetric_hash_enabled
            __props__.__dict__["network_security_group_ids"] = network_security_group_ids
            __props__.__dict__["nlb_ip_version"] = nlb_ip_version
            __props__.__dict__["reserved_ips"] = reserved_ips
            __props__.__dict__["security_attributes"] = security_attributes
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["subnet_ipv6cidr"] = subnet_ipv6cidr
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NetworkLoadBalancer, __self__).__init__(
            'oci:NetworkLoadBalancer/networkLoadBalancer:NetworkLoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assigned_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            assigned_private_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerIpAddressArgs', 'NetworkLoadBalancerIpAddressArgsDict']]]]] = None,
            is_preserve_source_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            is_private: Optional[pulumi.Input[_builtins.bool]] = None,
            is_symmetric_hash_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            nlb_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerReservedIpArgs', 'NetworkLoadBalancerReservedIpArgsDict']]]]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_ipv6cidr: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkLoadBalancer':
        """
        Get an existing NetworkLoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assigned_ipv6: IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        :param pulumi.Input[_builtins.str] assigned_private_ipv4: Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Network load balancer identifier, which can be renamed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerIpAddressArgs', 'NetworkLoadBalancerIpAddressArgsDict']]]] ip_addresses: An array of IP addresses.
        :param pulumi.Input[_builtins.bool] is_preserve_source_destination: (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        :param pulumi.Input[_builtins.bool] is_private: Whether the network load balancer has a virtual cloud network-local (private) IP address.
               
               If "true", then the service assigns a private IP address to the network load balancer.
               
               If "false", then the service assigns a public IP address to the network load balancer.
               
               A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.
               
               Example: `true`
        :param pulumi.Input[_builtins.bool] is_symmetric_hash_enabled: (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 
               
               Example: `true`
               Example: `true`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_security_group_ids: (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.
               
               During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.
               
               The benefits of associating the network load balancer with network security groups include:
               *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
               *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.
               
               Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        :param pulumi.Input[_builtins.str] nlb_ip_version: (Updatable) IP version associated with the NLB.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkLoadBalancerReservedIpArgs', 'NetworkLoadBalancerReservedIpArgsDict']]]] reserved_ips: An array of reserved Ips.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] security_attributes: (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[_builtins.str] state: The current state of the network load balancer.
        :param pulumi.Input[_builtins.str] subnet_id: The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] subnet_ipv6cidr: IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkLoadBalancerState.__new__(_NetworkLoadBalancerState)

        __props__.__dict__["assigned_ipv6"] = assigned_ipv6
        __props__.__dict__["assigned_private_ipv4"] = assigned_private_ipv4
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["is_preserve_source_destination"] = is_preserve_source_destination
        __props__.__dict__["is_private"] = is_private
        __props__.__dict__["is_symmetric_hash_enabled"] = is_symmetric_hash_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["network_security_group_ids"] = network_security_group_ids
        __props__.__dict__["nlb_ip_version"] = nlb_ip_version
        __props__.__dict__["reserved_ips"] = reserved_ips
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subnet_ipv6cidr"] = subnet_ipv6cidr
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return NetworkLoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assignedIpv6")
    def assigned_ipv6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IPv6 address to be assigned to the network load balancer being created. This IP address has to be part of one of the prefixes supported by the subnet. Example: "2607:9b80:9a0a:9a7e:abcd:ef01:2345:6789"
        """
        return pulumi.get(self, "assigned_ipv6")

    @_builtins.property
    @pulumi.getter(name="assignedPrivateIpv4")
    def assigned_private_ipv4(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private IP address to be assigned to the network load balancer being created. This IP address has to be in the CIDR range of the subnet where network load balancer is being created Example: "10.0.0.1"
        """
        return pulumi.get(self, "assigned_private_ipv4")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the network load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Network load balancer identifier, which can be renamed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.NetworkLoadBalancerIpAddress']]:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="isPreserveSourceDestination")
    def is_preserve_source_destination(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) This parameter can be enabled only if backends are compute OCIDs. When enabled, the skipSourceDestinationCheck parameter is automatically enabled on the load balancer VNIC, and packets are sent to the backend with the entire IP header intact.
        """
        return pulumi.get(self, "is_preserve_source_destination")

    @_builtins.property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the network load balancer has a virtual cloud network-local (private) IP address.

        If "true", then the service assigns a private IP address to the network load balancer.

        If "false", then the service assigns a public IP address to the network load balancer.

        A public network load balancer is accessible from the internet, depending on the [security list rules](https://docs.cloud.oracle.com/iaas/Content/network/Concepts/securitylists.htm) for your virtual cloud network. For more information about public and private network load balancers, see [Network Load Balancer Types](https://docs.cloud.oracle.com/iaas/Content/NetworkLoadBalancer/introduction.htm#NetworkLoadBalancerTypes). This value is true by default.

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @_builtins.property
    @pulumi.getter(name="isSymmetricHashEnabled")
    def is_symmetric_hash_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) This can only be enabled when NLB is working in transparent mode with source destination header preservation enabled.  This removes the additional dependency from NLB backends(like Firewalls) to perform SNAT. 

        Example: `true`
        Example: `true`
        """
        return pulumi.get(self, "is_symmetric_hash_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        (Updatable) An array of network security groups [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the network load balancer.

        During the creation of the network load balancer, the service adds the new load balancer to the specified network security groups.

        The benefits of associating the network load balancer with network security groups include:
        *  Network security groups define network security rules to govern ingress and egress traffic for the network load balancer.
        *  The network security rules of other resources can reference the network security groups associated with the network load balancer to ensure access.

        Example: ["ocid1.nsg.oc1.phx.unique_ID"]
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="nlbIpVersion")
    def nlb_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) IP version associated with the NLB.
        """
        return pulumi.get(self, "nlb_ip_version")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> pulumi.Output[Sequence['outputs.NetworkLoadBalancerReservedIp']]:
        """
        An array of reserved Ips.
        """
        return pulumi.get(self, "reserved_ips")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) ZPR tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"oracle-zpr": {"td": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the network load balancer.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet in which the network load balancer is spawned [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetIpv6cidr")
    def subnet_ipv6cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IPv6 subnet prefix selection. If Ipv6 subnet prefix is passed, Nlb Ipv6 Address would be assign within the cidr block. NLB has to be dual or single stack ipv6 to support this.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ipv6cidr")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Key-value pair representing system tags' keys and values scoped to a namespace. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the network load balancer was created, in the format defined by RFC3339.  Example: `2020-05-01T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the network load balancer was updated. An RFC3339 formatted date-time string.  Example: `2020-05-01T22:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

