# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbmulticloudOracleDbAzureConnectorArgs', 'DbmulticloudOracleDbAzureConnector']

@pulumi.input_type
class DbmulticloudOracleDbAzureConnectorArgs:
    def __init__(__self__, *,
                 access_token: pulumi.Input[_builtins.str],
                 azure_identity_mechanism: pulumi.Input[_builtins.str],
                 azure_resource_group: pulumi.Input[_builtins.str],
                 azure_subscription_id: pulumi.Input[_builtins.str],
                 azure_tenant_id: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 db_cluster_resource_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 arc_agent_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]] = None,
                 last_modification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbmulticloudOracleDbAzureConnector resource.
        :param pulumi.Input[_builtins.str] access_token: (Updatable) Azure bearer access token.
        :param pulumi.Input[_builtins.str] azure_identity_mechanism: (Updatable) Azure Identity mechanism.
        :param pulumi.Input[_builtins.str] azure_resource_group: (Updatable) Azure Resource group name.
        :param pulumi.Input[_builtins.str] azure_subscription_id: (Updatable) Azure Subscription ID.
        :param pulumi.Input[_builtins.str] azure_tenant_id: (Updatable) Azure Tenant ID.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] db_cluster_resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Azure Connector resource name.
        :param pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]] arc_agent_nodes: List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "azure_identity_mechanism", azure_identity_mechanism)
        pulumi.set(__self__, "azure_resource_group", azure_resource_group)
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_cluster_resource_id", db_cluster_resource_id)
        pulumi.set(__self__, "display_name", display_name)
        if arc_agent_nodes is not None:
            pulumi.set(__self__, "arc_agent_nodes", arc_agent_nodes)
        if last_modification is not None:
            pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Azure bearer access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="azureIdentityMechanism")
    def azure_identity_mechanism(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Azure Identity mechanism.
        """
        return pulumi.get(self, "azure_identity_mechanism")

    @azure_identity_mechanism.setter
    def azure_identity_mechanism(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_identity_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="azureResourceGroup")
    def azure_resource_group(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Azure Resource group name.
        """
        return pulumi.get(self, "azure_resource_group")

    @azure_resource_group.setter
    def azure_resource_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Azure Subscription ID.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Azure Tenant ID.
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @db_cluster_resource_id.setter
    def db_cluster_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Oracle DB Azure Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="arcAgentNodes")
    def arc_agent_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]]:
        """
        List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        """
        return pulumi.get(self, "arc_agent_nodes")

    @arc_agent_nodes.setter
    def arc_agent_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]]):
        pulumi.set(self, "arc_agent_nodes", value)

    @_builtins.property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the latest modification of the Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "last_modification")

    @last_modification.setter
    def last_modification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modification", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)


@pulumi.input_type
class _DbmulticloudOracleDbAzureConnectorState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_agent_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]] = None,
                 azure_identity_connectivity_status: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_identity_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbmulticloudOracleDbAzureConnector resources.
        :param pulumi.Input[_builtins.str] access_token: (Updatable) Azure bearer access token.
        :param pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]] arc_agent_nodes: List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] azure_identity_connectivity_status: The current Connectivity status of Azure Identity Connector resource.
        :param pulumi.Input[_builtins.str] azure_identity_mechanism: (Updatable) Azure Identity mechanism.
        :param pulumi.Input[_builtins.str] azure_resource_group: (Updatable) Azure Resource group name.
        :param pulumi.Input[_builtins.str] azure_subscription_id: (Updatable) Azure Subscription ID.
        :param pulumi.Input[_builtins.str] azure_tenant_id: (Updatable) Azure Tenant ID.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] db_cluster_resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Azure Connector resource name.
        :param pulumi.Input[_builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the Azure Arc Agent resource.
        :param pulumi.Input[_builtins.str] time_created: Time when the Oracle DB Azure Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[_builtins.str] time_updated: Time when the Oracle DB Azure Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if arc_agent_nodes is not None:
            pulumi.set(__self__, "arc_agent_nodes", arc_agent_nodes)
        if azure_identity_connectivity_status is not None:
            pulumi.set(__self__, "azure_identity_connectivity_status", azure_identity_connectivity_status)
        if azure_identity_mechanism is not None:
            pulumi.set(__self__, "azure_identity_mechanism", azure_identity_mechanism)
        if azure_resource_group is not None:
            pulumi.set(__self__, "azure_resource_group", azure_resource_group)
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if azure_tenant_id is not None:
            pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_cluster_resource_id is not None:
            pulumi.set(__self__, "db_cluster_resource_id", db_cluster_resource_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_modification is not None:
            pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Azure bearer access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="arcAgentNodes")
    def arc_agent_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]]:
        """
        List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        """
        return pulumi.get(self, "arc_agent_nodes")

    @arc_agent_nodes.setter
    def arc_agent_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs']]]]):
        pulumi.set(self, "arc_agent_nodes", value)

    @_builtins.property
    @pulumi.getter(name="azureIdentityConnectivityStatus")
    def azure_identity_connectivity_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current Connectivity status of Azure Identity Connector resource.
        """
        return pulumi.get(self, "azure_identity_connectivity_status")

    @azure_identity_connectivity_status.setter
    def azure_identity_connectivity_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_identity_connectivity_status", value)

    @_builtins.property
    @pulumi.getter(name="azureIdentityMechanism")
    def azure_identity_mechanism(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Azure Identity mechanism.
        """
        return pulumi.get(self, "azure_identity_mechanism")

    @azure_identity_mechanism.setter
    def azure_identity_mechanism(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_identity_mechanism", value)

    @_builtins.property
    @pulumi.getter(name="azureResourceGroup")
    def azure_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Azure Resource group name.
        """
        return pulumi.get(self, "azure_resource_group")

    @azure_resource_group.setter
    def azure_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Azure Subscription ID.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Azure Tenant ID.
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @db_cluster_resource_id.setter
    def db_cluster_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle DB Azure Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the latest modification of the Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "last_modification")

    @last_modification.setter
    def last_modification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modification", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the Azure Arc Agent resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the Oracle DB Azure Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the Oracle DB Azure Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/dbmulticloudOracleDbAzureConnector:DbmulticloudOracleDbAzureConnector")
class DbmulticloudOracleDbAzureConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_agent_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs', 'DbmulticloudOracleDbAzureConnectorArcAgentNodeArgsDict']]]]] = None,
                 azure_identity_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        OracleDbAzureConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureConnector:DbmulticloudOracleDbAzureConnector test_oracle_db_azure_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: (Updatable) Azure bearer access token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs', 'DbmulticloudOracleDbAzureConnectorArcAgentNodeArgsDict']]]] arc_agent_nodes: List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] azure_identity_mechanism: (Updatable) Azure Identity mechanism.
        :param pulumi.Input[_builtins.str] azure_resource_group: (Updatable) Azure Resource group name.
        :param pulumi.Input[_builtins.str] azure_subscription_id: (Updatable) Azure Subscription ID.
        :param pulumi.Input[_builtins.str] azure_tenant_id: (Updatable) Azure Tenant ID.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] db_cluster_resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Azure Connector resource name.
        :param pulumi.Input[_builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbmulticloudOracleDbAzureConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        OracleDbAzureConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureConnector:DbmulticloudOracleDbAzureConnector test_oracle_db_azure_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbmulticloudOracleDbAzureConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbmulticloudOracleDbAzureConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_agent_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs', 'DbmulticloudOracleDbAzureConnectorArcAgentNodeArgsDict']]]]] = None,
                 azure_identity_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbmulticloudOracleDbAzureConnectorArgs.__new__(DbmulticloudOracleDbAzureConnectorArgs)

            if access_token is None and not opts.urn:
                raise TypeError("Missing required property 'access_token'")
            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["arc_agent_nodes"] = arc_agent_nodes
            if azure_identity_mechanism is None and not opts.urn:
                raise TypeError("Missing required property 'azure_identity_mechanism'")
            __props__.__dict__["azure_identity_mechanism"] = azure_identity_mechanism
            if azure_resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'azure_resource_group'")
            __props__.__dict__["azure_resource_group"] = azure_resource_group
            if azure_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'azure_subscription_id'")
            __props__.__dict__["azure_subscription_id"] = azure_subscription_id
            if azure_tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'azure_tenant_id'")
            __props__.__dict__["azure_tenant_id"] = azure_tenant_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if db_cluster_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_resource_id'")
            __props__.__dict__["db_cluster_resource_id"] = db_cluster_resource_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["last_modification"] = last_modification
            __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
            __props__.__dict__["azure_identity_connectivity_status"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbmulticloudOracleDbAzureConnector, __self__).__init__(
            'oci:oci/dbmulticloudOracleDbAzureConnector:DbmulticloudOracleDbAzureConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[_builtins.str]] = None,
            arc_agent_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs', 'DbmulticloudOracleDbAzureConnectorArcAgentNodeArgsDict']]]]] = None,
            azure_identity_connectivity_status: Optional[pulumi.Input[_builtins.str]] = None,
            azure_identity_mechanism: Optional[pulumi.Input[_builtins.str]] = None,
            azure_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_modification: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbmulticloudOracleDbAzureConnector':
        """
        Get an existing DbmulticloudOracleDbAzureConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: (Updatable) Azure bearer access token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbAzureConnectorArcAgentNodeArgs', 'DbmulticloudOracleDbAzureConnectorArcAgentNodeArgsDict']]]] arc_agent_nodes: List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] azure_identity_connectivity_status: The current Connectivity status of Azure Identity Connector resource.
        :param pulumi.Input[_builtins.str] azure_identity_mechanism: (Updatable) Azure Identity mechanism.
        :param pulumi.Input[_builtins.str] azure_resource_group: (Updatable) Azure Resource group name.
        :param pulumi.Input[_builtins.str] azure_subscription_id: (Updatable) Azure Subscription ID.
        :param pulumi.Input[_builtins.str] azure_tenant_id: (Updatable) Azure Tenant ID.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] db_cluster_resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Azure Connector resource name.
        :param pulumi.Input[_builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Connector resource.
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the Azure Arc Agent resource.
        :param pulumi.Input[_builtins.str] time_created: Time when the Oracle DB Azure Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[_builtins.str] time_updated: Time when the Oracle DB Azure Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbmulticloudOracleDbAzureConnectorState.__new__(_DbmulticloudOracleDbAzureConnectorState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["arc_agent_nodes"] = arc_agent_nodes
        __props__.__dict__["azure_identity_connectivity_status"] = azure_identity_connectivity_status
        __props__.__dict__["azure_identity_mechanism"] = azure_identity_mechanism
        __props__.__dict__["azure_resource_group"] = azure_resource_group
        __props__.__dict__["azure_subscription_id"] = azure_subscription_id
        __props__.__dict__["azure_tenant_id"] = azure_tenant_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_cluster_resource_id"] = db_cluster_resource_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_modification"] = last_modification
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DbmulticloudOracleDbAzureConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Azure bearer access token.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="arcAgentNodes")
    def arc_agent_nodes(self) -> pulumi.Output[Sequence['outputs.DbmulticloudOracleDbAzureConnectorArcAgentNode']]:
        """
        List of all VMs where Arc Agent is installed under Cloud VM Cluster.
        """
        return pulumi.get(self, "arc_agent_nodes")

    @_builtins.property
    @pulumi.getter(name="azureIdentityConnectivityStatus")
    def azure_identity_connectivity_status(self) -> pulumi.Output[_builtins.str]:
        """
        The current Connectivity status of Azure Identity Connector resource.
        """
        return pulumi.get(self, "azure_identity_connectivity_status")

    @_builtins.property
    @pulumi.getter(name="azureIdentityMechanism")
    def azure_identity_mechanism(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Azure Identity mechanism.
        """
        return pulumi.get(self, "azure_identity_mechanism")

    @_builtins.property
    @pulumi.getter(name="azureResourceGroup")
    def azure_resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Azure Resource group name.
        """
        return pulumi.get(self, "azure_resource_group")

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Azure Subscription ID.
        """
        return pulumi.get(self, "azure_subscription_id")

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Azure Tenant ID.
        """
        return pulumi.get(self, "azure_tenant_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle DB Azure Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the latest modification of the Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "last_modification")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the Azure Arc Agent resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the Oracle DB Azure Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the Oracle DB Azure Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

