# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbmulticloudOracleDbGcpIdentityConnectorArgs', 'DbmulticloudOracleDbGcpIdentityConnector']

@pulumi.input_type
class DbmulticloudOracleDbGcpIdentityConnectorArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 gcp_location: pulumi.Input[_builtins.str],
                 gcp_resource_service_agent_id: pulumi.Input[_builtins.str],
                 gcp_workload_identity_pool_id: pulumi.Input[_builtins.str],
                 gcp_workload_identity_provider_id: pulumi.Input[_builtins.str],
                 issuer_url: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbmulticloudOracleDbGcpIdentityConnector resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Google GCP Identity Connector resource name.
        :param pulumi.Input[_builtins.str] gcp_location: (Updatable) GCP Location.
        :param pulumi.Input[_builtins.str] gcp_resource_service_agent_id: (Updatable) The ID of the GCP resource service agent.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_pool_id: (Updatable) The ID of the cloud GCP Workload Identity Pool.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_provider_id: (Updatable) The ID of the GCP Workload Identity Provider.
        :param pulumi.Input[_builtins.str] issuer_url: (Updatable) OIDC token issuer Url
        :param pulumi.Input[_builtins.str] project_id: (Updatable) Project id of the customer project.
        :param pulumi.Input[_builtins.str] resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gcp_location", gcp_location)
        pulumi.set(__self__, "gcp_resource_service_agent_id", gcp_resource_service_agent_id)
        pulumi.set(__self__, "gcp_workload_identity_pool_id", gcp_workload_identity_pool_id)
        pulumi.set(__self__, "gcp_workload_identity_provider_id", gcp_workload_identity_provider_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "resource_id", resource_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Oracle DB Google GCP Identity Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="gcpLocation")
    def gcp_location(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) GCP Location.
        """
        return pulumi.get(self, "gcp_location")

    @gcp_location.setter
    def gcp_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_location", value)

    @_builtins.property
    @pulumi.getter(name="gcpResourceServiceAgentId")
    def gcp_resource_service_agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The ID of the GCP resource service agent.
        """
        return pulumi.get(self, "gcp_resource_service_agent_id")

    @gcp_resource_service_agent_id.setter
    def gcp_resource_service_agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_resource_service_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityPoolId")
    def gcp_workload_identity_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The ID of the cloud GCP Workload Identity Pool.
        """
        return pulumi.get(self, "gcp_workload_identity_pool_id")

    @gcp_workload_identity_pool_id.setter
    def gcp_workload_identity_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_workload_identity_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityProviderId")
    def gcp_workload_identity_provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The ID of the GCP Workload Identity Provider.
        """
        return pulumi.get(self, "gcp_workload_identity_provider_id")

    @gcp_workload_identity_provider_id.setter
    def gcp_workload_identity_provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_workload_identity_provider_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) OIDC token issuer Url
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Project id of the customer project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DbmulticloudOracleDbGcpIdentityConnectorState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gcp_identity_connectivity_status: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs']]]] = None,
                 gcp_resource_service_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbmulticloudOracleDbGcpIdentityConnector resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Google GCP Identity Connector resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gcp_identity_connectivity_status: The current Connectivity status of GCP Identity Connector resource.
        :param pulumi.Input[_builtins.str] gcp_location: (Updatable) GCP Location.
        :param pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs']]] gcp_nodes: List of All VMs where GCP Identity Connector is configured for this VMCluster.
        :param pulumi.Input[_builtins.str] gcp_resource_service_agent_id: (Updatable) The ID of the GCP resource service agent.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_pool_id: (Updatable) The ID of the cloud GCP Workload Identity Pool.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_provider_id: (Updatable) The ID of the GCP Workload Identity Provider.
        :param pulumi.Input[_builtins.str] issuer_url: (Updatable) OIDC token issuer Url
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[_builtins.str] project_id: (Updatable) Project id of the customer project.
        :param pulumi.Input[_builtins.str] resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the GCP Identity Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Time when the Oracle DB GCP Identity Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[_builtins.str] time_updated: Time when the Oracle DB GCP Identity Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gcp_identity_connectivity_status is not None:
            pulumi.set(__self__, "gcp_identity_connectivity_status", gcp_identity_connectivity_status)
        if gcp_location is not None:
            pulumi.set(__self__, "gcp_location", gcp_location)
        if gcp_nodes is not None:
            pulumi.set(__self__, "gcp_nodes", gcp_nodes)
        if gcp_resource_service_agent_id is not None:
            pulumi.set(__self__, "gcp_resource_service_agent_id", gcp_resource_service_agent_id)
        if gcp_workload_identity_pool_id is not None:
            pulumi.set(__self__, "gcp_workload_identity_pool_id", gcp_workload_identity_pool_id)
        if gcp_workload_identity_provider_id is not None:
            pulumi.set(__self__, "gcp_workload_identity_provider_id", gcp_workload_identity_provider_id)
        if issuer_url is not None:
            pulumi.set(__self__, "issuer_url", issuer_url)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle DB Google GCP Identity Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="gcpIdentityConnectivityStatus")
    def gcp_identity_connectivity_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current Connectivity status of GCP Identity Connector resource.
        """
        return pulumi.get(self, "gcp_identity_connectivity_status")

    @gcp_identity_connectivity_status.setter
    def gcp_identity_connectivity_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_identity_connectivity_status", value)

    @_builtins.property
    @pulumi.getter(name="gcpLocation")
    def gcp_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) GCP Location.
        """
        return pulumi.get(self, "gcp_location")

    @gcp_location.setter
    def gcp_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_location", value)

    @_builtins.property
    @pulumi.getter(name="gcpNodes")
    def gcp_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs']]]]:
        """
        List of All VMs where GCP Identity Connector is configured for this VMCluster.
        """
        return pulumi.get(self, "gcp_nodes")

    @gcp_nodes.setter
    def gcp_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs']]]]):
        pulumi.set(self, "gcp_nodes", value)

    @_builtins.property
    @pulumi.getter(name="gcpResourceServiceAgentId")
    def gcp_resource_service_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The ID of the GCP resource service agent.
        """
        return pulumi.get(self, "gcp_resource_service_agent_id")

    @gcp_resource_service_agent_id.setter
    def gcp_resource_service_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_resource_service_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityPoolId")
    def gcp_workload_identity_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The ID of the cloud GCP Workload Identity Pool.
        """
        return pulumi.get(self, "gcp_workload_identity_pool_id")

    @gcp_workload_identity_pool_id.setter
    def gcp_workload_identity_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_workload_identity_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityProviderId")
    def gcp_workload_identity_provider_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The ID of the GCP Workload Identity Provider.
        """
        return pulumi.get(self, "gcp_workload_identity_provider_id")

    @gcp_workload_identity_provider_id.setter
    def gcp_workload_identity_provider_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_workload_identity_provider_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) OIDC token issuer Url
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Project id of the customer project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the GCP Identity Connector resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the Oracle DB GCP Identity Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the Oracle DB GCP Identity Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/dbmulticloudOracleDbGcpIdentityConnector:DbmulticloudOracleDbGcpIdentityConnector")
class DbmulticloudOracleDbGcpIdentityConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gcp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_resource_service_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_gcp_identity_connector = oci.oci.DbmulticloudOracleDbGcpIdentityConnector("test_oracle_db_gcp_identity_connector",
            compartment_id=compartment_id,
            display_name=oracle_db_gcp_identity_connector_display_name,
            gcp_location=oracle_db_gcp_identity_connector_gcp_location,
            gcp_resource_service_agent_id=test_agent["id"],
            gcp_workload_identity_pool_id=test_pool["id"],
            gcp_workload_identity_provider_id=test_identity_provider["id"],
            issuer_url=oracle_db_gcp_identity_connector_issuer_url,
            project_id=test_project["id"],
            resource_id=test_resource["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        OracleDbGcpIdentityConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbGcpIdentityConnector:DbmulticloudOracleDbGcpIdentityConnector test_oracle_db_gcp_identity_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Google GCP Identity Connector resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gcp_location: (Updatable) GCP Location.
        :param pulumi.Input[_builtins.str] gcp_resource_service_agent_id: (Updatable) The ID of the GCP resource service agent.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_pool_id: (Updatable) The ID of the cloud GCP Workload Identity Pool.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_provider_id: (Updatable) The ID of the GCP Workload Identity Provider.
        :param pulumi.Input[_builtins.str] issuer_url: (Updatable) OIDC token issuer Url
        :param pulumi.Input[_builtins.str] project_id: (Updatable) Project id of the customer project.
        :param pulumi.Input[_builtins.str] resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbmulticloudOracleDbGcpIdentityConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_gcp_identity_connector = oci.oci.DbmulticloudOracleDbGcpIdentityConnector("test_oracle_db_gcp_identity_connector",
            compartment_id=compartment_id,
            display_name=oracle_db_gcp_identity_connector_display_name,
            gcp_location=oracle_db_gcp_identity_connector_gcp_location,
            gcp_resource_service_agent_id=test_agent["id"],
            gcp_workload_identity_pool_id=test_pool["id"],
            gcp_workload_identity_provider_id=test_identity_provider["id"],
            issuer_url=oracle_db_gcp_identity_connector_issuer_url,
            project_id=test_project["id"],
            resource_id=test_resource["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        OracleDbGcpIdentityConnectors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbGcpIdentityConnector:DbmulticloudOracleDbGcpIdentityConnector test_oracle_db_gcp_identity_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbmulticloudOracleDbGcpIdentityConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbmulticloudOracleDbGcpIdentityConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gcp_location: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_resource_service_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_workload_identity_provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbmulticloudOracleDbGcpIdentityConnectorArgs.__new__(DbmulticloudOracleDbGcpIdentityConnectorArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if gcp_location is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_location'")
            __props__.__dict__["gcp_location"] = gcp_location
            if gcp_resource_service_agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_resource_service_agent_id'")
            __props__.__dict__["gcp_resource_service_agent_id"] = gcp_resource_service_agent_id
            if gcp_workload_identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_workload_identity_pool_id'")
            __props__.__dict__["gcp_workload_identity_pool_id"] = gcp_workload_identity_pool_id
            if gcp_workload_identity_provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_workload_identity_provider_id'")
            __props__.__dict__["gcp_workload_identity_provider_id"] = gcp_workload_identity_provider_id
            if issuer_url is None and not opts.urn:
                raise TypeError("Missing required property 'issuer_url'")
            __props__.__dict__["issuer_url"] = issuer_url
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["gcp_identity_connectivity_status"] = None
            __props__.__dict__["gcp_nodes"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbmulticloudOracleDbGcpIdentityConnector, __self__).__init__(
            'oci:oci/dbmulticloudOracleDbGcpIdentityConnector:DbmulticloudOracleDbGcpIdentityConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gcp_identity_connectivity_status: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_location: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs', 'DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgsDict']]]]] = None,
            gcp_resource_service_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_workload_identity_provider_id: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_state_details: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbmulticloudOracleDbGcpIdentityConnector':
        """
        Get an existing DbmulticloudOracleDbGcpIdentityConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Oracle DB Google GCP Identity Connector resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gcp_identity_connectivity_status: The current Connectivity status of GCP Identity Connector resource.
        :param pulumi.Input[_builtins.str] gcp_location: (Updatable) GCP Location.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgs', 'DbmulticloudOracleDbGcpIdentityConnectorGcpNodeArgsDict']]]] gcp_nodes: List of All VMs where GCP Identity Connector is configured for this VMCluster.
        :param pulumi.Input[_builtins.str] gcp_resource_service_agent_id: (Updatable) The ID of the GCP resource service agent.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_pool_id: (Updatable) The ID of the cloud GCP Workload Identity Pool.
        :param pulumi.Input[_builtins.str] gcp_workload_identity_provider_id: (Updatable) The ID of the GCP Workload Identity Provider.
        :param pulumi.Input[_builtins.str] issuer_url: (Updatable) OIDC token issuer Url
        :param pulumi.Input[_builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[_builtins.str] project_id: (Updatable) Project id of the customer project.
        :param pulumi.Input[_builtins.str] resource_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the GCP Identity Connector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Time when the Oracle DB GCP Identity Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[_builtins.str] time_updated: Time when the Oracle DB GCP Identity Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbmulticloudOracleDbGcpIdentityConnectorState.__new__(_DbmulticloudOracleDbGcpIdentityConnectorState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gcp_identity_connectivity_status"] = gcp_identity_connectivity_status
        __props__.__dict__["gcp_location"] = gcp_location
        __props__.__dict__["gcp_nodes"] = gcp_nodes
        __props__.__dict__["gcp_resource_service_agent_id"] = gcp_resource_service_agent_id
        __props__.__dict__["gcp_workload_identity_pool_id"] = gcp_workload_identity_pool_id
        __props__.__dict__["gcp_workload_identity_provider_id"] = gcp_workload_identity_provider_id
        __props__.__dict__["issuer_url"] = issuer_url
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DbmulticloudOracleDbGcpIdentityConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Oracle DB GCP Identity Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle DB Google GCP Identity Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gcpIdentityConnectivityStatus")
    def gcp_identity_connectivity_status(self) -> pulumi.Output[_builtins.str]:
        """
        The current Connectivity status of GCP Identity Connector resource.
        """
        return pulumi.get(self, "gcp_identity_connectivity_status")

    @_builtins.property
    @pulumi.getter(name="gcpLocation")
    def gcp_location(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) GCP Location.
        """
        return pulumi.get(self, "gcp_location")

    @_builtins.property
    @pulumi.getter(name="gcpNodes")
    def gcp_nodes(self) -> pulumi.Output[Sequence['outputs.DbmulticloudOracleDbGcpIdentityConnectorGcpNode']]:
        """
        List of All VMs where GCP Identity Connector is configured for this VMCluster.
        """
        return pulumi.get(self, "gcp_nodes")

    @_builtins.property
    @pulumi.getter(name="gcpResourceServiceAgentId")
    def gcp_resource_service_agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The ID of the GCP resource service agent.
        """
        return pulumi.get(self, "gcp_resource_service_agent_id")

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityPoolId")
    def gcp_workload_identity_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The ID of the cloud GCP Workload Identity Pool.
        """
        return pulumi.get(self, "gcp_workload_identity_pool_id")

    @_builtins.property
    @pulumi.getter(name="gcpWorkloadIdentityProviderId")
    def gcp_workload_identity_provider_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The ID of the GCP Workload Identity Provider.
        """
        return pulumi.get(self, "gcp_workload_identity_provider_id")

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) OIDC token issuer Url
        """
        return pulumi.get(self, "issuer_url")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Project id of the customer project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GCP VM Cluster resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the GCP Identity Connector resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the Oracle DB GCP Identity Connector resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the Oracle DB GCP Identity Connector resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

