# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DifStackArgs', 'DifStack']

@pulumi.input_type
class DifStackArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 stack_templates: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 adbs: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]] = None,
                 add_service_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 dataflows: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deploy_artifacts_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 genais: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]] = None,
                 ggcs: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorages: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DifStack resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: (Updatable) List of services to be onboarded for the stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] stack_templates: (Updatable) List of templates to be onboarded for the stack.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]] adbs: (Updatable) ADB details if adb is included in the services.
        :param pulumi.Input[_builtins.int] add_service_trigger: (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]] dataflows: (Updatable) DATAFLOW details if dataflow is included in the services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] deploy_artifacts_trigger: (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.
               
               
               ** IMPORTANT **
               - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
               - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
               - Add service (increase add_service_trigger)
               - Deploy artifacts (increase deploy_artifacts_trigger)
               - Change compartment (update compartment_id)
               - Standard update (all other updatable fields such as tags, service block parameters, etc.)
               Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
               - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]] genais: (Updatable) GenAi Details if genai is included in services.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]] ggcs: (Updatable) GGCS details if ggcs is included in the services.
        :param pulumi.Input[_builtins.str] notification_email: email id to which the stack notifications would be sent.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]] objectstorages: (Updatable) Object Storage Details if object storage is included in services.
        :param pulumi.Input[_builtins.str] subnet_id: (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "stack_templates", stack_templates)
        if adbs is not None:
            pulumi.set(__self__, "adbs", adbs)
        if add_service_trigger is not None:
            pulumi.set(__self__, "add_service_trigger", add_service_trigger)
        if dataflows is not None:
            pulumi.set(__self__, "dataflows", dataflows)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifacts_trigger is not None:
            pulumi.set(__self__, "deploy_artifacts_trigger", deploy_artifacts_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if genais is not None:
            pulumi.set(__self__, "genais", genais)
        if ggcs is not None:
            pulumi.set(__self__, "ggcs", ggcs)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if objectstorages is not None:
            pulumi.set(__self__, "objectstorages", objectstorages)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) List of services to be onboarded for the stack.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="stackTemplates")
    def stack_templates(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) List of templates to be onboarded for the stack.
        """
        return pulumi.get(self, "stack_templates")

    @stack_templates.setter
    def stack_templates(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "stack_templates", value)

    @_builtins.property
    @pulumi.getter
    def adbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]]:
        """
        (Updatable) ADB details if adb is included in the services.
        """
        return pulumi.get(self, "adbs")

    @adbs.setter
    def adbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]]):
        pulumi.set(self, "adbs", value)

    @_builtins.property
    @pulumi.getter(name="addServiceTrigger")
    def add_service_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        """
        return pulumi.get(self, "add_service_trigger")

    @add_service_trigger.setter
    def add_service_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "add_service_trigger", value)

    @_builtins.property
    @pulumi.getter
    def dataflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]]:
        """
        (Updatable) DATAFLOW details if dataflow is included in the services.
        """
        return pulumi.get(self, "dataflows")

    @dataflows.setter
    def dataflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]]):
        pulumi.set(self, "dataflows", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="deployArtifactsTrigger")
    def deploy_artifacts_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.


        ** IMPORTANT **
        - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
        - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
        - Add service (increase add_service_trigger)
        - Deploy artifacts (increase deploy_artifacts_trigger)
        - Change compartment (update compartment_id)
        - Standard update (all other updatable fields such as tags, service block parameters, etc.)
        Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
        - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        """
        return pulumi.get(self, "deploy_artifacts_trigger")

    @deploy_artifacts_trigger.setter
    def deploy_artifacts_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deploy_artifacts_trigger", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def genais(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]]:
        """
        (Updatable) GenAi Details if genai is included in services.
        """
        return pulumi.get(self, "genais")

    @genais.setter
    def genais(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]]):
        pulumi.set(self, "genais", value)

    @_builtins.property
    @pulumi.getter
    def ggcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]]:
        """
        (Updatable) GGCS details if ggcs is included in the services.
        """
        return pulumi.get(self, "ggcs")

    @ggcs.setter
    def ggcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]]):
        pulumi.set(self, "ggcs", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        email id to which the stack notifications would be sent.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter
    def objectstorages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]]:
        """
        (Updatable) Object Storage Details if object storage is included in services.
        """
        return pulumi.get(self, "objectstorages")

    @objectstorages.setter
    def objectstorages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]]):
        pulumi.set(self, "objectstorages", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _DifStackState:
    def __init__(__self__, *,
                 adbs: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]] = None,
                 add_service_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataflows: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deploy_artifacts_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 genais: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]] = None,
                 ggcs: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorages: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]] = None,
                 service_details: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackServiceDetailArgs']]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_templates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DifStack resources.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]] adbs: (Updatable) ADB details if adb is included in the services.
        :param pulumi.Input[_builtins.int] add_service_trigger: (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]] dataflows: (Updatable) DATAFLOW details if dataflow is included in the services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] deploy_artifacts_trigger: (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.
               
               
               ** IMPORTANT **
               - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
               - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
               - Add service (increase add_service_trigger)
               - Deploy artifacts (increase deploy_artifacts_trigger)
               - Change compartment (update compartment_id)
               - Standard update (all other updatable fields such as tags, service block parameters, etc.)
               Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
               - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]] genais: (Updatable) GenAi Details if genai is included in services.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]] ggcs: (Updatable) GGCS details if ggcs is included in the services.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the Stack in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] notification_email: email id to which the stack notifications would be sent.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]] objectstorages: (Updatable) Object Storage Details if object storage is included in services.
        :param pulumi.Input[Sequence[pulumi.Input['DifStackServiceDetailArgs']]] service_details: Details of the service onboarded for the data intelligence stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: (Updatable) List of services to be onboarded for the stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] stack_templates: (Updatable) List of templates to be onboarded for the stack.
        :param pulumi.Input[_builtins.str] state: The current state of the Stack.
        :param pulumi.Input[_builtins.str] subnet_id: (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Stack was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Stack was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if adbs is not None:
            pulumi.set(__self__, "adbs", adbs)
        if add_service_trigger is not None:
            pulumi.set(__self__, "add_service_trigger", add_service_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if dataflows is not None:
            pulumi.set(__self__, "dataflows", dataflows)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifacts_trigger is not None:
            pulumi.set(__self__, "deploy_artifacts_trigger", deploy_artifacts_trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if genais is not None:
            pulumi.set(__self__, "genais", genais)
        if ggcs is not None:
            pulumi.set(__self__, "ggcs", ggcs)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if objectstorages is not None:
            pulumi.set(__self__, "objectstorages", objectstorages)
        if service_details is not None:
            pulumi.set(__self__, "service_details", service_details)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if stack_templates is not None:
            pulumi.set(__self__, "stack_templates", stack_templates)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def adbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]]:
        """
        (Updatable) ADB details if adb is included in the services.
        """
        return pulumi.get(self, "adbs")

    @adbs.setter
    def adbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackAdbArgs']]]]):
        pulumi.set(self, "adbs", value)

    @_builtins.property
    @pulumi.getter(name="addServiceTrigger")
    def add_service_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        """
        return pulumi.get(self, "add_service_trigger")

    @add_service_trigger.setter
    def add_service_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "add_service_trigger", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def dataflows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]]:
        """
        (Updatable) DATAFLOW details if dataflow is included in the services.
        """
        return pulumi.get(self, "dataflows")

    @dataflows.setter
    def dataflows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackDataflowArgs']]]]):
        pulumi.set(self, "dataflows", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="deployArtifactsTrigger")
    def deploy_artifacts_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.


        ** IMPORTANT **
        - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
        - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
        - Add service (increase add_service_trigger)
        - Deploy artifacts (increase deploy_artifacts_trigger)
        - Change compartment (update compartment_id)
        - Standard update (all other updatable fields such as tags, service block parameters, etc.)
        Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
        - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        """
        return pulumi.get(self, "deploy_artifacts_trigger")

    @deploy_artifacts_trigger.setter
    def deploy_artifacts_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deploy_artifacts_trigger", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def genais(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]]:
        """
        (Updatable) GenAi Details if genai is included in services.
        """
        return pulumi.get(self, "genais")

    @genais.setter
    def genais(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGenaiArgs']]]]):
        pulumi.set(self, "genais", value)

    @_builtins.property
    @pulumi.getter
    def ggcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]]:
        """
        (Updatable) GGCS details if ggcs is included in the services.
        """
        return pulumi.get(self, "ggcs")

    @ggcs.setter
    def ggcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackGgcArgs']]]]):
        pulumi.set(self, "ggcs", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the Stack in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        email id to which the stack notifications would be sent.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter
    def objectstorages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]]:
        """
        (Updatable) Object Storage Details if object storage is included in services.
        """
        return pulumi.get(self, "objectstorages")

    @objectstorages.setter
    def objectstorages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackObjectstorageArgs']]]]):
        pulumi.set(self, "objectstorages", value)

    @_builtins.property
    @pulumi.getter(name="serviceDetails")
    def service_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DifStackServiceDetailArgs']]]]:
        """
        Details of the service onboarded for the data intelligence stack.
        """
        return pulumi.get(self, "service_details")

    @service_details.setter
    def service_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DifStackServiceDetailArgs']]]]):
        pulumi.set(self, "service_details", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of services to be onboarded for the stack.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="stackTemplates")
    def stack_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of templates to be onboarded for the stack.
        """
        return pulumi.get(self, "stack_templates")

    @stack_templates.setter
    def stack_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "stack_templates", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Stack.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Stack was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Stack was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/difStack:DifStack")
class DifStack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackAdbArgs', 'DifStackAdbArgsDict']]]]] = None,
                 add_service_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackDataflowArgs', 'DifStackDataflowArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deploy_artifacts_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 genais: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGenaiArgs', 'DifStackGenaiArgsDict']]]]] = None,
                 ggcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGgcArgs', 'DifStackGgcArgsDict']]]]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackObjectstorageArgs', 'DifStackObjectstorageArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_templates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Stack resource in Oracle Cloud Infrastructure Dif service.

        Creates a Stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stack = oci.oci.DifStack("test_stack",
            compartment_id=compartment_id,
            display_name=stack_display_name,
            services=stack_services,
            stack_templates=stack_stack_templates,
            adbs=[{
                "admin_password_id": test_admin_password["id"],
                "data_storage_size_in_tbs": stack_adb_data_storage_size_in_tbs,
                "db_version": stack_adb_db_version,
                "db_workload": stack_adb_db_workload,
                "ecpu": stack_adb_ecpu,
                "instance_id": stack_adb_instance_id,
                "is_mtls_connection_required": stack_adb_is_mtls_connection_required,
                "is_public": stack_adb_is_public,
                "subnet_id": test_subnet["id"],
                "tools_public_access": stack_adb_tools_public_access,
                "artifact_object_storage_path": stack_adb_artifact_object_storage_path,
                "db_credentials": [{
                    "user_name": stack_adb_db_credentials_user_name,
                    "secret_id": stack_adb_db_credentials_secret_id,
                    "user_type": stack_adb_db_credentials_user_type,
                }],
            }],
            dataflows=[{
                "driver_shape": stack_dataflow_driver_shape,
                "executor_shape": stack_dataflow_executor_shape,
                "instance_id": stack_dataflow_instance_id,
                "log_bucket_instance_id": stack_objectstorage_instance_id,
                "num_executors": stack_dataflow_num_executors,
                "spark_version": stack_dataflow_spark_version,
                "connections": {
                    "connection_details": {
                        "dif_dependencies": [{
                            "service_instance_id": stack_dependency_instance_id,
                            "service_type": stack_dataflow_connections_connection_details_dif_dependencies_service_type,
                        }],
                        "domain_names": stack_dataflow_connections_connection_details_domain_names,
                    },
                    "subnet_id": test_subnet["id"],
                },
                "driver_shape_config": {
                    "memory_in_gbs": stack_dataflow_driver_shape_config_memory_in_gbs,
                    "ocpus": stack_dataflow_driver_shape_config_ocpus,
                },
                "executor_shape_config": {
                    "memory_in_gbs": stack_dataflow_executor_shape_config_memory_in_gbs,
                    "ocpus": stack_dataflow_executor_shape_config_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
                "warehouse_bucket_instance_id": stack_objectstorage_instance_id,
                "execute": stack_dataflow_execute,
                "archive_uri": stack_dataflow_archive_uri,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            genais=[{
                "base_model": stack_genai_base_model,
                "cluster_type": stack_genai_cluster_type,
                "instance_id": stack_genai_instance_id,
                "oci_region": stack_genai_oci_region,
                "unit_count": stack_genai_unit_count,
                "endpoints": [{
                    "endpoint_name": stack_genai_endpoint_name,
                    "is_content_moderation_enabled": stack_genai_endpoints_is_content_moderation_enabled,
                }],
            }],
            ggcs=[{
                "instance_id": stack_ggcs_instance_id,
                "ocpu": stack_ggcs_ocpu,
                "password_secret_id": test_secret["id"],
                "subnet_id": test_subnet["id"],
                "connections": [{
                    "connection_name": test_connection["name"],
                    "connection_id": test_connection["id"],
                    "dif_dependencies": [{
                        "service_instance_id": stack_dependency_instance_id,
                        "service_type": stack_ggcs_connections_dif_dependencies_service_type,
                    }],
                    "gg_admin_secret_id": test_secret["id"],
                }],
                "ogg_version": stack_ggcs_ogg_version,
                "public_subnet_id": test_subnet["id"],
                "artifact_object_storage_path": stack_ggcs_artifact_object_storage_path,
                "users": [{
                    "user_name": stack_ggcs_users_user_name,
                    "secret_id": stack_ggcs_users_secret_id,
                    "user_type": stack_ggcs_users_user_type,
                    "action": stack_ggcs_users_action,
                }],
                "sources": [{
                    "source_id": stack_ggcs_sources_source_id,
                    "action": stack_ggcs_sources_action,
                    "should_start_source_operations": stack_ggcs_sources_should_start_source_operations,
                    "target_uri": stack_ggcs_sources_target_uri,
                    "target_connection_name": stack_ggcs_sources_target_connection_name,
                }],
                "targets": [{
                    "target_id": stack_ggcs_target_id,
                    "action": stack_ggcs_action,
                    "should_start_target_operations": stack_ggcs_should_start_target_operations,
                    "source_uri": stack_ggcs_source_uri,
                    "source_connection_name": stack_ggcs_source_connection_name,
                }],
            }],
            notification_email=stack_notification_email,
            objectstorages=[{
                "instance_id": stack_objectstorage_instance_id,
                "object_versioning": stack_objectstorage_object_versioning,
                "storage_tier": stack_objectstorage_storage_tier,
                "auto_tiering": stack_objectstorage_auto_tiering,
            }],
            subnet_id=stack_deploy_artifacts_subnet_id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackAdbArgs', 'DifStackAdbArgsDict']]]] adbs: (Updatable) ADB details if adb is included in the services.
        :param pulumi.Input[_builtins.int] add_service_trigger: (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackDataflowArgs', 'DifStackDataflowArgsDict']]]] dataflows: (Updatable) DATAFLOW details if dataflow is included in the services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] deploy_artifacts_trigger: (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.
               
               
               ** IMPORTANT **
               - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
               - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
               - Add service (increase add_service_trigger)
               - Deploy artifacts (increase deploy_artifacts_trigger)
               - Change compartment (update compartment_id)
               - Standard update (all other updatable fields such as tags, service block parameters, etc.)
               Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
               - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackGenaiArgs', 'DifStackGenaiArgsDict']]]] genais: (Updatable) GenAi Details if genai is included in services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackGgcArgs', 'DifStackGgcArgsDict']]]] ggcs: (Updatable) GGCS details if ggcs is included in the services.
        :param pulumi.Input[_builtins.str] notification_email: email id to which the stack notifications would be sent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackObjectstorageArgs', 'DifStackObjectstorageArgsDict']]]] objectstorages: (Updatable) Object Storage Details if object storage is included in services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: (Updatable) List of services to be onboarded for the stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] stack_templates: (Updatable) List of templates to be onboarded for the stack.
        :param pulumi.Input[_builtins.str] subnet_id: (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DifStackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Stack resource in Oracle Cloud Infrastructure Dif service.

        Creates a Stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stack = oci.oci.DifStack("test_stack",
            compartment_id=compartment_id,
            display_name=stack_display_name,
            services=stack_services,
            stack_templates=stack_stack_templates,
            adbs=[{
                "admin_password_id": test_admin_password["id"],
                "data_storage_size_in_tbs": stack_adb_data_storage_size_in_tbs,
                "db_version": stack_adb_db_version,
                "db_workload": stack_adb_db_workload,
                "ecpu": stack_adb_ecpu,
                "instance_id": stack_adb_instance_id,
                "is_mtls_connection_required": stack_adb_is_mtls_connection_required,
                "is_public": stack_adb_is_public,
                "subnet_id": test_subnet["id"],
                "tools_public_access": stack_adb_tools_public_access,
                "artifact_object_storage_path": stack_adb_artifact_object_storage_path,
                "db_credentials": [{
                    "user_name": stack_adb_db_credentials_user_name,
                    "secret_id": stack_adb_db_credentials_secret_id,
                    "user_type": stack_adb_db_credentials_user_type,
                }],
            }],
            dataflows=[{
                "driver_shape": stack_dataflow_driver_shape,
                "executor_shape": stack_dataflow_executor_shape,
                "instance_id": stack_dataflow_instance_id,
                "log_bucket_instance_id": stack_objectstorage_instance_id,
                "num_executors": stack_dataflow_num_executors,
                "spark_version": stack_dataflow_spark_version,
                "connections": {
                    "connection_details": {
                        "dif_dependencies": [{
                            "service_instance_id": stack_dependency_instance_id,
                            "service_type": stack_dataflow_connections_connection_details_dif_dependencies_service_type,
                        }],
                        "domain_names": stack_dataflow_connections_connection_details_domain_names,
                    },
                    "subnet_id": test_subnet["id"],
                },
                "driver_shape_config": {
                    "memory_in_gbs": stack_dataflow_driver_shape_config_memory_in_gbs,
                    "ocpus": stack_dataflow_driver_shape_config_ocpus,
                },
                "executor_shape_config": {
                    "memory_in_gbs": stack_dataflow_executor_shape_config_memory_in_gbs,
                    "ocpus": stack_dataflow_executor_shape_config_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
                "warehouse_bucket_instance_id": stack_objectstorage_instance_id,
                "execute": stack_dataflow_execute,
                "archive_uri": stack_dataflow_archive_uri,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            genais=[{
                "base_model": stack_genai_base_model,
                "cluster_type": stack_genai_cluster_type,
                "instance_id": stack_genai_instance_id,
                "oci_region": stack_genai_oci_region,
                "unit_count": stack_genai_unit_count,
                "endpoints": [{
                    "endpoint_name": stack_genai_endpoint_name,
                    "is_content_moderation_enabled": stack_genai_endpoints_is_content_moderation_enabled,
                }],
            }],
            ggcs=[{
                "instance_id": stack_ggcs_instance_id,
                "ocpu": stack_ggcs_ocpu,
                "password_secret_id": test_secret["id"],
                "subnet_id": test_subnet["id"],
                "connections": [{
                    "connection_name": test_connection["name"],
                    "connection_id": test_connection["id"],
                    "dif_dependencies": [{
                        "service_instance_id": stack_dependency_instance_id,
                        "service_type": stack_ggcs_connections_dif_dependencies_service_type,
                    }],
                    "gg_admin_secret_id": test_secret["id"],
                }],
                "ogg_version": stack_ggcs_ogg_version,
                "public_subnet_id": test_subnet["id"],
                "artifact_object_storage_path": stack_ggcs_artifact_object_storage_path,
                "users": [{
                    "user_name": stack_ggcs_users_user_name,
                    "secret_id": stack_ggcs_users_secret_id,
                    "user_type": stack_ggcs_users_user_type,
                    "action": stack_ggcs_users_action,
                }],
                "sources": [{
                    "source_id": stack_ggcs_sources_source_id,
                    "action": stack_ggcs_sources_action,
                    "should_start_source_operations": stack_ggcs_sources_should_start_source_operations,
                    "target_uri": stack_ggcs_sources_target_uri,
                    "target_connection_name": stack_ggcs_sources_target_connection_name,
                }],
                "targets": [{
                    "target_id": stack_ggcs_target_id,
                    "action": stack_ggcs_action,
                    "should_start_target_operations": stack_ggcs_should_start_target_operations,
                    "source_uri": stack_ggcs_source_uri,
                    "source_connection_name": stack_ggcs_source_connection_name,
                }],
            }],
            notification_email=stack_notification_email,
            objectstorages=[{
                "instance_id": stack_objectstorage_instance_id,
                "object_versioning": stack_objectstorage_object_versioning,
                "storage_tier": stack_objectstorage_storage_tier,
                "auto_tiering": stack_objectstorage_auto_tiering,
            }],
            subnet_id=stack_deploy_artifacts_subnet_id)
        ```

        :param str resource_name: The name of the resource.
        :param DifStackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DifStackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackAdbArgs', 'DifStackAdbArgsDict']]]]] = None,
                 add_service_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackDataflowArgs', 'DifStackDataflowArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deploy_artifacts_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 genais: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGenaiArgs', 'DifStackGenaiArgsDict']]]]] = None,
                 ggcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGgcArgs', 'DifStackGgcArgsDict']]]]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackObjectstorageArgs', 'DifStackObjectstorageArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_templates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DifStackArgs.__new__(DifStackArgs)

            __props__.__dict__["adbs"] = adbs
            __props__.__dict__["add_service_trigger"] = add_service_trigger
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["dataflows"] = dataflows
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deploy_artifacts_trigger"] = deploy_artifacts_trigger
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["genais"] = genais
            __props__.__dict__["ggcs"] = ggcs
            __props__.__dict__["notification_email"] = notification_email
            __props__.__dict__["objectstorages"] = objectstorages
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            if stack_templates is None and not opts.urn:
                raise TypeError("Missing required property 'stack_templates'")
            __props__.__dict__["stack_templates"] = stack_templates
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["service_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DifStack, __self__).__init__(
            'oci:oci/difStack:DifStack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackAdbArgs', 'DifStackAdbArgsDict']]]]] = None,
            add_service_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            dataflows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackDataflowArgs', 'DifStackDataflowArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            deploy_artifacts_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            genais: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGenaiArgs', 'DifStackGenaiArgsDict']]]]] = None,
            ggcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackGgcArgs', 'DifStackGgcArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            notification_email: Optional[pulumi.Input[_builtins.str]] = None,
            objectstorages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackObjectstorageArgs', 'DifStackObjectstorageArgsDict']]]]] = None,
            service_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DifStackServiceDetailArgs', 'DifStackServiceDetailArgsDict']]]]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            stack_templates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DifStack':
        """
        Get an existing DifStack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackAdbArgs', 'DifStackAdbArgsDict']]]] adbs: (Updatable) ADB details if adb is included in the services.
        :param pulumi.Input[_builtins.int] add_service_trigger: (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackDataflowArgs', 'DifStackDataflowArgsDict']]]] dataflows: (Updatable) DATAFLOW details if dataflow is included in the services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.int] deploy_artifacts_trigger: (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.
               
               
               ** IMPORTANT **
               - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
               - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
               - Add service (increase add_service_trigger)
               - Deploy artifacts (increase deploy_artifacts_trigger)
               - Change compartment (update compartment_id)
               - Standard update (all other updatable fields such as tags, service block parameters, etc.)
               Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
               - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackGenaiArgs', 'DifStackGenaiArgsDict']]]] genais: (Updatable) GenAi Details if genai is included in services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackGgcArgs', 'DifStackGgcArgsDict']]]] ggcs: (Updatable) GGCS details if ggcs is included in the services.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the Stack in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] notification_email: email id to which the stack notifications would be sent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackObjectstorageArgs', 'DifStackObjectstorageArgsDict']]]] objectstorages: (Updatable) Object Storage Details if object storage is included in services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DifStackServiceDetailArgs', 'DifStackServiceDetailArgsDict']]]] service_details: Details of the service onboarded for the data intelligence stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: (Updatable) List of services to be onboarded for the stack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] stack_templates: (Updatable) List of templates to be onboarded for the stack.
        :param pulumi.Input[_builtins.str] state: The current state of the Stack.
        :param pulumi.Input[_builtins.str] subnet_id: (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Stack was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Stack was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DifStackState.__new__(_DifStackState)

        __props__.__dict__["adbs"] = adbs
        __props__.__dict__["add_service_trigger"] = add_service_trigger
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["dataflows"] = dataflows
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deploy_artifacts_trigger"] = deploy_artifacts_trigger
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["genais"] = genais
        __props__.__dict__["ggcs"] = ggcs
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notification_email"] = notification_email
        __props__.__dict__["objectstorages"] = objectstorages
        __props__.__dict__["service_details"] = service_details
        __props__.__dict__["services"] = services
        __props__.__dict__["stack_templates"] = stack_templates
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DifStack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def adbs(self) -> pulumi.Output[Optional[Sequence['outputs.DifStackAdb']]]:
        """
        (Updatable) ADB details if adb is included in the services.
        """
        return pulumi.get(self, "adbs")

    @_builtins.property
    @pulumi.getter(name="addServiceTrigger")
    def add_service_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Add Service. Could be set to any integer value.
        """
        return pulumi.get(self, "add_service_trigger")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the Stack in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def dataflows(self) -> pulumi.Output[Optional[Sequence['outputs.DifStackDataflow']]]:
        """
        (Updatable) DATAFLOW details if dataflow is included in the services.
        """
        return pulumi.get(self, "dataflows")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deployArtifactsTrigger")
    def deploy_artifacts_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Deploy Artifacts. Could be set to any integer value.


        ** IMPORTANT **
        - Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values.
        - Single-operation per apply: exactly one of the following is allowed in a single pulumi up:
        - Add service (increase add_service_trigger)
        - Deploy artifacts (increase deploy_artifacts_trigger)
        - Change compartment (update compartment_id)
        - Standard update (all other updatable fields such as tags, service block parameters, etc.)
        Mixing any two or more in the same plan/apply is not allowed and will result in a provider error. Split your changes across separate applies.
        - Additions to services/templates or service blocks require increasing add_service_trigger. Deletions are not permitted.
        """
        return pulumi.get(self, "deploy_artifacts_trigger")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Should be unique per compartment. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def genais(self) -> pulumi.Output[Optional[Sequence['outputs.DifStackGenai']]]:
        """
        (Updatable) GenAi Details if genai is included in services.
        """
        return pulumi.get(self, "genais")

    @_builtins.property
    @pulumi.getter
    def ggcs(self) -> pulumi.Output[Optional[Sequence['outputs.DifStackGgc']]]:
        """
        (Updatable) GGCS details if ggcs is included in the services.
        """
        return pulumi.get(self, "ggcs")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the Stack in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        email id to which the stack notifications would be sent.
        """
        return pulumi.get(self, "notification_email")

    @_builtins.property
    @pulumi.getter
    def objectstorages(self) -> pulumi.Output[Optional[Sequence['outputs.DifStackObjectstorage']]]:
        """
        (Updatable) Object Storage Details if object storage is included in services.
        """
        return pulumi.get(self, "objectstorages")

    @_builtins.property
    @pulumi.getter(name="serviceDetails")
    def service_details(self) -> pulumi.Output[Sequence['outputs.DifStackServiceDetail']]:
        """
        Details of the service onboarded for the data intelligence stack.
        """
        return pulumi.get(self, "service_details")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of services to be onboarded for the stack.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="stackTemplates")
    def stack_templates(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of templates to be onboarded for the stack.
        """
        return pulumi.get(self, "stack_templates")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Stack.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) Subnet id for the Private Endpoint creation for artifact deployment.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Stack was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Stack was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

