# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAiDataPlatformAiDataPlatformResult',
    'AwaitableGetAiDataPlatformAiDataPlatformResult',
    'get_ai_data_platform_ai_data_platform',
    'get_ai_data_platform_ai_data_platform_output',
]

@pulumi.output_type
class GetAiDataPlatformAiDataPlatformResult:
    """
    A collection of values returned by getAiDataPlatformAiDataPlatform.
    """
    def __init__(__self__, ai_data_platform_id=None, ai_data_platform_type=None, alias_key=None, compartment_id=None, created_by=None, default_workspace_name=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, state=None, system_tags=None, time_created=None, time_updated=None, web_socket_endpoint=None):
        if ai_data_platform_id and not isinstance(ai_data_platform_id, str):
            raise TypeError("Expected argument 'ai_data_platform_id' to be a str")
        pulumi.set(__self__, "ai_data_platform_id", ai_data_platform_id)
        if ai_data_platform_type and not isinstance(ai_data_platform_type, str):
            raise TypeError("Expected argument 'ai_data_platform_type' to be a str")
        pulumi.set(__self__, "ai_data_platform_type", ai_data_platform_type)
        if alias_key and not isinstance(alias_key, str):
            raise TypeError("Expected argument 'alias_key' to be a str")
        pulumi.set(__self__, "alias_key", alias_key)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if default_workspace_name and not isinstance(default_workspace_name, str):
            raise TypeError("Expected argument 'default_workspace_name' to be a str")
        pulumi.set(__self__, "default_workspace_name", default_workspace_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if web_socket_endpoint and not isinstance(web_socket_endpoint, str):
            raise TypeError("Expected argument 'web_socket_endpoint' to be a str")
        pulumi.set(__self__, "web_socket_endpoint", web_socket_endpoint)

    @_builtins.property
    @pulumi.getter(name="aiDataPlatformId")
    def ai_data_platform_id(self) -> _builtins.str:
        return pulumi.get(self, "ai_data_platform_id")

    @_builtins.property
    @pulumi.getter(name="aiDataPlatformType")
    def ai_data_platform_type(self) -> _builtins.str:
        """
        The AiDataPlatform type.
        """
        return pulumi.get(self, "ai_data_platform_type")

    @_builtins.property
    @pulumi.getter(name="aliasKey")
    def alias_key(self) -> _builtins.str:
        """
        The alias Id of the AiDataPlatform which is the short form of OCID.
        """
        return pulumi.get(self, "alias_key")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IAM user.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="defaultWorkspaceName")
    def default_workspace_name(self) -> _builtins.str:
        return pulumi.get(self, "default_workspace_name")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the AiDataPlatform.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the AiDataPlatform in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the AiDataPlatform.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the AiDataPlatform was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the AiDataPlatform was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="webSocketEndpoint")
    def web_socket_endpoint(self) -> _builtins.str:
        """
        The WebSocket URL of the AiDataPlatform.
        """
        return pulumi.get(self, "web_socket_endpoint")


class AwaitableGetAiDataPlatformAiDataPlatformResult(GetAiDataPlatformAiDataPlatformResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiDataPlatformAiDataPlatformResult(
            ai_data_platform_id=self.ai_data_platform_id,
            ai_data_platform_type=self.ai_data_platform_type,
            alias_key=self.alias_key,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            default_workspace_name=self.default_workspace_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            web_socket_endpoint=self.web_socket_endpoint)


def get_ai_data_platform_ai_data_platform(ai_data_platform_id: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiDataPlatformAiDataPlatformResult:
    """
    This data source provides details about a specific Ai Data Platform resource in Oracle Cloud Infrastructure Ai Data Platform service.

    Gets information about a AiDataPlatform.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_data_platform = oci.oci.get_ai_data_platform_ai_data_platform(ai_data_platform_id=test_ai_data_platform_oci_ai_data_platform_ai_data_platform["id"])
    ```


    :param _builtins.str ai_data_platform_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the AiDataPlatform.
    """
    __args__ = dict()
    __args__['aiDataPlatformId'] = ai_data_platform_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getAiDataPlatformAiDataPlatform:getAiDataPlatformAiDataPlatform', __args__, opts=opts, typ=GetAiDataPlatformAiDataPlatformResult).value

    return AwaitableGetAiDataPlatformAiDataPlatformResult(
        ai_data_platform_id=pulumi.get(__ret__, 'ai_data_platform_id'),
        ai_data_platform_type=pulumi.get(__ret__, 'ai_data_platform_type'),
        alias_key=pulumi.get(__ret__, 'alias_key'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        default_workspace_name=pulumi.get(__ret__, 'default_workspace_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        web_socket_endpoint=pulumi.get(__ret__, 'web_socket_endpoint'))
def get_ai_data_platform_ai_data_platform_output(ai_data_platform_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiDataPlatformAiDataPlatformResult]:
    """
    This data source provides details about a specific Ai Data Platform resource in Oracle Cloud Infrastructure Ai Data Platform service.

    Gets information about a AiDataPlatform.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_data_platform = oci.oci.get_ai_data_platform_ai_data_platform(ai_data_platform_id=test_ai_data_platform_oci_ai_data_platform_ai_data_platform["id"])
    ```


    :param _builtins.str ai_data_platform_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the AiDataPlatform.
    """
    __args__ = dict()
    __args__['aiDataPlatformId'] = ai_data_platform_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getAiDataPlatformAiDataPlatform:getAiDataPlatformAiDataPlatform', __args__, opts=opts, typ=GetAiDataPlatformAiDataPlatformResult)
    return __ret__.apply(lambda __response__: GetAiDataPlatformAiDataPlatformResult(
        ai_data_platform_id=pulumi.get(__response__, 'ai_data_platform_id'),
        ai_data_platform_type=pulumi.get(__response__, 'ai_data_platform_type'),
        alias_key=pulumi.get(__response__, 'alias_key'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        default_workspace_name=pulumi.get(__response__, 'default_workspace_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        web_socket_endpoint=pulumi.get(__response__, 'web_socket_endpoint')))
