# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiPlatformApiPlatformInstanceResult',
    'AwaitableGetApiPlatformApiPlatformInstanceResult',
    'get_api_platform_api_platform_instance',
    'get_api_platform_api_platform_instance_output',
]

@pulumi.output_type
class GetApiPlatformApiPlatformInstanceResult:
    """
    A collection of values returned by getApiPlatformApiPlatformInstance.
    """
    def __init__(__self__, api_platform_instance_id=None, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, idcs_apps=None, lifecycle_details=None, name=None, state=None, system_tags=None, time_created=None, time_updated=None, uris=None):
        if api_platform_instance_id and not isinstance(api_platform_instance_id, str):
            raise TypeError("Expected argument 'api_platform_instance_id' to be a str")
        pulumi.set(__self__, "api_platform_instance_id", api_platform_instance_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_apps and not isinstance(idcs_apps, list):
            raise TypeError("Expected argument 'idcs_apps' to be a list")
        pulumi.set(__self__, "idcs_apps", idcs_apps)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if uris and not isinstance(uris, list):
            raise TypeError("Expected argument 'uris' to be a list")
        pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter(name="apiPlatformInstanceId")
    def api_platform_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "api_platform_instance_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        User-provided changeable and non-unique description of the instance
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idcsApps")
    def idcs_apps(self) -> Sequence['outputs.GetApiPlatformApiPlatformInstanceIdcsAppResult']:
        """
        IDCS app associated with the instance, that can be used to manage the roles of the users
        """
        return pulumi.get(self, "idcs_apps")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the instance in more detail. For example, can be used to provide actionable information for a resource in the Failed state
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A regionally unique, non-changeable instance name provided by the user during instance creation
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the instance
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence['outputs.GetApiPlatformApiPlatformInstanceUriResult']:
        """
        Service URIs pertaining to the instance
        """
        return pulumi.get(self, "uris")


class AwaitableGetApiPlatformApiPlatformInstanceResult(GetApiPlatformApiPlatformInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiPlatformApiPlatformInstanceResult(
            api_platform_instance_id=self.api_platform_instance_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            idcs_apps=self.idcs_apps,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            uris=self.uris)


def get_api_platform_api_platform_instance(api_platform_instance_id: Optional[_builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiPlatformApiPlatformInstanceResult:
    """
    This data source provides details about a specific Api Platform Instance resource in Oracle Cloud Infrastructure Api Platform service.

    Gets information about an API Platform Instance

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_platform_instance = oci.oci.get_api_platform_api_platform_instance(api_platform_instance_id=test_api_platform_instance_oci_api_platform_api_platform_instance["id"])
    ```


    :param _builtins.str api_platform_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
    """
    __args__ = dict()
    __args__['apiPlatformInstanceId'] = api_platform_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getApiPlatformApiPlatformInstance:getApiPlatformApiPlatformInstance', __args__, opts=opts, typ=GetApiPlatformApiPlatformInstanceResult).value

    return AwaitableGetApiPlatformApiPlatformInstanceResult(
        api_platform_instance_id=pulumi.get(__ret__, 'api_platform_instance_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        idcs_apps=pulumi.get(__ret__, 'idcs_apps'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        uris=pulumi.get(__ret__, 'uris'))
def get_api_platform_api_platform_instance_output(api_platform_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiPlatformApiPlatformInstanceResult]:
    """
    This data source provides details about a specific Api Platform Instance resource in Oracle Cloud Infrastructure Api Platform service.

    Gets information about an API Platform Instance

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_platform_instance = oci.oci.get_api_platform_api_platform_instance(api_platform_instance_id=test_api_platform_instance_oci_api_platform_api_platform_instance["id"])
    ```


    :param _builtins.str api_platform_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance
    """
    __args__ = dict()
    __args__['apiPlatformInstanceId'] = api_platform_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getApiPlatformApiPlatformInstance:getApiPlatformApiPlatformInstance', __args__, opts=opts, typ=GetApiPlatformApiPlatformInstanceResult)
    return __ret__.apply(lambda __response__: GetApiPlatformApiPlatformInstanceResult(
        api_platform_instance_id=pulumi.get(__response__, 'api_platform_instance_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        idcs_apps=pulumi.get(__response__, 'idcs_apps'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        uris=pulumi.get(__response__, 'uris')))
