# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDifStackResult',
    'AwaitableGetDifStackResult',
    'get_dif_stack',
    'get_dif_stack_output',
]

@pulumi.output_type
class GetDifStackResult:
    """
    A collection of values returned by getDifStack.
    """
    def __init__(__self__, adbs=None, add_service_trigger=None, compartment_id=None, dataflows=None, defined_tags=None, deploy_artifacts_trigger=None, display_name=None, freeform_tags=None, genais=None, ggcs=None, id=None, lifecycle_details=None, notification_email=None, objectstorages=None, service_details=None, services=None, stack_id=None, stack_templates=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None):
        if adbs and not isinstance(adbs, list):
            raise TypeError("Expected argument 'adbs' to be a list")
        pulumi.set(__self__, "adbs", adbs)
        if add_service_trigger and not isinstance(add_service_trigger, int):
            raise TypeError("Expected argument 'add_service_trigger' to be a int")
        pulumi.set(__self__, "add_service_trigger", add_service_trigger)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dataflows and not isinstance(dataflows, list):
            raise TypeError("Expected argument 'dataflows' to be a list")
        pulumi.set(__self__, "dataflows", dataflows)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifacts_trigger and not isinstance(deploy_artifacts_trigger, int):
            raise TypeError("Expected argument 'deploy_artifacts_trigger' to be a int")
        pulumi.set(__self__, "deploy_artifacts_trigger", deploy_artifacts_trigger)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if genais and not isinstance(genais, list):
            raise TypeError("Expected argument 'genais' to be a list")
        pulumi.set(__self__, "genais", genais)
        if ggcs and not isinstance(ggcs, list):
            raise TypeError("Expected argument 'ggcs' to be a list")
        pulumi.set(__self__, "ggcs", ggcs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notification_email and not isinstance(notification_email, str):
            raise TypeError("Expected argument 'notification_email' to be a str")
        pulumi.set(__self__, "notification_email", notification_email)
        if objectstorages and not isinstance(objectstorages, list):
            raise TypeError("Expected argument 'objectstorages' to be a list")
        pulumi.set(__self__, "objectstorages", objectstorages)
        if service_details and not isinstance(service_details, list):
            raise TypeError("Expected argument 'service_details' to be a list")
        pulumi.set(__self__, "service_details", service_details)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if stack_id and not isinstance(stack_id, str):
            raise TypeError("Expected argument 'stack_id' to be a str")
        pulumi.set(__self__, "stack_id", stack_id)
        if stack_templates and not isinstance(stack_templates, list):
            raise TypeError("Expected argument 'stack_templates' to be a list")
        pulumi.set(__self__, "stack_templates", stack_templates)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def adbs(self) -> Sequence['outputs.GetDifStackAdbResult']:
        """
        ADB details if adb is included in the services.
        """
        return pulumi.get(self, "adbs")

    @_builtins.property
    @pulumi.getter(name="addServiceTrigger")
    def add_service_trigger(self) -> _builtins.int:
        return pulumi.get(self, "add_service_trigger")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def dataflows(self) -> Sequence['outputs.GetDifStackDataflowResult']:
        """
        DATAFLOW details if dataflow is included in the services.
        """
        return pulumi.get(self, "dataflows")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deployArtifactsTrigger")
    def deploy_artifacts_trigger(self) -> _builtins.int:
        return pulumi.get(self, "deploy_artifacts_trigger")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        name of the service
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def genais(self) -> Sequence['outputs.GetDifStackGenaiResult']:
        """
        GenAI Details if genai is included in services.
        """
        return pulumi.get(self, "genais")

    @_builtins.property
    @pulumi.getter
    def ggcs(self) -> Sequence['outputs.GetDifStackGgcResult']:
        """
        GGCS details if ggcs is included in the services.
        """
        return pulumi.get(self, "ggcs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Stack.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the Stack in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> _builtins.str:
        """
        email id to which the stack notifications would be sent.
        """
        return pulumi.get(self, "notification_email")

    @_builtins.property
    @pulumi.getter
    def objectstorages(self) -> Sequence['outputs.GetDifStackObjectstorageResult']:
        """
        Object Storage Details if object storage is included in services.
        """
        return pulumi.get(self, "objectstorages")

    @_builtins.property
    @pulumi.getter(name="serviceDetails")
    def service_details(self) -> Sequence['outputs.GetDifStackServiceDetailResult']:
        """
        Details of the service onboarded for the data intelligence stack.
        """
        return pulumi.get(self, "service_details")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence[_builtins.str]:
        """
        List of services to be onboarded for the stack.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackTemplates")
    def stack_templates(self) -> Sequence[_builtins.str]:
        """
        List of templates to be onboarded for the stack.
        """
        return pulumi.get(self, "stack_templates")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Stack.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of the subnet of the GGCS deployment's private endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Stack was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Stack was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDifStackResult(GetDifStackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDifStackResult(
            adbs=self.adbs,
            add_service_trigger=self.add_service_trigger,
            compartment_id=self.compartment_id,
            dataflows=self.dataflows,
            defined_tags=self.defined_tags,
            deploy_artifacts_trigger=self.deploy_artifacts_trigger,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            genais=self.genais,
            ggcs=self.ggcs,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            notification_email=self.notification_email,
            objectstorages=self.objectstorages,
            service_details=self.service_details,
            services=self.services,
            stack_id=self.stack_id,
            stack_templates=self.stack_templates,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dif_stack(stack_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDifStackResult:
    """
    This data source provides details about a specific Stack resource in Oracle Cloud Infrastructure Dif service.

    Gets information about a Stack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stack = oci.oci.get_dif_stack(stack_id=test_stack_oci_dif_stack["id"])
    ```


    :param _builtins.str stack_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Stack.
    """
    __args__ = dict()
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDifStack:getDifStack', __args__, opts=opts, typ=GetDifStackResult).value

    return AwaitableGetDifStackResult(
        adbs=pulumi.get(__ret__, 'adbs'),
        add_service_trigger=pulumi.get(__ret__, 'add_service_trigger'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dataflows=pulumi.get(__ret__, 'dataflows'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deploy_artifacts_trigger=pulumi.get(__ret__, 'deploy_artifacts_trigger'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        genais=pulumi.get(__ret__, 'genais'),
        ggcs=pulumi.get(__ret__, 'ggcs'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        notification_email=pulumi.get(__ret__, 'notification_email'),
        objectstorages=pulumi.get(__ret__, 'objectstorages'),
        service_details=pulumi.get(__ret__, 'service_details'),
        services=pulumi.get(__ret__, 'services'),
        stack_id=pulumi.get(__ret__, 'stack_id'),
        stack_templates=pulumi.get(__ret__, 'stack_templates'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_dif_stack_output(stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDifStackResult]:
    """
    This data source provides details about a specific Stack resource in Oracle Cloud Infrastructure Dif service.

    Gets information about a Stack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stack = oci.oci.get_dif_stack(stack_id=test_stack_oci_dif_stack["id"])
    ```


    :param _builtins.str stack_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Stack.
    """
    __args__ = dict()
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDifStack:getDifStack', __args__, opts=opts, typ=GetDifStackResult)
    return __ret__.apply(lambda __response__: GetDifStackResult(
        adbs=pulumi.get(__response__, 'adbs'),
        add_service_trigger=pulumi.get(__response__, 'add_service_trigger'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dataflows=pulumi.get(__response__, 'dataflows'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        deploy_artifacts_trigger=pulumi.get(__response__, 'deploy_artifacts_trigger'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        genais=pulumi.get(__response__, 'genais'),
        ggcs=pulumi.get(__response__, 'ggcs'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        notification_email=pulumi.get(__response__, 'notification_email'),
        objectstorages=pulumi.get(__response__, 'objectstorages'),
        service_details=pulumi.get(__response__, 'service_details'),
        services=pulumi.get(__response__, 'services'),
        stack_id=pulumi.get(__response__, 'stack_id'),
        stack_templates=pulumi.get(__response__, 'stack_templates'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
