# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIotDigitalTwinInstancesResult',
    'AwaitableGetIotDigitalTwinInstancesResult',
    'get_iot_digital_twin_instances',
    'get_iot_digital_twin_instances_output',
]

@pulumi.output_type
class GetIotDigitalTwinInstancesResult:
    """
    A collection of values returned by getIotDigitalTwinInstances.
    """
    def __init__(__self__, digital_twin_instance_collections=None, digital_twin_model_id=None, digital_twin_model_spec_uri=None, display_name=None, filters=None, id=None, iot_domain_id=None, state=None):
        if digital_twin_instance_collections and not isinstance(digital_twin_instance_collections, list):
            raise TypeError("Expected argument 'digital_twin_instance_collections' to be a list")
        pulumi.set(__self__, "digital_twin_instance_collections", digital_twin_instance_collections)
        if digital_twin_model_id and not isinstance(digital_twin_model_id, str):
            raise TypeError("Expected argument 'digital_twin_model_id' to be a str")
        pulumi.set(__self__, "digital_twin_model_id", digital_twin_model_id)
        if digital_twin_model_spec_uri and not isinstance(digital_twin_model_spec_uri, str):
            raise TypeError("Expected argument 'digital_twin_model_spec_uri' to be a str")
        pulumi.set(__self__, "digital_twin_model_spec_uri", digital_twin_model_spec_uri)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_id and not isinstance(iot_domain_id, str):
            raise TypeError("Expected argument 'iot_domain_id' to be a str")
        pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="digitalTwinInstanceCollections")
    def digital_twin_instance_collections(self) -> Sequence['outputs.GetIotDigitalTwinInstancesDigitalTwinInstanceCollectionResult']:
        """
        The list of digital_twin_instance_collection.
        """
        return pulumi.get(self, "digital_twin_instance_collections")

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelId")
    def digital_twin_model_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
        """
        return pulumi.get(self, "digital_twin_model_id")

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelSpecUri")
    def digital_twin_model_spec_uri(self) -> Optional[_builtins.str]:
        """
        The URI of the digital twin model specification.
        """
        return pulumi.get(self, "digital_twin_model_spec_uri")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIotDigitalTwinInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
        """
        return pulumi.get(self, "iot_domain_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the digital twin instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetIotDigitalTwinInstancesResult(GetIotDigitalTwinInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotDigitalTwinInstancesResult(
            digital_twin_instance_collections=self.digital_twin_instance_collections,
            digital_twin_model_id=self.digital_twin_model_id,
            digital_twin_model_spec_uri=self.digital_twin_model_spec_uri,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            iot_domain_id=self.iot_domain_id,
            state=self.state)


def get_iot_digital_twin_instances(digital_twin_model_id: Optional[_builtins.str] = None,
                                   digital_twin_model_spec_uri: Optional[_builtins.str] = None,
                                   display_name: Optional[_builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetIotDigitalTwinInstancesFilterArgs', 'GetIotDigitalTwinInstancesFilterArgsDict']]] = None,
                                   id: Optional[_builtins.str] = None,
                                   iot_domain_id: Optional[_builtins.str] = None,
                                   state: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotDigitalTwinInstancesResult:
    """
    This data source provides the list of Digital Twin Instances in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin instances within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_instances = oci.oci.get_iot_digital_twin_instances(iot_domain_id=test_iot_domain["id"],
        digital_twin_model_id=test_digital_twin_model["id"],
        digital_twin_model_spec_uri=digital_twin_instance_digital_twin_model_spec_uri,
        display_name=digital_twin_instance_display_name,
        id=digital_twin_instance_id,
        state=digital_twin_instance_state)
    ```


    :param _builtins.str digital_twin_model_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
    :param _builtins.str digital_twin_model_spec_uri: Filter resources that match the specified URI (DTMI) of the digital twin model.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['digitalTwinModelId'] = digital_twin_model_id
    __args__['digitalTwinModelSpecUri'] = digital_twin_model_spec_uri
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotDigitalTwinInstances:getIotDigitalTwinInstances', __args__, opts=opts, typ=GetIotDigitalTwinInstancesResult).value

    return AwaitableGetIotDigitalTwinInstancesResult(
        digital_twin_instance_collections=pulumi.get(__ret__, 'digital_twin_instance_collections'),
        digital_twin_model_id=pulumi.get(__ret__, 'digital_twin_model_id'),
        digital_twin_model_spec_uri=pulumi.get(__ret__, 'digital_twin_model_spec_uri'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_id=pulumi.get(__ret__, 'iot_domain_id'),
        state=pulumi.get(__ret__, 'state'))
def get_iot_digital_twin_instances_output(digital_twin_model_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          digital_twin_model_spec_uri: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIotDigitalTwinInstancesFilterArgs', 'GetIotDigitalTwinInstancesFilterArgsDict']]]]] = None,
                                          id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotDigitalTwinInstancesResult]:
    """
    This data source provides the list of Digital Twin Instances in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin instances within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_instances = oci.oci.get_iot_digital_twin_instances(iot_domain_id=test_iot_domain["id"],
        digital_twin_model_id=test_digital_twin_model["id"],
        digital_twin_model_spec_uri=digital_twin_instance_digital_twin_model_spec_uri,
        display_name=digital_twin_instance_display_name,
        id=digital_twin_instance_id,
        state=digital_twin_instance_state)
    ```


    :param _builtins.str digital_twin_model_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the digital twin model.
    :param _builtins.str digital_twin_model_spec_uri: Filter resources that match the specified URI (DTMI) of the digital twin model.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['digitalTwinModelId'] = digital_twin_model_id
    __args__['digitalTwinModelSpecUri'] = digital_twin_model_spec_uri
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotDigitalTwinInstances:getIotDigitalTwinInstances', __args__, opts=opts, typ=GetIotDigitalTwinInstancesResult)
    return __ret__.apply(lambda __response__: GetIotDigitalTwinInstancesResult(
        digital_twin_instance_collections=pulumi.get(__response__, 'digital_twin_instance_collections'),
        digital_twin_model_id=pulumi.get(__response__, 'digital_twin_model_id'),
        digital_twin_model_spec_uri=pulumi.get(__response__, 'digital_twin_model_spec_uri'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_id=pulumi.get(__response__, 'iot_domain_id'),
        state=pulumi.get(__response__, 'state')))
