# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIotDigitalTwinModelsResult',
    'AwaitableGetIotDigitalTwinModelsResult',
    'get_iot_digital_twin_models',
    'get_iot_digital_twin_models_output',
]

@pulumi.output_type
class GetIotDigitalTwinModelsResult:
    """
    A collection of values returned by getIotDigitalTwinModels.
    """
    def __init__(__self__, digital_twin_model_collections=None, display_name=None, filters=None, id=None, iot_domain_id=None, spec_uri_starts_with=None, state=None):
        if digital_twin_model_collections and not isinstance(digital_twin_model_collections, list):
            raise TypeError("Expected argument 'digital_twin_model_collections' to be a list")
        pulumi.set(__self__, "digital_twin_model_collections", digital_twin_model_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_id and not isinstance(iot_domain_id, str):
            raise TypeError("Expected argument 'iot_domain_id' to be a str")
        pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if spec_uri_starts_with and not isinstance(spec_uri_starts_with, str):
            raise TypeError("Expected argument 'spec_uri_starts_with' to be a str")
        pulumi.set(__self__, "spec_uri_starts_with", spec_uri_starts_with)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="digitalTwinModelCollections")
    def digital_twin_model_collections(self) -> Sequence['outputs.GetIotDigitalTwinModelsDigitalTwinModelCollectionResult']:
        """
        The list of digital_twin_model_collection.
        """
        return pulumi.get(self, "digital_twin_model_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  If left blank, the display name will be derived from the spec.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIotDigitalTwinModelsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
        """
        return pulumi.get(self, "iot_domain_id")

    @_builtins.property
    @pulumi.getter(name="specUriStartsWith")
    def spec_uri_starts_with(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "spec_uri_starts_with")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the digital twin model.
        """
        return pulumi.get(self, "state")


class AwaitableGetIotDigitalTwinModelsResult(GetIotDigitalTwinModelsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotDigitalTwinModelsResult(
            digital_twin_model_collections=self.digital_twin_model_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            iot_domain_id=self.iot_domain_id,
            spec_uri_starts_with=self.spec_uri_starts_with,
            state=self.state)


def get_iot_digital_twin_models(display_name: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetIotDigitalTwinModelsFilterArgs', 'GetIotDigitalTwinModelsFilterArgsDict']]] = None,
                                id: Optional[_builtins.str] = None,
                                iot_domain_id: Optional[_builtins.str] = None,
                                spec_uri_starts_with: Optional[_builtins.str] = None,
                                state: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotDigitalTwinModelsResult:
    """
    This data source provides the list of Digital Twin Models in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin models within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_models = oci.oci.get_iot_digital_twin_models(iot_domain_id=test_iot_domain["id"],
        display_name=digital_twin_model_display_name,
        id=digital_twin_model_id,
        spec_uri_starts_with=digital_twin_model_spec_uri_starts_with,
        state=digital_twin_model_state)
    ```


    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str spec_uri_starts_with: Filters resources by spec URI prefix. For example, to search all versions of the `dtmi:example:device;1` model, pass the prefix without the version: `dtmi:example:device`.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['specUriStartsWith'] = spec_uri_starts_with
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotDigitalTwinModels:getIotDigitalTwinModels', __args__, opts=opts, typ=GetIotDigitalTwinModelsResult).value

    return AwaitableGetIotDigitalTwinModelsResult(
        digital_twin_model_collections=pulumi.get(__ret__, 'digital_twin_model_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_id=pulumi.get(__ret__, 'iot_domain_id'),
        spec_uri_starts_with=pulumi.get(__ret__, 'spec_uri_starts_with'),
        state=pulumi.get(__ret__, 'state'))
def get_iot_digital_twin_models_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIotDigitalTwinModelsFilterArgs', 'GetIotDigitalTwinModelsFilterArgsDict']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       spec_uri_starts_with: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotDigitalTwinModelsResult]:
    """
    This data source provides the list of Digital Twin Models in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin models within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_models = oci.oci.get_iot_digital_twin_models(iot_domain_id=test_iot_domain["id"],
        display_name=digital_twin_model_display_name,
        id=digital_twin_model_id,
        spec_uri_starts_with=digital_twin_model_spec_uri_starts_with,
        state=digital_twin_model_state)
    ```


    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str spec_uri_starts_with: Filters resources by spec URI prefix. For example, to search all versions of the `dtmi:example:device;1` model, pass the prefix without the version: `dtmi:example:device`.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['specUriStartsWith'] = spec_uri_starts_with
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotDigitalTwinModels:getIotDigitalTwinModels', __args__, opts=opts, typ=GetIotDigitalTwinModelsResult)
    return __ret__.apply(lambda __response__: GetIotDigitalTwinModelsResult(
        digital_twin_model_collections=pulumi.get(__response__, 'digital_twin_model_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_id=pulumi.get(__response__, 'iot_domain_id'),
        spec_uri_starts_with=pulumi.get(__response__, 'spec_uri_starts_with'),
        state=pulumi.get(__response__, 'state')))
