# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIotDigitalTwinRelationshipResult',
    'AwaitableGetIotDigitalTwinRelationshipResult',
    'get_iot_digital_twin_relationship',
    'get_iot_digital_twin_relationship_output',
]

@pulumi.output_type
class GetIotDigitalTwinRelationshipResult:
    """
    A collection of values returned by getIotDigitalTwinRelationship.
    """
    def __init__(__self__, content=None, content_path=None, defined_tags=None, description=None, digital_twin_relationship_id=None, display_name=None, freeform_tags=None, id=None, iot_domain_id=None, source_digital_twin_instance_id=None, state=None, system_tags=None, target_digital_twin_instance_id=None, time_created=None, time_updated=None):
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if content_path and not isinstance(content_path, str):
            raise TypeError("Expected argument 'content_path' to be a str")
        pulumi.set(__self__, "content_path", content_path)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if digital_twin_relationship_id and not isinstance(digital_twin_relationship_id, str):
            raise TypeError("Expected argument 'digital_twin_relationship_id' to be a str")
        pulumi.set(__self__, "digital_twin_relationship_id", digital_twin_relationship_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_id and not isinstance(iot_domain_id, str):
            raise TypeError("Expected argument 'iot_domain_id' to be a str")
        pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if source_digital_twin_instance_id and not isinstance(source_digital_twin_instance_id, str):
            raise TypeError("Expected argument 'source_digital_twin_instance_id' to be a str")
        pulumi.set(__self__, "source_digital_twin_instance_id", source_digital_twin_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_digital_twin_instance_id and not isinstance(target_digital_twin_instance_id, str):
            raise TypeError("Expected argument 'target_digital_twin_instance_id' to be a str")
        pulumi.set(__self__, "target_digital_twin_instance_id", target_digital_twin_instance_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The value(s) of the relationship properties defined in the source digital twin model.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentPath")
    def content_path(self) -> _builtins.str:
        """
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.
        """
        return pulumi.get(self, "content_path")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A short description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="digitalTwinRelationshipId")
    def digital_twin_relationship_id(self) -> _builtins.str:
        return pulumi.get(self, "digital_twin_relationship_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
        """
        return pulumi.get(self, "iot_domain_id")

    @_builtins.property
    @pulumi.getter(name="sourceDigitalTwinInstanceId")
    def source_digital_twin_instance_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source digital twin instance.
        """
        return pulumi.get(self, "source_digital_twin_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the digital twin relationship.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetDigitalTwinInstanceId")
    def target_digital_twin_instance_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target digital twin instance.
        """
        return pulumi.get(self, "target_digital_twin_instance_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetIotDigitalTwinRelationshipResult(GetIotDigitalTwinRelationshipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotDigitalTwinRelationshipResult(
            content=self.content,
            content_path=self.content_path,
            defined_tags=self.defined_tags,
            description=self.description,
            digital_twin_relationship_id=self.digital_twin_relationship_id,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            iot_domain_id=self.iot_domain_id,
            source_digital_twin_instance_id=self.source_digital_twin_instance_id,
            state=self.state,
            system_tags=self.system_tags,
            target_digital_twin_instance_id=self.target_digital_twin_instance_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_iot_digital_twin_relationship(digital_twin_relationship_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotDigitalTwinRelationshipResult:
    """
    This data source provides details about a specific Digital Twin Relationship resource in Oracle Cloud Infrastructure Iot service.

    Retrieves the digital twin relationship identified by the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_relationship = oci.oci.get_iot_digital_twin_relationship(digital_twin_relationship_id=test_digital_twin_relationship_oci_iot_digital_twin_relationship["id"])
    ```


    :param _builtins.str digital_twin_relationship_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of digital twin relationship.
    """
    __args__ = dict()
    __args__['digitalTwinRelationshipId'] = digital_twin_relationship_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotDigitalTwinRelationship:getIotDigitalTwinRelationship', __args__, opts=opts, typ=GetIotDigitalTwinRelationshipResult).value

    return AwaitableGetIotDigitalTwinRelationshipResult(
        content=pulumi.get(__ret__, 'content'),
        content_path=pulumi.get(__ret__, 'content_path'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        digital_twin_relationship_id=pulumi.get(__ret__, 'digital_twin_relationship_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_id=pulumi.get(__ret__, 'iot_domain_id'),
        source_digital_twin_instance_id=pulumi.get(__ret__, 'source_digital_twin_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_digital_twin_instance_id=pulumi.get(__ret__, 'target_digital_twin_instance_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_iot_digital_twin_relationship_output(digital_twin_relationship_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotDigitalTwinRelationshipResult]:
    """
    This data source provides details about a specific Digital Twin Relationship resource in Oracle Cloud Infrastructure Iot service.

    Retrieves the digital twin relationship identified by the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_relationship = oci.oci.get_iot_digital_twin_relationship(digital_twin_relationship_id=test_digital_twin_relationship_oci_iot_digital_twin_relationship["id"])
    ```


    :param _builtins.str digital_twin_relationship_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of digital twin relationship.
    """
    __args__ = dict()
    __args__['digitalTwinRelationshipId'] = digital_twin_relationship_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotDigitalTwinRelationship:getIotDigitalTwinRelationship', __args__, opts=opts, typ=GetIotDigitalTwinRelationshipResult)
    return __ret__.apply(lambda __response__: GetIotDigitalTwinRelationshipResult(
        content=pulumi.get(__response__, 'content'),
        content_path=pulumi.get(__response__, 'content_path'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        digital_twin_relationship_id=pulumi.get(__response__, 'digital_twin_relationship_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_id=pulumi.get(__response__, 'iot_domain_id'),
        source_digital_twin_instance_id=pulumi.get(__response__, 'source_digital_twin_instance_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_digital_twin_instance_id=pulumi.get(__response__, 'target_digital_twin_instance_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
