# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIotDigitalTwinRelationshipsResult',
    'AwaitableGetIotDigitalTwinRelationshipsResult',
    'get_iot_digital_twin_relationships',
    'get_iot_digital_twin_relationships_output',
]

@pulumi.output_type
class GetIotDigitalTwinRelationshipsResult:
    """
    A collection of values returned by getIotDigitalTwinRelationships.
    """
    def __init__(__self__, content_path=None, digital_twin_relationship_collections=None, display_name=None, filters=None, id=None, iot_domain_id=None, source_digital_twin_instance_id=None, state=None, target_digital_twin_instance_id=None):
        if content_path and not isinstance(content_path, str):
            raise TypeError("Expected argument 'content_path' to be a str")
        pulumi.set(__self__, "content_path", content_path)
        if digital_twin_relationship_collections and not isinstance(digital_twin_relationship_collections, list):
            raise TypeError("Expected argument 'digital_twin_relationship_collections' to be a list")
        pulumi.set(__self__, "digital_twin_relationship_collections", digital_twin_relationship_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_id and not isinstance(iot_domain_id, str):
            raise TypeError("Expected argument 'iot_domain_id' to be a str")
        pulumi.set(__self__, "iot_domain_id", iot_domain_id)
        if source_digital_twin_instance_id and not isinstance(source_digital_twin_instance_id, str):
            raise TypeError("Expected argument 'source_digital_twin_instance_id' to be a str")
        pulumi.set(__self__, "source_digital_twin_instance_id", source_digital_twin_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_digital_twin_instance_id and not isinstance(target_digital_twin_instance_id, str):
            raise TypeError("Expected argument 'target_digital_twin_instance_id' to be a str")
        pulumi.set(__self__, "target_digital_twin_instance_id", target_digital_twin_instance_id)

    @_builtins.property
    @pulumi.getter(name="contentPath")
    def content_path(self) -> Optional[_builtins.str]:
        """
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.
        """
        return pulumi.get(self, "content_path")

    @_builtins.property
    @pulumi.getter(name="digitalTwinRelationshipCollections")
    def digital_twin_relationship_collections(self) -> Sequence['outputs.GetIotDigitalTwinRelationshipsDigitalTwinRelationshipCollectionResult']:
        """
        The list of digital_twin_relationship_collection.
        """
        return pulumi.get(self, "digital_twin_relationship_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIotDigitalTwinRelationshipsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainId")
    def iot_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain.
        """
        return pulumi.get(self, "iot_domain_id")

    @_builtins.property
    @pulumi.getter(name="sourceDigitalTwinInstanceId")
    def source_digital_twin_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source digital twin instance.
        """
        return pulumi.get(self, "source_digital_twin_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the digital twin relationship.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetDigitalTwinInstanceId")
    def target_digital_twin_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target digital twin instance.
        """
        return pulumi.get(self, "target_digital_twin_instance_id")


class AwaitableGetIotDigitalTwinRelationshipsResult(GetIotDigitalTwinRelationshipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotDigitalTwinRelationshipsResult(
            content_path=self.content_path,
            digital_twin_relationship_collections=self.digital_twin_relationship_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            iot_domain_id=self.iot_domain_id,
            source_digital_twin_instance_id=self.source_digital_twin_instance_id,
            state=self.state,
            target_digital_twin_instance_id=self.target_digital_twin_instance_id)


def get_iot_digital_twin_relationships(content_path: Optional[_builtins.str] = None,
                                       display_name: Optional[_builtins.str] = None,
                                       filters: Optional[Sequence[Union['GetIotDigitalTwinRelationshipsFilterArgs', 'GetIotDigitalTwinRelationshipsFilterArgsDict']]] = None,
                                       id: Optional[_builtins.str] = None,
                                       iot_domain_id: Optional[_builtins.str] = None,
                                       source_digital_twin_instance_id: Optional[_builtins.str] = None,
                                       state: Optional[_builtins.str] = None,
                                       target_digital_twin_instance_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotDigitalTwinRelationshipsResult:
    """
    This data source provides the list of Digital Twin Relationships in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin relationships within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_relationships = oci.oci.get_iot_digital_twin_relationships(iot_domain_id=test_iot_domain["id"],
        content_path=digital_twin_relationship_content_path,
        display_name=digital_twin_relationship_display_name,
        id=digital_twin_relationship_id,
        source_digital_twin_instance_id=test_digital_twin_instance["id"],
        state=digital_twin_relationship_state,
        target_digital_twin_instance_id=test_digital_twin_instance["id"])
    ```


    :param _builtins.str content_path: Filters resources that match the content path of the digital twin relationship.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str source_digital_twin_instance_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source digital twin instance.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    :param _builtins.str target_digital_twin_instance_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target digital twin instance.
    """
    __args__ = dict()
    __args__['contentPath'] = content_path
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['sourceDigitalTwinInstanceId'] = source_digital_twin_instance_id
    __args__['state'] = state
    __args__['targetDigitalTwinInstanceId'] = target_digital_twin_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotDigitalTwinRelationships:getIotDigitalTwinRelationships', __args__, opts=opts, typ=GetIotDigitalTwinRelationshipsResult).value

    return AwaitableGetIotDigitalTwinRelationshipsResult(
        content_path=pulumi.get(__ret__, 'content_path'),
        digital_twin_relationship_collections=pulumi.get(__ret__, 'digital_twin_relationship_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_id=pulumi.get(__ret__, 'iot_domain_id'),
        source_digital_twin_instance_id=pulumi.get(__ret__, 'source_digital_twin_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        target_digital_twin_instance_id=pulumi.get(__ret__, 'target_digital_twin_instance_id'))
def get_iot_digital_twin_relationships_output(content_path: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIotDigitalTwinRelationshipsFilterArgs', 'GetIotDigitalTwinRelationshipsFilterArgsDict']]]]] = None,
                                              id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              iot_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              source_digital_twin_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              target_digital_twin_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotDigitalTwinRelationshipsResult]:
    """
    This data source provides the list of Digital Twin Relationships in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of digital twin relationships within the specified IoT domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_digital_twin_relationships = oci.oci.get_iot_digital_twin_relationships(iot_domain_id=test_iot_domain["id"],
        content_path=digital_twin_relationship_content_path,
        display_name=digital_twin_relationship_display_name,
        id=digital_twin_relationship_id,
        source_digital_twin_instance_id=test_digital_twin_instance["id"],
        state=digital_twin_relationship_state,
        target_digital_twin_instance_id=test_digital_twin_instance["id"])
    ```


    :param _builtins.str content_path: Filters resources that match the content path of the digital twin relationship.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str iot_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IoT domain in which to list digital twin resources.
    :param _builtins.str source_digital_twin_instance_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source digital twin instance.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    :param _builtins.str target_digital_twin_instance_id: Filter resources that match the specified [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target digital twin instance.
    """
    __args__ = dict()
    __args__['contentPath'] = content_path
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['iotDomainId'] = iot_domain_id
    __args__['sourceDigitalTwinInstanceId'] = source_digital_twin_instance_id
    __args__['state'] = state
    __args__['targetDigitalTwinInstanceId'] = target_digital_twin_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotDigitalTwinRelationships:getIotDigitalTwinRelationships', __args__, opts=opts, typ=GetIotDigitalTwinRelationshipsResult)
    return __ret__.apply(lambda __response__: GetIotDigitalTwinRelationshipsResult(
        content_path=pulumi.get(__response__, 'content_path'),
        digital_twin_relationship_collections=pulumi.get(__response__, 'digital_twin_relationship_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_id=pulumi.get(__response__, 'iot_domain_id'),
        source_digital_twin_instance_id=pulumi.get(__response__, 'source_digital_twin_instance_id'),
        state=pulumi.get(__response__, 'state'),
        target_digital_twin_instance_id=pulumi.get(__response__, 'target_digital_twin_instance_id')))
