# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIotIotDomainGroupResult',
    'AwaitableGetIotIotDomainGroupResult',
    'get_iot_iot_domain_group',
    'get_iot_iot_domain_group_output',
]

@pulumi.output_type
class GetIotIotDomainGroupResult:
    """
    A collection of values returned by getIotIotDomainGroup.
    """
    def __init__(__self__, compartment_id=None, data_host=None, db_allow_listed_vcn_ids=None, db_connection_string=None, db_token_scope=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, iot_domain_group_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_host and not isinstance(data_host, str):
            raise TypeError("Expected argument 'data_host' to be a str")
        pulumi.set(__self__, "data_host", data_host)
        if db_allow_listed_vcn_ids and not isinstance(db_allow_listed_vcn_ids, list):
            raise TypeError("Expected argument 'db_allow_listed_vcn_ids' to be a list")
        pulumi.set(__self__, "db_allow_listed_vcn_ids", db_allow_listed_vcn_ids)
        if db_connection_string and not isinstance(db_connection_string, str):
            raise TypeError("Expected argument 'db_connection_string' to be a str")
        pulumi.set(__self__, "db_connection_string", db_connection_string)
        if db_token_scope and not isinstance(db_token_scope, str):
            raise TypeError("Expected argument 'db_token_scope' to be a str")
        pulumi.set(__self__, "db_token_scope", db_token_scope)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_group_id and not isinstance(iot_domain_group_id, str):
            raise TypeError("Expected argument 'iot_domain_group_id' to be a str")
        pulumi.set(__self__, "iot_domain_group_id", iot_domain_group_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment corresponding to the resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dataHost")
    def data_host(self) -> _builtins.str:
        """
        The host name of the database corresponding to the IoT Domain group.
        """
        return pulumi.get(self, "data_host")

    @_builtins.property
    @pulumi.getter(name="dbAllowListedVcnIds")
    def db_allow_listed_vcn_ids(self) -> Sequence[_builtins.str]:
        """
        This is an array of VCN OCID (virtual cloud network Oracle Cloud ID) that is allowed to connect the data host.
        """
        return pulumi.get(self, "db_allow_listed_vcn_ids")

    @_builtins.property
    @pulumi.getter(name="dbConnectionString")
    def db_connection_string(self) -> _builtins.str:
        """
        The connection string used to connect to the data host associated with the IoT domain group.
        """
        return pulumi.get(self, "db_connection_string")

    @_builtins.property
    @pulumi.getter(name="dbTokenScope")
    def db_token_scope(self) -> _builtins.str:
        """
        The token scope used to connect to the data host associated with the IoT domain group.
        """
        return pulumi.get(self, "db_token_scope")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A short description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainGroupId")
    def iot_domain_group_id(self) -> _builtins.str:
        return pulumi.get(self, "iot_domain_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of an IoT Domain Group.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time when the resource was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time when the resource was last updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetIotIotDomainGroupResult(GetIotIotDomainGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotIotDomainGroupResult(
            compartment_id=self.compartment_id,
            data_host=self.data_host,
            db_allow_listed_vcn_ids=self.db_allow_listed_vcn_ids,
            db_connection_string=self.db_connection_string,
            db_token_scope=self.db_token_scope,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            iot_domain_group_id=self.iot_domain_group_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_iot_iot_domain_group(iot_domain_group_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotIotDomainGroupResult:
    """
    This data source provides details about a specific Iot Domain Group resource in Oracle Cloud Infrastructure Iot service.

    Retrieves the IoT domain group identified by the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iot_domain_group = oci.oci.get_iot_iot_domain_group(iot_domain_group_id=test_iot_domain_group_oci_iot_iot_domain_group["id"])
    ```


    :param _builtins.str iot_domain_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an IoT Domain Group.
    """
    __args__ = dict()
    __args__['iotDomainGroupId'] = iot_domain_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotIotDomainGroup:getIotIotDomainGroup', __args__, opts=opts, typ=GetIotIotDomainGroupResult).value

    return AwaitableGetIotIotDomainGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_host=pulumi.get(__ret__, 'data_host'),
        db_allow_listed_vcn_ids=pulumi.get(__ret__, 'db_allow_listed_vcn_ids'),
        db_connection_string=pulumi.get(__ret__, 'db_connection_string'),
        db_token_scope=pulumi.get(__ret__, 'db_token_scope'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_group_id=pulumi.get(__ret__, 'iot_domain_group_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_iot_iot_domain_group_output(iot_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotIotDomainGroupResult]:
    """
    This data source provides details about a specific Iot Domain Group resource in Oracle Cloud Infrastructure Iot service.

    Retrieves the IoT domain group identified by the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iot_domain_group = oci.oci.get_iot_iot_domain_group(iot_domain_group_id=test_iot_domain_group_oci_iot_iot_domain_group["id"])
    ```


    :param _builtins.str iot_domain_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an IoT Domain Group.
    """
    __args__ = dict()
    __args__['iotDomainGroupId'] = iot_domain_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotIotDomainGroup:getIotIotDomainGroup', __args__, opts=opts, typ=GetIotIotDomainGroupResult)
    return __ret__.apply(lambda __response__: GetIotIotDomainGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_host=pulumi.get(__response__, 'data_host'),
        db_allow_listed_vcn_ids=pulumi.get(__response__, 'db_allow_listed_vcn_ids'),
        db_connection_string=pulumi.get(__response__, 'db_connection_string'),
        db_token_scope=pulumi.get(__response__, 'db_token_scope'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_group_id=pulumi.get(__response__, 'iot_domain_group_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
