# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIotIotDomainGroupsResult',
    'AwaitableGetIotIotDomainGroupsResult',
    'get_iot_iot_domain_groups',
    'get_iot_iot_domain_groups_output',
]

@pulumi.output_type
class GetIotIotDomainGroupsResult:
    """
    A collection of values returned by getIotIotDomainGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, iot_domain_group_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iot_domain_group_collections and not isinstance(iot_domain_group_collections, list):
            raise TypeError("Expected argument 'iot_domain_group_collections' to be a list")
        pulumi.set(__self__, "iot_domain_group_collections", iot_domain_group_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment corresponding to the resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIotIotDomainGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iotDomainGroupCollections")
    def iot_domain_group_collections(self) -> Sequence['outputs.GetIotIotDomainGroupsIotDomainGroupCollectionResult']:
        """
        The list of iot_domain_group_collection.
        """
        return pulumi.get(self, "iot_domain_group_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of an IoT Domain Group.
        """
        return pulumi.get(self, "state")


class AwaitableGetIotIotDomainGroupsResult(GetIotIotDomainGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIotIotDomainGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            iot_domain_group_collections=self.iot_domain_group_collections,
            state=self.state)


def get_iot_iot_domain_groups(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetIotIotDomainGroupsFilterArgs', 'GetIotIotDomainGroupsFilterArgsDict']]] = None,
                              id: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIotIotDomainGroupsResult:
    """
    This data source provides the list of Iot Domain Groups in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of IoT domain groups within the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iot_domain_groups = oci.oci.get_iot_iot_domain_groups(compartment_id=compartment_id,
        display_name=iot_domain_group_display_name,
        id=iot_domain_group_id,
        state=iot_domain_group_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getIotIotDomainGroups:getIotIotDomainGroups', __args__, opts=opts, typ=GetIotIotDomainGroupsResult).value

    return AwaitableGetIotIotDomainGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        iot_domain_group_collections=pulumi.get(__ret__, 'iot_domain_group_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_iot_iot_domain_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIotIotDomainGroupsFilterArgs', 'GetIotIotDomainGroupsFilterArgsDict']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIotIotDomainGroupsResult]:
    """
    This data source provides the list of Iot Domain Groups in Oracle Cloud Infrastructure Iot service.

    Retrieves a list of IoT domain groups within the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iot_domain_groups = oci.oci.get_iot_iot_domain_groups(compartment_id=compartment_id,
        display_name=iot_domain_group_display_name,
        id=iot_domain_group_id,
        state=iot_domain_group_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: Filter resources whose display name matches the specified value.
    :param _builtins.str id: Filter resources by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be a valid OCID of the resource type.
    :param _builtins.str state: Filter resources whose lifecycleState matches the specified value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getIotIotDomainGroups:getIotIotDomainGroups', __args__, opts=opts, typ=GetIotIotDomainGroupsResult)
    return __ret__.apply(lambda __response__: GetIotIotDomainGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        iot_domain_group_collections=pulumi.get(__response__, 'iot_domain_group_collections'),
        state=pulumi.get(__response__, 'state')))
