# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMulticloudNetworkAnchorResult',
    'AwaitableGetMulticloudNetworkAnchorResult',
    'get_multicloud_network_anchor',
    'get_multicloud_network_anchor_output',
]

@pulumi.output_type
class GetMulticloudNetworkAnchorResult:
    """
    A collection of values returned by getMulticloudNetworkAnchor.
    """
    def __init__(__self__, cloud_service_provider_metadata_items=None, cluster_placement_group_id=None, compartment_id=None, defined_tags=None, display_name=None, external_location=None, freeform_tags=None, id=None, lifecycle_details=None, network_anchor_id=None, network_anchor_lifecycle_state=None, oci_metadata_items=None, resource_anchor_id=None, setup_mode=None, subscription_id=None, subscription_service_name=None, system_tags=None, time_created=None, time_updated=None):
        if cloud_service_provider_metadata_items and not isinstance(cloud_service_provider_metadata_items, list):
            raise TypeError("Expected argument 'cloud_service_provider_metadata_items' to be a list")
        pulumi.set(__self__, "cloud_service_provider_metadata_items", cloud_service_provider_metadata_items)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_location and not isinstance(external_location, str):
            raise TypeError("Expected argument 'external_location' to be a str")
        pulumi.set(__self__, "external_location", external_location)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if network_anchor_id and not isinstance(network_anchor_id, str):
            raise TypeError("Expected argument 'network_anchor_id' to be a str")
        pulumi.set(__self__, "network_anchor_id", network_anchor_id)
        if network_anchor_lifecycle_state and not isinstance(network_anchor_lifecycle_state, str):
            raise TypeError("Expected argument 'network_anchor_lifecycle_state' to be a str")
        pulumi.set(__self__, "network_anchor_lifecycle_state", network_anchor_lifecycle_state)
        if oci_metadata_items and not isinstance(oci_metadata_items, list):
            raise TypeError("Expected argument 'oci_metadata_items' to be a list")
        pulumi.set(__self__, "oci_metadata_items", oci_metadata_items)
        if resource_anchor_id and not isinstance(resource_anchor_id, str):
            raise TypeError("Expected argument 'resource_anchor_id' to be a str")
        pulumi.set(__self__, "resource_anchor_id", resource_anchor_id)
        if setup_mode and not isinstance(setup_mode, str):
            raise TypeError("Expected argument 'setup_mode' to be a str")
        pulumi.set(__self__, "setup_mode", setup_mode)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_service_name and not isinstance(subscription_service_name, str):
            raise TypeError("Expected argument 'subscription_service_name' to be a str")
        pulumi.set(__self__, "subscription_service_name", subscription_service_name)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="cloudServiceProviderMetadataItems")
    def cloud_service_provider_metadata_items(self) -> Sequence['outputs.GetMulticloudNetworkAnchorCloudServiceProviderMetadataItemResult']:
        """
        Cloud Service Provider metadata item. Warning - In future this object can change to generic object with future Cloud Service Provider based on  CloudServiceProvider field. This can be one of CSP provider type Azure, GCP and AWS
        """
        return pulumi.get(self, "cloud_service_provider_metadata_items")

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> _builtins.str:
        """
        The CPG ID in which Network Anchor will be created.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalLocation")
    def external_location(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "external_location")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the NetworkAnchor in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="networkAnchorId")
    def network_anchor_id(self) -> _builtins.str:
        return pulumi.get(self, "network_anchor_id")

    @_builtins.property
    @pulumi.getter(name="networkAnchorLifecycleState")
    def network_anchor_lifecycle_state(self) -> _builtins.str:
        """
        The current state of the NetworkAnchor.
        """
        return pulumi.get(self, "network_anchor_lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="ociMetadataItems")
    def oci_metadata_items(self) -> Sequence['outputs.GetMulticloudNetworkAnchorOciMetadataItemResult']:
        """
        Oracle Cloud Infrastructure network anchor related meta data items
        """
        return pulumi.get(self, "oci_metadata_items")

    @_builtins.property
    @pulumi.getter(name="resourceAnchorId")
    def resource_anchor_id(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure resource anchor Id (OCID).
        """
        return pulumi.get(self, "resource_anchor_id")

    @_builtins.property
    @pulumi.getter(name="setupMode")
    def setup_mode(self) -> _builtins.str:
        """
        AUTO_BIND - when passed compartment will be created on-behalf of customer and bind to this resource anchor NO_AUTO_BIND - compartment will not be created and later customer can bind existing compartment.  to this resource anchor. This is for future use only
        """
        return pulumi.get(self, "setup_mode")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionServiceName")
    def subscription_service_name(self) -> _builtins.str:
        return pulumi.get(self, "subscription_service_name")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the NetworkAnchor was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the NetworkAnchor was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMulticloudNetworkAnchorResult(GetMulticloudNetworkAnchorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMulticloudNetworkAnchorResult(
            cloud_service_provider_metadata_items=self.cloud_service_provider_metadata_items,
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            external_location=self.external_location,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            network_anchor_id=self.network_anchor_id,
            network_anchor_lifecycle_state=self.network_anchor_lifecycle_state,
            oci_metadata_items=self.oci_metadata_items,
            resource_anchor_id=self.resource_anchor_id,
            setup_mode=self.setup_mode,
            subscription_id=self.subscription_id,
            subscription_service_name=self.subscription_service_name,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_multicloud_network_anchor(external_location: Optional[_builtins.str] = None,
                                  network_anchor_id: Optional[_builtins.str] = None,
                                  subscription_id: Optional[_builtins.str] = None,
                                  subscription_service_name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMulticloudNetworkAnchorResult:
    """
    This data source provides details about a specific Network Anchor resource in Oracle Cloud Infrastructure Multicloud service.

    Gets information about a NetworkAnchor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_anchor = oci.oci.get_multicloud_network_anchor(network_anchor_id=network_anchor_id,
        subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        external_location=network_anchor_external_location)
    ```


    :param _builtins.str external_location: OMHub Control Plane must know underlying CSP CP Region External Location Name.
    :param _builtins.str network_anchor_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['externalLocation'] = external_location
    __args__['networkAnchorId'] = network_anchor_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getMulticloudNetworkAnchor:getMulticloudNetworkAnchor', __args__, opts=opts, typ=GetMulticloudNetworkAnchorResult).value

    return AwaitableGetMulticloudNetworkAnchorResult(
        cloud_service_provider_metadata_items=pulumi.get(__ret__, 'cloud_service_provider_metadata_items'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_location=pulumi.get(__ret__, 'external_location'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        network_anchor_id=pulumi.get(__ret__, 'network_anchor_id'),
        network_anchor_lifecycle_state=pulumi.get(__ret__, 'network_anchor_lifecycle_state'),
        oci_metadata_items=pulumi.get(__ret__, 'oci_metadata_items'),
        resource_anchor_id=pulumi.get(__ret__, 'resource_anchor_id'),
        setup_mode=pulumi.get(__ret__, 'setup_mode'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_service_name=pulumi.get(__ret__, 'subscription_service_name'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_multicloud_network_anchor_output(external_location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         network_anchor_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         subscription_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMulticloudNetworkAnchorResult]:
    """
    This data source provides details about a specific Network Anchor resource in Oracle Cloud Infrastructure Multicloud service.

    Gets information about a NetworkAnchor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_anchor = oci.oci.get_multicloud_network_anchor(network_anchor_id=network_anchor_id,
        subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        external_location=network_anchor_external_location)
    ```


    :param _builtins.str external_location: OMHub Control Plane must know underlying CSP CP Region External Location Name.
    :param _builtins.str network_anchor_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['externalLocation'] = external_location
    __args__['networkAnchorId'] = network_anchor_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getMulticloudNetworkAnchor:getMulticloudNetworkAnchor', __args__, opts=opts, typ=GetMulticloudNetworkAnchorResult)
    return __ret__.apply(lambda __response__: GetMulticloudNetworkAnchorResult(
        cloud_service_provider_metadata_items=pulumi.get(__response__, 'cloud_service_provider_metadata_items'),
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_location=pulumi.get(__response__, 'external_location'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        network_anchor_id=pulumi.get(__response__, 'network_anchor_id'),
        network_anchor_lifecycle_state=pulumi.get(__response__, 'network_anchor_lifecycle_state'),
        oci_metadata_items=pulumi.get(__response__, 'oci_metadata_items'),
        resource_anchor_id=pulumi.get(__response__, 'resource_anchor_id'),
        setup_mode=pulumi.get(__response__, 'setup_mode'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_service_name=pulumi.get(__response__, 'subscription_service_name'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
