# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMulticloudNetworkAnchorsResult',
    'AwaitableGetMulticloudNetworkAnchorsResult',
    'get_multicloud_network_anchors',
    'get_multicloud_network_anchors_output',
]

@pulumi.output_type
class GetMulticloudNetworkAnchorsResult:
    """
    A collection of values returned by getMulticloudNetworkAnchors.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_location=None, id=None, limit=None, network_anchor_collections=None, network_anchor_lifecycle_state=None, network_anchor_oci_subnet_id=None, network_anchor_oci_vcn_id=None, subscription_id=None, subscription_service_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_location and not isinstance(external_location, str):
            raise TypeError("Expected argument 'external_location' to be a str")
        pulumi.set(__self__, "external_location", external_location)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if network_anchor_collections and not isinstance(network_anchor_collections, list):
            raise TypeError("Expected argument 'network_anchor_collections' to be a list")
        pulumi.set(__self__, "network_anchor_collections", network_anchor_collections)
        if network_anchor_lifecycle_state and not isinstance(network_anchor_lifecycle_state, str):
            raise TypeError("Expected argument 'network_anchor_lifecycle_state' to be a str")
        pulumi.set(__self__, "network_anchor_lifecycle_state", network_anchor_lifecycle_state)
        if network_anchor_oci_subnet_id and not isinstance(network_anchor_oci_subnet_id, str):
            raise TypeError("Expected argument 'network_anchor_oci_subnet_id' to be a str")
        pulumi.set(__self__, "network_anchor_oci_subnet_id", network_anchor_oci_subnet_id)
        if network_anchor_oci_vcn_id and not isinstance(network_anchor_oci_vcn_id, str):
            raise TypeError("Expected argument 'network_anchor_oci_vcn_id' to be a str")
        pulumi.set(__self__, "network_anchor_oci_vcn_id", network_anchor_oci_vcn_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_service_name and not isinstance(subscription_service_name, str):
            raise TypeError("Expected argument 'subscription_service_name' to be a str")
        pulumi.set(__self__, "subscription_service_name", subscription_service_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalLocation")
    def external_location(self) -> _builtins.str:
        return pulumi.get(self, "external_location")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="networkAnchorCollections")
    def network_anchor_collections(self) -> Sequence['outputs.GetMulticloudNetworkAnchorsNetworkAnchorCollectionResult']:
        """
        The list of NetworkAnchor.
        """
        return pulumi.get(self, "network_anchor_collections")

    @_builtins.property
    @pulumi.getter(name="networkAnchorLifecycleState")
    def network_anchor_lifecycle_state(self) -> Optional[_builtins.str]:
        """
        The current state of the NetworkAnchor.
        """
        return pulumi.get(self, "network_anchor_lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="networkAnchorOciSubnetId")
    def network_anchor_oci_subnet_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "network_anchor_oci_subnet_id")

    @_builtins.property
    @pulumi.getter(name="networkAnchorOciVcnId")
    def network_anchor_oci_vcn_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "network_anchor_oci_vcn_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionServiceName")
    def subscription_service_name(self) -> _builtins.str:
        return pulumi.get(self, "subscription_service_name")


class AwaitableGetMulticloudNetworkAnchorsResult(GetMulticloudNetworkAnchorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMulticloudNetworkAnchorsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_location=self.external_location,
            id=self.id,
            limit=self.limit,
            network_anchor_collections=self.network_anchor_collections,
            network_anchor_lifecycle_state=self.network_anchor_lifecycle_state,
            network_anchor_oci_subnet_id=self.network_anchor_oci_subnet_id,
            network_anchor_oci_vcn_id=self.network_anchor_oci_vcn_id,
            subscription_id=self.subscription_id,
            subscription_service_name=self.subscription_service_name)


def get_multicloud_network_anchors(compartment_id: Optional[_builtins.str] = None,
                                   display_name: Optional[_builtins.str] = None,
                                   external_location: Optional[_builtins.str] = None,
                                   id: Optional[_builtins.str] = None,
                                   limit: Optional[_builtins.int] = None,
                                   network_anchor_lifecycle_state: Optional[_builtins.str] = None,
                                   network_anchor_oci_subnet_id: Optional[_builtins.str] = None,
                                   network_anchor_oci_vcn_id: Optional[_builtins.str] = None,
                                   subscription_id: Optional[_builtins.str] = None,
                                   subscription_service_name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMulticloudNetworkAnchorsResult:
    """
    This data source provides the list of Network Anchors in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of NetworkAnchors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_anchors = oci.oci.get_multicloud_network_anchors(external_location=external_location,
        subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        compartment_id=compartment_id,
        network_anchor_lifecycle_state=network_anchor_lifecycle_state,
        display_name=display_name,
        network_anchor_oci_subnet_id=network_anchor_oci_subnet_id,
        network_anchor_oci_vcn_id=network_anchor_oci_vcn_id,
        id=id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str external_location: OMHub Control Plane must know underlying CSP CP Region External Location Name.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
           
           Note: one of the arguments `compartment_id` or `id` must be specified.
    :param _builtins.str network_anchor_lifecycle_state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str network_anchor_oci_subnet_id: A filter to return only NetworkAnchor resources that match the given Oracle Cloud Infrastructure subnet Id.
    :param _builtins.str network_anchor_oci_vcn_id: A filter to return only NetworkAnchor resources that match the given Oracle Cloud Infrastructure Vcn Id.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalLocation'] = external_location
    __args__['id'] = id
    __args__['limit'] = limit
    __args__['networkAnchorLifecycleState'] = network_anchor_lifecycle_state
    __args__['networkAnchorOciSubnetId'] = network_anchor_oci_subnet_id
    __args__['networkAnchorOciVcnId'] = network_anchor_oci_vcn_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getMulticloudNetworkAnchors:getMulticloudNetworkAnchors', __args__, opts=opts, typ=GetMulticloudNetworkAnchorsResult).value

    return AwaitableGetMulticloudNetworkAnchorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_location=pulumi.get(__ret__, 'external_location'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        network_anchor_collections=pulumi.get(__ret__, 'network_anchor_collections'),
        network_anchor_lifecycle_state=pulumi.get(__ret__, 'network_anchor_lifecycle_state'),
        network_anchor_oci_subnet_id=pulumi.get(__ret__, 'network_anchor_oci_subnet_id'),
        network_anchor_oci_vcn_id=pulumi.get(__ret__, 'network_anchor_oci_vcn_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_service_name=pulumi.get(__ret__, 'subscription_service_name'))
def get_multicloud_network_anchors_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          external_location: Optional[pulumi.Input[_builtins.str]] = None,
                                          id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                          network_anchor_lifecycle_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          network_anchor_oci_subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          network_anchor_oci_vcn_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          subscription_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMulticloudNetworkAnchorsResult]:
    """
    This data source provides the list of Network Anchors in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of NetworkAnchors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_anchors = oci.oci.get_multicloud_network_anchors(external_location=external_location,
        subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        compartment_id=compartment_id,
        network_anchor_lifecycle_state=network_anchor_lifecycle_state,
        display_name=display_name,
        network_anchor_oci_subnet_id=network_anchor_oci_subnet_id,
        network_anchor_oci_vcn_id=network_anchor_oci_vcn_id,
        id=id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str external_location: OMHub Control Plane must know underlying CSP CP Region External Location Name.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the NetworkAnchor.
           
           Note: one of the arguments `compartment_id` or `id` must be specified.
    :param _builtins.str network_anchor_lifecycle_state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str network_anchor_oci_subnet_id: A filter to return only NetworkAnchor resources that match the given Oracle Cloud Infrastructure subnet Id.
    :param _builtins.str network_anchor_oci_vcn_id: A filter to return only NetworkAnchor resources that match the given Oracle Cloud Infrastructure Vcn Id.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalLocation'] = external_location
    __args__['id'] = id
    __args__['limit'] = limit
    __args__['networkAnchorLifecycleState'] = network_anchor_lifecycle_state
    __args__['networkAnchorOciSubnetId'] = network_anchor_oci_subnet_id
    __args__['networkAnchorOciVcnId'] = network_anchor_oci_vcn_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getMulticloudNetworkAnchors:getMulticloudNetworkAnchors', __args__, opts=opts, typ=GetMulticloudNetworkAnchorsResult)
    return __ret__.apply(lambda __response__: GetMulticloudNetworkAnchorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_location=pulumi.get(__response__, 'external_location'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        network_anchor_collections=pulumi.get(__response__, 'network_anchor_collections'),
        network_anchor_lifecycle_state=pulumi.get(__response__, 'network_anchor_lifecycle_state'),
        network_anchor_oci_subnet_id=pulumi.get(__response__, 'network_anchor_oci_subnet_id'),
        network_anchor_oci_vcn_id=pulumi.get(__response__, 'network_anchor_oci_vcn_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_service_name=pulumi.get(__response__, 'subscription_service_name')))
