# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMulticloudOmHubMultiCloudMetadataResult',
    'AwaitableGetMulticloudOmHubMultiCloudMetadataResult',
    'get_multicloud_om_hub_multi_cloud_metadata',
    'get_multicloud_om_hub_multi_cloud_metadata_output',
]

@pulumi.output_type
class GetMulticloudOmHubMultiCloudMetadataResult:
    """
    A collection of values returned by getMulticloudOmHubMultiCloudMetadata.
    """
    def __init__(__self__, base_compartment_id=None, base_subscription_id=None, compartment_id=None, defined_tags=None, freeform_tags=None, id=None, subscription_id=None, system_tags=None, time_created=None):
        if base_compartment_id and not isinstance(base_compartment_id, str):
            raise TypeError("Expected argument 'base_compartment_id' to be a str")
        pulumi.set(__self__, "base_compartment_id", base_compartment_id)
        if base_subscription_id and not isinstance(base_subscription_id, str):
            raise TypeError("Expected argument 'base_subscription_id' to be a str")
        pulumi.set(__self__, "base_subscription_id", base_subscription_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="baseCompartmentId")
    def base_compartment_id(self) -> _builtins.str:
        """
        MultiCloud base compartment OCID associated with subscriptionId.
        """
        return pulumi.get(self, "base_compartment_id")

    @_builtins.property
    @pulumi.getter(name="baseSubscriptionId")
    def base_subscription_id(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure subscriptionId.
        """
        return pulumi.get(self, "base_subscription_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the multicloud compartment was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetMulticloudOmHubMultiCloudMetadataResult(GetMulticloudOmHubMultiCloudMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMulticloudOmHubMultiCloudMetadataResult(
            base_compartment_id=self.base_compartment_id,
            base_subscription_id=self.base_subscription_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            subscription_id=self.subscription_id,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_multicloud_om_hub_multi_cloud_metadata(compartment_id: Optional[_builtins.str] = None,
                                               subscription_id: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMulticloudOmHubMultiCloudMetadataResult:
    """
    This data source provides details about a specific OmHub MultiCloud base compartment in Oracle Cloud Infrastructure Multicloud service.

    Gets information about multicloud base compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_om_hub_multi_cloud_metadata = oci.oci.get_multicloud_om_hub_multi_cloud_metadata(compartment_id=compartment_id,
        subscription_id=subscription_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure subscription.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getMulticloudOmHubMultiCloudMetadata:getMulticloudOmHubMultiCloudMetadata', __args__, opts=opts, typ=GetMulticloudOmHubMultiCloudMetadataResult).value

    return AwaitableGetMulticloudOmHubMultiCloudMetadataResult(
        base_compartment_id=pulumi.get(__ret__, 'base_compartment_id'),
        base_subscription_id=pulumi.get(__ret__, 'base_subscription_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_multicloud_om_hub_multi_cloud_metadata_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMulticloudOmHubMultiCloudMetadataResult]:
    """
    This data source provides details about a specific OmHub MultiCloud base compartment in Oracle Cloud Infrastructure Multicloud service.

    Gets information about multicloud base compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_om_hub_multi_cloud_metadata = oci.oci.get_multicloud_om_hub_multi_cloud_metadata(compartment_id=compartment_id,
        subscription_id=subscription_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure subscription.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getMulticloudOmHubMultiCloudMetadata:getMulticloudOmHubMultiCloudMetadata', __args__, opts=opts, typ=GetMulticloudOmHubMultiCloudMetadataResult)
    return __ret__.apply(lambda __response__: GetMulticloudOmHubMultiCloudMetadataResult(
        base_compartment_id=pulumi.get(__response__, 'base_compartment_id'),
        base_subscription_id=pulumi.get(__response__, 'base_subscription_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
