# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMulticloudOmHubMultiCloudsMetadataResult',
    'AwaitableGetMulticloudOmHubMultiCloudsMetadataResult',
    'get_multicloud_om_hub_multi_clouds_metadata',
    'get_multicloud_om_hub_multi_clouds_metadata_output',
]

@pulumi.output_type
class GetMulticloudOmHubMultiCloudsMetadataResult:
    """
    A collection of values returned by getMulticloudOmHubMultiCloudsMetadata.
    """
    def __init__(__self__, compartment_id=None, id=None, limit=None, multi_cloud_metadata_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if multi_cloud_metadata_collections and not isinstance(multi_cloud_metadata_collections, list):
            raise TypeError("Expected argument 'multi_cloud_metadata_collections' to be a list")
        pulumi.set(__self__, "multi_cloud_metadata_collections", multi_cloud_metadata_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        MultiCloud base compartment OCID associated with subscriptionId.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="multiCloudMetadataCollections")
    def multi_cloud_metadata_collections(self) -> Sequence['outputs.GetMulticloudOmHubMultiCloudsMetadataMultiCloudMetadataCollectionResult']:
        """
        The list of MultiCloudMetadataCollection.
        """
        return pulumi.get(self, "multi_cloud_metadata_collections")


class AwaitableGetMulticloudOmHubMultiCloudsMetadataResult(GetMulticloudOmHubMultiCloudsMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMulticloudOmHubMultiCloudsMetadataResult(
            compartment_id=self.compartment_id,
            id=self.id,
            limit=self.limit,
            multi_cloud_metadata_collections=self.multi_cloud_metadata_collections)


def get_multicloud_om_hub_multi_clouds_metadata(compartment_id: Optional[_builtins.str] = None,
                                                limit: Optional[_builtins.int] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMulticloudOmHubMultiCloudsMetadataResult:
    """
    This data source provides the list of compartments under a root compartment in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of multicloud metadata with multicloud base compartment and subscription across Cloud Service Providers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_om_hub_multi_clouds_metadata = oci.oci.get_multicloud_om_hub_multi_clouds_metadata(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the root compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['limit'] = limit
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getMulticloudOmHubMultiCloudsMetadata:getMulticloudOmHubMultiCloudsMetadata', __args__, opts=opts, typ=GetMulticloudOmHubMultiCloudsMetadataResult).value

    return AwaitableGetMulticloudOmHubMultiCloudsMetadataResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        multi_cloud_metadata_collections=pulumi.get(__ret__, 'multi_cloud_metadata_collections'))
def get_multicloud_om_hub_multi_clouds_metadata_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                       limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMulticloudOmHubMultiCloudsMetadataResult]:
    """
    This data source provides the list of compartments under a root compartment in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of multicloud metadata with multicloud base compartment and subscription across Cloud Service Providers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_om_hub_multi_clouds_metadata = oci.oci.get_multicloud_om_hub_multi_clouds_metadata(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the root compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['limit'] = limit
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getMulticloudOmHubMultiCloudsMetadata:getMulticloudOmHubMultiCloudsMetadata', __args__, opts=opts, typ=GetMulticloudOmHubMultiCloudsMetadataResult)
    return __ret__.apply(lambda __response__: GetMulticloudOmHubMultiCloudsMetadataResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        multi_cloud_metadata_collections=pulumi.get(__response__, 'multi_cloud_metadata_collections')))
