# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMulticloudResourceAnchorsResult',
    'AwaitableGetMulticloudResourceAnchorsResult',
    'get_multicloud_resource_anchors',
    'get_multicloud_resource_anchors_output',
]

@pulumi.output_type
class GetMulticloudResourceAnchorsResult:
    """
    A collection of values returned by getMulticloudResourceAnchors.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, is_compartment_id_in_subtree=None, lifecycle_state=None, limit=None, linked_compartment_id=None, resource_anchor_collections=None, subscription_id=None, subscription_service_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if lifecycle_state and not isinstance(lifecycle_state, str):
            raise TypeError("Expected argument 'lifecycle_state' to be a str")
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if linked_compartment_id and not isinstance(linked_compartment_id, str):
            raise TypeError("Expected argument 'linked_compartment_id' to be a str")
        pulumi.set(__self__, "linked_compartment_id", linked_compartment_id)
        if resource_anchor_collections and not isinstance(resource_anchor_collections, list):
            raise TypeError("Expected argument 'resource_anchor_collections' to be a list")
        pulumi.set(__self__, "resource_anchor_collections", resource_anchor_collections)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_service_name and not isinstance(subscription_service_name, str):
            raise TypeError("Expected argument 'subscription_service_name' to be a str")
        pulumi.set(__self__, "subscription_service_name", subscription_service_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMulticloudResourceAnchorsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnchor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[_builtins.str]:
        """
        The current state of the ResourceAnchor.
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="linkedCompartmentId")
    def linked_compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "linked_compartment_id")

    @_builtins.property
    @pulumi.getter(name="resourceAnchorCollections")
    def resource_anchor_collections(self) -> Sequence['outputs.GetMulticloudResourceAnchorsResourceAnchorCollectionResult']:
        """
        The list of ResourceAnchorCollection.
        """
        return pulumi.get(self, "resource_anchor_collections")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        Oracle Cloud Infrastructure Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionServiceName")
    def subscription_service_name(self) -> _builtins.str:
        return pulumi.get(self, "subscription_service_name")


class AwaitableGetMulticloudResourceAnchorsResult(GetMulticloudResourceAnchorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMulticloudResourceAnchorsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            lifecycle_state=self.lifecycle_state,
            limit=self.limit,
            linked_compartment_id=self.linked_compartment_id,
            resource_anchor_collections=self.resource_anchor_collections,
            subscription_id=self.subscription_id,
            subscription_service_name=self.subscription_service_name)


def get_multicloud_resource_anchors(compartment_id: Optional[_builtins.str] = None,
                                    display_name: Optional[_builtins.str] = None,
                                    filters: Optional[Sequence[Union['GetMulticloudResourceAnchorsFilterArgs', 'GetMulticloudResourceAnchorsFilterArgsDict']]] = None,
                                    id: Optional[_builtins.str] = None,
                                    is_compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                    lifecycle_state: Optional[_builtins.str] = None,
                                    limit: Optional[_builtins.int] = None,
                                    linked_compartment_id: Optional[_builtins.str] = None,
                                    subscription_id: Optional[_builtins.str] = None,
                                    subscription_service_name: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMulticloudResourceAnchorsResult:
    """
    This data source provides the list of Resource Anchors in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of ResourceAnchors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resource_anchors = oci.oci.get_multicloud_resource_anchors(subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        compartment_id=compartment_id,
        display_name=resource_anchor_display_name,
        id=resource_anchor_id,
        is_compartment_id_in_subtree=resource_anchor_is_compartment_id_in_subtree,
        linked_compartment_id=linked_compartment_id,
        lifecycle_state=resource_anchor_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnchor.
    :param _builtins.bool is_compartment_id_in_subtree: Check the sub-compartments of a given compartmentId
    :param _builtins.str lifecycle_state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str linked_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which linked to Resource.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['lifecycleState'] = lifecycle_state
    __args__['limit'] = limit
    __args__['linkedCompartmentId'] = linked_compartment_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getMulticloudResourceAnchors:getMulticloudResourceAnchors', __args__, opts=opts, typ=GetMulticloudResourceAnchorsResult).value

    return AwaitableGetMulticloudResourceAnchorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        lifecycle_state=pulumi.get(__ret__, 'lifecycle_state'),
        limit=pulumi.get(__ret__, 'limit'),
        linked_compartment_id=pulumi.get(__ret__, 'linked_compartment_id'),
        resource_anchor_collections=pulumi.get(__ret__, 'resource_anchor_collections'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        subscription_service_name=pulumi.get(__ret__, 'subscription_service_name'))
def get_multicloud_resource_anchors_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMulticloudResourceAnchorsFilterArgs', 'GetMulticloudResourceAnchorsFilterArgsDict']]]]] = None,
                                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                           lifecycle_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                           linked_compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           subscription_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMulticloudResourceAnchorsResult]:
    """
    This data source provides the list of Resource Anchors in Oracle Cloud Infrastructure Multicloud service.

    Gets a list of ResourceAnchors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resource_anchors = oci.oci.get_multicloud_resource_anchors(subscription_id=subscription_id,
        subscription_service_name=subscription_service_name,
        compartment_id=compartment_id,
        display_name=resource_anchor_display_name,
        id=resource_anchor_id,
        is_compartment_id_in_subtree=resource_anchor_is_compartment_id_in_subtree,
        linked_compartment_id=linked_compartment_id,
        lifecycle_state=resource_anchor_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnchor.
    :param _builtins.bool is_compartment_id_in_subtree: Check the sub-compartments of a given compartmentId
    :param _builtins.str lifecycle_state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str linked_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which linked to Resource.
    :param _builtins.str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription in which to list resources.
    :param _builtins.str subscription_service_name: The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['lifecycleState'] = lifecycle_state
    __args__['limit'] = limit
    __args__['linkedCompartmentId'] = linked_compartment_id
    __args__['subscriptionId'] = subscription_id
    __args__['subscriptionServiceName'] = subscription_service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getMulticloudResourceAnchors:getMulticloudResourceAnchors', __args__, opts=opts, typ=GetMulticloudResourceAnchorsResult)
    return __ret__.apply(lambda __response__: GetMulticloudResourceAnchorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        lifecycle_state=pulumi.get(__response__, 'lifecycle_state'),
        limit=pulumi.get(__response__, 'limit'),
        linked_compartment_id=pulumi.get(__response__, 'linked_compartment_id'),
        resource_anchor_collections=pulumi.get(__response__, 'resource_anchor_collections'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        subscription_service_name=pulumi.get(__response__, 'subscription_service_name')))
