# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceAnalyticsMonitoredRegionResult',
    'AwaitableGetResourceAnalyticsMonitoredRegionResult',
    'get_resource_analytics_monitored_region',
    'get_resource_analytics_monitored_region_output',
]

@pulumi.output_type
class GetResourceAnalyticsMonitoredRegionResult:
    """
    A collection of values returned by getResourceAnalyticsMonitoredRegion.
    """
    def __init__(__self__, id=None, lifecycle_details=None, monitored_region_id=None, region_id=None, resource_analytics_instance_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if monitored_region_id and not isinstance(monitored_region_id, str):
            raise TypeError("Expected argument 'monitored_region_id' to be a str")
        pulumi.set(__self__, "monitored_region_id", monitored_region_id)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if resource_analytics_instance_id and not isinstance(resource_analytics_instance_id, str):
            raise TypeError("Expected argument 'resource_analytics_instance_id' to be a str")
        pulumi.set(__self__, "resource_analytics_instance_id", resource_analytics_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the MonitoredRegion in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="monitoredRegionId")
    def monitored_region_id(self) -> _builtins.str:
        return pulumi.get(self, "monitored_region_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The [Region Identifier](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) of this MonitoredRegion.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceAnalyticsInstanceId")
    def resource_analytics_instance_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnalyticsInstance associated with this MonitoredRegion.
        """
        return pulumi.get(self, "resource_analytics_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the MonitoredRegion.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the MonitoredRegion was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the MonitoredRegion was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetResourceAnalyticsMonitoredRegionResult(GetResourceAnalyticsMonitoredRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceAnalyticsMonitoredRegionResult(
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            monitored_region_id=self.monitored_region_id,
            region_id=self.region_id,
            resource_analytics_instance_id=self.resource_analytics_instance_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_resource_analytics_monitored_region(monitored_region_id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceAnalyticsMonitoredRegionResult:
    """
    This data source provides details about a specific Monitored Region resource in Oracle Cloud Infrastructure Resource Analytics service.

    Gets information about a MonitoredRegion.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_region = oci.oci.get_resource_analytics_monitored_region(monitored_region_id=test_monitored_region_oci_resource_analytics_monitored_region["id"])
    ```


    :param _builtins.str monitored_region_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
    """
    __args__ = dict()
    __args__['monitoredRegionId'] = monitored_region_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getResourceAnalyticsMonitoredRegion:getResourceAnalyticsMonitoredRegion', __args__, opts=opts, typ=GetResourceAnalyticsMonitoredRegionResult).value

    return AwaitableGetResourceAnalyticsMonitoredRegionResult(
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        monitored_region_id=pulumi.get(__ret__, 'monitored_region_id'),
        region_id=pulumi.get(__ret__, 'region_id'),
        resource_analytics_instance_id=pulumi.get(__ret__, 'resource_analytics_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_resource_analytics_monitored_region_output(monitored_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceAnalyticsMonitoredRegionResult]:
    """
    This data source provides details about a specific Monitored Region resource in Oracle Cloud Infrastructure Resource Analytics service.

    Gets information about a MonitoredRegion.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_region = oci.oci.get_resource_analytics_monitored_region(monitored_region_id=test_monitored_region_oci_resource_analytics_monitored_region["id"])
    ```


    :param _builtins.str monitored_region_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
    """
    __args__ = dict()
    __args__['monitoredRegionId'] = monitored_region_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getResourceAnalyticsMonitoredRegion:getResourceAnalyticsMonitoredRegion', __args__, opts=opts, typ=GetResourceAnalyticsMonitoredRegionResult)
    return __ret__.apply(lambda __response__: GetResourceAnalyticsMonitoredRegionResult(
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        monitored_region_id=pulumi.get(__response__, 'monitored_region_id'),
        region_id=pulumi.get(__response__, 'region_id'),
        resource_analytics_instance_id=pulumi.get(__response__, 'resource_analytics_instance_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
