# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResourceAnalyticsMonitoredRegionsResult',
    'AwaitableGetResourceAnalyticsMonitoredRegionsResult',
    'get_resource_analytics_monitored_regions',
    'get_resource_analytics_monitored_regions_output',
]

@pulumi.output_type
class GetResourceAnalyticsMonitoredRegionsResult:
    """
    A collection of values returned by getResourceAnalyticsMonitoredRegions.
    """
    def __init__(__self__, filters=None, id=None, monitored_region_collections=None, resource_analytics_instance_id=None, state=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitored_region_collections and not isinstance(monitored_region_collections, list):
            raise TypeError("Expected argument 'monitored_region_collections' to be a list")
        pulumi.set(__self__, "monitored_region_collections", monitored_region_collections)
        if resource_analytics_instance_id and not isinstance(resource_analytics_instance_id, str):
            raise TypeError("Expected argument 'resource_analytics_instance_id' to be a str")
        pulumi.set(__self__, "resource_analytics_instance_id", resource_analytics_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResourceAnalyticsMonitoredRegionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="monitoredRegionCollections")
    def monitored_region_collections(self) -> Sequence['outputs.GetResourceAnalyticsMonitoredRegionsMonitoredRegionCollectionResult']:
        """
        The list of monitored_region_collection.
        """
        return pulumi.get(self, "monitored_region_collections")

    @_builtins.property
    @pulumi.getter(name="resourceAnalyticsInstanceId")
    def resource_analytics_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ResourceAnalyticsInstance associated with this MonitoredRegion.
        """
        return pulumi.get(self, "resource_analytics_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the MonitoredRegion.
        """
        return pulumi.get(self, "state")


class AwaitableGetResourceAnalyticsMonitoredRegionsResult(GetResourceAnalyticsMonitoredRegionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceAnalyticsMonitoredRegionsResult(
            filters=self.filters,
            id=self.id,
            monitored_region_collections=self.monitored_region_collections,
            resource_analytics_instance_id=self.resource_analytics_instance_id,
            state=self.state)


def get_resource_analytics_monitored_regions(filters: Optional[Sequence[Union['GetResourceAnalyticsMonitoredRegionsFilterArgs', 'GetResourceAnalyticsMonitoredRegionsFilterArgsDict']]] = None,
                                             id: Optional[_builtins.str] = None,
                                             resource_analytics_instance_id: Optional[_builtins.str] = None,
                                             state: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceAnalyticsMonitoredRegionsResult:
    """
    This data source provides the list of Monitored Regions in Oracle Cloud Infrastructure Resource Analytics service.

    Gets a list of MonitoredRegions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_regions = oci.oci.get_resource_analytics_monitored_regions(id=monitored_region_id,
        resource_analytics_instance_id=test_resource_analytics_instance["id"],
        state=monitored_region_state)
    ```


    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
    :param _builtins.str resource_analytics_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a ResourceAnalyticsInstance.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceAnalyticsInstanceId'] = resource_analytics_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getResourceAnalyticsMonitoredRegions:getResourceAnalyticsMonitoredRegions', __args__, opts=opts, typ=GetResourceAnalyticsMonitoredRegionsResult).value

    return AwaitableGetResourceAnalyticsMonitoredRegionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        monitored_region_collections=pulumi.get(__ret__, 'monitored_region_collections'),
        resource_analytics_instance_id=pulumi.get(__ret__, 'resource_analytics_instance_id'),
        state=pulumi.get(__ret__, 'state'))
def get_resource_analytics_monitored_regions_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResourceAnalyticsMonitoredRegionsFilterArgs', 'GetResourceAnalyticsMonitoredRegionsFilterArgsDict']]]]] = None,
                                                    id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    resource_analytics_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceAnalyticsMonitoredRegionsResult]:
    """
    This data source provides the list of Monitored Regions in Oracle Cloud Infrastructure Resource Analytics service.

    Gets a list of MonitoredRegions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_regions = oci.oci.get_resource_analytics_monitored_regions(id=monitored_region_id,
        resource_analytics_instance_id=test_resource_analytics_instance["id"],
        state=monitored_region_state)
    ```


    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the MonitoredRegion.
    :param _builtins.str resource_analytics_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a ResourceAnalyticsInstance.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceAnalyticsInstanceId'] = resource_analytics_instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getResourceAnalyticsMonitoredRegions:getResourceAnalyticsMonitoredRegions', __args__, opts=opts, typ=GetResourceAnalyticsMonitoredRegionsResult)
    return __ret__.apply(lambda __response__: GetResourceAnalyticsMonitoredRegionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        monitored_region_collections=pulumi.get(__response__, 'monitored_region_collections'),
        resource_analytics_instance_id=pulumi.get(__response__, 'resource_analytics_instance_id'),
        state=pulumi.get(__response__, 'state')))
